# encoding: utf-8
import datetime
from south.db import db
from south.v2 import SchemaMigration
from django.db import models


class Migration(SchemaMigration):

    def forwards(self, orm):

        # Adding model 'SvnReview'
        db.create_table('svnreview_svnreview', (
            ('review_id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('rev', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['svnlog.SvnLog'], db_column='rev')),
            ('reviewer', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['auth.User'])),
            ('review_time', self.gf('django.db.models.fields.DateTimeField')()),
            ('resolution', self.gf('django.db.models.fields.CharField')(max_length=1)),
            ('message', self.gf('django.db.models.fields.TextField')()),
            ('fix_rev', self.gf('django.db.models.fields.related.ForeignKey')(related_name='fix', null=True, db_column='fix_rev', to=orm['svnlog.SvnLog'])),
        ))
        db.send_create_signal('svnreview', ['SvnReview'])

    def backwards(self, orm):

        # Deleting model 'SvnReview'
        db.delete_table('svnreview_svnreview')

    models = {
        'auth.group': {
            'Meta': {'object_name': 'Group'},
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '80'}),
            'permissions': ('django.db.models.fields.related.ManyToManyField', [], {'to': "orm['auth.Permission']", 'symmetrical': 'False', 'blank': 'True'})
        },
        'auth.permission': {
            'Meta': {'ordering': "('content_type__app_label', 'content_type__model', 'codename')", 'unique_together': "(('content_type', 'codename'),)", 'object_name': 'Permission'},
            'codename': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'content_type': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['contenttypes.ContentType']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '50'})
        },
        'auth.user': {
            'Meta': {'object_name': 'User'},
            'date_joined': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now'}),
            'email': ('django.db.models.fields.EmailField', [], {'max_length': '75', 'blank': 'True'}),
            'first_name': ('django.db.models.fields.CharField', [], {'max_length': '30', 'blank': 'True'}),
            'groups': ('django.db.models.fields.related.ManyToManyField', [], {'to': "orm['auth.Group']", 'symmetrical': 'False', 'blank': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'is_active': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'is_staff': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'is_superuser': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'last_login': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now'}),
            'last_name': ('django.db.models.fields.CharField', [], {'max_length': '30', 'blank': 'True'}),
            'password': ('django.db.models.fields.CharField', [], {'max_length': '128'}),
            'user_permissions': ('django.db.models.fields.related.ManyToManyField', [], {'to': "orm['auth.Permission']", 'symmetrical': 'False', 'blank': 'True'}),
            'username': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '30'})
        },
        'contenttypes.contenttype': {
            'Meta': {'ordering': "('name',)", 'unique_together': "(('app_label', 'model'),)", 'object_name': 'ContentType', 'db_table': "'django_content_type'"},
            'app_label': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'model': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '100'})
        },
        'svnlog.svnauthor': {
            'Meta': {'object_name': 'SvnAuthor'},
            'author_id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'login': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '128'})
        },
        'svnlog.svnlog': {
            'Meta': {'object_name': 'SvnLog'},
            'author': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['svnlog.SvnAuthor']"}),
            'hotfix': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'message': ('django.db.models.fields.TextField', [], {'max_length': '16384'}),
            'rev': ('django.db.models.fields.IntegerField', [], {'primary_key': 'True'}),
            'revtime': ('django.db.models.fields.DateTimeField', [], {})
        },
        'svnreview.svnreview': {
            'Meta': {'object_name': 'SvnReview'},
            'fix_rev': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'fix'", 'null': 'True', 'db_column': "'fix_rev'", 'to': "orm['svnlog.SvnLog']"}),
            'message': ('django.db.models.fields.TextField', [], {}),
            'resolution': ('django.db.models.fields.CharField', [], {'max_length': '1'}),
            'rev': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['svnlog.SvnLog']", 'db_column': "'rev'"}),
            'review_id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'review_time': ('django.db.models.fields.DateTimeField', [], {}),
            'reviewer': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['auth.User']"})
        }
    }

    complete_apps = ['svnreview']
