import re

from django import template
from django.template.defaultfilters import stringfilter
from django.utils.safestring import mark_safe
from django.utils.html import escape

register = template.Library()

@register.filter
def svnreview_format_diff(value):
    lines = value.split("\n")
    ret = ''
    for l, i in zip(lines, xrange(0, len(lines)-1)):
        if l.startswith('+++ ') or l.startswith('--- '):
            cl = 'diff-line-header'
        elif l.startswith('+'):
            cl = 'diff-line-added'
        elif l.startswith('-'):
            cl = 'diff-line-deleted'
        elif l.startswith('@@ '):
            cl = 'diff-line-breaks'
        else:
            cl = ''
        l = escape(l)
        l = re.sub("\t", ' ' * 4, l)
        #l = re.sub(' ', '&#8194;', l)
        ret += "<span class='diff-line %s'><pre>%s</pre></span>" % (cl, l)
    return mark_safe(ret)

@register.filter
def svnreview_format_diff_shortstat(value):
    lines = value.split("\n")
    added = 0
    deleted = 0
    for l, i in zip(lines, xrange(0, len(lines)-1)):
        if i < 4:
            pass
        elif l.startswith('+'):
            added += 1
        elif l.startswith('-'):
            deleted += 1
    return mark_safe("+%d lines, -%d lines" % (added, deleted))

