# -*- encoding: utf-8 -*-

from django.http import HttpResponse
import json

from django.conf import settings

from startrek_client import Startrek
from releaser.startrek.tools import startrek_status_key_to_str, get_startrek_robot_token

import sys, re

ISSUES_PER_REQUEST = 200

def issue_status(r):
    issues = r.REQUEST.getlist('issue')
    for_app = r.REQUEST.get('for_app', '').strip()
    chunks = [issues[i:i+ISSUES_PER_REQUEST] for i in xrange(0, len(issues), ISSUES_PER_REQUEST)]
    ret = {'resps': [], 'errors': [], 'data': {}, 'app': for_app}

    startrek = Startrek(token=get_startrek_robot_token(), useragent=settings.STARTREK_CLIENT_USER_AGENT)
    for chunk in chunks:
        try:
            result = startrek.issues.find('Key: ' + ','.join(chunk))
            for issue in result:
                if for_app:
                    affected = for_app in issue['affectedApps']
                    tested   = for_app in issue['testedApps']
                    if not affected:
                        ret['data'][issue.key] = 'not-affected'
                    elif not tested:
                        ret['data'][issue.key] = 'not-tested'
                    elif tested:
                        ret['data'][issue.key] = 'tested'
                    else:
                        ret['data'][issue.key] = 'error'
                else:
                    ret['data'][issue.key] = startrek_status_key_to_str(issue.status.key)
        except Exception, e:
            ret['errors'].append('error: ' + unicode(e))

    return HttpResponse(
        json.dumps(ret, sort_keys=True),
        mimetype='application/javascript'
        )
