# -*- coding: utf-8 -*-

from django.http import HttpResponse, Http404, HttpResponseNotFound
from django.shortcuts import render_to_response
from django.template import RequestContext

from django.conf import settings

import json, re, os.path, sys
import logging
from datetime import datetime

"""
Небольшое приложение для загрузки файлов на сервер
"""

logger = logging.getLogger(__name__)

def index(r, path):
    if r.method != 'POST':
        return render_to_response('uploader/index.html', {}, context_instance=RequestContext(r))
    ret = {'error': _check_params(r)}
    if not ret['error']:
        try:
            result_file = os.path.join(settings.UPLOADER_DIR, r.POST['name'])
            dest_fh = open(result_file, "wb")
            sys.stderr.write(json.dumps({'user': r.user.username, 'file': result_file, 'date': str(datetime.now())}))
            sys.stderr.write("\n")
            for chunk in r.FILES['file'].chunks():
                sys.stderr.write(chunk)
                dest_fh.write(chunk)
            dest_fh.close()
            sys.stderr.write("\n")
            ret['url'] = 'http://' + r.META['HTTP_HOST'] + settings.UPLOADER_PATH + "/" + r.POST['name']
            ret['save_time'] = datetime.now().strftime("%H:%M:%S")
        except Exception, e:
            ret['error'] = "Ошибка загрузки файла: %s" % str(e)
    retstr = "<script>parent.upload_result(" + json.dumps(ret) + ");</script>"
    return HttpResponse(retstr, mimetype="text/html")

def _check_params(r):
    if 'name' not in r.POST:
        return "Не указано имя файла"
    if not re.match(r'^[a-zA-Z0-9_-][a-zA-Z0-9\._-]*$', r.POST['name']):
        return "Неверно указано имя файла"
    if 'file' not in r.FILES:
        return "Не выбран файл"
    return None

