from django.conf import settings

from django.conf.urls import patterns, url, include

from django.contrib import admin
admin.autodiscover()

urlpatterns = patterns('',
    (r'^(index/|$)', include('releaser.index.urls')),
    (r'^(svnlog/$)', include('releaser.svnlog.urls')),
    (r'^svnreview/', include('releaser.svnreview.urls')),
    (r'^metatracker/', include('releaser.metatracker.urls')),
    (r'^testupdate/', include('releaser.testupdate.urls')),
    (r'^gap/', include('releaser.gap.urls')),
    (r'^versionica/', include('releaser.versionica.urls')),
    (r'^rights/', include('releaser.rights.urls')),
    (r'^releaseplanning/', include('releaser.releaseplanning.urls')),
    (r'^migrations/', include('releaser.migrations.urls')),
    (r'^hotfixing/', include('releaser.hotfixing.urls')),
    (r'^ptera/', include('releaser.ptera.urls')),
    (r'^flagman/', include('releaser.flagman.urls')),
    (r'^autobeta/', include('releaser.autobeta.urls')),
    (r'^(m|screen)/', include('releaser.screen.urls')),
    (r'^(birthdays)/', include('releaser.birthdays.urls')),
    (r'^(cifront)/', include('releaser.cifront.urls')),
    (r'^automerge/', include('releaser.automerge.urls')),
    (r'^statistics/', include('releaser.statistics.urls')),
    (r'^cloud_testupdate/', include('releaser.cloud_testupdate.urls')),
    (r'^subscriptions/', include('releaser.subscriptions.urls')),
    (r'^testscriptrun/', include('releaser.testscriptrun.urls')),

    (r'^(ft|functests)/', include('releaser.functests.urls')),

    (r'^(?:t|timer)$', 'django.views.static.serve',
     {'document_root': settings.PROJECT_PATH + '/releaser/static', 'path': 'timer.html'}),

    (r'^static/(?P<path>.*)$', 'django.views.static.serve',
     {'document_root': settings.PROJECT_PATH + '/releaser/static'}),
    (r'^tracker/issue_status$', 'releaser.tracker_proxy.views.issue_status'),


    # Uncomment the admin/doc line below and add 'django.contrib.admindocs'
    # to INSTALLED_APPS to enable admin documentation:
    # (r'^admin/doc/', include('django.contrib.admindocs.urls')),

    # Uncomment the next line to enable the admin:
    #(r'^admin/(.*)', admin.site.root),

    (r'^zkbrowser(?P<path>.*)$', 'releaser.zkbrowser.views.index'),

    (r'^uploader(?P<path>.*)$', 'releaser.uploader.views.index'),

    (r'^login', 'releaser.common.views.login'),

    (r'^xmpp_send', 'releaser.common.views.yamb_send'),
    (r'^yamb_send', 'releaser.common.views.yamb_send'),
)
