# -*- encoding: utf-8 -*-

from email.mime.text import MIMEText
import os, base64, time, random, hashlib, base64
from contextlib import contextmanager

from django.core.files import locks
from django.conf import settings
import zookeeper
from math import log

sendmail_location = "/usr/sbin/sendmail"

def mime_encode(string):
    return '=?utf8?B?%s?=' % base64.b64encode(string)

def sendmail(mail_from, mail_to, subject, body, cc=None):
    msg = MIMEText(body, _charset="utf-8")
    msg['Subject'] = mime_encode(subject)
    msg['From'] = mail_from
    msg['To'] = mail_to
    if cc:
        msg['CC'] = cc

    p = os.popen("%s -oi -t" % sendmail_location, "w")
    p.write(msg.as_string())
    status = p.close()


def generate_reqid():
    pid = os.getpid()
    t = time.clock()
    rnd = random.randrange(0, 2 ** 16 - 1)
    return int((t*257 % 2**32) * 2**32 + pid * 2**16 + rnd)


def hash(str):
    h = hashlib.sha256()
    h.update(str)
    return base64.b64encode(h.digest())


def filter_utf_for_mysql(str):
    # нужно отфильтровывать символы с кодом более 65535
    # как нормально сделать - не знаю
    return str.encode('cp1251', 'replace').decode('cp1251')

def decode_str(str):
    """
    Попытаться раскодировать текст, пусть даже с потерями
    """
    if isinstance(str, unicode):
        str_unicode = str
    else:
        enc_list = ('utf-8', 'cp1251','utf-8')
        for enc in enc_list[0:-1]:
            try:
                return filter_utf_for_mysql(str.decode(enc, 'strict'))
            except UnicodeError:
                pass
        str_unicode = str.decode(enc_list[-1], 'replace')
    return filter_utf_for_mysql(str_unicode)



@contextmanager
def locked_file(filename, retries=None, timeout=None):
    full_filename = "%s/%s" % (settings.LOCKS_PATH, filename)
    if retries is None:
        retries = 0
    if timeout is None:
        timeout = 1
    i = 0
    f = open(full_filename, 'wb')
    while True:
        try:
            locks.lock(f, locks.LOCK_EX|locks.LOCK_NB)
            break
        except (IOError), (e):
            if i >= retries or e.errno not in (errno.EACCES, errno.EAGAIN):
                raise e
            i = i + 1
            time.sleep(timeout)
    try:
        yield
    finally:
        locks.unlock(f)
        f.close()


def calc_font_size(value, base_value, value_step, font_step, min_proc=60):
    if value > 0:
        f = value / float(base_value)
    else:
        f = 0.1

    x = log(f)/log(value_step)
    proc = 100 + 10*int(x*font_step/10.0)

    if proc < min_proc:
        proc = min_proc

    return proc


def make_display_url(issue_key):
    return settings.STARTREK_DISPLAY_URL + '/' + issue_key

def get_hosts_from_zk_node_using_zk_handle(zkh, zk_node):
    content = zookeeper.get(zkh, zk_node)[0]
    return content.splitlines()

def get_hosts_from_zk_node(zk_node):
    zkh = zookeeper.init(settings.ZOOKEEPER_SERVERS, None, 10000)
    result = get_hosts_from_zk_node_using_zk_handle(zkh, zk_node)
    zookeeper.close(zkh)
    return result

def get_hosts_from_zk_directory(zk_directory):
    zkh = zookeeper.init(settings.ZOOKEEPER_SERVERS, None, 10000)
    children = zookeeper.get_children(zkh, zk_directory)
    result = []
    for child in children:
        print zk_directory + "/" + child
        result.extend(get_hosts_from_zk_node_using_zk_handle(zkh, zk_directory + "/" + child))
    return result

