# -* encoding: utf-8 -*-
from django.db.models import Q
import math, sys, re, yaml
from urllib import urlencode

from django.conf import settings
from releaser.versionica.models import *

def check():
    raw_rules = yaml.load(open(settings.VERSIONICA_PACKAGE_RULES_FILE))

    hostnames = [p['host__name'] for p in HostProperty.objects.values('host__name').order_by().distinct()]

    # к каждому правилу приписываем хосты, которые под него подпадают
    rules = []
    for raw_rule in raw_rules:
        rule = {
                'raw_rule': raw_rule,
                'yamled_rule': yaml.dump(raw_rule, default_flow_style=False),
                }
        rules += [rule]
        rule['host_list'] = []
        for h in hostnames:
            for regexp in raw_rule['hosts']:
                regexp += '$'
                if re.match(regexp, h):
                    rule['host_list'] += [h]
                    break

    proof_link_tmpl = "/versionica/property?include_missing_packages=on&%s"
    hosts_proof_link_tmpl = "/versionica/property?%s"
    for rule in rules:
        raw_rule = rule['raw_rule']
        rule['ok'] = True
        rule['status_ok'] = []
        rule['status_nook'] = []
        rule['hosts_count'] = len(rule['host_list'])
        packages_count_min = rule['hosts_count'] if raw_rule['packages_count_min'] == 'all' else raw_rule['packages_count_min']
        packages_count_max = rule['hosts_count'] if raw_rule['packages_count_max'] == 'all' else raw_rule['packages_count_max']
        # проверяем количество хостов, попавших под правило
        param = {
                'host': "^(%s)$" % "|".join(rule['raw_rule']['hosts']),
                'property': "__ANY__",
                }
        hosts_proof_link = hosts_proof_link_tmpl % (urlencode(param))
        if rule['hosts_count'] < raw_rule['hosts_count_min']:
            rule['ok'] = False
            error_message = "#(hosts) = %s < hosts_count_min = %s" % (rule['hosts_count'], raw_rule['hosts_count_min'])
            rule['status_nook'] += [{
                'message': error_message,
                'proof_link': hosts_proof_link,
                }]
        if rule['hosts_count'] > raw_rule['hosts_count_max']:
            rule['ok'] = False
            error_message = "#(hosts) = %s > hosts_count_max = %s" % (rule['hosts_count'], raw_rule['hosts_count_max'])
            rule['status_nook'] += [{
                'message': error_message,
                'proof_link': hosts_proof_link,
                }]
        if rule['ok']:
            rule['status_ok'] += [{
                'message': "#(hosts) = %s" % rule['hosts_count'],
                'proof_link': hosts_proof_link,
                }]
        for p in raw_rule['packages']:
            package_ok = True
            # проверяем количество хостов с установленным пакетом
            cnt = HostProperty.objects.filter(host__name__in = rule['host_list'], property__name = p).count()
            param = {
                    'host': "^(%s)$" % "|".join(rule['raw_rule']['hosts']),
                    'property': "^%s$" % p,
                    }
            proof_link = proof_link_tmpl % (urlencode(param))
            if packages_count_min < 0 and cnt < rule['hosts_count'] + packages_count_min:
                rule['ok'] = False
                package_ok = False
                error_message = "#(%s) = %s < packages_count_min = %s - %s" % (p, cnt, rule['hosts_count'], -packages_count_min)
                rule['status_nook'] += [{
                    'message': error_message,
                    'proof_link': proof_link
                    }]
            if packages_count_min >= 0 and cnt < packages_count_min :
                rule['ok'] = False
                package_ok = False
                error_message = "#(%s) = %s < packages_count_min = %s" % (p, cnt, packages_count_min)
                rule['status_nook'] += [{
                    'message': error_message,
                    'proof_link': proof_link
                    }]
            if packages_count_max < 0 and cnt > rule['hosts_count'] + packages_count_max :
                rule['ok'] = False
                package_ok = False
                error_message = "#(%s) = %s > packages_count_max = %s - %s" % (p, cnt, rule['hosts_count'], -packages_count_max)
                rule['status_nook'] += [{
                    'message': error_message,
                    'proof_link': proof_link
                    }]
            if packages_count_max >= 0 and cnt > packages_count_max :
                rule['ok'] = False
                package_ok = False
                error_message = "#(%s) = %s > packages_count_max = %s" % (p, cnt, packages_count_max)
                rule['status_nook'] += [{
                    'message': error_message,
                    'proof_link': proof_link
                    }]
            if package_ok:
                rule['status_ok'] += [{
                    'message': "#(%s) = %s" % (p, cnt),
                    'proof_link': proof_link
                    }]
    return rules


def check_results_to_text(results, **O):
    text_parts = []
    for rule in results:
        if rule['ok'] and not O['full_report']:
            continue

        title = rule['raw_rule']['title']
        if rule['ok']:
            part = "### Правило %s -- OK" % title
        else:
            part = "### Правило %s -- проблемы:\n%s" % (
                    title,
                    "\n".join([ nook['message'] for nook in rule['status_nook']])
                    )
        text_parts += [part]

    if len(text_parts) == 0:
        return ''

    text = "Проверка установленных пакетов\n\n%s\n\nПодробнее: http://%s/versionica/checkpackages" % ("\n\n".join(text_parts), settings.RELEASER_DNS)
    return text
