# -* encoding: utf-8 -*-
from django.db.models import Q
import math
import sys
import re

from django.conf import settings
from releaser.versionica.models import *
from releaser.versionica.tools import parse_version
from releaser.svnlog.models import *
from releaser.conductor_client.client import *
import releaser.common.apps_conf as AppsConf
import urllib2
import json


def current_version(group, app=None):
    try:
        if settings.PROJECT == 'javadirect':
            apps_conf = AppsConf.get(add_perl_direct=True)

            if app not in apps_conf:
                return '1.0.0-1'

            versions_dict = {}
            length = 0
            if app == 'direct':
                # версии perl-Директа не пишутся в java-direct-Версионику, поэтому достаём их из direct-dev
                # в будущем разные проекты в Табуле объединим, база Версионики будет одна и эта конструкция перестанет быть нужна
                if type(group) == str and group == 'release-ts':
                    host_arg = 'host=ppctest-ts1-front.yandex.ru'
                else:
                    host_arg = 'host_group=c%3Adirect_perl'
                versionica_request_url = 'https://direct-dev.yandex-team.ru/versionica/property?project=prehistoric&reqid=&group=&host=&property=yandex-direct%24&as=json_with_hosts&' + host_arg
                req = urllib2.Request(versionica_request_url)
                direct_versionica_data = json.loads(urllib2.urlopen(req).read())
                pkg = apps_conf[app]['package']
                length = len(direct_versionica_data.keys())
                for h in direct_versionica_data:
                    try:
                        if direct_versionica_data[h][pkg] not in versions_dict:
                            versions_dict[ direct_versionica_data[h][pkg] ] = 0
                    except KeyError:
                        pass
                    versions_dict[ direct_versionica_data[h][pkg] ] += 1
            else:
                if group and str(group).startswith('app:'):
                    hosts = ConductorRestClient().groups2hosts(apps_conf[str(group)[len('app:'):]]['conductor_groups'])
                else:
                    hosts = ConductorRestClient().groups2hosts(apps_conf[app]['conductor_groups'])

                versions = HostProperty.objects.all().select_related('host__name', 'property__name').filter(
                    group__name='packages',
                    property__name=apps_conf[app]['package'],
                    host__name__in=hosts
                )
                for version in versions:
                    if version.value not in versions_dict:
                        versions_dict[version.value] = 0
                    versions_dict[version.value] += 1
                length = len(versions)

            for version in versions_dict:
                if versions_dict[version] * 2 >= length: # берем версию релиза, которая в данный момент стоит хотя бы на половине продакшеновых машин
                    return version

            return '1.0.0-1'

        # если понадобится, можно MAIN_DEB_PACKAGE хранить тоже в базе
        version = HostProperty.objects.get(
                host=group.main_host,
                group__name='packages',
                property__name=settings.MAIN_DEB_PACKAGE,
                ).value
    except HostProperty.DoesNotExist:
        version = '1.0.0-1'
    return version


def has_commit(group, rev, version=None, app=None):
    return check_commits(group, [rev], version, app)[rev]

def check_commits(group, revs, version=None, app=None):
    # TODO если коммит был в branches -- False

    if group and str(group).startswith('app:'):
        app = str(group)[len('app:'):]

    if settings.PROJECT == 'javadirect' and app == None:
        return {}

    if version == None:
        version = current_version(group, app)

    base_rev, tip_rev = parse_version(version)
    release_branch = '/releases/release-%d' % base_rev

    if settings.PROJECT == 'javadirect':
        if app == 'direct':
            release_branch = '/branches/direct/release/perl/release-%s' % base_rev
        else:
            release_branch = '/branches/direct/release/%s/%s/arcadia' % (app, base_rev)

    ret = {}
    for rev in revs:
        if rev <= base_rev:
            ret[rev] = True
        elif rev > tip_rev:
            ret[rev] = False

    todo = filter(lambda r: r not in ret, revs)
    if todo:
        hotfixes = [h.hotfix_rev_id for h in SvnLogHotfix.objects.filter(release_rev=base_rev, commit_rev__lte=tip_rev, hotfix_rev__in=todo)]
        for h in hotfixes:
            ret[h] = True
        todo = filter(lambda r: r not in ret, revs)

    if todo:
        # коммиты, сделанные в релизный бранч до врехней выложенной ревизии
        branches = SvnLogBranch.objects.select_related('branch').filter(rev__in=todo)
        for b in branches:
            if b.branch.path == release_branch and rev <= tip_rev:
                ret[b.rev_id] = True
        todo = filter(lambda r: r not in ret, revs)

    for t in todo:
        ret[t] = False
    return ret

