# -*- encoding: utf-8 -*-

"""
django-admin.py clear_host bmdev04.yandex.ru --settings=releaser.settings.direct --pythonpath=../

Интерактивный скрипт для удаления из Версионики записей об устаревших (отключенных, переименованных) хостах.

В командной строке ожидает имя хоста.
После запуска просит повторить это же имя, и затем ввести 'yes' (без кавычек)
-- для того, чтобы было почти невозможно непреднамеренно удалить нужные запси
случайно/запустив повторно команду/сделав мышкой двойной щелчок вместо одинарного
"""

from __future__ import with_statement

from django.core.management.base import BaseCommand
from django.db import transaction, models
from django.core.files import locks

from pprint import pprint as p
import tempfile, re, string, os, time, sys, urllib2
from datetime import datetime
from optparse import make_option
from contextlib import contextmanager

#import copy

from django.db.models import Q
from django.conf import settings
from releaser.utils import locked_file, generate_reqid
from releaser.versionica.models import PropertyGroup, Host
from releaser.versionica.update_properties import update_group

class Command(BaseCommand):
    help = "Deleting (obsolete) hosts from Versionica tables"
    debug = True


    #@transaction.commit_on_success
    def clear_host(self, reqid, hostname):
        try:
            host = Host.objects.get(name=hostname)
        except Host.DoesNotExist:
            sys.stderr.write("there is no host %s in DB\n" % hostname);
            return

        group_names = [ g.name for g in PropertyGroup.objects.all() ]

        for group in group_names:
            print("processing group %s\n" % group)
            update_group(hostname, group, {}, reqid)

        return


    def handle(self, hostname, **options):
        with locked_file('versionica_delete_host'):
            hostname2 = raw_input("repeat the hostname please: ")
            if hostname2 != hostname:
                print "\nhostnames don't match, exiting...\n"
                return
            confirm = raw_input("going to clear packages from host %s. Type yes to confirm: " % hostname)
            if confirm != 'yes':
                print "\nexiting...\n"
                return
            reqid = generate_reqid()
            print("hostname: %s\nreqid: %s\n" % (hostname, reqid))
            self.clear_host(reqid, hostname)
        return

