# -*- encoding: utf-8 -*-

from __future__ import with_statement

import httplib2
from urllib import urlencode

from django.core.management.base import BaseCommand
from django.db import transaction, models
from django.core.files import locks

import tempfile, re, string, os, time, sys, yaml
from optparse import make_option
from contextlib import contextmanager


from django.conf import settings
from releaser.utils import locked_file
from releaser.yambclient.client import YambClient
from releaser.versionica import check_package_rules
from releaser.rights.models import HasRight
from releaser.rights.tools import exclusive_holder


class Command(BaseCommand):
    """
    Провека установленных пакетов, yamb-уведомления о проблемах
    """

    option_list = BaseCommand.option_list + (
        make_option(
            "--full-report",
            action="store_true",
            default=False,
            dest="full_report",
            help="Make full report, including checks that don't fail"
            ),
        )

    @transaction.commit_on_success
    def do_all_work(self, full_report):
        check_results = check_package_rules.check()

        message = check_package_rules.check_results_to_text(check_results, full_report = full_report)

        yamb = YambClient()
        # кому отправлять сообщение
        if full_report:
            to = [ rec.user.login for rec in HasRight.objects.filter(right__right = "receive_check_package_full_notifications") ]
        else:
            to = [ rec.user.login for rec in HasRight.objects.filter(right__right = "receive_check_package_notifications") ]

        for login in to:
            yamb.send_message(login, message)

        return


    def handle(self, **options):
        with locked_file('package_rules_notifications'):
            self.do_all_work(options['full_report'])

        return

