# encoding: utf-8
import datetime
from south.db import db
from south.v2 import SchemaMigration
from django.db import models


class Migration(SchemaMigration):

    def forwards(self, orm):

        # Adding model 'VersionInstalled'
        db.create_table('versionica_versioninstalled', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('host', self.gf('django.db.models.fields.CharField')(max_length=100)),
            ('package', self.gf('django.db.models.fields.CharField')(max_length=100)),
            ('version', self.gf('django.db.models.fields.CharField')(max_length=100)),
            ('logtime', self.gf('django.db.models.fields.DateTimeField')()),
        ))
        db.send_create_signal('versionica', ['VersionInstalled'])

        # Adding unique constraint on 'VersionInstalled', fields ['host', 'package']
        db.create_unique('versionica_versioninstalled', ['host', 'package'])

        # Adding model 'VersionLog'
        db.create_table('versionica_versionlog', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('host', self.gf('django.db.models.fields.CharField')(max_length=100, db_index=True)),
            ('package', self.gf('django.db.models.fields.CharField')(max_length=100)),
            ('action', self.gf('django.db.models.fields.CharField')(max_length=100)),
            ('version', self.gf('django.db.models.fields.CharField')(max_length=100)),
            ('logtime', self.gf('django.db.models.fields.DateTimeField')(db_index=True)),
        ))
        db.send_create_signal('versionica', ['VersionLog'])

        # Adding model 'Property'
        db.create_table('versionica_property', (
            ('prop_id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('name', self.gf('django.db.models.fields.CharField')(unique=True, max_length=100, db_index=True)),
        ))
        db.send_create_signal('versionica', ['Property'])

        # Adding model 'Host'
        db.create_table('versionica_host', (
            ('host_id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('name', self.gf('django.db.models.fields.CharField')(unique=True, max_length=100, db_index=True)),
        ))
        db.send_create_signal('versionica', ['Host'])

        # Adding model 'PropertyGroup'
        db.create_table('versionica_propertygroup', (
            ('group_id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('name', self.gf('django.db.models.fields.CharField')(unique=True, max_length=100, db_index=True)),
            ('default_property', self.gf('django.db.models.fields.CharField')(max_length=100)),
        ))
        db.send_create_signal('versionica', ['PropertyGroup'])

        # Adding model 'HostProperty'
        db.create_table('versionica_hostproperty', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('host', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['versionica.Host'])),
            ('group', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['versionica.PropertyGroup'])),
            ('property', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['versionica.Property'])),
            ('value', self.gf('django.db.models.fields.CharField')(max_length=300)),
            ('reqid', self.gf('django.db.models.fields.BigIntegerField')()),
            ('logtime', self.gf('django.db.models.fields.DateTimeField')()),
        ))
        db.send_create_signal('versionica', ['HostProperty'])

        # Adding unique constraint on 'HostProperty', fields ['host', 'group', 'property']
        db.create_unique('versionica_hostproperty', ['host_id', 'group_id', 'property_id'])

        # Adding model 'HostPropertyLog'
        db.create_table('versionica_hostpropertylog', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('host', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['versionica.Host'])),
            ('group', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['versionica.PropertyGroup'])),
            ('property', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['versionica.Property'])),
            ('action', self.gf('django.db.models.fields.CharField')(max_length=100)),
            ('value', self.gf('django.db.models.fields.CharField')(max_length=300)),
            ('reqid', self.gf('django.db.models.fields.BigIntegerField')()),
            ('logtime', self.gf('django.db.models.fields.DateTimeField')(db_index=True)),
        ))
        db.send_create_signal('versionica', ['HostPropertyLog'])

    def backwards(self, orm):

        # Removing unique constraint on 'HostProperty', fields ['host', 'group', 'property']
        db.delete_unique('versionica_hostproperty', ['host_id', 'group_id', 'property_id'])

        # Removing unique constraint on 'VersionInstalled', fields ['host', 'package']
        db.delete_unique('versionica_versioninstalled', ['host', 'package'])

        # Deleting model 'VersionInstalled'
        db.delete_table('versionica_versioninstalled')

        # Deleting model 'VersionLog'
        db.delete_table('versionica_versionlog')

        # Deleting model 'Property'
        db.delete_table('versionica_property')

        # Deleting model 'Host'
        db.delete_table('versionica_host')

        # Deleting model 'PropertyGroup'
        db.delete_table('versionica_propertygroup')

        # Deleting model 'HostProperty'
        db.delete_table('versionica_hostproperty')

        # Deleting model 'HostPropertyLog'
        db.delete_table('versionica_hostpropertylog')

    models = {
        'versionica.host': {
            'Meta': {'object_name': 'Host'},
            'host_id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '100', 'db_index': 'True'})
        },
        'versionica.hostproperty': {
            'Meta': {'unique_together': "(('host', 'group', 'property'),)", 'object_name': 'HostProperty'},
            'group': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['versionica.PropertyGroup']"}),
            'host': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['versionica.Host']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'logtime': ('django.db.models.fields.DateTimeField', [], {}),
            'property': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['versionica.Property']"}),
            'reqid': ('django.db.models.fields.BigIntegerField', [], {}),
            'value': ('django.db.models.fields.CharField', [], {'max_length': '300'})
        },
        'versionica.hostpropertylog': {
            'Meta': {'object_name': 'HostPropertyLog'},
            'action': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'group': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['versionica.PropertyGroup']"}),
            'host': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['versionica.Host']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'logtime': ('django.db.models.fields.DateTimeField', [], {'db_index': 'True'}),
            'property': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['versionica.Property']"}),
            'reqid': ('django.db.models.fields.BigIntegerField', [], {}),
            'value': ('django.db.models.fields.CharField', [], {'max_length': '300'})
        },
        'versionica.property': {
            'Meta': {'object_name': 'Property'},
            'name': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '100', 'db_index': 'True'}),
            'prop_id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'})
        },
        'versionica.propertygroup': {
            'Meta': {'object_name': 'PropertyGroup'},
            'default_property': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'group_id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '100', 'db_index': 'True'})
        },
        'versionica.versioninstalled': {
            'Meta': {'unique_together': "(('host', 'package'),)", 'object_name': 'VersionInstalled'},
            'host': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'logtime': ('django.db.models.fields.DateTimeField', [], {}),
            'package': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'version': ('django.db.models.fields.CharField', [], {'max_length': '100'})
        },
        'versionica.versionlog': {
            'Meta': {'object_name': 'VersionLog'},
            'action': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'host': ('django.db.models.fields.CharField', [], {'max_length': '100', 'db_index': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'logtime': ('django.db.models.fields.DateTimeField', [], {'db_index': 'True'}),
            'package': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'version': ('django.db.models.fields.CharField', [], {'max_length': '100'})
        }
    }

    complete_apps = ['versionica']
