# encoding: utf-8
import datetime
from south.db import db
from south.v2 import SchemaMigration
from django.db import models


class Migration(SchemaMigration):

    def forwards(self, orm):

        # Removing unique constraint on 'VersionInstalled', fields ['host', 'package']
        db.delete_unique('versionica_versioninstalled', ['host', 'package'])

        # Deleting model 'VersionInstalled'
        db.delete_table('versionica_versioninstalled')

        # Deleting model 'VersionLog'
        db.delete_table('versionica_versionlog')

    def backwards(self, orm):

        # Adding model 'VersionInstalled'
        db.create_table('versionica_versioninstalled', (
            ('package', self.gf('django.db.models.fields.CharField')(max_length=100)),
            ('host', self.gf('django.db.models.fields.CharField')(max_length=100)),
            ('version', self.gf('django.db.models.fields.CharField')(max_length=100)),
            ('logtime', self.gf('django.db.models.fields.DateTimeField')()),
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
        ))
        db.send_create_signal('versionica', ['VersionInstalled'])

        # Adding unique constraint on 'VersionInstalled', fields ['host', 'package']
        db.create_unique('versionica_versioninstalled', ['host', 'package'])

        # Adding model 'VersionLog'
        db.create_table('versionica_versionlog', (
            ('version', self.gf('django.db.models.fields.CharField')(max_length=100)),
            ('package', self.gf('django.db.models.fields.CharField')(max_length=100)),
            ('host', self.gf('django.db.models.fields.CharField')(max_length=100, db_index=True)),
            ('logtime', self.gf('django.db.models.fields.DateTimeField')(db_index=True)),
            ('action', self.gf('django.db.models.fields.CharField')(max_length=100)),
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
        ))
        db.send_create_signal('versionica', ['VersionLog'])

    models = {
        'versionica.host': {
            'Meta': {'object_name': 'Host'},
            'host_id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '100', 'db_index': 'True'})
        },
        'versionica.hostproperty': {
            'Meta': {'unique_together': "(('host', 'group', 'property'),)", 'object_name': 'HostProperty'},
            'group': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['versionica.PropertyGroup']"}),
            'host': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['versionica.Host']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'logtime': ('django.db.models.fields.DateTimeField', [], {}),
            'property': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['versionica.Property']"}),
            'reqid': ('django.db.models.fields.BigIntegerField', [], {}),
            'value': ('django.db.models.fields.CharField', [], {'max_length': '300'})
        },
        'versionica.hostpropertylog': {
            'Meta': {'object_name': 'HostPropertyLog'},
            'action': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'group': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['versionica.PropertyGroup']"}),
            'host': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['versionica.Host']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'logtime': ('django.db.models.fields.DateTimeField', [], {'db_index': 'True'}),
            'property': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['versionica.Property']"}),
            'reqid': ('django.db.models.fields.BigIntegerField', [], {}),
            'value': ('django.db.models.fields.CharField', [], {'max_length': '300'})
        },
        'versionica.property': {
            'Meta': {'object_name': 'Property'},
            'name': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '100', 'db_index': 'True'}),
            'prop_id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'})
        },
        'versionica.propertygroup': {
            'Meta': {'object_name': 'PropertyGroup'},
            'default_property': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'group_id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '100', 'db_index': 'True'})
        }
    }

    complete_apps = ['versionica']
