# encoding: utf-8
import datetime
from south.db import db
from south.v2 import SchemaMigration
from django.db import models


class Migration(SchemaMigration):

    def forwards(self, orm):

        # Adding model 'HostGroup'
        db.create_table('versionica_hostgroup', (
            ('group_id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('name', self.gf('django.db.models.fields.CharField')(unique=True, max_length=100, db_index=True)),
            ('main_host', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['versionica.Host'], null=True)),
        ))
        db.send_create_signal('versionica', ['HostGroup'])

        # Adding model 'GroupIncludesHost'
        db.create_table('versionica_groupincludeshost', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('group', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['versionica.HostGroup'])),
            ('host', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['versionica.Host'])),
        ))
        db.send_create_signal('versionica', ['GroupIncludesHost'])

    def backwards(self, orm):

        # Deleting model 'HostGroup'
        db.delete_table('versionica_hostgroup')

        # Deleting model 'GroupIncludesHost'
        db.delete_table('versionica_groupincludeshost')

    models = {
        'versionica.groupincludeshost': {
            'Meta': {'object_name': 'GroupIncludesHost'},
            'group': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['versionica.HostGroup']"}),
            'host': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['versionica.Host']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'})
        },
        'versionica.host': {
            'Meta': {'object_name': 'Host'},
            'host_id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '100', 'db_index': 'True'})
        },
        'versionica.hostgroup': {
            'Meta': {'object_name': 'HostGroup'},
            'group_id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'main_host': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['versionica.Host']", 'null': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '100', 'db_index': 'True'})
        },
        'versionica.hostproperty': {
            'Meta': {'unique_together': "(('host', 'group', 'property'),)", 'object_name': 'HostProperty'},
            'group': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['versionica.PropertyGroup']"}),
            'host': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['versionica.Host']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'logtime': ('django.db.models.fields.DateTimeField', [], {}),
            'property': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['versionica.Property']"}),
            'reqid': ('django.db.models.fields.BigIntegerField', [], {}),
            'value': ('django.db.models.fields.CharField', [], {'max_length': '300'})
        },
        'versionica.hostpropertylog': {
            'Meta': {'object_name': 'HostPropertyLog'},
            'action': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'group': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['versionica.PropertyGroup']"}),
            'host': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['versionica.Host']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'logtime': ('django.db.models.fields.DateTimeField', [], {'db_index': 'True'}),
            'property': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['versionica.Property']"}),
            'reqid': ('django.db.models.fields.BigIntegerField', [], {}),
            'value': ('django.db.models.fields.CharField', [], {'max_length': '300'})
        },
        'versionica.property': {
            'Meta': {'object_name': 'Property'},
            'name': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '100', 'db_index': 'True'}),
            'prop_id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'})
        },
        'versionica.propertygroup': {
            'Meta': {'object_name': 'PropertyGroup'},
            'default_property': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'group_id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '100', 'db_index': 'True'})
        }
    }

    complete_apps = ['versionica']
