# -*- coding: utf-8 -*-
import datetime
from south.db import db
from south.v2 import SchemaMigration
from django.db import models


class Migration(SchemaMigration):

    def forwards(self, orm):
        # Removing unique constraint on 'HostProperty', fields ['host', 'property', 'group']
        db.delete_unique(u'versionica_hostproperty', ['host_id', 'property_id', 'group_id'])

        # Adding field 'HostProperty.project'
        db.add_column(u'versionica_hostproperty', 'project',
                      self.gf('django.db.models.fields.IntegerField')(default=0),
                      keep_default=False)

        # Adding unique constraint on 'HostProperty', fields ['project', 'host', 'property', 'group']
        db.create_unique(u'versionica_hostproperty', ['project', 'host_id', 'property_id', 'group_id'])

        # Adding field 'HostPropertyLog.project'
        db.add_column(u'versionica_hostpropertylog', 'project',
                      self.gf('django.db.models.fields.IntegerField')(default=0),
                      keep_default=False)


    def backwards(self, orm):
        # Removing unique constraint on 'HostProperty', fields ['project', 'host', 'property', 'group']
        db.delete_unique(u'versionica_hostproperty', ['project', 'host_id', 'property_id', 'group_id'])

        # Deleting field 'HostProperty.project'
        db.delete_column(u'versionica_hostproperty', 'project')

        # Adding unique constraint on 'HostProperty', fields ['host', 'property', 'group']
        db.create_unique(u'versionica_hostproperty', ['host_id', 'property_id', 'group_id'])

        # Deleting field 'HostPropertyLog.project'
        db.delete_column(u'versionica_hostpropertylog', 'project')


    models = {
        u'versionica.groupincludeshost': {
            'Meta': {'object_name': 'GroupIncludesHost'},
            'group': ('django.db.models.fields.related.ForeignKey', [], {'to': u"orm['versionica.HostGroup']"}),
            'host': ('django.db.models.fields.related.ForeignKey', [], {'to': u"orm['versionica.Host']"}),
            u'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'})
        },
        u'versionica.host': {
            'Meta': {'object_name': 'Host'},
            'host_id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '100', 'db_index': 'True'})
        },
        u'versionica.hostgroup': {
            'Meta': {'object_name': 'HostGroup'},
            'group_id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'main_host': ('django.db.models.fields.related.ForeignKey', [], {'to': u"orm['versionica.Host']", 'null': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '100', 'db_index': 'True'})
        },
        u'versionica.hostproperty': {
            'Meta': {'unique_together': "(('project', 'host', 'group', 'property'),)", 'object_name': 'HostProperty'},
            'group': ('django.db.models.fields.related.ForeignKey', [], {'to': u"orm['versionica.PropertyGroup']"}),
            'host': ('django.db.models.fields.related.ForeignKey', [], {'to': u"orm['versionica.Host']"}),
            u'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'logtime': ('django.db.models.fields.DateTimeField', [], {}),
            'project': ('django.db.models.fields.IntegerField', [], {'default': '0'}),
            'property': ('django.db.models.fields.related.ForeignKey', [], {'to': u"orm['versionica.Property']"}),
            'reqid': ('django.db.models.fields.BigIntegerField', [], {}),
            'value': ('django.db.models.fields.CharField', [], {'max_length': '300'})
        },
        u'versionica.hostpropertylog': {
            'Meta': {'object_name': 'HostPropertyLog'},
            'action': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'group': ('django.db.models.fields.related.ForeignKey', [], {'to': u"orm['versionica.PropertyGroup']"}),
            'host': ('django.db.models.fields.related.ForeignKey', [], {'to': u"orm['versionica.Host']"}),
            u'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'logtime': ('django.db.models.fields.DateTimeField', [], {'db_index': 'True'}),
            'project': ('django.db.models.fields.IntegerField', [], {'default': '0'}),
            'property': ('django.db.models.fields.related.ForeignKey', [], {'to': u"orm['versionica.Property']"}),
            'reqid': ('django.db.models.fields.BigIntegerField', [], {}),
            'value': ('django.db.models.fields.CharField', [], {'max_length': '300'})
        },
        u'versionica.property': {
            'Meta': {'object_name': 'Property'},
            'name': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '100', 'db_index': 'True'}),
            'prop_id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'})
        },
        u'versionica.propertygroup': {
            'Meta': {'object_name': 'PropertyGroup'},
            'default_property': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'group_id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '100', 'db_index': 'True'})
        }
    }

    complete_apps = ['versionica']