# -*- coding:utf-8 -*-
from django.db import models
from datetime import datetime


class Property(models.Model):
    prop_id = models.AutoField(primary_key=True,)
    name = models.CharField( max_length = 100, db_index = True, unique = True )
    def __unicode__(self):
        return self.name

class Host(models.Model):
    host_id = models.AutoField(primary_key=True,)
    name = models.CharField( max_length = 100, db_index = True, unique = True )
    def __unicode__(self):
        return self.name

class PropertyGroup(models.Model):
    group_id = models.AutoField(primary_key=True,)
    name = models.CharField( max_length = 100, db_index = True, unique = True )
    default_property = models.CharField( max_length = 100)
    def __unicode__(self):
        return self.name

class HostProperty(models.Model):

    PROJECT_PREHISTORIC = 0
    PROJECT_DIRECT = 1
    PROJECT_DIRECTMOD = 2
    PROJECT_GEOCONTEXT = 3
    PROJECT_MARKET = 3
    PROJECT_DEBUG = 999
    PROJECT_CHOICES = (
            (PROJECT_PREHISTORIC, 'prehistoric'),
            (PROJECT_DIRECT, 'Direct'),
            (PROJECT_DIRECTMOD, 'Directmod'),
            (PROJECT_GEOCONTEXT, 'Geocontext'),
            (PROJECT_MARKET, 'Market'),
            (PROJECT_DEBUG, 'Debug'),
            )
    project_code_to_name = dict(PROJECT_CHOICES)
    project_name_to_code = dict((v,k) for k,v in PROJECT_CHOICES)

    project = models.IntegerField(choices=PROJECT_CHOICES, default=PROJECT_PREHISTORIC)
    host = models.ForeignKey(Host)
    group = models.ForeignKey(PropertyGroup)
    property = models.ForeignKey(Property)
    value = models.CharField( max_length = 300 )
    reqid = models.BigIntegerField()
    logtime = models.DateTimeField()

    class Meta:
        unique_together = (("project", "host", "group", "property"),)
    def save(self, *args, **kwargs):
            self.logtime = datetime.now()
            super(HostProperty, self).save(*args, **kwargs)
    def __unicode__(self):
        return "%s/%s: %s.%s=%s (%s)" % (self.project, self.host, self.group, self.property, self.value, self.logtime)


class HostPropertyLog(models.Model):
    project = models.IntegerField(choices=HostProperty.PROJECT_CHOICES, default=HostProperty.PROJECT_PREHISTORIC)
    host = models.ForeignKey(Host)
    group = models.ForeignKey(PropertyGroup)
    property = models.ForeignKey(Property)
    action  = models.CharField( max_length = 100 )
    value = models.CharField( max_length = 300 )
    reqid = models.BigIntegerField()
    logtime = models.DateTimeField(db_index = True)

    def save(self, *args, **kwargs):
            self.logtime = datetime.now()
            super(HostPropertyLog, self).save(*args, **kwargs)
    def __unicode__(self):
        return "%s/%s: %s %s.%s=%s (%s)" % (self.project, self.host, self.action, self.group, self.property, self.value, self.logtime)


class HostGroup(models.Model):
    group_id = models.AutoField(primary_key=True,)
    name = models.CharField( max_length = 100, db_index = True, unique = True )
    main_host = models.ForeignKey(Host, null=True)
    def __unicode__(self):
        return self.name


class GroupIncludesHost(models.Model):
    group = models.ForeignKey(HostGroup)
    host = models.ForeignKey(Host)
    def __unicode__(self):
        return "%s: %s" % (self.group.name, self.host.name)

