# -* encoding: utf-8 -*-
import math, sys, os, random, time, datetime, string, re


def prod_group_for_app(app_name):
    return "app:%s" % app_name


def parse_version(version):
    # 1.45601.45898~dirty-2
    regexp = r'^1\.(\d+)(?:\.(\d+))?(?:~[a-zA-Z0-9_\-]+)?-\d+'
    m = re.match(regexp, version)
    if not m:
        print version
        raise Exception("can't parse version %s" %  version)
    base_rev = int(m.group(1))
    if len(m.groups()) > 1:
        tip_rev = int(m.group(2) or base_rev)
    else:
        tip_rev = int(base_rev)
    return (base_rev, tip_rev)


def get_sort_params(str, **O):
    """
    из строчки вида 'property,-value' делает массив, подходящий для order_by
    """
    arr = string.split(str, ',') + [O['default']]
    sorted_desc = {}
    fields_array = []
    for f in arr:
        desc = ''
        if f[:1] == '-':
            desc = '-'
            f = f [1:]
        if f in sorted_desc or f == '':
            continue
        sorted_desc[f] = (desc == '-')
        fields_array = fields_array + [desc + f]

    primary_sort = fields_array[0]
    if primary_sort[:1] == '-':
        primary_sort = primary_sort[1:]

    for f in ['logtime', 'host__name', 'property', 'value']:
        if f in sorted_desc:
            continue
        sorted_desc[f] = False

    return {
            'fields_array': fields_array,
            'sorted_desc': sorted_desc,
            'primary_sort': primary_sort,
            }


def sort_dicts(array, order_by):
    for str in reversed(order_by):
        reverse = False
        field = str
        if str[0] == '-':
            reverse = True
            field = str[1:]
        array = sorted(array, key=lambda k: k[field], reverse=reverse)
    return array

