# -* encoding: utf-8 -*-
from django.db.models import Q
import math
import sys
import re

from django.conf import settings
from releaser.versionica.models import *


def update_group(project_name, hostname, groupname, new_value, reqid):
    host, _ = Host.objects.get_or_create(name=hostname)
    group, _ = PropertyGroup.objects.get_or_create(name=groupname)
    project_code = HostProperty.project_name_to_code[project_name]

    old = {}
    for rec in HostProperty.objects.all().filter(project=project_code, host=host, group=group):
        old[rec.property.name] = rec

    for p in new_value:
        action = ''
        property = None
        if p not in old:
            property, _ = Property.objects.get_or_create(name=p)
            rec = HostProperty.objects.create(
                    project=project_code,
                    host=host,
                    group=group,
                    property=property,
                    value=new_value[p],
                    reqid=reqid,
                    )
            action = 'add'
        elif p in old and new_value[p] != old[p].value:
            property = old[p].property
            rec = old[p]
            rec.value = new_value[p]
            rec.reqid = reqid
            action = 'update'
            rec.save()
        if action != '':
            log = HostPropertyLog.objects.create(
                    project=project_code,
                    host=host,
                    group=group,
                    property=property,
                    action=action,
                    value=new_value[p],
                    reqid=reqid,
                    )
    for p in old:
        if p not in new_value:
            log = HostPropertyLog.objects.create(
                    project=project_code,
                    host=host,
                    group=group,
                    property=old[p].property,
                    action='delete',
                    value='',
                    reqid=reqid,
                    )
            old[p].delete()

    return


def apply_diff_to_group(project_name, hostname, groupname, new_values, reqid):
    host, _ = Host.objects.get_or_create(name=hostname)
    group, _ = PropertyGroup.objects.get_or_create(name=groupname)
    project_code = HostProperty.project_name_to_code[project_name]

    old = {}
    for rec in HostProperty.objects.all().filter(project=project_code, host=host, group=group):
        old[rec.property.name] = rec

    for property in new_values:
        value = new_values[property]
        apply_diff_to_property(old, project_code, host, group, property, value, reqid)
    return


def apply_diff_to_property(old, project_code, host, group, property_name, new_value, reqid):
    property, _ = Property.objects.get_or_create(name=property_name)
    # 1. какое действие произошло
    if not property_name in old and new_value == '<none>':
        action = ''
    if not property_name in old and new_value != '<none>':
        action = 'add'
    if property_name in old and new_value == '<none>':
        action = 'delete'
    if property_name in old and new_value != '<none>' and new_value == old[property_name].value:
        action = ''
    if property_name in old and new_value != '<none>' and new_value != old[property_name].value:
        #sys.stderr.write("update %s --> %s\n" % (old[property], new_value))
        action = 'update'

    if action != '':
        log = HostPropertyLog(
                project=project_code,
                host=host,
                group=group,
                property=property,
                action=action,
                value=new_value,
                reqid=reqid
                )
        log.save()

    # 2. текущее состояние
    record, created = HostProperty.objects.get_or_create(project=project_code, host=host, group=group, property=property, defaults={'project':project_code, 'host': host, 'property': property, 'group': group, 'reqid': reqid})
    if new_value == '<none>':
        record.delete()
    else:
        record.value = new_value
        record.save()

    return

