# -* encoding: utf-8 -*-
import json
from django.http import HttpResponse, Http404
from django.shortcuts import render_to_response, redirect
from django.template import RequestContext
from django.contrib.auth.decorators import login_required
from django.db.models import Q, Min, Count
from django.db import connection
import math, sys, os, random, time, datetime, string, re
from socket import getaddrinfo, getnameinfo
import yaml
from urllib import urlencode

from django.conf import settings
from releaser.versionica.models import *
from releaser.versionica.update_properties import update_group, apply_diff_to_group
from releaser.versionica.tools import get_sort_params, sort_dicts

from releaser.utils import generate_reqid, get_hosts_from_zk_node, get_hosts_from_zk_directory
from releaser.rights.tools import allowed, has_right
from releaser.conductor_client.client import *

import check_package_rules


def property_index(r):
    if not settings.VERSIONICA_ENABLED:
        raise Http404

    reqid = r.GET.get('reqid', '').strip();
    project_name = r.GET.get('project', 'prehistoric').strip();
    host = r.GET.get('host', '').strip();
    property = r.GET.get('property', '').strip();
    group = r.GET.get('group', '').strip();
    host_group = r.GET.get('host_group', '').strip();
    sort = r.GET.get('sort', '').strip();
    include_missing_packages = r.GET.get('include_missing_packages', '').strip();
    #include_missing_packages = include_missing_packages == 'on'
    if project_name != '':
        project_code = HostProperty.project_name_to_code[project_name]
    else:
        project_code = None

    if not 'group' in r.GET:
        group = 'packages'

    if not 'property' in r.GET and 'group' != '':
        group = PropertyGroup.objects.get(name=group)
        property = group.default_property

    records = HostProperty.objects.all().select_related('host__name', 'property__name')

    if project_code != None:
        records = records.filter(project=project_code)

    if host_group != '':
        hostnames = []
        hosts = []
        for host_group_item in host_group.split(';'):
            if re.match(r'^c:', host_group_item):
                conductor_group = re.sub(r'^c:', '', host_group_item)
                hostnames.extend(ConductorRestClient().groups2hosts([conductor_group]))
            elif re.match(r'^zknode:', host_group_item):
                zk_node = re.sub(r'^zknode:', '', host_group_item)
                hostnames.extend(get_hosts_from_zk_node(zk_node))
            elif re.match(r'^zkchildren:', host_group_item):
                zk_directory = re.sub(r'^zkchildren:', '', host_group_item)
                hostnames.extend(get_hosts_from_zk_directory(zk_directory))
            else:
                hosts.extend([rec.host for rec in GroupIncludesHost.objects.all().filter(group__name=host_group_item) ])

        records = records.filter(Q(host__name__in=hostnames) | Q(host__in=hosts))
    if reqid != '':
        records = records.filter(reqid=reqid)
    if group != '':
        records = records.filter(group__name=group)
    if host != '':
        records = records.filter(host__name__regex=host)
    if include_missing_packages == 'on':
        # если надо показать хосты _без_ пакетов -- запоминаем все хосты
        matching_hosts = records.values('host__name').order_by().distinct()
    if property != '':
        if property == '__ANY__':
            # не нужны настоящие записи о пакетах, нужен только список хостов
            records_any = records.values('host__name').annotate(logtime=Min('logtime'))
        else:
            records = records.filter(property__name__regex=property)

    # QuerySet переделываем в массив хешей, чтобы приклеить фейковые записи о неустановленных пакетах
    # заодно составляем хеш "хост-пакет" => 1
    record_dicts = []
    installed = {}
    if property == '__ANY__':
        # только список хостов
        for rec in records_any:
            k = "%s-%s" % (rec['host__name'], '__ANY__')
            installed[k] = 1
            record_dicts +=[{
                'logtime': rec['logtime'].strftime('%Y-%m-%d %H:%M:%S'),
                'reqid': '',
                'host': rec['host__name'],
                'property': '__ANY__',
                'value': '__some__',
                }]
    else:
        # настоящий список хостов-пакетов
        for rec in records:
            k = "%s-%s" % (rec.host.name, rec.property.name)
            installed[k] = 1
            record_dicts +=[{
                'logtime': rec.logtime.strftime('%Y-%m-%d %H:%M:%S'),
                'reqid': rec.reqid,
                'host': rec.host.name,
                'property': rec.property.name,
                'value': rec.value,
                }]

    # добавляем записи о хостах, на которых _нет_ указанных пакетов
    if include_missing_packages == 'on' and property != '__ANY__':
        matching_properties = list(records.values('property__name').order_by().distinct())
        fake_records = []
        for p in matching_properties:
            for h in matching_hosts:
                k = "%s-%s" % (h['host__name'], p['property__name'])
                if k in installed:
                    continue
                fake_records += [{
                    'host': h['host__name'],
                    'property': p['property__name'],
                    'logtime': '0000-00-00',
                    'value': '',
                    'reqid': '',
                    }]
        record_dicts += fake_records

    sort_params = get_sort_params(sort, default='host')
    record_dicts = sort_dicts(record_dicts, sort_params['fields_array'])

    # Если в таблице ровно один реквизит -- раскрашиваем значения,
    # чтобы легче было видеть расхождения
    if len(list(set([rec['property'] for rec in record_dicts]))) == 1:
        property_count = {}
        for rec in record_dicts:
            if rec['value'] in property_count:
                property_count[rec['value']] += 1
            else:
                property_count[rec['value']] = 1

        value_order = {}
        for i, v in enumerate(sorted(property_count, reverse=True, key=property_count.get)):
            value_order[v] = i

        for rec in record_dicts:
            rec['order'] = value_order[rec['value']]
    else:
        property_count = {}

    # если требуется отдать версии в виде json -- делаем
    if 'as' in r.GET and r.GET.get('as', '').strip() == 'json_with_hosts':
        versions = {}
        for rec in records:
            if rec.host.name not in versions:
                versions[rec.host.name] = {}
            versions[rec.host.name][rec.property.name] = rec.value
        json_data = json.dumps(versions, sort_keys=True)
        return HttpResponse(json_data, mimetype="application/javascript")
    if 'as' in r.GET and r.GET.get('as', '').strip() == 'json':
        versions = {}
        for rec in records:
            versions[rec.property.name] = rec.value
        json_data = json.dumps(versions, sort_keys=True)
        return HttpResponse(json_data, mimetype="application/javascript")

    available_groups = [ g.name for g in PropertyGroup.objects.all()]

    sorted_desc = sort_params['sorted_desc']
    return render_to_response('versionica/property_index.html',
            {
                'include_missing_packages': include_missing_packages,
                'project': project_name,
                'host': host,
                'reqid': reqid,
                'group': group,
                'property': property,
                'host_group': host_group,
                'table_fields': [
                    {
                        'name': 'logtime',
                        'searcheable': False,
                        'sortable': True,
                        'sort_field': 'logtime',
                        'sorted_desc': sorted_desc['logtime'],
                        },
                    {
                        'name': 'reqid',
                        'searcheable': True,
                        'sortable': False,
                        },
                    {
                        'name': 'host',
                        'searcheable': True,
                        'sortable': True,
                        'sort_field': 'host',
                        'sorted_desc': sorted_desc['host'],
                        },
                    {
                        'name': 'property',
                        'searcheable': True,
                        'sortable': True,
                        'sort_field': 'property',
                        'sorted_desc': sorted_desc['property'],
                        },
                    {
                        'name': 'value',
                        'searcheable': False,
                        'sortable': True,
                        'sort_field': 'value',
                        'sorted_desc': sorted_desc['value'],
                        },
                    ],
                'properties': record_dicts,
                'available_projects': sorted(HostProperty.project_name_to_code.keys()),
                'available_groups': available_groups, #['db', 'packages', 'names'],
                'current_sort': ','.join(sort_params['fields_array']),
                'primary_sort': sort_params['primary_sort'],
            },
            context_instance=RequestContext(r)
            )


def update_db(r):
    return full_update_v2(r, "db")


def update_packages(r):
    return incremental_update_v2(r, "packages")


def full_update_v2(r, group):
    return full_update(r, group, "prehistoric")

def incremental_update_v2(r, group):
    return incremental_update(r, group, "prehistoric")

def full_update(r, group, project):
    if not settings.VERSIONICA_ENABLED:
        raise Http404

    if group == '':
        raise Http404

    if project == '':
        raise Http404

    ip = r.META['REMOTE_ADDR']
    host = getnameinfo(getaddrinfo(ip, 0)[0][-1], 0)[0]
    if '_hostname_for_versionica' in r.REQUEST:
        host = r.REQUEST['_hostname_for_versionica']

    new_value = {}
    for property in r.REQUEST:
        if property == 'hostname':
            continue
        value = r.REQUEST[property]
        new_value[property] = value

    update_group(project, host, group, new_value, r.reqid)

    return HttpResponse('OK', mimetype="application/javascript")


def incremental_update(r, group, project):
    if not settings.VERSIONICA_ENABLED:
        raise Http404

    if group == '':
        raise Http404

    if project == '':
        raise Http404

    x_forwarded_for = r.META.get('HTTP_X_FORWARDED_FOR')
    if x_forwarded_for:
        ip = x_forwarded_for.split(',')[0]
    else:
        ip = r.META.get('REMOTE_ADDR')

    host = getnameinfo(getaddrinfo(ip, 0)[0][-1], 0)[0]
    if '_hostname_for_versionica' in r.REQUEST:
        host = r.REQUEST['_hostname_for_versionica']

    new_value = {}
    for property in r.REQUEST:
        if property == 'hostname':
            continue
        value = r.REQUEST[property]
        new_value[property] = value

    apply_diff_to_group(project, host, group, new_value, r.reqid)

    return HttpResponse('OK', mimetype="application/javascript")


def property_log(r):
    if not settings.VERSIONICA_ENABLED:
        raise Http404

    project_name = r.GET.get('project', '').strip();
    host = r.GET.get('host', '').strip();
    property = r.GET.get('property', '').strip();
    group = r.GET.get('group', '').strip();
    action = r.GET.get('action', '').strip();
    reqid = r.GET.get('reqid', '').strip();
    host_group = r.GET.get('host_group', '').strip();
    sort = r.GET.get('sort', '').strip();

    if project_name != '':
        project_code = HostProperty.project_name_to_code[project_name]
    else:
        project_code = None

    records = HostPropertyLog.objects.all().select_related('host__name', 'property__name')

    if project_code:
        records = records.filter(project=project_code)
    if host_group != '':
        hostnames = []
        hosts = []
        for host_group_item in host_group.split(';'):
            if re.match(r'^c:', host_group_item):
                conductor_group = re.sub(r'^c:', '', host_group_item)
                hostnames.extend(ConductorRestClient().groups2hosts([conductor_group]))
            elif re.match(r'^zknode:', host_group_item):
                zk_node = re.sub(r'^zknode:', '', host_group_item)
                hostnames.extend(get_hosts_from_zk_node(zk_node))
            elif re.match(r'^zkchildren:', host_group_item):
                zk_directory = re.sub(r'^zkchildren:', '', host_group_item)
                hostnames.extend(get_hosts_from_zk_directory(zk_directory))
            else:
                hosts.extend([rec.host for rec in GroupIncludesHost.objects.all().filter(group__name=host_group_item) ])

        records = records.filter(Q(host__name__in=hostnames) | Q(host__in=hosts))
    if group != '':
        records = records.filter(group__name=group)
    if host != '':
        records = records.filter(host__name__regex=host)
    if property != '':
        records = records.filter(property__name__regex=property)
    if action != '':
        records = records.filter(action=action)
    if reqid != '':
        records = records.filter(reqid=reqid)

    sort_params = get_sort_params(sort, default='-logtime')
    limit = int(r.REQUEST.get('limit', 1000))
    records = apply(records.order_by, sort_params['fields_array'])[:limit]

    # принудительно форматируем время записи --
    # некрасиво, а красиво не умею :(
    for rec in records:
        rec.logtime = rec.logtime.strftime('%Y-%m-%d %H:%M:%S')

    # если требуется отдать версии в виде json -- делаем
    if 'as' in r.GET and r.GET.get('as', '').strip() == 'json':
        updates = []
        for rec in records:
            updates += [{
                    'logtime': rec.logtime,
                    'host': rec.host.name,
                    'property': rec.property.name,
                    'action': rec.action,
                    'value': rec.value,
                    }]
        json_data = json.dumps(updates, sort_keys=True)
        return HttpResponse(json_data, mimetype="application/javascript")

    # если требуется отдать версии в виде csv -- делаем
    if 'as' in r.GET and r.GET.get('as', '').strip() == 'csv':
        updates = []
        for rec in records:
            updates += [
                    "%s,%s,%s,%s,%s" % (
                    rec.logtime,
                    rec.host.name,
                    rec.property.name,
                    rec.action,
                    rec.value,
                    )
                    ]
        csv = "\n".join(updates)
        return HttpResponse(csv, mimetype="application/javascript")

    sorted_desc = sort_params['sorted_desc']
    response = render_to_response('versionica/property_log.html',
            {
                'action': action,
                'project': project_name,
                'host': host,
                'group': group,
                'property': property,
                'host_group': host_group,
                'reqid': reqid,
                'table_fields': [
                    {
                        'name': 'logtime',
                        'searcheable': False,
                        'sortable': True,
                        'sort_field': 'logtime',
                        'sorted_desc': sorted_desc['logtime'],
                        },
                    {
                        'name': 'reqid',
                        'searcheable': True,
                        },
                    {
                        'name': 'action',
                        'searcheable': False,
                        },
                    {
                        'name': 'host',
                        'searcheable': True,
                        'sortable': True,
                        'sort_field': 'host__name',
                        'sorted_desc': sorted_desc['host__name'],
                        },
                    {
                        'name': 'property',
                        'searcheable': True,
                        'sortable': True,
                        'sort_field': 'property',
                        'sorted_desc': sorted_desc['property'],
                        },
                    {
                        'name': 'value',
                        'searcheable': False,
                        'sortable': True,
                        'sort_field': 'value',
                        'sorted_desc': sorted_desc['value'],
                        },
                    ],
                'available_actions': ['add', 'update', 'delete'],
                'available_groups': ['db', 'packages'],
                'available_projects': sorted(HostProperty.project_name_to_code.keys()),
                'records': records,
                'current_sort': ','.join(sort_params['fields_array']),
                'primary_sort': sort_params['primary_sort'],
            },
            context_instance=RequestContext(r)
            )

    #for query in connection.queries:
    #    print query['sql']

    return response


@login_required
@allowed(['developer', 'admin'])
def host_group_index(r):
    by_host = {}
    by_group = {}
    ungrouped_hosts = []
    empty_groups = []

    records = GroupIncludesHost.objects.all()

    # нераспределенные по группам хосты: не приписаны ни к одной группе, и при этом о них есть актуальные записи
    ungrouped_hosts = [h for h in Host.objects.all() if len(h.groupincludeshost_set.all()) == 0 and HostProperty.objects.filter(host=h).count() > 0 ]

    empty_groups = [g for g in HostGroup.objects.all() if len(g.groupincludeshost_set.all()) == 0]

    property_groups = PropertyGroup.objects.all()

    return render_to_response('versionica/host_group_index.html',
            {
                'records': records,
                'by_host': by_host,
                'by_group': by_group,
                'ungrouped_hosts': ungrouped_hosts,
                'empty_groups': empty_groups,
                'property_groups': property_groups,
            },
            context_instance=RequestContext(r)
            )


@login_required
@allowed(['developer'])
def refresh_host_group(r):
    cfg = yaml.load(open(settings.VERSIONICA_HOSTGROUPS_FILE))
    # группы из файла
    groups_cfg = {}
    for g in cfg:
        if not g in groups_cfg:
            groups_cfg[g] = {
                    'main_host': None,
                    'hosts': [],
                    }
        if len(cfg[g]) == 0:
            continue
        # определяем главный хост (первый в списке, если это не пустая строка)
        if cfg[g][0] == '':
            cfg[g].pop(0)
        else:
            groups_cfg[g]['main_host'] = cfg[g][0]

        groups_cfg[g]['hosts'] = cfg[g]

    # группы из БД
    records = GroupIncludesHost.objects.all()
    groups_db = {}
    for rec in records:
        if not rec.group in groups_db:
            groups_db[rec.group] = []
        groups_db[rec.group] += [rec.host]

    #sys.stderr.write("cfg: %s\ndb: %s\n" % (groups_cfg, groups_db))

    # приводим БД к нужному виду
    # 1. удаляем группы и связи, которых больше нет
    for g in groups_db:
        if not g.name in groups_cfg:
            GroupIncludesHost.objects.filter(group=g).delete()
            g.delete()
            continue

        for h in groups_db[g]:
            if not h.name in groups_cfg[g.name]:
                GroupIncludesHost.objects.filter(group=g, host=h).delete()

    # 2. добавляем новые группы и связи из файла
    for gname in groups_cfg:
        g, _ = HostGroup.objects.get_or_create(name = gname)
        if groups_cfg[gname]['main_host'] != None and (g.main_host == None or g.main_host.name != groups_cfg[gname]['main_host']):
            g.main_host = Host.objects.get(name = groups_cfg[gname]['main_host'])
            g.save()
        if groups_cfg[gname]['main_host'] == None and g.main_host != None:
            g.main_host = None
            g.save()
        for hname in groups_cfg[gname]['hosts']:
            h = Host.objects.get(name = hname)
            rec, _ = GroupIncludesHost.objects.get_or_create(host = h, group = g)

    return redirect('/versionica/hostgroup' )


@login_required
@allowed(['developer'])
def refresh_default_property(r):
    cfg = yaml.load(open(settings.VERSIONICA_DEFAULT_PROPERTY_FILE))

    # группы из БД
    records = PropertyGroup.objects.all()
    for rec in records:
        if not rec.name in cfg:
            default = ''
        else:
            default = cfg[rec.name]
            del cfg[rec.name]

        rec.default_property = default
        rec.save()

    for propname in cfg:
        p = PropertyGroup.objects.create(
                name = propname,
                default_property = cfg[propname]
                )

    return redirect('/versionica/hostgroup' )


@login_required
@allowed(['developer', 'admin'])
def check_packages(r):

    rules = check_package_rules.check()

    return render_to_response('versionica/check_packages_result.html',
            {
                'rules': rules,
            },
            context_instance=RequestContext(r)
            )


@login_required
def is_deployed(r):
    return render_to_response('versionica/is_deployed.html',
            {
                'request': r,
            },
            context_instance=RequestContext(r)
            )


