# -*- encoding: utf-8 -*-

from django.conf import settings
from releaser.yambclient.models import DomainUsers

import urllib2
import json

import sys

sys.path.insert(0, '/opt/direct-chat-bot')
from bots import YambBot

class YambClient(object):
    def __init__(self, config=settings.YAMB_BOT_CONFIG):
        self.client = YambBot(config)


    def format_login(self, login):
        ind = login.find('@')
        if ind != -1:
            login = login[0:ind]
        return login


    def get_uid_by_login(self, login):
        try:
            uid = DomainUsers.objects.get(login=login).uid
        except DomainUsers.DoesNotExist:
            token = open(settings.STAFF_API_TOKEN_FILE).readline().rstrip()
            req = urllib2.Request('%s/persons?_one=1&_fields=uid&login=%s' % (settings.STAFF_API_URL, login))
            req.add_header('User-agent', settings.USER_AGENT)
            req.add_header('Authorization', 'OAuth %s' % (token))
            uid = json.loads(urllib2.urlopen(req).read())['uid']
            DomainUsers(login=login, uid=uid).save()
        return uid


    def send_message(self, login, text, formatter="yamb"):
        try:
            self.client.bot.sendMessage(self.get_uid_by_login(login), text, formatter=formatter)
        except:
            return False

        return True
