# -*- coding:utf-8 -*-

from django.core.management.base import BaseCommand
from django.db import models
from django.conf import settings

from optparse import make_option

from releaser.yambclient.models import DomainUsers
import urllib2
import json


class Command(BaseCommand):
    help = "Get uids for direct staff and write to database"
    option_list = BaseCommand.option_list + (
        make_option('--group', action='append', dest='groups',
            help='url of group for loading (default is yandex_monetize_tech)'),
        )

    def get_uids(self, groups):
        try:
            token = open(settings.STAFF_API_TOKEN_FILE).readline().rstrip()
            req = urllib2.Request('%s/persons?_page=1&_limit=1000&_fields=uid,login&official.is_dismissed=false&groups.group.ancestors.url=%s' % (settings.STAFF_API_URL, ','.join(groups)))
            req.add_header('User-agent', settings.USER_AGENT)
            req.add_header('Authorization', 'OAuth %s' % (token))
            return json.loads(urllib2.urlopen(req).read())['result']

        except:
            return

    def handle(self, **options):
        if not options['groups']:
            options['groups'] = ['yandex_monetize_tech']

        users = self.get_uids(options['groups'])
        for user in users:
            if not DomainUsers.objects.filter(login=user['login']).exists():
                DomainUsers(login=user['login'], uid=user['uid']).save()

        return
