# -* encoding: utf-8 -*-
from django.http import HttpResponse, Http404, HttpResponseNotFound
from django.shortcuts import render_to_response
from django.template import RequestContext

from django.conf import settings

import zookeeper
import re

def index(r, path):
    if path == None or path == '':
        path = '/'
    path = re.sub(r'//+', '/', path)
    stash = {'path': path, 'zoo_servers': settings.ZOOKEEPER_SERVERS}
    zkh = zookeeper.init(settings.ZOOKEEPER_SERVERS, None, 10000)
    if zookeeper.exists(zkh, path):
        stash['content'], stash['attrs'] = zookeeper.get(zkh, path)
    stash['children'] = [
        {'path': re.sub(r'/(.*?)/*[^/]+/*$', r'/\1', path),
         'title': '..'
         }
        ]
    stash['children'].extend([{'title': f, 'path': path + '/' + f} for f in zookeeper.get_children(zkh, path)])
    zookeeper.close(zkh)
    return render_to_response('zkbrowser/index.html', stash, context_instance=RequestContext(r))

