#!/usr/bin/env python
# -*- coding: utf-8 -*-

from kazoo.client import KazooClient
from kazoo.exceptions import NoNodeError


class ZookeeperClient(object):
    """
    клиент для работы с зукипером
    """

    COMMON_ZK_PREFIX = '/direct/versions_current'
    NO_VERSION_VALUE = u"0"
    ZK_HOSTS = "ppcback01f.yandex.ru,ppcback01e.yandex.ru,ppcback01i.yandex.ru"
    ZK_TIMEOUT = 10
    ZK_RETRY = {"max_tries": 1, "delay": 1, "max_jitter": 1, "backoff": 1, "ignore_expire": False}

    def __init__(self):
        self.zkh = KazooClient(
            hosts=self.ZK_HOSTS, timeout=self.ZK_TIMEOUT, connection_retry=self.ZK_RETRY, command_retry=self.ZK_RETRY
        )
        self.zkh.start()


    def get_version_from_zk(self, app, host):
        """
        получить текущую версию для заданного приложения и хоста
        """
        try:
            content = self.zkh.get("%s/%s/%s/dpkg" % (self.COMMON_ZK_PREFIX, app, host))[0]
            return content[:content.find("\n")]
        except NoNodeError:
            return self.NO_VERSION_VALUE


    def get_versions(self, app, hosts):
        """
        получить текущие версии пакетов приложения
        """
        return [self.get_version_from_zk(app, host) for host in hosts]


    def get_hosts2versions(self, app, hosts):
        """
        получить словарь для данного приложения: хост -> версия
        """
        return {host: self.get_version_from_zk(app, host) for host in hosts}


    def __del__(self):
        self.zkh.stop()

