#!/usr/bin/env python

from bummer import conductorCli as cc
import argparse

parser = argparse.ArgumentParser()
parser.add_argument('--project', type=str, required=True, help='conductor project')
parser.add_argument('--group', type=str, required=True, help='conductor group to add to')
parser.add_argument('--parent-group', type=str, required=True, help='conductor parent group')
parser.add_argument('--dc', type=str, required=True, help='datacenter')
parser.add_argument('hosts', type=str, nargs='*')
args = parser.parse_args()

try:
    cc.add_group(args.group, args.project, description='', parents=(args.parent_group,))
except Exception as e:
    print "Can't add conductor group: %s - %s" % (type(e), e)

for host in args.hosts:
    res = cc.add_host(host, args.group, datacenter=args.dc)
    print "added: " + host + " " + str(res)
