#!/usr/bin/env python
# -*- coding: utf-8 -*-

from __future__ import unicode_literals

import argparse
import json
import os
import sys
import requests
from urlparse import urljoin


NANNY_URL = 'https://nanny.yandex-team.ru/'
with open(os.path.expanduser('~/.scli/token'), 'r') as f:
    OAUTH_TOKEN = f.read().strip()

COPY_INSTANCES = False
COPY_AUTH_ATTRS = True


if __name__ == '__main__':
    session = requests.Session()
    session.headers['Authorization'] = 'OAuth {}'.format(OAUTH_TOKEN)
    session.headers['Content-Type'] = 'application/json'

    source_service = sys.argv[1]
    destination_service = sys.argv[2]
    category = sys.argv[3]
    desc = sys.argv[4]

    events_url = urljoin(NANNY_URL, 'v2/services/{}/copies/'.format(source_service))

    req = {
        'id': destination_service,
        'copy_auth_attrs': COPY_AUTH_ATTRS,
        'copy_instances': COPY_INSTANCES,
        'category': category,
        'desc': desc,
    }

    print session.headers
    print events_url
    print json.dumps(req)

    result = session.post(events_url, data=json.dumps(req), verify='/usr/share/yandex-internal-root-ca/YandexInternalRootCA.crt')
    print result.status_code
    print result.text
