#!/bin/bash -ex
curdir=$(pwd | sed 's/.*\///')
repo=${curdir%_*}
name=${curdir#*_}

# FROM registry.yandex.net/ppc/percona-mysql56:latest
if [ -n "$FULL_REBUILD" -a x"$(grep FROM Dockerfile | cut -d/ -f2- | cut -d: -f2 | sed -E 's/\s+//g')" = x"latest" ]; then
    from_dir=$(grep FROM Dockerfile | cut -d/ -f2- | cut -d: -f 1 | sed 's/\//_/')
    echo "build $from_dir first"
    cd ../$from_dir
    ./build.sh
    ./upload.sh
    cd ../$curdir
fi

docker build --no-cache -t registry.yandex.net/$repo/$name:latest .
