#!/bin/bash -ex

export LSB_RELEASE=trusty
export DEBIAN_FRONTEND=noninteractive
export APT="apt-get install --yes --force-yes --no-install-recommends"

# project repos
export PROJECT=direct-mod
printf "Package: *\nPin: origin "'"${PROJECT}-*.dist.yandex.ru"'"\nPin-Priority: 650\n" > /etc/apt/preferences.d/80-${PROJECT}
printf "deb http://${PROJECT}-${LSB_RELEASE}.dist.yandex.ru/${PROJECT}-${LSB_RELEASE}/ stable/all/\ndeb http://${PROJECT}-${LSB_RELEASE}.dist.yandex.ru/${PROJECT}-${LSB_RELEASE}/ stable/amd64/\n" > /etc/apt/sources.list.d/direct-mod.list

# packages
apt-get update || exit 1

# monrun hack, пока слишком много зависит от monrun =(
#RUN echo "127.0.1.1 $(hostname).fix.monrun $(hostname)" >> /etc/hosts
$APT monrun=1.3.5 juggler-client=2.3.12060547 || true
perl -i -lpe 's/hostname\.strip\("\."\)\.lower\(\)/"local01z.host.monrun"/' /usr/lib/monrun/utils/gethostname.py
apt-get -f install

$APT \
percona-server-client-5.6=5.6.28-76.1-1.trusty \
percona-server-common-5.6=5.6.28-76.1-1.trusty \
percona-server-server-5.6=5.6.28-76.1-1.trusty \
libperconaserverclient18.1=5.6.28-76.1-1.trusty # || true
#RUN echo "exit 0" > /var/lib/dpkg/info/percona-server-server-5.6.postinst && apt-get -f install

$APT yandex-du-lm mysql-utilities

# directmod packages
. /provision/config.sh

$APT $PROJECT_MYSQL_PACKAGE
