#!/bin/bash
exec >> /tmp/startup.log 2>&1
set -x

. /provision/config.sh

# убеждаемся в налиичии необходимого окружения
export PATH=/usr/local/sbin:/usr/local/bin:/sbin:/bin:/usr/sbin:/usr/bin
. /etc/profile.d/locale.sh
. /etc/profile.d/tz.sh

# делаем директории персистентными
export STORAGE_DIR=ephemeral
if [ -d /storage ]; then
    export STORAGE_DIR=storage
fi
export PERSISTENT_DIRS="opt/mysql.$MYSQL_INSTANCE opt/tmp var/log"
container-prepare-persistent-storage

# в пакетах модерации этого нет, но и в любом случае не помешает
mkdir -p /opt/mysql.$MYSQL_INSTANCE/{bin-logs,relay-logs,data}
chown mysql: -R /opt/mysql.$MYSQL_INSTANCE/
chmod u=rwX,g=rwX,o=rX -R /opt/mysql.$MYSQL_INSTANCE/
##printf "[mysqld]\ngtid_mode = ON\nenforce_gtid_consistency = ON\n" > /etc/mysql/$MYSQL_INSTANCE.conf.d/gtid.cnf

#cat > /etc/mysql/$MYSQL_INSTANCE.conf.d/info-repos.cnf <<EOF
#[mysqld]
#master-info-repository = TABLE
#relay-log-info-repository = TABLE
#EOF

cat > /etc/mysql/$MYSQL_INSTANCE.conf.d/slave-host.cnf <<EOF
[mysqld]
report-host = $QLOUD_DISCOVERY_INSTANCE
EOF

# инициализируем пустую базу
if ! [ -e /opt/mysql.$MYSQL_INSTANCE/mysql-installed ]; then
    set -e
    echo "Install empty mysql db"
    lm $MYSQL_INSTANCE installdb --force
    printf "[mysqld]\nserver-id = $RANDOM\n" > /opt/mysql.$MYSQL_INSTANCE/data/server-id.cnf
    set +e
    touch /opt/mysql.$MYSQL_INSTANCE/mysql-installed
fi
cp /opt/mysql.$MYSQL_INSTANCE/data/server-id.cnf /etc/mysql/$MYSQL_INSTANCE.conf.d/server-id.cnf

# включаем необходимые сервисы
svmgr install mysql.$MYSQL_INSTANCE /provision/mysqld.run
svmgr install container-http-hooks /provision/container-http-hooks.run

# sshd уже установлен в базовом образе
svmgr enable sshd
svmgr enable mysql.$MYSQL_INSTANCE
svmgr enable container-http-hooks

# запускаем runit
exec /usr/sbin/runsvdir-start
