#!/bin/bash -ex
# common ppc layer

export LSB_RELEASE=trusty
export DEBIAN_FRONTEND=noninteractive

# куча printf осталось от старой сборки докера, можно переписать аккуратнее
# apt preferences and configs
rm /etc/apt/sources.list.d/* >/dev/null 2>&1 || true
printf "deb http://mirror.yandex.ru/ubuntu ${LSB_RELEASE} main restricted universe multiverse\ndeb http://mirror.yandex.ru/ubuntu ${LSB_RELEASE}-updates main restricted universe multiverse\ndeb http://mirror.yandex.ru/ubuntu ${LSB_RELEASE}-security main restricted universe multiverse\n#deb http://mirror.yandex.ru/ubuntu ${LSB_RELEASE}-backports main restricted universe multiverse\n" > /etc/apt/sources.list
printf 'Package: *\nPin: origin "direct-*.dist.yandex.ru"\nPin-Priority: 590\n\nPackage: *\nPin: origin "*dist.yandex.ru"\nPin-Priority: 500\n\nPackage: *\nPin: origin "mirror.yandex.ru"\nPin-Priority: 500\n' > /etc/apt/preferences.d/90-all-projects
printf 'APT::Install-Recommends "false";\n' > /etc/apt/apt.conf.d/97noinstallrecommends

apt-get update -q2
apt-get install --yes --force-yes --no-install-recommends curl

# direct common repos
curl -s http://dist.yandex.ru/REPO.asc | apt-key add -
printf "deb http://common.dist.yandex.ru/common/ stable/all/\ndeb http://common.dist.yandex.ru/common/ stable/amd64/\ndeb http://direct-common.dist.yandex.ru/direct-common/ stable/all/\ndeb http://direct-common.dist.yandex.ru/direct-common/ stable/amd64/\ndeb http://direct-${LSB_RELEASE}.dist.yandex.ru/direct-${LSB_RELEASE}/ stable/all/\ndeb http://direct-${LSB_RELEASE}.dist.yandex.ru/direct-${LSB_RELEASE}/ stable/amd64/\ndeb http://search-kernel.dist.yandex.ru/search-kernel stable/all/\ndeb http://search-kernel.dist.yandex.ru/search-kernel stable/amd64/\ndeb http://system.dist.yandex.ru/system/ ${LSB_RELEASE}/all/\ndeb http://system.dist.yandex.ru/system/ ${LSB_RELEASE}/amd64/\ndeb http://yandex-${LSB_RELEASE}.dist.yandex.ru/yandex-${LSB_RELEASE}/ stable/all/\ndeb http://yandex-${LSB_RELEASE}.dist.yandex.ru/yandex-${LSB_RELEASE}/ stable/amd64/\n" > /etc/apt/sources.list.d/common.list

# locale
locale-gen en_US.UTF-8
echo 'LANG="en_US.UTF-8"' > /etc/default/locale
printf 'LC_ALL="en_US.UTF-8"\nLANG="en_US.UTF-8"\n' >> /etc/environment
printf 'export LC_ALL="en_US.UTF-8"\nexport LANG="en_US.UTF-8"\n' > /etc/profile.d/locale.sh

# dash to bash and TZ
rm /bin/sh
ln /bin/bash /bin/sh
echo 'Europe/Moscow' > /etc/timezone
echo 'TZ="Europe/Moscow"' >> /etc/environment
echo 'export TZ="Europe/Moscow"' > /etc/profile.d/tz.sh
rm /etc/localtime
ln -sf /usr/share/zoneinfo/Europe/Moscow /etc/localtime
dpkg-reconfigure --frontend noninteractive tzdata

cat /provision/data/etc_bash.bashrc > /etc/bash.bashrc
cat /provision/data/root.bashrc > /root/.bashrc

# base packages
apt-get update -q2
apt-get install --yes --force-yes --no-install-recommends \
atop \
bind9-host \
bash-completion \
curl \
dnsutils \
debsums \
dstat \
file \
gdb \
git \
iotop \
iptables \
jq \
less \
lsof \
ltrace \
netcat-traditional \
netcat-openbsd \
pv \
patch \
psmisc \
python \
python3 \
rsync \
runit \
screen \
strace=4.12-3ubuntu1unwind \
socat \
ssh \
sysstat \
tcpdump \
telnet \
tmux \
traceroute \
vim \
wget \
yandex-internal-root-ca \
yandex-du-container-helpers \
yandex-du-svmgr

rm -rf /etc/sv/getty-5/

# root ssh pubkey
mkdir -p /root/.ssh
chown root:root /root/.ssh
chmod 0700 /root/.ssh
cat /provision/data/root.authorized_keys > /root/.ssh/authorized_keys
chmod 0600 /root/.ssh/*

# sshd на отдельном порту, чтобы ноды могли общаться
# симлинки на сервисы тут не делаются, в конечном образе можно включать по необходимости (svmgr enable sshd, ...)
cat /provision/data/sshd_config > /etc/ssh/sshd_config
sed 's@session\s*required\s*pam_loginuid.so@session optional pam_loginuid.so@g' -i /etc/pam.d/sshd
mkdir -p /var/run/sshd
chmod 0700 /var/run/sshd
svmgr install sshd /provision/data/sshd.run
