#!/usr/bin/env python

from bummer import conductorCli as cc
import argparse

parser = argparse.ArgumentParser()
parser.add_argument('--alias-prefix', type=str, help='conductor group to add to')
parser.add_argument('hosts', type=str, nargs='*')
args = parser.parse_args()

num = 1
for host in sorted(args.hosts):
    alias = '%s%03d' % (args.alias_prefix, num)
    res = cc.add_tag_to_host(host, 'host_alias=' + alias)
    num += 1
    print "added: %s %s" % (host, alias)
