#!/usr/bin/python

import json
import sys

usage_msg = '''
  Usage: {0} tl|list
  Examples:
    curl -s https://proxy.sandbox.yandex-team.ru/1526139199 | {0} tl     # produce a timeline chart from package_evlog_1.json
    curl -s https://proxy.sandbox.yandex-team.ru/1526139199 | {0} list   # produce a list of events by thread from package_evlog_1.json
'''.format(sys.argv[0])
if len(sys.argv) != 2:
    sys.exit('error: incorrect number of arguments\n' + usage_msg)

events_for_thread = {}
last_event_for_thread = {}
first_timestamp = None
last_timestamp = None
while True:
    line = sys.stdin.readline()
    if line == '':
        break
    r = json.loads(line)
    if 'event' not in r:
        continue
    if r['event'] == 'node-started':
        if not first_timestamp:
            first_timestamp = r['timestamp']
        thread = r['thread_name']
        if thread not in events_for_thread:
            events_for_thread[thread] = []
        event = {}
        event['started'] = r['timestamp']
        event['name'] = r['value']['name']
        if thread in last_event_for_thread and int(event['started'] - last_event_for_thread[thread]['finished']) > 1:
            events_for_thread[thread].append({
                'name':'waiting',
                'started':last_event_for_thread[thread]['finished'],
                'finished':event['started'],
            })
        events_for_thread[thread].append(event)
        last_event_for_thread[thread] = event
    if r['event'] == 'node-finished':
        thread = r['thread_name']
        last_event_for_thread[thread]['finished'] = r['timestamp']
        last_timestamp = r['timestamp']

if sys.argv[1] == 'list':
    for thread in sorted(events_for_thread.keys()):
        for event in events_for_thread[thread]:
            offset = int(event['started'] - first_timestamp)
            offset_min = int(offset/60)
            offset_sec = offset % 60
            offset2 = int(event['finished'] - first_timestamp)
            offset2_min = int(offset2/60)
            offset2_sec = offset2 % 60
            print '{:10s} {:4d} {:02d}:{:02d} {:02d}:{:02d} {}'.format(thread, int(event['finished'] - event['started']), offset_min, offset_sec, offset2_min, offset2_sec, event['name'])

if sys.argv[1] == 'tl':
    print '''
_ - loading Sandbox resource
X - building
C - working with cache
D - download from DistBuild
. - waiting
? - other
'''
    print ' ' * len('..:..-..:.. ') + ' '.join(['%02d' % int(t.split('-')[1]) for t in sorted(events_for_thread.keys())])
    ts = first_timestamp
    step = 20
    event_index_for_thread = {}
    for t in events_for_thread:
        event_index_for_thread[t] = 0
    while ts < last_timestamp:
        ts2 = ts + step
        offset = int(ts - first_timestamp)
        offset_min = int(offset/60)
        offset_sec = offset % 60
        offset2 = int(ts2 - first_timestamp)
        offset2_min = int(offset2/60)
        offset2_sec = offset2 % 60
        sys.stderr.write('%02d:%02d-%02d:%02d ' % (offset_min, offset_sec, offset2_min, offset2_sec))
        for t in sorted(events_for_thread.keys()):
            event_index = event_index_for_thread[t]
            while event_index < len(events_for_thread[t]) and events_for_thread[t][event_index]['finished'] <= ts:
                event_index += 1
            event_index_for_thread[t] = event_index
            if event_index >= len(events_for_thread[t]) or event['finished'] <= ts:
                sym = ' '
            else:
                name = events_for_thread[t][event_index]['name']
                sym = '?'
                if name.startswith('Resource'):
                    sym = '_'
                elif name.startswith('Run'):
                    sym = 'X'
                elif 'Cache' in name:
                    sym = 'C'
                elif name.startswith('DistDownload'):
                    sym = 'D'
                elif name == 'waiting':
                    sym = '.'
            sys.stdout.write(sym + '  ')
        print
        ts = ts2
