#!/usr/bin/perl

use strict;
use warnings;

use IPC::Open3;
use Time::HiRes qw/gettimeofday tv_interval usleep ualarm/;

use ScriptStarter::Log;
use ScriptStarter::Middleware::Innermost;
use ScriptStarter::Middleware::Timer;
use ScriptStarter::Middleware::Tee;

$|++;

my $file_stdout = "/tmp/lena-san/script-starter-stdout";
my $file_stderr = "/tmp/lena-san/script-starter-stderr";
my $file_log = "/tmp/lena-san/script-starter-log";

my $params = {
    Timer => {
        timeout => 10,
    },
};


=head1 

perl -Ilib ./bin/script-starter.pl perl -le 'print STDERR "".localtime(); sleep 3; print STDERR "".localtime();sleep 30;'

TODO 

  * описать интерфейс, который должна давать обертка (Middleware)
  * настоящее логгирование
  * в обертки передавать знание о том, что именно запускается (например, просто в конструкторе)
  * захочется обертку, которая перезапускает воркера, если он умирает (воркер -- демон). 
  Помещается ли это в концепцию? 
  Как извещать остальных про то, что произошел новый запуск?
  Или механизм повторного запуска оставить в стартере, а из оберток только сообщать, что перезапуск требуется (например, результатом after())
  * STDOUT, STDERR воркера писать в случайные временные файлы; после открытия всех нужных дескрипторов файлы unlink'ать
  * запрещающие before (для switchman и т.п.)
  * предохранитель на размер std(out|err): по достижении порога прибивать воркера (чтобы не забил диск ворнингами, например)
  * если надо прибить воркера -- делать аккуратно, как в Switchman: сначала SIGINT, только потом SIGKILL
  * понимать конфигурационные файлы
  * сделать из Switchman плагин-обертку

  * сможем ли заопенсорсить?
  * красивое (абстрактное) имя

=cut

run() unless caller();

sub run 
{
    my $log = ScriptStarter::Log->new(filename => $file_log);
    open CHILD_STDOUT, '>', $file_stdout or die "Error: $!";
    open CHILD_STDERR, '>', $file_stderr or die "Error: $!";
    my $filehandles_to_close = [ \*CHILD_STDOUT, \*CHILD_STDERR ];
    my $middlewares = [];
    # сначала внутренние, потом внешние
    for my $name (qw/Innermost Timer Tee/) {
        open my $fh_stdout_ro, '<', $file_stdout or die "Error: $!";
        open my $fh_stderr_ro, '<', $file_stderr or die "Error: $!";
        push @$filehandles_to_close, $fh_stdout_ro, $fh_stderr_ro;
        my $m = "ScriptStarter::Middleware::$name"->new(
            log => $log, 
            fh_stdout => $fh_stdout_ro,
            fh_stderr => $fh_stderr_ro,
            %{$params->{$name}||{}},
        );
        push @$middlewares, $m;
    }

    for my $m ( reverse @$middlewares ){
        # TODO если before() возвращает не "" -- умирать 
        $m->before();
    }

    my $CHILD_PID = open3( "<&", ">&CHILD_STDOUT", ">&CHILD_STDERR", @ARGV ) or die "Can't call Open3: $!";

    $_->{child_pid} = $CHILD_PID for @$middlewares;

    eval{
        while (1) {
            my $t0 = [gettimeofday()]; 
            for my $m ( @$middlewares ){
                eval{
                    local $SIG{ALRM} = sub {die "timeout"};
                    ualarm (100_000);
                    $m->while();
                    ualarm (0);
                };
                die $@ if $@ && $@ ne "timeout";
            }
            my $e=tv_interval ( $t0 ); 
            my $to_sleep = 1_000_000 - int($e * 1_000_000);
            usleep $to_sleep if $to_sleep > 1_000;
        }
    };
    # TODO проверять, почему именно вышли

    for my $m ( @$middlewares ){
        $m->after();
    }

    close $_ for @$filehandles_to_close;

    return '';
}

