use strict; 
use warnings;

package ScriptStarter::Log;

use POSIX qw/strftime/;

sub new
{
    my $this = shift;
    my $class = ref($this) || $this;

    my $self = {@_};
    bless $self, $class;

    open $self->{fd}, ">>:utf8", $self->{filename} or die "Can't open $self->{filename}: $!";
    $self->{fd}->autoflush(1);

    return $self;
}


sub out
{
    my $self = shift;

    my $date_str = strftime("%Y-%m-%d\t%H:%M:%S", localtime());
    $self->{fd}->print(map {"$date_str\t$$\t$_\n"} @_);
    
    return '';
}


sub DESTROY
{
    my $self = shift;

    if ($self->{fd} && $self->{fd}->opened()) {
        $self->{fd}->close();
    }
}

1;

