use strict;
use warnings;

# базовый класс для оберток

package ScriptStarter::Middleware::Base;

sub new 
{
    my ($class, @data) = @_;
    return bless { child_pid => '', @data}, $class;
}

sub before
{
    my ($self) = @_;
    return '';
}

sub after 
{
    my ($self) = @_;
    return '';
}

sub while
{
    my ($self) = @_;
    return '';
}

sub log
{
    my $self = shift;
    
    my @messages = map { (ref $self)." $_" } @_;

    $self->{log}->out(@messages);
}

# TODO сначала посылать SIGINT -- см. switchman
sub kill_child
{
    my ($self, $reason) = @_;
    $reason = '' unless defined $reason;

    $self->log("going to KILL child $self->{child_pid}, reason: $reason ");

    kill 9 => $self->{child_pid};

    $self->log("KILLed child $self->{child_pid}, reason: $reason");
}

1;

