use strict;
use warnings;

# служебная обертка: устанавливает нужные обработчики на сигналы

package ScriptStarter::Middleware::Innermost;

use base "ScriptStarter::Middleware::Base";

sub before
{
    my ($self) = @_;
    # We want to exit right after our child dies
    $SIG{CHLD} = sub {
        my $pid = wait;
        my $status = $?;
        if ($status == -1) {
            $self->log("\$SIG{CHLD}, failed to execute: $!");
        } elsif ($status & 127) {
            $self->log(sprintf("\$SIG{CHLD}, child died with signal %d, %s coredump",
            ($status & 127),  ($status & 128) ? 'with' : 'without'));
        }
        else {
            $self->log(sprintf("\$SIG{CHLD}, child exited with value %d", $status >> 8));
        }

        die "Child $pid exited with $status\n";
    };

    my $CHILD = \$self->{child_pid};

    # If we suddenly die, we won't leave our child alone
    # Otherwise the process will be active and not holding the lock
    # TODO проверить, как работает
    # писать в лог, что умираем -- в любом случае
    $SIG{__DIE__} = sub {
        my $msg = shift;
        chomp $msg;
        return '' if $msg =~ m{Can't locate Mo/(builder|default)\.pm};
        if ($$CHILD && kill 0 => $$CHILD) {
            $self->log("Parent is terminating abnormally ($msg), killing child $CHILD");
            kill 9 => $CHILD or $self->log("Failed to KILL $CHILD");
        }
    };
    $SIG{TERM} = $SIG{INT} = sub {
        my $signame = shift;
        warn "Parent received SIG$signame, terminating child $CHILD\n";
        if (kill $signame => $CHILD) {
            $self->log("Sent SIG$signame to $CHILD");
            sleep 1; # wait for process cleanup
        }
        if (kill 0 => $CHILD) {
            $self->log("Failed to $signame $CHILD");
        } else {
            exit;
        }
    };
}


1;
