use strict; 
use warnings;

# читает stdout и stderr воркера и печатает их 

package ScriptStarter::Middleware::Tee;

use base "ScriptStarter::Middleware::Base";

sub while
{
    my $self = shift;
    return $self->_read_and_print()
}

sub after
{
    my $self = shift;
    return $self->_read_and_print()
}


sub _read_and_print
{
    my $self = shift;
    my ($fh_stdout, $fh_stderr) = ($self->{fh_stdout}, $self->{fh_stderr});
    while (my $o = <$fh_stdout>){
        print "> $o" if $o;
    }
    while (my $e = <$fh_stderr>){
        print ">> $e" if $e; 
    }
    return '';
}

1;

