#!/usr/bin/env perl

use strict;
use warnings;
use utf8;

use Test::More;
use Test::Deep;

use ScriptsMetadata;

local %Yandex::ScriptDistributor::CONF = (
    test => {
        distribution => {
            shard_1 => {
                heavy => 2,
                easy => 2,
                heavy2 => 1
            },
            shard_3 => {
                heavy => 2,
                easy => 2,
                heavy2 => 3
            },
            shard_default => {
                heavy => 1,
                easy => 1,
                heavy2 => 2
            }
        }
    }
);
our $SHARDS_NUM = 3;
local $Yandex::ScriptDistributor::SHARDS_NUM_REF = \$SHARDS_NUM;

my @test_cases_positive = (
    {
        in => [
            {
                sharded => 0, 
            },
            shard_num => 5,
        ],
        expected_out => [
            { },
        ],
    },

    {
        in => [
            {
                distributed => 1,
                sharded => 0,
            },
            script_name => 'aaa/bbb/test.why',
        ],
        expected_out => [
            { run_id => "1"},
            { run_id => "2"},
            { run_id => "3"},
            { run_id => "4"},
            { run_id => "5"},
            { run_id => "6"},
            { run_id => "7"},
            { run_id => "8"},
            { run_id => "9"},
            { run_id => "10"},
            { run_id => "11"},
            { run_id => "12"},
            { run_id => "13"},
            { run_id => "14"},
            { run_id => "15"},
            { run_id => "16"},
        ],
    },
);

my $i = 1;
for my $t ( @test_cases_positive ){
    cmp_deeply( [ScriptsMetadata::process_multiplicators(@{$t->{in}})], $t->{expected_out}, $t->{title} // "positive test #".$i++ );
}

done_testing;
