#!/usr/bin/perl

use strict;
use warnings;
use utf8;

use List::MoreUtils qw/uniq/;
use Test::More;

use ScriptsMetadata;

*rd = \&ScriptsMetadata::randomized_time;

# строки, не подходящие под */NN.* не меняются
my @unchange_tests = (
    '1 */2 * * *',
    '* 2 * * *',
    '32 * * * *',
    '2-45/4 */3 * * *',
    );
for my $str (@unchange_tests) {
    is(rd($str), $str, "time like '$str' leave unchanged");
}

# для остальных строк проверяем, что получается что-то похожее на правду
my @tests = (
    '*/4 * * * *',
    '*/10 * * 1 *',
    '*/5 * 3 * *',
    '*/4 */3 * * *',
    );
for my $str (@tests) {
    my $rest = [split /\//, $str, 2]->[1];
    my $re = qr/^\d+-59\/\Q$rest\E$/;
    like(rd($str), $re, '$str w/o params');
    like(rd($str, 'key'), $re, '$str w/o params');
    for my $i (undef, 0..3) {
        like(rd($str, 'key', $i, 4), $re, '$str w/o params');
        # при одинаковом ключе, данные не меняются
        is(rd($str, 'key', $i, 4), rd($str, 'key', $i, 4));
        # при разных ключах - меняются
        cmp_ok(scalar(uniq map {rd($str, "key$_", $i, 4)} 1..10), '>', 1);
    }
}

done_testing;
