#!/usr/bin/perl

use strict;
use warnings;
use utf8;

use Test::More;

use ScriptsMetadata;
use Yandex::Metadata;

# [ 'metadata', $test_name ]
my @tests_ok = (
    [
        '<crontab>
            time: */59 * * * *
            sharded: 1
            package: scripts-switchman
        </crontab>',
        'crontab',
    ],
    [
        '<crontab>
            time: */59 * * * *
            sharded: 1
            package: scripts-switchman
            <switchman>
                group: scripts-other
                lockname: mylockname
                <leases>
                    FQDN_mem: 50
                </leases>
            </switchman>
        </crontab>',
        'crontab with switchman',
    ],
    [
        '<crontab>
            time: */59 * * * *
            sharded: 1
            package: scripts-switchman
            <switchman>
                group: scripts-other
                lockname: mylockname
                <leases>
                    mem: 50
                </leases>
            </switchman>
        </crontab>',
        'crontab with switchman and custom mem lease name',
        {
            MEM_NAME_IN_META => 'mem',
        },
    ],
);
my @tests_fail = (
    [
        '<crontab>
            time: */59 * * * *
            sharded: 1
            package: scripts-other
            <switchman>
                group: scripts-other
                <leases>
                    FQDN_mem: 50
                </leases>
            </switchman>
        </crontab>',
        'crontab with bad switchman package',
    ], [
        '<crontab>
            time: */59 * * * *
            sharded: 1
            package: scripts-switchman
            <switchman>
                gruop: scripts-other
                lockname: mylockname
                <leases>
                    FQDN_mem: 50
                </leases>
            </switchman>
        </crontab>',
        'crontab with typo in switchman group field',
    ], [
        '<crontab>
            time: */59 * * * *
            sharded: 1
            package: scripts-switchman
            <switchman>
                group: scripts-other
                locknmae: mylockname
                <leases>
                    FQDN_mem: 50
                </leases>
            </switchman>
        </crontab>',
        'crontab with typo in switchman lockname field',
    ], [
        '<crontab>
            time: */59 * * * *
            sharded: 1
            package: scripts-switchman
            <switchman>
                group: scripts-other
                lockname: mylockname
                <lease>
                    FQDN_mem: 50
                </lease>
            </switchman>
        </crontab>',
        'crontab with typo in switchman leases field',
    ], [
        '<crontab>
            time: */59 * * * *
            sharded: 1
            package: scripts-switchman
            <switchman>
                group: scripts-other
                lockname: mylockname
                <leases>
                    FQND_mem: 50
                </leases>
            </switchman>
        </crontab>',
        'crontab with typo in switchman lease name',
    ], [
        '<crontab>
            time: */59 * * * *
            sharded: 1
            package: scripts-switchman
            <switchman>
                group: scripts-other
                lockname: mylockname
                <leases>
                    donuts: 50
                </leases>
            </switchman>
        </crontab>',
        'crontab with unknown lease in switchman conf',
    ],
    [
        '<crontab>
            time: */59 * * * *
            sharded: 1
            distributed: 1
            package: scripts-switchman
        </crontab>',
        'crontab with sharded and distributed',
    ],
    [
        '<crontab>
            time: */59 * * * *
            sharded: 1
            package: scripts-switchman
            <switchman>
                group: scripts-other
                lockname: mylockname
                <leases>
                    FQDN_mem: 50
                </leases>
            </switchman>
        </crontab>',
        'old crontab with default (instead of custom) mem lease name',
        {
            MEM_NAME_IN_META => 'mem',
        },
    ],
);

Test::More::plan(tests => scalar(@tests_ok) + scalar(@tests_fail));

for my $is_error_expected (0, 1) {
    for my $test ($is_error_expected ? @tests_fail : @tests_ok) {
        $test->[2] //= {};
        local $ScriptsMetadata::MEM_NAME_IN_META = $test->[2]->{MEM_NAME_IN_META} if $test->[2]->{MEM_NAME_IN_META};
        my $metadata = deserialize_metadata($test->[0]);
        my @errors = ScriptsMetadata::validate_crontab($metadata->{crontab},
                                                       package_prefix => 'yandex-direct',
                                                       switchman_packages => [qw(scripts-switchman)],
                                                       switchman_leases => [$ScriptsMetadata::MEM_NAME_IN_META],
                                                       );
        ok((@errors ? 1 : 0) == $is_error_expected, ($is_error_expected ? 'should fail: ' : 'should pass: ') . $test->[1]);
    }
}
