#!/usr/bin/perl

use strict;
use warnings;

use Test::More;

use ScriptsMetadata;

use utf8;

# [ {name => , expression =>, crit =>, ...}, $is_error_expected, $test_name ]
my @tests = (
    [
        {
            name => 'test',
            crit => 666,
            expression => 'test.expression.$shard',
            sharded => 1,
        },
        0,
        '$shard in sharded check',
    ], [
        {
            name => 'test',
            crit => 666,
            expression => 'test.expression.$shard',
            sharded => 1,
            juggler_host => 'test_checks.direct.yandex.ru',
        },
        0,
        'juggler_host in check',
    ], [
        {
            name => 'test',
            crit => 666,
            expression => 'test.expression',
            juggler_host => 'test_checks.direct.yandex.ru',
            juggler_host => 'test-1.direct.yandex.ru',
        },
        0,
        'two juggler_hosts in check',
    ], [
        {
            name => 'test',
            crit => 666,
            expression => 'test.expression',
            juggler_host => 'test_checks!direct.yandex.ru',
        },
        1,
        'invalid juggler_host in check',
    ], [
        {
            name => 'test',
            crit => 666,
            expression => 'test.expression.$shard',
        },
        1,
        '$shard in non-sharded check',
    ], [
        {
            name => 'test with space',
            crit => 666,
            expression => 'test.expression',
        },
        1,
        'invalid warn format',
    ], [
        {
            name => 'test',
            crit => '666s',
            expression => 'test.expression',
        },
        1,
        'invalid crit format',
    ], [
        {
            name => 'test',
            warn => '666s',
            expression => 'invalid warn format',
        },
        1,
        'invalid characters in name',
    ], [
        {
            name => 'test',
            crit => 666,
            sharded => 1,
            expression => 'test.expression',
        },
        1,
        'sharded without $shard in expression',
    ], [
        {
            name => 'test',
            expression => 'test.expression',
        },
        1,
        'no crit or warn parameters in check',
    ], [
        {
            name => 'test',
            expression => 'test.expression.$queue',
            warn => 10,
            vars => 'queue=std;heavy'
        },
        1,
        'bad vars format',
    ],
);

Test::More::plan(tests => scalar(@tests));

for my $test (@tests) {
    my ($conf, $is_error_expected, $test_name) = @$test;
    my @errors = ScriptsMetadata::validate_monrun($conf);
    my $has_errors = (@errors) ? 1 : 0;
    is($has_errors, $is_error_expected, $test_name);
}
