#!/bin/bash
# change-mod-beta.sh: на бете Модерации поменять бету Директа, на которую она смотрит.
# С появлением многослойных конфигов перестанет быть актуален.

mod_beta_path=$1
direct_beta_port=$2

if [ -z $mod_beta_path ]
then
    echo 'missing moderation beta path'
    echo 'usage: change-direct-beta.sh <mod_beta_path> <direct_beta_port>'
    exit 1
fi

if [ -z $direct_beta_port ]
then
    echo 'missing direct beta port'
    echo 'usage: change-direct-beta.sh <mod_beta_path> <direct_beta_port>'
    exit 1
fi

dev1_re='^8[0-9]{3}$'
dev2_re='^9[0-9]{3}$'
dev3_re='^10[0-9]{3}$'
dev4_re='^11[0-9]{3}$'
dev5_re='^12[0-9]{3}$'
dev6_re='^13[0-9]{3}$'
if [[ $direct_beta_port =~ $dev1_re ]]
then
    direct_server_name="beta1.direct"
elif [[ $direct_beta_port =~ $dev2_re ]]
then
    direct_server_name="beta2.direct"
elif [[ $direct_beta_port =~ $dev3_re ]]
then
    direct_server_name="beta3.direct"
elif [[ $direct_beta_port =~ $dev4_re ]]
then
    direct_server_name="beta4.direct"
elif [[ $direct_beta_port =~ $dev5_re ]]
then
    direct_server_name="beta5.direct"
elif [[ $direct_beta_port =~ $dev6_re ]]
then
    direct_server_name="beta6.direct"
else
    echo 'invalid direct beta port number'
    exit 1
fi

sed -i "s/[0-9]\{4,5\}\.beta[0-9]\.direct\.yandex\.ru/$direct_beta_port.$direct_server_name\.yandex.ru/g" $mod_beta_path/protected/SettingsLocal.pm
direct-mk $mod_beta_path beta-postupdate
