#!/bin/bash
# change-direct-beta.sh: на бете Директа поменять бету Модерации, на которую она смотрит.
# С появлением многослойных конфигов перестанет быть актуален.

direct_beta_path=$1
mod_beta_port=$2

if [ -z $direct_beta_path ]
then
    echo 'missing direct beta path'
    echo 'usage: change-mod-beta.sh <direct_beta_path> <mod_beta_port>'
    exit 1
fi

if [ -z $mod_beta_port ]
then
    echo 'missing moderation beta port'
    echo 'usage: change-mod-beta.sh <direct_beta_path> <mod_beta_port>'
    exit 1
fi

dev1_re='^8[0-9]{3}$'
dev2_re='^9[0-9]{3}$'
if [[ $mod_beta_port =~ $dev1_re ]]
then
    mod_server_name="ppcmoddev1"
elif [[ $mod_beta_port =~ $dev2_re ]]
then
    mod_server_name="ppcmoddev2"
else
    echo 'invalid moderation beta port number'
    exit 1
fi

sed -i "s/ppcmoddev[1-2]\.yandex\.ru:[0-9]\{4\}/$mod_server_name\.yandex.ru:$mod_beta_port/g" $direct_beta_path/perl/settings/SettingsLocal.pm
direct-mk $direct_beta_path beta-postupdate
