#/bin/sh

# $Id$

# ctags для Директа (придумал msa)
# запускать из корневого каталога беты
#
# собираются обычные теги для perl и javascript-файлов
# + для функций типа "cmd_doSmth" добавляются теги без префикса "cmd_" (для переходов с redirect("?cmd=doSmth"); )
# + добавляются теги для html-шаблонов (для переходов с $template->process('some_page.html'); )
# + добавляются js-функции в html-файлах
# 
# grep -E -v '^.{300,}' выкидывает слишком длинные строчки (простой способ побороть нечеловеческие js)
# без LANG=C подозрительно работает sort: при сравнении строк игнорирует подчеркивания '_'
# 

#TODO 
# теги для файлов скриптов, напр. ppcSuggest.pl
# если есть повторяющиеся теги -- добавлять суффиксы _html, _css, _perl

ctags -f tagsunsorted --languages=Perl,JavaScript --totals -R '--exclude=*.pl' '--exclude=data/lego/*' '--exclude=data/block/*' '--exclude=data/js-c/*'

# find all templates and javascripts
find data/ -name '*.html' -or -name '*.htm' -or -name '*.js' -or -name '*.css' \
  | grep -v 'data/t/seminar' \
  | grep -v 'data/block' \
  | grep -v 'data/lego' \
  | perl -pe 'chomp $_; /data.*\/([^\/\.]+)\./; $_ = "$1\t$_\t1;\"\tF\n"' >> tagsunsorted

# find all js funtions in html
find data/t/ -name '*.html' -or -name '*.htm'  \
  | xargs ctags -f - --language-force=JavaScript \
  | grep -v '^!_TAG_' >> tagsunsorted

# макросы из TT-шаблонов
grep -r --include="*html" --include="*tt2" '\[% *MACRO *[_a-zA-Z]*' data/t | sed 's/^\(.*\): *\[% *\(MACRO *\([a-zA-Z_]*\)\).*$/\3\t\1\t\/\2\//' >> tagsunsorted

# методы из js-объектов
egrep '^this\.' tagsunsorted | sed 's/^this\.//' >> tagsunsorted

# find all cmds
egrep '^cmd_' tagsunsorted | sed 's/^cmd_//' >> tagsunsorted

cat tagsunsorted | grep -E -v '^.{300,}' |  perl -e 'print (sort <>)' | uniq > tags
rm tagsunsorted


