#!/usr/bin/env python
# -*- coding: utf-8 -*-

#TODO syslog
#TODO exit code = count broken slbs

"""
Скрипт для сравнения хостов из составов l3-балансеров, кондукторных групп, няневых сервисов.
Полагается на direct-vhosts.yaml.
"""


import requests
import os
import json
import yaml
import sys
import difflib
import logging
import argparse
import socket
from socket import AF_INET6 as ipv6
from socket import AF_INET as ipv4
from pprint import pprint
import direct_juggler.juggler as dj

requests.packages.urllib3.disable_warnings()
logging.getLogger("requests").setLevel(logging.WARNING)
logging.getLogger("urllib3").setLevel(logging.WARNING)

API_URL = 'https://l3-api.tt.yandex-team.ru'
vhost_file = '/etc/yandex-direct/direct-vhosts.yaml'
logdir = '/var/log/dt-l3-yp'
DESCRIPTION_PREFIX = 'from: %s on %s' % (os.path.basename(__file__), socket.gethostname())

log_levels = {
#    3: logging.CRITICAL,
#    4: logging.ERROR,
    0: logging.WARN,
    1: logging.INFO,
    2: logging.DEBUG,
}

def load_vhost_config(config_file):
    with open(config_file, 'r') as stream:
        try:
            config = yaml.safe_load(stream)
           # print(config)
        except yaml.YAMLError as exc:
            logging.exception("Can't load vhost config.")
            logging.error('Exit.')
            sys.exit(1)
        return config


def rs_from_slb(svc_id, token):
    vs_info = {}
    headers = {'Authorization': 'OAuth %s' % token}
    r = requests.get(u"%s%s" % (API_URL, "/api/v1/service/%s" % svc_id), headers=headers, verify=False)
    service = r.json()
    for vs in service['config']['vs_id']:
        r = requests.get(u"%s%s" % (API_URL, "/api/v1/service/%s/vs/%s/rs?_limit=100" % (svc_id, vs)), headers=headers, verify=False)
        # TODO читать список аккуратно с пейджингом -- на случай, если перестанем помещаться в лимиты на одну страницу
        data = r.json()
        p = requests.get(u"%s%s" % (API_URL, "/api/v1/vs/%s?_pretty" % vs), headers=headers, verify=False)
        vs_port = p.json().get('port')

        yield {'vs_id' : vs, 'port' : vs_port, 'groups' : set(x.get('group') for x in data.get('objects')), 'instances' : {x.get('fqdn') : x.get('ip') for x in  data.get('objects')}}


def rs_from_nanny(svc_name):
    r = requests.get('http://nanny.yandex-team.ru/v2/services/%s/current_state/instances' % svc_name, verify=False)
    service = r.json()
    return [x.get('container_hostname') for x in service.get('result')] #jq .result[].container_hostname


def list_rs_from_conductor(cgroups):
    r = requests.get('https://c.yandex-team.ru/api/groups2hosts/%s' % ",".join(cgroups), verify=False)
    if r.status_code != requests.codes.ok:
        pass #TODO check
        return []
    return sorted(r.text.split())


def coditioning_nanny(vhost_info):
    nanny_services = vhost_info.get('endpoints',{}).get('nanny_services',[])
    if not nanny_services:
        logging.info('Not in nanny according %s' % vhost_file)
        logging.info(10 * "---")
        return []
    logging.debug('Nanny :' + ",".join(nanny_services))
    reals_in_nanny = []
    for grp in nanny_services:
        reals_in_nanny += rs_from_nanny(grp)
    reals_in_nanny.sort()
    return reals_in_nanny

def diff_hosts_list(diff):
    diff_list = '*'.join(diff).split('*')
    diff_hosts = [x for x in diff_list if (x.encode().startswith('+') or x.encode().startswith('-'))]
    return diff_hosts


def get_and_show_diff(diff, services):
    diff_hosts = diff_hosts_list(diff)
    df = diff if args.verbosity else diff_hosts
    for line in ('Hosts diff: \n--- {0}\n+++ {1}\n' + '\n'.join(diff_hosts) if diff_hosts else '{0},{1}: Ok, no diff').format(services[0], services[1]).split('\n'):
        logging.info(line)
    return diff_hosts

def resolve_hosts(host_list):
    res = {}
    for host in host_list:
        res[host] = []
        ips = []
        try:
            ips = socket.getaddrinfo(host, None, socket.AF_INET6);
        except Exception as error:
            logging.error("Can't get ips for host {0}. Error: {1}".format(host, error))

        for ip in ips:
            res[host].append(ip[4][0])
        res[host] = list(set(res[host]))
    return res

def normalize_ipv6(ip_list):
    n = []
    for ip in ip_list:
        socket_addr = socket.getaddrinfo(ip, None)
        if socket_addr[0][0] == 2:
            n.append(ip)
        elif socket_addr[0][0] == 10 or len(socket_addr[0][4]) == 4:
            n.append(socket.inet_ntop(ipv6, socket.inet_pton(ipv6, ip)))
    n.sort()
    return n

def check_service(vhost, vhost_info):
    have_a_diff = False
    logging.info(10*"===")
    logging.info("Balancer(vhost): " + vhost)
    #logging.debug(vhost_info)
    if not vhost_info.get('entrypoints'):
        logging.info('No balancers found in config')
        logging.info(10 * "---")
        return
    reals_in_nanny = coditioning_nanny(vhost_info)
    logging.debug("Reals in nanny: " + ','.join(reals_in_nanny))
    conductor_groups = vhost_info.get('endpoints',{}).get('conductor_groups',[])
    logging.debug("C: " + ",".join(conductor_groups))
    reals_in_conductor = list_rs_from_conductor(conductor_groups)
    reals_in_conductor.sort()
    resolved_reals_in_conductor = resolve_hosts(reals_in_conductor)
    logging.debug("Reals in conductor: " + ','.join(resolved_reals_in_conductor))
    ips_in_conductor = list(set(y for x in resolved_reals_in_conductor.values() for y in x))
    ips_in_conductor.sort()
    logging.debug("Resolved reals in conductor: " + json.dumps(resolved_reals_in_conductor))
    diff_nanny_conductor = difflib.ndiff(reals_in_nanny, reals_in_conductor)
    diff_hosts_nanny_conductor = get_and_show_diff(diff_nanny_conductor, ('nanny', 'conductor groups: %s' % conductor_groups)) if reals_in_nanny else []
    for entrypoint in vhost_info.get('entrypoints'):
        l3id =  entrypoint.get('l3_manager_id')
        vs_slb_diffs = {}
        for vs_slb in rs_from_slb(l3id, token):
            slb_info = 'slb id:%s[vs: %s](fqdn: %s port %s)' % (l3id, vs_slb.get('vs_id'), ','.join(entrypoint.get('fqdn')[:args.verbosity]) , vs_slb.get('port'))
            reals_in_slb_full = vs_slb.get('instances')
            reals_in_slb = reals_in_slb_full.keys()
            reals_in_slb.sort()
            ips_in_slb = reals_in_slb_full.values()
            ips_in_slb = normalize_ipv6(ips_in_slb)
            logging.debug('Reals in slb %s(vs: %s), cgroups: %s: ' % (l3id, vs_slb.get('vs_id'), ','.join(vs_slb.get('groups',[])))  + json.dumps(reals_in_slb_full))
            diff_slb_nanny = difflib.ndiff(reals_in_slb, reals_in_nanny)
            diff_slb_conductor = difflib.ndiff(reals_in_slb, reals_in_conductor)
            diff_slb_conductor_resolved = difflib.ndiff(ips_in_slb, ips_in_conductor)
            vs_slb_diffs[vs_slb.get('vs_id')] = {'slb_info': slb_info, 'diff_slb_conductor': diff_slb_conductor, 'diff_slb_nanny': diff_slb_nanny}
            if reals_in_nanny:
                diff_hosts_slb_nanny = get_and_show_diff(diff_slb_nanny, (slb_info, 'nanny'))
            else:
                logging.info("not in nanny")
                diff_hosts_slb_nanny = []
            diff_hosts_slb_conductor = get_and_show_diff(diff_slb_conductor, (slb_info, 'conductor groups: %s' % conductor_groups))
            diff_hosts_slb_conductor_resolved = get_and_show_diff(diff_slb_conductor_resolved, (slb_info, 'Resolved conductor groups: %s' % conductor_groups))
            if len(diff_hosts_slb_nanny + diff_hosts_nanny_conductor + diff_hosts_slb_conductor + diff_hosts_slb_conductor_resolved) > 0:
                have_a_diff = True
            logging.info(10 * "---")
    dj.queue_events([{
        'host': vhost,
        'service': 'slb-yp_consistency',
        'status': 'WARN' if have_a_diff else 'OK',
        'description': "; ".join([
            'balancer and yp have different settings' if have_a_diff else 'Hosts on slb and yp identical' ,
            DESCRIPTION_PREFIX,
            'see logs on %s' % logdir,
            ]),
        }])



if __name__ == "__main__":
    parser = argparse.ArgumentParser(description='Check slb consistency with conductor and nanny')
    parser.add_argument('-v',  action='count', help='more vvverbose', dest='verbosity', default=0)
    parser.add_argument('--slb', dest='slb', type=str, action='store', help='Check alone balancer')
    parser.add_argument('--token', dest='token', type=str, action='store', help='Token for l3-api')
    parser.add_argument('--exclude', dest='excl', type=str, action='store', help='Exclude balancer from all checks')
    args=parser.parse_args()
    token = args.token if args.token else os.environ.get("OAUTH", "")
    verbosity = args.verbosity if 0 <= args.verbosity < 3 else 2
    logging.basicConfig(filename='%s/%s.log' % (logdir, os.path.basename(__file__)),format='%(asctime)s %(message)s', filemode='a+', level=log_levels[verbosity])
    logging.info(10 * '***')
    if not token:
        logging.info("you must provide your OAuth-token for l3-manager in environment variable 'OAUTH' or token argument")
        logging.info("you can get token here https://oauth.yandex-team.ru/authorize?response_type=token&client_id=0427b538222547f88a0549104c476f78")
        logging.info(10 * '***')
        sys.exit(1)
    logging.info('Start with vhost config from %s' % vhost_file)
    config = load_vhost_config(vhost_file)
    if args.slb:
        if args.slb in config.get('vhosts').keys():
            check_service(args.slb, config.get('vhosts').get(args.slb))
        else:
            logging.error("Slb %s not found in config" % args.slb)
        logging.info(10 * '***')
        sys.exit()
    for vhost, vhost_info in config.get('vhosts').items():
        if vhost == args.excl:
            continue
        check_service(vhost, vhost_info)
    logging.info(10 * '***')
