#!/usr/bin/env python
# coding: utf-8

import argparse
import yaml
import logging
import os
from subprocess import check_call

SOLOMON_CONFD = '/etc/solomon-agent/conf.d'
CONF_PREFIX = 'direct-apps.'

if __name__ == '__main__':
    parser = argparse.ArgumentParser(formatter_class=argparse.ArgumentDefaultsHelpFormatter, description=__doc__)
    parser.add_argument('--apply', default=False, action='store_true', help='Записать новые и удалить лишние конфиги (иначе просто покажет, что собирается сделать)')
    args = parser.parse_args()
    logging.basicConfig(level=logging.DEBUG)

    with open('/etc/yandex-direct/direct-apps.conf.yaml') as f:
        apps_conf = yaml.load(f)

    processed = set()
    changed = 0
    for app, app_conf in apps_conf['apps'].items():
        if app_conf.get('type') != 'arcadia-java' or 'solomon-confgen' in app_conf.get('ignore-features', []):
            continue

        try:
            port = int(app_conf['monitoring_port'])
        except:
            continue

        solomon_conf_file = '%s/%s%s.conf' % (SOLOMON_CONFD, CONF_PREFIX, app)
        processed.add(solomon_conf_file)

        # похоже, что у solomon-agent свой формат конфигов, проще писать текстом и не экспериментировать с yaml
        solomon_conf = """Project: "direct"
Service: "java-apps"

PullInterval: "15s"

Labels: [
    "app=""" + app + """"
]

Modules: [
    { HttpPull: {
        Url: "http://localhost:""" + str(port) + """/monitoring"
    }}
]
"""

        cur_solomon_conf = ''
        try:
            with open(solomon_conf_file) as f:
                cur_solomon_conf = f.read()
        except Exception as e:
            logging.warning('make_configs: reading current solomon config - cannot open file %s: %s %s' % (solomon_conf_file, type(e), e))
 
        if solomon_conf == cur_solomon_conf:
            logging.info('make_configs: solomon config for %s already in file %s, skipping' % (app, solomon_conf_file))
            continue

        logging.info('make_configs: solomon config for %s differs from file %s, write new config: %s' % (app, solomon_conf_file, solomon_conf))
        if args.apply:
            try:
                with open(solomon_conf_file, 'w') as f:
                    f.write(solomon_conf)
                changed += 1
            except Exception as e:
                logging.critical('make_configs: cannot write file %s, skipping: %s %s' % (solomon_conf_file, type(e), e))
                continue

    logging.info('make_configs: processed apps: ' + str(processed))
    # удаляем конфиги приложений, которые не были обработаны
    for conf in os.listdir(SOLOMON_CONFD):
        solomon_conf_file = SOLOMON_CONFD + '/' + conf

        if solomon_conf_file in processed or not (os.path.isfile(solomon_conf_file) and conf.startswith(CONF_PREFIX) and conf.endswith('.conf')):
            logging.info('remove_configs: skipping ' + conf)
            continue

        logging.info('remove_configs: removing %s ...' % (conf,))
        if args.apply:
            try:
                os.unlink(solomon_conf_file)
                changed += 1
            except Exception as e:
                logging.critical('cannot remove file %s, skipping: %s %s' % (conf, type(e), e))
                continue

    if args.apply and changed:
        logging.info('reloading solomon-agent')
        check_call(['sv', 'hup', 'solomon-agent'])
