#!/usr/bin/perl

use strict;
use warnings;

use utf8;

use Fcntl qw(:flock);
use ProjectSpecific qw/svn_url/;
use Yandex::Shell;

our $TRUNK_CACHE_PATH = '/var/www/svn-trunk-cache';
our $LOCK_FILE_PATH = '/var/lock/svn-trunk-cache';

run() unless caller();

sub run {
    umask 022;
    open my $lock, '>', $LOCK_FILE_PATH or die "Cannot open $LOCK_FILE_PATH: $!";
    flock $lock, LOCK_EX or die "Cannot get a lock on $LOCK_FILE_PATH: $!";
    if (-d $TRUNK_CACHE_PATH) {
        yash_system("svn", "cleanup", $TRUNK_CACHE_PATH);
        yash_system("svn", "update", $TRUNK_CACHE_PATH);
    } else {
        yash_system("svn", "checkout", svn_url('trunk'), $TRUNK_CACHE_PATH);
    }
    flock $lock, LOCK_UN or die "Cannot release a lock on $LOCK_FILE_PATH: $!";
    close $lock or die "Cannot close $LOCK_FILE_PATH: $!";
    exit(0);
}
