#!/usr/bin/python
# -*- encoding: utf-8 -*-

import os
import json
import time
import datetime
import subprocess
import socket
import re

def getZfsRatio(point):
    try:
        #для пустых машин с zfs выставляем коэфициент сжатия в 3.0
        command1 = "/sbin/zfs get used pool/{0}".format(point.strip("/"))
        proc1 = subprocess.Popen(command1, shell=True, stdout=subprocess.PIPE, stderr=subprocess.PIPE)
        out1 = proc1.communicate()
        rgxp1 = re.compile('used\s+(\d+\.?\d*)(\D?)')
        used = rgxp1.search(out1[0]).groups()
        if used[1] == 'K' or (used[1] == 'G' and float(used[0]) < 100.0):
            return float(3.0)
        #для машин с размером больше 100G береи коэфициент из refcompressratio
        command2 = "/sbin/zfs get refcompressratio pool/{0}".format(point.strip("/"))
        proc2 = subprocess.Popen(command2, shell=True, stdout=subprocess.PIPE, stderr=subprocess.PIPE)
        out2 = proc2.communicate()
        if len(out2[1]) > 0:
            raise
        rgxp2 = re.compile('refcompressratio\s+(\d+\.?\d*)x?')
        ratio = rgxp2.search(out2[0]).groups()[0]
        return float(ratio)
    except Exception as err:
        #для машин без zfs коэфициент сжатия равен 1
        return 1

'''Возвращает словарь с указанием общего и свободного места в байтах.
   output: { 'total_size': 100, 'free_size': 50 }
'''
def serverSpace(point):
    ratio = getZfsRatio(point)
    result=os.statvfs(point)
    block_size=int(result.f_frsize)
    total_size=int(result.f_blocks*block_size)
    free_size=int(result.f_bfree*block_size)
    return { 'total_size': int(ratio*total_size),
             'free_size': int(ratio*free_size) }

'''Возвращает список инстансов, найденных в /etc/init.d с именем mysql.*
'''
def mysqlConfigs(init_dir):
    return [ i.split('.', 1)[1] for i in os.listdir(init_dir) if i.startswith('mysql.') ]

def mysqlMemory(finder, run_dir='/run'):
    result = {}
    file_pids = dict([ (i, os.path.join(run_dir, i, "mysqld.pid")) for i in os.listdir(run_dir)
                                                                    if i.startswith('mysqld.')])
    for name in file_pids:
        instance = name.split(".", 1)[1]
        if instance.find(finder) == -1: continue
        if os.path.exists(file_pids[name]):
            pid = open(file_pids[name]).read().strip()
            pid_status = os.path.join("/proc", pid, "status")
            if os.path.exists(pid_status):
                stats = open(os.path.join("/proc", pid, "status")).read()
                memory = [ i.split()[1] for i in stats.split("\n") if i.startswith("VmRSS") ][0]
            else:
                memory = 0
            return int(memory)*1024
    return 0

'''Принимает конфиг mysql и выбирает из него порт(поддерживает include).
Если порт был найден - то возвращается число, при отсутсвии - None.
'''
def mysqlPort(mycnf):
    ports = []
    if not os.path.exists(mycnf):
        return None
    for line in open(mycnf).readlines():
        if line.startswith('port'):
            ports.append(line.strip().split('=')[1])
        if line.startswith('!includedir'):
            include_dir = line.strip().split(' ')[1]
            for f1les in os.listdir(include_dir):
                port = mysqlPort(os.path.join(include_dir, f1les))
                if not port is None: ports.append(port)
    if len(ports) == 0:
        return None
    return int(ports[-1])

'''Возвращает словарь, в котором указывается сколько места занимает каждая инсталяция БД.
'''
def mysqlDatabases(mysql_dir, mysql_conf='/etc/mysql'):
    mysql_params = {}
    inits = os.listdir(mysql_dir)
    instances = [ i.split('.', 1)[1] for i in inits if i.startswith('mysql.') ]
    for name in instances:
        mysql_params.setdefault(name, {})
        filepath = os.path.join(mysql_dir, "mysql.{0}".format(name))
        rootpath = '/' if name.find('ppcdict') == -1 else '/opt/root.ppcdict.1'
        mysqlconf = os.path.join(rootpath, mysql_conf.strip('/'), "{0}.cnf".format(name))
        if os.path.exists(filepath):
            mysql_params[name]['size_database'] = backupSize(filepath)
            mysql_params[name]['version_database'] = backupCreateTime(filepath)
            mysql_params[name]['xtrabackup_binlog'] = backupBinlogPositions(filepath)
            mysql_params[name]['usage_memory'] = mysqlMemory(name)
            mysql_params[name]['name'] = name
        else:
            mysql_params[name]['size_database'] = 0
            mysql_params[name]['version_database'] = 0
            mysql_params[name]['usage_memory'] = 0
            mysql_params[name]['name'] = name
        mysql_port = mysqlPort(mysqlconf) if mysqlPort(mysqlconf) is not None else 0
        mysql_params[name]['port'] = mysql_port  #явное обозначение, что порта в конфиге нет.
        mysql_params[name]['running'] = 'yes' if mysqlRunning(mysql_port) else 'no'
    return mysql_params


'''Проверяет доступность mysql порта. Принимает номер порта, возвращает True/False
'''
def mysqlRunning(mysql_port):
    mysql_port = int(mysql_port)
    try:
        if mysql_port == 0:
            raise ValueError("mysql port equal zero")
        sock = socket.socket()
        sock.connect(('localhost', mysql_port))
        sock.close()
        return True
    except Exception as err:
        pass
    return False

'''Возвращает количествой байтов занимаемое БД.
'''
def backupSize(path):
    total = 0
    for dirpath, dirnames, filenames in os.walk(path):
        for name in filenames:
            filepath = os.path.join(dirpath, name)
            total += os.path.getsize(filepath)
    return total

'''Возвращает время создания бекапа в формате unix timestamp.
'''
def backupCreateTime(path):
    result = 0
    filename = os.path.join(path, "data/xtrabackup_info")
    if os.path.exists(filename):
        meta = open(filename).read()
        str_time = [ i.split("=", 1)[1] for i in meta.split("\n") if i.startswith("start_time") ][0]
        start_time = datetime.datetime.strptime(str_time.strip(), '%Y-%m-%d %H:%M:%S')
        result =  time.mktime(start_time.timetuple())
    return result

'''Возвращает позиции binlogs бекапа mysqld'''
def backupBinlogPositions(path):
    result = {}
    filename = os.path.join(path, "data/xtrabackup_binlog_info")
    if os.path.exists(filename):
        meta = open(filename).read().replace("\n", "").split("\t")
        result["name"] = meta[0] if len(meta) >= 1 else ""
        result["position"] = meta[1] if len(meta) >= 2 else 0
        result["gtid"] = meta[2] if len(meta) >= 3 else ""
    return result

def serverMemory():
    pass


def run():
    result = { 'server_space': serverSpace('/opt'),
               'installed_dbconfigs': mysqlConfigs('/etc/init.d/'),
               'server_memory': serverMemory(),
               'instances': mysqlDatabases('/opt'),
             }
    return json.dumps(result)

if __name__ == '__main__':
    print run()
