#! /usr/bin/perl

=head1 sync-db-direct-mysql-upgrade.pl

    Скрипт готовит тестовые базы rbac2 и sandbox к использованию, запуская mysql_upgrade.
    Это нужно, потому что бэкап может приехать с данными MySQL 5.0, с которыми 5.5
    до mysql_upgrade корректно работать не будет (запустится, но клиенты будут получать ошибки).

    Соглашения о параметрах и результатах см. в sync-db-prepare-direct-grants.pl

=cut

use strict;
use warnings;

my @dbs = qw( rbac2 sandbox );

foreach my $db (@dbs) {
    my $status = system( qq{mysql_upgrade -u root -S "/var/run/mysqld.$db/mysqld.sock" --force} );
    print "database $db status $status\n";
}

exit 0;
