#! /usr/bin/perl

=head1 sync-db-direct-prepare-ppcdict.pl

    Скрипт готовит тестовую базу ppcddict к использованию: 
      * увеличивает id в шардинговых мета-таблицах

    Соглашения о параметрах и результатах см. в sync-db-prepare-direct-grants.pl

=cut

use strict;
use warnings;

use Sys::Hostname;

my $hostname = hostname();

my $db = 'ppcdict';

my $mysql_sock = $ARGV[0];
my $pass = `cat /etc/direct-tokens/mysql_direct-test`;

my $status = system(qq!mysql --user=direct-test --host="$mysql_sock" --port=3306 --password="$pass" ppcdict -e "delete from reshard_queue where status not in ('done', 'error');"!) || 0;
print "database $db clear reshard_queue status $status\n";

my @shard_inc_tables = `mysql --user=direct-test --host="$mysql_sock" --port=3306 --password="$pass" ppcdict -e "show tables like '%inc_%';"`;
for my $table (@shard_inc_tables) {
    if ($table =~ /^(?:shard_)?inc_(\w+)$/) {
        my $status = system(qq!mysql --user=direct-test --host="$mysql_sock" --port=3306 --password="$pass" ppcdict -e "insert into $table ($1) select round(max($1) * 1.1) + 20000 from $table;"!) || 0;
        print "database $db $table status $status\n";
    }
}

exit(0);

