-- MySQL dump 10.13  Distrib 5.7.25-28, for debian-linux-gnu (x86_64)
--
-- Host: localhost    Database: mysql
-- ------------------------------------------------------
-- Server version	5.7.25-28-log

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;
/*!50717 SELECT COUNT(*) INTO @rocksdb_has_p_s_session_variables FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA = 'performance_schema' AND TABLE_NAME = 'session_variables' */;
/*!50717 SET @rocksdb_get_is_supported = IF (@rocksdb_has_p_s_session_variables, 'SELECT COUNT(*) INTO @rocksdb_is_supported FROM performance_schema.session_variables WHERE VARIABLE_NAME=\'rocksdb_bulk_load\'', 'SELECT 0') */;
/*!50717 PREPARE s FROM @rocksdb_get_is_supported */;
/*!50717 EXECUTE s */;
/*!50717 DEALLOCATE PREPARE s */;
/*!50717 SET @rocksdb_enable_bulk_load = IF (@rocksdb_is_supported, 'SET SESSION rocksdb_bulk_load = 1', 'SET @rocksdb_dummy_bulk_load = 0') */;
/*!50717 PREPARE s FROM @rocksdb_enable_bulk_load */;
/*!50717 EXECUTE s */;
/*!50717 DEALLOCATE PREPARE s */;

CREATE DATABASE IF NOT EXISTS `mysql` DEFAULT CHARACTER SET utf8;
CREATE DATABASE IF NOT EXISTS `ppclog_bs` DEFAULT CHARACTER SET utf8;
CREATE DATABASE IF NOT EXISTS `ppclog` DEFAULT CHARACTER SET utf8;

USE ppclog; 

--
-- Table structure for table `monitor_targets`
--
DROP TABLE IF EXISTS `monitor_targets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `monitor_targets` (
  `target_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `description` text NOT NULL,
  `units` enum('num','proc') CHARACTER SET latin1 NOT NULL DEFAULT 'num',
  PRIMARY KEY (`target_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM AUTO_INCREMENT=21 DEFAULT CHARSET=utf8;

CREATE TABLE `monitor_values_day` (
  `target_id` int(10) unsigned NOT NULL,
  `measure_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `value` double NOT NULL,
  PRIMARY KEY (`target_id`,`measure_time`),
  KEY `measure_time` (`measure_time`,`target_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `monitor_values_hour` (
  `target_id` int(10) unsigned NOT NULL,
  `measure_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `value` double NOT NULL,
  PRIMARY KEY (`target_id`,`measure_time`),
  KEY `measure_time` (`measure_time`,`target_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `monitor_values_sec` (
  `target_id` int(10) unsigned NOT NULL,
  `measure_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `value` double NOT NULL,
  PRIMARY KEY (`target_id`,`measure_time`),
  KEY `measure_time` (`measure_time`,`target_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

USE mysql;
--
-- Table structure for table `columns_priv`
--

DROP TABLE IF EXISTS `columns_priv`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `columns_priv` (
  `Host` char(60) COLLATE utf8_bin NOT NULL DEFAULT '',
  `Db` char(64) COLLATE utf8_bin NOT NULL DEFAULT '',
  `User` char(32) COLLATE utf8_bin NOT NULL DEFAULT '',
  `Table_name` char(64) COLLATE utf8_bin NOT NULL DEFAULT '',
  `Column_name` char(64) COLLATE utf8_bin NOT NULL DEFAULT '',
  `Timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `Column_priv` set('Select','Insert','Update','References') CHARACTER SET utf8 NOT NULL DEFAULT '',
  PRIMARY KEY (`Host`,`Db`,`User`,`Table_name`,`Column_name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='Column privileges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `columns_priv`
--

LOCK TABLES `columns_priv` WRITE;
/*!40000 ALTER TABLE `columns_priv` DISABLE KEYS */;
/*!40000 ALTER TABLE `columns_priv` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `db`
--

DROP TABLE IF EXISTS `db`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `db` (
  `Host` char(60) COLLATE utf8_bin NOT NULL DEFAULT '',
  `Db` char(64) COLLATE utf8_bin NOT NULL DEFAULT '',
  `User` char(32) COLLATE utf8_bin NOT NULL DEFAULT '',
  `Select_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `Insert_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `Update_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `Delete_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `Create_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `Drop_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `Grant_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `References_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `Index_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `Alter_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `Create_tmp_table_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `Lock_tables_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `Create_view_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `Show_view_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `Create_routine_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `Alter_routine_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `Execute_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `Event_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `Trigger_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  PRIMARY KEY (`Host`,`Db`,`User`),
  KEY `User` (`User`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='Database privileges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `db`
--

LOCK TABLES `db` WRITE;
/*!40000 ALTER TABLE `db` DISABLE KEYS */;
INSERT INTO `db` VALUES ('%','test','','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','N','N','Y','Y'),('%','test\\_%','','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','N','N','Y','Y'),('localhost','sys','mysql.sys','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','Y');
/*!40000 ALTER TABLE `db` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `engine_cost`
--

DROP TABLE IF EXISTS `engine_cost`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `engine_cost` (
  `engine_name` varchar(64) NOT NULL,
  `device_type` int(11) NOT NULL,
  `cost_name` varchar(64) NOT NULL,
  `cost_value` float DEFAULT NULL,
  `last_update` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `comment` varchar(1024) DEFAULT NULL,
  PRIMARY KEY (`cost_name`,`engine_name`,`device_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 STATS_PERSISTENT=0;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `engine_cost`
--

LOCK TABLES `engine_cost` WRITE;
/*!40000 ALTER TABLE `engine_cost` DISABLE KEYS */;
INSERT INTO `engine_cost` VALUES ('default',0,'io_block_read_cost',NULL,'2017-03-02 18:45:31',NULL),('default',0,'memory_block_read_cost',NULL,'2017-03-02 18:45:31',NULL);
/*!40000 ALTER TABLE `engine_cost` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `event`
--

DROP TABLE IF EXISTS `event`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `event` (
  `db` char(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `name` char(64) NOT NULL DEFAULT '',
  `body` longblob NOT NULL,
  `definer` char(93) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `execute_at` datetime DEFAULT NULL,
  `interval_value` int(11) DEFAULT NULL,
  `interval_field` enum('YEAR','QUARTER','MONTH','DAY','HOUR','MINUTE','WEEK','SECOND','MICROSECOND','YEAR_MONTH','DAY_HOUR','DAY_MINUTE','DAY_SECOND','HOUR_MINUTE','HOUR_SECOND','MINUTE_SECOND','DAY_MICROSECOND','HOUR_MICROSECOND','MINUTE_MICROSECOND','SECOND_MICROSECOND') DEFAULT NULL,
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_executed` datetime DEFAULT NULL,
  `starts` datetime DEFAULT NULL,
  `ends` datetime DEFAULT NULL,
  `status` enum('ENABLED','DISABLED','SLAVESIDE_DISABLED') NOT NULL DEFAULT 'ENABLED',
  `on_completion` enum('DROP','PRESERVE') NOT NULL DEFAULT 'DROP',
  `sql_mode` set('REAL_AS_FLOAT','PIPES_AS_CONCAT','ANSI_QUOTES','IGNORE_SPACE','NOT_USED','ONLY_FULL_GROUP_BY','NO_UNSIGNED_SUBTRACTION','NO_DIR_IN_CREATE','POSTGRESQL','ORACLE','MSSQL','DB2','MAXDB','NO_KEY_OPTIONS','NO_TABLE_OPTIONS','NO_FIELD_OPTIONS','MYSQL323','MYSQL40','ANSI','NO_AUTO_VALUE_ON_ZERO','NO_BACKSLASH_ESCAPES','STRICT_TRANS_TABLES','STRICT_ALL_TABLES','NO_ZERO_IN_DATE','NO_ZERO_DATE','INVALID_DATES','ERROR_FOR_DIVISION_BY_ZERO','TRADITIONAL','NO_AUTO_CREATE_USER','HIGH_NOT_PRECEDENCE','NO_ENGINE_SUBSTITUTION','PAD_CHAR_TO_FULL_LENGTH') NOT NULL DEFAULT '',
  `comment` char(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `originator` int(10) unsigned NOT NULL,
  `time_zone` char(64) CHARACTER SET latin1 NOT NULL DEFAULT 'SYSTEM',
  `character_set_client` char(32) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `collation_connection` char(32) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `db_collation` char(32) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `body_utf8` longblob,
  PRIMARY KEY (`db`,`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Events';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `event`
--

LOCK TABLES `event` WRITE;
/*!40000 ALTER TABLE `event` DISABLE KEYS */;
/*!40000 ALTER TABLE `event` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `func`
--

DROP TABLE IF EXISTS `func`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `func` (
  `name` char(64) COLLATE utf8_bin NOT NULL DEFAULT '',
  `ret` tinyint(1) NOT NULL DEFAULT '0',
  `dl` char(128) COLLATE utf8_bin NOT NULL DEFAULT '',
  `type` enum('function','aggregate') CHARACTER SET utf8 NOT NULL,
  PRIMARY KEY (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='User defined functions';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `func`
--

LOCK TABLES `func` WRITE;
/*!40000 ALTER TABLE `func` DISABLE KEYS */;
/*!40000 ALTER TABLE `func` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gtid_executed`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `gtid_executed` (
  `source_uuid` char(36) NOT NULL COMMENT 'uuid of the source where the transaction was originally executed.',
  `interval_start` bigint(20) NOT NULL COMMENT 'First number of interval.',
  `interval_end` bigint(20) NOT NULL COMMENT 'Last number of interval.',
  PRIMARY KEY (`source_uuid`,`interval_start`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 STATS_PERSISTENT=0;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `help_category`
--

DROP TABLE IF EXISTS `help_category`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `help_category` (
  `help_category_id` smallint(5) unsigned NOT NULL,
  `name` char(64) NOT NULL,
  `parent_category_id` smallint(5) unsigned DEFAULT NULL,
  `url` text NOT NULL,
  PRIMARY KEY (`help_category_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 STATS_PERSISTENT=0 COMMENT='help categories';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_category`
--

LOCK TABLES `help_category` WRITE;
/*!40000 ALTER TABLE `help_category` DISABLE KEYS */;
INSERT INTO `help_category` VALUES (1,'Geographic',0,''),(2,'Polygon properties',35,''),(3,'WKT',35,''),(4,'Numeric Functions',39,''),(5,'Plugins',36,''),(6,'MBR',35,''),(7,'Control flow functions',39,''),(8,'Transactions',36,''),(9,'Help Metadata',36,''),(10,'Account Management',36,''),(11,'Point properties',35,''),(12,'Encryption Functions',39,''),(13,'LineString properties',35,''),(14,'Miscellaneous Functions',39,''),(15,'Logical operators',39,''),(16,'Functions and Modifiers for Use with GROUP BY',36,''),(17,'Information Functions',39,''),(18,'Storage Engines',36,''),(19,'Comparison operators',39,''),(20,'Bit Functions',39,''),(21,'Table Maintenance',36,''),(22,'User-Defined Functions',36,''),(23,'Data Types',36,''),(24,'Compound Statements',36,''),(25,'Geometry constructors',35,''),(26,'GeometryCollection properties',1,''),(27,'Administration',36,''),(28,'Data Manipulation',36,''),(29,'Utility',36,''),(30,'Language Structure',36,''),(31,'Geometry relations',35,''),(32,'Date and Time Functions',39,''),(33,'WKB',35,''),(34,'Procedures',36,''),(35,'Geographic Features',36,''),(36,'Contents',0,''),(37,'Geometry properties',35,''),(38,'String Functions',39,''),(39,'Functions',36,''),(40,'Data Definition',36,'');
/*!40000 ALTER TABLE `help_category` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_keyword`
--

DROP TABLE IF EXISTS `help_keyword`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `help_keyword` (
  `help_keyword_id` int(10) unsigned NOT NULL,
  `name` char(64) NOT NULL,
  PRIMARY KEY (`help_keyword_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 STATS_PERSISTENT=0 COMMENT='help keywords';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_keyword`
--

LOCK TABLES `help_keyword` WRITE;
/*!40000 ALTER TABLE `help_keyword` DISABLE KEYS */;
INSERT INTO `help_keyword` VALUES (469,'<>'),(445,'ACTION'),(173,'ADD'),(465,'AES_DECRYPT'),(407,'AES_ENCRYPT'),(227,'AFTER'),(98,'AGAINST'),(167,'AGGREGATE'),(178,'ALGORITHM'),(315,'ALL'),(378,'ALTER'),(419,'ANALYSE'),(442,'ANALYZE'),(322,'AND'),(171,'ARCHIVE'),(214,'AS'),(456,'ASC'),(5,'AT'),(413,'AUTHORS'),(217,'AUTOCOMMIT'),(73,'AUTOEXTEND_SIZE'),(172,'AVG_ROW_LENGTH'),(312,'BEFORE'),(398,'BEGIN'),(302,'BETWEEN'),(125,'BIGINT'),(79,'BINARY'),(319,'BINLOG'),(334,'BOOL'),(113,'BOOLEAN'),(333,'BOTH'),(476,'BTREE'),(42,'BY'),(209,'BYTE'),(194,'CACHE'),(308,'CALL'),(268,'CASCADE'),(148,'CASE'),(480,'CATALOG_NAME'),(358,'CEIL'),(410,'CEILING'),(285,'CHAIN'),(81,'CHANGE'),(389,'CHAR'),(262,'CHARACTER'),(39,'CHECK'),(99,'CHECKSUM'),(149,'CIPHER'),(121,'CLASS_ORIGIN'),(257,'CLIENT'),(57,'CLOSE'),(478,'COALESCE'),(282,'CODE'),(207,'COLLATE'),(473,'COLLATION'),(352,'COLUMN'),(12,'COLUMNS'),(55,'COLUMN_NAME'),(131,'COMMENT'),(197,'COMMIT'),(394,'COMMITTED'),(157,'COMPACT'),(13,'COMPLETION'),(423,'COMPRESSED'),(337,'CONCURRENT'),(163,'CONDITION'),(56,'CONNECTION'),(344,'CONSISTENT'),(443,'CONSTRAINT'),(185,'CONSTRAINT_CATALOG'),(201,'CONSTRAINT_NAME'),(441,'CONSTRAINT_SCHEMA'),(151,'CONTINUE'),(249,'CONTRIBUTORS'),(205,'CONVERT'),(101,'COUNT'),(288,'CREATE'),(248,'CROSS'),(229,'CSV'),(82,'CURRENT_USER'),(283,'CURSOR'),(221,'CURSOR_NAME'),(46,'DATA'),(449,'DATABASE'),(327,'DATABASES'),(420,'DATAFILE'),(128,'DATE'),(15,'DATETIME'),(346,'DATE_ADD'),(371,'DATE_SUB'),(47,'DAY'),(404,'DAY_HOUR'),(369,'DAY_MINUTE'),(108,'DAY_SECOND'),(146,'DEALLOCATE'),(158,'DEC'),(189,'DECIMAL'),(202,'DECLARE'),(115,'DEFAULT'),(192,'DEFAULT_AUTH'),(243,'DEFINER'),(440,'DELAYED'),(399,'DELAY_KEY_WRITE'),(53,'DELETE'),(278,'DESC'),(289,'DESCRIBE'),(421,'DES_KEY_FILE'),(353,'DIAGNOSTICS'),(460,'DIRECTORY'),(230,'DISABLE'),(297,'DISCARD'),(464,'DISTINCT'),(277,'DISTINCTROW'),(124,'DO'),(23,'DROP'),(239,'DUAL'),(354,'DUMPFILE'),(28,'DUPLICATE'),(206,'DYNAMIC'),(145,'ELSE'),(155,'ELSEIF'),(459,'ENABLE'),(165,'ENCLOSED'),(320,'END'),(294,'ENDS'),(266,'ENGINE'),(105,'ENGINES'),(391,'ERRORS'),(19,'ESCAPE'),(384,'ESCAPED'),(65,'EVENT'),(25,'EVENTS'),(411,'EVERY'),(300,'EXCHANGE'),(356,'EXECUTE'),(109,'EXISTS'),(433,'EXIT'),(281,'EXPANSION'),(222,'EXPIRE'),(225,'EXPLAIN'),(470,'EXPORT'),(246,'EXTENDED'),(290,'EXTENT_SIZE'),(76,'FALSE'),(306,'FAST'),(88,'FEDERATED'),(350,'FETCH'),(169,'FIELDS'),(234,'FILE'),(477,'FIRST'),(482,'FIXED'),(175,'FLOAT4'),(323,'FLOAT8'),(224,'FLOOR'),(287,'FLUSH'),(159,'FOR'),(78,'FORCE'),(193,'FOREIGN'),(152,'FROM'),(40,'FULL'),(130,'FULLTEXT'),(166,'FUNCTION'),(284,'GEOMETRYCOLLECTIONFROMTEXT'),(24,'GEOMETRYCOLLECTIONFROMWKB'),(190,'GEOMETRYFROMTEXT'),(373,'GEOMETRYFROMWKB'),(309,'GET'),(210,'GLOBAL'),(187,'GRANT'),(219,'GRANTS'),(251,'GROUP'),(106,'HANDLER'),(213,'HAVING'),(298,'HEAP'),(338,'HELP'),(111,'HELP_DATE'),(181,'HELP_VERSION'),(475,'HIGH_PRIORITY'),(1,'HOST'),(195,'HOSTS'),(325,'HOUR'),(83,'HOUR_MINUTE'),(91,'HOUR_SECOND'),(329,'IDENTIFIED'),(427,'IF'),(68,'IGNORE'),(254,'IGNORE_SERVER_IDS'),(97,'IMPORT'),(351,'IN'),(241,'INDEX'),(191,'INDEXES'),(180,'INFILE'),(447,'INITIAL_SIZE'),(133,'INNER'),(32,'INNODB'),(104,'INSERT'),(267,'INSERT_METHOD'),(122,'INSTALL'),(374,'INT1'),(292,'INT2'),(170,'INT3'),(41,'INT4'),(412,'INT8'),(18,'INTEGER'),(402,'INTERVAL'),(87,'INTO'),(147,'IO_THREAD'),(417,'IS'),(409,'ISOLATION'),(127,'ISSUER'),(123,'ITERATE'),(0,'JOIN'),(436,'KEY'),(434,'KEYS'),(386,'KEY_BLOCK_SIZE'),(174,'KILL'),(431,'LAST'),(199,'LEADING'),(273,'LEAVE'),(154,'LEFT'),(77,'LEVEL'),(348,'LIKE'),(435,'LIMIT'),(361,'LINES'),(416,'LINESTRINGFROMTEXT'),(211,'LINESTRINGFROMWKB'),(203,'LOAD'),(463,'LOCAL'),(37,'LOCK'),(286,'LOGFILE'),(295,'LOGS'),(142,'LONG'),(102,'LONGBINARY'),(310,'LOOP'),(233,'LOW_PRIORITY'),(481,'MASTER'),(255,'MASTER_AUTO_POSITION'),(244,'MASTER_BIND'),(132,'MASTER_CONNECT_RETRY'),(52,'MASTER_HEARTBEAT_PERIOD'),(360,'MASTER_HOST'),(136,'MASTER_LOG_FILE'),(276,'MASTER_LOG_POS'),(258,'MASTER_PASSWORD'),(336,'MASTER_PORT'),(35,'MASTER_RETRY_COUNT'),(345,'MASTER_SSL'),(9,'MASTER_SSL_CA'),(366,'MASTER_SSL_CERT'),(331,'MASTER_SSL_CIPHER'),(183,'MASTER_SSL_CRL'),(58,'MASTER_SSL_CRLPATH'),(466,'MASTER_SSL_KEY'),(21,'MASTER_SSL_VERIFY_SERVER_CERT'),(263,'MASTER_USER'),(275,'MATCH'),(347,'MAX_CONNECTIONS_PER_HOUR'),(365,'MAX_QUERIES_PER_HOUR'),(379,'MAX_ROWS'),(90,'MAX_SIZE'),(291,'MAX_UPDATES_PER_HOUR'),(461,'MAX_USER_CONNECTIONS'),(401,'MEDIUM'),(357,'MEMORY'),(437,'MERGE'),(51,'MESSAGE_TEXT'),(186,'MIDDLEINT'),(44,'MINUTE'),(156,'MINUTE_SECOND'),(161,'MIN_ROWS'),(114,'MOD'),(16,'MODE'),(274,'MODIFY'),(26,'MONTH'),(137,'MRG_MYISAM'),(303,'MULTILINESTRINGFROMTEXT'),(247,'MULTILINESTRINGFROMWKB'),(242,'MULTIPOINTFROMTEXT'),(240,'MULTIPOINTFROMWKB'),(483,'MULTIPOLYGONFROMTEXT'),(367,'MULTIPOLYGONFROMWKB'),(110,'MUTEX'),(272,'MYISAM'),(196,'MYSQL_ERRNO'),(405,'NAME'),(250,'NATIONAL'),(382,'NATURAL'),(10,'NCHAR'),(38,'NDB'),(74,'NDBCLUSTER'),(390,'NEXT'),(43,'NO'),(235,'NODEGROUP'),(467,'NONE'),(418,'NOT'),(117,'NO_WRITE_TO_BINLOG'),(450,'NULL'),(168,'NUMBER'),(280,'NUMERIC'),(455,'NVARCHAR'),(388,'OFFSET'),(54,'ON'),(11,'ONLY'),(17,'OPEN'),(118,'OPTIMIZE'),(143,'OPTION'),(458,'OPTIONALLY'),(342,'OPTIONS'),(328,'OR'),(182,'ORDER'),(220,'OUTER'),(232,'OUTFILE'),(259,'OWNER'),(305,'PACK_KEYS'),(376,'PARSER'),(318,'PARTIAL'),(45,'PARTITION'),(141,'PARTITIONS'),(387,'PASSWORD'),(349,'PLUGIN'),(425,'PLUGINS'),(362,'PLUGIN_DIR'),(208,'POLYGONFROMTEXT'),(75,'POLYGONFROMWKB'),(107,'PORT'),(238,'POW'),(451,'POWER'),(138,'PRECISION'),(36,'PREPARE'),(85,'PRESERVE'),(324,'PREV'),(429,'PRIMARY'),(63,'PRIVILEGES'),(95,'PROCEDURE'),(341,'PROCESS'),(293,'PROCESSLIST'),(400,'PROFILE'),(27,'PROFILES'),(430,'PURGE'),(359,'QUERY'),(70,'QUICK'),(153,'READ'),(49,'REAL'),(372,'REBUILD'),(296,'RECOVER'),(316,'REDUNDANT'),(406,'REFERENCES'),(134,'RELAYLOG'),(260,'RELAY_LOG_FILE'),(269,'RELAY_LOG_POS'),(112,'RELEASE'),(216,'RELOAD'),(245,'REMOVE'),(375,'RENAME'),(144,'REORGANIZE'),(304,'REPAIR'),(2,'REPEAT'),(179,'REPEATABLE'),(4,'REPLACE'),(29,'REPLICATION'),(139,'REQUIRE'),(120,'RESET'),(343,'RESIGNAL'),(414,'RESTRICT'),(457,'RETURN'),(299,'RETURNED_SQLSTATE'),(7,'RETURNS'),(218,'REVOKE'),(377,'RIGHT'),(471,'RLIKE'),(94,'ROLLBACK'),(428,'ROWS'),(164,'ROW_COUNT'),(484,'ROW_FORMAT'),(426,'SAVEPOINT'),(6,'SCHEDULE'),(236,'SCHEMA'),(198,'SCHEMAS'),(264,'SCHEMA_NAME'),(321,'SECOND'),(72,'SECURITY'),(326,'SELECT'),(50,'SEPARATOR'),(444,'SERIAL'),(3,'SERIALIZABLE'),(364,'SERVER'),(448,'SESSION'),(126,'SET'),(252,'SHA'),(385,'SHA1'),(69,'SHA2'),(48,'SHARE'),(314,'SHOW'),(474,'SHUTDOWN'),(422,'SIGNAL'),(71,'SIGNED'),(454,'SLAVE'),(200,'SNAPSHOT'),(380,'SOCKET'),(237,'SONAME'),(301,'SOUNDS'),(64,'SPATIAL'),(119,'SQLSTATE'),(92,'SQL_AFTER_GTIDS'),(223,'SQL_AFTER_MTS_GAPS'),(100,'SQL_BEFORE_GTIDS'),(22,'SQL_BIG_RESULT'),(67,'SQL_BUFFER_RESULT'),(204,'SQL_CACHE'),(270,'SQL_CALC_FOUND_ROWS'),(392,'SQL_LOG_BIN'),(439,'SQL_NO_CACHE'),(332,'SQL_SLAVE_SKIP_COUNTER'),(395,'SQL_SMALL_RESULT'),(363,'SQL_THREAD'),(403,'SSL'),(424,'START'),(215,'STARTING'),(8,'STARTS'),(150,'STATS_AUTO_RECALC'),(31,'STATS_PERSISTENT'),(129,'STATUS'),(228,'STD'),(370,'STDDEV'),(135,'STOP'),(408,'STORAGE'),(381,'STRAIGHT_JOIN'),(162,'STRING'),(61,'SUBCLASS_ORIGIN'),(34,'SUBJECT'),(66,'SUPER'),(265,'TABLE'),(468,'TABLES'),(176,'TABLESPACE'),(86,'TABLE_NAME'),(393,'TEMPORARY'),(453,'TERMINATED'),(103,'THEN'),(279,'TIME'),(96,'TIMESTAMP'),(80,'TO'),(140,'TRAILING'),(368,'TRANSACTION'),(472,'TRIGGER'),(340,'TRIGGERS'),(261,'TRUE'),(313,'TRUNCATE'),(116,'TYPE'),(415,'UNCOMMITTED'),(253,'UNDO'),(231,'UNINSTALL'),(271,'UNION'),(339,'UNIQUE'),(30,'UNLOCK'),(188,'UNSIGNED'),(438,'UNTIL'),(84,'UPDATE'),(396,'UPGRADE'),(355,'USAGE'),(60,'USE'),(432,'USER'),(317,'USER_RESOURCES'),(452,'USE_FRM'),(184,'USING'),(20,'VALUE'),(307,'VALUES'),(311,'VARCHARACTER'),(93,'VARIABLE'),(383,'VARIABLES'),(89,'VARYING'),(177,'VIEW'),(479,'WAIT'),(160,'WARNINGS'),(212,'WHEN'),(62,'WHERE'),(462,'WHILE'),(226,'WITH'),(14,'WORK'),(330,'WRAPPER'),(446,'WRITE'),(59,'X509'),(397,'XA'),(335,'YEAR'),(33,'YEAR_MONTH'),(256,'ZEROFILL');
/*!40000 ALTER TABLE `help_keyword` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_relation`
--

DROP TABLE IF EXISTS `help_relation`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `help_relation` (
  `help_topic_id` int(10) unsigned NOT NULL,
  `help_keyword_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`help_keyword_id`,`help_topic_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 STATS_PERSISTENT=0 COMMENT='keyword-topic relation';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_relation`
--

LOCK TABLES `help_relation` WRITE;
/*!40000 ALTER TABLE `help_relation` DISABLE KEYS */;
INSERT INTO `help_relation` VALUES (0,0),(447,0),(249,1),(126,2),(238,3),(269,4),(332,4),(483,4),(310,5),(310,6),(475,6),(58,7),(310,8),(361,9),(229,10),(238,11),(340,11),(493,11),(247,12),(275,12),(441,12),(483,12),(511,12),(310,13),(475,13),(340,14),(125,15),(309,16),(447,16),(13,17),(62,17),(334,17),(441,17),(58,18),(264,18),(203,19),(200,20),(269,20),(317,20),(386,20),(508,20),(361,21),(447,22),(6,23),(51,23),(145,23),(218,23),(222,23),(279,23),(281,23),(360,23),(384,23),(400,23),(411,23),(428,23),(481,23),(511,23),(518,23),(319,24),(69,25),(95,25),(226,25),(202,26),(47,27),(317,28),(110,29),(25,30),(247,31),(247,32),(441,32),(202,33),(110,34),(361,35),(24,36),(384,36),(493,36),(25,37),(51,37),(114,37),(447,37),(511,37),(247,38),(223,39),(247,39),(511,39),(164,40),(247,40),(275,40),(441,40),(503,40),(264,41),(32,42),(48,42),(110,42),(247,42),(305,42),(332,42),(447,42),(448,42),(483,42),(511,42),(247,43),(517,43),(202,44),(0,45),(32,45),(247,45),(269,45),(317,45),(332,45),(447,45),(483,45),(511,45),(115,46),(247,46),(249,46),(483,46),(202,47),(447,48),(58,49),(419,49),(448,50),(171,51),(200,51),(508,51),(361,52),(32,53),(247,53),(517,53),(0,54),(310,54),(475,54),(517,54),(171,55),(200,55),(508,55),(97,56),(247,56),(33,57),(62,57),(361,58),(110,59),(0,60),(35,60),(107,60),(171,61),(200,61),(508,61),(32,62),(48,62),(62,62),(106,63),(110,63),(136,63),(114,64),(511,64),(193,65),(310,65),(411,65),(475,65),(110,66),(447,67),(0,68),(48,68),(317,68),(332,68),(447,68),(483,68),(511,68),(297,69),(32,70),(223,70),(245,70),(125,71),(110,72),(107,73),(247,74),(54,75),(255,75),(207,76),(238,77),(0,78),(26,79),(125,79),(149,79),(149,80),(361,80),(509,80),(361,81),(511,81),(310,82),(475,82),(202,83),(48,84),(317,84),(447,84),(517,84),(310,85),(475,85),(171,86),(200,86),(508,86),(269,87),(317,87),(413,87),(447,87),(247,88),(143,89),(107,90),(202,91),(426,92),(329,93),(340,94),(493,94),(509,94),(12,95),(103,95),(169,95),(182,95),(234,95),(441,95),(447,95),(481,95),(522,95),(59,96),(359,96),(483,97),(511,97),(309,98),(213,99),(247,99),(426,100),(230,101),(301,101),(427,101),(404,102),(20,103),(36,103),(49,103),(108,104),(168,104),(317,104),(521,104),(402,105),(441,105),(62,106),(420,106),(249,107),(202,108),(6,109),(279,109),(310,109),(342,109),(360,109),(400,109),(411,109),(441,110),(451,110),(63,111),(340,112),(493,112),(509,112),(276,113),(309,113),(66,114),(354,114),(115,115),(247,115),(269,115),(317,115),(342,115),(366,115),(386,115),(511,115),(511,116),(180,117),(245,117),(323,117),(515,117),(323,118),(511,118),(200,119),(508,119),(85,120),(146,120),(283,120),(325,120),(171,121),(200,121),(508,121),(482,122),(71,123),(72,124),(310,124),(475,124),(527,124),(120,125),(48,126),(101,126),(115,126),(184,126),(200,126),(247,126),(252,126),(261,126),(269,126),(317,126),(329,126),(332,126),(340,126),(342,126),(441,126),(447,126),(483,126),(508,126),(511,126),(517,126),(110,127),(74,128),(125,128),(202,128),(393,128),(37,129),(118,129),(121,129),(182,129),(337,129),(431,129),(441,129),(451,129),(114,130),(247,130),(511,130),(107,131),(114,131),(247,131),(310,131),(475,131),(361,132),(0,133),(226,134),(291,135),(361,136),(247,137),(419,138),(110,139),(506,140),(140,141),(404,142),(110,143),(136,143),(511,144),(36,145),(49,145),(384,146),(291,147),(426,147),(36,148),(49,148),(110,149),(247,150),(420,151),(32,152),(69,152),(226,152),(441,152),(447,152),(506,152),(25,153),(62,153),(238,153),(340,153),(493,153),(0,154),(20,155),(202,156),(247,157),(371,158),(180,159),(356,159),(420,159),(441,159),(447,159),(484,159),(427,160),(441,160),(247,161),(58,162),(356,163),(171,164),(483,165),(58,166),(169,166),(210,166),(218,166),(281,166),(299,166),(372,166),(382,166),(431,166),(441,166),(481,166),(58,167),(171,168),(441,169),(483,169),(138,170),(247,171),(247,172),(511,172),(38,173),(107,173),(511,173),(518,173),(97,174),(350,175),(107,176),(222,176),(511,176),(518,176),(91,177),(279,177),(505,177),(51,178),(114,178),(511,178),(238,179),(332,180),(483,180),(104,181),(32,182),(48,182),(447,182),(448,182),(511,182),(361,183),(0,184),(32,184),(50,184),(171,185),(200,185),(508,185),(138,186),(110,187),(136,187),(125,188),(264,188),(276,188),(327,188),(350,188),(371,188),(419,188),(58,189),(89,189),(125,189),(479,190),(441,191),(426,192),(247,193),(249,193),(511,193),(517,193),(60,194),(85,194),(413,194),(339,195),(441,195),(171,196),(200,196),(508,196),(340,197),(493,197),(92,198),(441,198),(506,199),(340,200),(493,200),(171,201),(200,201),(508,201),(356,202),(366,202),(420,202),(484,202),(413,203),(483,203),(447,204),(125,205),(457,205),(247,206),(115,207),(247,207),(342,207),(467,208),(513,209),(101,210),(238,210),(329,210),(337,210),(442,210),(502,211),(36,212),(49,212),(447,213),(0,214),(25,214),(447,214),(483,215),(110,216),(340,217),(136,218),(362,219),(441,219),(0,220),(171,221),(200,221),(508,221),(469,222),(426,223),(120,224),(140,225),(110,226),(114,226),(247,226),(309,226),(511,226),(511,227),(392,228),(247,229),(483,229),(310,230),(475,230),(511,230),(162,231),(447,232),(25,233),(32,233),(48,233),(269,233),(317,233),(332,233),(483,233),(110,234),(107,235),(115,236),(342,236),(360,236),(416,236),(441,236),(58,237),(399,238),(155,239),(510,240),(0,241),(38,241),(51,241),(60,241),(114,241),(247,241),(413,241),(417,241),(441,241),(511,241),(227,242),(310,243),(475,243),(361,244),(511,245),(140,246),(245,246),(153,247),(0,248),(4,249),(441,249),(143,250),(229,250),(107,251),(379,251),(447,251),(486,252),(420,253),(361,254),(361,255),(264,256),(276,256),(327,256),(350,256),(371,256),(419,256),(110,257),(361,258),(249,259),(361,260),(207,261),(115,262),(143,262),(184,262),(229,262),(247,262),(332,262),(342,262),(441,262),(447,262),(483,262),(361,263),(171,264),(200,264),(508,264),(38,265),(64,265),(118,265),(154,265),(213,265),(223,265),(245,265),(247,265),(323,265),(400,265),(424,265),(441,265),(511,265),(515,265),(107,266),(222,266),(247,266),(441,266),(451,266),(511,266),(518,266),(247,267),(247,268),(279,268),(400,268),(517,268),(361,269),(447,270),(414,271),(247,272),(173,273),(511,274),(309,275),(361,276),(447,277),(140,278),(447,278),(448,278),(125,279),(201,279),(421,279),(371,280),(309,281),(299,282),(522,282),(484,283),(388,284),(340,285),(107,286),(379,286),(85,287),(180,287),(12,288),(16,288),(38,288),(58,288),(107,288),(114,288),(154,288),(169,288),(193,288),(210,288),(247,288),(249,288),(305,288),(310,288),(342,288),(372,288),(416,288),(441,288),(505,288),(140,289),(107,290),(110,291),(127,292),(441,293),(503,293),(310,294),(26,295),(149,295),(441,295),(493,296),(511,297),(247,298),(171,299),(511,300),(458,301),(82,302),(318,303),(245,304),(511,304),(247,305),(223,306),(269,307),(317,307),(436,308),(171,309),(186,310),(143,311),(149,312),(424,313),(511,313),(4,314),(7,314),(12,314),(18,314),(23,314),(26,314),(37,314),(47,314),(69,314),(92,314),(95,314),(106,314),(118,314),(121,314),(154,314),(164,314),(182,314),(184,314),(193,314),(210,314),(226,314),(258,314),(275,314),(299,314),(301,314),(334,314),(337,314),(339,314),(362,314),(402,314),(416,314),(417,314),(427,314),(431,314),(441,314),(442,314),(451,314),(503,314),(522,314),(525,314),(110,315),(136,315),(283,315),(414,315),(447,315),(247,316),(180,317),(247,318),(69,319),(443,319),(20,320),(36,320),(49,320),(126,320),(181,320),(186,320),(493,320),(527,320),(202,321),(82,322),(175,322),(419,323),(62,324),(202,325),(140,326),(168,326),(269,326),(317,326),(447,326),(92,327),(441,327),(78,328),(110,329),(305,329),(332,329),(249,330),(361,331),(101,332),(506,333),(65,334),(276,334),(202,335),(361,336),(332,337),(483,337),(67,338),(464,338),(511,339),(18,340),(441,340),(110,341),(199,342),(249,342),(200,343),(340,344),(493,344),(361,345),(202,346),(110,347),(441,348),(458,348),(162,349),(441,349),(482,349),(206,350),(69,351),(226,351),(309,351),(447,351),(511,352),(171,353),(447,354),(110,355),(50,356),(110,356),(447,357),(470,358),(85,359),(97,359),(309,359),(361,360),(332,361),(483,361),(426,362),(291,363),(426,363),(6,364),(199,364),(249,364),(110,365),(361,366),(70,367),(238,368),(340,368),(202,369),(219,370),(202,371),(511,372),(81,373),(276,374),(64,375),(377,375),(475,375),(511,375),(114,376),(247,376),(511,376),(0,377),(38,378),(91,378),(110,378),(115,378),(199,378),(234,378),(379,378),(382,378),(469,378),(475,378),(511,378),(518,378),(247,379),(249,380),(0,381),(447,381),(0,382),(441,383),(442,383),(483,384),(486,385),(247,386),(110,387),(249,387),(252,387),(305,387),(426,387),(469,387),(447,388),(125,389),(513,389),(62,390),(301,391),(441,391),(261,392),(400,393),(238,394),(447,395),(115,396),(223,396),(493,397),(181,398),(340,398),(493,398),(247,399),(258,400),(223,401),(202,402),(310,402),(110,403),(202,404),(115,405),(110,406),(247,406),(517,406),(496,407),(402,408),(238,409),(501,410),(310,411),(327,412),(7,413),(441,413),(279,414),(400,414),(517,414),(238,415),(292,416),(112,417),(198,417),(241,417),(308,417),(112,418),(308,418),(310,418),(342,418),(418,418),(103,419),(107,420),(518,420),(180,421),(508,422),(247,423),(340,424),(426,424),(493,424),(23,425),(509,426),(6,427),(20,427),(254,427),(279,427),(310,427),(342,427),(360,427),(400,427),(411,427),(332,428),(511,429),(149,430),(62,431),(249,432),(305,432),(377,432),(426,432),(428,432),(469,432),(420,433),(417,434),(441,434),(511,434),(32,435),(48,435),(62,435),(69,435),(226,435),(447,435),(38,436),(247,436),(317,436),(511,436),(517,436),(247,437),(126,438),(447,439),(269,440),(317,440),(521,440),(171,441),(200,441),(508,441),(511,442),(515,442),(247,443),(511,443),(247,444),(386,444),(247,445),(517,445),(25,446),(238,446),(340,446),(493,446),(107,447),(518,447),(238,448),(329,448),(337,448),(442,448),(115,449),(249,449),(342,449),(360,449),(416,449),(441,449),(198,450),(308,450),(517,450),(256,451),(245,452),(483,453),(121,454),(283,454),(291,454),(310,454),(339,454),(426,454),(475,454),(143,455),(447,456),(448,456),(260,457),(483,458),(310,459),(475,459),(511,459),(115,460),(247,460),(110,461),(527,462),(25,463),(180,463),(245,463),(323,463),(332,463),(483,463),(515,463),(57,464),(230,464),(268,464),(407,464),(414,464),(447,464),(448,464),(460,464),(262,465),(361,466),(110,467),(25,468),(164,468),(334,468),(441,468),(526,469),(180,470),(19,471),(16,472),(145,472),(441,472),(441,473),(525,473),(110,474),(317,475),(447,475),(114,476),(62,477),(247,477),(511,477),(511,478),(107,479),(518,479),(171,480),(200,480),(508,480),(26,481),(37,481),(146,481),(149,481),(361,481),(247,482),(371,482),(365,483),(247,484);
/*!40000 ALTER TABLE `help_relation` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `help_topic`
--

DROP TABLE IF EXISTS `help_topic`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `help_topic` (
  `help_topic_id` int(10) unsigned NOT NULL,
  `name` char(64) NOT NULL,
  `help_category_id` smallint(5) unsigned NOT NULL,
  `description` text NOT NULL,
  `example` text NOT NULL,
  `url` text NOT NULL,
  PRIMARY KEY (`help_topic_id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 STATS_PERSISTENT=0 COMMENT='help topics';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `help_topic`
--

LOCK TABLES `help_topic` WRITE;
/*!40000 ALTER TABLE `help_topic` DISABLE KEYS */;
INSERT INTO `help_topic` VALUES (0,'JOIN',28,'MySQL supports the following JOIN syntaxes for the table_references\npart of SELECT statements and multiple-table DELETE and UPDATE\nstatements:\n\ntable_references:\n    escaped_table_reference [, escaped_table_reference] ...\n\nescaped_table_reference:\n    table_reference\n  | { OJ table_reference }\n\ntable_reference:\n    table_factor\n  | join_table\n\ntable_factor:\n    tbl_name [PARTITION (partition_names)] \n        [[AS] alias] [index_hint_list]\n  | table_subquery [AS] alias\n  | ( table_references )\n\njoin_table:\n    table_reference [INNER | CROSS] JOIN table_factor [join_condition]\n  | table_reference STRAIGHT_JOIN table_factor\n  | table_reference STRAIGHT_JOIN table_factor ON conditional_expr\n  | table_reference {LEFT|RIGHT} [OUTER] JOIN table_reference join_condition\n  | table_reference NATURAL [{LEFT|RIGHT} [OUTER]] JOIN table_factor\n\njoin_condition:\n    ON conditional_expr\n  | USING (column_list)\n\nindex_hint_list:\n    index_hint [, index_hint] ...\n\nindex_hint:\n    USE {INDEX|KEY}\n      [FOR {JOIN|ORDER BY|GROUP BY}] ([index_list])\n  | IGNORE {INDEX|KEY}\n      [FOR {JOIN|ORDER BY|GROUP BY}] (index_list)\n  | FORCE {INDEX|KEY}\n      [FOR {JOIN|ORDER BY|GROUP BY}] (index_list)\n\nindex_list:\n    index_name [, index_name] ...\n\nA table reference is also known as a join expression.\n\nIn MySQL 5.6.2 and later, a table reference (when it refers to a\npartitioned table) may contain a PARTITION option, including a\ncomma-separated list of partitions, subpartitions, or both. This option\nfollows the name of the table and precedes any alias declaration. The\neffect of this option is that rows are selected only from the listed\npartitions or subpartitions---in other words, any partitions or\nsubpartitions not named in the list are ignored For more information,\nsee http://dev.mysql.com/doc/refman/5.6/en/partitioning-selection.html.\n\nThe syntax of table_factor is extended in comparison with the SQL\nStandard. The latter accepts only table_reference, not a list of them\ninside a pair of parentheses.\n\nThis is a conservative extension if we consider each comma in a list of\ntable_reference items as equivalent to an inner join. For example:\n\nSELECT * FROM t1 LEFT JOIN (t2, t3, t4)\n                 ON (t2.a=t1.a AND t3.b=t1.b AND t4.c=t1.c)\n\nis equivalent to:\n\nSELECT * FROM t1 LEFT JOIN (t2 CROSS JOIN t3 CROSS JOIN t4)\n                 ON (t2.a=t1.a AND t3.b=t1.b AND t4.c=t1.c)\n\nIn MySQL, JOIN, CROSS JOIN, and INNER JOIN are syntactic equivalents\n(they can replace each other). In standard SQL, they are not\nequivalent. INNER JOIN is used with an ON clause, CROSS JOIN is used\notherwise.\n\nIn general, parentheses can be ignored in join expressions containing\nonly inner join operations. MySQL also supports nested joins (see\nhttp://dev.mysql.com/doc/refman/5.6/en/nested-join-optimization.html).\n\nIndex hints can be specified to affect how the MySQL optimizer makes\nuse of indexes. For more information, see\nhttp://dev.mysql.com/doc/refman/5.6/en/index-hints.html.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/join.html\n\n','SELECT left_tbl.*\n  FROM left_tbl LEFT JOIN right_tbl ON left_tbl.id = right_tbl.id\n  WHERE right_tbl.id IS NULL;\n','http://dev.mysql.com/doc/refman/5.6/en/join.html'),(1,'HEX',38,'Syntax:\nHEX(str), HEX(N)\n\nFor a string argument str, HEX() returns a hexadecimal string\nrepresentation of str where each character in str is converted to two\nhexadecimal digits. The inverse of this operation is performed by the\nUNHEX() function.\n\nFor a numeric argument N, HEX() returns a hexadecimal string\nrepresentation of the value of N treated as a longlong (BIGINT) number.\nThis is equivalent to CONV(N,10,16). The inverse of this operation is\nperformed by CONV(HEX(N),16,10).\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/string-functions.html\n\n','mysql> SELECT 0x616263, HEX(\'abc\'), UNHEX(HEX(\'abc\'));\n        -> \'abc\', 616263, \'abc\'\nmysql> SELECT HEX(255), CONV(HEX(255),16,10);\n        -> \'FF\', 255\n','http://dev.mysql.com/doc/refman/5.6/en/string-functions.html'),(2,'CONTAINS',31,'Contains(g1,g2)\n\nReturns 1 or 0 to indicate whether g1 completely contains g2. This\ntests the opposite relationship as Within().\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/functions-for-testing-spatial-relations-between-geometric-objects.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/functions-for-testing-spatial-relations-between-geometric-objects.html'),(3,'SRID',37,'SRID(g)\n\nReturns an integer indicating the Spatial Reference System ID for the\ngeometry value g.\n\nIn MySQL, the SRID value is just an integer associated with the\ngeometry value. All calculations are done assuming Euclidean (planar)\ngeometry.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/geometry-property-functions.html\n\n','mysql> SELECT SRID(GeomFromText(\'LineString(1 1,2 2)\',101));\n+-----------------------------------------------+\n| SRID(GeomFromText(\'LineString(1 1,2 2)\',101)) |\n+-----------------------------------------------+\n|                                           101 |\n+-----------------------------------------------+\n','http://dev.mysql.com/doc/refman/5.6/en/geometry-property-functions.html'),(4,'SHOW CONTRIBUTORS',27,'Syntax:\nSHOW CONTRIBUTORS\n\nThe SHOW CONTRIBUTORS statement displays information about the people\nwho contribute to MySQL source or to causes that we support. For each\ncontributor, it displays Name, Location, and Comment values.\n\nThis statement is removed as of MySQL 5.6.8.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/show-contributors.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/show-contributors.html'),(5,'VARIANCE',16,'Syntax:\nVARIANCE(expr)\n\nReturns the population standard variance of expr. This is an extension\nto standard SQL. The standard SQL function VAR_POP() can be used\ninstead.\n\nVARIANCE() returns NULL if there were no matching rows.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/group-by-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/group-by-functions.html'),(6,'DROP SERVER',40,'Syntax:\nDROP SERVER [ IF EXISTS ] server_name\n\nDrops the server definition for the server named server_name. The\ncorresponding row in the mysql.servers table is deleted. This statement\nrequires the SUPER privilege.\n\nDropping a server for a table does not affect any FEDERATED tables that\nused this connection information when they were created. See [HELP\nCREATE SERVER].\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/drop-server.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/drop-server.html'),(7,'SHOW AUTHORS',27,'Syntax:\nSHOW AUTHORS\n\nThe SHOW AUTHORS statement displays information about the people who\nwork on MySQL. For each author, it displays Name, Location, and Comment\nvalues.\n\nThis statement is removed as of MySQL 5.6.8.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/show-authors.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/show-authors.html'),(8,'CONCAT',38,'Syntax:\nCONCAT(str1,str2,...)\n\nReturns the string that results from concatenating the arguments. May\nhave one or more arguments. If all arguments are nonbinary strings, the\nresult is a nonbinary string. If the arguments include any binary\nstrings, the result is a binary string. A numeric argument is converted\nto its equivalent nonbinary string form.\n\nCONCAT() returns NULL if any argument is NULL.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/string-functions.html\n\n','mysql> SELECT CONCAT(\'My\', \'S\', \'QL\');\n        -> \'MySQL\'\nmysql> SELECT CONCAT(\'My\', NULL, \'QL\');\n        -> NULL\nmysql> SELECT CONCAT(14.3);\n        -> \'14.3\'\n','http://dev.mysql.com/doc/refman/5.6/en/string-functions.html'),(9,'GEOMETRY HIERARCHY',35,'Geometry is the base class. It is an abstract class. The instantiable\nsubclasses of Geometry are restricted to zero-, one-, and\ntwo-dimensional geometric objects that exist in two-dimensional\ncoordinate space. All instantiable geometry classes are defined so that\nvalid instances of a geometry class are topologically closed (that is,\nall defined geometries include their boundary).\n\nThe base Geometry class has subclasses for Point, Curve, Surface, and\nGeometryCollection:\n\no Point represents zero-dimensional objects.\n\no Curve represents one-dimensional objects, and has subclass\n  LineString, with sub-subclasses Line and LinearRing.\n\no Surface is designed for two-dimensional objects and has subclass\n  Polygon.\n\no GeometryCollection has specialized zero-, one-, and two-dimensional\n  collection classes named MultiPoint, MultiLineString, and\n  MultiPolygon for modeling geometries corresponding to collections of\n  Points, LineStrings, and Polygons, respectively. MultiCurve and\n  MultiSurface are introduced as abstract superclasses that generalize\n  the collection interfaces to handle Curves and Surfaces.\n\nGeometry, Curve, Surface, MultiCurve, and MultiSurface are defined as\nnoninstantiable classes. They define a common set of methods for their\nsubclasses and are included for extensibility.\n\nPoint, LineString, Polygon, GeometryCollection, MultiPoint,\nMultiLineString, and MultiPolygon are instantiable classes.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/gis-geometry-class-hierarchy.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/gis-geometry-class-hierarchy.html'),(10,'CHAR FUNCTION',38,'Syntax:\nCHAR(N,... [USING charset_name])\n\nCHAR() interprets each argument N as an integer and returns a string\nconsisting of the characters given by the code values of those\nintegers. NULL values are skipped.\nBy default, CHAR() returns a binary string. To produce a string in a\ngiven character set, use the optional USING clause:\n\nmysql> SELECT CHARSET(CHAR(0x65)), CHARSET(CHAR(0x65 USING utf8));\n+---------------------+--------------------------------+\n| CHARSET(CHAR(0x65)) | CHARSET(CHAR(0x65 USING utf8)) |\n+---------------------+--------------------------------+\n| binary              | utf8                           |\n+---------------------+--------------------------------+\n\nIf USING is given and the result string is illegal for the given\ncharacter set, a warning is issued. Also, if strict SQL mode is\nenabled, the result from CHAR() becomes NULL.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/string-functions.html\n\n','mysql> SELECT CHAR(77,121,83,81,\'76\');\n        -> \'MySQL\'\nmysql> SELECT CHAR(77,77.3,\'77.3\');\n        -> \'MMM\'\n','http://dev.mysql.com/doc/refman/5.6/en/string-functions.html'),(11,'SHOW CREATE TRIGGER',27,'Syntax:\nSHOW CREATE TRIGGER trigger_name\n\nThis statement shows a CREATE TRIGGER statement that creates the given\ntrigger.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/show-create-trigger.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/show-create-trigger.html'),(12,'SHOW CREATE PROCEDURE',27,'Syntax:\nSHOW CREATE PROCEDURE proc_name\n\nThis statement is a MySQL extension. It returns the exact string that\ncan be used to re-create the named stored procedure. A similar\nstatement, SHOW CREATE FUNCTION, displays information about stored\nfunctions (see [HELP SHOW CREATE FUNCTION]).\n\nBoth statements require that you be the owner of the routine or have\nSELECT access to the mysql.proc table. If you do not have privileges\nfor the routine itself, the value displayed for the Create Procedure or\nCreate Function field will be NULL.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/show-create-procedure.html\n\n','mysql> SHOW CREATE PROCEDURE test.simpleproc\\G\n*************************** 1. row ***************************\n           Procedure: simpleproc\n            sql_mode:\n    Create Procedure: CREATE PROCEDURE `simpleproc`(OUT param1 INT)\n                      BEGIN\n                      SELECT COUNT(*) INTO param1 FROM t;\n                      END\ncharacter_set_client: latin1\ncollation_connection: latin1_swedish_ci\n  Database Collation: latin1_swedish_ci\n\nmysql> SHOW CREATE FUNCTION test.hello\\G\n*************************** 1. row ***************************\n            Function: hello\n            sql_mode:\n     Create Function: CREATE FUNCTION `hello`(s CHAR(20))\n                      RETURNS CHAR(50)\n                      RETURN CONCAT(\'Hello, \',s,\'!\')\ncharacter_set_client: latin1\ncollation_connection: latin1_swedish_ci\n  Database Collation: latin1_swedish_ci\n','http://dev.mysql.com/doc/refman/5.6/en/show-create-procedure.html'),(13,'OPEN',24,'Syntax:\nOPEN cursor_name\n\nThis statement opens a previously declared cursor. For an example, see\nhttp://dev.mysql.com/doc/refman/5.6/en/cursors.html.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/open.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/open.html'),(14,'ST_INTERSECTS',31,'ST_Intersects(g1,g2)\n\nReturns 1 or 0 to indicate whether g1 spatially intersects g2.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/functions-for-testing-spatial-relations-between-geometric-objects.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/functions-for-testing-spatial-relations-between-geometric-objects.html'),(15,'LOWER',38,'Syntax:\nLOWER(str)\n\nReturns the string str with all characters changed to lowercase\naccording to the current character set mapping. The default is latin1\n(cp1252 West European).\n\nmysql> SELECT LOWER(\'QUADRATICALLY\');\n        -> \'quadratically\'\n\nLOWER() (and UPPER()) are ineffective when applied to binary strings\n(BINARY, VARBINARY, BLOB). To perform lettercase conversion, convert\nthe string to a nonbinary string:\n\nmysql> SET @str = BINARY \'New York\';\nmysql> SELECT LOWER(@str), LOWER(CONVERT(@str USING latin1));\n+-------------+-----------------------------------+\n| LOWER(@str) | LOWER(CONVERT(@str USING latin1)) |\n+-------------+-----------------------------------+\n| New York    | new york                          |\n+-------------+-----------------------------------+\n\nFor Unicode character sets, LOWER() and UPPER() work accounting to\nUnicode Collation Algorithm (UCA) 5.2.0 for xxx_unicode_520_ci\ncollations and for language-specific collations that are derived from\nthem. For other Unicode collations, LOWER() and UPPER() work accounting\nto Unicode Collation Algorithm (UCA) 4.0.0. See\nhttp://dev.mysql.com/doc/refman/5.6/en/charset-unicode-sets.html.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/string-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/string-functions.html'),(16,'CREATE TRIGGER',40,'Syntax:\nCREATE\n    [DEFINER = { user | CURRENT_USER }]\n    TRIGGER trigger_name trigger_time trigger_event\n    ON tbl_name FOR EACH ROW trigger_body\n\nThis statement creates a new trigger. A trigger is a named database\nobject that is associated with a table, and that activates when a\nparticular event occurs for the table. The trigger becomes associated\nwith the table named tbl_name, which must refer to a permanent table.\nYou cannot associate a trigger with a TEMPORARY table or a view.\n\nCREATE TRIGGER requires the TRIGGER privilege for the table associated\nwith the trigger. The statement might also require the SUPER privilege,\ndepending on the DEFINER value, as described later in this section. If\nbinary logging is enabled, CREATE TRIGGER might require the SUPER\nprivilege, as described in\nhttp://dev.mysql.com/doc/refman/5.6/en/stored-programs-logging.html.\n\nThe DEFINER clause determines the security context to be used when\nchecking access privileges at trigger activation time. See later in\nthis section for more information.\n\ntrigger_time is the trigger action time. It can be BEFORE or AFTER to\nindicate that the trigger activates before or after each row to be\nmodified.\n\ntrigger_event indicates the kind of statement that activates the\ntrigger. The trigger_event can be one of the following:\n\no INSERT: The trigger is activated whenever a new row is inserted into\n  the table; for example, through INSERT, LOAD DATA, and REPLACE\n  statements.\n\no UPDATE: The trigger is activated whenever a row is modified; for\n  example, through UPDATE statements.\n\no DELETE: The trigger is activated whenever a row is deleted from the\n  table; for example, through DELETE and REPLACE statements. However,\n  DROP TABLE and TRUNCATE TABLE statements on the table do not activate\n  this trigger, because they do not use DELETE. Dropping a partition\n  does not activate DELETE triggers, either. See [HELP TRUNCATE TABLE].\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/create-trigger.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/create-trigger.html'),(17,'MONTH',32,'Syntax:\nMONTH(date)\n\nReturns the month for date, in the range 1 to 12 for January to\nDecember, or 0 for dates such as \'0000-00-00\' or \'2008-00-00\' that have\na zero month part.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html\n\n','mysql> SELECT MONTH(\'2008-02-03\');\n        -> 2\n','http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html'),(18,'SHOW TRIGGERS',27,'Syntax:\nSHOW TRIGGERS [{FROM | IN} db_name]\n    [LIKE \'pattern\' | WHERE expr]\n\nSHOW TRIGGERS lists the triggers currently defined for tables in a\ndatabase (the default database unless a FROM clause is given). This\nstatement returns results only for databases and tables for which you\nhave the TRIGGER privilege. The LIKE clause, if present, indicates\nwhich table names to match and causes the statement to display triggers\nfor those tables. The WHERE clause can be given to select rows using\nmore general conditions, as discussed in\nhttp://dev.mysql.com/doc/refman/5.6/en/extended-show.html.\n\nFor the trigger ins_sum as defined in\nhttp://dev.mysql.com/doc/refman/5.6/en/triggers.html, the output of\nthis statement is as shown here:\n\nmysql> SHOW TRIGGERS LIKE \'acc%\'\\G\n*************************** 1. row ***************************\n             Trigger: ins_sum\n               Event: INSERT\n               Table: account\n           Statement: SET @sum = @sum + NEW.amount\n              Timing: BEFORE\n             Created: NULL\n            sql_mode:\n             Definer: myname@localhost\ncharacter_set_client: latin1\ncollation_connection: latin1_swedish_ci\n  Database Collation: latin1_swedish_ci\n\ncharacter_set_client is the session value of the character_set_client\nsystem variable when the trigger was created. collation_connection is\nthe session value of the collation_connection system variable when the\ntrigger was created. Database Collation is the collation of the\ndatabase with which the trigger is associated.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/show-triggers.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/show-triggers.html'),(19,'REGEXP',38,'Syntax:\nexpr REGEXP pat, expr RLIKE pat\n\nPerforms a pattern match of a string expression expr against a pattern\npat. The pattern can be an extended regular expression. The syntax for\nregular expressions is discussed in\nhttp://dev.mysql.com/doc/refman/5.6/en/regexp.html. Returns 1 if expr\nmatches pat; otherwise it returns 0. If either expr or pat is NULL, the\nresult is NULL. RLIKE is a synonym for REGEXP, provided for mSQL\ncompatibility.\n\nThe pattern need not be a literal string. For example, it can be\nspecified as a string expression or table column.\n\n*Note*: Because MySQL uses the C escape syntax in strings (for example,\n\"\\n\" to represent the newline character), you must double any \"\\\" that\nyou use in your REGEXP strings.\n\nREGEXP is not case sensitive, except when used with binary strings.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/regexp.html\n\n','mysql> SELECT \'Monty!\' REGEXP \'.*\';\n        -> 1\nmysql> SELECT \'new*\\n*line\' REGEXP \'new\\\\*.\\\\*line\';\n        -> 1\nmysql> SELECT \'a\' REGEXP \'A\', \'a\' REGEXP BINARY \'A\';\n        -> 1  0\nmysql> SELECT \'a\' REGEXP \'^[a-d]\';\n        -> 1\n','http://dev.mysql.com/doc/refman/5.6/en/regexp.html'),(20,'IF STATEMENT',24,'Syntax:\nIF search_condition THEN statement_list\n    [ELSEIF search_condition THEN statement_list] ...\n    [ELSE statement_list]\nEND IF\n\nThe IF statement for stored programs implements a basic conditional\nconstruct.\n\n*Note*: There is also an IF() function, which differs from the IF\nstatement described here. See\nhttp://dev.mysql.com/doc/refman/5.6/en/control-flow-functions.html. The\nIF statement can have THEN, ELSE, and ELSEIF clauses, and it is\nterminated with END IF.\n\nIf the search_condition evaluates to true, the corresponding THEN or\nELSEIF clause statement_list executes. If no search_condition matches,\nthe ELSE clause statement_list executes.\n\nEach statement_list consists of one or more SQL statements; an empty\nstatement_list is not permitted.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/if.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/if.html'),(21,'VALIDATE_PASSWORD_STRENGTH',12,'Syntax:\nVALIDATE_PASSWORD_STRENGTH(str)\n\nGiven an argument representing a cleartext password, this function\nreturns an integer to indicate how strong the password is. The return\nvalue ranges from 0 (weak) to 100 (strong).\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/encryption-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/encryption-functions.html'),(22,'WITHIN',31,'Within(g1,g2)\n\nReturns 1 or 0 to indicate whether g1 is spatially within g2. This\ntests the opposite relationship as Contains().\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/functions-for-testing-spatial-relations-between-geometric-objects.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/functions-for-testing-spatial-relations-between-geometric-objects.html'),(23,'SHOW PLUGINS',27,'Syntax:\nSHOW PLUGINS\n\nSHOW PLUGINS displays information about server plugins. Plugin\ninformation is also available in the INFORMATION_SCHEMA.PLUGINS table.\nSee http://dev.mysql.com/doc/refman/5.6/en/plugins-table.html.\n\nExample of SHOW PLUGINS output:\n\nmysql> SHOW PLUGINS\\G\n*************************** 1. row ***************************\n   Name: binlog\n Status: ACTIVE\n   Type: STORAGE ENGINE\nLibrary: NULL\nLicense: GPL\n*************************** 2. row ***************************\n   Name: CSV\n Status: ACTIVE\n   Type: STORAGE ENGINE\nLibrary: NULL\nLicense: GPL\n*************************** 3. row ***************************\n   Name: MEMORY\n Status: ACTIVE\n   Type: STORAGE ENGINE\nLibrary: NULL\nLicense: GPL\n*************************** 4. row ***************************\n   Name: MyISAM\n Status: ACTIVE\n   Type: STORAGE ENGINE\nLibrary: NULL\nLicense: GPL\n...\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/show-plugins.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/show-plugins.html'),(24,'PREPARE',8,'Syntax:\nPREPARE stmt_name FROM preparable_stmt\n\nThe PREPARE statement prepares a SQL statement and assigns it a name,\nstmt_name, by which to refer to the statement later. The prepared\nstatement is executed with EXECUTE and released with DEALLOCATE\nPREPARE. For examples, see\nhttp://dev.mysql.com/doc/refman/5.6/en/sql-syntax-prepared-statements.h\ntml.\n\nStatement names are not case sensitive. preparable_stmt is either a\nstring literal or a user variable that contains the text of the SQL\nstatement. The text must represent a single statement, not multiple\nstatements. Within the statement, ? characters can be used as parameter\nmarkers to indicate where data values are to be bound to the query\nlater when you execute it. The ? characters should not be enclosed\nwithin quotation marks, even if you intend to bind them to string\nvalues. Parameter markers can be used only where data values should\nappear, not for SQL keywords, identifiers, and so forth.\n\nIf a prepared statement with the given name already exists, it is\ndeallocated implicitly before the new statement is prepared. This means\nthat if the new statement contains an error and cannot be prepared, an\nerror is returned and no statement with the given name exists.\n\nThe scope of a prepared statement is the session within which it is\ncreated, which as several implications:\n\no A prepared statement created in one session is not available to other\n  sessions.\n\no When a session ends, whether normally or abnormally, its prepared\n  statements no longer exist. If auto-reconnect is enabled, the client\n  is not notified that the connection was lost. For this reason,\n  clients may wish to disable auto-reconnect. See\n  http://dev.mysql.com/doc/refman/5.6/en/auto-reconnect.html.\n\no A prepared statement created within a stored program continues to\n  exist after the program finishes executing and can be executed\n  outside the program later.\n\no A statement prepared in stored program context cannot refer to stored\n  procedure or function parameters or local variables because they go\n  out of scope when the program ends and would be unavailable were the\n  statement to be executed later outside the program. As a workaround,\n  refer instead to user-defined variables, which also have session\n  scope; see\n  http://dev.mysql.com/doc/refman/5.6/en/user-variables.html.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/prepare.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/prepare.html'),(25,'LOCK',8,'Syntax:\nLOCK TABLES\n    tbl_name [[AS] alias] lock_type\n    [, tbl_name [[AS] alias] lock_type] ...\n\nlock_type:\n    READ [LOCAL]\n  | [LOW_PRIORITY] WRITE\n\nUNLOCK TABLES\n\nMySQL enables client sessions to acquire table locks explicitly for the\npurpose of cooperating with other sessions for access to tables, or to\nprevent other sessions from modifying tables during periods when a\nsession requires exclusive access to them. A session can acquire or\nrelease locks only for itself. One session cannot acquire locks for\nanother session or release locks held by another session.\n\nLocks may be used to emulate transactions or to get more speed when\nupdating tables. This is explained in more detail later in this\nsection.\n\nLOCK TABLES explicitly acquires table locks for the current client\nsession. Table locks can be acquired for base tables or views. You must\nhave the LOCK TABLES privilege, and the SELECT privilege for each\nobject to be locked.\n\nFor view locking, LOCK TABLES adds all base tables used in the view to\nthe set of tables to be locked and locks them automatically. If you\nlock a table explicitly with LOCK TABLES, any tables used in triggers\nare also locked implicitly, as described in\nhttp://dev.mysql.com/doc/refman/5.6/en/lock-tables-and-triggers.html.\n\nUNLOCK TABLES explicitly releases any table locks held by the current\nsession. LOCK TABLES implicitly releases any table locks held by the\ncurrent session before acquiring new locks.\n\nAnother use for UNLOCK TABLES is to release the global read lock\nacquired with the FLUSH TABLES WITH READ LOCK statement, which enables\nyou to lock all tables in all databases. See [HELP FLUSH]. (This is a\nvery convenient way to get backups if you have a file system such as\nVeritas that can take snapshots in time.)\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/lock-tables.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/lock-tables.html'),(26,'SHOW BINARY LOGS',27,'Syntax:\nSHOW BINARY LOGS\nSHOW MASTER LOGS\n\nLists the binary log files on the server. This statement is used as\npart of the procedure described in [HELP PURGE BINARY LOGS], that shows\nhow to determine which logs can be purged.\n\nmysql> SHOW BINARY LOGS;\n+---------------+-----------+\n| Log_name      | File_size |\n+---------------+-----------+\n| binlog.000015 |    724935 |\n| binlog.000016 |    733481 |\n+---------------+-----------+\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/show-binary-logs.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/show-binary-logs.html'),(27,'POLYGON',25,'Polygon(ls1,ls2,...)\n\nConstructs a Polygon value from a number of LineString or WKB\nLineString arguments. If any argument does not represent a LinearRing\n(that is, not a closed and simple LineString), the return value is\nNULL.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/creating-spatial-values.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/creating-spatial-values.html'),(28,'MINUTE',32,'Syntax:\nMINUTE(time)\n\nReturns the minute for time, in the range 0 to 59.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html\n\n','mysql> SELECT MINUTE(\'2008-02-03 10:05:03\');\n        -> 5\n','http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html'),(29,'MID',38,'Syntax:\nMID(str,pos,len)\n\nMID(str,pos,len) is a synonym for SUBSTRING(str,pos,len).\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/string-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/string-functions.html'),(30,'CONNECTION_ID',17,'Syntax:\nCONNECTION_ID()\n\nReturns the connection ID (thread ID) for the connection. Every\nconnection has an ID that is unique among the set of currently\nconnected clients.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/information-functions.html\n\n','mysql> SELECT CONNECTION_ID();\n        -> 23786\n','http://dev.mysql.com/doc/refman/5.6/en/information-functions.html'),(31,'FROM_BASE64()',38,'Syntax:\nFROM_BASE64(str)\n\nTakes a string encoded with the base-64 encoded rules used by\nTO_BASE64() and returns the decoded result as a binary string. The\nresult is NULL if the argument is NULL or not a valid base-64 string.\nSee the description of TO_BASE64() for details about the encoding and\ndecoding rules.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/string-functions.html\n\n','mysql> SELECT TO_BASE64(\'abc\'), FROM_BASE64(TO_BASE64(\'abc\'));\n        -> \'JWJj\', \'abc\'\n','http://dev.mysql.com/doc/refman/5.6/en/string-functions.html'),(32,'DELETE',28,'Syntax:\nDELETE is a DML statement that removes rows from a table.\n\nSingle-table syntax:\n\nDELETE [LOW_PRIORITY] [QUICK] [IGNORE] FROM tbl_name\n    [PARTITION (partition_name,...)]\n    [WHERE where_condition]\n    [ORDER BY ...]\n    [LIMIT row_count]\n\nThe DELETE statement deletes rows from tbl_name and returns the number\nof deleted rows. To check the number of deleted rows, call the\nROW_COUNT() function described in\nhttp://dev.mysql.com/doc/refman/5.6/en/information-functions.html.\n\nMain Clauses\n\nThe conditions in the optional WHERE clause identify which rows to\ndelete. With no WHERE clause, all rows are deleted.\n\nwhere_condition is an expression that evaluates to true for each row to\nbe deleted. It is specified as described in\nhttp://dev.mysql.com/doc/refman/5.6/en/select.html.\n\nIf the ORDER BY clause is specified, the rows are deleted in the order\nthat is specified. The LIMIT clause places a limit on the number of\nrows that can be deleted. These clauses apply to single-table deletes,\nbut not multi-table deletes.\n\nMultiple-table syntax:\n\nDELETE [LOW_PRIORITY] [QUICK] [IGNORE]\n    tbl_name[.*] [, tbl_name[.*]] ...\n    FROM table_references\n    [WHERE where_condition]\n\nOr:\n\nDELETE [LOW_PRIORITY] [QUICK] [IGNORE]\n    FROM tbl_name[.*] [, tbl_name[.*]] ...\n    USING table_references\n    [WHERE where_condition]\n\nPrivileges\n\nYou need the DELETE privilege on a table to delete rows from it. You\nneed only the SELECT privilege for any columns that are only read, such\nas those named in the WHERE clause.\n\nPerformance\n\nWhen you do not need to know the number of deleted rows, the TRUNCATE\nTABLE statement is a faster way to empty a table than a DELETE\nstatement with no WHERE clause. Unlike DELETE, TRUNCATE TABLE cannot be\nused within a transaction or if you have a lock on the table. See [HELP\nTRUNCATE TABLE] and [HELP LOCK].\n\nThe speed of delete operations may also be affected by factors\ndiscussed in http://dev.mysql.com/doc/refman/5.6/en/delete-speed.html.\n\nTo ensure that a given DELETE statement does not take too much time,\nthe MySQL-specific LIMIT row_count clause for DELETE specifies the\nmaximum number of rows to be deleted. If the number of rows to delete\nis larger than the limit, repeat the DELETE statement until the number\nof affected rows is less than the LIMIT value.\n\nSubqueries\n\nCurrently, you cannot delete from a table and select from the same\ntable in a subquery.\n\nPartitioned Tables\n\nBeginning with MySQL 5.6.2, DELETE supports explicit partition\nselection using the PARTITION option, which takes a comma-separated\nlist of the names of one or more partitions or subpartitions (or both)\nfrom which to select rows to be dropped. Partitions not included in the\nlist are ignored. Given a partitioned table t with a partition named\np0, executing the statement DELETE FROM t PARTITION (p0) has the same\neffect on the table as executing ALTER TABLE t TRUNCATE PARTITION (p0);\nin both cases, all rows in partition p0 are dropped.\n\nPARTITION can be used along with a WHERE condition, in which case the\ncondition is tested only on rows in the listed partitions. For example,\nDELETE FROM t PARTITION (p0) WHERE c < 5 deletes rows only from\npartition p0 for which the condition c < 5 is true; rows in any other\npartitions are not checked and thus not affected by the DELETE.\n\nThe PARTITION option can also be used in multiple-table DELETE\nstatements. You can use up to one such option per table named in the\nFROM option.\n\nSee http://dev.mysql.com/doc/refman/5.6/en/partitioning-selection.html,\nfor more information and examples.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/delete.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/delete.html'),(33,'CLOSE',24,'Syntax:\nCLOSE cursor_name\n\nThis statement closes a previously opened cursor. For an example, see\nhttp://dev.mysql.com/doc/refman/5.6/en/cursors.html.\n\nAn error occurs if the cursor is not open.\n\nIf not closed explicitly, a cursor is closed at the end of the BEGIN\n... END block in which it was declared.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/close.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/close.html'),(34,'REPLACE FUNCTION',38,'Syntax:\nREPLACE(str,from_str,to_str)\n\nReturns the string str with all occurrences of the string from_str\nreplaced by the string to_str. REPLACE() performs a case-sensitive\nmatch when searching for from_str.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/string-functions.html\n\n','mysql> SELECT REPLACE(\'www.mysql.com\', \'w\', \'Ww\');\n        -> \'WwWwWw.mysql.com\'\n','http://dev.mysql.com/doc/refman/5.6/en/string-functions.html'),(35,'USE',29,'Syntax:\nUSE db_name\n\nThe USE db_name statement tells MySQL to use the db_name database as\nthe default (current) database for subsequent statements. The database\nremains the default until the end of the session or another USE\nstatement is issued:\n\nUSE db1;\nSELECT COUNT(*) FROM mytable;   # selects from db1.mytable\nUSE db2;\nSELECT COUNT(*) FROM mytable;   # selects from db2.mytable\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/use.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/use.html'),(36,'CASE OPERATOR',7,'Syntax:\nCASE value WHEN [compare_value] THEN result [WHEN [compare_value] THEN\nresult ...] [ELSE result] END\n\nCASE WHEN [condition] THEN result [WHEN [condition] THEN result ...]\n[ELSE result] END\n\nThe first version returns the result where value=compare_value. The\nsecond version returns the result for the first condition that is true.\nIf there was no matching result value, the result after ELSE is\nreturned, or NULL if there is no ELSE part.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/control-flow-functions.html\n\n','mysql> SELECT CASE 1 WHEN 1 THEN \'one\'\n    ->     WHEN 2 THEN \'two\' ELSE \'more\' END;\n        -> \'one\'\nmysql> SELECT CASE WHEN 1>0 THEN \'true\' ELSE \'false\' END;\n        -> \'true\'\nmysql> SELECT CASE BINARY \'B\'\n    ->     WHEN \'a\' THEN 1 WHEN \'b\' THEN 2 END;\n        -> NULL\n','http://dev.mysql.com/doc/refman/5.6/en/control-flow-functions.html'),(37,'SHOW MASTER STATUS',27,'Syntax:\nSHOW MASTER STATUS\n\nThis statement provides status information about the binary log files\nof the master. It requires either the SUPER or REPLICATION CLIENT\nprivilege.\n\nExample:\n\nmysql> SHOW MASTER STATUS\\G\n*************************** 1. row ***************************\n             File: master-bin.000002\n         Position: 1307\n     Binlog_Do_DB: test\n Binlog_Ignore_DB: manual, mysql\nExecuted_Gtid_Set: 3E11FA47-71CA-11E1-9E33-C80AA9429562:1-5\n1 row in set (0.00 sec)\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/show-master-status.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/show-master-status.html'),(38,'SPATIAL',35,'For MyISAM tables, MySQL can create spatial indexes using syntax\nsimilar to that for creating regular indexes, but extended with the\nSPATIAL keyword. Currently, columns in spatial indexes must be declared\nNOT NULL. The following examples demonstrate how to create spatial\nindexes:\n\no With CREATE TABLE:\n\nCREATE TABLE geom (g GEOMETRY NOT NULL, SPATIAL INDEX(g)) ENGINE=MyISAM;\n\no With ALTER TABLE:\n\nALTER TABLE geom ADD SPATIAL INDEX(g);\n\no With CREATE INDEX:\n\nCREATE SPATIAL INDEX sp_index ON geom (g);\n\nFor MyISAM tables, SPATIAL INDEX creates an R-tree index. For storage\nengines that support nonspatial indexing of spatial columns, the engine\ncreates a B-tree index. A B-tree index on spatial values will be useful\nfor exact-value lookups, but not for range scans.\n\nFor more information on indexing spatial columns, see [HELP CREATE\nINDEX].\n\nTo drop spatial indexes, use ALTER TABLE or DROP INDEX:\n\no With ALTER TABLE:\n\nALTER TABLE geom DROP INDEX g;\n\no With DROP INDEX:\n\nDROP INDEX sp_index ON geom;\n\nExample: Suppose that a table geom contains more than 32,000\ngeometries, which are stored in the column g of type GEOMETRY. The\ntable also has an AUTO_INCREMENT column fid for storing object ID\nvalues.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/creating-spatial-indexes.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/creating-spatial-indexes.html'),(39,'TO_SECONDS',32,'Syntax:\nTO_SECONDS(expr)\n\nGiven a date or datetime expr, returns a the number of seconds since\nthe year 0. If expr is not a valid date or datetime value, returns\nNULL.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html\n\n','mysql> SELECT TO_SECONDS(950501);\n        -> 62966505600\nmysql> SELECT TO_SECONDS(\'2009-11-29\');\n        -> 63426672000\nmysql> SELECT TO_SECONDS(\'2009-11-29 13:43:32\');\n        -> 63426721412\nmysql> SELECT TO_SECONDS( NOW() );\n        -> 63426721458\n','http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html'),(40,'TIMESTAMPDIFF',32,'Syntax:\nTIMESTAMPDIFF(unit,datetime_expr1,datetime_expr2)\n\nReturns datetime_expr2 - datetime_expr1, where datetime_expr1 and\ndatetime_expr2 are date or datetime expressions. One expression may be\na date and the other a datetime; a date value is treated as a datetime\nhaving the time part \'00:00:00\' where necessary. The unit for the\nresult (an integer) is given by the unit argument. The legal values for\nunit are the same as those listed in the description of the\nTIMESTAMPADD() function.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html\n\n','mysql> SELECT TIMESTAMPDIFF(MONTH,\'2003-02-01\',\'2003-05-01\');\n        -> 3\nmysql> SELECT TIMESTAMPDIFF(YEAR,\'2002-05-01\',\'2001-01-01\');\n        -> -1\nmysql> SELECT TIMESTAMPDIFF(MINUTE,\'2003-02-01\',\'2003-05-01 12:05:55\');\n        -> 128885\n','http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html'),(41,'REVERSE',38,'Syntax:\nREVERSE(str)\n\nReturns the string str with the order of the characters reversed.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/string-functions.html\n\n','mysql> SELECT REVERSE(\'abc\');\n        -> \'cba\'\n','http://dev.mysql.com/doc/refman/5.6/en/string-functions.html'),(42,'ISNULL',19,'Syntax:\nISNULL(expr)\n\nIf expr is NULL, ISNULL() returns 1, otherwise it returns 0.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/comparison-operators.html\n\n','mysql> SELECT ISNULL(1+1);\n        -> 0\nmysql> SELECT ISNULL(1/0);\n        -> 1\n','http://dev.mysql.com/doc/refman/5.6/en/comparison-operators.html'),(43,'BINARY',23,'BINARY(M)\n\nThe BINARY type is similar to the CHAR type, but stores binary byte\nstrings rather than nonbinary character strings. M represents the\ncolumn length in bytes.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/string-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/string-type-overview.html'),(44,'BLOB DATA TYPE',23,'A BLOB is a binary large object that can hold a variable amount of\ndata. The four BLOB types are TINYBLOB, BLOB, MEDIUMBLOB, and LONGBLOB.\nThese differ only in the maximum length of the values they can hold.\nThe four TEXT types are TINYTEXT, TEXT, MEDIUMTEXT, and LONGTEXT. These\ncorrespond to the four BLOB types and have the same maximum lengths and\nstorage requirements. See\nhttp://dev.mysql.com/doc/refman/5.6/en/storage-requirements.html.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/blob.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/blob.html'),(45,'CURRENT_USER',17,'Syntax:\nCURRENT_USER, CURRENT_USER()\n\nReturns the user name and host name combination for the MySQL account\nthat the server used to authenticate the current client. This account\ndetermines your access privileges. The return value is a string in the\nutf8 character set.\n\nThe value of CURRENT_USER() can differ from the value of USER().\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/information-functions.html\n\n','mysql> SELECT USER();\n        -> \'davida@localhost\'\nmysql> SELECT * FROM mysql.user;\nERROR 1044: Access denied for user \'\'@\'localhost\' to\ndatabase \'mysql\'\nmysql> SELECT CURRENT_USER();\n        -> \'@localhost\'\n','http://dev.mysql.com/doc/refman/5.6/en/information-functions.html'),(46,'<=',19,'Syntax:\n<=\n\nLess than or equal:\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/comparison-operators.html\n\n','mysql> SELECT 0.1 <= 2;\n        -> 1\n','http://dev.mysql.com/doc/refman/5.6/en/comparison-operators.html'),(47,'SHOW PROFILES',27,'Syntax:\nSHOW PROFILES\n\nThe SHOW PROFILES statement, together with SHOW PROFILE, displays\nprofiling information that indicates resource usage for statements\nexecuted during the course of the current session. For more\ninformation, see [HELP SHOW PROFILE].\n\n*Note*: These statements are deprecated as of MySQL 5.6.7 and will be\nremoved in a future MySQL release. Use the Performance Schema instead;\nsee http://dev.mysql.com/doc/refman/5.6/en/performance-schema.html.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/show-profiles.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/show-profiles.html'),(48,'UPDATE',28,'Syntax:\nSingle-table syntax:\n\nUPDATE [LOW_PRIORITY] [IGNORE] table_reference\n    SET col_name1={expr1|DEFAULT} [, col_name2={expr2|DEFAULT}] ...\n    [WHERE where_condition]\n    [ORDER BY ...]\n    [LIMIT row_count]\n\nMultiple-table syntax:\n\nUPDATE [LOW_PRIORITY] [IGNORE] table_references\n    SET col_name1={expr1|DEFAULT} [, col_name2={expr2|DEFAULT}] ...\n    [WHERE where_condition]\n\nFor the single-table syntax, the UPDATE statement updates columns of\nexisting rows in the named table with new values. The SET clause\nindicates which columns to modify and the values they should be given.\nEach value can be given as an expression, or the keyword DEFAULT to set\na column explicitly to its default value. The WHERE clause, if given,\nspecifies the conditions that identify which rows to update. With no\nWHERE clause, all rows are updated. If the ORDER BY clause is\nspecified, the rows are updated in the order that is specified. The\nLIMIT clause places a limit on the number of rows that can be updated.\n\nFor the multiple-table syntax, UPDATE updates rows in each table named\nin table_references that satisfy the conditions. In this case, ORDER BY\nand LIMIT cannot be used.\n\nFor partitioned tables, both the single-single and multiple-table forms\nof this statement support the use of a PARTITION option as part of a\ntable reference. This option takes a list of one or more partitions or\nsubpartitions (or both). Only the partitions (or subpartitions) listed\nare checked for matches, and a row that is not in any of these\npartitions or subpartitions is not updated, whether it satisfies the\nwhere_condition or not.\n\n*Note*: Unlike the case when using PARTITION with an INSERT or REPLACE\nstatement, an otherwise valid UPDATE ... PARTITION statement is\nconsidered successful even if no rows in the listed partitions (or\nsubpartitions) match the where_condition.\n\nSee http://dev.mysql.com/doc/refman/5.6/en/partitioning-selection.html,\nfor more information and examples.\n\nwhere_condition is an expression that evaluates to true for each row to\nbe updated. For expression syntax, see\nhttp://dev.mysql.com/doc/refman/5.6/en/expressions.html.\n\ntable_references and where_condition are is specified as described in\nhttp://dev.mysql.com/doc/refman/5.6/en/select.html.\n\nYou need the UPDATE privilege only for columns referenced in an UPDATE\nthat are actually updated. You need only the SELECT privilege for any\ncolumns that are read but not modified.\n\nThe UPDATE statement supports the following modifiers:\n\no With the LOW_PRIORITY keyword, execution of the UPDATE is delayed\n  until no other clients are reading from the table. This affects only\n  storage engines that use only table-level locking (such as MyISAM,\n  MEMORY, and MERGE).\n\no With the IGNORE keyword, the update statement does not abort even if\n  errors occur during the update. Rows for which duplicate-key\n  conflicts occur are not updated. Rows for which columns are updated\n  to values that would cause data conversion errors are updated to the\n  closest valid values instead.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/update.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/update.html'),(49,'CASE STATEMENT',24,'Syntax:\nCASE case_value\n    WHEN when_value THEN statement_list\n    [WHEN when_value THEN statement_list] ...\n    [ELSE statement_list]\nEND CASE\n\nOr:\n\nCASE\n    WHEN search_condition THEN statement_list\n    [WHEN search_condition THEN statement_list] ...\n    [ELSE statement_list]\nEND CASE\n\nThe CASE statement for stored programs implements a complex conditional\nconstruct.\n\n*Note*: There is also a CASE expression, which differs from the CASE\nstatement described here. See\nhttp://dev.mysql.com/doc/refman/5.6/en/control-flow-functions.html. The\nCASE statement cannot have an ELSE NULL clause, and it is terminated\nwith END CASE instead of END.\n\nFor the first syntax, case_value is an expression. This value is\ncompared to the when_value expression in each WHEN clause until one of\nthem is equal. When an equal when_value is found, the corresponding\nTHEN clause statement_list executes. If no when_value is equal, the\nELSE clause statement_list executes, if there is one.\n\nThis syntax cannot be used to test for equality with NULL because NULL\n= NULL is false. See\nhttp://dev.mysql.com/doc/refman/5.6/en/working-with-null.html.\n\nFor the second syntax, each WHEN clause search_condition expression is\nevaluated until one is true, at which point its corresponding THEN\nclause statement_list executes. If no search_condition is equal, the\nELSE clause statement_list executes, if there is one.\n\nIf no when_value or search_condition matches the value tested and the\nCASE statement contains no ELSE clause, a Case not found for CASE\nstatement error results.\n\nEach statement_list consists of one or more SQL statements; an empty\nstatement_list is not permitted.\n\nTo handle situations where no value is matched by any WHEN clause, use\nan ELSE containing an empty BEGIN ... END block, as shown in this\nexample. (The indentation used here in the ELSE clause is for purposes\nof clarity only, and is not otherwise significant.)\n\nDELIMITER |\n\nCREATE PROCEDURE p()\n  BEGIN\n    DECLARE v INT DEFAULT 1;\n\n    CASE v\n      WHEN 2 THEN SELECT v;\n      WHEN 3 THEN SELECT 0;\n      ELSE\n        BEGIN\n        END;\n    END CASE;\n  END;\n  |\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/case.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/case.html'),(50,'EXECUTE STATEMENT',8,'Syntax:\nEXECUTE stmt_name\n    [USING @var_name [, @var_name] ...]\n\nAfter preparing a statement with PREPARE, you execute it with an\nEXECUTE statement that refers to the prepared statement name. If the\nprepared statement contains any parameter markers, you must supply a\nUSING clause that lists user variables containing the values to be\nbound to the parameters. Parameter values can be supplied only by user\nvariables, and the USING clause must name exactly as many variables as\nthe number of parameter markers in the statement.\n\nYou can execute a given prepared statement multiple times, passing\ndifferent variables to it or setting the variables to different values\nbefore each execution.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/execute.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/execute.html'),(51,'DROP INDEX',40,'Syntax:\nDROP INDEX index_name ON tbl_name\n    [algorithm_option | lock_option] ...\n\nalgorithm_option:\n    ALGORITHM [=] {DEFAULT|INPLACE|COPY}\n\nlock_option:\n    LOCK [=] {DEFAULT|NONE|SHARED|EXCLUSIVE}\n\nDROP INDEX drops the index named index_name from the table tbl_name.\nThis statement is mapped to an ALTER TABLE statement to drop the index.\nSee [HELP ALTER TABLE].\n\nTo drop a primary key, the index name is always PRIMARY, which must be\nspecified as a quoted identifier because PRIMARY is a reserved word:\n\nDROP INDEX `PRIMARY` ON t;\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/drop-index.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/drop-index.html'),(52,'ABS',4,'Syntax:\nABS(X)\n\nReturns the absolute value of X.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/mathematical-functions.html\n\n','mysql> SELECT ABS(2);\n        -> 2\nmysql> SELECT ABS(-32);\n        -> 32\n','http://dev.mysql.com/doc/refman/5.6/en/mathematical-functions.html'),(53,'IS_IPV4',14,'Syntax:\nIS_IPV4(expr)\n\nReturns 1 if the argument is a valid IPv4 address specified as a\nstring, 0 otherwise.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/miscellaneous-functions.html\n\n','mysql> SELECT IS_IPV4(\'10.0.5.9\'), IS_IPV4(\'10.0.5.256\');\n        -> 1, 0\n','http://dev.mysql.com/doc/refman/5.6/en/miscellaneous-functions.html'),(54,'POLYFROMWKB',33,'PolyFromWKB(wkb[,srid]), PolygonFromWKB(wkb[,srid])\n\nConstructs a POLYGON value using its WKB representation and SRID.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/creating-spatial-values.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/creating-spatial-values.html'),(55,'NOT LIKE',38,'Syntax:\nexpr NOT LIKE pat [ESCAPE \'escape_char\']\n\nThis is the same as NOT (expr LIKE pat [ESCAPE \'escape_char\']).\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/string-comparison-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/string-comparison-functions.html'),(56,'SPACE',38,'Syntax:\nSPACE(N)\n\nReturns a string consisting of N space characters.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/string-functions.html\n\n','mysql> SELECT SPACE(6);\n        -> \'      \'\n','http://dev.mysql.com/doc/refman/5.6/en/string-functions.html'),(57,'MAX',16,'Syntax:\nMAX([DISTINCT] expr)\n\nReturns the maximum value of expr. MAX() may take a string argument; in\nsuch cases, it returns the maximum string value. See\nhttp://dev.mysql.com/doc/refman/5.6/en/mysql-indexes.html. The DISTINCT\nkeyword can be used to find the maximum of the distinct values of expr,\nhowever, this produces the same result as omitting DISTINCT.\n\nMAX() returns NULL if there were no matching rows.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/group-by-functions.html\n\n','mysql> SELECT student_name, MIN(test_score), MAX(test_score)\n    ->        FROM student\n    ->        GROUP BY student_name;\n','http://dev.mysql.com/doc/refman/5.6/en/group-by-functions.html'),(58,'CREATE FUNCTION UDF',22,'Syntax:\nCREATE [AGGREGATE] FUNCTION function_name RETURNS {STRING|INTEGER|REAL|DECIMAL}\n    SONAME shared_library_name\n\nA user-defined function (UDF) is a way to extend MySQL with a new\nfunction that works like a native (built-in) MySQL function such as\nABS() or CONCAT().\n\nfunction_name is the name that should be used in SQL statements to\ninvoke the function. The RETURNS clause indicates the type of the\nfunction\'s return value. DECIMAL is a legal value after RETURNS, but\ncurrently DECIMAL functions return string values and should be written\nlike STRING functions.\n\nshared_library_name is the basename of the shared object file that\ncontains the code that implements the function. The file must be\nlocated in the plugin directory. This directory is given by the value\nof the plugin_dir system variable. For more information, see\nhttp://dev.mysql.com/doc/refman/5.6/en/udf-compiling.html.\n\nTo create a function, you must have the INSERT privilege for the mysql\ndatabase. This is necessary because CREATE FUNCTION adds a row to the\nmysql.func system table that records the function\'s name, type, and\nshared library name. If you do not have this table, you should run the\nmysql_upgrade command to create it. See\nhttp://dev.mysql.com/doc/refman/5.6/en/mysql-upgrade.html.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/create-function-udf.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/create-function-udf.html'),(59,'TIMESTAMP',23,'TIMESTAMP[(fsp)]\n\nA timestamp. The range is \'1970-01-01 00:00:01.000000\' UTC to\n\'2038-01-19 03:14:07.999999\' UTC. TIMESTAMP values are stored as the\nnumber of seconds since the epoch (\'1970-01-01 00:00:00\' UTC). A\nTIMESTAMP cannot represent the value \'1970-01-01 00:00:00\' because that\nis equivalent to 0 seconds from the epoch and the value 0 is reserved\nfor representing \'0000-00-00 00:00:00\', the \"zero\" TIMESTAMP value.\n\nAs of MySQL 5.6.4, an optional fsp value in the range from 0 to 6 may\nbe given to specify fractional seconds precision. A value of 0\nsignifies that there is no fractional part. If omitted, the default\nprecision is 0.\n\nThe way the server handles TIMESTAMP definitions depends on the value\nof the explicit_defaults_for_timestamp system variable (see\nhttp://dev.mysql.com/doc/refman/5.6/en/server-system-variables.html).\nBy default, explicit_defaults_for_timestamp is disabled and the server\nhandles TIMESTAMP as follows:\n\nUnless specified otherwise, the first TIMESTAMP column in a table is\ndefined to be automatically set to the date and time of the most recent\nmodification if not explicitly assigned a value. This makes TIMESTAMP\nuseful for recording the timestamp of an INSERT or UPDATE operation.\nYou can also set any TIMESTAMP column to the current date and time by\nassigning it a NULL value, unless it has been defined with the NULL\nattribute to permit NULL values.\n\nAutomatic initialization and updating to the current date and time can\nbe specified using DEFAULT CURRENT_TIMESTAMP and ON UPDATE\nCURRENT_TIMESTAMP column definition clauses. By default, the first\nTIMESTAMP column has these properties, as previously noted. As of MySQL\n5.6.5, any TIMESTAMP column in a table can be defined to have these\nproperties. Before 5.6.5, at most one TIMESTAMP column per table can\nhave them, but it is possible to suppress them for the first column and\ninstead assign them to a different TIMESTAMP column. See\nhttp://dev.mysql.com/doc/refman/5.6/en/timestamp-initialization.html.\n\nIf explicit_defaults_for_timestamp is enabled, there is no automatic\nassignment of the DEFAULT CURRENT_TIMESTAMP or ON UPDATE\nCURRENT_TIMESTAMP attributes to any TIMESTAMP column. They must be\nincluded explicitly in the column definition. Also, any TIMESTAMP not\nexplicitly declared as NOT NULL permits NULL values.\n\nexplicit_defaults_for_timestamp is available as of MySQL 5.6.6. Before\n5.6.6, the server handles TIMESTAMP as discussed for\nexplicit_defaults_for_timestamp disabled. Those behaviors, while they\nremain the default, are nonstandard and are deprecated as of 5.6.6. For\ndiscussion regarding upgrading to an installation with\nexplicit_defaults_for_timestamp enabled, see\nhttp://dev.mysql.com/doc/refman/5.6/en/upgrading-from-previous-series.h\ntml.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/date-and-time-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/date-and-time-type-overview.html'),(60,'CACHE INDEX',27,'Syntax:\nCACHE INDEX\n  tbl_index_list [, tbl_index_list] ...\n  [PARTITION (partition_list | ALL)]\n  IN key_cache_name\n\ntbl_index_list:\n  tbl_name [[INDEX|KEY] (index_name[, index_name] ...)]\n\npartition_list:\n  partition_name[, partition_name][, ...]\n\nThe CACHE INDEX statement assigns table indexes to a specific key\ncache. It is used only for MyISAM tables. After the indexes have been\nassigned, they can be preloaded into the cache if desired with LOAD\nINDEX INTO CACHE.\n\nThe following statement assigns indexes from the tables t1, t2, and t3\nto the key cache named hot_cache:\n\nmysql> CACHE INDEX t1, t2, t3 IN hot_cache;\n+---------+--------------------+----------+----------+\n| Table   | Op                 | Msg_type | Msg_text |\n+---------+--------------------+----------+----------+\n| test.t1 | assign_to_keycache | status   | OK       |\n| test.t2 | assign_to_keycache | status   | OK       |\n| test.t3 | assign_to_keycache | status   | OK       |\n+---------+--------------------+----------+----------+\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/cache-index.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/cache-index.html'),(61,'COMPRESS',12,'Syntax:\nCOMPRESS(string_to_compress)\n\nCompresses a string and returns the result as a binary string. This\nfunction requires MySQL to have been compiled with a compression\nlibrary such as zlib. Otherwise, the return value is always NULL. The\ncompressed string can be uncompressed with UNCOMPRESS().\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/encryption-functions.html\n\n','mysql> SELECT LENGTH(COMPRESS(REPEAT(\'a\',1000)));\n        -> 21\nmysql> SELECT LENGTH(COMPRESS(\'\'));\n        -> 0\nmysql> SELECT LENGTH(COMPRESS(\'a\'));\n        -> 13\nmysql> SELECT LENGTH(COMPRESS(REPEAT(\'a\',16)));\n        -> 15\n','http://dev.mysql.com/doc/refman/5.6/en/encryption-functions.html'),(62,'HANDLER',28,'Syntax:\nHANDLER tbl_name OPEN [ [AS] alias]\n\nHANDLER tbl_name READ index_name { = | <= | >= | < | > } (value1,value2,...)\n    [ WHERE where_condition ] [LIMIT ... ]\nHANDLER tbl_name READ index_name { FIRST | NEXT | PREV | LAST }\n    [ WHERE where_condition ] [LIMIT ... ]\nHANDLER tbl_name READ { FIRST | NEXT }\n    [ WHERE where_condition ] [LIMIT ... ]\n\nHANDLER tbl_name CLOSE\n\nThe HANDLER statement provides direct access to table storage engine\ninterfaces. It is available for InnoDB and MyISAM tables.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/handler.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/handler.html'),(63,'HELP_DATE',9,'This help information was generated from the MySQL 5.6 Reference Manual\non: 2013-05-12\n','',''),(64,'RENAME TABLE',40,'Syntax:\nRENAME TABLE tbl_name TO new_tbl_name\n    [, tbl_name2 TO new_tbl_name2] ...\n\nThis statement renames one or more tables.\n\nThe rename operation is done atomically, which means that no other\nsession can access any of the tables while the rename is running. For\nexample, if you have an existing table old_table, you can create\nanother table new_table that has the same structure but is empty, and\nthen replace the existing table with the empty one as follows (assuming\nthat backup_table does not already exist):\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/rename-table.html\n\n','CREATE TABLE new_table (...);\nRENAME TABLE old_table TO backup_table, new_table TO old_table;\n','http://dev.mysql.com/doc/refman/5.6/en/rename-table.html'),(65,'BOOLEAN',23,'BOOL, BOOLEAN\n\nThese types are synonyms for TINYINT(1). A value of zero is considered\nfalse. Nonzero values are considered true:\n\nmysql> SELECT IF(0, \'true\', \'false\');\n+------------------------+\n| IF(0, \'true\', \'false\') |\n+------------------------+\n| false                  |\n+------------------------+\n\nmysql> SELECT IF(1, \'true\', \'false\');\n+------------------------+\n| IF(1, \'true\', \'false\') |\n+------------------------+\n| true                   |\n+------------------------+\n\nmysql> SELECT IF(2, \'true\', \'false\');\n+------------------------+\n| IF(2, \'true\', \'false\') |\n+------------------------+\n| true                   |\n+------------------------+\n\nHowever, the values TRUE and FALSE are merely aliases for 1 and 0,\nrespectively, as shown here:\n\nmysql> SELECT IF(0 = FALSE, \'true\', \'false\');\n+--------------------------------+\n| IF(0 = FALSE, \'true\', \'false\') |\n+--------------------------------+\n| true                           |\n+--------------------------------+\n\nmysql> SELECT IF(1 = TRUE, \'true\', \'false\');\n+-------------------------------+\n| IF(1 = TRUE, \'true\', \'false\') |\n+-------------------------------+\n| true                          |\n+-------------------------------+\n\nmysql> SELECT IF(2 = TRUE, \'true\', \'false\');\n+-------------------------------+\n| IF(2 = TRUE, \'true\', \'false\') |\n+-------------------------------+\n| false                         |\n+-------------------------------+\n\nmysql> SELECT IF(2 = FALSE, \'true\', \'false\');\n+--------------------------------+\n| IF(2 = FALSE, \'true\', \'false\') |\n+--------------------------------+\n| false                          |\n+--------------------------------+\n\nThe last two statements display the results shown because 2 is equal to\nneither 1 nor 0.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/numeric-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/numeric-type-overview.html'),(66,'MOD',4,'Syntax:\nMOD(N,M), N % M, N MOD M\n\nModulo operation. Returns the remainder of N divided by M.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/mathematical-functions.html\n\n','mysql> SELECT MOD(234, 10);\n        -> 4\nmysql> SELECT 253 % 7;\n        -> 1\nmysql> SELECT MOD(29,9);\n        -> 2\nmysql> SELECT 29 MOD 9;\n        -> 2\n','http://dev.mysql.com/doc/refman/5.6/en/mathematical-functions.html'),(67,'HELP STATEMENT',29,'Syntax:\nHELP \'search_string\'\n\nThe HELP statement returns online information from the MySQL Reference\nmanual. Its proper operation requires that the help tables in the mysql\ndatabase be initialized with help topic information (see\nhttp://dev.mysql.com/doc/refman/5.6/en/server-side-help-support.html).\n\nThe HELP statement searches the help tables for the given search string\nand displays the result of the search. The search string is not case\nsensitive.\n\nThe search string can contain the the wildcard characters \"%\" and \"_\".\nThese have the same meaning as for pattern-matching operations\nperformed with the LIKE operator. For example, HELP \'rep%\' returns a\nlist of topics that begin with rep.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/help.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/help.html'),(68,'UCASE',38,'Syntax:\nUCASE(str)\n\nUCASE() is a synonym for UPPER().\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/string-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/string-functions.html'),(69,'SHOW BINLOG EVENTS',27,'Syntax:\nSHOW BINLOG EVENTS\n   [IN \'log_name\'] [FROM pos] [LIMIT [offset,] row_count]\n\nShows the events in the binary log. If you do not specify \'log_name\',\nthe first binary log is displayed.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/show-binlog-events.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/show-binlog-events.html'),(70,'MPOLYFROMWKB',33,'MPolyFromWKB(wkb[,srid]), MultiPolygonFromWKB(wkb[,srid])\n\nConstructs a MULTIPOLYGON value using its WKB representation and SRID.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/creating-spatial-values.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/creating-spatial-values.html'),(71,'ITERATE',24,'Syntax:\nITERATE label\n\nITERATE can appear only within LOOP, REPEAT, and WHILE statements.\nITERATE means \"start the loop again.\"\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/iterate.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/iterate.html'),(72,'DO',28,'Syntax:\nDO expr [, expr] ...\n\nDO executes the expressions but does not return any results. In most\nrespects, DO is shorthand for SELECT expr, ..., but has the advantage\nthat it is slightly faster when you do not care about the result.\n\nDO is useful primarily with functions that have side effects, such as\nRELEASE_LOCK().\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/do.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/do.html'),(73,'CHAR_LENGTH',38,'Syntax:\nCHAR_LENGTH(str)\n\nReturns the length of the string str, measured in characters. A\nmulti-byte character counts as a single character. This means that for\na string containing five 2-byte characters, LENGTH() returns 10,\nwhereas CHAR_LENGTH() returns 5.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/string-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/string-functions.html'),(74,'DATE',23,'DATE\n\nA date. The supported range is \'1000-01-01\' to \'9999-12-31\'. MySQL\ndisplays DATE values in \'YYYY-MM-DD\' format, but permits assignment of\nvalues to DATE columns using either strings or numbers.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/date-and-time-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/date-and-time-type-overview.html'),(75,'EXTRACTVALUE',38,'Syntax:\nExtractValue(xml_frag, xpath_expr)\n\nExtractValue() takes two string arguments, a fragment of XML markup\nxml_frag and an XPath expression xpath_expr (also known as a locator);\nit returns the text (CDATA) of the first text node which is a child of\nthe elements or elements matched by the XPath expression. In MySQL\n5.6.6 and earlier, the XPath expression could contain at most 127\ncharacters. This limitation was lifted in MySQL 5.6.7. (Bug #13007062,\nBug#62429)\n\nUsing this function is the equivalent of performing a match using the\nxpath_expr after appending /text(). In other words,\nExtractValue(\'<a><b>Sakila</b></a>\', \'/a/b\') and\nExtractValue(\'<a><b>Sakila</b></a>\', \'/a/b/text()\') produce the same\nresult.\n\nIf multiple matches are found, the content of the first child text node\nof each matching element is returned (in the order matched) as a\nsingle, space-delimited string.\n\nIf no matching text node is found for the expression (including the\nimplicit /text())---for whatever reason, as long as xpath_expr is\nvalid, and xml_frag consists of elements which are properly nested and\nclosed---an empty string is returned. No distinction is made between a\nmatch on an empty element and no match at all. This is by design.\n\nIf you need to determine whether no matching element was found in\nxml_frag or such an element was found but contained no child text\nnodes, you should test the result of an expression that uses the XPath\ncount() function. For example, both of these statements return an empty\nstring, as shown here:\n\nmysql> SELECT ExtractValue(\'<a><b/></a>\', \'/a/b\');\n+-------------------------------------+\n| ExtractValue(\'<a><b/></a>\', \'/a/b\') |\n+-------------------------------------+\n|                                     |\n+-------------------------------------+\n1 row in set (0.00 sec)\n\nmysql> SELECT ExtractValue(\'<a><c/></a>\', \'/a/b\');\n+-------------------------------------+\n| ExtractValue(\'<a><c/></a>\', \'/a/b\') |\n+-------------------------------------+\n|                                     |\n+-------------------------------------+\n1 row in set (0.00 sec)\n\nHowever, you can determine whether there was actually a matching\nelement using the following:\n\nmysql> SELECT ExtractValue(\'<a><b/></a>\', \'count(/a/b)\');\n+-------------------------------------+\n| ExtractValue(\'<a><b/></a>\', \'count(/a/b)\') |\n+-------------------------------------+\n| 1                                   |\n+-------------------------------------+\n1 row in set (0.00 sec)\n\nmysql> SELECT ExtractValue(\'<a><c/></a>\', \'count(/a/b)\');\n+-------------------------------------+\n| ExtractValue(\'<a><c/></a>\', \'count(/a/b)\') |\n+-------------------------------------+\n| 0                                   |\n+-------------------------------------+\n1 row in set (0.01 sec)\n\n*Important*: ExtractValue() returns only CDATA, and does not return any\ntags that might be contained within a matching tag, nor any of their\ncontent (see the result returned as val1 in the following example).\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/xml-functions.html\n\n','mysql> SELECT\n    ->   ExtractValue(\'<a>ccc<b>ddd</b></a>\', \'/a\') AS val1,\n    ->   ExtractValue(\'<a>ccc<b>ddd</b></a>\', \'/a/b\') AS val2,\n    ->   ExtractValue(\'<a>ccc<b>ddd</b></a>\', \'//b\') AS val3,\n    ->   ExtractValue(\'<a>ccc<b>ddd</b></a>\', \'/b\') AS val4,\n    ->   ExtractValue(\'<a>ccc<b>ddd</b><b>eee</b></a>\', \'//b\') AS val5;\n\n+------+------+------+------+---------+\n| val1 | val2 | val3 | val4 | val5    |\n+------+------+------+------+---------+\n| ccc  | ddd  | ddd  |      | ddd eee |\n+------+------+------+------+---------+\n','http://dev.mysql.com/doc/refman/5.6/en/xml-functions.html'),(76,'OLD_PASSWORD',12,'Syntax:\nOLD_PASSWORD(str)\n\nOLD_PASSWORD() was added when the implementation of PASSWORD() was\nchanged in MySQL 4.1 to improve security. OLD_PASSWORD() returns the\nvalue of the pre-4.1 implementation of PASSWORD() as a string, and is\nintended to permit you to reset passwords for any pre-4.1 clients that\nneed to connect to your version 5.6 MySQL server without locking them\nout. See http://dev.mysql.com/doc/refman/5.6/en/password-hashing.html.\n\nThe return value is a nonbinary string in the connection character set.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/encryption-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/encryption-functions.html'),(77,'FORMAT',38,'Syntax:\nFORMAT(X,D[,locale])\n\nFormats the number X to a format like \'#,###,###.##\', rounded to D\ndecimal places, and returns the result as a string. If D is 0, the\nresult has no decimal point or fractional part.\n\nThe optional third parameter enables a locale to be specified to be\nused for the result number\'s decimal point, thousands separator, and\ngrouping between separators. Permissible locale values are the same as\nthe legal values for the lc_time_names system variable (see\nhttp://dev.mysql.com/doc/refman/5.6/en/locale-support.html). If no\nlocale is specified, the default is \'en_US\'.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/string-functions.html\n\n','mysql> SELECT FORMAT(12332.123456, 4);\n        -> \'12,332.1235\'\nmysql> SELECT FORMAT(12332.1,4);\n        -> \'12,332.1000\'\nmysql> SELECT FORMAT(12332.2,0);\n        -> \'12,332\'\nmysql> SELECT FORMAT(12332.2,2,\'de_DE\');\n        -> \'12.332,20\'\n','http://dev.mysql.com/doc/refman/5.6/en/string-functions.html'),(78,'||',15,'Syntax:\nOR, ||\n\nLogical OR. When both operands are non-NULL, the result is 1 if any\noperand is nonzero, and 0 otherwise. With a NULL operand, the result is\n1 if the other operand is nonzero, and NULL otherwise. If both operands\nare NULL, the result is NULL.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/logical-operators.html\n\n','mysql> SELECT 1 || 1;\n        -> 1\nmysql> SELECT 1 || 0;\n        -> 1\nmysql> SELECT 0 || 0;\n        -> 0\nmysql> SELECT 0 || NULL;\n        -> NULL\nmysql> SELECT 1 || NULL;\n        -> 1\n','http://dev.mysql.com/doc/refman/5.6/en/logical-operators.html'),(79,'BIT_LENGTH',38,'Syntax:\nBIT_LENGTH(str)\n\nReturns the length of the string str in bits.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/string-functions.html\n\n','mysql> SELECT BIT_LENGTH(\'text\');\n        -> 32\n','http://dev.mysql.com/doc/refman/5.6/en/string-functions.html'),(80,'EXTERIORRING',2,'ExteriorRing(poly)\n\nReturns the exterior ring of the Polygon value poly as a LineString.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/geometry-property-functions.html\n\n','mysql> SET @poly =\n    -> \'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))\';\nmysql> SELECT AsText(ExteriorRing(GeomFromText(@poly)));\n+-------------------------------------------+\n| AsText(ExteriorRing(GeomFromText(@poly))) |\n+-------------------------------------------+\n| LINESTRING(0 0,0 3,3 3,3 0,0 0)           |\n+-------------------------------------------+\n','http://dev.mysql.com/doc/refman/5.6/en/geometry-property-functions.html'),(81,'GEOMFROMWKB',33,'GeomFromWKB(wkb[,srid]), GeometryFromWKB(wkb[,srid])\n\nConstructs a geometry value of any type using its WKB representation\nand SRID.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/creating-spatial-values.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/creating-spatial-values.html'),(82,'BETWEEN AND',19,'Syntax:\nexpr BETWEEN min AND max\n\nIf expr is greater than or equal to min and expr is less than or equal\nto max, BETWEEN returns 1, otherwise it returns 0. This is equivalent\nto the expression (min <= expr AND expr <= max) if all the arguments\nare of the same type. Otherwise type conversion takes place according\nto the rules described in\nhttp://dev.mysql.com/doc/refman/5.6/en/type-conversion.html, but\napplied to all the three arguments.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/comparison-operators.html\n\n','mysql> SELECT 2 BETWEEN 1 AND 3, 2 BETWEEN 3 and 1;\n        -> 1, 0\nmysql> SELECT 1 BETWEEN 2 AND 3;\n        -> 0\nmysql> SELECT \'b\' BETWEEN \'a\' AND \'c\';\n        -> 1\nmysql> SELECT 2 BETWEEN 2 AND \'3\';\n        -> 1\nmysql> SELECT 2 BETWEEN 2 AND \'x-3\';\n        -> 0\n','http://dev.mysql.com/doc/refman/5.6/en/comparison-operators.html'),(83,'MULTIPOLYGON',25,'MultiPolygon(poly1,poly2,...)\n\nConstructs a MultiPolygon value from a set of Polygon or WKB Polygon\narguments.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/creating-spatial-values.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/creating-spatial-values.html'),(84,'LEFT',38,'Syntax:\nLEFT(str,len)\n\nReturns the leftmost len characters from the string str, or NULL if any\nargument is NULL.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/string-functions.html\n\n','mysql> SELECT LEFT(\'foobarbar\', 5);\n        -> \'fooba\'\n','http://dev.mysql.com/doc/refman/5.6/en/string-functions.html'),(85,'FLUSH QUERY CACHE',27,'You can defragment the query cache to better utilize its memory with\nthe FLUSH QUERY CACHE statement. The statement does not remove any\nqueries from the cache.\n\nThe RESET QUERY CACHE statement removes all query results from the\nquery cache. The FLUSH TABLES statement also does this.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/query-cache-status-and-maintenance.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/query-cache-status-and-maintenance.html'),(86,'SET DATA TYPE',23,'SET(\'value1\',\'value2\',...) [CHARACTER SET charset_name] [COLLATE\ncollation_name]\n\nA set. A string object that can have zero or more values, each of which\nmust be chosen from the list of values \'value1\', \'value2\', ... SET\nvalues are represented internally as integers.\n\nA SET column can have a maximum of 64 distinct members. A table can\nhave no more than 255 unique element list definitions among its ENUM\nand SET columns considered as a group. For more information on this\nlimit, see http://dev.mysql.com/doc/refman/5.6/en/limits-frm-file.html.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/string-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/string-type-overview.html'),(87,'RAND',4,'Syntax:\nRAND(), RAND(N)\n\nReturns a random floating-point value v in the range 0 <= v < 1.0. If a\nconstant integer argument N is specified, it is used as the seed value,\nwhich produces a repeatable sequence of column values. In the following\nexample, note that the sequences of values produced by RAND(3) is the\nsame both places where it occurs.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/mathematical-functions.html\n\n','mysql> CREATE TABLE t (i INT);\nQuery OK, 0 rows affected (0.42 sec)\n\nmysql> INSERT INTO t VALUES(1),(2),(3);\nQuery OK, 3 rows affected (0.00 sec)\nRecords: 3  Duplicates: 0  Warnings: 0\n\nmysql> SELECT i, RAND() FROM t;\n+------+------------------+\n| i    | RAND()           |\n+------+------------------+\n|    1 | 0.61914388706828 |\n|    2 | 0.93845168309142 |\n|    3 | 0.83482678498591 |\n+------+------------------+\n3 rows in set (0.00 sec)\n\nmysql> SELECT i, RAND(3) FROM t;\n+------+------------------+\n| i    | RAND(3)          |\n+------+------------------+\n|    1 | 0.90576975597606 |\n|    2 | 0.37307905813035 |\n|    3 | 0.14808605345719 |\n+------+------------------+\n3 rows in set (0.00 sec)\n\nmysql> SELECT i, RAND() FROM t;\n+------+------------------+\n| i    | RAND()           |\n+------+------------------+\n|    1 | 0.35877890638893 |\n|    2 | 0.28941420772058 |\n|    3 | 0.37073435016976 |\n+------+------------------+\n3 rows in set (0.00 sec)\n\nmysql> SELECT i, RAND(3) FROM t;\n+------+------------------+\n| i    | RAND(3)          |\n+------+------------------+\n|    1 | 0.90576975597606 |\n|    2 | 0.37307905813035 |\n|    3 | 0.14808605345719 |\n+------+------------------+\n3 rows in set (0.01 sec)\n','http://dev.mysql.com/doc/refman/5.6/en/mathematical-functions.html'),(88,'RPAD',38,'Syntax:\nRPAD(str,len,padstr)\n\nReturns the string str, right-padded with the string padstr to a length\nof len characters. If str is longer than len, the return value is\nshortened to len characters.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/string-functions.html\n\n','mysql> SELECT RPAD(\'hi\',5,\'?\');\n        -> \'hi???\'\nmysql> SELECT RPAD(\'hi\',1,\'?\');\n        -> \'h\'\n','http://dev.mysql.com/doc/refman/5.6/en/string-functions.html'),(89,'DEC',23,'DEC[(M[,D])] [UNSIGNED] [ZEROFILL], NUMERIC[(M[,D])] [UNSIGNED]\n[ZEROFILL], FIXED[(M[,D])] [UNSIGNED] [ZEROFILL]\n\nThese types are synonyms for DECIMAL. The FIXED synonym is available\nfor compatibility with other database systems.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/numeric-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/numeric-type-overview.html'),(90,'ELT',38,'Syntax:\nELT(N,str1,str2,str3,...)\n\nELT() returns the Nth element of the list of strings: str1 if N = 1,\nstr2 if N = 2, and so on. Returns NULL if N is less than 1 or greater\nthan the number of arguments. ELT() is the complement of FIELD().\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/string-functions.html\n\n','mysql> SELECT ELT(1, \'ej\', \'Heja\', \'hej\', \'foo\');\n        -> \'ej\'\nmysql> SELECT ELT(4, \'ej\', \'Heja\', \'hej\', \'foo\');\n        -> \'foo\'\n','http://dev.mysql.com/doc/refman/5.6/en/string-functions.html'),(91,'ALTER VIEW',40,'Syntax:\nALTER\n    [ALGORITHM = {UNDEFINED | MERGE | TEMPTABLE}]\n    [DEFINER = { user | CURRENT_USER }]\n    [SQL SECURITY { DEFINER | INVOKER }]\n    VIEW view_name [(column_list)]\n    AS select_statement\n    [WITH [CASCADED | LOCAL] CHECK OPTION]\n\nThis statement changes the definition of a view, which must exist. The\nsyntax is similar to that for CREATE VIEW and the effect is the same as\nfor CREATE OR REPLACE VIEW. See [HELP CREATE VIEW]. This statement\nrequires the CREATE VIEW and DROP privileges for the view, and some\nprivilege for each column referred to in the SELECT statement. ALTER\nVIEW is permitted only to the definer or users with the SUPER\nprivilege.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/alter-view.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/alter-view.html'),(92,'SHOW DATABASES',27,'Syntax:\nSHOW {DATABASES | SCHEMAS}\n    [LIKE \'pattern\' | WHERE expr]\n\nSHOW DATABASES lists the databases on the MySQL server host. SHOW\nSCHEMAS is a synonym for SHOW DATABASES. The LIKE clause, if present,\nindicates which database names to match. The WHERE clause can be given\nto select rows using more general conditions, as discussed in\nhttp://dev.mysql.com/doc/refman/5.6/en/extended-show.html.\n\nYou see only those databases for which you have some kind of privilege,\nunless you have the global SHOW DATABASES privilege. You can also get\nthis list using the mysqlshow command.\n\nIf the server was started with the --skip-show-database option, you\ncannot use this statement at all unless you have the SHOW DATABASES\nprivilege.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/show-databases.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/show-databases.html'),(93,'SEC_TO_TIME',32,'Syntax:\nSEC_TO_TIME(seconds)\n\nReturns the seconds argument, converted to hours, minutes, and seconds,\nas a TIME value. The range of the result is constrained to that of the\nTIME data type. A warning occurs if the argument corresponds to a value\noutside that range.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html\n\n','mysql> SELECT SEC_TO_TIME(2378);\n        -> \'00:39:38\'\nmysql> SELECT SEC_TO_TIME(2378) + 0;\n        -> 3938\n','http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html'),(94,'LOCATE',38,'Syntax:\nLOCATE(substr,str), LOCATE(substr,str,pos)\n\nThe first syntax returns the position of the first occurrence of\nsubstring substr in string str. The second syntax returns the position\nof the first occurrence of substring substr in string str, starting at\nposition pos. Returns 0 if substr is not in str.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/string-functions.html\n\n','mysql> SELECT LOCATE(\'bar\', \'foobarbar\');\n        -> 4\nmysql> SELECT LOCATE(\'xbar\', \'foobar\');\n        -> 0\nmysql> SELECT LOCATE(\'bar\', \'foobarbar\', 5);\n        -> 7\n','http://dev.mysql.com/doc/refman/5.6/en/string-functions.html'),(95,'SHOW EVENTS',27,'Syntax:\nSHOW EVENTS [{FROM | IN} schema_name]\n    [LIKE \'pattern\' | WHERE expr]\n\nThis statement displays information about Event Manager events. It\nrequires the EVENT privilege for the database from which the events are\nto be shown.\n\nIn its simplest form, SHOW EVENTS lists all of the events in the\ncurrent schema:\n\nmysql> SELECT CURRENT_USER(), SCHEMA();\n+----------------+----------+\n| CURRENT_USER() | SCHEMA() |\n+----------------+----------+\n| jon@ghidora    | myschema |\n+----------------+----------+\n1 row in set (0.00 sec)\n\nmysql> SHOW EVENTS\\G\n*************************** 1. row ***************************\n                  Db: myschema\n                Name: e_daily\n             Definer: jon@ghidora\n           Time zone: SYSTEM\n                Type: RECURRING\n          Execute at: NULL\n      Interval value: 10\n      Interval field: SECOND\n              Starts: 2006-02-09 10:41:23\n                Ends: NULL\n              Status: ENABLED\n          Originator: 0\ncharacter_set_client: latin1\ncollation_connection: latin1_swedish_ci\n  Database Collation: latin1_swedish_ci\n\nTo see events for a specific schema, use the FROM clause. For example,\nto see events for the test schema, use the following statement:\n\nSHOW EVENTS FROM test;\n\nThe LIKE clause, if present, indicates which event names to match. The\nWHERE clause can be given to select rows using more general conditions,\nas discussed in\nhttp://dev.mysql.com/doc/refman/5.6/en/extended-show.html.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/show-events.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/show-events.html'),(96,'LONGTEXT',23,'LONGTEXT [CHARACTER SET charset_name] [COLLATE collation_name]\n\nA TEXT column with a maximum length of 4,294,967,295 or 4GB (232 - 1)\ncharacters. The effective maximum length is less if the value contains\nmulti-byte characters. The effective maximum length of LONGTEXT columns\nalso depends on the configured maximum packet size in the client/server\nprotocol and available memory. Each LONGTEXT value is stored using a\n4-byte length prefix that indicates the number of bytes in the value.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/string-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/string-type-overview.html'),(97,'KILL',27,'Syntax:\nKILL [CONNECTION | QUERY] thread_id\n\nEach connection to mysqld runs in a separate thread. You can see which\nthreads are running with the SHOW PROCESSLIST statement and kill a\nthread with the KILL thread_id statement.\n\nKILL permits an optional CONNECTION or QUERY modifier:\n\no KILL CONNECTION is the same as KILL with no modifier: It terminates\n  the connection associated with the given thread_id.\n\no KILL QUERY terminates the statement that the connection is currently\n  executing, but leaves the connection itself intact.\n\nIf you have the PROCESS privilege, you can see all threads. If you have\nthe SUPER privilege, you can kill all threads and statements.\nOtherwise, you can see and kill only your own threads and statements.\n\nYou can also use the mysqladmin processlist and mysqladmin kill\ncommands to examine and kill threads.\n\n*Note*: You cannot use KILL with the Embedded MySQL Server library\nbecause the embedded server merely runs inside the threads of the host\napplication. It does not create any connection threads of its own.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/kill.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/kill.html'),(98,'DISJOINT',31,'Disjoint(g1,g2)\n\nReturns 1 or 0 to indicate whether g1 is spatially disjoint from (does\nnot intersect) g2.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/functions-for-testing-spatial-relations-between-geometric-objects.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/functions-for-testing-spatial-relations-between-geometric-objects.html'),(99,'LPAD',38,'Syntax:\nLPAD(str,len,padstr)\n\nReturns the string str, left-padded with the string padstr to a length\nof len characters. If str is longer than len, the return value is\nshortened to len characters.\n\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/string-functions.html\n\n','mysql> SELECT LPAD(\'hi\',4,\'??\');\n        -> \'??hi\'\nmysql> SELECT LPAD(\'hi\',1,\'??\');\n        -> \'h\'\n','http://dev.mysql.com/doc/refman/5.6/en/string-functions.html'),(100,'OVERLAPS',31,'Overlaps(g1,g2)\n\nReturns 1 or 0 to indicate whether g1 spatially overlaps g2. The term\nspatially overlaps is used if two geometries intersect and their\nintersection results in a geometry of the same dimension but not equal\nto either of the given geometries.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/functions-for-testing-spatial-relations-between-geometric-objects.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/functions-for-testing-spatial-relations-between-geometric-objects.html'),(101,'SET GLOBAL SQL_SLAVE_SKIP_COUNTER',8,'Syntax:\nSET GLOBAL sql_slave_skip_counter = N\n\nThis statement skips the next N events from the master. This is useful\nfor recovering from replication stops caused by a statement.\n\nThis statement is valid only when the slave threads are not running.\nOtherwise, it produces an error.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/set-global-sql-slave-skip-counter.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/set-global-sql-slave-skip-counter.html'),(102,'MBREQUAL',6,'MBREqual(g1,g2)\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of\nthe two geometries g1 and g2 are the same.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/functions-for-testing-spatial-relations-between-geometric-objects.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/functions-for-testing-spatial-relations-between-geometric-objects.html'),(103,'PROCEDURE ANALYSE',34,'Syntax:\nANALYSE([max_elements[,max_memory]])\n\nANALYSE() examines the result from a query and returns an analysis of\nthe results that suggests optimal data types for each column that may\nhelp reduce table sizes. To obtain this analysis, append PROCEDURE\nANALYSE to the end of a SELECT statement:\n\nSELECT ... FROM ... WHERE ... PROCEDURE ANALYSE([max_elements,[max_memory]])\n\nFor example:\n\nSELECT col1, col2 FROM table1 PROCEDURE ANALYSE(10, 2000);\n\nThe results show some statistics for the values returned by the query,\nand propose an optimal data type for the columns. This can be helpful\nfor checking your existing tables, or after importing new data. You may\nneed to try different settings for the arguments so that PROCEDURE\nANALYSE() does not suggest the ENUM data type when it is not\nappropriate.\n\nThe arguments are optional and are used as follows:\n\no max_elements (default 256) is the maximum number of distinct values\n  that ANALYSE() notices per column. This is used by ANALYSE() to check\n  whether the optimal data type should be of type ENUM; if there are\n  more than max_elements distinct values, then ENUM is not a suggested\n  type.\n\no max_memory (default 8192) is the maximum amount of memory that\n  ANALYSE() should allocate per column while trying to find all\n  distinct values.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/procedure-analyse.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/procedure-analyse.html'),(104,'HELP_VERSION',9,'This help information was generated from the MySQL 5.6 Reference Manual\non: 2013-05-12 (revision: 35152)\n\nThis information applies to MySQL 5.6 through 5.6.13.\n','',''),(105,'CHARACTER_LENGTH',38,'Syntax:\nCHARACTER_LENGTH(str)\n\nCHARACTER_LENGTH() is a synonym for CHAR_LENGTH().\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/string-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/string-functions.html'),(106,'SHOW PRIVILEGES',27,'Syntax:\nSHOW PRIVILEGES\n\nSHOW PRIVILEGES shows the list of system privileges that the MySQL\nserver supports. The exact list of privileges depends on the version of\nyour server.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/show-privileges.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/show-privileges.html'),(107,'CREATE TABLESPACE',40,'Syntax:\nCREATE TABLESPACE tablespace_name\n    ADD DATAFILE \'file_name\'\n    USE LOGFILE GROUP logfile_group\n    [EXTENT_SIZE [=] extent_size]\n    [INITIAL_SIZE [=] initial_size]\n    [AUTOEXTEND_SIZE [=] autoextend_size]\n    [MAX_SIZE [=] max_size]\n    [NODEGROUP [=] nodegroup_id]\n    [WAIT]\n    [COMMENT [=] comment_text]\n    ENGINE [=] engine_name\n\nThis statement is used to create a tablespace, which can contain one or\nmore data files, providing storage space for tables. One data file is\ncreated and added to the tablespace using this statement. Additional\ndata files may be added to the tablespace by using the ALTER TABLESPACE\nstatement (see [HELP ALTER TABLESPACE]). For rules covering the naming\nof tablespaces, see\nhttp://dev.mysql.com/doc/refman/5.6/en/identifiers.html.\n\n*Note*: All MySQL Cluster Disk Data objects share the same namespace.\nThis means that each Disk Data object must be uniquely named (and not\nmerely each Disk Data object of a given type). For example, you cannot\nhave a tablespace and a log file group with the same name, or a\ntablespace and a data file with the same name.\n\nA log file group of one or more UNDO log files must be assigned to the\ntablespace to be created with the USE LOGFILE GROUP clause.\nlogfile_group must be an existing log file group created with CREATE\nLOGFILE GROUP (see\nhttp://dev.mysql.com/doc/refman/5.6/en/create-logfile-group.html).\nMultiple tablespaces may use the same log file group for UNDO logging.\n\nThe EXTENT_SIZE sets the size, in bytes, of the extents used by any\nfiles belonging to the tablespace. The default value is 1M. The minimum\nsize is 32K, and theoretical maximum is 2G, although the practical\nmaximum size depends on a number of factors. In most cases, changing\nthe extent size does not have any measurable effect on performance, and\nthe default value is recommended for all but the most unusual\nsituations.\n\nAn extent is a unit of disk space allocation. One extent is filled with\nas much data as that extent can contain before another extent is used.\nIn theory, up to 65,535 (64K) extents may used per data file; however,\nthe recommended maximum is 32,768 (32K). The recommended maximum size\nfor a single data file is 32G---that is, 32K extents x 1 MB per extent.\nIn addition, once an extent is allocated to a given partition, it\ncannot be used to store data from a different partition; an extent\ncannot store data from more than one partition. This means, for example\nthat a tablespace having a single datafile whose INITIAL_SIZE is 256 MB\nand whose EXTENT_SIZE is 128M has just two extents, and so can be used\nto store data from at most two different disk data table partitions.\n\nYou can see how many extents remain free in a given data file by\nquerying the INFORMATION_SCHEMA.FILES table, and so derive an estimate\nfor how much space remains free in the file. For further discussion and\nexamples, see http://dev.mysql.com/doc/refman/5.6/en/files-table.html.\n\nThe INITIAL_SIZE parameter sets the data file\'s total size in bytes.\nOnce the file has been created, its size cannot be changed; however,\nyou can add more data files to the tablespace using ALTER TABLESPACE\n... ADD DATAFILE. See [HELP ALTER TABLESPACE].\n\nINITIAL_SIZE is optional; its default value is 128M.\n\nOn 32-bit systems, the maximum supported value for INITIAL_SIZE is 4G.\n(Bug #29186)\n\nWhen setting EXTENT_SIZE or INITIAL_SIZE (either or both), you may\noptionally follow the number with a one-letter abbreviation for an\norder of magnitude, similar to those used in my.cnf. Generally, this is\none of the letters M (for megabytes) or G (for gigabytes).\n\nINITIAL_SIZE, EXTENT_SIZE, and UNDO_BUFFER_SIZE are subject to rounding\nas follows:\n\no EXTENT_SIZE and UNDO_BUFFER_SIZE are each rounded up to the nearest\n  whole multiple of 32K.\n\no INITIAL_SIZE is rounded down to the nearest whole multiple of 32K.\n\n  For data files, INITIAL_SIZE is subject to further rounding; the\n  result just obtained is rounded up to the nearest whole multiple of\n  EXTENT_SIZE (after any rounding).\n\nThe rounding just described is done explicitly, and a warning is issued\nby the MySQL Server when any such rounding is performed. The rounded\nvalues are also used by the NDB kernel for calculating\nINFORMATION_SCHEMA.FILES column values and other purposes. However, to\navoid an unexpected result, we suggest that you always use whole\nmultiples of 32K in specifying these options.\n\nAUTOEXTEND_SIZE, MAX_SIZE, NODEGROUP, WAIT, and COMMENT are parsed but\nignored, and so currently have no effect. These options are intended\nfor future expansion.\n\nThe ENGINE parameter determines the storage engine which uses this\ntablespace, with engine_name being the name of the storage engine.\nCurrently, engine_name must be one of the values NDB or NDBCLUSTER.\n\nWhen CREATE TABLESPACE is used with ENGINE = NDB, a tablespace and\nassociated data file are created on each Cluster data node. You can\nverify that the data files were created and obtain information about\nthem by querying the INFORMATION_SCHEMA.FILES table. For example:\n\nmysql> SELECT LOGFILE_GROUP_NAME, FILE_NAME, EXTRA\n    -> FROM INFORMATION_SCHEMA.FILES\n    -> WHERE TABLESPACE_NAME = \'newts\' AND FILE_TYPE = \'DATAFILE\';\n+--------------------+-------------+----------------+\n| LOGFILE_GROUP_NAME | FILE_NAME   | EXTRA          |\n+--------------------+-------------+----------------+\n| lg_3               | newdata.dat | CLUSTER_NODE=3 |\n| lg_3               | newdata.dat | CLUSTER_NODE=4 |\n+--------------------+-------------+----------------+\n2 rows in set (0.01 sec)\n\n(See http://dev.mysql.com/doc/refman/5.6/en/files-table.html.)\n\nCREATE TABLESPACE is useful only with Disk Data storage for MySQL\nCluster. See\nhttp://dev.mysql.com/doc/refman/5.6/en/mysql-cluster-disk-data.html.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/create-tablespace.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/create-tablespace.html'),(108,'INSERT FUNCTION',38,'Syntax:\nINSERT(str,pos,len,newstr)\n\nReturns the string str, with the substring beginning at position pos\nand len characters long replaced by the string newstr. Returns the\noriginal string if pos is not within the length of the string. Replaces\nthe rest of the string from position pos if len is not within the\nlength of the rest of the string. Returns NULL if any argument is NULL.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/string-functions.html\n\n','mysql> SELECT INSERT(\'Quadratic\', 3, 4, \'What\');\n        -> \'QuWhattic\'\nmysql> SELECT INSERT(\'Quadratic\', -1, 4, \'What\');\n        -> \'Quadratic\'\nmysql> SELECT INSERT(\'Quadratic\', 3, 100, \'What\');\n        -> \'QuWhat\'\n','http://dev.mysql.com/doc/refman/5.6/en/string-functions.html'),(109,'XOR',15,'Syntax:\nXOR\n\nLogical XOR. Returns NULL if either operand is NULL. For non-NULL\noperands, evaluates to 1 if an odd number of operands is nonzero,\notherwise 0 is returned.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/logical-operators.html\n\n','mysql> SELECT 1 XOR 1;\n        -> 0\nmysql> SELECT 1 XOR 0;\n        -> 1\nmysql> SELECT 1 XOR NULL;\n        -> NULL\nmysql> SELECT 1 XOR 1 XOR 1;\n        -> 1\n','http://dev.mysql.com/doc/refman/5.6/en/logical-operators.html'),(110,'GRANT',10,'Syntax:\nGRANT\n    priv_type [(column_list)]\n      [, priv_type [(column_list)]] ...\n    ON [object_type] priv_level\n    TO user_specification [, user_specification] ...\n    [REQUIRE {NONE | ssl_option [[AND] ssl_option] ...}]\n    [WITH with_option ...]\n\nGRANT PROXY ON user_specification\n    TO user_specification [, user_specification] ...\n    [WITH GRANT OPTION]\n\nobject_type:\n    TABLE\n  | FUNCTION\n  | PROCEDURE\n\npriv_level:\n    *\n  | *.*\n  | db_name.*\n  | db_name.tbl_name\n  | tbl_name\n  | db_name.routine_name\n\nuser_specification:\n    user\n    [\n        IDENTIFIED BY [PASSWORD] \'password\'\n      | IDENTIFIED WITH auth_plugin [AS \'auth_string\']\n    ]\n\nssl_option:\n    SSL\n  | X509\n  | CIPHER \'cipher\'\n  | ISSUER \'issuer\'\n  | SUBJECT \'subject\'\n\nwith_option:\n    GRANT OPTION\n  | MAX_QUERIES_PER_HOUR count\n  | MAX_UPDATES_PER_HOUR count\n  | MAX_CONNECTIONS_PER_HOUR count\n  | MAX_USER_CONNECTIONS count\n\nThe GRANT statement grants privileges to MySQL user accounts. GRANT\nalso serves to specify other account characteristics such as use of\nsecure connections and limits on access to server resources. To use\nGRANT, you must have the GRANT OPTION privilege, and you must have the\nprivileges that you are granting.\n\nNormally, a database administrator first uses CREATE USER to create an\naccount, then GRANT to define its privileges and characteristics. For\nexample:\n\nCREATE USER \'jeffrey\'@\'localhost\' IDENTIFIED BY \'mypass\';\nGRANT ALL ON db1.* TO \'jeffrey\'@\'localhost\';\nGRANT SELECT ON db2.invoice TO \'jeffrey\'@\'localhost\';\nGRANT USAGE ON *.* TO \'jeffrey\'@\'localhost\' WITH MAX_QUERIES_PER_HOUR 90;\n\nHowever, if an account named in a GRANT statement does not already\nexist, GRANT may create it under the conditions described later in the\ndiscussion of the NO_AUTO_CREATE_USER SQL mode.\n\nThe REVOKE statement is related to GRANT and enables administrators to\nremove account privileges. See [HELP REVOKE].\n\nWhen successfully executed from the mysql program, GRANT responds with\nQuery OK, 0 rows affected. To determine what privileges result from the\noperation, use SHOW GRANTS. See [HELP SHOW GRANTS].\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/grant.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/grant.html'),(111,'MBRINTERSECTS',6,'MBRIntersects(g1,g2)\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of\nthe two geometries g1 and g2 intersect.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/functions-for-testing-spatial-relations-between-geometric-objects.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/functions-for-testing-spatial-relations-between-geometric-objects.html'),(112,'IS NOT',19,'Syntax:\nIS NOT boolean_value\n\nTests a value against a boolean value, where boolean_value can be TRUE,\nFALSE, or UNKNOWN.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/comparison-operators.html\n\n','mysql> SELECT 1 IS NOT UNKNOWN, 0 IS NOT UNKNOWN, NULL IS NOT UNKNOWN;\n        -> 1, 1, 0\n','http://dev.mysql.com/doc/refman/5.6/en/comparison-operators.html'),(113,'SQRT',4,'Syntax:\nSQRT(X)\n\nReturns the square root of a nonnegative number X.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/mathematical-functions.html\n\n','mysql> SELECT SQRT(4);\n        -> 2\nmysql> SELECT SQRT(20);\n        -> 4.4721359549996\nmysql> SELECT SQRT(-16);\n        -> NULL\n','http://dev.mysql.com/doc/refman/5.6/en/mathematical-functions.html'),(114,'CREATE INDEX',40,'Syntax:\nCREATE [UNIQUE|FULLTEXT|SPATIAL] INDEX index_name\n    [index_type]\n    ON tbl_name (index_col_name,...)\n    [algorithm_option | lock_option] ...\n\nindex_col_name:\n    col_name [(length)] [ASC | DESC]\n\nindex_type:\n    USING {BTREE | HASH}\n\nindex_option:\n    KEY_BLOCK_SIZE [=] value\n  | index_type\n  | WITH PARSER parser_name\n  | COMMENT \'string\'\n\nalgorithm_option:\n    ALGORITHM [=] {DEFAULT|INPLACE|COPY}\n\nlock_option:\n    LOCK [=] {DEFAULT|NONE|SHARED|EXCLUSIVE}\n\nCREATE INDEX is mapped to an ALTER TABLE statement to create indexes.\nSee [HELP ALTER TABLE]. CREATE INDEX cannot be used to create a PRIMARY\nKEY; use ALTER TABLE instead. For more information about indexes, see\nhttp://dev.mysql.com/doc/refman/5.6/en/mysql-indexes.html.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/create-index.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/create-index.html'),(115,'ALTER DATABASE',40,'Syntax:\nALTER {DATABASE | SCHEMA} [db_name]\n    alter_specification ...\nALTER {DATABASE | SCHEMA} db_name\n    UPGRADE DATA DIRECTORY NAME\n\nalter_specification:\n    [DEFAULT] CHARACTER SET [=] charset_name\n  | [DEFAULT] COLLATE [=] collation_name\n\nALTER DATABASE enables you to change the overall characteristics of a\ndatabase. These characteristics are stored in the db.opt file in the\ndatabase directory. To use ALTER DATABASE, you need the ALTER privilege\non the database. ALTER SCHEMA is a synonym for ALTER DATABASE.\n\nThe database name can be omitted from the first syntax, in which case\nthe statement applies to the default database.\n\nNational Language Characteristics\n\nThe CHARACTER SET clause changes the default database character set.\nThe COLLATE clause changes the default database collation.\nhttp://dev.mysql.com/doc/refman/5.6/en/charset.html, discusses\ncharacter set and collation names.\n\nYou can see what character sets and collations are available using,\nrespectively, the SHOW CHARACTER SET and SHOW COLLATION statements. See\n[HELP SHOW CHARACTER SET], and [HELP SHOW COLLATION], for more\ninformation.\n\nIf you change the default character set or collation for a database,\nstored routines that use the database defaults must be dropped and\nrecreated so that they use the new defaults. (In a stored routine,\nvariables with character data types use the database defaults if the\ncharacter set or collation are not specified explicitly. See [HELP\nCREATE PROCEDURE].)\n\nUpgrading from Versions Older than MySQL 5.1\n\nThe syntax that includes the UPGRADE DATA DIRECTORY NAME clause updates\nthe name of the directory associated with the database to use the\nencoding implemented in MySQL 5.1 for mapping database names to\ndatabase directory names (see\nhttp://dev.mysql.com/doc/refman/5.6/en/identifier-mapping.html). This\nclause is for use under these conditions:\n\no It is intended when upgrading MySQL to 5.1 or later from older\n  versions.\n\no It is intended to update a database directory name to the current\n  encoding format if the name contains special characters that need\n  encoding.\n\no The statement is used by mysqlcheck (as invoked by mysql_upgrade).\n\nFor example, if a database in MySQL 5.0 has the name a-b-c, the name\ncontains instances of the - (dash) character. In MySQL 5.0, the\ndatabase directory is also named a-b-c, which is not necessarily safe\nfor all file systems. In MySQL 5.1 and later, the same database name is\nencoded as a@002db@002dc to produce a file system-neutral directory\nname.\n\nWhen a MySQL installation is upgraded to MySQL 5.1 or later from an\nolder version,the server displays a name such as a-b-c (which is in the\nold format) as #mysql50#a-b-c, and you must refer to the name using the\n#mysql50# prefix. Use UPGRADE DATA DIRECTORY NAME in this case to\nexplicitly tell the server to re-encode the database directory name to\nthe current encoding format:\n\nALTER DATABASE `#mysql50#a-b-c` UPGRADE DATA DIRECTORY NAME;\n\nAfter executing this statement, you can refer to the database as a-b-c\nwithout the special #mysql50# prefix.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/alter-database.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/alter-database.html'),(116,'GEOMETRYN',26,'GeometryN(gc,N)\n\nReturns the N-th geometry in the GeometryCollection value gc.\nGeometries are numbered beginning with 1.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/geometry-property-functions.html\n\n','mysql> SET @gc = \'GeometryCollection(Point(1 1),LineString(2 2, 3 3))\';\nmysql> SELECT AsText(GeometryN(GeomFromText(@gc),1));\n+----------------------------------------+\n| AsText(GeometryN(GeomFromText(@gc),1)) |\n+----------------------------------------+\n| POINT(1 1)                             |\n+----------------------------------------+\n','http://dev.mysql.com/doc/refman/5.6/en/geometry-property-functions.html'),(117,'<<',20,'Syntax:\n<<\n\nShifts a longlong (BIGINT) number to the left.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/bit-functions.html\n\n','mysql> SELECT 1 << 2;\n        -> 4\n','http://dev.mysql.com/doc/refman/5.6/en/bit-functions.html'),(118,'SHOW TABLE STATUS',27,'Syntax:\nSHOW TABLE STATUS [{FROM | IN} db_name]\n    [LIKE \'pattern\' | WHERE expr]\n\nSHOW TABLE STATUS works likes SHOW TABLES, but provides a lot of\ninformation about each non-TEMPORARY table. You can also get this list\nusing the mysqlshow --status db_name command. The LIKE clause, if\npresent, indicates which table names to match. The WHERE clause can be\ngiven to select rows using more general conditions, as discussed in\nhttp://dev.mysql.com/doc/refman/5.6/en/extended-show.html.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/show-table-status.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/show-table-status.html'),(119,'ASCII',38,'Syntax:\nASCII(str)\n\nReturns the numeric value of the leftmost character of the string str.\nReturns 0 if str is the empty string. Returns NULL if str is NULL.\nASCII() works for 8-bit characters.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/string-functions.html\n\n','mysql> SELECT ASCII(\'2\');\n        -> 50\nmysql> SELECT ASCII(2);\n        -> 50\nmysql> SELECT ASCII(\'dx\');\n        -> 100\n','http://dev.mysql.com/doc/refman/5.6/en/string-functions.html'),(120,'DIV',4,'Syntax:\nDIV\n\nInteger division. Similar to FLOOR(), but is safe with BIGINT values.\n\nIn MySQL 5.6, if either operand has a noninteger type, the operands are\nconverted to DECIMAL and divided using DECIMAL arithmetic before\nconverting the result to BIGINT. If the result exceeds BIGINT range, an\nerror occurs.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/arithmetic-functions.html\n\n','mysql> SELECT 5 DIV 2;\n        -> 2\n','http://dev.mysql.com/doc/refman/5.6/en/arithmetic-functions.html'),(121,'SHOW SLAVE STATUS',27,'Syntax:\nSHOW SLAVE STATUS\n\nThis statement provides status information on essential parameters of\nthe slave threads. It requires either the SUPER or REPLICATION CLIENT\nprivilege.\n\nIf you issue this statement using the mysql client, you can use a \\G\nstatement terminator rather than a semicolon to obtain a more readable\nvertical layout:\n\nmysql> SHOW SLAVE STATUS\\G\n*************************** 1. row ***************************\n               Slave_IO_State: Waiting for master to send event\n                  Master_Host: localhost\n                  Master_User: root\n                  Master_Port: 13000\n                Connect_Retry: 60\n              Master_Log_File: master-bin.000002\n          Read_Master_Log_Pos: 1307\n               Relay_Log_File: slave-relay-bin.000003\n                Relay_Log_Pos: 1508\n        Relay_Master_Log_File: master-bin.000002\n             Slave_IO_Running: Yes\n            Slave_SQL_Running: Yes\n              Replicate_Do_DB:\n          Replicate_Ignore_DB:\n           Replicate_Do_Table:\n       Replicate_Ignore_Table:\n      Replicate_Wild_Do_Table:\n  Replicate_Wild_Ignore_Table:\n                   Last_Errno: 0\n                   Last_Error:\n                 Skip_Counter: 0\n          Exec_Master_Log_Pos: 1307\n              Relay_Log_Space: 1858\n              Until_Condition: None\n               Until_Log_File:\n                Until_Log_Pos: 0\n           Master_SSL_Allowed: No\n           Master_SSL_CA_File:\n           Master_SSL_CA_Path:\n              Master_SSL_Cert:\n            Master_SSL_Cipher:\n               Master_SSL_Key:\n        Seconds_Behind_Master: 0\nMaster_SSL_Verify_Server_Cert: No\n                Last_IO_Errno: 0\n                Last_IO_Error:\n               Last_SQL_Errno: 0\n               Last_SQL_Error:\n  Replicate_Ignore_Server_Ids:\n             Master_Server_Id: 1\n                  Master_UUID: 3e11fa47-71ca-11e1-9e33-c80aa9429562\n             Master_Info_File: /var/mysqld.2/data/master.info\n                    SQL_Delay: 0\n          SQL_Remaining_Delay: NULL\n      Slave_SQL_Running_State: Slave has read all relay log; waiting for the slave I/O thread to update it\n           Master_Retry_Count: 10\n                  Master_Bind:\n      Last_IO_Error_Timestamp:\n     Last_SQL_Error_Timestamp:\n               Master_SSL_Crl:\n           Master_SSL_Crlpath:\n           Retrieved_Gtid_Set: 3e11fa47-71ca-11e1-9e33-c80aa9429562:1-5\n            Executed_Gtid_Set: 3e11fa47-71ca-11e1-9e33-c80aa9429562:1-5\n                Auto_Position: 1\n1 row in set (0.00 sec)\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/show-slave-status.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/show-slave-status.html'),(122,'GEOMETRY',35,'MySQL provides a standard way of creating spatial columns for geometry\ntypes, for example, with CREATE TABLE or ALTER TABLE. Currently,\nspatial columns are supported for MyISAM, InnoDB, NDB, and ARCHIVE\ntables. See also the annotations about spatial indexes under [HELP\nSPATIAL].\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/creating-spatial-columns.html\n\n','CREATE TABLE geom (g GEOMETRY);\n','http://dev.mysql.com/doc/refman/5.6/en/creating-spatial-columns.html'),(123,'&',20,'Syntax:\n&\n\nBitwise AND:\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/bit-functions.html\n\n','mysql> SELECT 29 & 15;\n        -> 13\n','http://dev.mysql.com/doc/refman/5.6/en/bit-functions.html'),(124,'ASSIGN-EQUAL',15,'Syntax:\n=\n\nThis operator is used to perform value assignments in two cases,\ndescribed in the next two paragraphs.\n\nWithin a SET statement, = is treated as an assignment operator that\ncauses the user variable on the left hand side of the operator to take\non the value to its right. (In other words, when used in a SET\nstatement, = is treated identically to :=.) The value on the right hand\nside may be a literal value, another variable storing a value, or any\nlegal expression that yields a scalar value, including the result of a\nquery (provided that this value is a scalar value). You can perform\nmultiple assignments in the same SET statement.\n\nIn the SET clause of an UPDATE statement, = also acts as an assignment\noperator; in this case, however, it causes the column named on the left\nhand side of the operator to assume the value given to the right,\nprovided any WHERE conditions that are part of the UPDATE are met. You\ncan make multiple assignments in the same SET clause of an UPDATE\nstatement.\n\nIn any other context, = is treated as a comparison operator.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/assignment-operators.html\n\n','mysql> SELECT @var1, @var2;\n        -> NULL, NULL\nmysql> SELECT @var1 := 1, @var2;\n        -> 1, NULL\nmysql> SELECT @var1, @var2;\n        -> 1, NULL\nmysql> SELECT @var1, @var2 := @var1;\n        -> 1, 1\nmysql> SELECT @var1, @var2;\n        -> 1, 1\n','http://dev.mysql.com/doc/refman/5.6/en/assignment-operators.html'),(125,'CONVERT',38,'Syntax:\nCONVERT(expr,type), CONVERT(expr USING transcoding_name)\n\nThe CONVERT() and CAST() functions take an expression of any type and\nproduce a result value of a specified type.\n\nThe type for the result can be one of the following values:\n\no BINARY[(N)]\n\no CHAR[(N)]\n\no DATE\n\no DATETIME\n\no DECIMAL[(M[,D])]\n\no SIGNED [INTEGER]\n\no TIME\n\no UNSIGNED [INTEGER]\n\nBINARY produces a string with the BINARY data type. See\nhttp://dev.mysql.com/doc/refman/5.6/en/binary-varbinary.html for a\ndescription of how this affects comparisons. If the optional length N\nis given, BINARY(N) causes the cast to use no more than N bytes of the\nargument. Values shorter than N bytes are padded with 0x00 bytes to a\nlength of N.\n\nCHAR(N) causes the cast to use no more than N characters of the\nargument.\n\nCAST() and CONVERT(... USING ...) are standard SQL syntax. The\nnon-USING form of CONVERT() is ODBC syntax.\n\nCONVERT() with USING is used to convert data between different\ncharacter sets. In MySQL, transcoding names are the same as the\ncorresponding character set names. For example, this statement converts\nthe string \'abc\' in the default character set to the corresponding\nstring in the utf8 character set:\n\nSELECT CONVERT(\'abc\' USING utf8);\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/cast-functions.html\n\n','SELECT enum_col FROM tbl_name ORDER BY CAST(enum_col AS CHAR);\n','http://dev.mysql.com/doc/refman/5.6/en/cast-functions.html'),(126,'REPEAT LOOP',24,'Syntax:\n[begin_label:] REPEAT\n    statement_list\nUNTIL search_condition\nEND REPEAT [end_label]\n\nThe statement list within a REPEAT statement is repeated until the\nsearch_condition expression is true. Thus, a REPEAT always enters the\nloop at least once. statement_list consists of one or more statements,\neach terminated by a semicolon (;) statement delimiter.\n\nA REPEAT statement can be labeled. For the rules regarding label use,\nsee [HELP labels].\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/repeat.html\n\n','mysql> delimiter //\n\nmysql> CREATE PROCEDURE dorepeat(p1 INT)\n    -> BEGIN\n    ->   SET @x = 0;\n    ->   REPEAT\n    ->     SET @x = @x + 1;\n    ->   UNTIL @x > p1 END REPEAT;\n    -> END\n    -> //\nQuery OK, 0 rows affected (0.00 sec)\n\nmysql> CALL dorepeat(1000)//\nQuery OK, 0 rows affected (0.00 sec)\n\nmysql> SELECT @x//\n+------+\n| @x   |\n+------+\n| 1001 |\n+------+\n1 row in set (0.00 sec)\n','http://dev.mysql.com/doc/refman/5.6/en/repeat.html'),(127,'SMALLINT',23,'SMALLINT[(M)] [UNSIGNED] [ZEROFILL]\n\nA small integer. The signed range is -32768 to 32767. The unsigned\nrange is 0 to 65535.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/numeric-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/numeric-type-overview.html'),(128,'DOUBLE PRECISION',23,'DOUBLE PRECISION[(M,D)] [UNSIGNED] [ZEROFILL], REAL[(M,D)] [UNSIGNED]\n[ZEROFILL]\n\nThese types are synonyms for DOUBLE. Exception: If the REAL_AS_FLOAT\nSQL mode is enabled, REAL is a synonym for FLOAT rather than DOUBLE.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/numeric-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/numeric-type-overview.html'),(129,'ORD',38,'Syntax:\nORD(str)\n\nIf the leftmost character of the string str is a multi-byte character,\nreturns the code for that character, calculated from the numeric values\nof its constituent bytes using this formula:\n\n  (1st byte code)\n+ (2nd byte code * 256)\n+ (3rd byte code * 2562) ...\n\nIf the leftmost character is not a multi-byte character, ORD() returns\nthe same value as the ASCII() function.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/string-functions.html\n\n','mysql> SELECT ORD(\'2\');\n        -> 50\n','http://dev.mysql.com/doc/refman/5.6/en/string-functions.html'),(130,'ENVELOPE',37,'Envelope(g)\n\nReturns the Minimum Bounding Rectangle (MBR) for the geometry value g.\nThe result is returned as a Polygon value.\n\nThe polygon is defined by the corner points of the bounding box:\n\nPOLYGON((MINX MINY, MAXX MINY, MAXX MAXY, MINX MAXY, MINX MINY))\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/geometry-property-functions.html\n\n','mysql> SELECT AsText(Envelope(GeomFromText(\'LineString(1 1,2 2)\')));\n+-------------------------------------------------------+\n| AsText(Envelope(GeomFromText(\'LineString(1 1,2 2)\'))) |\n+-------------------------------------------------------+\n| POLYGON((1 1,2 1,2 2,1 2,1 1))                        |\n+-------------------------------------------------------+\n','http://dev.mysql.com/doc/refman/5.6/en/geometry-property-functions.html'),(131,'INET_ATON',14,'Syntax:\nINET_ATON(expr)\n\nGiven the dotted-quad representation of an IPv4 network address as a\nstring, returns an integer that represents the numeric value of the\naddress in network byte order (big endian). INET_ATON() returns NULL if\nit does not understand its argument.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/miscellaneous-functions.html\n\n','mysql> SELECT INET_ATON(\'10.0.5.9\');\n        -> 167773449\n','http://dev.mysql.com/doc/refman/5.6/en/miscellaneous-functions.html'),(132,'ISSIMPLE',37,'IsSimple(g)\n\nReturns 1 if the geometry value g has no anomalous geometric points,\nsuch as self-intersection or self-tangency. IsSimple() returns 0 if the\nargument is not simple, and NULL if it is NULL.\n\nThe description of each instantiable geometric class given earlier in\nthe chapter includes the specific conditions that cause an instance of\nthat class to be classified as not simple. (See [HELP Geometry\nhierarchy].)\n\nPrior to MySQL 5.6.1, this function always returns 0.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/geometry-property-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/geometry-property-functions.html'),(133,'- BINARY',4,'Syntax:\n-\n\nSubtraction:\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/arithmetic-functions.html\n\n','mysql> SELECT 3-5;\n        -> -2\n','http://dev.mysql.com/doc/refman/5.6/en/arithmetic-functions.html'),(134,'WKT DEFINITION',3,'The Well-Known Text (WKT) representation of Geometry is designed to\nexchange geometry data in ASCII form. For a Backus-Naur grammar that\nspecifies the formal production rules for writing WKT values, see the\nOpenGIS specification document referenced in\nhttp://dev.mysql.com/doc/refman/5.6/en/spatial-extensions.html.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/gis-wkt-format.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/gis-wkt-format.html'),(135,'CURRENT_TIME',32,'Syntax:\nCURRENT_TIME, CURRENT_TIME([fsp])\n\nCURRENT_TIME and CURRENT_TIME() are synonyms for CURTIME().\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html'),(136,'REVOKE',10,'Syntax:\nREVOKE\n    priv_type [(column_list)]\n      [, priv_type [(column_list)]] ...\n    ON [object_type] priv_level\n    FROM user [, user] ...\n\nREVOKE ALL PRIVILEGES, GRANT OPTION\n    FROM user [, user] ...\n\nREVOKE PROXY ON user\n    FROM user [, user] ...\n\nThe REVOKE statement enables system administrators to revoke privileges\nfrom MySQL accounts. Each account name uses the format described in\nhttp://dev.mysql.com/doc/refman/5.6/en/account-names.html. For example:\n\nREVOKE INSERT ON *.* FROM \'jeffrey\'@\'localhost\';\n\nIf you specify only the user name part of the account name, a host name\npart of \'%\' is used.\n\nFor details on the levels at which privileges exist, the permissible\npriv_type and priv_level values, and the syntax for specifying users\nand passwords, see [HELP GRANT]\n\nTo use the first REVOKE syntax, you must have the GRANT OPTION\nprivilege, and you must have the privileges that you are revoking.\n\nTo revoke all privileges, use the second syntax, which drops all\nglobal, database, table, column, and routine privileges for the named\nuser or users:\n\nREVOKE ALL PRIVILEGES, GRANT OPTION FROM user [, user] ...\n\nTo use this REVOKE syntax, you must have the global CREATE USER\nprivilege or the UPDATE privilege for the mysql database.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/revoke.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/revoke.html'),(137,'LAST_DAY',32,'Syntax:\nLAST_DAY(date)\n\nTakes a date or datetime value and returns the corresponding value for\nthe last day of the month. Returns NULL if the argument is invalid.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html\n\n','mysql> SELECT LAST_DAY(\'2003-02-05\');\n        -> \'2003-02-28\'\nmysql> SELECT LAST_DAY(\'2004-02-05\');\n        -> \'2004-02-29\'\nmysql> SELECT LAST_DAY(\'2004-01-01 01:01:01\');\n        -> \'2004-01-31\'\nmysql> SELECT LAST_DAY(\'2003-03-32\');\n        -> NULL\n','http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html'),(138,'MEDIUMINT',23,'MEDIUMINT[(M)] [UNSIGNED] [ZEROFILL]\n\nA medium-sized integer. The signed range is -8388608 to 8388607. The\nunsigned range is 0 to 16777215.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/numeric-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/numeric-type-overview.html'),(139,'RTRIM',38,'Syntax:\nRTRIM(str)\n\nReturns the string str with trailing space characters removed.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/string-functions.html\n\n','mysql> SELECT RTRIM(\'barbar   \');\n        -> \'barbar\'\n','http://dev.mysql.com/doc/refman/5.6/en/string-functions.html'),(140,'EXPLAIN',29,'Syntax:\n{EXPLAIN | DESCRIBE | DESC}\n    tbl_name [col_name | wild]\n\n{EXPLAIN | DESCRIBE | DESC}\n    [explain_type] explainable_stmt\n\nexplain_type:\n    EXTENDED\n  | PARTITIONS\n  | FORMAT = format_name\n\nformat_name:\n    TRADITIONAL\n  | JSON\n\nexplainable_stmt:\n      SELECT statement\n    | DELETE statement\n    | INSERT statement\n    | REPLACE statement\n    | UPDATE statement\n\nThe DESCRIBE and EXPLAIN statements are synonyms. In practice, the\nDESCRIBE keyword is more often used to obtain information about table\nstructure, whereas EXPLAIN is used to obtain a query execution plan\n(that is, an explanation of how MySQL would execute a query). The\nfollowing discussion uses the DESCRIBE and EXPLAIN keywords in\naccordance with those uses, but the MySQL parser treats them as\ncompletely synonymous.\n\nObtaining Table Structure Information\n\nDESCRIBE provides information about the columns in a table. It is a\nshortcut for SHOW COLUMNS FROM. These statements also display\ninformation for views. (See [HELP SHOW COLUMNS].)\n\ncol_name can be a column name, or a string containing the SQL \"%\" and\n\"_\" wildcard characters to obtain output only for the columns with\nnames matching the string. There is no need to enclose the string\nwithin quotation marks unless it contains spaces or other special\ncharacters.\n\nmysql> DESCRIBE City;\n+------------+----------+------+-----+---------+----------------+\n| Field      | Type     | Null | Key | Default | Extra          |\n+------------+----------+------+-----+---------+----------------+\n| Id         | int(11)  | NO   | PRI | NULL    | auto_increment |\n| Name       | char(35) | NO   |     |         |                |\n| Country    | char(3)  | NO   | UNI |         |                |\n| District   | char(20) | YES  | MUL |         |                |\n| Population | int(11)  | NO   |     | 0       |                |\n+------------+----------+------+-----+---------+----------------+\n5 rows in set (0.00 sec)\n\nThe description for SHOW COLUMNS provides more information about the\noutput columns (see [HELP SHOW COLUMNS]).\n\nIf the data types differ from what you expect them to be based on a\nCREATE TABLE statement, note that MySQL sometimes changes data types\nwhen you create or alter a table. The conditions under which this\noccurs are described in\nhttp://dev.mysql.com/doc/refman/5.6/en/silent-column-changes.html.\n\nThe DESCRIBE statement is provided for compatibility with Oracle.\n\nThe SHOW CREATE TABLE, SHOW TABLE STATUS, and SHOW INDEX statements\nalso provide information about tables. See [HELP SHOW].\n\nObtaining Query Execution Plan Information\n\nThe EXPLAIN statement provides a way to obtain information about how\nMySQL executes a statement:\n\no When you precede a statement with the keyword EXPLAIN, MySQL displays\n  information from the optimizer about the statement execution plan.\n  That is, MySQL explains how it would process the statement, including\n  information about how tables are joined and in which order. EXPLAIN\n  EXTENDED can be used to obtain additional information.\n\n  As of MySQL 5.6.3, EXPLAIN provides information about SELECT, DELETE,\n  INSERT, REPLACE, and UPDATE statements. Before MySQL 5.6.3, EXPLAIN\n  provides information only about SELECT statements.\n\n  For information about using EXPLAIN and EXPLAIN EXTENDED to obtain\n  query execution plan information, see\n  http://dev.mysql.com/doc/refman/5.6/en/using-explain.html.\n\no EXPLAIN PARTITIONS is useful only when examining queries involving\n  partitioned tables. For details, see\n  http://dev.mysql.com/doc/refman/5.6/en/partitioning-info.html.\n\no As of MySQL 5.6.5, the FORMAT option can be used to select the output\n  format. TRADITIONAL presents the output in tabular format. This is\n  the default if no FORMAT option is present. JSON format displays the\n  information in JSON format. With FORMAT = JSON, the output includes\n  extended and partition information.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/explain.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/explain.html'),(141,'DEGREES',4,'Syntax:\nDEGREES(X)\n\nReturns the argument X, converted from radians to degrees.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/mathematical-functions.html\n\n','mysql> SELECT DEGREES(PI());\n        -> 180\nmysql> SELECT DEGREES(PI() / 2);\n        -> 90\n','http://dev.mysql.com/doc/refman/5.6/en/mathematical-functions.html'),(142,'- UNARY',4,'Syntax:\n-\n\nUnary minus. This operator changes the sign of the operand.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/arithmetic-functions.html\n\n','mysql> SELECT - 2;\n        -> -2\n','http://dev.mysql.com/doc/refman/5.6/en/arithmetic-functions.html'),(143,'VARCHAR',23,'[NATIONAL] VARCHAR(M) [CHARACTER SET charset_name] [COLLATE\ncollation_name]\n\nA variable-length string. M represents the maximum column length in\ncharacters. The range of M is 0 to 65,535. The effective maximum length\nof a VARCHAR is subject to the maximum row size (65,535 bytes, which is\nshared among all columns) and the character set used. For example, utf8\ncharacters can require up to three bytes per character, so a VARCHAR\ncolumn that uses the utf8 character set can be declared to be a maximum\nof 21,844 characters. See\nhttp://dev.mysql.com/doc/refman/5.6/en/column-count-limit.html.\n\nMySQL stores VARCHAR values as a 1-byte or 2-byte length prefix plus\ndata. The length prefix indicates the number of bytes in the value. A\nVARCHAR column uses one length byte if values require no more than 255\nbytes, two length bytes if values may require more than 255 bytes.\n\n*Note*: MySQL 5.6 follows the standard SQL specification, and does not\nremove trailing spaces from VARCHAR values.\n\nVARCHAR is shorthand for CHARACTER VARYING. NATIONAL VARCHAR is the\nstandard SQL way to define that a VARCHAR column should use some\npredefined character set. MySQL 4.1 and up uses utf8 as this predefined\ncharacter set.\nhttp://dev.mysql.com/doc/refman/5.6/en/charset-national.html. NVARCHAR\nis shorthand for NATIONAL VARCHAR.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/string-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/string-type-overview.html'),(144,'UNHEX',38,'Syntax:\n\nUNHEX(str)\n\nFor a string argument str, UNHEX(str) performs the inverse operation of\nHEX(str). That is, it interprets each pair of characters in the\nargument as a hexadecimal number and converts it to the character\nrepresented by the number. The return value is a binary string.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/string-functions.html\n\n','mysql> SELECT UNHEX(\'4D7953514C\');\n        -> \'MySQL\'\nmysql> SELECT 0x4D7953514C;\n        -> \'MySQL\'\nmysql> SELECT UNHEX(HEX(\'string\'));\n        -> \'string\'\nmysql> SELECT HEX(UNHEX(\'1267\'));\n        -> \'1267\'\n','http://dev.mysql.com/doc/refman/5.6/en/string-functions.html'),(145,'DROP TRIGGER',40,'Syntax:\nDROP TRIGGER [IF EXISTS] [schema_name.]trigger_name\n\nThis statement drops a trigger. The schema (database) name is optional.\nIf the schema is omitted, the trigger is dropped from the default\nschema. DROP TRIGGER requires the TRIGGER privilege for the table\nassociated with the trigger.\n\nUse IF EXISTS to prevent an error from occurring for a trigger that\ndoes not exist. A NOTE is generated for a nonexistent trigger when\nusing IF EXISTS. See [HELP SHOW WARNINGS].\n\nTriggers for a table are also dropped if you drop the table.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/drop-trigger.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/drop-trigger.html'),(146,'RESET MASTER',8,'Syntax:\nRESET MASTER\n\nDeletes all binary log files listed in the index file, resets the\nbinary log index file to be empty, and creates a new binary log file.\n\nIn MySQL 5.6.5 and later, RESET MASTER also clears the values of the\ngtid_purged system variable (known as gtid_lost in MySQL 5.6.8 and\nearlier) as well as the global value of the gtid_executed (gtid_done,\nprior to MySQL 5.6.9) system variable (but not its session value); that\nis, executing this statement sets each of these values to an empty\nstring (\'\').\n\nThis statement is intended to be used only when the master is started\nfor the first time.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/reset-master.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/reset-master.html'),(147,'PI',4,'Syntax:\nPI()\n\nReturns the value of π (pi). The default number of decimal places\ndisplayed is seven, but MySQL uses the full double-precision value\ninternally.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/mathematical-functions.html\n\n','mysql> SELECT PI();\n        -> 3.141593\nmysql> SELECT PI()+0.000000000000000000;\n        -> 3.141592653589793116\n','http://dev.mysql.com/doc/refman/5.6/en/mathematical-functions.html'),(148,'/',4,'Syntax:\n/\n\nDivision:\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/arithmetic-functions.html\n\n','mysql> SELECT 3/5;\n        -> 0.60\n','http://dev.mysql.com/doc/refman/5.6/en/arithmetic-functions.html'),(149,'PURGE BINARY LOGS',8,'Syntax:\nPURGE { BINARY | MASTER } LOGS\n    { TO \'log_name\' | BEFORE datetime_expr }\n\nThe binary log is a set of files that contain information about data\nmodifications made by the MySQL server. The log consists of a set of\nbinary log files, plus an index file (see\nhttp://dev.mysql.com/doc/refman/5.6/en/binary-log.html).\n\nThe PURGE BINARY LOGS statement deletes all the binary log files listed\nin the log index file prior to the specified log file name or date.\nBINARY and MASTER are synonyms. Deleted log files also are removed from\nthe list recorded in the index file, so that the given log file becomes\nthe first in the list.\n\nThis statement has no effect if the server was not started with the\n--log-bin option to enable binary logging.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/purge-binary-logs.html\n\n','PURGE BINARY LOGS TO \'mysql-bin.010\';\nPURGE BINARY LOGS BEFORE \'2008-04-02 22:46:26\';\n','http://dev.mysql.com/doc/refman/5.6/en/purge-binary-logs.html'),(150,'STDDEV_SAMP',16,'Syntax:\nSTDDEV_SAMP(expr)\n\nReturns the sample standard deviation of expr (the square root of\nVAR_SAMP().\n\nSTDDEV_SAMP() returns NULL if there were no matching rows.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/group-by-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/group-by-functions.html'),(151,'ST_TOUCHES',31,'ST_Touches(g1,g2)\n\nReturns 1 or 0 to indicate whether g1 spatially touches g2. Two\ngeometries spatially touch if the interiors of the geometries do not\nintersect, but the boundary of one of the geometries intersects either\nthe boundary or the interior of the other.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/functions-for-testing-spatial-relations-between-geometric-objects.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/functions-for-testing-spatial-relations-between-geometric-objects.html'),(152,'SCHEMA',17,'Syntax:\nSCHEMA()\n\nThis function is a synonym for DATABASE().\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/information-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/information-functions.html'),(153,'MLINEFROMWKB',33,'MLineFromWKB(wkb[,srid]), MultiLineStringFromWKB(wkb[,srid])\n\nConstructs a MULTILINESTRING value using its WKB representation and\nSRID.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/creating-spatial-values.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/creating-spatial-values.html'),(154,'SHOW CREATE TABLE',27,'Syntax:\nSHOW CREATE TABLE tbl_name\n\nShows the CREATE TABLE statement that creates the given table. To use\nthis statement, you must have some privilege for the table. This\nstatement also works with views.\nSHOW CREATE TABLE quotes table and column names according to the value\nof the sql_quote_show_create option. See\nhttp://dev.mysql.com/doc/refman/5.6/en/server-system-variables.html.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/show-create-table.html\n\n','mysql> SHOW CREATE TABLE t\\G\n*************************** 1. row ***************************\n       Table: t\nCreate Table: CREATE TABLE t (\n  id INT(11) default NULL auto_increment,\n  s char(60) default NULL,\n  PRIMARY KEY (id)\n) ENGINE=MyISAM\n','http://dev.mysql.com/doc/refman/5.6/en/show-create-table.html'),(155,'DUAL',28,'You are permitted to specify DUAL as a dummy table name in situations\nwhere no tables are referenced:\n\nmysql> SELECT 1 + 1 FROM DUAL;\n        -> 2\n\nDUAL is purely for the convenience of people who require that all\nSELECT statements should have FROM and possibly other clauses. MySQL\nmay ignore the clauses. MySQL does not require FROM DUAL if no tables\nare referenced.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/select.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/select.html'),(156,'INSTR',38,'Syntax:\nINSTR(str,substr)\n\nReturns the position of the first occurrence of substring substr in\nstring str. This is the same as the two-argument form of LOCATE(),\nexcept that the order of the arguments is reversed.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/string-functions.html\n\n','mysql> SELECT INSTR(\'foobarbar\', \'bar\');\n        -> 4\nmysql> SELECT INSTR(\'xbar\', \'foobar\');\n        -> 0\n','http://dev.mysql.com/doc/refman/5.6/en/string-functions.html'),(157,'>=',19,'Syntax:\n>=\n\nGreater than or equal:\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/comparison-operators.html\n\n','mysql> SELECT 2 >= 2;\n        -> 1\n','http://dev.mysql.com/doc/refman/5.6/en/comparison-operators.html'),(158,'EXP',4,'Syntax:\nEXP(X)\n\nReturns the value of e (the base of natural logarithms) raised to the\npower of X. The inverse of this function is LOG() (using a single\nargument only) or LN().\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/mathematical-functions.html\n\n','mysql> SELECT EXP(2);\n        -> 7.3890560989307\nmysql> SELECT EXP(-2);\n        -> 0.13533528323661\nmysql> SELECT EXP(0);\n        -> 1\n','http://dev.mysql.com/doc/refman/5.6/en/mathematical-functions.html'),(159,'POINTN',13,'PointN(ls,N)\n\nReturns the N-th Point in the Linestring value ls. Points are numbered\nbeginning with 1.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/geometry-property-functions.html\n\n','mysql> SET @ls = \'LineString(1 1,2 2,3 3)\';\nmysql> SELECT AsText(PointN(GeomFromText(@ls),2));\n+-------------------------------------+\n| AsText(PointN(GeomFromText(@ls),2)) |\n+-------------------------------------+\n| POINT(2 2)                          |\n+-------------------------------------+\n','http://dev.mysql.com/doc/refman/5.6/en/geometry-property-functions.html'),(160,'OCT',38,'Syntax:\nOCT(N)\n\nReturns a string representation of the octal value of N, where N is a\nlonglong (BIGINT) number. This is equivalent to CONV(N,10,8). Returns\nNULL if N is NULL.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/string-functions.html\n\n','mysql> SELECT OCT(12);\n        -> \'14\'\n','http://dev.mysql.com/doc/refman/5.6/en/string-functions.html'),(161,'SYSDATE',32,'Syntax:\nSYSDATE()\n\nReturns the current date and time as a value in \'YYYY-MM-DD HH:MM:SS\'\nor YYYYMMDDHHMMSS format, depending on whether the function is used in\na string or numeric context.\n\nSYSDATE() returns the time at which it executes. This differs from the\nbehavior for NOW(), which returns a constant time that indicates the\ntime at which the statement began to execute. (Within a stored function\nor trigger, NOW() returns the time at which the function or triggering\nstatement began to execute.)\n\nmysql> SELECT NOW(), SLEEP(2), NOW();\n+---------------------+----------+---------------------+\n| NOW()               | SLEEP(2) | NOW()               |\n+---------------------+----------+---------------------+\n| 2006-04-12 13:47:36 |        0 | 2006-04-12 13:47:36 |\n+---------------------+----------+---------------------+\n\nmysql> SELECT SYSDATE(), SLEEP(2), SYSDATE();\n+---------------------+----------+---------------------+\n| SYSDATE()           | SLEEP(2) | SYSDATE()           |\n+---------------------+----------+---------------------+\n| 2006-04-12 13:47:44 |        0 | 2006-04-12 13:47:46 |\n+---------------------+----------+---------------------+\n\nIn addition, the SET TIMESTAMP statement affects the value returned by\nNOW() but not by SYSDATE(). This means that timestamp settings in the\nbinary log have no effect on invocations of SYSDATE().\n\nBecause SYSDATE() can return different values even within the same\nstatement, and is not affected by SET TIMESTAMP, it is nondeterministic\nand therefore unsafe for replication if statement-based binary logging\nis used. If that is a problem, you can use row-based logging.\n\nAlternatively, you can use the --sysdate-is-now option to cause\nSYSDATE() to be an alias for NOW(). This works if the option is used on\nboth the master and the slave.\n\nThe nondeterministic nature of SYSDATE() also means that indexes cannot\nbe used for evaluating expressions that refer to it.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html'),(162,'UNINSTALL PLUGIN',5,'Syntax:\nUNINSTALL PLUGIN plugin_name\n\nThis statement removes an installed server plugin. It requires the\nDELETE privilege for the mysql.plugin table.\n\nplugin_name must be the name of some plugin that is listed in the\nmysql.plugin table. The server executes the plugin\'s deinitialization\nfunction and removes the row for the plugin from the mysql.plugin\ntable, so that subsequent server restarts will not load and initialize\nthe plugin. UNINSTALL PLUGIN does not remove the plugin\'s shared\nlibrary file.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/uninstall-plugin.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/uninstall-plugin.html'),(163,'ASBINARY',33,'AsBinary(g), AsWKB(g)\n\nConverts a value in internal geometry format to its WKB representation\nand returns the binary result.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/functions-to-convert-geometries-between-formats.html\n\n','SELECT AsBinary(g) FROM geom;\n','http://dev.mysql.com/doc/refman/5.6/en/functions-to-convert-geometries-between-formats.html'),(164,'SHOW TABLES',27,'Syntax:\nSHOW [FULL] TABLES [{FROM | IN} db_name]\n    [LIKE \'pattern\' | WHERE expr]\n\nSHOW TABLES lists the non-TEMPORARY tables in a given database. You can\nalso get this list using the mysqlshow db_name command. The LIKE\nclause, if present, indicates which table names to match. The WHERE\nclause can be given to select rows using more general conditions, as\ndiscussed in http://dev.mysql.com/doc/refman/5.6/en/extended-show.html.\n\nMatching performed by the LIKE clause is dependent on the setting of\nthe lower_case_table_names system variable.\n\nThis statement also lists any views in the database. The FULL modifier\nis supported such that SHOW FULL TABLES displays a second output\ncolumn. Values for the second column are BASE TABLE for a table and\nVIEW for a view.\n\nIf you have no privileges for a base table or view, it does not show up\nin the output from SHOW TABLES or mysqlshow db_name.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/show-tables.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/show-tables.html'),(165,'MAKEDATE',32,'Syntax:\nMAKEDATE(year,dayofyear)\n\nReturns a date, given year and day-of-year values. dayofyear must be\ngreater than 0 or the result is NULL.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html\n\n','mysql> SELECT MAKEDATE(2011,31), MAKEDATE(2011,32);\n        -> \'2011-01-31\', \'2011-02-01\'\nmysql> SELECT MAKEDATE(2011,365), MAKEDATE(2014,365);\n        -> \'2011-12-31\', \'2014-12-31\'\nmysql> SELECT MAKEDATE(2011,0);\n        -> NULL\n','http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html'),(166,'BINARY OPERATOR',38,'Syntax:\nBINARY\n\nThe BINARY operator casts the string following it to a binary string.\nThis is an easy way to force a column comparison to be done byte by\nbyte rather than character by character. This causes the comparison to\nbe case sensitive even if the column is not defined as BINARY or BLOB.\nBINARY also causes trailing spaces to be significant.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/cast-functions.html\n\n','mysql> SELECT \'a\' = \'A\';\n        -> 1\nmysql> SELECT BINARY \'a\' = \'A\';\n        -> 0\nmysql> SELECT \'a\' = \'a \';\n        -> 1\nmysql> SELECT BINARY \'a\' = \'a \';\n        -> 0\n','http://dev.mysql.com/doc/refman/5.6/en/cast-functions.html'),(167,'MBROVERLAPS',6,'MBROverlaps(g1,g2)\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of\nthe two geometries g1 and g2 overlap. The term spatially overlaps is\nused if two geometries intersect and their intersection results in a\ngeometry of the same dimension but not equal to either of the given\ngeometries.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/functions-for-testing-spatial-relations-between-geometric-objects.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/functions-for-testing-spatial-relations-between-geometric-objects.html'),(168,'INSERT SELECT',28,'Syntax:\nINSERT [LOW_PRIORITY | HIGH_PRIORITY] [IGNORE]\n    [INTO] tbl_name \n    [PARTITION (partition_name,...)]\n    [(col_name,...)]\n    SELECT ...\n    [ ON DUPLICATE KEY UPDATE col_name=expr, ... ]\n\nWith INSERT ... SELECT, you can quickly insert many rows into a table\nfrom one or many tables. For example:\n\nINSERT INTO tbl_temp2 (fld_id)\n  SELECT tbl_temp1.fld_order_id\n  FROM tbl_temp1 WHERE tbl_temp1.fld_order_id > 100;\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/insert-select.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/insert-select.html'),(169,'CREATE PROCEDURE',40,'Syntax:\nCREATE\n    [DEFINER = { user | CURRENT_USER }]\n    PROCEDURE sp_name ([proc_parameter[,...]])\n    [characteristic ...] routine_body\n\nCREATE\n    [DEFINER = { user | CURRENT_USER }]\n    FUNCTION sp_name ([func_parameter[,...]])\n    RETURNS type\n    [characteristic ...] routine_body\n\nproc_parameter:\n    [ IN | OUT | INOUT ] param_name type\n\nfunc_parameter:\n    param_name type\n\ntype:\n    Any valid MySQL data type\n\ncharacteristic:\n    COMMENT \'string\'\n  | LANGUAGE SQL\n  | [NOT] DETERMINISTIC\n  | { CONTAINS SQL | NO SQL | READS SQL DATA | MODIFIES SQL DATA }\n  | SQL SECURITY { DEFINER | INVOKER }\n\nroutine_body:\n    Valid SQL routine statement\n\nThese statements create stored routines. By default, a routine is\nassociated with the default database. To associate the routine\nexplicitly with a given database, specify the name as db_name.sp_name\nwhen you create it.\n\nThe CREATE FUNCTION statement is also used in MySQL to support UDFs\n(user-defined functions). See\nhttp://dev.mysql.com/doc/refman/5.6/en/adding-functions.html. A UDF can\nbe regarded as an external stored function. Stored functions share\ntheir namespace with UDFs. See\nhttp://dev.mysql.com/doc/refman/5.6/en/function-resolution.html, for\nthe rules describing how the server interprets references to different\nkinds of functions.\n\nTo invoke a stored procedure, use the CALL statement (see [HELP CALL]).\nTo invoke a stored function, refer to it in an expression. The function\nreturns a value during expression evaluation.\n\nCREATE PROCEDURE and CREATE FUNCTION require the CREATE ROUTINE\nprivilege. They might also require the SUPER privilege, depending on\nthe DEFINER value, as described later in this section. If binary\nlogging is enabled, CREATE FUNCTION might require the SUPER privilege,\nas described in\nhttp://dev.mysql.com/doc/refman/5.6/en/stored-programs-logging.html.\n\nBy default, MySQL automatically grants the ALTER ROUTINE and EXECUTE\nprivileges to the routine creator. This behavior can be changed by\ndisabling the automatic_sp_privileges system variable. See\nhttp://dev.mysql.com/doc/refman/5.6/en/stored-routines-privileges.html.\n\nThe DEFINER and SQL SECURITY clauses specify the security context to be\nused when checking access privileges at routine execution time, as\ndescribed later in this section.\n\nIf the routine name is the same as the name of a built-in SQL function,\na syntax error occurs unless you use a space between the name and the\nfollowing parenthesis when defining the routine or invoking it later.\nFor this reason, avoid using the names of existing SQL functions for\nyour own stored routines.\n\nThe IGNORE_SPACE SQL mode applies to built-in functions, not to stored\nroutines. It is always permissible to have spaces after a stored\nroutine name, regardless of whether IGNORE_SPACE is enabled.\n\nThe parameter list enclosed within parentheses must always be present.\nIf there are no parameters, an empty parameter list of () should be\nused. Parameter names are not case sensitive.\n\nEach parameter is an IN parameter by default. To specify otherwise for\na parameter, use the keyword OUT or INOUT before the parameter name.\n\n*Note*: Specifying a parameter as IN, OUT, or INOUT is valid only for a\nPROCEDURE. For a FUNCTION, parameters are always regarded as IN\nparameters.\n\nAn IN parameter passes a value into a procedure. The procedure might\nmodify the value, but the modification is not visible to the caller\nwhen the procedure returns. An OUT parameter passes a value from the\nprocedure back to the caller. Its initial value is NULL within the\nprocedure, and its value is visible to the caller when the procedure\nreturns. An INOUT parameter is initialized by the caller, can be\nmodified by the procedure, and any change made by the procedure is\nvisible to the caller when the procedure returns.\n\nFor each OUT or INOUT parameter, pass a user-defined variable in the\nCALL statement that invokes the procedure so that you can obtain its\nvalue when the procedure returns. If you are calling the procedure from\nwithin another stored procedure or function, you can also pass a\nroutine parameter or local routine variable as an IN or INOUT\nparameter.\n\nRoutine parameters cannot be referenced in statements prepared within\nthe routine; see\nhttp://dev.mysql.com/doc/refman/5.6/en/stored-program-restrictions.html\n.\n\nThe following example shows a simple stored procedure that uses an OUT\nparameter:\n\nmysql> delimiter //\n\nmysql> CREATE PROCEDURE simpleproc (OUT param1 INT)\n    -> BEGIN\n    ->   SELECT COUNT(*) INTO param1 FROM t;\n    -> END//\nQuery OK, 0 rows affected (0.00 sec)\n\nmysql> delimiter ;\n\nmysql> CALL simpleproc(@a);\nQuery OK, 0 rows affected (0.00 sec)\n\nmysql> SELECT @a;\n+------+\n| @a   |\n+------+\n| 3    |\n+------+\n1 row in set (0.00 sec)\n\nThe example uses the mysql client delimiter command to change the\nstatement delimiter from ; to // while the procedure is being defined.\nThis enables the ; delimiter used in the procedure body to be passed\nthrough to the server rather than being interpreted by mysql itself.\nSee\nhttp://dev.mysql.com/doc/refman/5.6/en/stored-programs-defining.html.\n\nThe RETURNS clause may be specified only for a FUNCTION, for which it\nis mandatory. It indicates the return type of the function, and the\nfunction body must contain a RETURN value statement. If the RETURN\nstatement returns a value of a different type, the value is coerced to\nthe proper type. For example, if a function specifies an ENUM or SET\nvalue in the RETURNS clause, but the RETURN statement returns an\ninteger, the value returned from the function is the string for the\ncorresponding ENUM member of set of SET members.\n\nThe following example function takes a parameter, performs an operation\nusing an SQL function, and returns the result. In this case, it is\nunnecessary to use delimiter because the function definition contains\nno internal ; statement delimiters:\n\nmysql> CREATE FUNCTION hello (s CHAR(20))\nmysql> RETURNS CHAR(50) DETERMINISTIC\n    -> RETURN CONCAT(\'Hello, \',s,\'!\');\nQuery OK, 0 rows affected (0.00 sec)\n\nmysql> SELECT hello(\'world\');\n+----------------+\n| hello(\'world\') |\n+----------------+\n| Hello, world!  |\n+----------------+\n1 row in set (0.00 sec)\n\nParameter types and function return types can be declared to use any\nvalid data type. The COLLATE attribute can be used if preceded by the\nCHARACTER SET attribute.\n\nThe routine_body consists of a valid SQL routine statement. This can be\na simple statement such as SELECT or INSERT, or a compound statement\nwritten using BEGIN and END. Compound statements can contain\ndeclarations, loops, and other control structure statements. The syntax\nfor these statements is described in\nhttp://dev.mysql.com/doc/refman/5.6/en/sql-syntax-compound-statements.h\ntml.\n\nMySQL permits routines to contain DDL statements, such as CREATE and\nDROP. MySQL also permits stored procedures (but not stored functions)\nto contain SQL transaction statements such as COMMIT. Stored functions\nmay not contain statements that perform explicit or implicit commit or\nrollback. Support for these statements is not required by the SQL\nstandard, which states that each DBMS vendor may decide whether to\npermit them.\n\nStatements that return a result set can be used within a stored\nprocedure but not within a stored function. This prohibition includes\nSELECT statements that do not have an INTO var_list clause and other\nstatements such as SHOW, EXPLAIN, and CHECK TABLE. For statements that\ncan be determined at function definition time to return a result set, a\nNot allowed to return a result set from a function error occurs\n(ER_SP_NO_RETSET). For statements that can be determined only at\nruntime to return a result set, a PROCEDURE %s can\'t return a result\nset in the given context error occurs (ER_SP_BADSELECT).\n\nUSE statements within stored routines are not permitted. When a routine\nis invoked, an implicit USE db_name is performed (and undone when the\nroutine terminates). The causes the routine to have the given default\ndatabase while it executes. References to objects in databases other\nthan the routine default database should be qualified with the\nappropriate database name.\n\nFor additional information about statements that are not permitted in\nstored routines, see\nhttp://dev.mysql.com/doc/refman/5.6/en/stored-program-restrictions.html\n.\n\nFor information about invoking stored procedures from within programs\nwritten in a language that has a MySQL interface, see [HELP CALL].\n\nMySQL stores the sql_mode system variable setting that is in effect at\nthe time a routine is created, and always executes the routine with\nthis setting in force, regardless of the server SQL mode in effect when\nthe routine is invoked.\n\nThe switch from the SQL mode of the invoker to that of the routine\noccurs after evaluation of arguments and assignment of the resulting\nvalues to routine parameters. If you define a routine in strict SQL\nmode but invoke it in nonstrict mode, assignment of arguments to\nroutine parameters does not take place in strict mode. If you require\nthat expressions passed to a routine be assigned in strict SQL mode,\nyou should invoke the routine with strict mode in effect.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/create-procedure.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/create-procedure.html'),(170,'SQL_THREAD_WAIT_AFTER_GTIDS',17,'Syntax:\nSQL_THREAD_WAIT_AFTER_GTIDS(gtid_set[, timeout])\n\nSQL_THREAD_WAIT_AFTER_GTIDS() was added in MySQL 5.6.5, and replaced by\nWAIT_UNTIL_SQL_THREAD_AFTER_GTIDS() in MySQL 5.6.9. (Bug #14775984)\n\nFor more information, see\nhttp://dev.mysql.com/doc/refman/5.6/en/replication-gtids.html.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/gtid-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/gtid-functions.html'),(171,'GET DIAGNOSTICS',24,'Syntax:\nGET [CURRENT] DIAGNOSTICS\n{\n    statement_information_item\n    [, statement_information_item] ... \n  | CONDITION condition_number\n    condition_information_item\n    [, condition_information_item] ...\n}\n\nstatement_information_item:\n    target = statement_information_item_name\n\ncondition_information_item:\n    target = condition_information_item_name\n\nstatement_information_item_name:\n    NUMBER\n  | ROW_COUNT\n\ncondition_information_item_name:\n    CLASS_ORIGIN\n  | SUBCLASS_ORIGIN\n  | RETURNED_SQLSTATE\n  | MESSAGE_TEXT\n  | MYSQL_ERRNO\n  | CONSTRAINT_CATALOG\n  | CONSTRAINT_SCHEMA\n  | CONSTRAINT_NAME\n  | CATALOG_NAME\n  | SCHEMA_NAME\n  | TABLE_NAME\n  | COLUMN_NAME\n  | CURSOR_NAME\n\ncondition_number, target:\n    (see following discussion)\n\nSQL statements produce diagnostic information that populates the\ndiagnostics area. The GET DIAGNOSTICS statement enables applications to\ninspect this information. It is available as of MySQL 5.6.4. (You can\nalso use SHOW WARNINGS or SHOW ERRORS to see conditions or errors.)\n\nNo special privileges are required to execute GET DIAGNOSTICS.\n\nThe keyword CURRENT means to retrieve information from the current\ndiagnostics area. In MySQL, it has no effect because that is the\ndefault behavior.\n\nGET DIAGNOSTICS is typically used in a handler within a stored program,\nbut it is a MySQL extension that it is permitted outside handler\ncontext to check the execution of any SQL statement. For example, if\nyou invoke the mysql client program, you can enter these statements at\nthe prompt:\n\nmysql> DROP TABLE test.no_such_table;\nERROR 1051 (42S02): Unknown table \'test.no_such_table\'\nmysql> GET DIAGNOSTICS CONDITION 1\n    ->   @p1 = RETURNED_SQLSTATE, @p2 = MESSAGE_TEXT;\nmysql> SELECT @p1, @p2;\n+-------+------------------------------------+\n| @p1   | @p2                                |\n+-------+------------------------------------+\n| 42S02 | Unknown table \'test.no_such_table\' |\n+-------+------------------------------------+\n\nFor a description of the diagnostics area, see\nhttp://dev.mysql.com/doc/refman/5.6/en/diagnostics-area.html. Briefly,\nit contains two kinds of information:\n\no Statement information, such as the number of conditions that occurred\n  or the affected-rows count.\n\no Condition information, such as the error code and message. If a\n  statement raises multiple conditions, this part of the diagnostics\n  area has a condition area for each one. If a statement raises no\n  conditions, this part of the diagnostics area is empty.\n\nFor a statement that produces three conditions, the diagnostics area\ncontains statement and condition information like this:\n\nStatement information:\n  row count\n  ... other statement information items ...\nCondition area list:\n  Condition area 1:\n    error code for condition 1\n    error message for condition 1\n    ... other condition information items ...\n  Condition area 2:\n    error code for condition 2:\n    error message for condition 2\n    ... other condition information items ...\n  Condition area 3:\n    error code for condition 3\n    error message for condition 3\n    ... other condition information items ...\n\nGET DIAGNOSTICS can obtain either statement or condition information,\nbut not both in the same statement:\n\no To obtain statement information, retrieve the desired statement items\n  into target variables. This instance of GET DIAGNOSTICS assigns the\n  number of available conditions and the rows-affected count to the\n  user variables @p1 and @p2:\n\nGET DIAGNOSTICS @p1 = NUMBER, @p2 = ROW_COUNT;\n\no To obtain condition information, specify the condition number and\n  retrieve the desired condition items into target variables. This\n  instance of GET DIAGNOSTICS assigns the SQLSTATE value and error\n  message to the user variables @p3 and @p4:\n\nGET DIAGNOSTICS CONDITION 1\n  @p3 = RETURNED_SQLSTATE, @p4 = MESSAGE_TEXT;\n\nThe retrieval list specifies one or more target = item_name\nassignments, separated by commas. Each assignment names a target\nvariable and either a statement_information_item_name or\ncondition_information_item_name designator, depending on whether the\nstatement retrieves statement or condition information.\n\nValid target designators for storing item information can be stored\nprocedure or function parameters, stored program local variables\ndeclared with DECLARE, or user-defined variables.\n\nValid condition_number designators can be stored procedure or function\nparameters, stored program local variables declared with DECLARE,\nuser-defined variables, system variables, or literals. A character\nliteral may include a _charset introducer. A warning occurs if the\ncondition number is not in the range from 1 to the number of condition\nareas that have information. In this case, the warning is added to the\ndiagnostics area without clearing it.\n\nCurrently, when a condition occurs, MySQL does not populate all\ncondition items recognized by GET DIAGNOSTICS. For example:\n\nmysql> GET DIAGNOSTICS CONDITION 1\n    ->   @p5 = SCHEMA_NAME, @p6 = TABLE_NAME;\nmysql> SELECT @p5, @p6;\n+------+------+\n| @p5  | @p6  |\n+------+------+\n|      |      |\n+------+------+\n\nIn standard SQL, if there are multiple conditions, the first condition\nrelates to the SQLSTATE value returned for the previous SQL statement.\nIn MySQL, this is not guaranteed. To get the main error, you cannot do\nthis:\n\nGET DIAGNOSTICS CONDITION 1 @errno = MYSQL_ERRNO;\n\nInstead, retrieve the condition count first, then use it to specify\nwhich condition number to inspect:\n\nGET DIAGNOSTICS @cno = NUMBER;\nGET DIAGNOSTICS CONDITION @cno @errno = MYSQL_ERRNO;\n\nFor information about permissible statement and condition information\nitems, and which ones are populated when a condition occurs, see\nhttp://dev.mysql.com/doc/refman/5.6/en/diagnostics-area.html#diagnostic\ns-area-information-items.\n\nHere is an example that uses GET DIAGNOSTICS and an exception handler\nin stored procedure context to assess the outcome of an insert\noperation. If the insert was successful, the procedure uses GET\nDIAGNOSTICS to get the rows-affected count. This shows that you can use\nGET DIAGNOSTICS multiple times to retrieve information about a\nstatement as long as the diagnostics area has not been cleared.\n\nCREATE PROCEDURE do_insert(value INT)\nBEGIN\n  -- Declare variables to hold diagnostics area information\n  DECLARE code CHAR(5) DEFAULT \'00000\';\n  DECLARE msg TEXT;\n  DECLARE rows INT;\n  DECLARE result TEXT;\n  -- Declare exception handler for failed insert\n  DECLARE CONTINUE HANDLER FOR SQLEXCEPTION\n    BEGIN\n      GET DIAGNOSTICS CONDITION 1\n        code = RETURNED_SQLSTATE, msg = MESSAGE_TEXT;\n    END;\n\n  -- Perform the insert\n  INSERT INTO t1 (int_col) VALUES(value);\n  -- Check whether the insert was successful\n  IF code = \'00000\' THEN\n    GET DIAGNOSTICS rows = ROW_COUNT;\n    SET result = CONCAT(\'insert succeeded, row count = \',rows);\n  ELSE\n    SET result = CONCAT(\'insert failed, error = \',code,\', message = \',msg);\n  END IF;\n  -- Say what happened\n  SELECT result;\nEND;\n\nSuppose that t1.int_col is an integer column that is declared as NOT\nNULL. The procedure produces these results when invoked to insert\nnon-NULL and NULL values:\n\nmysql> CALL do_insert(1);\n+---------------------------------+\n| result                          |\n+---------------------------------+\n| insert succeeded, row count = 1 |\n+---------------------------------+\n\nmysql> CALL do_insert(NULL);\n+-------------------------------------------------------------------------+\n| result                                                                  |\n+-------------------------------------------------------------------------+\n| insert failed, error = 23000, message = Column \'int_col\' cannot be null |\n+-------------------------------------------------------------------------+\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/get-diagnostics.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/get-diagnostics.html'),(172,'NOT REGEXP',38,'Syntax:\nexpr NOT REGEXP pat, expr NOT RLIKE pat\n\nThis is the same as NOT (expr REGEXP pat).\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/regexp.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/regexp.html'),(173,'LEAVE',24,'Syntax:\nLEAVE label\n\nThis statement is used to exit the flow control construct that has the\ngiven label. If the label is for the outermost stored program block,\nLEAVE exits the program.\n\nLEAVE can be used within BEGIN ... END or loop constructs (LOOP,\nREPEAT, WHILE).\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/leave.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/leave.html'),(174,'NOT IN',19,'Syntax:\nexpr NOT IN (value,...)\n\nThis is the same as NOT (expr IN (value,...)).\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/comparison-operators.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/comparison-operators.html'),(175,'&&',15,'Syntax:\nAND, &&\n\nLogical AND. Evaluates to 1 if all operands are nonzero and not NULL,\nto 0 if one or more operands are 0, otherwise NULL is returned.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/logical-operators.html\n\n','mysql> SELECT 1 && 1;\n        -> 1\nmysql> SELECT 1 && 0;\n        -> 0\nmysql> SELECT 1 && NULL;\n        -> NULL\nmysql> SELECT 0 && NULL;\n        -> 0\nmysql> SELECT NULL && 0;\n        -> 0\n','http://dev.mysql.com/doc/refman/5.6/en/logical-operators.html'),(176,'X',11,'X(p)\n\nReturns the X-coordinate value for the Point object p as a\ndouble-precision number.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/geometry-property-functions.html\n\n','mysql> SELECT X(POINT(56.7, 53.34));\n+-----------------------+\n| X(POINT(56.7, 53.34)) |\n+-----------------------+\n|                  56.7 |\n+-----------------------+\n','http://dev.mysql.com/doc/refman/5.6/en/geometry-property-functions.html'),(177,'FOUND_ROWS',17,'Syntax:\nFOUND_ROWS()\n\nA SELECT statement may include a LIMIT clause to restrict the number of\nrows the server returns to the client. In some cases, it is desirable\nto know how many rows the statement would have returned without the\nLIMIT, but without running the statement again. To obtain this row\ncount, include a SQL_CALC_FOUND_ROWS option in the SELECT statement,\nand then invoke FOUND_ROWS() afterward:\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/information-functions.html\n\n','mysql> SELECT SQL_CALC_FOUND_ROWS * FROM tbl_name\n    -> WHERE id > 100 LIMIT 10;\nmysql> SELECT FOUND_ROWS();\n','http://dev.mysql.com/doc/refman/5.6/en/information-functions.html'),(178,'CROSSES',31,'Crosses(g1,g2)\n\nReturns 1 if g1 spatially crosses g2. Returns NULL if g1 is a Polygon\nor a MultiPolygon, or if g2 is a Point or a MultiPoint. Otherwise,\nreturns 0.\n\nThe term spatially crosses denotes a spatial relation between two given\ngeometries that has the following properties:\n\no The two geometries intersect\n\no Their intersection results in a geometry that has a dimension that is\n  one less than the maximum dimension of the two given geometries\n\no Their intersection is not equal to either of the two given geometries\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/functions-for-testing-spatial-relations-between-geometric-objects.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/functions-for-testing-spatial-relations-between-geometric-objects.html'),(179,'BIT_XOR',16,'Syntax:\nBIT_XOR(expr)\n\nReturns the bitwise XOR of all bits in expr. The calculation is\nperformed with 64-bit (BIGINT) precision.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/group-by-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/group-by-functions.html'),(180,'FLUSH',27,'Syntax:\nFLUSH [NO_WRITE_TO_BINLOG | LOCAL]\n    flush_option [, flush_option] ...\n\nThe FLUSH statement has several variant forms that clear or reload\nvarious internal caches, flush tables, or acquire locks. To execute\nFLUSH, you must have the RELOAD privilege. Specific flush options might\nrequire additional privileges, as described later.\n\nBy default, the server writes FLUSH statements to the binary log so\nthat they replicate to replication slaves. To suppress logging, specify\nthe optional NO_WRITE_TO_BINLOG keyword or its alias LOCAL.\n\n*Note*: FLUSH LOGS, FLUSH TABLES WITH READ LOCK (with or without a\ntable list), and FLUSH TABLES tbl_name ... FOR EXPORT are not written\nto the binary log in any case because they would cause problems if\nreplicated to a slave.\n\nSending a SIGHUP signal to the server causes several flush operations\nto occur that are similar to various forms of the FLUSH statement. See\nhttp://dev.mysql.com/doc/refman/5.6/en/server-signal-response.html.\n\nThe FLUSH statement causes an implicit commit. See\nhttp://dev.mysql.com/doc/refman/5.6/en/implicit-commit.html.\n\nThe RESET statement is similar to FLUSH. See [HELP RESET], for\ninformation about using the RESET statement with replication.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/flush.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/flush.html'),(181,'BEGIN END',24,'Syntax:\n[begin_label:] BEGIN\n    [statement_list]\nEND [end_label]\n\nBEGIN ... END syntax is used for writing compound statements, which can\nappear within stored programs (stored procedures and functions,\ntriggers, and events). A compound statement can contain multiple\nstatements, enclosed by the BEGIN and END keywords. statement_list\nrepresents a list of one or more statements, each terminated by a\nsemicolon (;) statement delimiter. The statement_list itself is\noptional, so the empty compound statement (BEGIN END) is legal.\n\nBEGIN ... END blocks can be nested.\n\nUse of multiple statements requires that a client is able to send\nstatement strings containing the ; statement delimiter. In the mysql\ncommand-line client, this is handled with the delimiter command.\nChanging the ; end-of-statement delimiter (for example, to //) permit ;\nto be used in a program body. For an example, see\nhttp://dev.mysql.com/doc/refman/5.6/en/stored-programs-defining.html.\n\nA BEGIN ... END block can be labeled. See [HELP labels].\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/begin-end.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/begin-end.html'),(182,'SHOW PROCEDURE STATUS',27,'Syntax:\nSHOW PROCEDURE STATUS\n    [LIKE \'pattern\' | WHERE expr]\n\nThis statement is a MySQL extension. It returns characteristics of a\nstored procedure, such as the database, name, type, creator, creation\nand modification dates, and character set information. A similar\nstatement, SHOW FUNCTION STATUS, displays information about stored\nfunctions (see [HELP SHOW FUNCTION STATUS]).\n\nThe LIKE clause, if present, indicates which procedure or function\nnames to match. The WHERE clause can be given to select rows using more\ngeneral conditions, as discussed in\nhttp://dev.mysql.com/doc/refman/5.6/en/extended-show.html.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/show-procedure-status.html\n\n','mysql> SHOW PROCEDURE STATUS LIKE \'sp1\'\\G\n*************************** 1. row ***************************\n                  Db: test\n                Name: sp1\n                Type: PROCEDURE\n             Definer: testuser@localhost\n            Modified: 2004-08-03 15:29:37\n             Created: 2004-08-03 15:29:37\n       Security_type: DEFINER\n             Comment:\ncharacter_set_client: latin1\ncollation_connection: latin1_swedish_ci\n  Database Collation: latin1_swedish_ci\n','http://dev.mysql.com/doc/refman/5.6/en/show-procedure-status.html'),(183,'STDDEV_POP',16,'Syntax:\nSTDDEV_POP(expr)\n\nReturns the population standard deviation of expr (the square root of\nVAR_POP()). You can also use STD() or STDDEV(), which are equivalent\nbut not standard SQL.\n\nSTDDEV_POP() returns NULL if there were no matching rows.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/group-by-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/group-by-functions.html'),(184,'SHOW CHARACTER SET',27,'Syntax:\nSHOW CHARACTER SET\n    [LIKE \'pattern\' | WHERE expr]\n\nThe SHOW CHARACTER SET statement shows all available character sets.\nThe LIKE clause, if present, indicates which character set names to\nmatch. The WHERE clause can be given to select rows using more general\nconditions, as discussed in\nhttp://dev.mysql.com/doc/refman/5.6/en/extended-show.html. For example:\n\nmysql> SHOW CHARACTER SET LIKE \'latin%\';\n+---------+-----------------------------+-------------------+--------+\n| Charset | Description                 | Default collation | Maxlen |\n+---------+-----------------------------+-------------------+--------+\n| latin1  | cp1252 West European        | latin1_swedish_ci |      1 |\n| latin2  | ISO 8859-2 Central European | latin2_general_ci |      1 |\n| latin5  | ISO 8859-9 Turkish          | latin5_turkish_ci |      1 |\n| latin7  | ISO 8859-13 Baltic          | latin7_general_ci |      1 |\n+---------+-----------------------------+-------------------+--------+\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/show-character-set.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/show-character-set.html'),(185,'INTERSECTS',31,'Intersects(g1,g2)\n\nReturns 1 or 0 to indicate whether g1 spatially intersects g2.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/functions-for-testing-spatial-relations-between-geometric-objects.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/functions-for-testing-spatial-relations-between-geometric-objects.html'),(186,'LOOP',24,'Syntax:\n[begin_label:] LOOP\n    statement_list\nEND LOOP [end_label]\n\nLOOP implements a simple loop construct, enabling repeated execution of\nthe statement list, which consists of one or more statements, each\nterminated by a semicolon (;) statement delimiter. The statements\nwithin the loop are repeated until the loop is terminated. Usually,\nthis is accomplished with a LEAVE statement. Within a stored function,\nRETURN can also be used, which exits the function entirely.\n\nNeglecting to include a loop-termination statement results in an\ninfinite loop.\n\nA LOOP statement can be labeled. For the rules regarding label use, see\n[HELP labels].\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/loop.html\n\n','CREATE PROCEDURE doiterate(p1 INT)\nBEGIN\n  label1: LOOP\n    SET p1 = p1 + 1;\n    IF p1 < 10 THEN\n      ITERATE label1;\n    END IF;\n    LEAVE label1;\n  END LOOP label1;\n  SET @x = p1;\nEND;\n','http://dev.mysql.com/doc/refman/5.6/en/loop.html'),(187,'GREATEST',19,'Syntax:\nGREATEST(value1,value2,...)\n\nWith two or more arguments, returns the largest (maximum-valued)\nargument. The arguments are compared using the same rules as for\nLEAST().\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/comparison-operators.html\n\n','mysql> SELECT GREATEST(2,0);\n        -> 2\nmysql> SELECT GREATEST(34.0,3.0,5.0,767.0);\n        -> 767.0\nmysql> SELECT GREATEST(\'B\',\'A\',\'C\');\n        -> \'C\'\n','http://dev.mysql.com/doc/refman/5.6/en/comparison-operators.html'),(188,'ST_CONTAINS',31,'ST_Contains(g1,g2)\n\nReturns 1 or 0 to indicate whether g1 completely contains g2. This\ntests the opposite relationship as ST_Within().\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/functions-for-testing-spatial-relations-between-geometric-objects.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/functions-for-testing-spatial-relations-between-geometric-objects.html'),(189,'BIT_AND',16,'Syntax:\nBIT_AND(expr)\n\nReturns the bitwise AND of all bits in expr. The calculation is\nperformed with 64-bit (BIGINT) precision.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/group-by-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/group-by-functions.html'),(190,'SECOND',32,'Syntax:\nSECOND(time)\n\nReturns the second for time, in the range 0 to 59.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html\n\n','mysql> SELECT SECOND(\'10:05:03\');\n        -> 3\n','http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html'),(191,'MBRCONTAINS',6,'MBRContains(g1,g2)\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangle of g1\ncontains the Minimum Bounding Rectangle of g2. This tests the opposite\nrelationship as MBRWithin().\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/functions-for-testing-spatial-relations-between-geometric-objects.html\n\n','mysql> SET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nmysql> SET @g2 = GeomFromText(\'Point(1 1)\');\nmysql> SELECT MBRContains(@g1,@g2), MBRContains(@g2,@g1);\n----------------------+----------------------+\n| MBRContains(@g1,@g2) | MBRContains(@g2,@g1) |\n+----------------------+----------------------+\n|                    1 |                    0 |\n+----------------------+----------------------+\n','http://dev.mysql.com/doc/refman/5.6/en/functions-for-testing-spatial-relations-between-geometric-objects.html'),(192,'COT',4,'Syntax:\nCOT(X)\n\nReturns the cotangent of X.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/mathematical-functions.html\n\n','mysql> SELECT COT(12);\n        -> -1.5726734063977\nmysql> SELECT COT(0);\n        -> NULL\n','http://dev.mysql.com/doc/refman/5.6/en/mathematical-functions.html'),(193,'SHOW CREATE EVENT',27,'Syntax:\nSHOW CREATE EVENT event_name\n\nThis statement displays the CREATE EVENT statement needed to re-create\na given event. It requires the EVENT privilege for the database from\nwhich the event is to be shown. For example (using the same event\ne_daily defined and then altered in [HELP SHOW EVENTS]):\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/show-create-event.html\n\n','mysql> SHOW CREATE EVENT test.e_daily\\G\n*************************** 1. row ***************************\n               Event: e_daily\n            sql_mode:\n           time_zone: SYSTEM\n        Create Event: CREATE EVENT `e_daily`\n                        ON SCHEDULE EVERY 1 DAY\n                        STARTS CURRENT_TIMESTAMP + INTERVAL 6 HOUR\n                        ON COMPLETION NOT PRESERVE\n                        ENABLE\n                        COMMENT \'Saves total number of sessions then\n                                clears the table each day\'\n                        DO BEGIN\n                          INSERT INTO site_activity.totals (time, total)\n                            SELECT CURRENT_TIMESTAMP, COUNT(*)\n                            FROM site_activity.sessions;\n                          DELETE FROM site_activity.sessions;\n                        END\ncharacter_set_client: latin1\ncollation_connection: latin1_swedish_ci\n  Database Collation: latin1_swedish_ci\n','http://dev.mysql.com/doc/refman/5.6/en/show-create-event.html'),(194,'LOAD_FILE',38,'Syntax:\nLOAD_FILE(file_name)\n\nReads the file and returns the file contents as a string. To use this\nfunction, the file must be located on the server host, you must specify\nthe full path name to the file, and you must have the FILE privilege.\nThe file must be readable by all and its size less than\nmax_allowed_packet bytes. If the secure_file_priv system variable is\nset to a nonempty directory name, the file to be loaded must be located\nin that directory.\n\nIf the file does not exist or cannot be read because one of the\npreceding conditions is not satisfied, the function returns NULL.\n\nThe character_set_filesystem system variable controls interpretation of\nfile names that are given as literal strings.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/string-functions.html\n\n','mysql> UPDATE t\n            SET blob_col=LOAD_FILE(\'/tmp/picture\')\n            WHERE id=1;\n','http://dev.mysql.com/doc/refman/5.6/en/string-functions.html'),(195,'POINTFROMTEXT',3,'PointFromText(wkt[,srid])\n\nConstructs a POINT value using its WKT representation and SRID.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/creating-spatial-values.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/creating-spatial-values.html'),(196,'DATE_FORMAT',32,'Syntax:\nDATE_FORMAT(date,format)\n\nFormats the date value according to the format string.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html\n\n','mysql> SELECT DATE_FORMAT(\'2009-10-04 22:23:00\', \'%W %M %Y\');\n        -> \'Sunday October 2009\'\nmysql> SELECT DATE_FORMAT(\'2007-10-04 22:23:00\', \'%H:%i:%s\');\n        -> \'22:23:00\'\nmysql> SELECT DATE_FORMAT(\'1900-10-04 22:23:00\',\n    ->                 \'%D %y %a %d %m %b %j\');\n        -> \'4th 00 Thu 04 10 Oct 277\'\nmysql> SELECT DATE_FORMAT(\'1997-10-04 22:23:00\',\n    ->                 \'%H %k %I %r %T %S %w\');\n        -> \'22 22 10 10:23:00 PM 22:23:00 00 6\'\nmysql> SELECT DATE_FORMAT(\'1999-01-01\', \'%X %V\');\n        -> \'1998 52\'\nmysql> SELECT DATE_FORMAT(\'2006-06-00\', \'%d\');\n        -> \'00\'\n','http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html'),(197,'YEAR',32,'Syntax:\nYEAR(date)\n\nReturns the year for date, in the range 1000 to 9999, or 0 for the\n\"zero\" date.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html\n\n','mysql> SELECT YEAR(\'1987-01-01\');\n        -> 1987\n','http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html'),(198,'IS NULL',19,'Syntax:\nIS NULL\n\nTests whether a value is NULL.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/comparison-operators.html\n\n','mysql> SELECT 1 IS NULL, 0 IS NULL, NULL IS NULL;\n        -> 0, 0, 1\n','http://dev.mysql.com/doc/refman/5.6/en/comparison-operators.html'),(199,'ALTER SERVER',40,'Syntax:\nALTER SERVER  server_name\n    OPTIONS (option [, option] ...)\n\nAlters the server information for server_name, adjusting any of the\noptions permitted in the CREATE SERVER statement. The corresponding\nfields in the mysql.servers table are updated accordingly. This\nstatement requires the SUPER privilege.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/alter-server.html\n\n','ALTER SERVER s OPTIONS (USER \'sally\');\n','http://dev.mysql.com/doc/refman/5.6/en/alter-server.html'),(200,'RESIGNAL',24,'Syntax:\nRESIGNAL [condition_value]\n    [SET signal_information_item\n    [, signal_information_item] ...]\n\ncondition_value:\n    SQLSTATE [VALUE] sqlstate_value\n  | condition_name\n\nsignal_information_item:\n    condition_information_item_name = simple_value_specification\n\ncondition_information_item_name:\n    CLASS_ORIGIN\n  | SUBCLASS_ORIGIN\n  | MESSAGE_TEXT\n  | MYSQL_ERRNO\n  | CONSTRAINT_CATALOG\n  | CONSTRAINT_SCHEMA\n  | CONSTRAINT_NAME\n  | CATALOG_NAME\n  | SCHEMA_NAME\n  | TABLE_NAME\n  | COLUMN_NAME\n  | CURSOR_NAME\n\ncondition_name, simple_value_specification:\n    (see following discussion)\n\nRESIGNAL passes on the error condition information that is available\nduring execution of a condition handler within a compound statement\ninside a stored procedure or function, trigger, or event. RESIGNAL may\nchange some or all information before passing it on. RESIGNAL is\nrelated to SIGNAL, but instead of originating a condition as SIGNAL\ndoes, RESIGNAL relays existing condition information, possibly after\nmodifying it.\n\nRESIGNAL makes it possible to both handle an error and return the error\ninformation. Otherwise, by executing an SQL statement within the\nhandler, information that caused the handler\'s activation is destroyed.\nRESIGNAL also can make some procedures shorter if a given handler can\nhandle part of a situation, then pass the condition \"up the line\" to\nanother handler.\n\nNo special privileges are required to execute the RESIGNAL statement.\n\nAll forms of RESIGNAL require that the current context be a condition\nhandler. Otherwise, RESIGNAL is illegal and a RESIGNAL when handler not\nactive error occurs.\n\nTo retrieve information from the diagnostics area, use the GET\nDIAGNOSTICS statement (see [HELP GET DIAGNOSTICS]). For information\nabout the diagnostics area, see\nhttp://dev.mysql.com/doc/refman/5.6/en/diagnostics-area.html.\n\nFor condition_value and signal_information_item, the definitions and\nrules are the same for RESIGNAL as for SIGNAL. For example, the\ncondition_value can be an SQLSTATE value, and the value can indicate\nerrors, warnings, or \"not found.\" For additional information, see [HELP\nSIGNAL].\n\nThe RESIGNAL statement takes condition_value and SET clauses, both of\nwhich are optional. This leads to several possible uses:\n\no RESIGNAL alone:\n\nRESIGNAL;\n\no RESIGNAL with new signal information:\n\nRESIGNAL SET signal_information_item [, signal_information_item] ...;\n\no RESIGNAL with a condition value and possibly new signal information:\n\nRESIGNAL condition_value\n    [SET signal_information_item [, signal_information_item] ...];\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/resignal.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/resignal.html'),(201,'TIME FUNCTION',32,'Syntax:\nTIME(expr)\n\nExtracts the time part of the time or datetime expression expr and\nreturns it as a string.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html\n\n','mysql> SELECT TIME(\'2003-12-31 01:02:03\');\n        -> \'01:02:03\'\nmysql> SELECT TIME(\'2003-12-31 01:02:03.000123\');\n        -> \'01:02:03.000123\'\n','http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html'),(202,'DATE_ADD',32,'Syntax:\nDATE_ADD(date,INTERVAL expr unit), DATE_SUB(date,INTERVAL expr unit)\n\nThese functions perform date arithmetic. The date argument specifies\nthe starting date or datetime value. expr is an expression specifying\nthe interval value to be added or subtracted from the starting date.\nexpr is a string; it may start with a \"-\" for negative intervals. unit\nis a keyword indicating the units in which the expression should be\ninterpreted.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html\n\n','mysql> SELECT \'2008-12-31 23:59:59\' + INTERVAL 1 SECOND;\n        -> \'2009-01-01 00:00:00\'\nmysql> SELECT INTERVAL 1 DAY + \'2008-12-31\';\n        -> \'2009-01-01\'\nmysql> SELECT \'2005-01-01\' - INTERVAL 1 SECOND;\n        -> \'2004-12-31 23:59:59\'\nmysql> SELECT DATE_ADD(\'2000-12-31 23:59:59\',\n    ->                 INTERVAL 1 SECOND);\n        -> \'2001-01-01 00:00:00\'\nmysql> SELECT DATE_ADD(\'2010-12-31 23:59:59\',\n    ->                 INTERVAL 1 DAY);\n        -> \'2011-01-01 23:59:59\'\nmysql> SELECT DATE_ADD(\'2100-12-31 23:59:59\',\n    ->                 INTERVAL \'1:1\' MINUTE_SECOND);\n        -> \'2101-01-01 00:01:00\'\nmysql> SELECT DATE_SUB(\'2005-01-01 00:00:00\',\n    ->                 INTERVAL \'1 1:1:1\' DAY_SECOND);\n        -> \'2004-12-30 22:58:59\'\nmysql> SELECT DATE_ADD(\'1900-01-01 00:00:00\',\n    ->                 INTERVAL \'-1 10\' DAY_HOUR);\n        -> \'1899-12-30 14:00:00\'\nmysql> SELECT DATE_SUB(\'1998-01-02\', INTERVAL 31 DAY);\n        -> \'1997-12-02\'\nmysql> SELECT DATE_ADD(\'1992-12-31 23:59:59.000002\',\n    ->            INTERVAL \'1.999999\' SECOND_MICROSECOND);\n        -> \'1993-01-01 00:00:01.000001\'\n','http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html'),(203,'LIKE',38,'Syntax:\nexpr LIKE pat [ESCAPE \'escape_char\']\n\nPattern matching using SQL simple regular expression comparison.\nReturns 1 (TRUE) or 0 (FALSE). If either expr or pat is NULL, the\nresult is NULL.\n\nThe pattern need not be a literal string. For example, it can be\nspecified as a string expression or table column.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/string-comparison-functions.html\n\n','mysql> SELECT \'David!\' LIKE \'David_\';\n        -> 1\nmysql> SELECT \'David!\' LIKE \'%D%v%\';\n        -> 1\n','http://dev.mysql.com/doc/refman/5.6/en/string-comparison-functions.html'),(204,'MULTIPOINT',25,'MultiPoint(pt1,pt2,...)\n\nConstructs a MultiPoint value using Point or WKB Point arguments.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/creating-spatial-values.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/creating-spatial-values.html'),(205,'>>',20,'Syntax:\n>>\n\nShifts a longlong (BIGINT) number to the right.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/bit-functions.html\n\n','mysql> SELECT 4 >> 2;\n        -> 1\n','http://dev.mysql.com/doc/refman/5.6/en/bit-functions.html'),(206,'FETCH',24,'Syntax:\nFETCH [[NEXT] FROM] cursor_name INTO var_name [, var_name] ...\n\nThis statement fetches the next row for the SELECT statement associated\nwith the specified cursor (which must be open), and advances the cursor\npointer. If a row exists, the fetched columns are stored in the named\nvariables. The number of columns retrieved by the SELECT statement must\nmatch the number of output variables specified in the FETCH statement.\n\nIf no more rows are available, a No Data condition occurs with SQLSTATE\nvalue \'02000\'. To detect this condition, you can set up a handler for\nit (or for a NOT FOUND condition). For an example, see\nhttp://dev.mysql.com/doc/refman/5.6/en/cursors.html.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/fetch.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/fetch.html'),(207,'TRUE FALSE',30,'The constants TRUE and FALSE evaluate to 1 and 0, respectively. The\nconstant names can be written in any lettercase.\n\nmysql> SELECT TRUE, true, FALSE, false;\n        -> 1, 1, 0, 0\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/boolean-literals.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/boolean-literals.html'),(208,'MBRWITHIN',6,'MBRWithin(g1,g2)\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangle of g1\nis within the Minimum Bounding Rectangle of g2. This tests the opposite\nrelationship as MBRContains().\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/functions-for-testing-spatial-relations-between-geometric-objects.html\n\n','mysql> SET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nmysql> SET @g2 = GeomFromText(\'Polygon((0 0,0 5,5 5,5 0,0 0))\');\nmysql> SELECT MBRWithin(@g1,@g2), MBRWithin(@g2,@g1);\n+--------------------+--------------------+\n| MBRWithin(@g1,@g2) | MBRWithin(@g2,@g1) |\n+--------------------+--------------------+\n|                  1 |                  0 |\n+--------------------+--------------------+\n','http://dev.mysql.com/doc/refman/5.6/en/functions-for-testing-spatial-relations-between-geometric-objects.html'),(209,'SESSION_USER',17,'Syntax:\nSESSION_USER()\n\nSESSION_USER() is a synonym for USER().\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/information-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/information-functions.html'),(210,'SHOW CREATE FUNCTION',27,'Syntax:\nSHOW CREATE FUNCTION func_name\n\nThis statement is similar to SHOW CREATE PROCEDURE but for stored\nfunctions. See [HELP SHOW CREATE PROCEDURE].\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/show-create-function.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/show-create-function.html'),(211,'STR_TO_DATE',32,'Syntax:\nSTR_TO_DATE(str,format)\n\nThis is the inverse of the DATE_FORMAT() function. It takes a string\nstr and a format string format. STR_TO_DATE() returns a DATETIME value\nif the format string contains both date and time parts, or a DATE or\nTIME value if the string contains only date or time parts. If the date,\ntime, or datetime value extracted from str is illegal, STR_TO_DATE()\nreturns NULL and produces a warning.\n\nThe server scans str attempting to match format to it. The format\nstring can contain literal characters and format specifiers beginning\nwith %. Literal characters in format must match literally in str.\nFormat specifiers in format must match a date or time part in str. For\nthe specifiers that can be used in format, see the DATE_FORMAT()\nfunction description.\n\nmysql> SELECT STR_TO_DATE(\'01,5,2013\',\'%d,%m,%Y\');\n        -> \'2013-05-01\'\nmysql> SELECT STR_TO_DATE(\'May 1, 2013\',\'%M %d,%Y\');\n        -> \'2013-05-01\'\n\nScanning starts at the beginning of str and fails if format is found\nnot to match. Extra characters at the end of str are ignored.\n\nmysql> SELECT STR_TO_DATE(\'a09:30:17\',\'a%h:%i:%s\');\n        -> \'09:30:17\'\nmysql> SELECT STR_TO_DATE(\'a09:30:17\',\'%h:%i:%s\');\n        -> NULL\nmysql> SELECT STR_TO_DATE(\'09:30:17a\',\'%h:%i:%s\');\n        -> \'09:30:17\'\n\nUnspecified date or time parts have a value of 0, so incompletely\nspecified values in str produce a result with some or all parts set to\n0:\n\nmysql> SELECT STR_TO_DATE(\'abc\',\'abc\');\n        -> \'0000-00-00\'\nmysql> SELECT STR_TO_DATE(\'9\',\'%m\');\n        -> \'0000-09-00\'\nmysql> SELECT STR_TO_DATE(\'9\',\'%s\');\n        -> \'00:00:09\'\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html'),(212,'Y',11,'Y(p)\n\nReturns the Y-coordinate value for the Point object p as a\ndouble-precision number.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/geometry-property-functions.html\n\n','mysql> SELECT Y(POINT(56.7, 53.34));\n+-----------------------+\n| Y(POINT(56.7, 53.34)) |\n+-----------------------+\n|                 53.34 |\n+-----------------------+\n','http://dev.mysql.com/doc/refman/5.6/en/geometry-property-functions.html'),(213,'CHECKSUM TABLE',21,'Syntax:\nCHECKSUM TABLE tbl_name [, tbl_name] ... [ QUICK | EXTENDED ]\n\nCHECKSUM TABLE reports a checksum for the contents of a table. You can\nuse this statement to verify that the contents are the same before and\nafter a backup, rollback, or other operation that is intended to put\nthe data back to a known state. This statement requires the SELECT\nprivilege for the table.\n\nPerformance Considerations\n\nBy default, the entire table is read row by row and the checksum is\ncalculated. For large tables, this could take a long time, thus you\nwould only perform this operation occasionally. This row-by-row\ncalculation is what you get with the EXTENDED clause, with InnoDB and\nall other storage engines other than MyISAM, and with MyISAM tables not\ncreated with the CHECKSUM=1 clause.\n\nFor MyISAM tables created with the CHECKSUM=1 clause, CHECKSUM TABLE or\nCHECKSUM TABLE ... QUICK returns the \"live\" table checksum that can be\nreturned very fast. If the table does not meet all these conditions,\nthe QUICK method returns NULL. See [HELP CREATE TABLE] for the syntax\nof the CHECKSUM clause.\n\nFor a nonexistent table, CHECKSUM TABLE returns NULL and generates a\nwarning.\n\nPrior to MySQL 5.6.4, CHECKSUM TABLE returned 0 for partitioned tables\nunless the EXTENDED option was used. (Bug #11933226, Bug #60681)\n\nThe checksum value depends on the table row format. If the row format\nchanges, the checksum also changes. For example, the storage format for\nVARCHAR changed between MySQL 4.1 and 5.0, so if a 4.1 table is\nupgraded to MySQL 5.0, the checksum value may change.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/checksum-table.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/checksum-table.html'),(214,'NUMINTERIORRINGS',2,'NumInteriorRings(poly)\n\nReturns the number of interior rings in the Polygon value poly.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/geometry-property-functions.html\n\n','mysql> SET @poly =\n    -> \'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))\';\nmysql> SELECT NumInteriorRings(GeomFromText(@poly));\n+---------------------------------------+\n| NumInteriorRings(GeomFromText(@poly)) |\n+---------------------------------------+\n|                                     1 |\n+---------------------------------------+\n','http://dev.mysql.com/doc/refman/5.6/en/geometry-property-functions.html'),(215,'INTERIORRINGN',2,'InteriorRingN(poly,N)\n\nReturns the N-th interior ring for the Polygon value poly as a\nLineString. Rings are numbered beginning with 1.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/geometry-property-functions.html\n\n','mysql> SET @poly =\n    -> \'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))\';\nmysql> SELECT AsText(InteriorRingN(GeomFromText(@poly),1));\n+----------------------------------------------+\n| AsText(InteriorRingN(GeomFromText(@poly),1)) |\n+----------------------------------------------+\n| LINESTRING(1 1,1 2,2 2,2 1,1 1)              |\n+----------------------------------------------+\n','http://dev.mysql.com/doc/refman/5.6/en/geometry-property-functions.html'),(216,'UTC_TIME',32,'Syntax:\nUTC_TIME, UTC_TIME([fsp])\n\nReturns the current UTC time as a value in \'HH:MM:SS\' or HHMMSS format,\ndepending on whether the function is used in a string or numeric\ncontext.\n\nAs of MySQL 5.6.4, if the fsp argument is given to specify a fractional\nseconds precision from 0 to 6, the return value includes a fractional\nseconds part of that many digits. Before 5.6.4, any argument is\nignored.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html\n\n','mysql> SELECT UTC_TIME(), UTC_TIME() + 0;\n        -> \'18:07:53\', 180753.000000\n','http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html'),(217,'IS_IPV4_COMPAT',14,'Syntax:\nIS_IPV4_COMPAT(expr)\n\nThis function takes an IPv6 address represented in numeric form as a\nbinary string, as returned by INET6_ATON(). It returns 1 if the\nargument is a valid IPv4-compatible IPv6 address, 0 otherwise.\nIPv4-compatible addresses have the form ::ipv4_address.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/miscellaneous-functions.html\n\n','mysql> SELECT IS_IPV4_COMPAT(INET6_ATON(\'::10.0.5.9\'));\n        -> 1\nmysql> SELECT IS_IPV4_COMPAT(INET6_ATON(\'::ffff:10.0.5.9\'));\n        -> 0\n','http://dev.mysql.com/doc/refman/5.6/en/miscellaneous-functions.html'),(218,'DROP FUNCTION',40,'The DROP FUNCTION statement is used to drop stored functions and\nuser-defined functions (UDFs):\n\no For information about dropping stored functions, see [HELP DROP\n  PROCEDURE].\n\no For information about dropping user-defined functions, see [HELP DROP\n  FUNCTION UDF].\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/drop-function.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/drop-function.html'),(219,'STDDEV',16,'Syntax:\nSTDDEV(expr)\n\nReturns the population standard deviation of expr. This function is\nprovided for compatibility with Oracle. The standard SQL function\nSTDDEV_POP() can be used instead.\n\nThis function returns NULL if there were no matching rows.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/group-by-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/group-by-functions.html'),(220,'PERIOD_ADD',32,'Syntax:\nPERIOD_ADD(P,N)\n\nAdds N months to period P (in the format YYMM or YYYYMM). Returns a\nvalue in the format YYYYMM. Note that the period argument P is not a\ndate value.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html\n\n','mysql> SELECT PERIOD_ADD(200801,2);\n        -> 200803\n','http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html'),(221,'RIGHT',38,'Syntax:\nRIGHT(str,len)\n\nReturns the rightmost len characters from the string str, or NULL if\nany argument is NULL.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/string-functions.html\n\n','mysql> SELECT RIGHT(\'foobarbar\', 4);\n        -> \'rbar\'\n','http://dev.mysql.com/doc/refman/5.6/en/string-functions.html'),(222,'DROP TABLESPACE',40,'Syntax:\nDROP TABLESPACE tablespace_name\n    ENGINE [=] engine_name\n\nThis statement drops a tablespace that was previously created using\nCREATE TABLESPACE (see [HELP CREATE TABLESPACE]).\n\n*Important*: The tablespace to be dropped must not contain any data\nfiles; in other words, before you can drop a tablespace, you must first\ndrop each of its data files using ALTER TABLESPACE ... DROP DATAFILE\n(see [HELP ALTER TABLESPACE]).\n\nThe ENGINE clause (required) specifies the storage engine used by the\ntablespace. Currently, the only accepted values for engine_name are NDB\nand NDBCLUSTER.\n\nDROP TABLESPACE is useful only with Disk Data storage for MySQL\nCluster. See\nhttp://dev.mysql.com/doc/refman/5.6/en/mysql-cluster-disk-data.html.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/drop-tablespace.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/drop-tablespace.html'),(223,'CHECK TABLE',21,'Syntax:\nCHECK TABLE tbl_name [, tbl_name] ... [option] ...\n\noption = {FOR UPGRADE | QUICK | FAST | MEDIUM | EXTENDED | CHANGED}\n\nCHECK TABLE checks a table or tables for errors. CHECK TABLE works for\nInnoDB, MyISAM, ARCHIVE, and CSV tables. For MyISAM tables, the key\nstatistics are updated as well.\n\nTo check a table, you must have some privilege for it.\n\nCHECK TABLE can also check views for problems, such as tables that are\nreferenced in the view definition that no longer exist.\n\nCHECK TABLE is supported for partitioned tables, and you can use ALTER\nTABLE ... CHECK PARTITION to check one or more partitions; for more\ninformation, see [HELP ALTER TABLE], and\nhttp://dev.mysql.com/doc/refman/5.6/en/partitioning-maintenance.html.\n\nIn MySQL 5.6.11 only, gtid_next must be set to AUTOMATIC before issuing\nthis statement. (Bug #16062608, Bug #16715809, Bug #69045)\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/check-table.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/check-table.html'),(224,'BIN',38,'Syntax:\nBIN(N)\n\nReturns a string representation of the binary value of N, where N is a\nlonglong (BIGINT) number. This is equivalent to CONV(N,10,2). Returns\nNULL if N is NULL.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/string-functions.html\n\n','mysql> SELECT BIN(12);\n        -> \'1100\'\n','http://dev.mysql.com/doc/refman/5.6/en/string-functions.html'),(225,'MULTILINESTRING',25,'MultiLineString(ls1,ls2,...)\n\nConstructs a MultiLineString value using LineString or WKB LineString\narguments.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/creating-spatial-values.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/creating-spatial-values.html'),(226,'SHOW RELAYLOG EVENTS',27,'Syntax:\nSHOW RELAYLOG EVENTS\n   [IN \'log_name\'] [FROM pos] [LIMIT [offset,] row_count]\n\nShows the events in the relay log of a replication slave. If you do not\nspecify \'log_name\', the first relay log is displayed. This statement\nhas no effect on the master.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/show-relaylog-events.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/show-relaylog-events.html'),(227,'MPOINTFROMTEXT',3,'MPointFromText(wkt[,srid]), MultiPointFromText(wkt[,srid])\n\nConstructs a MULTIPOINT value using its WKT representation and SRID.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/creating-spatial-values.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/creating-spatial-values.html'),(228,'SUBSTR',38,'Syntax:\nSUBSTR(str,pos), SUBSTR(str FROM pos), SUBSTR(str,pos,len), SUBSTR(str\nFROM pos FOR len)\n\nSUBSTR() is a synonym for SUBSTRING().\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/string-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/string-functions.html'),(229,'CHAR',23,'[NATIONAL] CHAR[(M)] [CHARACTER SET charset_name] [COLLATE\ncollation_name]\n\nA fixed-length string that is always right-padded with spaces to the\nspecified length when stored. M represents the column length in\ncharacters. The range of M is 0 to 255. If M is omitted, the length is\n1.\n\n*Note*: Trailing spaces are removed when CHAR values are retrieved\nunless the PAD_CHAR_TO_FULL_LENGTH SQL mode is enabled.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/string-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/string-type-overview.html'),(230,'COUNT DISTINCT',16,'Syntax:\nCOUNT(DISTINCT expr,[expr...])\n\nReturns a count of the number of rows with different non-NULL expr\nvalues.\n\nCOUNT(DISTINCT) returns 0 if there were no matching rows.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/group-by-functions.html\n\n','mysql> SELECT COUNT(DISTINCT results) FROM student;\n','http://dev.mysql.com/doc/refman/5.6/en/group-by-functions.html'),(231,'SHOW CREATE VIEW',27,'Syntax:\nSHOW CREATE VIEW view_name\n\nThis statement shows a CREATE VIEW statement that creates the given\nview.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/show-create-view.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/show-create-view.html'),(232,'INTERVAL',19,'Syntax:\nINTERVAL(N,N1,N2,N3,...)\n\nReturns 0 if N < N1, 1 if N < N2 and so on or -1 if N is NULL. All\narguments are treated as integers. It is required that N1 < N2 < N3 <\n... < Nn for this function to work correctly. This is because a binary\nsearch is used (very fast).\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/comparison-operators.html\n\n','mysql> SELECT INTERVAL(23, 1, 15, 17, 30, 44, 200);\n        -> 3\nmysql> SELECT INTERVAL(10, 1, 10, 100, 1000);\n        -> 2\nmysql> SELECT INTERVAL(22, 23, 30, 44, 200);\n        -> 0\n','http://dev.mysql.com/doc/refman/5.6/en/comparison-operators.html'),(233,'FROM_DAYS',32,'Syntax:\nFROM_DAYS(N)\n\nGiven a day number N, returns a DATE value.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html\n\n','mysql> SELECT FROM_DAYS(730669);\n        -> \'2007-07-03\'\n','http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html'),(234,'ALTER PROCEDURE',40,'Syntax:\nALTER PROCEDURE proc_name [characteristic ...]\n\ncharacteristic:\n    COMMENT \'string\'\n  | LANGUAGE SQL\n  | { CONTAINS SQL | NO SQL | READS SQL DATA | MODIFIES SQL DATA }\n  | SQL SECURITY { DEFINER | INVOKER }\n\nThis statement can be used to change the characteristics of a stored\nprocedure. More than one change may be specified in an ALTER PROCEDURE\nstatement. However, you cannot change the parameters or body of a\nstored procedure using this statement; to make such changes, you must\ndrop and re-create the procedure using DROP PROCEDURE and CREATE\nPROCEDURE.\n\nYou must have the ALTER ROUTINE privilege for the procedure. By\ndefault, that privilege is granted automatically to the procedure\ncreator. This behavior can be changed by disabling the\nautomatic_sp_privileges system variable. See\nhttp://dev.mysql.com/doc/refman/5.6/en/stored-routines-privileges.html.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/alter-procedure.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/alter-procedure.html'),(235,'BIT_COUNT',20,'Syntax:\nBIT_COUNT(N)\n\nReturns the number of bits that are set in the argument N.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/bit-functions.html\n\n','mysql> SELECT BIT_COUNT(29), BIT_COUNT(b\'101010\');\n        -> 4, 3\n','http://dev.mysql.com/doc/refman/5.6/en/bit-functions.html'),(236,'ST_WITHIN',31,'ST_Within(g1,g2)\n\nReturns 1 or 0 to indicate whether g1 is spatially within g2. This\ntests the opposite relationship as ST_Contains().\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/functions-for-testing-spatial-relations-between-geometric-objects.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/functions-for-testing-spatial-relations-between-geometric-objects.html'),(237,'ACOS',4,'Syntax:\nACOS(X)\n\nReturns the arc cosine of X, that is, the value whose cosine is X.\nReturns NULL if X is not in the range -1 to 1.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/mathematical-functions.html\n\n','mysql> SELECT ACOS(1);\n        -> 0\nmysql> SELECT ACOS(1.0001);\n        -> NULL\nmysql> SELECT ACOS(0);\n        -> 1.5707963267949\n','http://dev.mysql.com/doc/refman/5.6/en/mathematical-functions.html'),(238,'ISOLATION',8,'Syntax:\nSET [GLOBAL | SESSION] TRANSACTION\n    transaction_characteristic [, transaction_characteristic] ...\n\ntransaction_characteristic:\n    ISOLATION LEVEL level\n  | READ WRITE\n  | READ ONLY\n\nlevel:\n     REPEATABLE READ\n   | READ COMMITTED\n   | READ UNCOMMITTED\n   | SERIALIZABLE\n\nThis statement specifies transaction characteristics. It takes a list\nof one or more characteristic values separated by commas. These\ncharacteristics set the transaction isolation level or access mode. The\nisolation level is used for operations on InnoDB tables. The access\nmode may be specified as of MySQL 5.6.5 and indicates whether\ntransactions operate in read/write or read-only mode.\n\nIn addition, SET TRANSACTION can include an optional GLOBAL or SESSION\nkeyword to indicate the scope of the statement.\n\nScope of Transaction Characteristics\n\nYou can set transaction characteristics globally, for the current\nsession, or for the next transaction:\n\no With the GLOBAL keyword, the statement applies globally for all\n  subsequent sessions. Existing sessions are unaffected.\n\no With the SESSION keyword, the statement applies to all subsequent\n  transactions performed within the current session.\n\no Without any SESSION or GLOBAL keyword, the statement applies to the\n  next (not started) transaction performed within the current session.\n\nA global change to transaction characteristics requires the SUPER\nprivilege. Any session is free to change its session characteristics\n(even in the middle of a transaction), or the characteristics for its\nnext transaction.\n\nSET TRANSACTION without GLOBAL or SESSION is not permitted while there\nis an active transaction:\n\nmysql> START TRANSACTION;\nQuery OK, 0 rows affected (0.02 sec)\n\nmysql> SET TRANSACTION ISOLATION LEVEL SERIALIZABLE;\nERROR 1568 (25001): Transaction characteristics can\'t be changed\nwhile a transaction is in progress\n\nTo set the global default isolation level at server startup, use the\n--transaction-isolation=level option to mysqld on the command line or\nin an option file. Values of level for this option use dashes rather\nthan spaces, so the permissible values are READ-UNCOMMITTED,\nREAD-COMMITTED, REPEATABLE-READ, or SERIALIZABLE. For example, to set\nthe default isolation level to REPEATABLE READ, use these lines in the\n[mysqld] section of an option file:\n\n[mysqld]\ntransaction-isolation = REPEATABLE-READ\n\nIt is possible to check or set the global and session transaction\nisolation levels at runtime by using the tx_isolation system variable:\n\nSELECT @@GLOBAL.tx_isolation, @@tx_isolation;\nSET GLOBAL tx_isolation=\'REPEATABLE-READ\';\nSET SESSION tx_isolation=\'SERIALIZABLE\';\n\nSimilarly, to set the transaction access mode at server startup or at\nruntime, use the --transaction-read-only option or tx_read_only system\nvariable. By default, these are OFF (the mode is read/write) but can be\nset to ON for a default mode of read only.\n\nSetting the global or session value of tx_isolation or tx_read_only is\nequivalent to setting the isolation level or access mode with SET\nGLOBAL TRANSACTION or SET SESSION TRANSACTION.\n\nDetails and Usage of Isolation Levels\n\nInnoDB supports each of the transaction isolation levels described here\nusing different locking strategies. You can enforce a high degree of\nconsistency with the default REPEATABLE READ level, for operations on\ncrucial data where ACID compliance is important. Or you can relax the\nconsistency rules with READ COMMITTED or even READ UNCOMMITTED, in\nsituations such as bulk reporting where precise consistency and\nrepeatable results are less important than minimizing the amount of\noverhead for locking. SERIALIZABLE enforces even stricter rules than\nREPEATABLE READ, and is used mainly in specialized situations, such as\nwith XA transactions and for troubleshooting issues with concurrency\nand deadlocks.\n\nFor full information about how these isolation levels work with InnoDB\ntransactions, see\nhttp://dev.mysql.com/doc/refman/5.6/en/innodb-transaction-model.html.\nIn particular, for additional information about InnoDB record-level\nlocks and how it uses them to execute various types of statements, see\nhttp://dev.mysql.com/doc/refman/5.6/en/innodb-record-level-locks.html\nand http://dev.mysql.com/doc/refman/5.6/en/innodb-locks-set.html.\n\nThe following list describes how MySQL supports the different\ntransaction levels. The list goes from the most commonly used level to\nthe least used.\n\no REPEATABLE READ\n\n  This is the default isolation level for InnoDB. For consistent reads,\n  there is an important difference from the READ COMMITTED isolation\n  level: All consistent reads within the same transaction read the\n  snapshot established by the first read. This convention means that if\n  you issue several plain (nonlocking) SELECT statements within the\n  same transaction, these SELECT statements are consistent also with\n  respect to each other. See\n  http://dev.mysql.com/doc/refman/5.6/en/innodb-consistent-read.html.\n\n  For locking reads (SELECT with FOR UPDATE or LOCK IN SHARE MODE),\n  UPDATE, and DELETE statements, locking depends on whether the\n  statement uses a unique index with a unique search condition, or a\n  range-type search condition. For a unique index with a unique search\n  condition, InnoDB locks only the index record found, not the gap\n  before it. For other search conditions, InnoDB locks the index range\n  scanned, using gap locks or next-key locks to block insertions by\n  other sessions into the gaps covered by the range.\n\no READ COMMITTED\n\n  A somewhat Oracle-like isolation level with respect to consistent\n  (nonlocking) reads: Each consistent read, even within the same\n  transaction, sets and reads its own fresh snapshot. See\n  http://dev.mysql.com/doc/refman/5.6/en/innodb-consistent-read.html.\n\n  For locking reads (SELECT with FOR UPDATE or LOCK IN SHARE MODE),\n  InnoDB locks only index records, not the gaps before them, and thus\n  permits the free insertion of new records next to locked records. For\n  UPDATE and DELETE statements, locking depends on whether the\n  statement uses a unique index with a unique search condition (such as\n  WHERE id = 100), or a range-type search condition (such as WHERE id >\n  100). For a unique index with a unique search condition, InnoDB locks\n  only the index record found, not the gap before it. For range-type\n  searches, InnoDB locks the index range scanned, using gap locks or\n  next-key locks to block insertions by other sessions into the gaps\n  covered by the range. This is necessary because \"phantom rows\" must\n  be blocked for MySQL replication and recovery to work.\n\n  *Note*: In MySQL 5.6, if the READ COMMITTED isolation level is used,\n  or the deprecated innodb_locks_unsafe_for_binlog system variable is\n  enabled, there is no InnoDB gap locking except for foreign-key\n  constraint checking and duplicate-key checking. Also, record locks\n  for nonmatching rows are released after MySQL has evaluated the WHERE\n  condition. If you use READ COMMITTED or enable\n  innodb_locks_unsafe_for_binlog, you must use row-based binary\n  logging.\n\no READ UNCOMMITTED\n\n  SELECT statements are performed in a nonlocking fashion, but a\n  possible earlier version of a row might be used. Thus, using this\n  isolation level, such reads are not consistent. This is also called a\n  dirty read. Otherwise, this isolation level works like READ\n  COMMITTED.\n\no SERIALIZABLE\n\n  This level is like REPEATABLE READ, but InnoDB implicitly converts\n  all plain SELECT statements to SELECT ... LOCK IN SHARE MODE if\n  autocommit is disabled. If autocommit is enabled, the SELECT is its\n  own transaction. It therefore is known to be read only and can be\n  serialized if performed as a consistent (nonlocking) read and need\n  not block for other transactions. (To force a plain SELECT to block\n  if other transactions have modified the selected rows, disable\n  autocommit.)\n\nTransaction Access Mode\n\nAs of MySQL 5.6.5, the transaction access mode may be specified with\nSET TRANSACTION. By default, a transaction takes place in read/write\nmode, with both reads and writes permitted to tables used in the\ntransaction. This mode may be specified explicitly using an access mode\nof READ WRITE.\n\nIf the transaction access mode is set to READ ONLY, changes to tables\nare prohibited. This may enable storage engines to make performance\nimprovements that are possible when writes are not permitted.\n\nIt is not permitted to specify both READ WRITE and READ ONLY in the\nsame statement.\n\nIn read-only mode, it remains possible to change tables created with\nthe TEMPORARY keyword using DML statements. Changes made with DDL\nstatements are not permitted, just as with permanent tables.\n\nThe READ WRITE and READ ONLY access modes also may be specified for an\nindividual transaction using the START TRANSACTION statement.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/set-transaction.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/set-transaction.html'),(239,'SIN',4,'Syntax:\nSIN(X)\n\nReturns the sine of X, where X is given in radians.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/mathematical-functions.html\n\n','mysql> SELECT SIN(PI());\n        -> 1.2246063538224e-16\nmysql> SELECT ROUND(SIN(PI()));\n        -> 0\n','http://dev.mysql.com/doc/refman/5.6/en/mathematical-functions.html'),(240,'BUFFER',26,'Buffer(g,d)\n\nReturns a geometry that represents all points whose distance from the\ngeometry value g is less than or equal to a distance of d.\n\nBuffer() supports negative distances for polygons, multipolygons, and\ngeometry collections containing polygons or multipolygons. For point,\nmultipoint, linestring, multilinestring, and geometry collections not\ncontaining any polygons or multipolygons, Buffer() with a negative\ndistance returns NULL.\n\nPrior to MySQL 5.6.1, this function is unimplemented.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/functions-that-create-new-geometries-from-existing-ones.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/functions-that-create-new-geometries-from-existing-ones.html'),(241,'IS',19,'Syntax:\nIS boolean_value\n\nTests a value against a boolean value, where boolean_value can be TRUE,\nFALSE, or UNKNOWN.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/comparison-operators.html\n\n','mysql> SELECT 1 IS TRUE, 0 IS FALSE, NULL IS UNKNOWN;\n        -> 1, 1, 1\n','http://dev.mysql.com/doc/refman/5.6/en/comparison-operators.html'),(242,'GET_FORMAT',32,'Syntax:\nGET_FORMAT({DATE|TIME|DATETIME}, {\'EUR\'|\'USA\'|\'JIS\'|\'ISO\'|\'INTERNAL\'})\n\nReturns a format string. This function is useful in combination with\nthe DATE_FORMAT() and the STR_TO_DATE() functions.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html\n\n','mysql> SELECT DATE_FORMAT(\'2003-10-03\',GET_FORMAT(DATE,\'EUR\'));\n        -> \'03.10.2003\'\nmysql> SELECT STR_TO_DATE(\'10.31.2003\',GET_FORMAT(DATE,\'USA\'));\n        -> \'2003-10-31\'\n','http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html'),(243,'TINYBLOB',23,'TINYBLOB\n\nA BLOB column with a maximum length of 255 (28 - 1) bytes. Each\nTINYBLOB value is stored using a 1-byte length prefix that indicates\nthe number of bytes in the value.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/string-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/string-type-overview.html'),(244,'USER',17,'Syntax:\nUSER()\n\nReturns the current MySQL user name and host name as a string in the\nutf8 character set.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/information-functions.html\n\n','mysql> SELECT USER();\n        -> \'davida@localhost\'\n','http://dev.mysql.com/doc/refman/5.6/en/information-functions.html'),(245,'REPAIR TABLE',21,'Syntax:\nREPAIR [NO_WRITE_TO_BINLOG | LOCAL] TABLE\n    tbl_name [, tbl_name] ...\n    [QUICK] [EXTENDED] [USE_FRM]\n\nREPAIR TABLE repairs a possibly corrupted table, for certain storage\nengines only. By default, it has the same effect as myisamchk --recover\ntbl_name.\n\n*Note*: REPAIR TABLE only applies to MyISAM, ARCHIVE, and CSV tables.\nSee http://dev.mysql.com/doc/refman/5.6/en/myisam-storage-engine.html,\nand http://dev.mysql.com/doc/refman/5.6/en/archive-storage-engine.html,\nand http://dev.mysql.com/doc/refman/5.6/en/csv-storage-engine.html\n\nThis statement requires SELECT and INSERT privileges for the table.\n\nREPAIR TABLE is supported for partitioned tables. However, the USE_FRM\noption cannot be used with this statement on a partitioned table.\n\nIn MySQL 5.6.11 only, gtid_next must be set to AUTOMATIC before issuing\nthis statement. (Bug #16062608, Bug #16715809, Bug #69045)\n\nYou can use ALTER TABLE ... REPAIR PARTITION to repair one or more\npartitions; for more information, see [HELP ALTER TABLE], and\nhttp://dev.mysql.com/doc/refman/5.6/en/partitioning-maintenance.html.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/repair-table.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/repair-table.html'),(246,'MERGE',18,'The MERGE storage engine, also known as the MRG_MyISAM engine, is a\ncollection of identical MyISAM tables that can be used as one.\n\"Identical\" means that all tables have identical column and index\ninformation. You cannot merge MyISAM tables in which the columns are\nlisted in a different order, do not have exactly the same columns, or\nhave the indexes in different order. However, any or all of the MyISAM\ntables can be compressed with myisampack. See\nhttp://dev.mysql.com/doc/refman/5.6/en/myisampack.html. Differences in\ntable options such as AVG_ROW_LENGTH, MAX_ROWS, or PACK_KEYS do not\nmatter.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/merge-storage-engine.html\n\n','mysql> CREATE TABLE t1 (\n    ->    a INT NOT NULL AUTO_INCREMENT PRIMARY KEY,\n    ->    message CHAR(20)) ENGINE=MyISAM;\nmysql> CREATE TABLE t2 (\n    ->    a INT NOT NULL AUTO_INCREMENT PRIMARY KEY,\n    ->    message CHAR(20)) ENGINE=MyISAM;\nmysql> INSERT INTO t1 (message) VALUES (\'Testing\'),(\'table\'),(\'t1\');\nmysql> INSERT INTO t2 (message) VALUES (\'Testing\'),(\'table\'),(\'t2\');\nmysql> CREATE TABLE total (\n    ->    a INT NOT NULL AUTO_INCREMENT,\n    ->    message CHAR(20), INDEX(a))\n    ->    ENGINE=MERGE UNION=(t1,t2) INSERT_METHOD=LAST;\n','http://dev.mysql.com/doc/refman/5.6/en/merge-storage-engine.html'),(247,'CREATE TABLE',40,'Syntax:\nCREATE [TEMPORARY] TABLE [IF NOT EXISTS] tbl_name\n    (create_definition,...)\n    [table_options]\n    [partition_options]\n\nOr:\n\nCREATE [TEMPORARY] TABLE [IF NOT EXISTS] tbl_name\n    [(create_definition,...)]\n    [table_options]\n    [partition_options]\n    select_statement\n\nOr:\n\nCREATE [TEMPORARY] TABLE [IF NOT EXISTS] tbl_name\n    { LIKE old_tbl_name | (LIKE old_tbl_name) }\n\ncreate_definition:\n    col_name column_definition\n  | [CONSTRAINT [symbol]] PRIMARY KEY [index_type] (index_col_name,...)\n      [index_option] ...\n  | {INDEX|KEY} [index_name] [index_type] (index_col_name,...)\n      [index_option] ...\n  | [CONSTRAINT [symbol]] UNIQUE [INDEX|KEY]\n      [index_name] [index_type] (index_col_name,...)\n      [index_option] ...\n  | {FULLTEXT|SPATIAL} [INDEX|KEY] [index_name] (index_col_name,...)\n      [index_option] ...\n  | [CONSTRAINT [symbol]] FOREIGN KEY\n      [index_name] (index_col_name,...) reference_definition\n  | CHECK (expr)\n\ncolumn_definition:\n    data_type [NOT NULL | NULL] [DEFAULT default_value]\n      [AUTO_INCREMENT] [UNIQUE [KEY] | [PRIMARY] KEY]\n      [COMMENT \'string\']\n      [COLUMN_FORMAT {FIXED|DYNAMIC|DEFAULT}]\n      [STORAGE {DISK|MEMORY|DEFAULT}]\n      [reference_definition]\n\ndata_type:\n    BIT[(length)]\n  | TINYINT[(length)] [UNSIGNED] [ZEROFILL]\n  | SMALLINT[(length)] [UNSIGNED] [ZEROFILL]\n  | MEDIUMINT[(length)] [UNSIGNED] [ZEROFILL]\n  | INT[(length)] [UNSIGNED] [ZEROFILL]\n  | INTEGER[(length)] [UNSIGNED] [ZEROFILL]\n  | BIGINT[(length)] [UNSIGNED] [ZEROFILL]\n  | REAL[(length,decimals)] [UNSIGNED] [ZEROFILL]\n  | DOUBLE[(length,decimals)] [UNSIGNED] [ZEROFILL]\n  | FLOAT[(length,decimals)] [UNSIGNED] [ZEROFILL]\n  | DECIMAL[(length[,decimals])] [UNSIGNED] [ZEROFILL]\n  | NUMERIC[(length[,decimals])] [UNSIGNED] [ZEROFILL]\n  | DATE\n  | TIME\n  | TIMESTAMP\n  | DATETIME\n  | YEAR\n  | CHAR[(length)]\n      [CHARACTER SET charset_name] [COLLATE collation_name]\n  | VARCHAR(length)\n      [CHARACTER SET charset_name] [COLLATE collation_name]\n  | BINARY[(length)]\n  | VARBINARY(length)\n  | TINYBLOB\n  | BLOB\n  | MEDIUMBLOB\n  | LONGBLOB\n  | TINYTEXT [BINARY]\n      [CHARACTER SET charset_name] [COLLATE collation_name]\n  | TEXT [BINARY]\n      [CHARACTER SET charset_name] [COLLATE collation_name]\n  | MEDIUMTEXT [BINARY]\n      [CHARACTER SET charset_name] [COLLATE collation_name]\n  | LONGTEXT [BINARY]\n      [CHARACTER SET charset_name] [COLLATE collation_name]\n  | ENUM(value1,value2,value3,...)\n      [CHARACTER SET charset_name] [COLLATE collation_name]\n  | SET(value1,value2,value3,...)\n      [CHARACTER SET charset_name] [COLLATE collation_name]\n  | spatial_type\n\nindex_col_name:\n    col_name [(length)] [ASC | DESC]\n\nindex_type:\n    USING {BTREE | HASH}\n\nindex_option:\n    KEY_BLOCK_SIZE [=] value\n  | index_type\n  | WITH PARSER parser_name\n  | COMMENT \'string\'\n\nreference_definition:\n    REFERENCES tbl_name (index_col_name,...)\n      [MATCH FULL | MATCH PARTIAL | MATCH SIMPLE]\n      [ON DELETE reference_option]\n      [ON UPDATE reference_option]\n\nreference_option:\n    RESTRICT | CASCADE | SET NULL | NO ACTION\n\ntable_options:\n    table_option [[,] table_option] ...\n\ntable_option:\n    ENGINE [=] engine_name\n  | AUTO_INCREMENT [=] value\n  | AVG_ROW_LENGTH [=] value\n  | [DEFAULT] CHARACTER SET [=] charset_name\n  | CHECKSUM [=] {0 | 1}\n  | [DEFAULT] COLLATE [=] collation_name\n  | COMMENT [=] \'string\'\n  | CONNECTION [=] \'connect_string\'\n  | DATA DIRECTORY [=] \'absolute path to directory\'\n  | DELAY_KEY_WRITE [=] {0 | 1}\n  | INDEX DIRECTORY [=] \'absolute path to directory\'\n  | INSERT_METHOD [=] { NO | FIRST | LAST }\n  | KEY_BLOCK_SIZE [=] value\n  | MAX_ROWS [=] value\n  | MIN_ROWS [=] value\n  | PACK_KEYS [=] {0 | 1 | DEFAULT}\n  | PASSWORD [=] \'string\'\n  | ROW_FORMAT [=] {DEFAULT|DYNAMIC|FIXED|COMPRESSED|REDUNDANT|COMPACT}\n  | STATS_AUTO_RECALC [=] {DEFAULT|0|1}\n  | STATS_PERSISTENT [=] {DEFAULT|0|1}\n  | TABLESPACE tablespace_name [STORAGE {DISK|MEMORY|DEFAULT}]\n  | UNION [=] (tbl_name[,tbl_name]...)\n\npartition_options:\n    PARTITION BY\n        { [LINEAR] HASH(expr)\n        | [LINEAR] KEY [ALGORITHM={1|2}] (column_list)\n        | RANGE{(expr) | COLUMNS(column_list)}\n        | LIST{(expr) | COLUMNS(column_list)} }\n    [PARTITIONS num]\n    [SUBPARTITION BY\n        { [LINEAR] HASH(expr)\n        | [LINEAR] KEY [ALGORITHM={1|2}] (column_list) }\n      [SUBPARTITIONS num]\n    ]\n    [(partition_definition [, partition_definition] ...)]\n\npartition_definition:\n    PARTITION partition_name\n        [VALUES \n            {LESS THAN {(expr | value_list) | MAXVALUE} \n            | \n            IN (value_list)}]\n        [[STORAGE] ENGINE [=] engine_name]\n        [COMMENT [=] \'comment_text\' ]\n        [DATA DIRECTORY [=] \'data_dir\']\n        [INDEX DIRECTORY [=] \'index_dir\']\n        [MAX_ROWS [=] max_number_of_rows]\n        [MIN_ROWS [=] min_number_of_rows]\n        [TABLESPACE [=] tablespace_name]\n        [NODEGROUP [=] node_group_id]\n        [(subpartition_definition [, subpartition_definition] ...)]\n\nsubpartition_definition:\n    SUBPARTITION logical_name\n        [[STORAGE] ENGINE [=] engine_name]\n        [COMMENT [=] \'comment_text\' ]\n        [DATA DIRECTORY [=] \'data_dir\']\n        [INDEX DIRECTORY [=] \'index_dir\']\n        [MAX_ROWS [=] max_number_of_rows]\n        [MIN_ROWS [=] min_number_of_rows]\n        [TABLESPACE [=] tablespace_name]\n        [NODEGROUP [=] node_group_id]\n\nselect_statement:\n    [IGNORE | REPLACE] [AS] SELECT ...   (Some valid select statement)\n\nCREATE TABLE creates a table with the given name. You must have the\nCREATE privilege for the table.\n\nRules for permissible table names are given in\nhttp://dev.mysql.com/doc/refman/5.6/en/identifiers.html. By default,\nthe table is created in the default database, using the InnoDB storage\nengine. An error occurs if the table exists, if there is no default\ndatabase, or if the database does not exist.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/create-table.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/create-table.html'),(248,'MICROSECOND',32,'Syntax:\nMICROSECOND(expr)\n\nReturns the microseconds from the time or datetime expression expr as a\nnumber in the range from 0 to 999999.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html\n\n','mysql> SELECT MICROSECOND(\'12:00:00.123456\');\n        -> 123456\nmysql> SELECT MICROSECOND(\'2009-12-31 23:59:59.000010\');\n        -> 10\n','http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html'),(249,'CREATE SERVER',40,'Syntax:\nCREATE SERVER server_name\n    FOREIGN DATA WRAPPER wrapper_name\n    OPTIONS (option [, option] ...)\n\noption:\n  { HOST character-literal\n  | DATABASE character-literal\n  | USER character-literal\n  | PASSWORD character-literal\n  | SOCKET character-literal\n  | OWNER character-literal\n  | PORT numeric-literal }\n\nThis statement creates the definition of a server for use with the\nFEDERATED storage engine. The CREATE SERVER statement creates a new row\nin the servers table in the mysql database. This statement requires the\nSUPER privilege.\n\nThe server_name should be a unique reference to the server. Server\ndefinitions are global within the scope of the server, it is not\npossible to qualify the server definition to a specific database.\nserver_name has a maximum length of 64 characters (names longer than 64\ncharacters are silently truncated), and is case insensitive. You may\nspecify the name as a quoted string.\n\nThe wrapper_name should be mysql, and may be quoted with single\nquotation marks. Other values for wrapper_name are not currently\nsupported.\n\nFor each option you must specify either a character literal or numeric\nliteral. Character literals are UTF-8, support a maximum length of 64\ncharacters and default to a blank (empty) string. String literals are\nsilently truncated to 64 characters. Numeric literals must be a number\nbetween 0 and 9999, default value is 0.\n\n*Note*: The OWNER option is currently not applied, and has no effect on\nthe ownership or operation of the server connection that is created.\n\nThe CREATE SERVER statement creates an entry in the mysql.servers table\nthat can later be used with the CREATE TABLE statement when creating a\nFEDERATED table. The options that you specify will be used to populate\nthe columns in the mysql.servers table. The table columns are\nServer_name, Host, Db, Username, Password, Port and Socket.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/create-server.html\n\n','CREATE SERVER s\nFOREIGN DATA WRAPPER mysql\nOPTIONS (USER \'Remote\', HOST \'192.168.1.106\', DATABASE \'test\');\n','http://dev.mysql.com/doc/refman/5.6/en/create-server.html'),(250,'MAKETIME',32,'Syntax:\nMAKETIME(hour,minute,second)\n\nReturns a time value calculated from the hour, minute, and second\narguments.\n\nAs of MySQL 5.6.4, the second argument can have a fractional part.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html\n\n','mysql> SELECT MAKETIME(12,15,30);\n        -> \'12:15:30\'\n','http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html'),(251,'CURDATE',32,'Syntax:\nCURDATE()\n\nReturns the current date as a value in \'YYYY-MM-DD\' or YYYYMMDD format,\ndepending on whether the function is used in a string or numeric\ncontext.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html\n\n','mysql> SELECT CURDATE();\n        -> \'2008-06-13\'\nmysql> SELECT CURDATE() + 0;\n        -> 20080613\n','http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html'),(252,'SET PASSWORD',10,'Syntax:\nSET PASSWORD [FOR user] =\n    {\n        PASSWORD(\'cleartext password\')\n      | OLD_PASSWORD(\'cleartext password\')\n      | \'encrypted password\'\n    }\n\nThe SET PASSWORD statement assigns a password to an existing MySQL user\naccount. When the read_only system variable is enabled, the SUPER\nprivilege is required to use SET PASSWORD, in addition to whatever\nother privileges might be required.\n\nIf the password is specified using the PASSWORD() or OLD_PASSWORD()\nfunction, the cleartext (unencrypted) password should be given as the\nargument to the function, which hashes the password and returns the\nencrypted password string. If the password is specified without using\neither function, it should be the already encrypted password value as a\nliteral string. In all cases, the encrypted password string must be in\nthe format required by the authentication method used for the account.\n\nWith no FOR user clause, this statement sets the password for the\ncurrent user. (To see which account the server authenticated you as,\ninvoke the CURRENT_USER() function.) Any client who successfully\nconnects to the server using a nonanonymous account can change the\npassword for that account.\n\nWith a FOR user clause, this statement sets the password for the named\nuser. You must have the UPDATE privilege for the mysql database to do\nthis. The user account name uses the format described in\nhttp://dev.mysql.com/doc/refman/5.6/en/account-names.html. The user\nvalue should be given as \'user_name\'@\'host_name\', where \'user_name\' and\n\'host_name\' are exactly as listed in the User and Host columns of the\nmysql.user table row. (If you specify only a user name, a host name of\n\'%\' is used.) For example, to set the password for an account with User\nand Host column values of \'bob\' and \'%.example.org\', write the\nstatement like this:\n\nSET PASSWORD FOR \'bob\'@\'%.example.org\' = PASSWORD(\'cleartext password\');\n\nThat is equivalent to the following statements:\n\nUPDATE mysql.user SET Password=PASSWORD(\'cleartext password\')\n  WHERE User=\'bob\' AND Host=\'%.example.org\';\nFLUSH PRIVILEGES;\n\nAnother way to set the password is to use GRANT:\n\nGRANT USAGE ON *.* TO \'bob\'@\'%.example.org\' IDENTIFIED BY \'cleartext password\';\n\nThe old_passwords system variable value determines the hashing method\nused by PASSWORD(). If you specify the password using that function and\nSET PASSWORD rejects the password as not being in the correct format,\nit may be necessary to set old_passwords to change the hashing method.\nFor descriptions of the permitted values, see\nhttp://dev.mysql.com/doc/refman/5.6/en/server-system-variables.html.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/set-password.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/set-password.html'),(253,'DATABASE',17,'Syntax:\nDATABASE()\n\nReturns the default (current) database name as a string in the utf8\ncharacter set. If there is no default database, DATABASE() returns\nNULL. Within a stored routine, the default database is the database\nthat the routine is associated with, which is not necessarily the same\nas the database that is the default in the calling context.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/information-functions.html\n\n','mysql> SELECT DATABASE();\n        -> \'test\'\n','http://dev.mysql.com/doc/refman/5.6/en/information-functions.html'),(254,'IF FUNCTION',7,'Syntax:\nIF(expr1,expr2,expr3)\n\nIf expr1 is TRUE (expr1 <> 0 and expr1 <> NULL) then IF() returns\nexpr2; otherwise it returns expr3. IF() returns a numeric or string\nvalue, depending on the context in which it is used.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/control-flow-functions.html\n\n','mysql> SELECT IF(1>2,2,3);\n        -> 3\nmysql> SELECT IF(1<2,\'yes\',\'no\');\n        -> \'yes\'\nmysql> SELECT IF(STRCMP(\'test\',\'test1\'),\'no\',\'yes\');\n        -> \'no\'\n','http://dev.mysql.com/doc/refman/5.6/en/control-flow-functions.html'),(255,'POINTFROMWKB',33,'PointFromWKB(wkb[,srid])\n\nConstructs a POINT value using its WKB representation and SRID.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/creating-spatial-values.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/creating-spatial-values.html'),(256,'POWER',4,'Syntax:\nPOWER(X,Y)\n\nThis is a synonym for POW().\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/mathematical-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/mathematical-functions.html'),(257,'ATAN',4,'Syntax:\nATAN(X)\n\nReturns the arc tangent of X, that is, the value whose tangent is X.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/mathematical-functions.html\n\n','mysql> SELECT ATAN(2);\n        -> 1.1071487177941\nmysql> SELECT ATAN(-2);\n        -> -1.1071487177941\n','http://dev.mysql.com/doc/refman/5.6/en/mathematical-functions.html'),(258,'SHOW PROFILE',27,'Syntax:\nSHOW PROFILE [type [, type] ... ]\n    [FOR QUERY n]\n    [LIMIT row_count [OFFSET offset]]\n\ntype:\n    ALL\n  | BLOCK IO\n  | CONTEXT SWITCHES\n  | CPU\n  | IPC\n  | MEMORY\n  | PAGE FAULTS\n  | SOURCE\n  | SWAPS\n\nThe SHOW PROFILE and SHOW PROFILES statements display profiling\ninformation that indicates resource usage for statements executed\nduring the course of the current session.\n\n*Note*: These statements are deprecated as of MySQL 5.6.7 and will be\nremoved in a future MySQL release. Use the Performance Schema instead;\nsee http://dev.mysql.com/doc/refman/5.6/en/performance-schema.html.\n\nProfiling is controlled by the profiling session variable, which has a\ndefault value of 0 (OFF). Profiling is enabled by setting profiling to\n1 or ON:\n\nmysql> SET profiling = 1;\n\nSHOW PROFILES displays a list of the most recent statements sent to the\nserver. The size of the list is controlled by the\nprofiling_history_size session variable, which has a default value of\n15. The maximum value is 100. Setting the value to 0 has the practical\neffect of disabling profiling.\n\nAll statements are profiled except SHOW PROFILE and SHOW PROFILES, so\nyou will find neither of those statements in the profile list.\nMalformed statements are profiled. For example, SHOW PROFILING is an\nillegal statement, and a syntax error occurs if you try to execute it,\nbut it will show up in the profiling list.\n\nSHOW PROFILE displays detailed information about a single statement.\nWithout the FOR QUERY n clause, the output pertains to the most\nrecently executed statement. If FOR QUERY n is included, SHOW PROFILE\ndisplays information for statement n. The values of n correspond to the\nQuery_ID values displayed by SHOW PROFILES.\n\nThe LIMIT row_count clause may be given to limit the output to\nrow_count rows. If LIMIT is given, OFFSET offset may be added to begin\nthe output offset rows into the full set of rows.\n\nBy default, SHOW PROFILE displays Status and Duration columns. The\nStatus values are like the State values displayed by SHOW PROCESSLIST,\nalthough there might be some minor differences in interpretion for the\ntwo statements for some status values (see\nhttp://dev.mysql.com/doc/refman/5.6/en/thread-information.html).\n\nOptional type values may be specified to display specific additional\ntypes of information:\n\no ALL displays all information\n\no BLOCK IO displays counts for block input and output operations\n\no CONTEXT SWITCHES displays counts for voluntary and involuntary\n  context switches\n\no CPU displays user and system CPU usage times\n\no IPC displays counts for messages sent and received\n\no MEMORY is not currently implemented\n\no PAGE FAULTS displays counts for major and minor page faults\n\no SOURCE displays the names of functions from the source code, together\n  with the name and line number of the file in which the function\n  occurs\n\no SWAPS displays swap counts\n\nProfiling is enabled per session. When a session ends, its profiling\ninformation is lost.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/show-profile.html\n\n','mysql> SELECT @@profiling;\n+-------------+\n| @@profiling |\n+-------------+\n|           0 |\n+-------------+\n1 row in set (0.00 sec)\n\nmysql> SET profiling = 1;\nQuery OK, 0 rows affected (0.00 sec)\n\nmysql> DROP TABLE IF EXISTS t1;\nQuery OK, 0 rows affected, 1 warning (0.00 sec)\n\nmysql> CREATE TABLE T1 (id INT);\nQuery OK, 0 rows affected (0.01 sec)\n\nmysql> SHOW PROFILES;\n+----------+----------+--------------------------+\n| Query_ID | Duration | Query                    |\n+----------+----------+--------------------------+\n|        0 | 0.000088 | SET PROFILING = 1        |\n|        1 | 0.000136 | DROP TABLE IF EXISTS t1  |\n|        2 | 0.011947 | CREATE TABLE t1 (id INT) |\n+----------+----------+--------------------------+\n3 rows in set (0.00 sec)\n\nmysql> SHOW PROFILE;\n+----------------------+----------+\n| Status               | Duration |\n+----------------------+----------+\n| checking permissions | 0.000040 |\n| creating table       | 0.000056 |\n| After create         | 0.011363 |\n| query end            | 0.000375 |\n| freeing items        | 0.000089 |\n| logging slow query   | 0.000019 |\n| cleaning up          | 0.000005 |\n+----------------------+----------+\n7 rows in set (0.00 sec)\n\nmysql> SHOW PROFILE FOR QUERY 1;\n+--------------------+----------+\n| Status             | Duration |\n+--------------------+----------+\n| query end          | 0.000107 |\n| freeing items      | 0.000008 |\n| logging slow query | 0.000015 |\n| cleaning up        | 0.000006 |\n+--------------------+----------+\n4 rows in set (0.00 sec)\n\nmysql> SHOW PROFILE CPU FOR QUERY 2;\n+----------------------+----------+----------+------------+\n| Status               | Duration | CPU_user | CPU_system |\n+----------------------+----------+----------+------------+\n| checking permissions | 0.000040 | 0.000038 |   0.000002 |\n| creating table       | 0.000056 | 0.000028 |   0.000028 |\n| After create         | 0.011363 | 0.000217 |   0.001571 |\n| query end            | 0.000375 | 0.000013 |   0.000028 |\n| freeing items        | 0.000089 | 0.000010 |   0.000014 |\n| logging slow query   | 0.000019 | 0.000009 |   0.000010 |\n| cleaning up          | 0.000005 | 0.000003 |   0.000002 |\n+----------------------+----------+----------+------------+\n7 rows in set (0.00 sec)\n','http://dev.mysql.com/doc/refman/5.6/en/show-profile.html'),(259,'LN',4,'Syntax:\nLN(X)\n\nReturns the natural logarithm of X; that is, the base-e logarithm of X.\nIf X is less than or equal to 0, then NULL is returned.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/mathematical-functions.html\n\n','mysql> SELECT LN(2);\n        -> 0.69314718055995\nmysql> SELECT LN(-2);\n        -> NULL\n','http://dev.mysql.com/doc/refman/5.6/en/mathematical-functions.html'),(260,'RETURN',24,'Syntax:\nRETURN expr\n\nThe RETURN statement terminates execution of a stored function and\nreturns the value expr to the function caller. There must be at least\none RETURN statement in a stored function. There may be more than one\nif the function has multiple exit points.\n\nThis statement is not used in stored procedures, triggers, or events.\nThe LEAVE statement can be used to exit a stored program of those\ntypes.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/return.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/return.html'),(261,'SET SQL_LOG_BIN',8,'Syntax:\nSET sql_log_bin = {0|1}\n\nThe sql_log_bin variable controls whether logging to the binary log is\ndone. The default value is 1 (do logging). To change logging for the\ncurrent session, change the session value of this variable. The session\nuser must have the SUPER privilege to set this variable.\n\nIn MySQL 5.6, it is not possible to set @@session.sql_log_bin within a\ntransaction or subquery. (Bug #53437)\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/set-sql-log-bin.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/set-sql-log-bin.html'),(262,'AES_DECRYPT',12,'Syntax:\nAES_DECRYPT(crypt_str,key_str)\n\nThis function decrypts data using the official AES (Advanced Encryption\nStandard) algorithm. For more information, see the description of\nAES_ENCRYPT().\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/encryption-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/encryption-functions.html'),(263,'COERCIBILITY',17,'Syntax:\nCOERCIBILITY(str)\n\nReturns the collation coercibility value of the string argument.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/information-functions.html\n\n','mysql> SELECT COERCIBILITY(\'abc\' COLLATE latin1_swedish_ci);\n        -> 0\nmysql> SELECT COERCIBILITY(USER());\n        -> 3\nmysql> SELECT COERCIBILITY(\'abc\');\n        -> 4\n','http://dev.mysql.com/doc/refman/5.6/en/information-functions.html'),(264,'INT',23,'INT[(M)] [UNSIGNED] [ZEROFILL]\n\nA normal-size integer. The signed range is -2147483648 to 2147483647.\nThe unsigned range is 0 to 4294967295.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/numeric-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/numeric-type-overview.html'),(265,'GLENGTH',13,'GLength(ls)\n\nReturns as a double-precision number the length of the LineString value\nls in its associated spatial reference.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/geometry-property-functions.html\n\n','mysql> SET @ls = \'LineString(1 1,2 2,3 3)\';\nmysql> SELECT GLength(GeomFromText(@ls));\n+----------------------------+\n| GLength(GeomFromText(@ls)) |\n+----------------------------+\n|            2.8284271247462 |\n+----------------------------+\n','http://dev.mysql.com/doc/refman/5.6/en/geometry-property-functions.html'),(266,'MAKE_SET',38,'Syntax:\nMAKE_SET(bits,str1,str2,...)\n\nReturns a set value (a string containing substrings separated by \",\"\ncharacters) consisting of the strings that have the corresponding bit\nin bits set. str1 corresponds to bit 0, str2 to bit 1, and so on. NULL\nvalues in str1, str2, ... are not appended to the result.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/string-functions.html\n\n','mysql> SELECT MAKE_SET(1,\'a\',\'b\',\'c\');\n        -> \'a\'\nmysql> SELECT MAKE_SET(1 | 4,\'hello\',\'nice\',\'world\');\n        -> \'hello,world\'\nmysql> SELECT MAKE_SET(1 | 4,\'hello\',\'nice\',NULL,\'world\');\n        -> \'hello\'\nmysql> SELECT MAKE_SET(0,\'a\',\'b\',\'c\');\n        -> \'\'\n','http://dev.mysql.com/doc/refman/5.6/en/string-functions.html'),(267,'FIND_IN_SET',38,'Syntax:\nFIND_IN_SET(str,strlist)\n\nReturns a value in the range of 1 to N if the string str is in the\nstring list strlist consisting of N substrings. A string list is a\nstring composed of substrings separated by \",\" characters. If the first\nargument is a constant string and the second is a column of type SET,\nthe FIND_IN_SET() function is optimized to use bit arithmetic. Returns\n0 if str is not in strlist or if strlist is the empty string. Returns\nNULL if either argument is NULL. This function does not work properly\nif the first argument contains a comma (\",\") character.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/string-functions.html\n\n','mysql> SELECT FIND_IN_SET(\'b\',\'a,b,c,d\');\n        -> 2\n','http://dev.mysql.com/doc/refman/5.6/en/string-functions.html'),(268,'MIN',16,'Syntax:\nMIN([DISTINCT] expr)\n\nReturns the minimum value of expr. MIN() may take a string argument; in\nsuch cases, it returns the minimum string value. See\nhttp://dev.mysql.com/doc/refman/5.6/en/mysql-indexes.html. The DISTINCT\nkeyword can be used to find the minimum of the distinct values of expr,\nhowever, this produces the same result as omitting DISTINCT.\n\nMIN() returns NULL if there were no matching rows.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/group-by-functions.html\n\n','mysql> SELECT student_name, MIN(test_score), MAX(test_score)\n    ->        FROM student\n    ->        GROUP BY student_name;\n','http://dev.mysql.com/doc/refman/5.6/en/group-by-functions.html'),(269,'REPLACE',28,'Syntax:\nREPLACE [LOW_PRIORITY | DELAYED]\n    [INTO] tbl_name\n    [PARTITION (partition_name,...)] \n    [(col_name,...)]\n    {VALUES | VALUE} ({expr | DEFAULT},...),(...),...\n\nOr:\n\nREPLACE [LOW_PRIORITY | DELAYED]\n    [INTO] tbl_name\n    [PARTITION (partition_name,...)] \n    SET col_name={expr | DEFAULT}, ...\n\nOr:\n\nREPLACE [LOW_PRIORITY | DELAYED]\n    [INTO] tbl_name\n    [PARTITION (partition_name,...)]  \n    [(col_name,...)]\n    SELECT ...\n\nREPLACE works exactly like INSERT, except that if an old row in the\ntable has the same value as a new row for a PRIMARY KEY or a UNIQUE\nindex, the old row is deleted before the new row is inserted. See [HELP\nINSERT].\n\nREPLACE is a MySQL extension to the SQL standard. It either inserts, or\ndeletes and inserts. For another MySQL extension to standard SQL---that\neither inserts or updates---see\nhttp://dev.mysql.com/doc/refman/5.6/en/insert-on-duplicate.html.\n\nNote that unless the table has a PRIMARY KEY or UNIQUE index, using a\nREPLACE statement makes no sense. It becomes equivalent to INSERT,\nbecause there is no index to be used to determine whether a new row\nduplicates another.\n\nValues for all columns are taken from the values specified in the\nREPLACE statement. Any missing columns are set to their default values,\njust as happens for INSERT. You cannot refer to values from the current\nrow and use them in the new row. If you use an assignment such as SET\ncol_name = col_name + 1, the reference to the column name on the right\nhand side is treated as DEFAULT(col_name), so the assignment is\nequivalent to SET col_name = DEFAULT(col_name) + 1.\n\nTo use REPLACE, you must have both the INSERT and DELETE privileges for\nthe table.\n\nBeginning with MySQL 5.6.2, REPLACE supports explicit partition\nselection using the PARTITION option with a comma-separated list of\nnames of partitions, subpartitions, or both. As with INSERT, if it is\nnot possible to insert the new row into any of these partitions or\nsubpartitions, the REPLACE statement fails with the error Found a row\nnot matching the given partition set. See\nhttp://dev.mysql.com/doc/refman/5.6/en/partitioning-selection.html, for\nmore information.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/replace.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/replace.html'),(270,'CURRENT_TIMESTAMP',32,'Syntax:\nCURRENT_TIMESTAMP, CURRENT_TIMESTAMP([fsp])\n\nCURRENT_TIMESTAMP and CURRENT_TIMESTAMP() are synonyms for NOW().\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html'),(271,'GTID_SUBSET',17,'Syntax:\nGTID_SUBSET(subset,set)\n\nGiven two sets of global transaction IDs subset and set, returns true\nif all GTIDs in subset are also in set. Returns false otherwise.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/gtid-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/gtid-functions.html'),(272,'VAR_SAMP',16,'Syntax:\nVAR_SAMP(expr)\n\nReturns the sample variance of expr. That is, the denominator is the\nnumber of rows minus one.\n\nVAR_SAMP() returns NULL if there were no matching rows.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/group-by-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/group-by-functions.html'),(273,'DATETIME',23,'DATETIME[(fsp)]\n\nA date and time combination. The supported range is \'1000-01-01\n00:00:00.000000\' to \'9999-12-31 23:59:59.999999\'. MySQL displays\nDATETIME values in \'YYYY-MM-DD HH:MM:SS[.fraction]\' format, but permits\nassignment of values to DATETIME columns using either strings or\nnumbers.\n\nAs of MySQL 5.6.4, an optional fsp value in the range from 0 to 6 may\nbe given to specify fractional seconds precision. A value of 0\nsignifies that there is no fractional part. If omitted, the default\nprecision is 0.\n\nAs of MySQL 5.6.5, automatic initialization and updating to the current\ndate and time for DATETIME columns can be specified using DEFAULT and\nON UPDATE column definition clauses, as described in\nhttp://dev.mysql.com/doc/refman/5.6/en/timestamp-initialization.html.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/date-and-time-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/date-and-time-type-overview.html'),(274,'INTEGER',23,'INTEGER[(M)] [UNSIGNED] [ZEROFILL]\n\nThis type is a synonym for INT.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/numeric-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/numeric-type-overview.html'),(275,'SHOW COLUMNS',27,'Syntax:\nSHOW [FULL] COLUMNS {FROM | IN} tbl_name [{FROM | IN} db_name]\n    [LIKE \'pattern\' | WHERE expr]\n\nSHOW COLUMNS displays information about the columns in a given table.\nIt also works for views. The LIKE clause, if present, indicates which\ncolumn names to match. The WHERE clause can be given to select rows\nusing more general conditions, as discussed in\nhttp://dev.mysql.com/doc/refman/5.6/en/extended-show.html.\n\nSHOW COLUMNS displays information only for those columns for which you\nhave some privilege.\n\nmysql> SHOW COLUMNS FROM City;\n+------------+----------+------+-----+---------+----------------+\n| Field      | Type     | Null | Key | Default | Extra          |\n+------------+----------+------+-----+---------+----------------+\n| Id         | int(11)  | NO   | PRI | NULL    | auto_increment |\n| Name       | char(35) | NO   |     |         |                |\n| Country    | char(3)  | NO   | UNI |         |                |\n| District   | char(20) | YES  | MUL |         |                |\n| Population | int(11)  | NO   |     | 0       |                |\n+------------+----------+------+-----+---------+----------------+\n5 rows in set (0.00 sec)\n\nIf the data types differ from what you expect them to be based on a\nCREATE TABLE statement, note that MySQL sometimes changes data types\nwhen you create or alter a table. The conditions under which this\noccurs are described in\nhttp://dev.mysql.com/doc/refman/5.6/en/silent-column-changes.html.\n\nThe FULL keyword causes the output to include the column collation and\ncomments, as well as the privileges you have for each column.\n\nYou can use db_name.tbl_name as an alternative to the tbl_name FROM\ndb_name syntax. In other words, these two statements are equivalent:\n\nmysql> SHOW COLUMNS FROM mytable FROM mydb;\nmysql> SHOW COLUMNS FROM mydb.mytable;\n\nSHOW COLUMNS displays the following values for each table column:\n\nField indicates the column name.\n\nType indicates the column data type.\n\nCollation indicates the collation for nonbinary string columns, or NULL\nfor other columns. This value is displayed only if you use the FULL\nkeyword.\n\nThe Null field contains YES if NULL values can be stored in the column,\nNO if not.\n\nThe Key field indicates whether the column is indexed:\n\no If Key is empty, the column either is not indexed or is indexed only\n  as a secondary column in a multiple-column, nonunique index.\n\no If Key is PRI, the column is a PRIMARY KEY or is one of the columns\n  in a multiple-column PRIMARY KEY.\n\no If Key is UNI, the column is the first column of a UNIQUE index. (A\n  UNIQUE index permits multiple NULL values, but you can tell whether\n  the column permits NULL by checking the Null field.)\n\no If Key is MUL, the column is the first column of a nonunique index in\n  which multiple occurrences of a given value are permitted within the\n  column.\n\nIf more than one of the Key values applies to a given column of a\ntable, Key displays the one with the highest priority, in the order\nPRI, UNI, MUL.\n\nA UNIQUE index may be displayed as PRI if it cannot contain NULL values\nand there is no PRIMARY KEY in the table. A UNIQUE index may display as\nMUL if several columns form a composite UNIQUE index; although the\ncombination of the columns is unique, each column can still hold\nmultiple occurrences of a given value.\n\nThe Default field indicates the default value that is assigned to the\ncolumn. This is NULL if the column has an explicit default of NULL, or\nif the column definition has no DEFAULT clause.\n\nThe Extra field contains any additional information that is available\nabout a given column. The value is nonempty in these cases:\nauto_increment for columns that have the AUTO_INCREMENT attribute; on\nupdate CURRENT_TIMESTAMP for TIMESTAMP or DATETIME columns that have\nthe ON UPDATE CURRENT_TIMESTAMP attribute.\n\nPrivileges indicates the privileges you have for the column. This value\nis displayed only if you use the FULL keyword.\n\nComment indicates any comment the column has. This value is displayed\nonly if you use the FULL keyword.\n\nSHOW FIELDS is a synonym for SHOW COLUMNS. You can also list a table\'s\ncolumns with the mysqlshow db_name tbl_name command.\n\nThe DESCRIBE statement provides information similar to SHOW COLUMNS.\nSee http://dev.mysql.com/doc/refman/5.6/en/describe.html.\n\nThe SHOW CREATE TABLE, SHOW TABLE STATUS, and SHOW INDEX statements\nalso provide information about tables. See [HELP SHOW].\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/show-columns.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/show-columns.html'),(276,'TINYINT',23,'TINYINT[(M)] [UNSIGNED] [ZEROFILL]\n\nA very small integer. The signed range is -128 to 127. The unsigned\nrange is 0 to 255.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/numeric-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/numeric-type-overview.html'),(277,'MASTER_POS_WAIT',14,'Syntax:\nMASTER_POS_WAIT(log_name,log_pos[,timeout])\n\nThis function is useful for control of master/slave synchronization. It\nblocks until the slave has read and applied all updates up to the\nspecified position in the master log. The return value is the number of\nlog events the slave had to wait for to advance to the specified\nposition. The function returns NULL if the slave SQL thread is not\nstarted, the slave\'s master information is not initialized, the\narguments are incorrect, or an error occurs. It returns -1 if the\ntimeout has been exceeded. If the slave SQL thread stops while\nMASTER_POS_WAIT() is waiting, the function returns NULL. If the slave\nis past the specified position, the function returns immediately.\n\nIf a timeout value is specified, MASTER_POS_WAIT() stops waiting when\ntimeout seconds have elapsed. timeout must be greater than 0; a zero or\nnegative timeout means no timeout.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/miscellaneous-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/miscellaneous-functions.html'),(278,'^',20,'Syntax:\n^\n\nBitwise XOR:\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/bit-functions.html\n\n','mysql> SELECT 1 ^ 1;\n        -> 0\nmysql> SELECT 1 ^ 0;\n        -> 1\nmysql> SELECT 11 ^ 3;\n        -> 8\n','http://dev.mysql.com/doc/refman/5.6/en/bit-functions.html'),(279,'DROP VIEW',40,'Syntax:\nDROP VIEW [IF EXISTS]\n    view_name [, view_name] ...\n    [RESTRICT | CASCADE]\n\nDROP VIEW removes one or more views. You must have the DROP privilege\nfor each view. If any of the views named in the argument list do not\nexist, MySQL returns an error indicating by name which nonexisting\nviews it was unable to drop, but it also drops all of the views in the\nlist that do exist.\n\nThe IF EXISTS clause prevents an error from occurring for views that\ndon\'t exist. When this clause is given, a NOTE is generated for each\nnonexistent view. See [HELP SHOW WARNINGS].\n\nRESTRICT and CASCADE, if given, are parsed and ignored.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/drop-view.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/drop-view.html'),(280,'WEEK',32,'Syntax:\nWEEK(date[,mode])\n\nThis function returns the week number for date. The two-argument form\nof WEEK() enables you to specify whether the week starts on Sunday or\nMonday and whether the return value should be in the range from 0 to 53\nor from 1 to 53. If the mode argument is omitted, the value of the\ndefault_week_format system variable is used. See\nhttp://dev.mysql.com/doc/refman/5.6/en/server-system-variables.html.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html\n\n','mysql> SELECT WEEK(\'2008-02-20\');\n        -> 7\nmysql> SELECT WEEK(\'2008-02-20\',0);\n        -> 7\nmysql> SELECT WEEK(\'2008-02-20\',1);\n        -> 8\nmysql> SELECT WEEK(\'2008-12-31\',1);\n        -> 53\n','http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html'),(281,'DROP FUNCTION UDF',22,'Syntax:\nDROP FUNCTION function_name\n\nThis statement drops the user-defined function (UDF) named\nfunction_name.\n\nTo drop a function, you must have the DELETE privilege for the mysql\ndatabase. This is because DROP FUNCTION removes a row from the\nmysql.func system table that records the function\'s name, type, and\nshared library name.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/drop-function-udf.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/drop-function-udf.html'),(282,'UPDATEXML',38,'Syntax:\nUpdateXML(xml_target, xpath_expr, new_xml)\n\nThis function replaces a single portion of a given fragment of XML\nmarkup xml_target with a new XML fragment new_xml, and then returns the\nchanged XML. The portion of xml_target that is replaced matches an\nXPath expression xpath_expr supplied by the user. In MySQL 5.6.6 and\nearlier, the XPath expression could contain at most 127 characters.\nThis limitation is lifted in MySQL 5.6.7. (Bug #13007062, Bug #62429)\n\nIf no expression matching xpath_expr is found, or if multiple matches\nare found, the function returns the original xml_target XML fragment.\nAll three arguments should be strings.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/xml-functions.html\n\n','mysql> SELECT\n    ->   UpdateXML(\'<a><b>ccc</b><d></d></a>\', \'/a\', \'<e>fff</e>\') AS val1,\n    ->   UpdateXML(\'<a><b>ccc</b><d></d></a>\', \'/b\', \'<e>fff</e>\') AS val2,\n    ->   UpdateXML(\'<a><b>ccc</b><d></d></a>\', \'//b\', \'<e>fff</e>\') AS val3,\n    ->   UpdateXML(\'<a><b>ccc</b><d></d></a>\', \'/a/d\', \'<e>fff</e>\') AS val4,\n    ->   UpdateXML(\'<a><d></d><b>ccc</b><d></d></a>\', \'/a/d\', \'<e>fff</e>\') AS val5\n    -> \\G\n\n*************************** 1. row ***************************\nval1: <e>fff</e>\nval2: <a><b>ccc</b><d></d></a>\nval3: <a><e>fff</e><d></d></a>\nval4: <a><b>ccc</b><e>fff</e></a>\nval5: <a><d></d><b>ccc</b><d></d></a>\n','http://dev.mysql.com/doc/refman/5.6/en/xml-functions.html'),(283,'RESET SLAVE',8,'Syntax:\nRESET SLAVE [ALL]\n\nRESET SLAVE makes the slave forget its replication position in the\nmaster\'s binary log. This statement is meant to be used for a clean\nstart: It deletes the master.info and relay-log.info files, all the\nrelay log files, and starts a new relay log file. It also resets to 0\nthe replication delay specified with the MASTER_DELAY option to CHANGE\nMASTER TO. To use RESET SLAVE, the slave replication threads must be\nstopped (use STOP SLAVE if necessary).\n\n*Note*: All relay log files are deleted, even if they have not been\ncompletely executed by the slave SQL thread. (This is a condition\nlikely to exist on a replication slave if you have issued a STOP SLAVE\nstatement or if the slave is highly loaded.)\n\nIn MySQL 5.6 (unlike the case in MySQL 5.1 and earlier), RESET SLAVE\ndoes not change any replication connection parameters such as master\nhost, master port, master user, or master password, which are retained\nin memory. This means that START SLAVE can be issued without requiring\na CHANGE MASTER TO statement following RESET SLAVE.\n\nConnection parameters are reset if the slave mysqld is shut down\nfollowing RESET SLAVE. In MySQL 5.6.3 and later, you can instead use\nRESET SLAVE ALL to reset these connection parameters (Bug #11809016).\n\nIn MySQL 5.6.7 and later, RESET SLAVE causes an implicit commit of an\nongoing transaction. See\nhttp://dev.mysql.com/doc/refman/5.6/en/implicit-commit.html.\n\nIf the slave SQL thread was in the middle of replicating temporary\ntables when it was stopped, and RESET SLAVE is issued, these replicated\ntemporary tables are deleted on the slave.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/reset-slave.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/reset-slave.html'),(284,'DAY',32,'Syntax:\nDAY(date)\n\nDAY() is a synonym for DAYOFMONTH().\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html'),(285,'UUID',14,'Syntax:\nUUID()\n\nReturns a Universal Unique Identifier (UUID) generated according to\n\"DCE 1.1: Remote Procedure Call\" (Appendix A) CAE (Common Applications\nEnvironment) Specifications published by The Open Group in October 1997\n(Document Number C706,\nhttp://www.opengroup.org/public/pubs/catalog/c706.htm).\n\nA UUID is designed as a number that is globally unique in space and\ntime. Two calls to UUID() are expected to generate two different\nvalues, even if these calls are performed on two separate computers\nthat are not connected to each other.\n\nA UUID is a 128-bit number represented by a utf8 string of five\nhexadecimal numbers in aaaaaaaa-bbbb-cccc-dddd-eeeeeeeeeeee format:\n\no The first three numbers are generated from a timestamp.\n\no The fourth number preserves temporal uniqueness in case the timestamp\n  value loses monotonicity (for example, due to daylight saving time).\n\no The fifth number is an IEEE 802 node number that provides spatial\n  uniqueness. A random number is substituted if the latter is not\n  available (for example, because the host computer has no Ethernet\n  card, or we do not know how to find the hardware address of an\n  interface on your operating system). In this case, spatial uniqueness\n  cannot be guaranteed. Nevertheless, a collision should have very low\n  probability.\n\n  Currently, the MAC address of an interface is taken into account only\n  on FreeBSD and Linux. On other operating systems, MySQL uses a\n  randomly generated 48-bit number.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/miscellaneous-functions.html\n\n','mysql> SELECT UUID();\n        -> \'6ccd780c-baba-1026-9564-0040f4311e29\'\n','http://dev.mysql.com/doc/refman/5.6/en/miscellaneous-functions.html'),(286,'SLEEP',14,'Syntax:\nSLEEP(duration)\n\nSleeps (pauses) for the number of seconds given by the duration\nargument, then returns 0. If SLEEP() is interrupted, it returns 1. The\nduration may have a fractional part.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/miscellaneous-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/miscellaneous-functions.html'),(287,'LINESTRING',25,'LineString(pt1,pt2,...)\n\nConstructs a LineString value from a number of Point or WKB Point\narguments. If the number of arguments is less than two, the return\nvalue is NULL.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/creating-spatial-values.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/creating-spatial-values.html'),(288,'NULLIF',7,'Syntax:\nNULLIF(expr1,expr2)\n\nReturns NULL if expr1 = expr2 is true, otherwise returns expr1. This is\nthe same as CASE WHEN expr1 = expr2 THEN NULL ELSE expr1 END.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/control-flow-functions.html\n\n','mysql> SELECT NULLIF(1,1);\n        -> NULL\nmysql> SELECT NULLIF(1,2);\n        -> 1\n','http://dev.mysql.com/doc/refman/5.6/en/control-flow-functions.html'),(289,'ROUND',4,'Syntax:\nROUND(X), ROUND(X,D)\n\nRounds the argument X to D decimal places. The rounding algorithm\ndepends on the data type of X. D defaults to 0 if not specified. D can\nbe negative to cause D digits left of the decimal point of the value X\nto become zero.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/mathematical-functions.html\n\n','mysql> SELECT ROUND(-1.23);\n        -> -1\nmysql> SELECT ROUND(-1.58);\n        -> -2\nmysql> SELECT ROUND(1.58);\n        -> 2\nmysql> SELECT ROUND(1.298, 1);\n        -> 1.3\nmysql> SELECT ROUND(1.298, 0);\n        -> 1\nmysql> SELECT ROUND(23.298, -1);\n        -> 20\n','http://dev.mysql.com/doc/refman/5.6/en/mathematical-functions.html'),(290,'TIMEDIFF',32,'Syntax:\nTIMEDIFF(expr1,expr2)\n\nTIMEDIFF() returns expr1 - expr2 expressed as a time value. expr1 and\nexpr2 are time or date-and-time expressions, but both must be of the\nsame type.\n\nThe result returned by TIMEDIFF() is limited to the range allowed for\nTIME values. Alternatively, you can use either of the functions\nTIMESTAMPDIFF() and UNIX_TIMESTAMP(), both of which return integers.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html\n\n','mysql> SELECT TIMEDIFF(\'2000:01:01 00:00:00\',\n    ->                 \'2000:01:01 00:00:00.000001\');\n        -> \'-00:00:00.000001\'\nmysql> SELECT TIMEDIFF(\'2008-12-31 23:59:59.000001\',\n    ->                 \'2008-12-30 01:01:01.000002\');\n        -> \'46:58:57.999999\'\n','http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html'),(291,'STOP SLAVE',8,'Syntax:\nSTOP SLAVE [thread_types]\n\nthread_types:\n    [thread_type [, thread_type] ... ]\n\nthread_type: IO_THREAD | SQL_THREAD\n\nStops the slave threads. STOP SLAVE requires the SUPER privilege.\nRecommended best practice is to execute STOP SLAVE on the slave before\nstopping the slave server (see\nhttp://dev.mysql.com/doc/refman/5.6/en/server-shutdown.html, for more\ninformation).\n\nWhen using the row-based logging format: You should execute STOP SLAVE\nor STOP SLAVE SQL_THREAD on the slave prior to shutting down the slave\nserver if you are replicating any tables that use a nontransactional\nstorage engine (see the Note later in this section).\n\nLike START SLAVE, this statement may be used with the IO_THREAD and\nSQL_THREAD options to name the thread or threads to be stopped.\n\nIn MySQL 5.6.7 and later, STOP SLAVE causes an implicit commit of an\nongoing transaction. See\nhttp://dev.mysql.com/doc/refman/5.6/en/implicit-commit.html.\n\nBeginning with MySQL 5.6.11, gtid_next must be set to AUTOMATIC before\nissuing this statement (Bug #16062608).\n\n*Note*: In MySQL 5.6, STOP SLAVE waits until the current replication\nevent group affecting one or more nontransactional tables has finished\nexecuting (if there is any such replication group), or until the user\nissues a KILL QUERY or KILL CONNECTION statement. (Bug #319, Bug\n#38205)\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/stop-slave.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/stop-slave.html'),(292,'LINEFROMTEXT',3,'LineFromText(wkt[,srid]), LineStringFromText(wkt[,srid])\n\nConstructs a LINESTRING value using its WKT representation and SRID.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/creating-spatial-values.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/creating-spatial-values.html'),(293,'ADDTIME',32,'Syntax:\nADDTIME(expr1,expr2)\n\nADDTIME() adds expr2 to expr1 and returns the result. expr1 is a time\nor datetime expression, and expr2 is a time expression.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html\n\n','mysql> SELECT ADDTIME(\'2007-12-31 23:59:59.999999\', \'1 1:1:1.000002\');\n        -> \'2008-01-02 01:01:01.000001\'\nmysql> SELECT ADDTIME(\'01:00:00.999999\', \'02:00:00.999998\');\n        -> \'03:00:01.999997\'\n','http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html'),(294,'UPPER',38,'Syntax:\nUPPER(str)\n\nReturns the string str with all characters changed to uppercase\naccording to the current character set mapping. The default is latin1\n(cp1252 West European).\n\nmysql> SELECT UPPER(\'Hej\');\n        -> \'HEJ\'\n\nSee the description of LOWER() for information that also applies to\nUPPER(). This included information about how to perform lettercase\nconversion of binary strings (BINARY, VARBINARY, BLOB) for which these\nfunctions are ineffective, and information about case folding for\nUnicode character sets.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/string-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/string-functions.html'),(295,'MEDIUMBLOB',23,'MEDIUMBLOB\n\nA BLOB column with a maximum length of 16,777,215 (224 - 1) bytes. Each\nMEDIUMBLOB value is stored using a 3-byte length prefix that indicates\nthe number of bytes in the value.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/string-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/string-type-overview.html'),(296,'FROM_UNIXTIME',32,'Syntax:\nFROM_UNIXTIME(unix_timestamp), FROM_UNIXTIME(unix_timestamp,format)\n\nReturns a representation of the unix_timestamp argument as a value in\n\'YYYY-MM-DD HH:MM:SS\' or YYYYMMDDHHMMSS format, depending on whether\nthe function is used in a string or numeric context. The value is\nexpressed in the current time zone. unix_timestamp is an internal\ntimestamp value such as is produced by the UNIX_TIMESTAMP() function.\n\nIf format is given, the result is formatted according to the format\nstring, which is used the same way as listed in the entry for the\nDATE_FORMAT() function.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html\n\n','mysql> SELECT FROM_UNIXTIME(1196440219);\n        -> \'2007-11-30 10:30:19\'\nmysql> SELECT FROM_UNIXTIME(1196440219) + 0;\n        -> 20071130103019.000000\nmysql> SELECT FROM_UNIXTIME(UNIX_TIMESTAMP(),\n    ->                      \'%Y %D %M %h:%i:%s %x\');\n        -> \'2007 30th November 10:30:59 2007\'\n','http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html'),(297,'SHA2',12,'Syntax:\nSHA2(str, hash_length)\n\nCalculates the SHA-2 family of hash functions (SHA-224, SHA-256,\nSHA-384, and SHA-512). The first argument is the cleartext string to be\nhashed. The second argument indicates the desired bit length of the\nresult, which must have a value of 224, 256, 384, 512, or 0 (which is\nequivalent to 256). If either argument is NULL or the hash length is\nnot one of the permitted values, the return value is NULL. Otherwise,\nthe function result is a hash value containing the desired number of\nbits. See the notes at the beginning of this section about storing hash\nvalues efficiently.\n\nThe return value is a nonbinary string in the connection character set.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/encryption-functions.html\n\n','mysql> SELECT SHA2(\'abc\', 224);\n        -> \'23097d223405d8228642a477bda255b32aadbce4bda0b3f7e36c9da7\'\n','http://dev.mysql.com/doc/refman/5.6/en/encryption-functions.html'),(298,'IFNULL',7,'Syntax:\nIFNULL(expr1,expr2)\n\nIf expr1 is not NULL, IFNULL() returns expr1; otherwise it returns\nexpr2. IFNULL() returns a numeric or string value, depending on the\ncontext in which it is used.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/control-flow-functions.html\n\n','mysql> SELECT IFNULL(1,0);\n        -> 1\nmysql> SELECT IFNULL(NULL,10);\n        -> 10\nmysql> SELECT IFNULL(1/0,10);\n        -> 10\nmysql> SELECT IFNULL(1/0,\'yes\');\n        -> \'yes\'\n','http://dev.mysql.com/doc/refman/5.6/en/control-flow-functions.html'),(299,'SHOW FUNCTION CODE',27,'Syntax:\nSHOW FUNCTION CODE func_name\n\nThis statement is similar to SHOW PROCEDURE CODE but for stored\nfunctions. See [HELP SHOW PROCEDURE CODE].\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/show-function-code.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/show-function-code.html'),(300,'LEAST',19,'Syntax:\nLEAST(value1,value2,...)\n\nWith two or more arguments, returns the smallest (minimum-valued)\nargument. The arguments are compared using the following rules:\n\no If any argument is NULL, the result is NULL. No comparison is needed.\n\no If the return value is used in an INTEGER context or all arguments\n  are integer-valued, they are compared as integers.\n\no If the return value is used in a REAL context or all arguments are\n  real-valued, they are compared as reals.\n\no If the arguments comprise a mix of numbers and strings, they are\n  compared as numbers.\n\no If any argument is a nonbinary (character) string, the arguments are\n  compared as nonbinary strings.\n\no In all other cases, the arguments are compared as binary strings.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/comparison-operators.html\n\n','mysql> SELECT LEAST(2,0);\n        -> 0\nmysql> SELECT LEAST(34.0,3.0,5.0,767.0);\n        -> 3.0\nmysql> SELECT LEAST(\'B\',\'A\',\'C\');\n        -> \'A\'\n','http://dev.mysql.com/doc/refman/5.6/en/comparison-operators.html'),(301,'SHOW ERRORS',27,'Syntax:\nSHOW ERRORS [LIMIT [offset,] row_count]\nSHOW COUNT(*) ERRORS\n\nThis statement is similar to SHOW WARNINGS, except that it displays\ninformation only for errors, rather than for errors, warnings, and\nnotes.\n\nThe LIMIT clause has the same syntax as for the SELECT statement. See\nhttp://dev.mysql.com/doc/refman/5.6/en/select.html.\n\nThe SHOW COUNT(*) ERRORS statement displays the number of errors. You\ncan also retrieve this number from the error_count variable:\n\nSHOW COUNT(*) ERRORS;\nSELECT @@error_count;\n\nSHOW ERRORS and error_count apply only to errors, not warnings or\nnotes. In other respects, they are similar to SHOW WARNINGS and\nwarning_count. In particular, SHOW ERRORS cannot display information\nfor more than max_error_count messages, and error_count can exceed the\nvalue of max_error_count if the number of errors exceeds\nmax_error_count.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/show-errors.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/show-errors.html'),(302,'=',19,'=\n\nEqual:\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/comparison-operators.html\n\n','mysql> SELECT 1 = 0;\n        -> 0\nmysql> SELECT \'0\' = 0;\n        -> 1\nmysql> SELECT \'0.0\' = 0;\n        -> 1\nmysql> SELECT \'0.01\' = 0;\n        -> 0\nmysql> SELECT \'.01\' = 0.01;\n        -> 1\n','http://dev.mysql.com/doc/refman/5.6/en/comparison-operators.html'),(303,'IS_IPV4_MAPPED',14,'Syntax:\nIS_IPV4_MAPPED(expr)\n\nThis function takes an IPv6 address represented in numeric form as a\nbinary string, as returned by INET6_ATON(). It returns 1 if the\nargument is a valid IPv4-mapped IPv6 address, 0 otherwise. IPv4-mapped\naddresses have the form ::ffff:ipv4_address.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/miscellaneous-functions.html\n\n','mysql> SELECT IS_IPV4_MAPPED(INET6_ATON(\'::10.0.5.9\'));\n        -> 0\nmysql> SELECT IS_IPV4_MAPPED(INET6_ATON(\'::ffff:10.0.5.9\'));\n        -> 1\n','http://dev.mysql.com/doc/refman/5.6/en/miscellaneous-functions.html'),(304,'BOUNDARY',37,'Boundary(g)\n\nReturns a geometry that is the closure of the combinatorial boundary of\nthe geometry value g.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/geometry-property-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/geometry-property-functions.html'),(305,'CREATE USER',10,'Syntax:\nCREATE USER user_specification\n    [, user_specification] ...\n\nuser_specification:\n    user\n    [\n        IDENTIFIED BY [PASSWORD] \'password\'\n      | IDENTIFIED WITH auth_plugin [AS \'auth_string\']\n    ]\n\nThe CREATE USER statement creates new MySQL accounts. To use it, you\nmust have the global CREATE USER privilege or the INSERT privilege for\nthe mysql database. For each account, CREATE USER creates a new row in\nthe mysql.user table and assigns the account no privileges. An error\noccurs if the account already exists.\n\nFor CREATE USER statements that do not specify an IDENTIFIED WITH\nauth_plugin clause, the server associates the account with the default\nauthentication plugin. As of MySQL 5.6.6, this is the plugin named by\nthe --default-authentication-plugin option at server startup, or\nmysql_native_password if that option is not used. Before 5.6.6, the\ndefault plugin is mysql_native_password. For information about\nauthentication plugins, see\nhttp://dev.mysql.com/doc/refman/5.6/en/pluggable-authentication.html.\n\nEach account name uses the format described in\nhttp://dev.mysql.com/doc/refman/5.6/en/account-names.html. For example:\n\nCREATE USER \'jeffrey\'@\'localhost\' IDENTIFIED BY \'mypass\';\n\nIf you specify only the user name part of the account name, a host name\npart of \'%\' is used.\n\nThe user specification may indicate how the user should authenticate\nwhen connecting to the server:\n\no To enable the user to connect with no password (which is insecure),\n  include no IDENTIFIED BY clause:\n\nCREATE USER \'jeffrey\'@\'localhost\';\n\n  In this case, the account uses the default authentication plugin and\n  clients must provide no password.\n\no To assign a password, use IDENTIFIED BY with the literal plaintext\n  password value:\n\nCREATE USER \'jeffrey\'@\'localhost\' IDENTIFIED BY \'mypass\';\n\n  The account uses the default authentication plugin and clients must\n  match the given password.\n\no To avoid specifying the plaintext password if you know its hash value\n  (the value that PASSWORD() would return for the password), specify\n  the hash value preceded by the keyword PASSWORD:\n\nCREATE USER \'jeffrey\'@\'localhost\'\nIDENTIFIED BY PASSWORD \'*90E462C37378CED12064BB3388827D2BA3A9B689\';\n\n  The account uses the default authentication plugin and the has must\n  be in the format required by that plugin. Clients must match the\n  given password.\n\no To authenticate the account using a specific authentication plugin,\n  use IDENTIFIED WITH, where auth_plugin is the plugin name. It can be\n  an unquoted name or a quoted string literal. \'auth_string\' is an\n  optional quoted string literal to pass to the plugin. The plugin\n  interprets the meaning of the string, so its format is plugin\n  specific. Consult the documentation for a given plugin for\n  information about the authentication string values it accepts.\n\nCREATE USER \'jeffrey\'@\'localhost\'\nIDENTIFIED WITH my_auth_plugin;\n\n  For connections that use this account, the server invokes the named\n  plugin and clients must provide credentials as required for the\n  authentication method that the plugin implements. If the server\n  cannot find the plugin, either at account-creation time or connect\n  time, an error occurs.\n\nThe IDENTIFIED BY and IDENTIFIED WITH clauses are mutually exclusive,\nso at most one of them can be specified for a given user.\n\nFor additional information about setting passwords, see\nhttp://dev.mysql.com/doc/refman/5.6/en/assigning-passwords.html.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/create-user.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/create-user.html'),(306,'POINT',25,'Point(x,y)\n\nConstructs a Point using its coordinates.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/creating-spatial-values.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/creating-spatial-values.html'),(307,'LCASE',38,'Syntax:\nLCASE(str)\n\nLCASE() is a synonym for LOWER().\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/string-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/string-functions.html'),(308,'IS NOT NULL',19,'Syntax:\nIS NOT NULL\n\nTests whether a value is not NULL.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/comparison-operators.html\n\n','mysql> SELECT 1 IS NOT NULL, 0 IS NOT NULL, NULL IS NOT NULL;\n        -> 1, 1, 0\n','http://dev.mysql.com/doc/refman/5.6/en/comparison-operators.html'),(309,'MATCH AGAINST',38,'Syntax:\nMATCH (col1,col2,...) AGAINST (expr [search_modifier])\n\nMySQL has support for full-text indexing and searching:\n\no A full-text index in MySQL is an index of type FULLTEXT.\n\no Full-text indexes can be used only with InnoDB or MyISAM tables, and\n  can be created only for CHAR, VARCHAR, or TEXT columns.\n\no A FULLTEXT index definition can be given in the CREATE TABLE\n  statement when a table is created, or added later using ALTER TABLE\n  or CREATE INDEX.\n\no For large data sets, it is much faster to load your data into a table\n  that has no FULLTEXT index and then create the index after that, than\n  to load data into a table that has an existing FULLTEXT index.\n\nFull-text searching is performed using MATCH() ... AGAINST syntax.\nMATCH() takes a comma-separated list that names the columns to be\nsearched. AGAINST takes a string to search for, and an optional\nmodifier that indicates what type of search to perform. The search\nstring must be a string value that is constant during query evaluation.\nThis rules out, for example, a table column because that can differ for\neach row.\n\nThere are three types of full-text searches:\n\no A natural language search interprets the search string as a phrase in\n  natural human language (a phrase in free text). There are no special\n  operators. The stopword list applies, controlled by\n  innodb_ft_enable_stopword, innodb_ft_server_stopword_table, and\n  innodb_ft_user_stopword_table for InnoDB search indexes, and\n  ft_stopword_file for MyISAM ones.\n\no Full-text searches are natural language searches if the IN NATURAL\n  LANGUAGE MODE modifier is given or if no modifier is given. For more\n  information, see\n  http://dev.mysql.com/doc/refman/5.6/en/fulltext-natural-language.html\n  .\n\no A boolean search interprets the search string using the rules of a\n  special query language. The string contains the words to search for.\n  It can also contain operators that specify requirements such that a\n  word must be present or absent in matching rows, or that it should be\n  weighted higher or lower than usual. Certain common words (stopwords)\n  are omitted from the search index and do not match if present in the\n  search string. The IN BOOLEAN MODE modifier specifies a boolean\n  search. For more information, see\n  http://dev.mysql.com/doc/refman/5.6/en/fulltext-boolean.html.\n\no A query expansion search is a modification of a natural language\n  search. The search string is used to perform a natural language\n  search. Then words from the most relevant rows returned by the search\n  are added to the search string and the search is done again. The\n  query returns the rows from the second search. The IN NATURAL\n  LANGUAGE MODE WITH QUERY EXPANSION or WITH QUERY EXPANSION modifier\n  specifies a query expansion search. For more information, see\n  http://dev.mysql.com/doc/refman/5.6/en/fulltext-query-expansion.html.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/fulltext-search.html\n\n','mysql> SELECT id, body, MATCH (title,body) AGAINST\n    (\'Security implications of running MySQL as root\'\n    IN NATURAL LANGUAGE MODE) AS score\n    FROM articles WHERE MATCH (title,body) AGAINST\n    (\'Security implications of running MySQL as root\'\n    IN NATURAL LANGUAGE MODE);\n+----+-----------------------+------------------------------------------+\n| id | title                 | body                                     |\n+----+-----------------------+------------------------------------------+\n|  5 | MySQL vs. YourSQL     | In the following database comparison ... |\n|  1 | MySQL Tutorial        | DBMS stands for DataBase ...             |\n|  3 | Optimizing MySQL      | In this tutorial we will show ...        |\n|  6 | MySQL Security        | When configured properly, MySQL ...      |\n|  2 | How To Use MySQL Well | After you went through a ...             |\n|  4 | 1001 MySQL Tricks     | 1. Never run mysqld as root. 2. ...      |\n+----+-----------------------+------------------------------------------+\n6 rows in set (0.00 sec)\n','http://dev.mysql.com/doc/refman/5.6/en/fulltext-search.html'),(310,'CREATE EVENT',40,'Syntax:\nCREATE\n    [DEFINER = { user | CURRENT_USER }]\n    EVENT\n    [IF NOT EXISTS]\n    event_name\n    ON SCHEDULE schedule\n    [ON COMPLETION [NOT] PRESERVE]\n    [ENABLE | DISABLE | DISABLE ON SLAVE]\n    [COMMENT \'comment\']\n    DO event_body;\n\nschedule:\n    AT timestamp [+ INTERVAL interval] ...\n  | EVERY interval\n    [STARTS timestamp [+ INTERVAL interval] ...]\n    [ENDS timestamp [+ INTERVAL interval] ...]\n\ninterval:\n    quantity {YEAR | QUARTER | MONTH | DAY | HOUR | MINUTE |\n              WEEK | SECOND | YEAR_MONTH | DAY_HOUR | DAY_MINUTE |\n              DAY_SECOND | HOUR_MINUTE | HOUR_SECOND | MINUTE_SECOND}\n\nThis statement creates and schedules a new event. The event will not\nrun unless the Event Scheduler is enabled. For information about\nchecking Event Scheduler status and enabling it if necessary, see\nhttp://dev.mysql.com/doc/refman/5.6/en/events-configuration.html.\n\nCREATE EVENT requires the EVENT privilege for the schema in which the\nevent is to be created. It might also require the SUPER privilege,\ndepending on the DEFINER value, as described later in this section.\n\nThe minimum requirements for a valid CREATE EVENT statement are as\nfollows:\n\no The keywords CREATE EVENT plus an event name, which uniquely\n  identifies the event in a database schema.\n\no An ON SCHEDULE clause, which determines when and how often the event\n  executes.\n\no A DO clause, which contains the SQL statement to be executed by an\n  event.\n\nThis is an example of a minimal CREATE EVENT statement:\n\nCREATE EVENT myevent\n    ON SCHEDULE AT CURRENT_TIMESTAMP + INTERVAL 1 HOUR\n    DO\n      UPDATE myschema.mytable SET mycol = mycol + 1;\n\nThe previous statement creates an event named myevent. This event\nexecutes once---one hour following its creation---by running an SQL\nstatement that increments the value of the myschema.mytable table\'s\nmycol column by 1.\n\nThe event_name must be a valid MySQL identifier with a maximum length\nof 64 characters. Event names are not case sensitive, so you cannot\nhave two events named myevent and MyEvent in the same schema. In\ngeneral, the rules governing event names are the same as those for\nnames of stored routines. See\nhttp://dev.mysql.com/doc/refman/5.6/en/identifiers.html.\n\nAn event is associated with a schema. If no schema is indicated as part\nof event_name, the default (current) schema is assumed. To create an\nevent in a specific schema, qualify the event name with a schema using\nschema_name.event_name syntax.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/create-event.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/create-event.html'),(311,'MBR DEFINITION',6,'Its MBR (Minimum Bounding Rectangle), or Envelope. This is the bounding\ngeometry, formed by the minimum and maximum (X,Y) coordinates:\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/gis-class-geometry.html\n\n','((MINX MINY, MAXX MINY, MAXX MAXY, MINX MAXY, MINX MINY))\n','http://dev.mysql.com/doc/refman/5.6/en/gis-class-geometry.html'),(312,'GEOMETRYCOLLECTION',25,'GeometryCollection(g1,g2,...)\n\nConstructs a GeometryCollection.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/creating-spatial-values.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/creating-spatial-values.html'),(313,'*',4,'Syntax:\n*\n\nMultiplication:\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/arithmetic-functions.html\n\n','mysql> SELECT 3*5;\n        -> 15\nmysql> SELECT 18014398509481984*18014398509481984.0;\n        -> 324518553658426726783156020576256.0\nmysql> SELECT 18014398509481984*18014398509481984;\n        -> out-of-range error\n','http://dev.mysql.com/doc/refman/5.6/en/arithmetic-functions.html'),(314,'DES_DECRYPT',12,'Syntax:\nDES_DECRYPT(crypt_str[,key_str])\n\nDecrypts a string encrypted with DES_ENCRYPT(). If an error occurs,\nthis function returns NULL.\n\nThis function works only if MySQL has been configured with SSL support.\nSee http://dev.mysql.com/doc/refman/5.6/en/ssl-connections.html.\n\nIf no key_str argument is given, DES_DECRYPT() examines the first byte\nof the encrypted string to determine the DES key number that was used\nto encrypt the original string, and then reads the key from the DES key\nfile to decrypt the message. For this to work, the user must have the\nSUPER privilege. The key file can be specified with the --des-key-file\nserver option.\n\nIf you pass this function a key_str argument, that string is used as\nthe key for decrypting the message.\n\nIf the crypt_str argument does not appear to be an encrypted string,\nMySQL returns the given crypt_str.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/encryption-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/encryption-functions.html'),(315,'ENDPOINT',13,'EndPoint(ls)\n\nReturns the Point that is the endpoint of the LineString value ls.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/geometry-property-functions.html\n\n','mysql> SET @ls = \'LineString(1 1,2 2,3 3)\';\nmysql> SELECT AsText(EndPoint(GeomFromText(@ls)));\n+-------------------------------------+\n| AsText(EndPoint(GeomFromText(@ls))) |\n+-------------------------------------+\n| POINT(3 3)                          |\n+-------------------------------------+\n','http://dev.mysql.com/doc/refman/5.6/en/geometry-property-functions.html'),(316,'COUNT',16,'Syntax:\nCOUNT(expr)\n\nReturns a count of the number of non-NULL values of expr in the rows\nretrieved by a SELECT statement. The result is a BIGINT value.\n\nCOUNT() returns 0 if there were no matching rows.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/group-by-functions.html\n\n','mysql> SELECT student.student_name,COUNT(*)\n    ->        FROM student,course\n    ->        WHERE student.student_id=course.student_id\n    ->        GROUP BY student_name;\n','http://dev.mysql.com/doc/refman/5.6/en/group-by-functions.html'),(317,'INSERT',28,'Syntax:\nINSERT [LOW_PRIORITY | DELAYED | HIGH_PRIORITY] [IGNORE]\n    [INTO] tbl_name\n    [PARTITION (partition_name,...)] \n    [(col_name,...)]\n    {VALUES | VALUE} ({expr | DEFAULT},...),(...),...\n    [ ON DUPLICATE KEY UPDATE\n      col_name=expr\n        [, col_name=expr] ... ]\n\nOr:\n\nINSERT [LOW_PRIORITY | DELAYED | HIGH_PRIORITY] [IGNORE]\n    [INTO] tbl_name\n    [PARTITION (partition_name,...)]\n    SET col_name={expr | DEFAULT}, ...\n    [ ON DUPLICATE KEY UPDATE\n      col_name=expr\n        [, col_name=expr] ... ]\n\nOr:\n\nINSERT [LOW_PRIORITY | HIGH_PRIORITY] [IGNORE]\n    [INTO] tbl_name\n    [PARTITION (partition_name,...)] \n    [(col_name,...)]\n    SELECT ...\n    [ ON DUPLICATE KEY UPDATE\n      col_name=expr\n        [, col_name=expr] ... ]\n\nINSERT inserts new rows into an existing table. The INSERT ... VALUES\nand INSERT ... SET forms of the statement insert rows based on\nexplicitly specified values. The INSERT ... SELECT form inserts rows\nselected from another table or tables. INSERT ... SELECT is discussed\nfurther in [HELP INSERT SELECT].\n\nIn MySQL 5.6.2 and later, when inserting into a partitioned table, you\ncan control which partitions and subpartitions accept new rows. The\nPARTITION option takes a comma-separated list of the names of one or\nmore partitions or subpartitions (or both) of the table. If any of the\nrows to be inserted by a given INSERT statement do not match one of the\npartitions listed, the INSERT statement fails with the error Found a\nrow not matching the given partition set. See\nhttp://dev.mysql.com/doc/refman/5.6/en/partitioning-selection.html, for\nmore information and examples.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/insert.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/insert.html'),(318,'MLINEFROMTEXT',3,'MLineFromText(wkt[,srid]), MultiLineStringFromText(wkt[,srid])\n\nConstructs a MULTILINESTRING value using its WKT representation and\nSRID.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/creating-spatial-values.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/creating-spatial-values.html'),(319,'GEOMCOLLFROMWKB',33,'GeomCollFromWKB(wkb[,srid]), GeometryCollectionFromWKB(wkb[,srid])\n\nConstructs a GEOMETRYCOLLECTION value using its WKB representation and\nSRID.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/creating-spatial-values.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/creating-spatial-values.html'),(320,'TINYTEXT',23,'TINYTEXT [CHARACTER SET charset_name] [COLLATE collation_name]\n\nA TEXT column with a maximum length of 255 (28 - 1) characters. The\neffective maximum length is less if the value contains multi-byte\ncharacters. Each TINYTEXT value is stored using a 1-byte length prefix\nthat indicates the number of bytes in the value.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/string-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/string-type-overview.html'),(321,'DEFAULT',14,'Syntax:\nDEFAULT(col_name)\n\nReturns the default value for a table column. An error results if the\ncolumn has no default value.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/miscellaneous-functions.html\n\n','mysql> UPDATE t SET i = DEFAULT(i)+1 WHERE id < 100;\n','http://dev.mysql.com/doc/refman/5.6/en/miscellaneous-functions.html'),(322,'DECODE',12,'Syntax:\nDECODE(crypt_str,pass_str)\n\nDecrypts the encrypted string crypt_str using pass_str as the password.\ncrypt_str should be a string returned from ENCODE().\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/encryption-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/encryption-functions.html'),(323,'OPTIMIZE TABLE',21,'Syntax:\nOPTIMIZE [NO_WRITE_TO_BINLOG | LOCAL] TABLE\n    tbl_name [, tbl_name] ...\n\nReorganizes the physical storage of table data and associated index\ndata, to reduce storage space and improve I/O efficiency when accessing\nthe table. The exact changes made to each table depend on the storage\nengine used by that table.\n\nUse OPTIMIZE TABLE in these cases, depending on the type of table:\n\no After doing substantial insert, update, or delete operations on an\n  InnoDB table that has its own .ibd file because it was created with\n  the innodb_file_per_table option enabled. The table and indexes are\n  reorganized, and disk space can be reclaimed for use by the operating\n  system.\n\no After doing substantial insert, update, or delete operations on\n  columns that are part of a FULLTEXT index in an InnoDB table. Set the\n  configuration option innodb_optimize_fulltext_only=1 first. To keep\n  the index maintenance period to a reasonable time, set the\n  innodb_ft_num_word_optimize option to specify how many words to\n  update in the search index, and run a sequence of OPTIMIZE TABLE\n  statements until the search index is fully updated.\n\no After deleting a large part of a MyISAM or ARCHIVE table, or making\n  many changes to a MyISAM or ARCHIVE table with variable-length rows\n  (tables that have VARCHAR, VARBINARY, BLOB, or TEXT columns). Deleted\n  rows are maintained in a linked list and subsequent INSERT operations\n  reuse old row positions. You can use OPTIMIZE TABLE to reclaim the\n  unused space and to defragment the data file. After extensive changes\n  to a table, this statement may also improve performance of statements\n  that use the table, sometimes significantly.\n\nThis statement requires SELECT and INSERT privileges for the table.\n\nOPTIMIZE TABLE is also supported for partitioned tables. For\ninformation about using this statement with partitioned tables and\ntable partitions, see\nhttp://dev.mysql.com/doc/refman/5.6/en/partitioning-maintenance.html.\n\nIn MySQL 5.6.11 only, gtid_next must be set to AUTOMATIC before issuing\nthis statement. (Bug #16062608, Bug #16715809, Bug #69045)\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/optimize-table.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/optimize-table.html'),(324,'<=>',19,'Syntax:\n<=>\n\nNULL-safe equal. This operator performs an equality comparison like the\n= operator, but returns 1 rather than NULL if both operands are NULL,\nand 0 rather than NULL if one operand is NULL.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/comparison-operators.html\n\n','mysql> SELECT 1 <=> 1, NULL <=> NULL, 1 <=> NULL;\n        -> 1, 1, 0\nmysql> SELECT 1 = 1, NULL = NULL, 1 = NULL;\n        -> 1, NULL, NULL\n','http://dev.mysql.com/doc/refman/5.6/en/comparison-operators.html'),(325,'RESET',27,'Syntax:\nRESET reset_option [, reset_option] ...\n\nThe RESET statement is used to clear the state of various server\noperations. You must have the RELOAD privilege to execute RESET.\n\nRESET acts as a stronger version of the FLUSH statement. See [HELP\nFLUSH].\n\nThe RESET statement causes an implicit commit. See\nhttp://dev.mysql.com/doc/refman/5.6/en/implicit-commit.html.\n\nIn MySQL 5.6.11 only, gtid_next must be set to AUTOMATIC before issuing\nthis statement. (Bug #16062608, Bug #16715809, Bug #69045)\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/reset.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/reset.html'),(326,'GET_LOCK',14,'Syntax:\nGET_LOCK(str,timeout)\n\nTries to obtain a lock with a name given by the string str, using a\ntimeout of timeout seconds. Returns 1 if the lock was obtained\nsuccessfully, 0 if the attempt timed out (for example, because another\nclient has previously locked the name), or NULL if an error occurred\n(such as running out of memory or the thread was killed with mysqladmin\nkill). If you have a lock obtained with GET_LOCK(), it is released when\nyou execute RELEASE_LOCK(), execute a new GET_LOCK(), or your\nconnection terminates (either normally or abnormally). Locks obtained\nwith GET_LOCK() do not interact with transactions. That is, committing\na transaction does not release any such locks obtained during the\ntransaction.\n\nThis function can be used to implement application locks or to simulate\nrecord locks. Names are locked on a server-wide basis. If a name has\nbeen locked by one client, GET_LOCK() blocks any request by another\nclient for a lock with the same name. This enables clients that agree\non a given lock name to use the name to perform cooperative advisory\nlocking. But be aware that it also enables a client that is not among\nthe set of cooperating clients to lock a name, either inadvertently or\ndeliberately, and thus prevent any of the cooperating clients from\nlocking that name. One way to reduce the likelihood of this is to use\nlock names that are database-specific or application-specific. For\nexample, use lock names of the form db_name.str or app_name.str.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/miscellaneous-functions.html\n\n','mysql> SELECT GET_LOCK(\'lock1\',10);\n        -> 1\nmysql> SELECT IS_FREE_LOCK(\'lock2\');\n        -> 1\nmysql> SELECT GET_LOCK(\'lock2\',10);\n        -> 1\nmysql> SELECT RELEASE_LOCK(\'lock2\');\n        -> 1\nmysql> SELECT RELEASE_LOCK(\'lock1\');\n        -> NULL\n','http://dev.mysql.com/doc/refman/5.6/en/miscellaneous-functions.html'),(327,'BIGINT',23,'BIGINT[(M)] [UNSIGNED] [ZEROFILL]\n\nA large integer. The signed range is -9223372036854775808 to\n9223372036854775807. The unsigned range is 0 to 18446744073709551615.\n\nSERIAL is an alias for BIGINT UNSIGNED NOT NULL AUTO_INCREMENT UNIQUE.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/numeric-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/numeric-type-overview.html'),(328,'CURTIME',32,'Syntax:\nCURTIME([fsp])\n\nReturns the current time as a value in \'HH:MM:SS\' or HHMMSS format,\ndepending on whether the function is used in a string or numeric\ncontext. The value is expressed in the current time zone.\n\nAs of MySQL 5.6.4, if the fsp argument is given to specify a fractional\nseconds precision from 0 to 6, the return value includes a fractional\nseconds part of that many digits. Before 5.6.4, any argument is\nignored.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html\n\n','mysql> SELECT CURTIME();\n        -> \'23:50:26\'\nmysql> SELECT CURTIME() + 0;\n        -> 235026.000000\n','http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html'),(329,'SET',27,'Syntax:\nSET variable_assignment [, variable_assignment] ...\n\nvariable_assignment:\n      user_var_name = expr\n    | [GLOBAL | SESSION] system_var_name = expr\n    | [@@global. | @@session. | @@]system_var_name = expr\n\nThe SET statement assigns values to different types of variables that\naffect the operation of the server or your client.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/set-statement.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/set-statement.html'),(330,'TO_BASE64()',38,'Syntax:\nTO_BASE64(str)\n\nConverts the string argument to base-64 encoded form and returns the\nresult as a character string with the connection character set and\ncollation. If the argument is not a string, it is converted to a string\nbefore conversion takes place. The result is NULL if the argument is\nNULL. Base-64 encoded strings can be decoded using the the\nFROM_BASE64() function.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/string-functions.html\n\n','mysql> SELECT TO_BASE64(\'abc\'), FROM_BASE64(TO_BASE64(\'abc\'));\n        -> \'JWJj\', \'abc\'\n','http://dev.mysql.com/doc/refman/5.6/en/string-functions.html'),(331,'CONV',4,'Syntax:\nCONV(N,from_base,to_base)\n\nConverts numbers between different number bases. Returns a string\nrepresentation of the number N, converted from base from_base to base\nto_base. Returns NULL if any argument is NULL. The argument N is\ninterpreted as an integer, but may be specified as an integer or a\nstring. The minimum base is 2 and the maximum base is 36. If to_base is\na negative number, N is regarded as a signed number. Otherwise, N is\ntreated as unsigned. CONV() works with 64-bit precision.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/mathematical-functions.html\n\n','mysql> SELECT CONV(\'a\',16,2);\n        -> \'1010\'\nmysql> SELECT CONV(\'6E\',18,8);\n        -> \'172\'\nmysql> SELECT CONV(-17,10,-18);\n        -> \'-H\'\nmysql> SELECT CONV(10+\'10\'+\'10\'+0xa,10,10);\n        -> \'40\'\n','http://dev.mysql.com/doc/refman/5.6/en/mathematical-functions.html'),(332,'LOAD XML',28,'Syntax:\nLOAD XML [LOW_PRIORITY | CONCURRENT] [LOCAL] INFILE \'file_name\'\n    [REPLACE | IGNORE]\n    INTO TABLE [db_name.]tbl_name\n    [PARTITION (partition_name,...)]\n    [CHARACTER SET charset_name]\n    [ROWS IDENTIFIED BY \'<tagname>\']\n    [IGNORE number {LINES | ROWS}]\n    [(column_or_user_var,...)]\n    [SET col_name = expr,...]\n\nThe LOAD XML statement reads data from an XML file into a table. The\nfile_name must be given as a literal string. The tagname in the\noptional ROWS IDENTIFIED BY clause must also be given as a literal\nstring, and must be surrounded by angle brackets (< and >).\n\nLOAD XML acts as the complement of running the mysql client in XML\noutput mode (that is, starting the client with the --xml option). To\nwrite data from a table to an XML file, use a command such as the\nfollowing one from the system shell:\n\nshell> mysql --xml -e \'SELECT * FROM mytable\' > file.xml\n\nTo read the file back into a table, use LOAD XML INFILE. By default,\nthe <row> element is considered to be the equivalent of a database\ntable row; this can be changed using the ROWS IDENTIFIED BY clause.\n\nThis statement supports three different XML formats:\n\no Column names as attributes and column values as attribute values:\n\n<row column1=\"value1\" column2=\"value2\" .../>\n\no Column names as tags and column values as the content of these tags:\n\n<row>\n  <column1>value1</column1>\n  <column2>value2</column2>\n</row>\n\no Column names are the name attributes of <field> tags, and values are\n  the contents of these tags:\n\n<row>\n  <field name=\'column1\'>value1</field>\n  <field name=\'column2\'>value2</field>\n</row>\n\n  This is the format used by other MySQL tools, such as mysqldump.\n\nAll 3 formats can be used in the same XML file; the import routine\nautomatically detects the format for each row and interprets it\ncorrectly. Tags are matched based on the tag or attribute name and the\ncolumn name.\n\nThe following clauses work essentially the same way for LOAD XML as\nthey do for LOAD DATA:\n\no LOW_PRIORITY or CONCURRENT\n\no LOCAL\n\no REPLACE or IGNORE\n\no PARTITION\n\no CHARACTER SET\n\no (column_or_user_var,...)\n\no SET\n\nSee [HELP LOAD DATA], for more information about these clauses.\n\nThe IGNORE number LINES or IGNORE number ROWS clause causes the first\nnumber rows in the XML file to be skipped. It is analogous to the LOAD\nDATA statement\'s IGNORE ... LINES clause.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/load-xml.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/load-xml.html'),(333,'ASSIGN-VALUE',15,'Syntax:\n:=\n\nAssignment operator. Causes the user variable on the left hand side of\nthe operator to take on the value to its right. The value on the right\nhand side may be a literal value, another variable storing a value, or\nany legal expression that yields a scalar value, including the result\nof a query (provided that this value is a scalar value). You can\nperform multiple assignments in the same SET statement. You can perform\nmultiple assignments in the same statement-\n\nUnlike =, the := operator is never interpreted as a comparison\noperator. This means you can use := in any valid SQL statement (not\njust in SET statements) to assign a value to a variable.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/assignment-operators.html\n\n','mysql> SELECT @var1, @var2;\n        -> NULL, NULL\nmysql> SELECT @var1 := 1, @var2;\n        -> 1, NULL\nmysql> SELECT @var1, @var2;\n        -> 1, NULL\nmysql> SELECT @var1, @var2 := @var1;\n        -> 1, 1\nmysql> SELECT @var1, @var2;\n        -> 1, 1\n\nmysql> SELECT @var1:=COUNT(*) FROM t1;\n        -> 4\nmysql> SELECT @var1;\n        -> 4\n','http://dev.mysql.com/doc/refman/5.6/en/assignment-operators.html'),(334,'SHOW OPEN TABLES',27,'Syntax:\nSHOW OPEN TABLES [{FROM | IN} db_name]\n    [LIKE \'pattern\' | WHERE expr]\n\nSHOW OPEN TABLES lists the non-TEMPORARY tables that are currently open\nin the table cache. See\nhttp://dev.mysql.com/doc/refman/5.6/en/table-cache.html. The FROM\nclause, if present, restricts the tables shown to those present in the\ndb_name database. The LIKE clause, if present, indicates which table\nnames to match. The WHERE clause can be given to select rows using more\ngeneral conditions, as discussed in\nhttp://dev.mysql.com/doc/refman/5.6/en/extended-show.html.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/show-open-tables.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/show-open-tables.html'),(335,'EXTRACT',32,'Syntax:\nEXTRACT(unit FROM date)\n\nThe EXTRACT() function uses the same kinds of unit specifiers as\nDATE_ADD() or DATE_SUB(), but extracts parts from the date rather than\nperforming date arithmetic.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html\n\n','mysql> SELECT EXTRACT(YEAR FROM \'2009-07-02\');\n       -> 2009\nmysql> SELECT EXTRACT(YEAR_MONTH FROM \'2009-07-02 01:02:03\');\n       -> 200907\nmysql> SELECT EXTRACT(DAY_MINUTE FROM \'2009-07-02 01:02:03\');\n       -> 20102\nmysql> SELECT EXTRACT(MICROSECOND\n    ->                FROM \'2003-01-02 10:30:00.000123\');\n        -> 123\n','http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html'),(336,'ENCRYPT',12,'Syntax:\nENCRYPT(str[,salt])\n\nEncrypts str using the Unix crypt() system call and returns a binary\nstring. The salt argument must be a string with at least two characters\nor the result will be NULL. If no salt argument is given, a random\nvalue is used.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/encryption-functions.html\n\n','mysql> SELECT ENCRYPT(\'hello\');\n        -> \'VxuFAJXVARROc\'\n','http://dev.mysql.com/doc/refman/5.6/en/encryption-functions.html'),(337,'SHOW STATUS',27,'Syntax:\nSHOW [GLOBAL | SESSION] STATUS\n    [LIKE \'pattern\' | WHERE expr]\n\nSHOW STATUS provides server status information. This information also\ncan be obtained using the mysqladmin extended-status command. The LIKE\nclause, if present, indicates which variable names to match. The WHERE\nclause can be given to select rows using more general conditions, as\ndiscussed in http://dev.mysql.com/doc/refman/5.6/en/extended-show.html.\nThis statement does not require any privilege. It requires only the\nability to connect to the server.\nWith a LIKE clause, the statement displays only rows for those\nvariables with names that match the pattern:\n\nmysql> SHOW STATUS LIKE \'Key%\';\n+--------------------+----------+\n| Variable_name      | Value    |\n+--------------------+----------+\n| Key_blocks_used    | 14955    |\n| Key_read_requests  | 96854827 |\n| Key_reads          | 162040   |\n| Key_write_requests | 7589728  |\n| Key_writes         | 3813196  |\n+--------------------+----------+\n\nWith the GLOBAL modifier, SHOW STATUS displays the status values for\nall connections to MySQL. With SESSION, it displays the status values\nfor the current connection. If no modifier is present, the default is\nSESSION. LOCAL is a synonym for SESSION.\n\nSome status variables have only a global value. For these, you get the\nsame value for both GLOBAL and SESSION. The scope for each status\nvariable is listed at\nhttp://dev.mysql.com/doc/refman/5.6/en/server-status-variables.html.\n\nEach invocation of the SHOW STATUS statement uses an internal temporary\ntable and increments the global Created_tmp_tables value.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/show-status.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/show-status.html'),(338,'INET6_ATON',14,'Syntax:\nINET6_ATON(expr)\n\nGiven an IPv6 or IPv4 network address as a string, returns a binary\nstring that represents the numeric value of the address in network byte\norder (big endian). Because numeric-format IPv6 addresses require more\nbytes than the largest integer type, the representation returned by\nthis function has the VARBINARY data type: VARBINARY(16) for IPv6\naddresses and VARBINARY(4) for IPv4 addresses. If the argument is not a\nvalid address, INET6_ATON() returns NULL.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/miscellaneous-functions.html\n\n','mysql> SELECT HEX(INET6_ATON(\'fdfe::5a55:caff:fefa:9089\'));\n        -> \'FDFE0000000000005A55CAFFFEFA9089\'\nmysql> SELECT HEX(INET6_ATON(\'10.0.5.9\'));\n        -> \'0A000509\'\n','http://dev.mysql.com/doc/refman/5.6/en/miscellaneous-functions.html'),(339,'SHOW SLAVE HOSTS',27,'Syntax:\nSHOW SLAVE HOSTS\n\nDisplays a list of replication slaves currently registered with the\nmaster.\n\nThe list is displayed on any server (not just the master server). The\noutput looks like this:\n\nmysql> SHOW SLAVE HOSTS;\n+-----------+-----------+-------+-----------+--------------------------------------+\n| Server_id | Host      | Port  | Master_id | Slave_UUID                           |\n+-----------+-----------+-------+-----------+--------------------------------------+\n|  192168010 | iconnect2 | 3306 | 192168011 | 14cb6624-7f93-11e0-b2c0-c80aa9429562 |\n| 1921680101 | athena    | 3306 | 192168011 | 07af4990-f41f-11df-a566-7ac56fdaf645 |\n+------------+-----------+------+-----------+--------------------------------------+\n\no Server_id: The unique server ID of the slave server, as configured in\n  the server\'s option file, or on the command line with\n  --server-id=value.\n\no Host: The host name of the slave server, as configured in the\n  server\'s option file, or on the command line with\n  --report-host=host_name. Note that this can differ from the machine\n  name as configured in the operating system.\n\no Port: The port the slave server is listening on.\n\n  In MySQL 5.6.5 and later, a zero in this column means that the slave\n  port (--report-port) was not set. Prior to MySQL 5.6.5, 3306 was used\n  as the default in such cases (Bug #13333431).\n\no Master_id: The unique server ID of the master server that the slave\n  server is replicating from.\n\no Slave_UUID: The globally unique ID of this slave, as generated on the\n  slave and found in the slave\'s auto.cnf file.\n\n  This column was added in MySQL 5.6.0.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/show-slave-hosts.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/show-slave-hosts.html'),(340,'START TRANSACTION',8,'Syntax:\nSTART TRANSACTION\n    [transaction_characteristic [, transaction_characteristic] ...]\n\ntransaction_characteristic:\n    WITH CONSISTENT SNAPSHOT\n  | READ WRITE\n  | READ ONLY\n\nBEGIN [WORK]\nCOMMIT [WORK] [AND [NO] CHAIN] [[NO] RELEASE]\nROLLBACK [WORK] [AND [NO] CHAIN] [[NO] RELEASE]\nSET autocommit = {0 | 1}\n\nThese statements provide control over use of transactions:\n\no START TRANSACTION or BEGIN start a new transaction.\n\no COMMIT commits the current transaction, making its changes permanent.\n\no ROLLBACK rolls back the current transaction, canceling its changes.\n\no SET autocommit disables or enables the default autocommit mode for\n  the current session.\n\nBy default, MySQL runs with autocommit mode enabled. This means that as\nsoon as you execute a statement that updates (modifies) a table, MySQL\nstores the update on disk to make it permanent. The change cannot be\nrolled back.\n\nTo disable autocommit mode implicitly for a single series of\nstatements, use the START TRANSACTION statement:\n\nSTART TRANSACTION;\nSELECT @A:=SUM(salary) FROM table1 WHERE type=1;\nUPDATE table2 SET summary=@A WHERE type=1;\nCOMMIT;\n\nWith START TRANSACTION, autocommit remains disabled until you end the\ntransaction with COMMIT or ROLLBACK. The autocommit mode then reverts\nto its previous state.\n\nSTART TRANSACTION permits several modifiers that control transaction\ncharacteristics. To specify multiple modifiers, separate them by\ncommas.\n\no The WITH CONSISTENT SNAPSHOT modifier starts a consistent read for\n  storage engines that are capable of it. This applies only to InnoDB.\n  The effect is the same as issuing a START TRANSACTION followed by a\n  SELECT from any InnoDB table. See\n  http://dev.mysql.com/doc/refman/5.6/en/innodb-consistent-read.html.\n  The WITH CONSISTENT SNAPSHOT modifier does not change the current\n  transaction isolation level, so it provides a consistent snapshot\n  only if the current isolation level is one that permits consistent\n  read (REPEATABLE READ or SERIALIZABLE).\n\no The READ WRITE and READ ONLY modifiers set the transaction access\n  mode. They permit or prohibit changes to tables used in the\n  transaction. The READ ONLY restriction prevents the transaction from\n  modifying or locking both transactional and nontransactional tables\n  that are visible to other transactions; the transaction can still\n  modify or lock temporary tables. These modifiers are available as of\n  MySQL 5.6.5.\n\n  MySQL enables extra optimizations for queries on InnoDB tables when\n  the transaction is known to be read-only. Specifying READ ONLY\n  ensures these optimizations are applied in cases where the read-only\n  status cannot be determined automatically. See\n  http://dev.mysql.com/doc/refman/5.6/en/innodb-performance.html#innodb\n  -performance-ro-txn for more information.\n\n  If no access mode is specified, the default mode applies. Unless the\n  default has been changed, it is read/write. It is not permitted to\n  specify both READ WRITE and READ ONLY in the same statement.\n\n  In read-only mode, it remains possible to change tables created with\n  the TEMPORARY keyword using DML statements. Changes made with DDL\n  statements are not permitted, just as with permanent tables.\n\n  For additional information about transaction access mode, including\n  ways to change the default mode, see [HELP ISOLATION].\n\n  If the read_only system variable is enabled, explicitly starting a\n  transaction with START TRANSACTION READ WRITE requires the SUPER\n  privilege.\n\n*Important*: Many APIs used for writing MySQL client applications (such\nas JDBC) provide their own methods for starting transactions that can\n(and sometimes should) be used instead of sending a START TRANSACTION\nstatement from the client. See\nhttp://dev.mysql.com/doc/refman/5.6/en/connectors-apis.html, or the\ndocumentation for your API, for more information.\n\nTo disable autocommit mode explicitly, use the following statement:\n\nSET autocommit=0;\n\nAfter disabling autocommit mode by setting the autocommit variable to\nzero, changes to transaction-safe tables (such as those for InnoDB or\nNDB) are not made permanent immediately. You must use COMMIT to store\nyour changes to disk or ROLLBACK to ignore the changes.\n\nautocommit is a session variable and must be set for each session. To\ndisable autocommit mode for each new connection, see the description of\nthe autocommit system variable at\nhttp://dev.mysql.com/doc/refman/5.6/en/server-system-variables.html.\n\nBEGIN and BEGIN WORK are supported as aliases of START TRANSACTION for\ninitiating a transaction. START TRANSACTION is standard SQL syntax, is\nthe recommended way to start an ad-hoc transaction, and permits\nmodifiers that BEGIN does not.\n\nThe BEGIN statement differs from the use of the BEGIN keyword that\nstarts a BEGIN ... END compound statement. The latter does not begin a\ntransaction. See [HELP BEGIN END].\n\n*Note*: Within all stored programs (stored procedures and functions,\ntriggers, and events), the parser treats BEGIN [WORK] as the beginning\nof a BEGIN ... END block. Begin a transaction in this context with\nSTART TRANSACTION instead.\n\nThe optional WORK keyword is supported for COMMIT and ROLLBACK, as are\nthe CHAIN and RELEASE clauses. CHAIN and RELEASE can be used for\nadditional control over transaction completion. The value of the\ncompletion_type system variable determines the default completion\nbehavior. See\nhttp://dev.mysql.com/doc/refman/5.6/en/server-system-variables.html.\n\nThe AND CHAIN clause causes a new transaction to begin as soon as the\ncurrent one ends, and the new transaction has the same isolation level\nas the just-terminated transaction. The RELEASE clause causes the\nserver to disconnect the current client session after terminating the\ncurrent transaction. Including the NO keyword suppresses CHAIN or\nRELEASE completion, which can be useful if the completion_type system\nvariable is set to cause chaining or release completion by default.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/commit.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/commit.html'),(341,'TIME_FORMAT',32,'Syntax:\nTIME_FORMAT(time,format)\n\nThis is used like the DATE_FORMAT() function, but the format string may\ncontain format specifiers only for hours, minutes, seconds, and\nmicroseconds. Other specifiers produce a NULL value or 0.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html\n\n','mysql> SELECT TIME_FORMAT(\'100:00:00\', \'%H %k %h %I %l\');\n        -> \'100 100 04 04 4\'\n','http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html'),(342,'CREATE DATABASE',40,'Syntax:\nCREATE {DATABASE | SCHEMA} [IF NOT EXISTS] db_name\n    [create_specification] ...\n\ncreate_specification:\n    [DEFAULT] CHARACTER SET [=] charset_name\n  | [DEFAULT] COLLATE [=] collation_name\n\nCREATE DATABASE creates a database with the given name. To use this\nstatement, you need the CREATE privilege for the database. CREATE\nSCHEMA is a synonym for CREATE DATABASE.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/create-database.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/create-database.html'),(343,'VAR_POP',16,'Syntax:\nVAR_POP(expr)\n\nReturns the population standard variance of expr. It considers rows as\nthe whole population, not as a sample, so it has the number of rows as\nthe denominator. You can also use VARIANCE(), which is equivalent but\nis not standard SQL.\n\nVAR_POP() returns NULL if there were no matching rows.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/group-by-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/group-by-functions.html'),(344,'CONCAT_WS',38,'Syntax:\nCONCAT_WS(separator,str1,str2,...)\n\nCONCAT_WS() stands for Concatenate With Separator and is a special form\nof CONCAT(). The first argument is the separator for the rest of the\narguments. The separator is added between the strings to be\nconcatenated. The separator can be a string, as can the rest of the\narguments. If the separator is NULL, the result is NULL.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/string-functions.html\n\n','mysql> SELECT CONCAT_WS(\',\',\'First name\',\'Second name\',\'Last Name\');\n        -> \'First name,Second name,Last Name\'\nmysql> SELECT CONCAT_WS(\',\',\'First name\',NULL,\'Last Name\');\n        -> \'First name,Last Name\'\n','http://dev.mysql.com/doc/refman/5.6/en/string-functions.html'),(345,'TEXT',23,'TEXT[(M)] [CHARACTER SET charset_name] [COLLATE collation_name]\n\nA TEXT column with a maximum length of 65,535 (216 - 1) characters. The\neffective maximum length is less if the value contains multi-byte\ncharacters. Each TEXT value is stored using a 2-byte length prefix that\nindicates the number of bytes in the value.\n\nAn optional length M can be given for this type. If this is done, MySQL\ncreates the column as the smallest TEXT type large enough to hold\nvalues M characters long.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/string-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/string-type-overview.html'),(346,'~',20,'Syntax:\n~\n\nInvert all bits.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/bit-functions.html\n\n','mysql> SELECT 5 & ~1;\n        -> 4\n','http://dev.mysql.com/doc/refman/5.6/en/bit-functions.html'),(347,'ASIN',4,'Syntax:\nASIN(X)\n\nReturns the arc sine of X, that is, the value whose sine is X. Returns\nNULL if X is not in the range -1 to 1.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/mathematical-functions.html\n\n','mysql> SELECT ASIN(0.2);\n        -> 0.20135792079033\nmysql> SELECT ASIN(\'foo\');\n\n+-------------+\n| ASIN(\'foo\') |\n+-------------+\n|           0 |\n+-------------+\n1 row in set, 1 warning (0.00 sec)\n\nmysql> SHOW WARNINGS;\n+---------+------+-----------------------------------------+\n| Level   | Code | Message                                 |\n+---------+------+-----------------------------------------+\n| Warning | 1292 | Truncated incorrect DOUBLE value: \'foo\' |\n+---------+------+-----------------------------------------+\n','http://dev.mysql.com/doc/refman/5.6/en/mathematical-functions.html'),(348,'ROW_COUNT',17,'Syntax:\nROW_COUNT()\n\nIn MySQL 5.6, ROW_COUNT() returns a value as follows:\n\no DDL statements: 0. This applies to statements such as CREATE TABLE or\n  DROP TABLE.\n\no DML statements other than SELECT: The number of affected rows. This\n  applies to statements such as UPDATE, INSERT, or DELETE (as before),\n  but now also to statements such as ALTER TABLE and LOAD DATA INFILE.\n\no SELECT: -1 if the statement returns a result set, or the number of\n  rows \"affected\" if it does not. For example, for SELECT * FROM t1,\n  ROW_COUNT() returns -1. For SELECT * FROM t1 INTO OUTFILE\n  \'file_name\', ROW_COUNT() returns the number of rows written to the\n  file.\n\no SIGNAL statements: 0.\n\nFor UPDATE statements, the affected-rows value by default is the number\nof rows actually changed. If you specify the CLIENT_FOUND_ROWS flag to\nmysql_real_connect() when connecting to mysqld, the affected-rows value\nis the number of rows \"found\"; that is, matched by the WHERE clause.\n\nFor REPLACE statements, the affected-rows value is 2 if the new row\nreplaced an old row, because in this case, one row was inserted after\nthe duplicate was deleted.\n\nFor INSERT ... ON DUPLICATE KEY UPDATE statements, the affected-rows\nvalue is 1 if the row is inserted as a new row and 2 if an existing row\nis updated.\n\nThe ROW_COUNT() value is similar to the value from the\nmysql_affected_rows() C API function and the row count that the mysql\nclient displays following statement execution.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/information-functions.html\n\n','mysql> INSERT INTO t VALUES(1),(2),(3);\nQuery OK, 3 rows affected (0.00 sec)\nRecords: 3  Duplicates: 0  Warnings: 0\n\nmysql> SELECT ROW_COUNT();\n+-------------+\n| ROW_COUNT() |\n+-------------+\n|           3 |\n+-------------+\n1 row in set (0.00 sec)\n\nmysql> DELETE FROM t WHERE i IN(1,2);\nQuery OK, 2 rows affected (0.00 sec)\n\nmysql> SELECT ROW_COUNT();\n+-------------+\n| ROW_COUNT() |\n+-------------+\n|           2 |\n+-------------+\n1 row in set (0.00 sec)\n','http://dev.mysql.com/doc/refman/5.6/en/information-functions.html'),(349,'SIGN',4,'Syntax:\nSIGN(X)\n\nReturns the sign of the argument as -1, 0, or 1, depending on whether X\nis negative, zero, or positive.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/mathematical-functions.html\n\n','mysql> SELECT SIGN(-32);\n        -> -1\nmysql> SELECT SIGN(0);\n        -> 0\nmysql> SELECT SIGN(234);\n        -> 1\n','http://dev.mysql.com/doc/refman/5.6/en/mathematical-functions.html'),(350,'FLOAT',23,'FLOAT[(M,D)] [UNSIGNED] [ZEROFILL]\n\nA small (single-precision) floating-point number. Permissible values\nare -3.402823466E+38 to -1.175494351E-38, 0, and 1.175494351E-38 to\n3.402823466E+38. These are the theoretical limits, based on the IEEE\nstandard. The actual range might be slightly smaller depending on your\nhardware or operating system.\n\nM is the total number of digits and D is the number of digits following\nthe decimal point. If M and D are omitted, values are stored to the\nlimits permitted by the hardware. A single-precision floating-point\nnumber is accurate to approximately 7 decimal places.\n\nUNSIGNED, if specified, disallows negative values.\n\nUsing FLOAT might give you some unexpected problems because all\ncalculations in MySQL are done with double precision. See\nhttp://dev.mysql.com/doc/refman/5.6/en/no-matching-rows.html.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/numeric-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/numeric-type-overview.html'),(351,'CHARSET',17,'Syntax:\nCHARSET(str)\n\nReturns the character set of the string argument.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/information-functions.html\n\n','mysql> SELECT CHARSET(\'abc\');\n        -> \'latin1\'\nmysql> SELECT CHARSET(CONVERT(\'abc\' USING utf8));\n        -> \'utf8\'\nmysql> SELECT CHARSET(USER());\n        -> \'utf8\'\n','http://dev.mysql.com/doc/refman/5.6/en/information-functions.html'),(352,'SUBDATE',32,'Syntax:\nSUBDATE(date,INTERVAL expr unit), SUBDATE(expr,days)\n\nWhen invoked with the INTERVAL form of the second argument, SUBDATE()\nis a synonym for DATE_SUB(). For information on the INTERVAL unit\nargument, see the discussion for DATE_ADD().\n\nmysql> SELECT DATE_SUB(\'2008-01-02\', INTERVAL 31 DAY);\n        -> \'2007-12-02\'\nmysql> SELECT SUBDATE(\'2008-01-02\', INTERVAL 31 DAY);\n        -> \'2007-12-02\'\n\nThe second form enables the use of an integer value for days. In such\ncases, it is interpreted as the number of days to be subtracted from\nthe date or datetime expression expr.\n\nmysql> SELECT SUBDATE(\'2008-01-02 12:00:00\', 31);\n        -> \'2007-12-02 12:00:00\'\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html'),(353,'DAYOFYEAR',32,'Syntax:\nDAYOFYEAR(date)\n\nReturns the day of the year for date, in the range 1 to 366.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html\n\n','mysql> SELECT DAYOFYEAR(\'2007-02-03\');\n        -> 34\n','http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html'),(354,'%',4,'Syntax:\nN % M, N MOD M\n\nModulo operation. Returns the remainder of N divided by M. For more\ninformation, see the description for the MOD() function in\nhttp://dev.mysql.com/doc/refman/5.6/en/mathematical-functions.html.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/arithmetic-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/arithmetic-functions.html'),(355,'ASTEXT',3,'AsText(g), AsWKT(g)\n\nConverts a value in internal geometry format to its WKT representation\nand returns the string result.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/functions-to-convert-geometries-between-formats.html\n\n','mysql> SET @g = \'LineString(1 1,2 2,3 3)\';\nmysql> SELECT AsText(GeomFromText(@g));\n+--------------------------+\n| AsText(GeomFromText(@g)) |\n+--------------------------+\n| LINESTRING(1 1,2 2,3 3)  |\n+--------------------------+\n','http://dev.mysql.com/doc/refman/5.6/en/functions-to-convert-geometries-between-formats.html'),(356,'DECLARE CONDITION',24,'Syntax:\nDECLARE condition_name CONDITION FOR condition_value\n\ncondition_value:\n    mysql_error_code\n  | SQLSTATE [VALUE] sqlstate_value\n\nThe DECLARE ... CONDITION statement declares a named error condition,\nassociating a name with a condition that needs specific handling. The\nname can be referred to in a subsequent DECLARE ... HANDLER statement\n(see [HELP DECLARE HANDLER]).\n\nCondition declarations must appear before cursor or handler\ndeclarations.\n\nThe condition_value for DECLARE ... CONDITION can be a MySQL error code\n(a number) or an SQLSTATE value (a 5-character string literal). You\nshould not use MySQL error code 0 or SQLSTATE values that begin with\n\'00\', because those indicate success rather than an error condition.\nFor a list of MySQL error codes and SQLSTATE values, see\nhttp://dev.mysql.com/doc/refman/5.6/en/error-messages-server.html.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/declare-condition.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/declare-condition.html'),(357,'MONTHNAME',32,'Syntax:\nMONTHNAME(date)\n\nReturns the full name of the month for date. The language used for the\nname is controlled by the value of the lc_time_names system variable\n(http://dev.mysql.com/doc/refman/5.6/en/locale-support.html).\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html\n\n','mysql> SELECT MONTHNAME(\'2008-02-03\');\n        -> \'February\'\n','http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html'),(358,'NUMGEOMETRIES',26,'NumGeometries(gc)\n\nReturns the number of geometries in the GeometryCollection value gc.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/geometry-property-functions.html\n\n','mysql> SET @gc = \'GeometryCollection(Point(1 1),LineString(2 2, 3 3))\';\nmysql> SELECT NumGeometries(GeomFromText(@gc));\n+----------------------------------+\n| NumGeometries(GeomFromText(@gc)) |\n+----------------------------------+\n|                                2 |\n+----------------------------------+\n','http://dev.mysql.com/doc/refman/5.6/en/geometry-property-functions.html'),(359,'TIMESTAMP FUNCTION',32,'Syntax:\nTIMESTAMP(expr), TIMESTAMP(expr1,expr2)\n\nWith a single argument, this function returns the date or datetime\nexpression expr as a datetime value. With two arguments, it adds the\ntime expression expr2 to the date or datetime expression expr1 and\nreturns the result as a datetime value.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html\n\n','mysql> SELECT TIMESTAMP(\'2003-12-31\');\n        -> \'2003-12-31 00:00:00\'\nmysql> SELECT TIMESTAMP(\'2003-12-31 12:00:00\',\'12:00:00\');\n        -> \'2004-01-01 00:00:00\'\n','http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html'),(360,'DROP DATABASE',40,'Syntax:\nDROP {DATABASE | SCHEMA} [IF EXISTS] db_name\n\nDROP DATABASE drops all tables in the database and deletes the\ndatabase. Be very careful with this statement! To use DROP DATABASE,\nyou need the DROP privilege on the database. DROP SCHEMA is a synonym\nfor DROP DATABASE.\n\n*Important*: When a database is dropped, user privileges on the\ndatabase are not automatically dropped. See [HELP GRANT].\n\nIF EXISTS is used to prevent an error from occurring if the database\ndoes not exist.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/drop-database.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/drop-database.html'),(361,'CHANGE MASTER TO',8,'Syntax:\nCHANGE MASTER TO option [, option] ...\n\noption:\n    MASTER_BIND = \'interface_name\'\n  | MASTER_HOST = \'host_name\'\n  | MASTER_USER = \'user_name\'\n  | MASTER_PASSWORD = \'password\'\n  | MASTER_PORT = port_num\n  | MASTER_CONNECT_RETRY = interval\n  | MASTER_RETRY_COUNT = count\n  | MASTER_DELAY = interval\n  | MASTER_HEARTBEAT_PERIOD = interval\n  | MASTER_LOG_FILE = \'master_log_name\'\n  | MASTER_LOG_POS = master_log_pos\n  | MASTER_AUTO_POSITION = {0|1}\n  | RELAY_LOG_FILE = \'relay_log_name\'\n  | RELAY_LOG_POS = relay_log_pos\n  | MASTER_SSL = {0|1}\n  | MASTER_SSL_CA = \'ca_file_name\'\n  | MASTER_SSL_CAPATH = \'ca_directory_name\'\n  | MASTER_SSL_CERT = \'cert_file_name\'\n  | MASTER_SSL_CRL = \'crl_file_name\'\n  | MASTER_SSL_CRLPATH = \'crl_directory_name\'\n  | MASTER_SSL_KEY = \'key_file_name\'\n  | MASTER_SSL_CIPHER = \'cipher_list\'\n  | MASTER_SSL_VERIFY_SERVER_CERT = {0|1}\n  | IGNORE_SERVER_IDS = (server_id_list)\n\nserver_id_list:\n    [server_id [, server_id] ... ]\n\nCHANGE MASTER TO changes the parameters that the slave server uses for\nconnecting to the master server, for reading the master binary log, and\nreading the slave relay log. It also updates the contents of the\nmaster.info and relay-log.info files. To use CHANGE MASTER TO, the\nslave replication threads must be stopped (use STOP SLAVE if\nnecessary). In MySQL 5.6.11 and later, gtid_next must also be set to\nAUTOMATIC (Bug #16062608).\n\nOptions not specified retain their value, except as indicated in the\nfollowing discussion. Thus, in most cases, there is no need to specify\noptions that do not change. For example, if the password to connect to\nyour MySQL master has changed, you just need to issue these statements\nto tell the slave about the new password:\n\nSTOP SLAVE; -- if replication was running\nCHANGE MASTER TO MASTER_PASSWORD=\'new3cret\';\nSTART SLAVE; -- if you want to restart replication\n\nMASTER_HOST, MASTER_USER, MASTER_PASSWORD, and MASTER_PORT provide\ninformation to the slave about how to connect to its master:\n\no MASTER_HOST and MASTER_PORT are the host name (or IP address) of the\n  master host and its TCP/IP port.\n\n  *Note*: Replication cannot use Unix socket files. You must be able to\n  connect to the master MySQL server using TCP/IP.\n\n  If you specify the MASTER_HOST or MASTER_PORT option, the slave\n  assumes that the master server is different from before (even if the\n  option value is the same as its current value.) In this case, the old\n  values for the master binary log file name and position are\n  considered no longer applicable, so if you do not specify\n  MASTER_LOG_FILE and MASTER_LOG_POS in the statement,\n  MASTER_LOG_FILE=\'\' and MASTER_LOG_POS=4 are silently appended to it.\n\n  Setting MASTER_HOST=\'\' (that is, setting its value explicitly to an\n  empty string) is not the same as not setting MASTER_HOST at all.\n  Beginning with MySQL 5.5, trying to set MASTER_HOST to an empty\n  string fails with an error. Previously, setting MASTER_HOST to an\n  empty string caused START SLAVE subsequently to fail. (Bug #28796)\n\n  In MySQL 5.6.5 and later, values used for MASTER_HOST and other\n  CHANGE MASTER TO options are checked for linefeed (\\n or 0x0A)\n  characters; the presence of such characters in these values causes\n  the statement to fail with ER_MASTER_INFO. (Bug #11758581, Bug\n  #50801)\n\no MASTER_USER and MASTER_PASSWORD are the user name and password of the\n  account to use for connecting to the master.\n\n  In MySQL 5.6.4 and later, MASTER_USER cannot be made empty; setting\n  MASTER_USER = \'\' or leaving it unset when setting a value for for\n  MASTER_PASSWORD causes an error (Bug #13427949).\n\n  Currently, a password used for a replication slave account is\n  effectively limited to 32 characters in length; the password can be\n  longer, but any excess characters are truncated. This is not due to\n  any limit imposed by the MySQL Server generally, but rather is an\n  issue specific to MySQL Replication. (For more information, see Bug\n  #43439.)\n\n  The text of a running CHANGE MASTER TO statement, including values\n  for MASTER_USER and MASTER_PASSWORD, can be seen in the output of a\n  concurrent SHOW PROCESSLIST statement. (The complete text of a START\n  SLAVE statement is also visible to SHOW PROCESSLIST.)\n\nThe MASTER_SSL_xxx options provide information about using SSL for the\nconnection. They correspond to the --ssl-xxx options described in\nhttp://dev.mysql.com/doc/refman/5.6/en/ssl-options.html, and\nhttp://dev.mysql.com/doc/refman/5.6/en/replication-solutions-ssl.html.\nThese options can be changed even on slaves that are compiled without\nSSL support. They are saved to the master.info file, but are ignored if\nthe slave does not have SSL support enabled. MASTER_SSL_CRL and\nMASTER_SSL_CRLPATH were added in MySQL 5.6.3.\n\nMASTER_CONNECT_RETRY specifies how many seconds to wait between connect\nretries. The default is 60.\n\nMASTER_RETRY_COUNT, added in MySQL 5.6.1, limits the number of\nreconnection attempts and updates the value of the Master_Retry_Count\ncolumn in the output of SHOW SLAVE STATUS (also added in MySQL 5.6.1).\nThe default value is 24 * 3600 = 86400. MASTER_RETRY_COUNT is intended\nto replace the older --master-retry-count server option, and is now the\npreferred method for setting this limit. You are encouraged not to rely\non --master-retry-count in new applications and, when upgrading to\nMySQL 5.6.1 or later from earlier versions of MySQL, to update any\nexisting applications that rely on it, so that they use CHANGE MASTER\nTO ... MASTER_RETRY_COUNT instead.\n\nMASTER_DELAY specifies how many seconds behind the master the slave\nmust lag. An event received from the master is not executed until at\nleast interval seconds later than its execution on the master. The\ndefault is 0. An error occurs if interval is not a nonnegative integer\nin the range from 0 to 231-1. For more information, see\nhttp://dev.mysql.com/doc/refman/5.6/en/replication-delayed.html. This\noption was added in MySQL 5.6.0.\n\nMASTER_BIND is for use on replication slaves having multiple network\ninterfaces, and determines which of the slave\'s network interfaces is\nchosen for connecting to the master.\n\nThe address configured with this option, if any, can be seen in the\nMaster_Bind column of the output from SHOW SLAVE STATUS. If you are\nusing slave status log tables (server started with\n--master-info-repository=TABLE), the value can also be seen as the\nMaster_bind column of the mysql.slave_master_info table.\n\nThe ability to bind a replication slave to a specific network interface\nwas added in MySQL 5.6.2. This is also supported by MySQL Cluster NDB\n7.3.1 and later.\n\nMASTER_HEARTBEAT_PERIOD sets the interval in seconds between\nreplication heartbeats. Whenever the master\'s binary log is updated\nwith an event, the waiting period for the next heartbeat is reset.\ninterval is a decimal value having the range 0 to 4294967 seconds and a\nresolution in milliseconds; the smallest nonzero value is 0.001.\nHeartbeats are sent by the master only if there are no unsent events in\nthe binary log file for a period longer than interval.\n\nIf you are logging master connection information to tables,\nMASTER_HEARTBEAT_PERIOD can be seen as the value of the Heartbeat\ncolumn of the mysql.slave_master_info table.\n\nSetting interval to 0 disables heartbeats altogether. The default value\nfor interval is equal to the value of slave_net_timeout divided by 2.\n\nSetting @@global.slave_net_timeout to a value less than that of the\ncurrent heartbeat interval results in a warning being issued. The\neffect of issuing RESET SLAVE on the heartbeat interval is to reset it\nto the default value.\n\nMASTER_LOG_FILE and MASTER_LOG_POS are the coordinates at which the\nslave I/O thread should begin reading from the master the next time the\nthread starts. RELAY_LOG_FILE and RELAY_LOG_POS are the coordinates at\nwhich the slave SQL thread should begin reading from the relay log the\nnext time the thread starts. If you specify either of MASTER_LOG_FILE\nor MASTER_LOG_POS, you cannot specify RELAY_LOG_FILE or RELAY_LOG_POS.\nIn MySQL 5.6.5 and later, if you specify either of MASTER_LOG_FILE or\nMASTER_LOG_POS, you also cannot specify MASTER_AUTO_POSITION = 1\n(described later in this section). If neither of MASTER_LOG_FILE or\nMASTER_LOG_POS is specified, the slave uses the last coordinates of the\nslave SQL thread before CHANGE MASTER TO was issued. This ensures that\nthere is no discontinuity in replication, even if the slave SQL thread\nwas late compared to the slave I/O thread, when you merely want to\nchange, say, the password to use.\n\nMASTER_AUTO_POSITION was added in MySQL 5.6.5. If MASTER_AUTO_POSITION\n= 1 is used with CHANGE MASTER TO, the slave attempts to connect to the\nmaster using the GTID-based replication protocol. In this case, the\ncoordinates represented by MASTER_LOG_FILE and MASTER_LOG_POS are not\nused, and global transaction identifiers are used instead. Thus the use\nof either or both of these options together with MASTER_AUTO_POSITION\ncauses an error.\n\nBeginning with MySQL 5.6.10, you can see whether replication is running\nwith autopositioning enabled by checking the output of SHOW SLAVE\nSTATUS. (Bug #15992220)\n\ngtid_mode must also be enabled before issuing CHANGE MASTER TO ...\nMASTER_AUTO_POSITION = 1. Otherwise, the statement fails with an error.\n\nTo revert to the older file-based replication protocol after using\nGTIDs, you can issue a new CHANGE MASTER TO statement that specifies\nMASTER_AUTO_POSITION = 0, as well as at least one of MASTER_LOG_FILE or\nMASTER_LOG_POSITION.\n\nCHANGE MASTER TO deletes all relay log files and starts a new one,\nunless you specify RELAY_LOG_FILE or RELAY_LOG_POS. In that case, relay\nlog files are kept; the relay_log_purge global variable is set silently\nto 0.\n\nPrior to MySQL 5.6.2, RELAY_LOG_FILE required an absolute path.\nBeginning with MySQL 5.6.2, the path can be relative, in which case it\nis assumed to be relative to the slave\'s data directory. (Bug #12190)\n\nIGNORE_SERVER_IDS takes a comma-separated list of 0 or more server IDs.\nEvents originating from the corresponding servers are ignored, with the\nexception of log rotation and deletion events, which are still recorded\nin the relay log.\n\nIn circular replication, the originating server normally acts as the\nterminator of its own events, so that they are not applied more than\nonce. Thus, this option is useful in circular replication when one of\nthe servers in the circle is removed. Suppose that you have a circular\nreplication setup with 4 servers, having server IDs 1, 2, 3, and 4, and\nserver 3 fails. When bridging the gap by starting replication from\nserver 2 to server 4, you can include IGNORE_SERVER_IDS = (3) in the\nCHANGE MASTER TO statement that you issue on server 4 to tell it to use\nserver 2 as its master instead of server 3. Doing so causes it to\nignore and not to propagate any statements that originated with the\nserver that is no longer in use.\n\nIf a CHANGE MASTER TO statement is issued without any IGNORE_SERVER_IDS\noption, any existing list is preserved; RESET SLAVE also has no effect\non the server ID list. To clear the list of ignored servers, it is\nnecessary to use the option with an empty list:\n\nCHANGE MASTER TO IGNORE_SERVER_IDS = ();\n\nIf IGNORE_SERVER_IDS contains the server\'s own ID and the server was\nstarted with the --replicate-same-server-id option enabled, an error\nresults.\n\nIn MySQL 5.6, the master.info file and the output of SHOW SLAVE STATUS\nprovide the list of servers that are currently ignored. For more\ninformation, see\nhttp://dev.mysql.com/doc/refman/5.6/en/slave-logs-status.html, and\n[HELP SHOW SLAVE STATUS].\n\nIn MySQL 5.6, invoking CHANGE MASTER TO causes the previous values for\nMASTER_HOST, MASTER_PORT, MASTER_LOG_FILE, and MASTER_LOG_POS to be\nwritten to the error log, along with other information about the\nslave\'s state prior to execution.\n\nIn MySQL 5.6.7 and later, CHANGE MASTER TO causes an implicit commit of\nan ongoing transaction. See\nhttp://dev.mysql.com/doc/refman/5.6/en/implicit-commit.html.\n\nCHANGE MASTER TO is useful for setting up a slave when you have the\nsnapshot of the master and have recorded the master binary log\ncoordinates corresponding to the time of the snapshot. After loading\nthe snapshot into the slave to synchronize it to the slave, you can run\nCHANGE MASTER TO MASTER_LOG_FILE=\'log_name\', MASTER_LOG_POS=log_pos on\nthe slave to specify the coordinates at which the slave should begin\nreading the master binary log.\n\nThe following example changes the master server the slave uses and\nestablishes the master binary log coordinates from which the slave\nbegins reading. This is used when you want to set up the slave to\nreplicate the master:\n\nCHANGE MASTER TO\n  MASTER_HOST=\'master2.mycompany.com\',\n  MASTER_USER=\'replication\',\n  MASTER_PASSWORD=\'bigs3cret\',\n  MASTER_PORT=3306,\n  MASTER_LOG_FILE=\'master2-bin.001\',\n  MASTER_LOG_POS=4,\n  MASTER_CONNECT_RETRY=10;\n\nThe next example shows an operation that is less frequently employed.\nIt is used when the slave has relay log files that you want it to\nexecute again for some reason. To do this, the master need not be\nreachable. You need only use CHANGE MASTER TO and start the SQL thread\n(START SLAVE SQL_THREAD):\n\nCHANGE MASTER TO\n  RELAY_LOG_FILE=\'slave-relay-bin.006\',\n  RELAY_LOG_POS=4025;\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/change-master-to.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/change-master-to.html'),(362,'SHOW GRANTS',27,'Syntax:\nSHOW GRANTS [FOR user]\n\nThis statement lists the GRANT statement or statements that must be\nissued to duplicate the privileges that are granted to a MySQL user\naccount. The account is named using the same format as for the GRANT\nstatement; for example, \'jeffrey\'@\'localhost\'. If you specify only the\nuser name part of the account name, a host name part of \'%\' is used.\nFor additional information about specifying account names, see [HELP\nGRANT].\n\nmysql> SHOW GRANTS FOR \'root\'@\'localhost\';\n+---------------------------------------------------------------------+\n| Grants for root@localhost                                           |\n+---------------------------------------------------------------------+\n| GRANT ALL PRIVILEGES ON *.* TO \'root\'@\'localhost\' WITH GRANT OPTION |\n+---------------------------------------------------------------------+\n\nTo list the privileges granted to the account that you are using to\nconnect to the server, you can use any of the following statements:\n\nSHOW GRANTS;\nSHOW GRANTS FOR CURRENT_USER;\nSHOW GRANTS FOR CURRENT_USER();\n\nIf SHOW GRANTS FOR CURRENT_USER (or any of the equivalent syntaxes) is\nused in DEFINER context, such as within a stored procedure that is\ndefined with SQL SECURITY DEFINER), the grants displayed are those of\nthe definer and not the invoker.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/show-grants.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/show-grants.html'),(363,'CRC32',4,'Syntax:\nCRC32(expr)\n\nComputes a cyclic redundancy check value and returns a 32-bit unsigned\nvalue. The result is NULL if the argument is NULL. The argument is\nexpected to be a string and (if possible) is treated as one if it is\nnot.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/mathematical-functions.html\n\n','mysql> SELECT CRC32(\'MySQL\');\n        -> 3259397556\nmysql> SELECT CRC32(\'mysql\');\n        -> 2501908538\n','http://dev.mysql.com/doc/refman/5.6/en/mathematical-functions.html'),(364,'STARTPOINT',13,'StartPoint(ls)\n\nReturns the Point that is the start point of the LineString value ls.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/geometry-property-functions.html\n\n','mysql> SET @ls = \'LineString(1 1,2 2,3 3)\';\nmysql> SELECT AsText(StartPoint(GeomFromText(@ls)));\n+---------------------------------------+\n| AsText(StartPoint(GeomFromText(@ls))) |\n+---------------------------------------+\n| POINT(1 1)                            |\n+---------------------------------------+\n','http://dev.mysql.com/doc/refman/5.6/en/geometry-property-functions.html'),(365,'MPOLYFROMTEXT',3,'MPolyFromText(wkt[,srid]), MultiPolygonFromText(wkt[,srid])\n\nConstructs a MULTIPOLYGON value using its WKT representation and SRID.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/creating-spatial-values.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/creating-spatial-values.html'),(366,'DECLARE VARIABLE',24,'Syntax:\nDECLARE var_name [, var_name] ... type [DEFAULT value]\n\nThis statement declares local variables within stored programs. To\nprovide a default value for a variable, include a DEFAULT clause. The\nvalue can be specified as an expression; it need not be a constant. If\nthe DEFAULT clause is missing, the initial value is NULL.\n\nLocal variables are treated like stored routine parameters with respect\nto data type and overflow checking. See [HELP CREATE PROCEDURE].\n\nVariable declarations must appear before cursor or handler\ndeclarations.\n\nLocal variable names are not case sensitive. Permissible characters and\nquoting rules are the same as for other identifiers, as described in\nhttp://dev.mysql.com/doc/refman/5.6/en/identifiers.html.\n\nThe scope of a local variable is the BEGIN ... END block within which\nit is declared. The variable can be referred to in blocks nested within\nthe declaring block, except those blocks that declare a variable with\nthe same name.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/declare-local-variable.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/declare-local-variable.html'),(367,'NOT BETWEEN',19,'Syntax:\nexpr NOT BETWEEN min AND max\n\nThis is the same as NOT (expr BETWEEN min AND max).\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/comparison-operators.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/comparison-operators.html'),(368,'YEARWEEK',32,'Syntax:\nYEARWEEK(date), YEARWEEK(date,mode)\n\nReturns year and week for a date. The mode argument works exactly like\nthe mode argument to WEEK(). The year in the result may be different\nfrom the year in the date argument for the first and the last week of\nthe year.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html\n\n','mysql> SELECT YEARWEEK(\'1987-01-01\');\n        -> 198653\n','http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html'),(369,'BIT_OR',16,'Syntax:\nBIT_OR(expr)\n\nReturns the bitwise OR of all bits in expr. The calculation is\nperformed with 64-bit (BIGINT) precision.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/group-by-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/group-by-functions.html'),(370,'LOG10',4,'Syntax:\nLOG10(X)\n\nReturns the base-10 logarithm of X.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/mathematical-functions.html\n\n','mysql> SELECT LOG10(2);\n        -> 0.30102999566398\nmysql> SELECT LOG10(100);\n        -> 2\nmysql> SELECT LOG10(-100);\n        -> NULL\n','http://dev.mysql.com/doc/refman/5.6/en/mathematical-functions.html'),(371,'DECIMAL',23,'DECIMAL[(M[,D])] [UNSIGNED] [ZEROFILL]\n\nA packed \"exact\" fixed-point number. M is the total number of digits\n(the precision) and D is the number of digits after the decimal point\n(the scale). The decimal point and (for negative numbers) the \"-\" sign\nare not counted in M. If D is 0, values have no decimal point or\nfractional part. The maximum number of digits (M) for DECIMAL is 65.\nThe maximum number of supported decimals (D) is 30. If D is omitted,\nthe default is 0. If M is omitted, the default is 10.\n\nUNSIGNED, if specified, disallows negative values.\n\nAll basic calculations (+, -, *, /) with DECIMAL columns are done with\na precision of 65 digits.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/numeric-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/numeric-type-overview.html'),(372,'CREATE FUNCTION',40,'The CREATE FUNCTION statement is used to create stored functions and\nuser-defined functions (UDFs):\n\no For information about creating stored functions, see [HELP CREATE\n  PROCEDURE].\n\no For information about creating user-defined functions, see [HELP\n  CREATE FUNCTION UDF].\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/create-function.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/create-function.html'),(373,'<',19,'Syntax:\n<\n\nLess than:\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/comparison-operators.html\n\n','mysql> SELECT 2 < 2;\n        -> 0\n','http://dev.mysql.com/doc/refman/5.6/en/comparison-operators.html'),(374,'MD5',12,'Syntax:\nMD5(str)\n\nCalculates an MD5 128-bit checksum for the string. The value is\nreturned as a string of 32 hex digits, or NULL if the argument was\nNULL. The return value can, for example, be used as a hash key. See the\nnotes at the beginning of this section about storing hash values\nefficiently.\n\nThe return value is a nonbinary string in the connection character set.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/encryption-functions.html\n\n','mysql> SELECT MD5(\'testing\');\n        -> \'ae2b1fca515949e5d54fb22b8ed95575\'\n','http://dev.mysql.com/doc/refman/5.6/en/encryption-functions.html'),(375,'DAYOFMONTH',32,'Syntax:\nDAYOFMONTH(date)\n\nReturns the day of the month for date, in the range 1 to 31, or 0 for\ndates such as \'0000-00-00\' or \'2008-00-00\' that have a zero day part.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html\n\n','mysql> SELECT DAYOFMONTH(\'2007-02-03\');\n        -> 3\n','http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html'),(376,'UNIX_TIMESTAMP',32,'Syntax:\nUNIX_TIMESTAMP(), UNIX_TIMESTAMP(date)\n\nIf called with no argument, returns a Unix timestamp (seconds since\n\'1970-01-01 00:00:00\' UTC) as an unsigned integer. If UNIX_TIMESTAMP()\nis called with a date argument, it returns the value of the argument as\nseconds since \'1970-01-01 00:00:00\' UTC. date may be a DATE string, a\nDATETIME string, a TIMESTAMP, or a number in the format YYMMDD or\nYYYYMMDD. The server interprets date as a value in the current time\nzone and converts it to an internal value in UTC. Clients can set their\ntime zone as described in\nhttp://dev.mysql.com/doc/refman/5.6/en/time-zone-support.html.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html\n\n','mysql> SELECT UNIX_TIMESTAMP();\n        -> 1196440210\nmysql> SELECT UNIX_TIMESTAMP(\'2007-11-30 10:30:19\');\n        -> 1196440219\n','http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html'),(377,'RENAME USER',10,'Syntax:\nRENAME USER old_user TO new_user\n    [, old_user TO new_user] ...\n\nThe RENAME USER statement renames existing MySQL accounts. To use it,\nyou must have the global CREATE USER privilege or the UPDATE privilege\nfor the mysql database. An error occurs if any old account does not\nexist or any new account exists. Each account name uses the format\ndescribed in http://dev.mysql.com/doc/refman/5.6/en/account-names.html.\nFor example:\n\nRENAME USER \'jeffrey\'@\'localhost\' TO \'jeff\'@\'127.0.0.1\';\n\nIf you specify only the user name part of the account name, a host name\npart of \'%\' is used.\n\nRENAME USER causes the privileges held by the old user to be those held\nby the new user. However, RENAME USER does not automatically drop or\ninvalidate databases or objects within them that the old user created.\nThis includes stored programs or views for which the DEFINER attribute\nnames the old user. Attempts to access such objects may produce an\nerror if they execute in definer security context. (For information\nabout security context, see\nhttp://dev.mysql.com/doc/refman/5.6/en/stored-programs-security.html.)\n\nThe privilege changes take effect as indicated in\nhttp://dev.mysql.com/doc/refman/5.6/en/privilege-changes.html.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/rename-user.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/rename-user.html'),(378,'NUMPOINTS',13,'NumPoints(ls)\n\nReturns the number of Point objects in the LineString value ls.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/geometry-property-functions.html\n\n','mysql> SET @ls = \'LineString(1 1,2 2,3 3)\';\nmysql> SELECT NumPoints(GeomFromText(@ls));\n+------------------------------+\n| NumPoints(GeomFromText(@ls)) |\n+------------------------------+\n|                            3 |\n+------------------------------+\n','http://dev.mysql.com/doc/refman/5.6/en/geometry-property-functions.html'),(379,'ALTER LOGFILE GROUP',40,'Syntax:\nALTER LOGFILE GROUP logfile_group\n    ADD UNDOFILE \'file_name\'\n    [INITIAL_SIZE [=] size]\n    [WAIT]\n    ENGINE [=] engine_name\n\nThis statement adds an UNDO file named \'file_name\' to an existing log\nfile group logfile_group. An ALTER LOGFILE GROUP statement has one and\nonly one ADD UNDOFILE clause. No DROP UNDOFILE clause is currently\nsupported.\n\n*Note*: All MySQL Cluster Disk Data objects share the same namespace.\nThis means that each Disk Data object must be uniquely named (and not\nmerely each Disk Data object of a given type). For example, you cannot\nhave a tablespace and an undo log file with the same name, or an undo\nlog file and a data file with the same name.\n\nThe optional INITIAL_SIZE parameter sets the UNDO file\'s initial size\nin bytes; if not specified, the initial size default to 128M (128\nmegabytes). You may optionally follow size with a one-letter\nabbreviation for an order of magnitude, similar to those used in\nmy.cnf. Generally, this is one of the letters M (for megabytes) or G\n(for gigabytes).\n\nOn 32-bit systems, the maximum supported value for INITIAL_SIZE is 4G.\n(Bug #29186)\n\nThe minimum permitted value for INITIAL_SIZE is 1M. (Bug #29574)\n\n*Note*: WAIT is parsed but otherwise ignored. This keyword currently\nhas no effect, and is intended for future expansion.\n\nThe ENGINE parameter (required) determines the storage engine which is\nused by this log file group, with engine_name being the name of the\nstorage engine. Currently, the only accepted values for engine_name are\n\"NDBCLUSTER\" and \"NDB\". The two values are equivalent.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/alter-logfile-group.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/alter-logfile-group.html'),(380,'LOCALTIMESTAMP',32,'Syntax:\nLOCALTIMESTAMP, LOCALTIMESTAMP([fsp])\n\nLOCALTIMESTAMP and LOCALTIMESTAMP() are synonyms for NOW().\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html'),(381,'ADDDATE',32,'Syntax:\nADDDATE(date,INTERVAL expr unit), ADDDATE(expr,days)\n\nWhen invoked with the INTERVAL form of the second argument, ADDDATE()\nis a synonym for DATE_ADD(). The related function SUBDATE() is a\nsynonym for DATE_SUB(). For information on the INTERVAL unit argument,\nsee the discussion for DATE_ADD().\n\nmysql> SELECT DATE_ADD(\'2008-01-02\', INTERVAL 31 DAY);\n        -> \'2008-02-02\'\nmysql> SELECT ADDDATE(\'2008-01-02\', INTERVAL 31 DAY);\n        -> \'2008-02-02\'\n\nWhen invoked with the days form of the second argument, MySQL treats it\nas an integer number of days to be added to expr.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html\n\n','mysql> SELECT ADDDATE(\'2008-01-02\', 31);\n        -> \'2008-02-02\'\n','http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html'),(382,'ALTER FUNCTION',40,'Syntax:\nALTER FUNCTION func_name [characteristic ...]\n\ncharacteristic:\n    COMMENT \'string\'\n  | LANGUAGE SQL\n  | { CONTAINS SQL | NO SQL | READS SQL DATA | MODIFIES SQL DATA }\n  | SQL SECURITY { DEFINER | INVOKER }\n\nThis statement can be used to change the characteristics of a stored\nfunction. More than one change may be specified in an ALTER FUNCTION\nstatement. However, you cannot change the parameters or body of a\nstored function using this statement; to make such changes, you must\ndrop and re-create the function using DROP FUNCTION and CREATE\nFUNCTION.\n\nYou must have the ALTER ROUTINE privilege for the function. (That\nprivilege is granted automatically to the function creator.) If binary\nlogging is enabled, the ALTER FUNCTION statement might also require the\nSUPER privilege, as described in\nhttp://dev.mysql.com/doc/refman/5.6/en/stored-programs-logging.html.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/alter-function.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/alter-function.html'),(383,'IS_FREE_LOCK',14,'Syntax:\nIS_FREE_LOCK(str)\n\nChecks whether the lock named str is free to use (that is, not locked).\nReturns 1 if the lock is free (no one is using the lock), 0 if the lock\nis in use, and NULL if an error occurs (such as an incorrect argument).\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/miscellaneous-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/miscellaneous-functions.html'),(384,'DEALLOCATE PREPARE',8,'Syntax:\n{DEALLOCATE | DROP} PREPARE stmt_name\n\nTo deallocate a prepared statement produced with PREPARE, use a\nDEALLOCATE PREPARE statement that refers to the prepared statement\nname. Attempting to execute a prepared statement after deallocating it\nresults in an error. If too many prepared statements are created and\nnot deallocated by either the DEALLOCATE PREPARE statement or the end\nof the session, you might encounter the upper limit enforced by the\nmax_prepared_stmt_count system variable.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/deallocate-prepare.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/deallocate-prepare.html'),(385,'TOUCHES',31,'Touches(g1,g2)\n\nReturns 1 or 0 to indicate whether g1 spatially touches g2. Two\ngeometries spatially touch if the interiors of the geometries do not\nintersect, but the boundary of one of the geometries intersects either\nthe boundary or the interior of the other.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/functions-for-testing-spatial-relations-between-geometric-objects.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/functions-for-testing-spatial-relations-between-geometric-objects.html'),(386,'AUTO_INCREMENT',23,'The AUTO_INCREMENT attribute can be used to generate a unique identity\nfor new rows:\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/example-auto-increment.html\n\n','CREATE TABLE animals (\n     id MEDIUMINT NOT NULL AUTO_INCREMENT,\n     name CHAR(30) NOT NULL,\n     PRIMARY KEY (id)\n);\n\nINSERT INTO animals (name) VALUES\n    (\'dog\'),(\'cat\'),(\'penguin\'),\n    (\'lax\'),(\'whale\'),(\'ostrich\');\n\nSELECT * FROM animals;\n','http://dev.mysql.com/doc/refman/5.6/en/example-auto-increment.html'),(387,'UNCOMPRESS',12,'Syntax:\nUNCOMPRESS(string_to_uncompress)\n\nUncompresses a string compressed by the COMPRESS() function. If the\nargument is not a compressed value, the result is NULL. This function\nrequires MySQL to have been compiled with a compression library such as\nzlib. Otherwise, the return value is always NULL.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/encryption-functions.html\n\n','mysql> SELECT UNCOMPRESS(COMPRESS(\'any string\'));\n        -> \'any string\'\nmysql> SELECT UNCOMPRESS(\'any string\');\n        -> NULL\n','http://dev.mysql.com/doc/refman/5.6/en/encryption-functions.html'),(388,'GEOMCOLLFROMTEXT',3,'GeomCollFromText(wkt[,srid]), GeometryCollectionFromText(wkt[,srid])\n\nConstructs a GEOMETRYCOLLECTION value using its WKT representation and\nSRID.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/creating-spatial-values.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/creating-spatial-values.html'),(389,'LAST_INSERT_ID',17,'Syntax:\nLAST_INSERT_ID(), LAST_INSERT_ID(expr)\n\nLAST_INSERT_ID() (with no argument) returns a BIGINT (64-bit) value\nrepresenting the first automatically generated value successfully\ninserted for an AUTO_INCREMENT column as a result of the most recently\nexecuted INSERT statement. The value of LAST_INSERT_ID() remains\nunchanged if no rows are successfully inserted.\n\nFor example, after inserting a row that generates an AUTO_INCREMENT\nvalue, you can get the value like this:\n\nmysql> SELECT LAST_INSERT_ID();\n        -> 195\n\nThe currently executing statement does not affect the value of\nLAST_INSERT_ID(). Suppose that you generate an AUTO_INCREMENT value\nwith one statement, and then refer to LAST_INSERT_ID() in a\nmultiple-row INSERT statement that inserts rows into a table with its\nown AUTO_INCREMENT column. The value of LAST_INSERT_ID() will remain\nstable in the second statement; its value for the second and later rows\nis not affected by the earlier row insertions. (However, if you mix\nreferences to LAST_INSERT_ID() and LAST_INSERT_ID(expr), the effect is\nundefined.)\n\nIf the previous statement returned an error, the value of\nLAST_INSERT_ID() is undefined. For transactional tables, if the\nstatement is rolled back due to an error, the value of LAST_INSERT_ID()\nis left undefined. For manual ROLLBACK, the value of LAST_INSERT_ID()\nis not restored to that before the transaction; it remains as it was at\nthe point of the ROLLBACK.\n\nWithin the body of a stored routine (procedure or function) or a\ntrigger, the value of LAST_INSERT_ID() changes the same way as for\nstatements executed outside the body of these kinds of objects. The\neffect of a stored routine or trigger upon the value of\nLAST_INSERT_ID() that is seen by following statements depends on the\nkind of routine:\n\no If a stored procedure executes statements that change the value of\n  LAST_INSERT_ID(), the changed value is seen by statements that follow\n  the procedure call.\n\no For stored functions and triggers that change the value, the value is\n  restored when the function or trigger ends, so following statements\n  will not see a changed value.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/information-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/information-functions.html'),(390,'FLOOR',4,'Syntax:\nFLOOR(X)\n\nReturns the largest integer value not greater than X.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/mathematical-functions.html\n\n','mysql> SELECT FLOOR(1.23);\n        -> 1\nmysql> SELECT FLOOR(-1.23);\n        -> -2\n','http://dev.mysql.com/doc/refman/5.6/en/mathematical-functions.html'),(391,'COS',4,'Syntax:\nCOS(X)\n\nReturns the cosine of X, where X is given in radians.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/mathematical-functions.html\n\n','mysql> SELECT COS(PI());\n        -> -1\n','http://dev.mysql.com/doc/refman/5.6/en/mathematical-functions.html'),(392,'STD',16,'Syntax:\nSTD(expr)\n\nReturns the population standard deviation of expr. This is an extension\nto standard SQL. The standard SQL function STDDEV_POP() can be used\ninstead.\n\nThis function returns NULL if there were no matching rows.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/group-by-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/group-by-functions.html'),(393,'DATE FUNCTION',32,'Syntax:\nDATE(expr)\n\nExtracts the date part of the date or datetime expression expr.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html\n\n','mysql> SELECT DATE(\'2003-12-31 01:02:03\');\n        -> \'2003-12-31\'\n','http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html'),(394,'TAN',4,'Syntax:\nTAN(X)\n\nReturns the tangent of X, where X is given in radians.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/mathematical-functions.html\n\n','mysql> SELECT TAN(PI());\n        -> -1.2246063538224e-16\nmysql> SELECT TAN(PI()+1);\n        -> 1.5574077246549\n','http://dev.mysql.com/doc/refman/5.6/en/mathematical-functions.html'),(395,'WEEKOFYEAR',32,'Syntax:\nWEEKOFYEAR(date)\n\nReturns the calendar week of the date as a number in the range from 1\nto 53. WEEKOFYEAR() is a compatibility function that is equivalent to\nWEEK(date,3).\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html\n\n','mysql> SELECT WEEKOFYEAR(\'2008-02-20\');\n        -> 8\n','http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html'),(396,'UNCOMPRESSED_LENGTH',12,'Syntax:\nUNCOMPRESSED_LENGTH(compressed_string)\n\nReturns the length that the compressed string had before being\ncompressed.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/encryption-functions.html\n\n','mysql> SELECT UNCOMPRESSED_LENGTH(COMPRESS(REPEAT(\'a\',30)));\n        -> 30\n','http://dev.mysql.com/doc/refman/5.6/en/encryption-functions.html'),(397,'SUBTIME',32,'Syntax:\nSUBTIME(expr1,expr2)\n\nSUBTIME() returns expr1 - expr2 expressed as a value in the same format\nas expr1. expr1 is a time or datetime expression, and expr2 is a time\nexpression.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html\n\n','mysql> SELECT SUBTIME(\'2007-12-31 23:59:59.999999\',\'1 1:1:1.000002\');\n        -> \'2007-12-30 22:58:58.999997\'\nmysql> SELECT SUBTIME(\'01:00:00.999999\', \'02:00:00.999998\');\n        -> \'-00:59:59.999999\'\n','http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html'),(398,'LOG2',4,'Syntax:\nLOG2(X)\n\nReturns the base-2 logarithm of X.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/mathematical-functions.html\n\n','mysql> SELECT LOG2(65536);\n        -> 16\nmysql> SELECT LOG2(-100);\n        -> NULL\n','http://dev.mysql.com/doc/refman/5.6/en/mathematical-functions.html'),(399,'POW',4,'Syntax:\nPOW(X,Y)\n\nReturns the value of X raised to the power of Y.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/mathematical-functions.html\n\n','mysql> SELECT POW(2,2);\n        -> 4\nmysql> SELECT POW(2,-2);\n        -> 0.25\n','http://dev.mysql.com/doc/refman/5.6/en/mathematical-functions.html'),(400,'DROP TABLE',40,'Syntax:\nDROP [TEMPORARY] TABLE [IF EXISTS]\n    tbl_name [, tbl_name] ...\n    [RESTRICT | CASCADE]\n\nDROP TABLE removes one or more tables. You must have the DROP privilege\nfor each table. All table data and the table definition are removed, so\nbe careful with this statement! If any of the tables named in the\nargument list do not exist, MySQL returns an error indicating by name\nwhich nonexisting tables it was unable to drop, but it also drops all\nof the tables in the list that do exist.\n\n*Important*: When a table is dropped, user privileges on the table are\nnot automatically dropped. See [HELP GRANT].\n\nNote that for a partitioned table, DROP TABLE permanently removes the\ntable definition, all of its partitions, and all of the data which was\nstored in those partitions. It also removes the partitioning definition\n(.par) file associated with the dropped table.\n\nUse IF EXISTS to prevent an error from occurring for tables that do not\nexist. A NOTE is generated for each nonexistent table when using IF\nEXISTS. See [HELP SHOW WARNINGS].\n\nRESTRICT and CASCADE are permitted to make porting easier. In MySQL\n5.6, they do nothing.\n\n*Note*: DROP TABLE automatically commits the current active\ntransaction, unless you use the TEMPORARY keyword.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/drop-table.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/drop-table.html'),(401,'NOW',32,'Syntax:\nNOW([fsp])\n\nReturns the current date and time as a value in \'YYYY-MM-DD HH:MM:SS\'\nor YYYYMMDDHHMMSS format, depending on whether the function is used in\na string or numeric context. The value is expressed in the current time\nzone.\n\nAs of MySQL 5.6.4, if the fsp argument is given to specify a fractional\nseconds precision from 0 to 6, the return value includes a fractional\nseconds part of that many digits. Before 5.6.4, any argument is\nignored.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html\n\n','mysql> SELECT NOW();\n        -> \'2007-12-15 23:50:26\'\nmysql> SELECT NOW() + 0;\n        -> 20071215235026.000000\n','http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html'),(402,'SHOW ENGINES',27,'Syntax:\nSHOW [STORAGE] ENGINES\n\nSHOW ENGINES displays status information about the server\'s storage\nengines. This is particularly useful for checking whether a storage\nengine is supported, or to see what the default engine is.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/show-engines.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/show-engines.html'),(403,'IS_IPV6',14,'Syntax:\nIS_IPV6(expr)\n\nReturns 1 if the argument is a valid IPv6 address specified as a\nstring, 0 otherwise. This function does not consider IPv4 addresses to\nbe valid IPv6 addresses.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/miscellaneous-functions.html\n\n','mysql> SELECT IS_IPV6(\'10.0.5.9\'), IS_IPV6(\'::1\');\n        -> 0, 1\n','http://dev.mysql.com/doc/refman/5.6/en/miscellaneous-functions.html'),(404,'LONGBLOB',23,'LONGBLOB\n\nA BLOB column with a maximum length of 4,294,967,295 or 4GB (232 - 1)\nbytes. The effective maximum length of LONGBLOB columns depends on the\nconfigured maximum packet size in the client/server protocol and\navailable memory. Each LONGBLOB value is stored using a 4-byte length\nprefix that indicates the number of bytes in the value.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/string-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/string-type-overview.html'),(405,'ST_OVERLAPS',31,'ST_Overlaps(g1,g2)\n\nReturns 1 or 0 to indicate whether g1 spatially overlaps g2. The term\nspatially overlaps is used if two geometries intersect and their\nintersection results in a geometry of the same dimension but not equal\nto either of the given geometries.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/functions-for-testing-spatial-relations-between-geometric-objects.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/functions-for-testing-spatial-relations-between-geometric-objects.html'),(406,'YEAR DATA TYPE',23,'YEAR[(2|4)]\n\nA year in two-digit or four-digit format. The default is four-digit\nformat. YEAR(2) or YEAR(4) differ in display format, but have the same\nrange of values. In four-digit format, values display as 1901 to 2155,\nand 0000. In two-digit format, values display as 70 to 69, representing\nyears from 1970 to 2069. MySQL displays YEAR values in YYYY or\nYYformat, but permits assignment of values to YEAR columns using either\nstrings or numbers.\n\n*Note*: The YEAR(2) data type has certain issues that you should\nconsider before choosing to use it. As of MySQL 5.6.6, YEAR(2) is\ndeprecated. YEAR(2) columns in existing tables are treated as before,\nbut YEAR(2) in new or altered tables are converted to YEAR(4). For more\ninformation, see\nhttp://dev.mysql.com/doc/refman/5.6/en/migrating-to-year4.html.\n\nFor additional information about YEAR display format and interpretation\nof input values, see http://dev.mysql.com/doc/refman/5.6/en/year.html.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/date-and-time-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/date-and-time-type-overview.html'),(407,'SUM',16,'Syntax:\nSUM([DISTINCT] expr)\n\nReturns the sum of expr. If the return set has no rows, SUM() returns\nNULL. The DISTINCT keyword can be used to sum only the distinct values\nof expr.\n\nSUM() returns NULL if there were no matching rows.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/group-by-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/group-by-functions.html'),(408,'REPEAT FUNCTION',38,'Syntax:\nREPEAT(str,count)\n\nReturns a string consisting of the string str repeated count times. If\ncount is less than 1, returns an empty string. Returns NULL if str or\ncount are NULL.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/string-functions.html\n\n','mysql> SELECT REPEAT(\'MySQL\', 3);\n        -> \'MySQLMySQLMySQL\'\n','http://dev.mysql.com/doc/refman/5.6/en/string-functions.html'),(409,'SOUNDEX',38,'Syntax:\nSOUNDEX(str)\n\nReturns a soundex string from str. Two strings that sound almost the\nsame should have identical soundex strings. A standard soundex string\nis four characters long, but the SOUNDEX() function returns an\narbitrarily long string. You can use SUBSTRING() on the result to get a\nstandard soundex string. All nonalphabetic characters in str are\nignored. All international alphabetic characters outside the A-Z range\nare treated as vowels.\n\n*Important*: When using SOUNDEX(), you should be aware of the following\nlimitations:\n\no This function, as currently implemented, is intended to work well\n  with strings that are in the English language only. Strings in other\n  languages may not produce reliable results.\n\no This function is not guaranteed to provide consistent results with\n  strings that use multi-byte character sets, including utf-8.\n\n  We hope to remove these limitations in a future release. See Bug\n  #22638 for more information.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/string-functions.html\n\n','mysql> SELECT SOUNDEX(\'Hello\');\n        -> \'H400\'\nmysql> SELECT SOUNDEX(\'Quadratically\');\n        -> \'Q36324\'\n','http://dev.mysql.com/doc/refman/5.6/en/string-functions.html'),(410,'MBRTOUCHES',6,'MBRTouches(g1,g2)\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of\nthe two geometries g1 and g2 touch. Two geometries spatially touch if\nthe interiors of the geometries do not intersect, but the boundary of\none of the geometries intersects either the boundary or the interior of\nthe other.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/functions-for-testing-spatial-relations-between-geometric-objects.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/functions-for-testing-spatial-relations-between-geometric-objects.html'),(411,'DROP EVENT',40,'Syntax:\nDROP EVENT [IF EXISTS] event_name\n\nThis statement drops the event named event_name. The event immediately\nceases being active, and is deleted completely from the server.\n\nIf the event does not exist, the error ERROR 1517 (HY000): Unknown\nevent \'event_name\' results. You can override this and cause the\nstatement to generate a warning for nonexistent events instead using IF\nEXISTS.\n\nThis statement requires the EVENT privilege for the schema to which the\nevent to be dropped belongs.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/drop-event.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/drop-event.html'),(412,'VARBINARY',23,'VARBINARY(M)\n\nThe VARBINARY type is similar to the VARCHAR type, but stores binary\nbyte strings rather than nonbinary character strings. M represents the\nmaximum column length in bytes.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/string-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/string-type-overview.html'),(413,'LOAD INDEX',27,'Syntax:\nLOAD INDEX INTO CACHE\n  tbl_index_list [, tbl_index_list] ...\n\ntbl_index_list:\n  tbl_name\n    [PARTITION (partition_list | ALL)]\n    [[INDEX|KEY] (index_name[, index_name] ...)]\n    [IGNORE LEAVES]\n\npartition_list:\n    partition_name[, partition_name][, ...]\n\nThe LOAD INDEX INTO CACHE statement preloads a table index into the key\ncache to which it has been assigned by an explicit CACHE INDEX\nstatement, or into the default key cache otherwise.\n\nLOAD INDEX INTO CACHE is used only for MyISAM tables. In MySQL 5.6, it\nis also supported for partitioned MyISAM tables; in addition, indexes\non partitioned tables can be preloaded for one, several, or all\npartitions.\n\nThe IGNORE LEAVES modifier causes only blocks for the nonleaf nodes of\nthe index to be preloaded.\n\nIGNORE LEAVES is also supported for partitioned MyISAM tables.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/load-index.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/load-index.html'),(414,'UNION',28,'Syntax:\nSELECT ...\nUNION [ALL | DISTINCT] SELECT ...\n[UNION [ALL | DISTINCT] SELECT ...]\n\nUNION is used to combine the result from multiple SELECT statements\ninto a single result set.\n\nThe column names from the first SELECT statement are used as the column\nnames for the results returned. Selected columns listed in\ncorresponding positions of each SELECT statement should have the same\ndata type. (For example, the first column selected by the first\nstatement should have the same type as the first column selected by the\nother statements.)\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/union.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/union.html'),(415,'TO_DAYS',32,'Syntax:\nTO_DAYS(date)\n\nGiven a date date, returns a day number (the number of days since year\n0).\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html\n\n','mysql> SELECT TO_DAYS(950501);\n        -> 728779\nmysql> SELECT TO_DAYS(\'2007-10-07\');\n        -> 733321\n','http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html'),(416,'SHOW CREATE DATABASE',27,'Syntax:\nSHOW CREATE {DATABASE | SCHEMA} [IF NOT EXISTS] db_name\n\nShows the CREATE DATABASE statement that creates the given database. If\nthe SHOW statement includes an IF NOT EXISTS clause, the output too\nincludes such a clause. SHOW CREATE SCHEMA is a synonym for SHOW CREATE\nDATABASE.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/show-create-database.html\n\n','mysql> SHOW CREATE DATABASE test\\G\n*************************** 1. row ***************************\n       Database: test\nCreate Database: CREATE DATABASE `test`\n                 /*!40100 DEFAULT CHARACTER SET latin1 */\n\nmysql> SHOW CREATE SCHEMA test\\G\n*************************** 1. row ***************************\n       Database: test\nCreate Database: CREATE DATABASE `test`\n                 /*!40100 DEFAULT CHARACTER SET latin1 */\n','http://dev.mysql.com/doc/refman/5.6/en/show-create-database.html'),(417,'SHOW INDEX',27,'Syntax:\nSHOW {INDEX | INDEXES | KEYS}\n    {FROM | IN} tbl_name\n    [{FROM | IN} db_name]\n    [WHERE expr]\n\nSHOW INDEX returns table index information. The format resembles that\nof the SQLStatistics call in ODBC. This statement requires some\nprivilege for any column in the table.\nYou can use db_name.tbl_name as an alternative to the tbl_name FROM\ndb_name syntax. These two statements are equivalent:\n\nSHOW INDEX FROM mytable FROM mydb;\nSHOW INDEX FROM mydb.mytable;\n\nThe WHERE clause can be given to select rows using more general\nconditions, as discussed in\nhttp://dev.mysql.com/doc/refman/5.6/en/extended-show.html.\n\nYou can also list a table\'s indexes with the mysqlshow -k db_name\ntbl_name command.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/show-index.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/show-index.html'),(418,'!',15,'Syntax:\nNOT, !\n\nLogical NOT. Evaluates to 1 if the operand is 0, to 0 if the operand is\nnonzero, and NOT NULL returns NULL.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/logical-operators.html\n\n','mysql> SELECT NOT 10;\n        -> 0\nmysql> SELECT NOT 0;\n        -> 1\nmysql> SELECT NOT NULL;\n        -> NULL\nmysql> SELECT ! (1+1);\n        -> 0\nmysql> SELECT ! 1+1;\n        -> 1\n','http://dev.mysql.com/doc/refman/5.6/en/logical-operators.html'),(419,'DOUBLE',23,'DOUBLE[(M,D)] [UNSIGNED] [ZEROFILL]\n\nA normal-size (double-precision) floating-point number. Permissible\nvalues are -1.7976931348623157E+308 to -2.2250738585072014E-308, 0, and\n2.2250738585072014E-308 to 1.7976931348623157E+308. These are the\ntheoretical limits, based on the IEEE standard. The actual range might\nbe slightly smaller depending on your hardware or operating system.\n\nM is the total number of digits and D is the number of digits following\nthe decimal point. If M and D are omitted, values are stored to the\nlimits permitted by the hardware. A double-precision floating-point\nnumber is accurate to approximately 15 decimal places.\n\nUNSIGNED, if specified, disallows negative values.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/numeric-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/numeric-type-overview.html'),(420,'DECLARE HANDLER',24,'Syntax:\nDECLARE handler_action HANDLER\n    FOR condition_value [, condition_value] ...\n    statement\n\nhandler_action:\n    CONTINUE\n  | EXIT\n  | UNDO\n\ncondition_value:\n    mysql_error_code\n  | SQLSTATE [VALUE] sqlstate_value\n  | condition_name\n  | SQLWARNING\n  | NOT FOUND\n  | SQLEXCEPTION\n\nThe DECLARE ... HANDLER statement specifies a handler that deals with\none or more conditions. If one of these conditions occurs, the\nspecified statement executes. statement can be a simple statement such\nas SET var_name = value, or a compound statement written using BEGIN\nand END (see [HELP BEGIN END]).\n\nHandler declarations must appear after variable or condition\ndeclarations.\n\nThe handler_action value indicates what action the handler takes after\nexecution of the handler statement:\n\no CONTINUE: Execution of the current program continues.\n\no EXIT: Execution terminates for the BEGIN ... END compound statement\n  in which the handler is declared. This is true even if the condition\n  occurs in an inner block.\n\no UNDO: Not supported.\n\nThe condition_value for DECLARE ... HANDLER indicates the specific\ncondition or class of conditions that activates the handler:\n\no A MySQL error code (a number) or an SQLSTATE value (a 5-character\n  string literal). You should not use MySQL error code 0 or SQLSTATE\n  values that begin with \'00\', because those indicate success rather\n  than an error condition. For a list of MySQL error codes and SQLSTATE\n  values, see\n  http://dev.mysql.com/doc/refman/5.6/en/error-messages-server.html.\n\no A condition name previously specified with DECLARE ... CONDITION. A\n  condition name can be associated with a MySQL error code or SQLSTATE\n  value. See [HELP DECLARE CONDITION].\n\no SQLWARNING is shorthand for the class of SQLSTATE values that begin\n  with \'01\'.\n\no NOT FOUND is shorthand for the class of SQLSTATE values that begin\n  with \'02\'. This is relevant within the context of cursors and is used\n  to control what happens when a cursor reaches the end of a data set.\n  If no more rows are available, a No Data condition occurs with\n  SQLSTATE value \'02000\'. To detect this condition, you can set up a\n  handler for it (or for a NOT FOUND condition). For an example, see\n  http://dev.mysql.com/doc/refman/5.6/en/cursors.html. This condition\n  also occurs for SELECT ... INTO var_list statements that retrieve no\n  rows.\n\no SQLEXCEPTION is shorthand for the class of SQLSTATE values that do\n  not begin with \'00\', \'01\', or \'02\'.\n\nFor information about how the server chooses handlers when a condition\noccurs, see http://dev.mysql.com/doc/refman/5.6/en/handler-scope.html.\n\nIf a condition occurs for which no handler has been declared, the\naction taken depends on the condition class:\n\no For SQLEXCEPTION conditions, the stored program terminates at the\n  statement that raised the condition, as if there were an EXIT\n  handler. If the program was called by another stored program, the\n  calling program handles the condition using the handler selection\n  rules applied to its own handlers.\n\no For SQLWARNING conditions, the program continues executing, as if\n  there were a CONTINUE handler.\n\no For NOT FOUND conditions, if the condition was raised normally, the\n  action is CONTINUE. If it was raised by SIGNAL or RESIGNAL, the\n  action is EXIT.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/declare-handler.html\n\n','mysql> CREATE TABLE test.t (s1 INT, PRIMARY KEY (s1));\nQuery OK, 0 rows affected (0.00 sec)\n\nmysql> delimiter //\n\nmysql> CREATE PROCEDURE handlerdemo ()\n    -> BEGIN\n    ->   DECLARE CONTINUE HANDLER FOR SQLSTATE \'23000\' SET @x2 = 1;\n    ->   SET @x = 1;\n    ->   INSERT INTO test.t VALUES (1);\n    ->   SET @x = 2;\n    ->   INSERT INTO test.t VALUES (1);\n    ->   SET @x = 3;\n    -> END;\n    -> //\nQuery OK, 0 rows affected (0.00 sec)\n\nmysql> CALL handlerdemo()//\nQuery OK, 0 rows affected (0.00 sec)\n\nmysql> SELECT @x//\n    +------+\n    | @x   |\n    +------+\n    | 3    |\n    +------+\n    1 row in set (0.00 sec)\n','http://dev.mysql.com/doc/refman/5.6/en/declare-handler.html'),(421,'TIME',23,'TIME[(fsp)]\n\nA time. The range is \'-838:59:59.000000\' to \'838:59:59.000000\'. MySQL\ndisplays TIME values in \'HH:MM:SS[.fraction]\' format, but permits\nassignment of values to TIME columns using either strings or numbers.\n\nAs of MySQL 5.6.4, an optional fsp value in the range from 0 to 6 may\nbe given to specify fractional seconds precision. A value of 0\nsignifies that there is no fractional part. If omitted, the default\nprecision is 0.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/date-and-time-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/date-and-time-type-overview.html'),(422,'SYSTEM_USER',17,'Syntax:\nSYSTEM_USER()\n\nSYSTEM_USER() is a synonym for USER().\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/information-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/information-functions.html'),(423,'CURRENT_DATE',32,'Syntax:\nCURRENT_DATE, CURRENT_DATE()\n\nCURRENT_DATE and CURRENT_DATE() are synonyms for CURDATE().\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html'),(424,'TRUNCATE TABLE',40,'Syntax:\nTRUNCATE [TABLE] tbl_name\n\nTRUNCATE TABLE empties a table completely. It requires the DROP\nprivilege.\n\nLogically, TRUNCATE TABLE is similar to a DELETE statement that deletes\nall rows, or a sequence of DROP TABLE and CREATE TABLE statements. To\nachieve high performance, it bypasses the DML method of deleting data.\nThus, it cannot be rolled back, it does not cause ON DELETE triggers to\nfire, and it cannot be performed for InnoDB tables with parent-child\nforeign key relationships.\n\nAlthough TRUNCATE TABLE is similar to DELETE, it is classified as a DDL\nstatement rather than a DML statement. It differs from DELETE in the\nfollowing ways in MySQL 5.6:\n\no Truncate operations drop and re-create the table, which is much\n  faster than deleting rows one by one, particularly for large tables.\n\no Truncate operations cause an implicit commit, and so cannot be rolled\n  back.\n\no Truncation operations cannot be performed if the session holds an\n  active table lock.\n\no TRUNCATE TABLE fails for an InnoDB table if there are any FOREIGN KEY\n  constraints from other tables that reference the table. Foreign key\n  constraints between columns of the same table are permitted.\n\no Truncation operations do not return a meaningful value for the number\n  of deleted rows. The usual result is \"0 rows affected,\" which should\n  be interpreted as \"no information.\"\n\no As long as the table format file tbl_name.frm is valid, the table can\n  be re-created as an empty table with TRUNCATE TABLE, even if the data\n  or index files have become corrupted.\n\no Any AUTO_INCREMENT value is reset to its start value. This is true\n  even for MyISAM and InnoDB, which normally do not reuse sequence\n  values.\n\no When used with partitioned tables, TRUNCATE TABLE preserves the\n  partitioning; that is, the data and index files are dropped and\n  re-created, while the partition definitions (.par) file is\n  unaffected.\n\no The TRUNCATE TABLE statement does not invoke ON DELETE triggers.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/truncate-table.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/truncate-table.html'),(425,'AREA',2,'Area(poly)\n\nReturns as a double-precision number the area of the Polygon value\npoly, as measured in its spatial reference system.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/geometry-property-functions.html\n\n','mysql> SET @poly = \'Polygon((0 0,0 3,3 0,0 0),(1 1,1 2,2 1,1 1))\';\nmysql> SELECT Area(GeomFromText(@poly));\n+---------------------------+\n| Area(GeomFromText(@poly)) |\n+---------------------------+\n|                         4 |\n+---------------------------+\n','http://dev.mysql.com/doc/refman/5.6/en/geometry-property-functions.html'),(426,'START SLAVE',8,'Syntax:\nSTART SLAVE [thread_types] [until_option] [connection_options]\n\nthread_types:\n    [thread_type [, thread_type] ... ]\n\nthread_type: \n    IO_THREAD | SQL_THREAD\n\nuntil_option:\n    UNTIL {   {SQL_BEFORE_GTIDS | SQL_AFTER_GTIDS} = gtid_set\n          |   MASTER_LOG_FILE = \'log_name\', MASTER_LOG_POS = log_pos\n          |   RELAY_LOG_FILE = \'log_name\', RELAY_LOG_POS = log_pos\n          |   SQL_AFTER_MTS_GAPS  }\n\nconnection_options: \n    [USER=\'user_name\'] [PASSWORD=\'user_pass\'] [DEFAULT_AUTH=\'plugin_name\'] [PLUGIN_DIR=\'plugin_dir\']\n\n\ngtid_set:\n    uuid_set [, uuid_set] ...\n    | \'\'\n\nuuid_set:\n    uuid:interval[:interval]...\n\nuuid:\n    hhhhhhhh-hhhh-hhhh-hhhh-hhhhhhhhhhhh\n\nh:\n    [0-9,A-F]\n\ninterval:\n    n[-n]\n\n    (n >= 1) \n\nSTART SLAVE with no thread_type options starts both of the slave\nthreads. The I/O thread reads events from the master server and stores\nthem in the relay log. The SQL thread reads events from the relay log\nand executes them. START SLAVE requires the SUPER privilege.\n\nIf START SLAVE succeeds in starting the slave threads, it returns\nwithout any error. However, even in that case, it might be that the\nslave threads start and then later stop (for example, because they do\nnot manage to connect to the master or read its binary log, or some\nother problem). START SLAVE does not warn you about this. You must\ncheck the slave\'s error log for error messages generated by the slave\nthreads, or check that they are running satisfactorily with SHOW SLAVE\nSTATUS.\n\nIn MySQL 5.6.7 and later, START SLAVE causes an implicit commit of an\nongoing transaction. See\nhttp://dev.mysql.com/doc/refman/5.6/en/implicit-commit.html.\n\nBeginning with MySQL 5.6.11, gtid_next must be set to AUTOMATIC before\nissuing this statement (Bug #16062608).\n\nMySQL 5.6.4 and later supports pluggable user-password authentication\nwith START SLAVE with the USER, PASSWORD, DEFAULT_AUTH and PLUGIN_DIR\noptions, as described in the following list:\n\no USER: User name. Cannot be set to an empty or null string, or left\n  unset if PASSWORD is used.\n\no PASSWORD: Password.\n\no DEFAULT_AUTH: Name of plugin; default is MySQL native authentication.\n\no PLUGIN_DIR: Location of plugin.\n\nStarting with MySQL 5.6.4, you cannot use the SQL_THREAD option when\nspecifying USER, PASSWORD, or both. (Bug #13083642).\n\nSee\nhttp://dev.mysql.com/doc/refman/5.6/en/pluggable-authentication.html,\nfor more information.\n\nIf an insecure connection is used with any these options, the server\nissues the warning Sending passwords in plain text without SSL/TLS is\nextremely insecure.\n\nStarting with MySQL 5.6.6, START SLAVE ... UNTIL supports two\nadditional options for use with global transaction identifiers (GTIDs)\n(see http://dev.mysql.com/doc/refman/5.6/en/replication-gtids.html).\nEach of these takes a set of one or more global transaction identifiers\ngtid_set as an argument (see\nhttp://dev.mysql.com/doc/refman/5.6/en/replication-gtids-concepts.html#\nreplication-gtids-concepts-gtid-sets, for more information).\n\nWhen no thread_type is specified, START SLAVE UNTIL SQL_BEFORE_GTIDS\ncauses both the slave SQL thread to process and the slave I/O thread to\nfetch transactions until both of them have reached the first\ntransaction whose GTID is listed in the gtid_set. START SLAVE UNTIL\nSQL_AFTER_GTIDS causes the slave threads to process all transactions\nuntil the last transaction in the gtid_set has been processed by both\nthreads. In other words, START SLAVE UNTIL SQL_BEFORE_GTIDS causes the\nslave SQL to process and I/O threads to fetch all transactions\noccurring before the first GTID in the gtid_set is reached, and START\nSLAVE UNTIL SQL_AFTER_GTIDS causes the slave threads to handle all\ntransactions, including those whose GTIDs are found in gtid_set, until\neach has encountered a transaction whose GTID is not part of the set.\nSQL_BEFORE_GTIDS and SQL_AFTER_GTIDS each support the SQL_THREAD and\nIO_THREAD options.\n\nFor example, START SLAVE SQL_THREAD UNTIL SQL_BEFORE_GTIDS =\n3E11FA47-71CA-11E1-9E33-C80AA9429562:11-56 causes the slave SQL thread\nto process all transactions originating from the master whose\nserver_uuid is 3E11FA47-71CA-11E1-9E33-C80AA9429562 until it encounters\nthe transaction having sequence number 11; it then stops without\nprocessing this transaction. In other words, all transactions up to and\nincluding the transaction with sequence number 10 are processed.\nExecuting START SLAVE IO_THREAD UNTIL SQL_AFTER_GTIDS =\n3E11FA47-71CA-11E1-9E33-C80AA9429562:11-56, on the other hand, would\ncause the slave I/O thread to obtain all transactions just mentioned\nfrom the master, including all of the transactions having the sequence\nnumbers 11 through 56, and then to stop without processing any\nadditional transactions; that is, the transaction having sequence\nnumber 56 would be the last transaction fetched by the slave I/O\nthread.\n\nWith neither the SQL_THREAD option nor the IO_THREAD option, the\nprevious statement would cause the slave SQL thread to execute all\ntransactions originating from this master, including all transactions\nwith sequence numbers 11 through 56, and then to stop without\nprocessing any additional transactions. The same command would also\ncause the slave I/O thread to start. When the SQL thread reaches the\ncondition, it is stopped. In other words, START SLAVE UNTIL\nSQL_BEFORE_GTIDS has the same effect as START SLAVE SQL_THREAD,\nIO_THREAD UNTIL SQL_BEFORE_GTIDS; the slave SQL thread and slave I/O\nthread are each started, and the SQL thread continues executing\ntransactions until the stop condition for that thread is met.\n(Similarly, START SLAVE UNTIL SQL_AFTER_GTIDS is effectively the same\nas START SLAVE SQL_THREAD, IO_THREAD UNTIL SQL_AFTER_GTIDS.)\n\n*Note*: The SQL_BEFORE_GTIDS and SQL_AFTER_GTIDS keywords are present\nin the MySQL 5.6.5 server; however, neither of them functioned\ncorrectly as options with START SLAVE [SQL_THREAD | IO_THREAD] UNTIL in\nthat version, and are therefore supported beginning only with MySQL\n5.6.6. (Bug#13810456)\n\nSTART SLAVE UNTIL SQL_AFTER_MTS_GAPS is available in MySQL 5.6.6 or\nlater. This statement causes a multi-threaded slave\'s SQL threads to\nrun until no more gaps are found in the relay log, and then to stop.\nThis statement can take an SQL_THREAD option, but the effects of the\nstatement remain unchanged. It has no effect on the slave I/O thread\n(and cannot be used with the IO_THREAD option). START SLAVE UNTIL\nSQL_AFTER_MTS_GAPS should be used before switching the slave from\nmulti-threaded mode to single-threaded mode (that is, when resetting\nslave_parallel_workers back to 0 from a positive, nonzero value) after\nslave has failed with errors in multi-threaded mode.\n\nTo change a failed multi-threaded slave to single-threaded mode, you\ncan issue the following series of statements, in the order shown:\n\nSTART SLAVE UNTIL SQL_AFTER_MTS_GAPS;\n\nSET @@GLOBAL.slave_parallel_workers = 0;\n\nSTART SLAVE SQL_THREAD;\n\nIf you were running the failed multi-threaded slave with\nrelay_log_recovery enabled, then you must issue START SLAVE UNTIL\nSQL_AFTER_MTS_GAPS prior to executing CHANGE MASTER TO. Otherwise the\nlatter statement fails.\n\n*Note*: It is possible to view the entire text of a running START SLAVE\n... statement, including any USER or PASSWORD values used, in the\noutput of SHOW PROCESSLIST. This is also true for the text of a running\nCHANGE MASTER TO statement, including any values it employs for\nMASTER_USER or MASTER_PASSWORD.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/start-slave.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/start-slave.html'),(427,'SHOW WARNINGS',27,'Syntax:\nSHOW WARNINGS [LIMIT [offset,] row_count]\nSHOW COUNT(*) WARNINGS\n\nSHOW WARNINGS shows information about the conditions (errors, warnings,\nand notes) that resulted from the last statement in the current session\nthat generated messages. It shows nothing if the last statement used a\ntable and generated no messages. (That is, a statement that uses a\ntable but generates no messages clears the message list.) Statements\nthat do not use tables and do not generate messages have no effect on\nthe message list.\n\nWarnings are generated for DML statements such as INSERT, UPDATE, and\nLOAD DATA INFILE as well as DDL statements such as CREATE TABLE and\nALTER TABLE.\n\nSHOW WARNINGS is also used following EXPLAIN EXTENDED, to display the\nextra information generated by EXPLAIN when the EXTENDED keyword is\nused. See http://dev.mysql.com/doc/refman/5.6/en/explain-extended.html.\n\nThe LIMIT clause has the same syntax as for the SELECT statement. See\nhttp://dev.mysql.com/doc/refman/5.6/en/select.html.\n\nA related statement, SHOW ERRORS, shows only the error conditions (it\nexcludes warnings and notes). See [HELP SHOW ERRORS]. GET DIAGNOSTICS\ncan be used to examine information for individual conditions. See [HELP\nGET DIAGNOSTICS].\n\nThe SHOW COUNT(*) WARNINGS statement displays the total number of\nerrors, warnings, and notes. You can also retrieve this number from the\nwarning_count system variable:\n\nSHOW COUNT(*) WARNINGS;\nSELECT @@warning_count;\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/show-warnings.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/show-warnings.html'),(428,'DROP USER',10,'Syntax:\nDROP USER user [, user] ...\n\nThe DROP USER statement removes one or more MySQL accounts and their\nprivileges. It removes privilege rows for the account from all grant\ntables. To use this statement, you must have the global CREATE USER\nprivilege or the DELETE privilege for the mysql database. Each account\nname uses the format described in\nhttp://dev.mysql.com/doc/refman/5.6/en/account-names.html. For example:\n\nDROP USER \'jeffrey\'@\'localhost\';\n\nIf you specify only the user name part of the account name, a host name\npart of \'%\' is used.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/drop-user.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/drop-user.html'),(429,'SUBSTRING',38,'Syntax:\nSUBSTRING(str,pos), SUBSTRING(str FROM pos), SUBSTRING(str,pos,len),\nSUBSTRING(str FROM pos FOR len)\n\nThe forms without a len argument return a substring from string str\nstarting at position pos. The forms with a len argument return a\nsubstring len characters long from string str, starting at position\npos. The forms that use FROM are standard SQL syntax. It is also\npossible to use a negative value for pos. In this case, the beginning\nof the substring is pos characters from the end of the string, rather\nthan the beginning. A negative value may be used for pos in any of the\nforms of this function.\n\nFor all forms of SUBSTRING(), the position of the first character in\nthe string from which the substring is to be extracted is reckoned as\n1.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/string-functions.html\n\n','mysql> SELECT SUBSTRING(\'Quadratically\',5);\n        -> \'ratically\'\nmysql> SELECT SUBSTRING(\'foobarbar\' FROM 4);\n        -> \'barbar\'\nmysql> SELECT SUBSTRING(\'Quadratically\',5,6);\n        -> \'ratica\'\nmysql> SELECT SUBSTRING(\'Sakila\', -3);\n        -> \'ila\'\nmysql> SELECT SUBSTRING(\'Sakila\', -5, 3);\n        -> \'aki\'\nmysql> SELECT SUBSTRING(\'Sakila\' FROM -4 FOR 2);\n        -> \'ki\'\n','http://dev.mysql.com/doc/refman/5.6/en/string-functions.html'),(430,'ISEMPTY',37,'IsEmpty(g)\n\nThis function is a placeholder that returns 0 for any valid geometry\nvalue, 1 for any invalid geometry value or NULL.\n\nMySQL does not support GIS EMPTY values such as POINT EMPTY.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/geometry-property-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/geometry-property-functions.html'),(431,'SHOW FUNCTION STATUS',27,'Syntax:\nSHOW FUNCTION STATUS\n    [LIKE \'pattern\' | WHERE expr]\n\nThis statement is similar to SHOW PROCEDURE STATUS but for stored\nfunctions. See [HELP SHOW PROCEDURE STATUS].\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/show-function-status.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/show-function-status.html'),(432,'LTRIM',38,'Syntax:\nLTRIM(str)\n\nReturns the string str with leading space characters removed.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/string-functions.html\n\n','mysql> SELECT LTRIM(\'  barbar\');\n        -> \'barbar\'\n','http://dev.mysql.com/doc/refman/5.6/en/string-functions.html'),(433,'ST_CROSSES',31,'ST_Crosses(g1,g2)\n\nReturns 1 if g1 spatially crosses g2. Returns NULL if g1 is a Polygon\nor a MultiPolygon, or if g2 is a Point or a MultiPoint. Otherwise,\nreturns 0.\n\nThe term spatially crosses denotes a spatial relation between two given\ngeometries that has the following properties:\n\no The two geometries intersect\n\no Their intersection results in a geometry that has a dimension that is\n  one less than the maximum dimension of the two given geometries\n\no Their intersection is not equal to either of the two given geometries\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/functions-for-testing-spatial-relations-between-geometric-objects.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/functions-for-testing-spatial-relations-between-geometric-objects.html'),(434,'VALUES',14,'Syntax:\nVALUES(col_name)\n\nIn an INSERT ... ON DUPLICATE KEY UPDATE statement, you can use the\nVALUES(col_name) function in the UPDATE clause to refer to column\nvalues from the INSERT portion of the statement. In other words,\nVALUES(col_name) in the UPDATE clause refers to the value of col_name\nthat would be inserted, had no duplicate-key conflict occurred. This\nfunction is especially useful in multiple-row inserts. The VALUES()\nfunction is meaningful only in the ON DUPLICATE KEY UPDATE clause of\nINSERT statements and returns NULL otherwise. See\nhttp://dev.mysql.com/doc/refman/5.6/en/insert-on-duplicate.html.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/miscellaneous-functions.html\n\n','mysql> INSERT INTO table (a,b,c) VALUES (1,2,3),(4,5,6)\n    -> ON DUPLICATE KEY UPDATE c=VALUES(a)+VALUES(b);\n','http://dev.mysql.com/doc/refman/5.6/en/miscellaneous-functions.html'),(435,'MBRDISJOINT',6,'MBRDisjoint(g1,g2)\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of\nthe two geometries g1 and g2 are disjoint (do not intersect).\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/functions-for-testing-spatial-relations-between-geometric-objects.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/functions-for-testing-spatial-relations-between-geometric-objects.html'),(436,'CALL',28,'Syntax:\nCALL sp_name([parameter[,...]])\nCALL sp_name[()]\n\nThe CALL statement invokes a stored procedure that was defined\npreviously with CREATE PROCEDURE.\n\nStored procedures that take no arguments can be invoked without\nparentheses. That is, CALL p() and CALL p are equivalent.\n\nCALL can pass back values to its caller using parameters that are\ndeclared as OUT or INOUT parameters. When the procedure returns, a\nclient program can also obtain the number of rows affected for the\nfinal statement executed within the routine: At the SQL level, call the\nROW_COUNT() function; from the C API, call the mysql_affected_rows()\nfunction.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/call.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/call.html'),(437,'ENCODE',12,'Syntax:\nENCODE(str,pass_str)\n\nEncrypt str using pass_str as the password. To decrypt the result, use\nDECODE().\n\nThe result is a binary string of the same length as str.\n\nThe strength of the encryption is based on how good the random\ngenerator is. It should suffice for short strings.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/encryption-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/encryption-functions.html'),(438,'SUBSTRING_INDEX',38,'Syntax:\nSUBSTRING_INDEX(str,delim,count)\n\nReturns the substring from string str before count occurrences of the\ndelimiter delim. If count is positive, everything to the left of the\nfinal delimiter (counting from the left) is returned. If count is\nnegative, everything to the right of the final delimiter (counting from\nthe right) is returned. SUBSTRING_INDEX() performs a case-sensitive\nmatch when searching for delim.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/string-functions.html\n\n','mysql> SELECT SUBSTRING_INDEX(\'www.mysql.com\', \'.\', 2);\n        -> \'www.mysql\'\nmysql> SELECT SUBSTRING_INDEX(\'www.mysql.com\', \'.\', -2);\n        -> \'mysql.com\'\n','http://dev.mysql.com/doc/refman/5.6/en/string-functions.html'),(439,'TIMESTAMPADD',32,'Syntax:\nTIMESTAMPADD(unit,interval,datetime_expr)\n\nAdds the integer expression interval to the date or datetime expression\ndatetime_expr. The unit for interval is given by the unit argument,\nwhich should be one of the following values: MICROSECOND\n(microseconds), SECOND, MINUTE, HOUR, DAY, WEEK, MONTH, QUARTER, or\nYEAR.\n\nThe unit value may be specified using one of keywords as shown, or with\na prefix of SQL_TSI_. For example, DAY and SQL_TSI_DAY both are legal.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html\n\n','mysql> SELECT TIMESTAMPADD(MINUTE,1,\'2003-01-02\');\n        -> \'2003-01-02 00:01:00\'\nmysql> SELECT TIMESTAMPADD(WEEK,1,\'2003-01-02\');\n        -> \'2003-01-09\'\n','http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html'),(440,'TRUNCATE',4,'Syntax:\nTRUNCATE(X,D)\n\nReturns the number X, truncated to D decimal places. If D is 0, the\nresult has no decimal point or fractional part. D can be negative to\ncause D digits left of the decimal point of the value X to become zero.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/mathematical-functions.html\n\n','mysql> SELECT TRUNCATE(1.223,1);\n        -> 1.2\nmysql> SELECT TRUNCATE(1.999,1);\n        -> 1.9\nmysql> SELECT TRUNCATE(1.999,0);\n        -> 1\nmysql> SELECT TRUNCATE(-1.999,1);\n        -> -1.9\nmysql> SELECT TRUNCATE(122,-2);\n       -> 100\nmysql> SELECT TRUNCATE(10.28*100,0);\n       -> 1028\n','http://dev.mysql.com/doc/refman/5.6/en/mathematical-functions.html'),(441,'SHOW',27,'SHOW has many forms that provide information about databases, tables,\ncolumns, or status information about the server. This section describes\nthose following:\n\nSHOW AUTHORS\nSHOW {BINARY | MASTER} LOGS\nSHOW BINLOG EVENTS [IN \'log_name\'] [FROM pos] [LIMIT [offset,] row_count]\nSHOW CHARACTER SET [like_or_where]\nSHOW COLLATION [like_or_where]\nSHOW [FULL] COLUMNS FROM tbl_name [FROM db_name] [like_or_where]\nSHOW CONTRIBUTORS\nSHOW CREATE DATABASE db_name\nSHOW CREATE EVENT event_name\nSHOW CREATE FUNCTION func_name\nSHOW CREATE PROCEDURE proc_name\nSHOW CREATE TABLE tbl_name\nSHOW CREATE TRIGGER trigger_name\nSHOW CREATE VIEW view_name\nSHOW DATABASES [like_or_where]\nSHOW ENGINE engine_name {STATUS | MUTEX}\nSHOW [STORAGE] ENGINES\nSHOW ERRORS [LIMIT [offset,] row_count]\nSHOW EVENTS\nSHOW FUNCTION CODE func_name\nSHOW FUNCTION STATUS [like_or_where]\nSHOW GRANTS FOR user\nSHOW INDEX FROM tbl_name [FROM db_name]\nSHOW MASTER STATUS\nSHOW OPEN TABLES [FROM db_name] [like_or_where]\nSHOW PLUGINS\nSHOW PROCEDURE CODE proc_name\nSHOW PROCEDURE STATUS [like_or_where]\nSHOW PRIVILEGES\nSHOW [FULL] PROCESSLIST\nSHOW PROFILE [types] [FOR QUERY n] [OFFSET n] [LIMIT n]\nSHOW PROFILES\nSHOW SLAVE HOSTS\nSHOW SLAVE STATUS\nSHOW [GLOBAL | SESSION] STATUS [like_or_where]\nSHOW TABLE STATUS [FROM db_name] [like_or_where]\nSHOW [FULL] TABLES [FROM db_name] [like_or_where]\nSHOW TRIGGERS [FROM db_name] [like_or_where]\nSHOW [GLOBAL | SESSION] VARIABLES [like_or_where]\nSHOW WARNINGS [LIMIT [offset,] row_count]\n\nlike_or_where:\n    LIKE \'pattern\'\n  | WHERE expr\n\nIf the syntax for a given SHOW statement includes a LIKE \'pattern\'\npart, \'pattern\' is a string that can contain the SQL \"%\" and \"_\"\nwildcard characters. The pattern is useful for restricting statement\noutput to matching values.\n\nSeveral SHOW statements also accept a WHERE clause that provides more\nflexibility in specifying which rows to display. See\nhttp://dev.mysql.com/doc/refman/5.6/en/extended-show.html.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/show.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/show.html'),(442,'SHOW VARIABLES',27,'Syntax:\nSHOW [GLOBAL | SESSION] VARIABLES\n    [LIKE \'pattern\' | WHERE expr]\n\nSHOW VARIABLES shows the values of MySQL system variables. This\ninformation also can be obtained using the mysqladmin variables\ncommand. The LIKE clause, if present, indicates which variable names to\nmatch. The WHERE clause can be given to select rows using more general\nconditions, as discussed in\nhttp://dev.mysql.com/doc/refman/5.6/en/extended-show.html. This\nstatement does not require any privilege. It requires only the ability\nto connect to the server.\n\nWith the GLOBAL modifier, SHOW VARIABLES displays the values that are\nused for new connections to MySQL. In MySQL 5.6, if a variable has no\nglobal value, no value is displayed. With SESSION, SHOW VARIABLES\ndisplays the values that are in effect for the current connection. If\nno modifier is present, the default is SESSION. LOCAL is a synonym for\nSESSION.\nWith a LIKE clause, the statement displays only rows for those\nvariables with names that match the pattern. To obtain the row for a\nspecific variable, use a LIKE clause as shown:\n\nSHOW VARIABLES LIKE \'max_join_size\';\nSHOW SESSION VARIABLES LIKE \'max_join_size\';\n\nTo get a list of variables whose name match a pattern, use the \"%\"\nwildcard character in a LIKE clause:\n\nSHOW VARIABLES LIKE \'%size%\';\nSHOW GLOBAL VARIABLES LIKE \'%size%\';\n\nWildcard characters can be used in any position within the pattern to\nbe matched. Strictly speaking, because \"_\" is a wildcard that matches\nany single character, you should escape it as \"\\_\" to match it\nliterally. In practice, this is rarely necessary.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/show-variables.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/show-variables.html'),(443,'BINLOG',27,'Syntax:\nBINLOG \'str\'\n\nBINLOG is an internal-use statement. It is generated by the mysqlbinlog\nprogram as the printable representation of certain events in binary log\nfiles. (See http://dev.mysql.com/doc/refman/5.6/en/mysqlbinlog.html.)\nThe \'str\' value is a base 64-encoded string the that server decodes to\ndetermine the data change indicated by the corresponding event. This\nstatement requires the SUPER privilege.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/binlog.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/binlog.html'),(444,'ST_DISJOINT',31,'ST_Disjoint(g1,g2)\n\nReturns 1 or 0 to indicate whether g1 is spatially disjoint from (does\nnot intersect) g2.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/functions-for-testing-spatial-relations-between-geometric-objects.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/functions-for-testing-spatial-relations-between-geometric-objects.html'),(445,'ATAN2',4,'Syntax:\nATAN(Y,X), ATAN2(Y,X)\n\nReturns the arc tangent of the two variables X and Y. It is similar to\ncalculating the arc tangent of Y / X, except that the signs of both\narguments are used to determine the quadrant of the result.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/mathematical-functions.html\n\n','mysql> SELECT ATAN(-2,2);\n        -> -0.78539816339745\nmysql> SELECT ATAN2(PI(),0);\n        -> 1.5707963267949\n','http://dev.mysql.com/doc/refman/5.6/en/mathematical-functions.html'),(446,'HOUR',32,'Syntax:\nHOUR(time)\n\nReturns the hour for time. The range of the return value is 0 to 23 for\ntime-of-day values. However, the range of TIME values actually is much\nlarger, so HOUR can return values greater than 23.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html\n\n','mysql> SELECT HOUR(\'10:05:03\');\n        -> 10\nmysql> SELECT HOUR(\'272:59:59\');\n        -> 272\n','http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html'),(447,'SELECT',28,'Syntax:\nSELECT\n    [ALL | DISTINCT | DISTINCTROW ]\n      [HIGH_PRIORITY]\n      [STRAIGHT_JOIN]\n      [SQL_SMALL_RESULT] [SQL_BIG_RESULT] [SQL_BUFFER_RESULT]\n      [SQL_CACHE | SQL_NO_CACHE] [SQL_CALC_FOUND_ROWS]\n    select_expr [, select_expr ...]\n    [FROM table_references\n      [PARTITION partition_list]\n    [WHERE where_condition]\n    [GROUP BY {col_name | expr | position}\n      [ASC | DESC], ... [WITH ROLLUP]]\n    [HAVING where_condition]\n    [ORDER BY {col_name | expr | position}\n      [ASC | DESC], ...]\n    [LIMIT {[offset,] row_count | row_count OFFSET offset}]\n    [PROCEDURE procedure_name(argument_list)]\n    [INTO OUTFILE \'file_name\'\n        [CHARACTER SET charset_name]\n        export_options\n      | INTO DUMPFILE \'file_name\'\n      | INTO var_name [, var_name]]\n    [FOR UPDATE | LOCK IN SHARE MODE]]\n\nSELECT is used to retrieve rows selected from one or more tables, and\ncan include UNION statements and subqueries. See [HELP UNION], and\nhttp://dev.mysql.com/doc/refman/5.6/en/subqueries.html.\n\nThe most commonly used clauses of SELECT statements are these:\n\no Each select_expr indicates a column that you want to retrieve. There\n  must be at least one select_expr.\n\no table_references indicates the table or tables from which to retrieve\n  rows. Its syntax is described in [HELP JOIN].\n\no Starting in MySQL 5.6.2, SELECT supports explicit partition selection\n  using the PARTITION keyword with a list of partitions or\n  subpartitions (or both) following the name of the table in a\n  table_reference (see [HELP JOIN]). In this case, rows are selected\n  only from the partitions listed, and any other partitions of the\n  table are ignored. For more information and examples, see\n  http://dev.mysql.com/doc/refman/5.6/en/partitioning-selection.html.\n\n  In MySQL 5.6.6 and later, SELECT ... PARTITION from tables using\n  storage engines such as MyISAM that perform table-level locks (and\n  thus partition locks) lock only the partitions or subpartitions named\n  by the PARTITION option.\n\n  See\n  http://dev.mysql.com/doc/refman/5.6/en/partitioning-limitations-locki\n  ng.html, for more information.\n\no The WHERE clause, if given, indicates the condition or conditions\n  that rows must satisfy to be selected. where_condition is an\n  expression that evaluates to true for each row to be selected. The\n  statement selects all rows if there is no WHERE clause.\n\n  In the WHERE expression, you can use any of the functions and\n  operators that MySQL supports, except for aggregate (summary)\n  functions. See\n  http://dev.mysql.com/doc/refman/5.6/en/expressions.html, and\n  http://dev.mysql.com/doc/refman/5.6/en/functions.html.\n\nSELECT can also be used to retrieve rows computed without reference to\nany table.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/select.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/select.html'),(448,'GROUP_CONCAT',16,'Syntax:\nGROUP_CONCAT(expr)\n\nThis function returns a string result with the concatenated non-NULL\nvalues from a group. It returns NULL if there are no non-NULL values.\nThe full syntax is as follows:\n\nGROUP_CONCAT([DISTINCT] expr [,expr ...]\n             [ORDER BY {unsigned_integer | col_name | expr}\n                 [ASC | DESC] [,col_name ...]]\n             [SEPARATOR str_val])\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/group-by-functions.html\n\n','mysql> SELECT student_name,\n    ->     GROUP_CONCAT(test_score)\n    ->     FROM student\n    ->     GROUP BY student_name;\n','http://dev.mysql.com/doc/refman/5.6/en/group-by-functions.html'),(449,'BENCHMARK',17,'Syntax:\nBENCHMARK(count,expr)\n\nThe BENCHMARK() function executes the expression expr repeatedly count\ntimes. It may be used to time how quickly MySQL processes the\nexpression. The result value is always 0. The intended use is from\nwithin the mysql client, which reports query execution times:\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/information-functions.html\n\n','mysql> SELECT BENCHMARK(1000000,ENCODE(\'hello\',\'goodbye\'));\n+----------------------------------------------+\n| BENCHMARK(1000000,ENCODE(\'hello\',\'goodbye\')) |\n+----------------------------------------------+\n|                                            0 |\n+----------------------------------------------+\n1 row in set (4.74 sec)\n','http://dev.mysql.com/doc/refman/5.6/en/information-functions.html'),(450,'NAME_CONST',14,'Syntax:\nNAME_CONST(name,value)\n\nReturns the given value. When used to produce a result set column,\nNAME_CONST() causes the column to have the given name. The arguments\nshould be constants.\n\nmysql> SELECT NAME_CONST(\'myname\', 14);\n+--------+\n| myname |\n+--------+\n|     14 |\n+--------+\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/miscellaneous-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/miscellaneous-functions.html'),(451,'SHOW ENGINE',27,'Syntax:\nSHOW ENGINE engine_name {STATUS | MUTEX}\n\nSHOW ENGINE displays operational information about a storage engine.\nThe following statements currently are supported:\n\nSHOW ENGINE INNODB STATUS\nSHOW ENGINE INNODB MUTEX\nSHOW ENGINE {NDB | NDBCLUSTER} STATUS\nSHOW ENGINE PERFORMANCE_SCHEMA STATUS\n\nSHOW ENGINE INNODB STATUS displays extensive information from the\nstandard InnoDB Monitor about the state of the InnoDB storage engine.\nFor information about the standard monitor and other InnoDB Monitors\nthat provide information about InnoDB processing, see\nhttp://dev.mysql.com/doc/refman/5.6/en/innodb-monitors.html.\n\nSHOW ENGINE INNODB MUTEX displays InnoDB mutex statistics. The\nstatement displays the following fields:\n\no Type\n\n  Always InnoDB.\n\no Name\n\n  The source file where the mutex is implemented, and the line number\n  in the file where the mutex is created. The line number may change\n  depending on your version of MySQL.\n\no Status\n\n  The mutex status. This field displays several values if UNIV_DEBUG\n  was defined at MySQL compilation time (for example, in include/univ.i\n  in the InnoDB part of the MySQL source tree). If UNIV_DEBUG was not\n  defined, the statement displays only the os_waits value. In the\n  latter case (without UNIV_DEBUG), the information on which the output\n  is based is insufficient to distinguish regular mutexes and mutexes\n  that protect rw-locks (which permit multiple readers or a single\n  writer). Consequently, the output may appear to contain multiple rows\n  for the same mutex.\n\n  o count indicates how many times the mutex was requested.\n\n  o spin_waits indicates how many times the spinlock had to run.\n\n  o spin_rounds indicates the number of spinlock rounds. (spin_rounds\n    divided by spin_waits provides the average round count.)\n\n  o os_waits indicates the number of operating system waits. This\n    occurs when the spinlock did not work (the mutex was not locked\n    during the spinlock and it was necessary to yield to the operating\n    system and wait).\n\n  o os_yields indicates the number of times a the thread trying to lock\n    a mutex gave up its timeslice and yielded to the operating system\n    (on the presumption that permitting other threads to run will free\n    the mutex so that it can be locked).\n\n  o os_wait_times indicates the amount of time (in ms) spent in\n    operating system waits, if the timed_mutexes system variable is 1\n    (ON). If timed_mutexes is 0 (OFF), timing is disabled, so\n    os_wait_times is 0. timed_mutexes is off by default.\n\nInformation from this statement can be used to diagnose system\nproblems. For example, large values of spin_waits and spin_rounds may\nindicate scalability problems.\n\nUse SHOW ENGINE PERFORMANCE_SCHEMA STATUS to inspect the internal\noperation of the Performance Schema code:\n\nmysql> SHOW ENGINE PERFORMANCE_SCHEMA STATUS\\G\n...\n*************************** 3. row ***************************\n  Type: performance_schema\n  Name: events_waits_history.row_size\nStatus: 76\n*************************** 4. row ***************************\n  Type: performance_schema\n  Name: events_waits_history.row_count\nStatus: 10000\n*************************** 5. row ***************************\n  Type: performance_schema\n  Name: events_waits_history.memory\nStatus: 760000\n...\n*************************** 57. row ***************************\n  Type: performance_schema\n  Name: performance_schema.memory\nStatus: 26459600\n...\n\nThis statement is intended to help the DBA understand the effects that\ndifferent Performance Schema options have on memory requirements.\n\nName values consist of two parts, which name an internal buffer and a\nbuffer attribute, respectively. Interpret buffer names as follows:\n\no An internal buffer that is not exposed as a table is named within\n  parentheses. Examples: (pfs_cond_class).row_size,\n  (pfs_mutex_class).memory.\n\no An internal buffer that is exposed as a table in the\n  performance_schema database is named after the table, without\n  parentheses. Examples: events_waits_history.row_size,\n  mutex_instances.row_count.\n\no A value that applies to the Performance Schema as a whole begins with\n  performance_schema. Example: performance_schema.memory.\n\nBuffer attributes have these meanings:\n\no row_size is the size of the internal record used by the\n  implementation, such as the size of a row in a table. row_size values\n  cannot be changed.\n\no row_count is the number of internal records, such as the number of\n  rows in a table. row_count values can be changed using Performance\n  Schema configuration options.\n\no For a table, tbl_name.memory is the product of row_size and\n  row_count. For the Performance Schema as a whole,\n  performance_schema.memory is the sum of all the memory used (the sum\n  of all other memory values).\n\nIn some cases, there is a direct relationship between a Performance\nSchema configuration parameter and a SHOW ENGINE value. For example,\nevents_waits_history_long.row_count corresponds to\nperformance_schema_events_waits_history_long_size. In other cases, the\nrelationship is more complex. For example,\nevents_waits_history.row_count corresponds to\nperformance_schema_events_waits_history_size (the number of rows per\nthread) multiplied by performance_schema_max_thread_instances ( the\nnumber of threads).\n\nSHOW ENGINE NDB STATUS If the server has the NDB storage engine\nenabled, SHOW ENGINE NDB STATUS displays cluster status information\nsuch as the number of connected data nodes, the cluster connectstring,\nand cluster binlog epochs, as well as counts of various Cluster API\nobjects created by the MySQL Server when connected to the cluster.\nSample output from this statement is shown here:\n\nmysql> SHOW ENGINE NDB STATUS;\n+------------+-----------------------+--------------------------------------------------+\n| Type       | Name                  | Status                                           |\n+------------+-----------------------+--------------------------------------------------+\n| ndbcluster | connection            | cluster_node_id=7,\n  connected_host=192.168.0.103, connected_port=1186, number_of_data_nodes=4,\n  number_of_ready_data_nodes=3, connect_count=0                                         |\n| ndbcluster | NdbTransaction        | created=6, free=0, sizeof=212                    |\n| ndbcluster | NdbOperation          | created=8, free=8, sizeof=660                    |\n| ndbcluster | NdbIndexScanOperation | created=1, free=1, sizeof=744                    |\n| ndbcluster | NdbIndexOperation     | created=0, free=0, sizeof=664                    |\n| ndbcluster | NdbRecAttr            | created=1285, free=1285, sizeof=60               |\n| ndbcluster | NdbApiSignal          | created=16, free=16, sizeof=136                  |\n| ndbcluster | NdbLabel              | created=0, free=0, sizeof=196                    |\n| ndbcluster | NdbBranch             | created=0, free=0, sizeof=24                     |\n| ndbcluster | NdbSubroutine         | created=0, free=0, sizeof=68                     |\n| ndbcluster | NdbCall               | created=0, free=0, sizeof=16                     |\n| ndbcluster | NdbBlob               | created=1, free=1, sizeof=264                    |\n| ndbcluster | NdbReceiver           | created=4, free=0, sizeof=68                     |\n| ndbcluster | binlog                | latest_epoch=155467, latest_trans_epoch=148126,\n  latest_received_binlog_epoch=0, latest_handled_binlog_epoch=0,\n  latest_applied_binlog_epoch=0                                                         |\n+------------+-----------------------+--------------------------------------------------+\n\nThe rows with connection and binlog in the Name column were added to\nthe output of this statement in MySQL 5.1. The Status column in each of\nthese rows provides information about the MySQL server\'s connection to\nthe cluster and about the cluster binary log\'s status, respectively.\nThe Status information is in the form of comma-delimited set of\nname/value pairs.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/show-engine.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/show-engine.html'),(452,'RELEASE_LOCK',14,'Syntax:\nRELEASE_LOCK(str)\n\nReleases the lock named by the string str that was obtained with\nGET_LOCK(). Returns 1 if the lock was released, 0 if the lock was not\nestablished by this thread (in which case the lock is not released),\nand NULL if the named lock did not exist. The lock does not exist if it\nwas never obtained by a call to GET_LOCK() or if it has previously been\nreleased.\n\nThe DO statement is convenient to use with RELEASE_LOCK(). See [HELP\nDO].\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/miscellaneous-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/miscellaneous-functions.html'),(453,'WEEKDAY',32,'Syntax:\nWEEKDAY(date)\n\nReturns the weekday index for date (0 = Monday, 1 = Tuesday, ... 6 =\nSunday).\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html\n\n','mysql> SELECT WEEKDAY(\'2008-02-03 22:23:00\');\n        -> 6\nmysql> SELECT WEEKDAY(\'2007-11-06\');\n        -> 1\n','http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html'),(454,'TIME_TO_SEC',32,'Syntax:\nTIME_TO_SEC(time)\n\nReturns the time argument, converted to seconds.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html\n\n','mysql> SELECT TIME_TO_SEC(\'22:23:00\');\n        -> 80580\nmysql> SELECT TIME_TO_SEC(\'00:39:38\');\n        -> 2378\n','http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html'),(455,'CONVERT_TZ',32,'Syntax:\nCONVERT_TZ(dt,from_tz,to_tz)\n\nCONVERT_TZ() converts a datetime value dt from the time zone given by\nfrom_tz to the time zone given by to_tz and returns the resulting\nvalue. Time zones are specified as described in\nhttp://dev.mysql.com/doc/refman/5.6/en/time-zone-support.html. This\nfunction returns NULL if the arguments are invalid.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html\n\n','mysql> SELECT CONVERT_TZ(\'2004-01-01 12:00:00\',\'GMT\',\'MET\');\n        -> \'2004-01-01 13:00:00\'\nmysql> SELECT CONVERT_TZ(\'2004-01-01 12:00:00\',\'+00:00\',\'+10:00\');\n        -> \'2004-01-01 22:00:00\'\n','http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html'),(456,'EXPORT_SET',38,'Syntax:\nEXPORT_SET(bits,on,off[,separator[,number_of_bits]])\n\nReturns a string such that for every bit set in the value bits, you get\nan on string and for every bit not set in the value, you get an off\nstring. Bits in bits are examined from right to left (from low-order to\nhigh-order bits). Strings are added to the result from left to right,\nseparated by the separator string (the default being the comma\ncharacter \",\"). The number of bits examined is given by number_of_bits,\nwhich has a default of 64 if not specified. number_of_bits is silently\nclipped to 64 if larger than 64. It is treated as an unsigned integer,\nso a value of -1 is effectively the same as 64.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/string-functions.html\n\n','mysql> SELECT EXPORT_SET(5,\'Y\',\'N\',\',\',4);\n        -> \'Y,N,Y,N\'\nmysql> SELECT EXPORT_SET(6,\'1\',\'0\',\',\',10);\n        -> \'0,1,1,0,0,0,0,0,0,0\'\n','http://dev.mysql.com/doc/refman/5.6/en/string-functions.html'),(457,'CAST',38,'Syntax:\nCAST(expr AS type)\n\nThe CAST() function takes an expression of any type and produces a\nresult value of a specified type, similar to CONVERT(). See the\ndescription of CONVERT() for more information.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/cast-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/cast-functions.html'),(458,'SOUNDS LIKE',38,'Syntax:\nexpr1 SOUNDS LIKE expr2\n\nThis is the same as SOUNDEX(expr1) = SOUNDEX(expr2).\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/string-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/string-functions.html'),(459,'PERIOD_DIFF',32,'Syntax:\nPERIOD_DIFF(P1,P2)\n\nReturns the number of months between periods P1 and P2. P1 and P2\nshould be in the format YYMM or YYYYMM. Note that the period arguments\nP1 and P2 are not date values.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html\n\n','mysql> SELECT PERIOD_DIFF(200802,200703);\n        -> 11\n','http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html'),(460,'AVG',16,'Syntax:\nAVG([DISTINCT] expr)\n\nReturns the average value of expr. The DISTINCT option can be used to\nreturn the average of the distinct values of expr.\n\nAVG() returns NULL if there were no matching rows.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/group-by-functions.html\n\n','mysql> SELECT student_name, AVG(test_score)\n    ->        FROM student\n    ->        GROUP BY student_name;\n','http://dev.mysql.com/doc/refman/5.6/en/group-by-functions.html'),(461,'QUOTE',38,'Syntax:\nQUOTE(str)\n\nQuotes a string to produce a result that can be used as a properly\nescaped data value in an SQL statement. The string is returned enclosed\nby single quotation marks and with each instance of backslash (\"\\\"),\nsingle quote (\"\'\"), ASCII NUL, and Control+Z preceded by a backslash.\nIf the argument is NULL, the return value is the word \"NULL\" without\nenclosing single quotation marks.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/string-functions.html\n\n','mysql> SELECT QUOTE(\'Don\\\'t!\');\n        -> \'Don\\\'t!\'\nmysql> SELECT QUOTE(NULL);\n        -> NULL\n','http://dev.mysql.com/doc/refman/5.6/en/string-functions.html'),(462,'IN',19,'Syntax:\nexpr IN (value,...)\n\nReturns 1 if expr is equal to any of the values in the IN list, else\nreturns 0. If all values are constants, they are evaluated according to\nthe type of expr and sorted. The search for the item then is done using\na binary search. This means IN is very quick if the IN value list\nconsists entirely of constants. Otherwise, type conversion takes place\naccording to the rules described in\nhttp://dev.mysql.com/doc/refman/5.6/en/type-conversion.html, but\napplied to all the arguments.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/comparison-operators.html\n\n','mysql> SELECT 2 IN (0,3,5,7);\n        -> 0\nmysql> SELECT \'wefwf\' IN (\'wee\',\'wefwf\',\'weg\');\n        -> 1\n','http://dev.mysql.com/doc/refman/5.6/en/comparison-operators.html'),(463,'QUARTER',32,'Syntax:\nQUARTER(date)\n\nReturns the quarter of the year for date, in the range 1 to 4.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html\n\n','mysql> SELECT QUARTER(\'2008-04-01\');\n        -> 2\n','http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html'),(464,'HELP COMMAND',27,'Syntax:\nmysql> help search_string\n\nIf you provide an argument to the help command, mysql uses it as a\nsearch string to access server-side help from the contents of the MySQL\nReference Manual. The proper operation of this command requires that\nthe help tables in the mysql database be initialized with help topic\ninformation (see\nhttp://dev.mysql.com/doc/refman/5.6/en/server-side-help-support.html).\n\nIf there is no match for the search string, the search fails:\n\nmysql> help me\n\nNothing found\nPlease try to run \'help contents\' for a list of all accessible topics\n\nUse help contents to see a list of the help categories:\n\nmysql> help contents\nYou asked for help about help category: \"Contents\"\nFor more information, type \'help <item>\', where <item> is one of the\nfollowing categories:\n   Account Management\n   Administration\n   Data Definition\n   Data Manipulation\n   Data Types\n   Functions\n   Functions and Modifiers for Use with GROUP BY\n   Geographic Features\n   Language Structure\n   Plugins\n   Storage Engines\n   Stored Routines\n   Table Maintenance\n   Transactions\n   Triggers\n\nIf the search string matches multiple items, mysql shows a list of\nmatching topics:\n\nmysql> help logs\nMany help items for your request exist.\nTo make a more specific request, please type \'help <item>\',\nwhere <item> is one of the following topics:\n   SHOW\n   SHOW BINARY LOGS\n   SHOW ENGINE\n   SHOW LOGS\n\nUse a topic as the search string to see the help entry for that topic:\n\nmysql> help show binary logs\nName: \'SHOW BINARY LOGS\'\nDescription:\nSyntax:\nSHOW BINARY LOGS\nSHOW MASTER LOGS\n\nLists the binary log files on the server. This statement is used as\npart of the procedure described in [purge-binary-logs], that shows how\nto determine which logs can be purged.\n\nmysql> SHOW BINARY LOGS;\n+---------------+-----------+\n| Log_name      | File_size |\n+---------------+-----------+\n| binlog.000015 |    724935 |\n| binlog.000016 |    733481 |\n+---------------+-----------+\n\nThe search string can contain the the wildcard characters \"%\" and \"_\".\nThese have the same meaning as for pattern-matching operations\nperformed with the LIKE operator. For example, HELP rep% returns a list\nof topics that begin with rep:\n\nmysql> HELP rep%\nMany help items for your request exist.\nTo make a more specific request, please type \'help <item>\',\nwhere <item> is one of the following\ntopics:\n   REPAIR TABLE\n   REPEAT FUNCTION\n   REPEAT LOOP\n   REPLACE\n   REPLACE FUNCTION\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/mysql-server-side-help.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/mysql-server-side-help.html'),(465,'POSITION',38,'Syntax:\nPOSITION(substr IN str)\n\nPOSITION(substr IN str) is a synonym for LOCATE(substr,str).\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/string-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/string-functions.html'),(466,'IS_USED_LOCK',14,'Syntax:\nIS_USED_LOCK(str)\n\nChecks whether the lock named str is in use (that is, locked). If so,\nit returns the connection identifier of the client that holds the lock.\nOtherwise, it returns NULL.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/miscellaneous-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/miscellaneous-functions.html'),(467,'POLYFROMTEXT',3,'PolyFromText(wkt[,srid]), PolygonFromText(wkt[,srid])\n\nConstructs a POLYGON value using its WKT representation and SRID.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/creating-spatial-values.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/creating-spatial-values.html'),(468,'DES_ENCRYPT',12,'Syntax:\nDES_ENCRYPT(str[,{key_num|key_str}])\n\nEncrypts the string with the given key using the Triple-DES algorithm.\n\nThis function works only if MySQL has been configured with SSL support.\nSee http://dev.mysql.com/doc/refman/5.6/en/ssl-connections.html.\n\nThe encryption key to use is chosen based on the second argument to\nDES_ENCRYPT(), if one was given. With no argument, the first key from\nthe DES key file is used. With a key_num argument, the given key number\n(0 to 9) from the DES key file is used. With a key_str argument, the\ngiven key string is used to encrypt str.\n\nThe key file can be specified with the --des-key-file server option.\n\nThe return string is a binary string where the first character is\nCHAR(128 | key_num). If an error occurs, DES_ENCRYPT() returns NULL.\n\nThe 128 is added to make it easier to recognize an encrypted key. If\nyou use a string key, key_num is 127.\n\nThe string length for the result is given by this formula:\n\nnew_len = orig_len + (8 - (orig_len % 8)) + 1\n\nEach line in the DES key file has the following format:\n\nkey_num des_key_str\n\nEach key_num value must be a number in the range from 0 to 9. Lines in\nthe file may be in any order. des_key_str is the string that is used to\nencrypt the message. There should be at least one space between the\nnumber and the key. The first key is the default key that is used if\nyou do not specify any key argument to DES_ENCRYPT().\n\nYou can tell MySQL to read new key values from the key file with the\nFLUSH DES_KEY_FILE statement. This requires the RELOAD privilege.\n\nOne benefit of having a set of default keys is that it gives\napplications a way to check for the existence of encrypted column\nvalues, without giving the end user the right to decrypt those values.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/encryption-functions.html\n\n','mysql> SELECT customer_address FROM customer_table \n     > WHERE crypted_credit_card = DES_ENCRYPT(\'credit_card_number\');\n','http://dev.mysql.com/doc/refman/5.6/en/encryption-functions.html'),(469,'ALTER USER',10,'Syntax:\nALTER USER user_specification\n    [, user_specification] ...\n\nuser_specification:\n    user PASSWORD EXPIRE\n\nThe ALTER USER statement alters MySQL accounts. To use it, you must\nhave the global CREATE USER privilege or the INSERT privilege for the\nmysql database. This statement was added in MySQL 5.6.6.\n\nFor each account, ALTER USER expires its password. For example:\n\nALTER USER \'jeffrey\'@\'localhost\' PASSWORD EXPIRE;\n\nThe account name uses the format described in\nhttp://dev.mysql.com/doc/refman/5.6/en/account-names.html. If you\nspecify only the user name part of the account name, a host name part\nof \'%\' is used.\n\nPassword expiration for an account affects the corresponding row of the\nmysql.user table: The server sets the password_expired column to \'Y\'.\n\n*Warning*: In MySQL 5.6.6, ALTER USER also sets the Password column to\nthe empty string, so do not use this statement until 5.6.7.\n\nAfter an account\'s password has been expired, all operations performed\nin subsequent connections to the server using the account result in an\nerror until the user issues a SET PASSWORD statement to establish a new\naccount password:\n\nmysql> SELECT 1;\nERROR 1820 (HY000): You must SET PASSWORD before executing this statement\n\nmysql> SET PASSWORD = PASSWORD(\'new_password\');\nQuery OK, 0 rows affected (0.01 sec)\n\nmysql> SELECT 1;\n+---+\n| 1 |\n+---+\n| 1 |\n+---+\n1 row in set (0.00 sec)\n\nAs of MySQL 5.6.8, this restricted mode of operation also permits SET\nstatements, which is useful if the account password uses a hashing\nformat that requires old_passwords to be set to a value different from\nits default.\n\nIt is also possible for an administrative user to reset the account\npassword, but any existing connections for the account remain under\nrestriction. Clients using the account must disconnect and reconnect\nbefore statements can be executed successfully.\n\nIt is possible after password expiration to \"reset\" a password by using\nSET PASSWORD to set it to its current value. As a matter of good\npolicy, it is preferable to choose a different password.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/alter-user.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/alter-user.html'),(470,'CEIL',4,'Syntax:\nCEIL(X)\n\nCEIL() is a synonym for CEILING().\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/mathematical-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/mathematical-functions.html'),(471,'WAIT_UNTIL_SQL_THREAD_AFTER_GTIDS',17,'Syntax:\nWAIT_UNTIL_SQL_THREAD_AFTER_GTIDS(gtid_set[, timeout])\n\nWait until the slave SQL thread has executed all of the transactions\nwhose global transaction identifiers are contained in gtid_set (see\nhttp://dev.mysql.com/doc/refman/5.6/en/replication-gtids-concepts.html,\nfor a definition of \"GTID sets\"), or until timeout seconds have\nelapsed, whichever occurs first. timeout is optional; the default\ntimeout is 0 seconds, in which case the master simply waits until all\nof the transactions in the GTID set have been executed.\n\nPrior to MySQL 5.6.9, WAIT_UNTIL_SQL_THREAD_AFTER_GTIDS() was named\nSQL_THREAD_WAIT_AFTER_GTIDS(). (Bug #14775984)\n\nFor more information, see\nhttp://dev.mysql.com/doc/refman/5.6/en/replication-gtids.html.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/gtid-functions.html\n\n','mysql> SELECT WAIT_UNTIL_SQL_THREAD_AFTER_GTIDS(\'3E11FA47-71CA-11E1-9E33-C80AA9429562:1-5\');\n        -> 5\n','http://dev.mysql.com/doc/refman/5.6/en/gtid-functions.html'),(472,'LENGTH',38,'Syntax:\nLENGTH(str)\n\nReturns the length of the string str, measured in bytes. A multi-byte\ncharacter counts as multiple bytes. This means that for a string\ncontaining five 2-byte characters, LENGTH() returns 10, whereas\nCHAR_LENGTH() returns 5.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/string-functions.html\n\n','mysql> SELECT LENGTH(\'text\');\n        -> 4\n','http://dev.mysql.com/doc/refman/5.6/en/string-functions.html'),(473,'WEIGHT_STRING',38,'Syntax:\nWEIGHT_STRING(str [AS {CHAR|BINARY}(N)] [LEVEL levels] [flags])\n\nlevels: N [ASC|DESC|REVERSE] [, N [ASC|DESC|REVERSE]] ...\n\nThis function returns the weight string for the input string. The\nreturn value is a binary string that represents the sorting and\ncomparison value of the string. It has these properties:\n\no If WEIGHT_STRING(str1) = WEIGHT_STRING(str2), then str1 = str2 (str1\n  and str2 are considered equal)\n\no If WEIGHT_STRING(str1) < WEIGHT_STRING(str2), then str1 < str2 (str1\n  sorts before str2)\n\nWEIGHT_STRING() can be used for testing and debugging of collations,\nespecially if you are adding a new collation. See\nhttp://dev.mysql.com/doc/refman/5.6/en/adding-collation.html.\n\nThe input string, str, is a string expression. If the input is a\nnonbinary (character) string such as a CHAR, VARCHAR, or TEXT value,\nthe return value contains the collation weights for the string. If the\ninput is a binary (byte) string such as a BINARY, VARBINARY, or BLOB\nvalue, the return value is the same as the input (the weight for each\nbyte in a binary string is the byte value). If the input is NULL,\nWEIGHT_STRING() returns NULL.\n\nExamples:\n\nmysql> SET @s = _latin1 \'AB\' COLLATE latin1_swedish_ci;\nmysql> SELECT @s, HEX(@s), HEX(WEIGHT_STRING(@s));\n+------+---------+------------------------+\n| @s   | HEX(@s) | HEX(WEIGHT_STRING(@s)) |\n+------+---------+------------------------+\n| AB   | 4142    | 4142                   |\n+------+---------+------------------------+\n\nmysql> SET @s = _latin1 \'ab\' COLLATE latin1_swedish_ci;\nmysql> SELECT @s, HEX(@s), HEX(WEIGHT_STRING(@s));\n+------+---------+------------------------+\n| @s   | HEX(@s) | HEX(WEIGHT_STRING(@s)) |\n+------+---------+------------------------+\n| ab   | 6162    | 4142                   |\n+------+---------+------------------------+\n\nmysql> SET @s = CAST(\'AB\' AS BINARY);\nmysql> SELECT @s, HEX(@s), HEX(WEIGHT_STRING(@s));\n+------+---------+------------------------+\n| @s   | HEX(@s) | HEX(WEIGHT_STRING(@s)) |\n+------+---------+------------------------+\n| AB   | 4142    | 4142                   |\n+------+---------+------------------------+\n\nmysql> SET @s = CAST(\'ab\' AS BINARY);\nmysql> SELECT @s, HEX(@s), HEX(WEIGHT_STRING(@s));\n+------+---------+------------------------+\n| @s   | HEX(@s) | HEX(WEIGHT_STRING(@s)) |\n+------+---------+------------------------+\n| ab   | 6162    | 6162                   |\n+------+---------+------------------------+\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/string-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/string-functions.html'),(474,'ST_EQUALS',31,'ST_Equals(g1,g2)\n\nReturns 1 or 0 to indicate whether g1 is spatially equal to g2.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/functions-for-testing-spatial-relations-between-geometric-objects.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/functions-for-testing-spatial-relations-between-geometric-objects.html'),(475,'ALTER EVENT',40,'Syntax:\nALTER\n    [DEFINER = { user | CURRENT_USER }]\n    EVENT event_name\n    [ON SCHEDULE schedule]\n    [ON COMPLETION [NOT] PRESERVE]\n    [RENAME TO new_event_name]\n    [ENABLE | DISABLE | DISABLE ON SLAVE]\n    [COMMENT \'comment\']\n    [DO event_body]\n\nThe ALTER EVENT statement changes one or more of the characteristics of\nan existing event without the need to drop and recreate it. The syntax\nfor each of the DEFINER, ON SCHEDULE, ON COMPLETION, COMMENT, ENABLE /\nDISABLE, and DO clauses is exactly the same as when used with CREATE\nEVENT. (See [HELP CREATE EVENT].)\n\nAny user can alter an event defined on a database for which that user\nhas the EVENT privilege. When a user executes a successful ALTER EVENT\nstatement, that user becomes the definer for the affected event.\n\nALTER EVENT works only with an existing event:\n\nmysql> ALTER EVENT no_such_event \n     >     ON SCHEDULE \n     >       EVERY \'2:3\' DAY_HOUR;\nERROR 1517 (HY000): Unknown event \'no_such_event\'\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/alter-event.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/alter-event.html'),(476,'DATE_SUB',32,'Syntax:\nDATE_SUB(date,INTERVAL expr unit)\n\nSee the description for DATE_ADD().\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html'),(477,'|',20,'Syntax:\n|\n\nBitwise OR:\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/bit-functions.html\n\n','mysql> SELECT 29 | 15;\n        -> 31\n','http://dev.mysql.com/doc/refman/5.6/en/bit-functions.html'),(478,'UUID_SHORT',14,'Syntax:\nUUID_SHORT()\n\nReturns a \"short\" universal identifier as a 64-bit unsigned integer\n(rather than a string-form 128-bit identifier as returned by the UUID()\nfunction).\n\nThe value of UUID_SHORT() is guaranteed to be unique if the following\nconditions hold:\n\no The server_id of the current host is unique among your set of master\n  and slave servers\n\no server_id is between 0 and 255\n\no You do not set back your system time for your server between mysqld\n  restarts\n\no You do not invoke UUID_SHORT() on average more than 16 million times\n  per second between mysqld restarts\n\nThe UUID_SHORT() return value is constructed this way:\n\n  (server_id & 255) << 56\n+ (server_startup_time_in_seconds << 24)\n+ incremented_variable++;\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/miscellaneous-functions.html\n\n','mysql> SELECT UUID_SHORT();\n        -> 92395783831158784\n','http://dev.mysql.com/doc/refman/5.6/en/miscellaneous-functions.html'),(479,'GEOMFROMTEXT',3,'GeomFromText(wkt[,srid]), GeometryFromText(wkt[,srid])\n\nConstructs a geometry value of any type using its WKT representation\nand SRID.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/creating-spatial-values.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/creating-spatial-values.html'),(480,'DATEDIFF',32,'Syntax:\nDATEDIFF(expr1,expr2)\n\nDATEDIFF() returns expr1 - expr2 expressed as a value in days from one\ndate to the other. expr1 and expr2 are date or date-and-time\nexpressions. Only the date parts of the values are used in the\ncalculation.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html\n\n','mysql> SELECT DATEDIFF(\'2007-12-31 23:59:59\',\'2007-12-30\');\n        -> 1\nmysql> SELECT DATEDIFF(\'2010-11-30 23:59:59\',\'2010-12-31\');\n        -> -31\n','http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html'),(481,'DROP PROCEDURE',40,'Syntax:\nDROP {PROCEDURE | FUNCTION} [IF EXISTS] sp_name\n\nThis statement is used to drop a stored procedure or function. That is,\nthe specified routine is removed from the server. You must have the\nALTER ROUTINE privilege for the routine. (If the\nautomatic_sp_privileges system variable is enabled, that privilege and\nEXECUTE are granted automatically to the routine creator when the\nroutine is created and dropped from the creator when the routine is\ndropped. See\nhttp://dev.mysql.com/doc/refman/5.6/en/stored-routines-privileges.html.\n)\n\nThe IF EXISTS clause is a MySQL extension. It prevents an error from\noccurring if the procedure or function does not exist. A warning is\nproduced that can be viewed with SHOW WARNINGS.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/drop-procedure.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/drop-procedure.html'),(482,'INSTALL PLUGIN',5,'Syntax:\nINSTALL PLUGIN plugin_name SONAME \'shared_library_name\'\n\nThis statement installs a server plugin. It requires the INSERT\nprivilege for the mysql.plugin table.\n\nplugin_name is the name of the plugin as defined in the plugin\ndescriptor structure contained in the library file (see\nhttp://dev.mysql.com/doc/refman/5.6/en/plugin-data-structures.html).\nPlugin names are not case sensitive. For maximal compatibility, plugin\nnames should be limited to ASCII letters, digits, and underscore\nbecause they are used in C source files, shell command lines, M4 and\nBourne shell scripts, and SQL environments.\n\nshared_library_name is the name of the shared library that contains the\nplugin code. The name includes the file name extension (for example,\nlibmyplugin.so, libmyplugin.dll, or libmyplugin.dylib).\n\nThe shared library must be located in the plugin directory (the\ndirectory named by the plugin_dir system variable). The library must be\nin the plugin directory itself, not in a subdirectory. By default,\nplugin_dir is the plugin directory under the directory named by the\npkglibdir configuration variable, but it can be changed by setting the\nvalue of plugin_dir at server startup. For example, set its value in a\nmy.cnf file:\n\n[mysqld]\nplugin_dir=/path/to/plugin/directory\n\nIf the value of plugin_dir is a relative path name, it is taken to be\nrelative to the MySQL base directory (the value of the basedir system\nvariable).\n\nINSTALL PLUGIN loads and initializes the plugin code to make the plugin\navailable for use. A plugin is initialized by executing its\ninitialization function, which handles any setup that the plugin must\nperform before it can be used. When the server shuts down, it executes\nthe deinitialization function for each plugin that is loaded so that\nthe plugin has a change to perform any final cleanup.\n\nINSTALL PLUGIN also registers the plugin by adding a line that\nindicates the plugin name and library file name to the mysql.plugin\ntable. At server startup, the server loads and initializes any plugin\nthat is listed in the mysql.plugin table. This means that a plugin is\ninstalled with INSTALL PLUGIN only once, not every time the server\nstarts. Plugin loading at startup does not occur if the server is\nstarted with the --skip-grant-tables option.\n\nA plugin library can contain multiple plugins. For each of them to be\ninstalled, use a separate INSTALL PLUGIN statement. Each statement\nnames a different plugin, but all of them specify the same library\nname.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/install-plugin.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/install-plugin.html'),(483,'LOAD DATA',28,'Syntax:\nLOAD DATA [LOW_PRIORITY | CONCURRENT] [LOCAL] INFILE \'file_name\'\n    [REPLACE | IGNORE]\n    INTO TABLE tbl_name\n    [PARTITION (partition_name,...)]\n    [CHARACTER SET charset_name]\n    [{FIELDS | COLUMNS}\n        [TERMINATED BY \'string\']\n        [[OPTIONALLY] ENCLOSED BY \'char\']\n        [ESCAPED BY \'char\']\n    ]\n    [LINES\n        [STARTING BY \'string\']\n        [TERMINATED BY \'string\']\n    ]\n    [IGNORE number {LINES | ROWS}]\n    [(col_name_or_user_var,...)]\n    [SET col_name = expr,...]\n\nThe LOAD DATA INFILE statement reads rows from a text file into a table\nat a very high speed. LOAD DATA INFILE is the complement of SELECT ...\nINTO OUTFILE. (See\nhttp://dev.mysql.com/doc/refman/5.6/en/select-into.html.) To write data\nfrom a table to a file, use SELECT ... INTO OUTFILE. To read the file\nback into a table, use LOAD DATA INFILE. The syntax of the FIELDS and\nLINES clauses is the same for both statements. Both clauses are\noptional, but FIELDS must precede LINES if both are specified.\n\nYou can also load data files by using the mysqlimport utility; it\noperates by sending a LOAD DATA INFILE statement to the server. The\n--local option causes mysqlimport to read data files from the client\nhost. You can specify the --compress option to get better performance\nover slow networks if the client and server support the compressed\nprotocol. See http://dev.mysql.com/doc/refman/5.6/en/mysqlimport.html.\n\nFor more information about the efficiency of INSERT versus LOAD DATA\nINFILE and speeding up LOAD DATA INFILE, see\nhttp://dev.mysql.com/doc/refman/5.6/en/insert-speed.html.\n\nThe file name must be given as a literal string. On Windows, specify\nbackslashes in path names as forward slashes or doubled backslashes.\nThe character_set_filesystem system variable controls the\ninterpretation of the file name.\n\nIn MySQL 5.6.2 and later, LOAD DATA supports explicit partition\nselection using the PARTITION option with a comma-separated list of\nmore or more names of partitions, subpartitions, or both. When this\noption is used, if any rows from the file cannot be inserted into any\nof the partitions or subpartitions named in the list, the statement\nfails with the error Found a row not matching the given partition set.\nFor more information, see\nhttp://dev.mysql.com/doc/refman/5.6/en/partitioning-selection.html.\n\nFor partitioned tables using storage engines that employ table locks,\nsuch as MyISAM, LOAD DATA cannot prune any partition locks. This does\nnot apply to tables using storage engines which employ row-level\nlocking, such as InnoDB. For more information, see\nhttp://dev.mysql.com/doc/refman/5.6/en/partitioning-limitations-locking\n.html.\n\nThe character set indicated by the character_set_database system\nvariable is used to interpret the information in the file. SET NAMES\nand the setting of character_set_client do not affect interpretation of\ninput. If the contents of the input file use a character set that\ndiffers from the default, it is usually preferable to specify the\ncharacter set of the file by using the CHARACTER SET clause. A\ncharacter set of binary specifies \"no conversion.\"\n\nLOAD DATA INFILE interprets all fields in the file as having the same\ncharacter set, regardless of the data types of the columns into which\nfield values are loaded. For proper interpretation of file contents,\nyou must ensure that it was written with the correct character set. For\nexample, if you write a data file with mysqldump -T or by issuing a\nSELECT ... INTO OUTFILE statement in mysql, be sure to use a\n--default-character-set option so that output is written in the\ncharacter set to be used when the file is loaded with LOAD DATA INFILE.\n\n*Note*: It is not possible to load data files that use the ucs2, utf16,\nutf16le, or utf32 character set.\n\nIf you use LOW_PRIORITY, execution of the LOAD DATA statement is\ndelayed until no other clients are reading from the table. This affects\nonly storage engines that use only table-level locking (such as MyISAM,\nMEMORY, and MERGE).\n\nIf you specify CONCURRENT with a MyISAM table that satisfies the\ncondition for concurrent inserts (that is, it contains no free blocks\nin the middle), other threads can retrieve data from the table while\nLOAD DATA is executing. This option affects the performance of LOAD\nDATA a bit, even if no other thread is using the table at the same\ntime.\n\nWith row-based replication, CONCURRENT is replicated regardless of\nMySQL version. With statement-based replication CONCURRENT is not\nreplicated prior to MySQL 5.5.1 (see Bug #34628). For more information,\nsee\nhttp://dev.mysql.com/doc/refman/5.6/en/replication-features-load-data.h\ntml.\n\nThe LOCAL keyword affects expected location of the file and error\nhandling, as described later. LOCAL works only if your server and your\nclient both have been configured to permit it. For example, if mysqld\nwas started with --local-infile=0, LOCAL does not work. See\nhttp://dev.mysql.com/doc/refman/5.6/en/load-data-local.html.\n\nThe LOCAL keyword affects where the file is expected to be found:\n\no If LOCAL is specified, the file is read by the client program on the\n  client host and sent to the server. The file can be given as a full\n  path name to specify its exact location. If given as a relative path\n  name, the name is interpreted relative to the directory in which the\n  client program was started.\n\n  When using LOCAL with LOAD DATA, a copy of the file is created in the\n  server\'s temporary directory. This is not the directory determined by\n  the value of tmpdir or slave_load_tmpdir, but rather the operating\n  system\'s temporary directory, and is not configurable in the MySQL\n  Server. (Typically the system temporary directory is /tmp on Linux\n  systems and C:\\WINDOWS\\TEMP on Windows.) Lack of sufficient space for\n  the copy in this directory can cause the LOAD DATA LOCAL statement to\n  fail.\n\no If LOCAL is not specified, the file must be located on the server\n  host and is read directly by the server. The server uses the\n  following rules to locate the file:\n\n  o If the file name is an absolute path name, the server uses it as\n    given.\n\n  o If the file name is a relative path name with one or more leading\n    components, the server searches for the file relative to the\n    server\'s data directory.\n\n  o If a file name with no leading components is given, the server\n    looks for the file in the database directory of the default\n    database.\n\nIn the non-LOCAL case, these rules mean that a file named as\n./myfile.txt is read from the server\'s data directory, whereas the file\nnamed as myfile.txt is read from the database directory of the default\ndatabase. For example, if db1 is the default database, the following\nLOAD DATA statement reads the file data.txt from the database directory\nfor db1, even though the statement explicitly loads the file into a\ntable in the db2 database:\n\nLOAD DATA INFILE \'data.txt\' INTO TABLE db2.my_table;\n\nFor security reasons, when reading text files located on the server,\nthe files must either reside in the database directory or be readable\nby all. Also, to use LOAD DATA INFILE on server files, you must have\nthe FILE privilege. See\nhttp://dev.mysql.com/doc/refman/5.6/en/privileges-provided.html. For\nnon-LOCAL load operations, if the secure_file_priv system variable is\nset to a nonempty directory name, the file to be loaded must be located\nin that directory.\n\nUsing LOCAL is a bit slower than letting the server access the files\ndirectly, because the contents of the file must be sent over the\nconnection by the client to the server. On the other hand, you do not\nneed the FILE privilege to load local files.\n\nLOCAL also affects error handling:\n\no With LOAD DATA INFILE, data-interpretation and duplicate-key errors\n  terminate the operation.\n\no With LOAD DATA LOCAL INFILE, data-interpretation and duplicate-key\n  errors become warnings and the operation continues because the server\n  has no way to stop transmission of the file in the middle of the\n  operation. For duplicate-key errors, this is the same as if IGNORE is\n  specified. IGNORE is explained further later in this section.\n\nThe REPLACE and IGNORE keywords control handling of input rows that\nduplicate existing rows on unique key values:\n\no If you specify REPLACE, input rows replace existing rows. In other\n  words, rows that have the same value for a primary key or unique\n  index as an existing row. See [HELP REPLACE].\n\no If you specify IGNORE, input rows that duplicate an existing row on a\n  unique key value are skipped.\n\no If you do not specify either option, the behavior depends on whether\n  the LOCAL keyword is specified. Without LOCAL, an error occurs when a\n  duplicate key value is found, and the rest of the text file is\n  ignored. With LOCAL, the default behavior is the same as if IGNORE is\n  specified; this is because the server has no way to stop transmission\n  of the file in the middle of the operation.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/load-data.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/load-data.html'),(484,'DECLARE CURSOR',24,'Syntax:\nDECLARE cursor_name CURSOR FOR select_statement\n\nThis statement declares a cursor and associates it with a SELECT\nstatement that retrieves the rows to be traversed by the cursor. To\nfetch the rows later, use a FETCH statement. The number of columns\nretrieved by the SELECT statement must match the number of output\nvariables specified in the FETCH statement.\n\nThe SELECT statement cannot have an INTO clause.\n\nCursor declarations must appear before handler declarations and after\nvariable and condition declarations.\n\nA stored program may contain multiple cursor declarations, but each\ncursor declared in a given block must have a unique name. For an\nexample, see http://dev.mysql.com/doc/refman/5.6/en/cursors.html.\n\nFor information available through SHOW statements, it is possible in\nmany cases to obtain equivalent information by using a cursor with an\nINFORMATION_SCHEMA table.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/declare-cursor.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/declare-cursor.html'),(485,'LOCALTIME',32,'Syntax:\nLOCALTIME, LOCALTIME([fsp])\n\nLOCALTIME and LOCALTIME() are synonyms for NOW().\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html'),(486,'SHA1',12,'Syntax:\nSHA1(str), SHA(str)\n\nCalculates an SHA-1 160-bit checksum for the string, as described in\nRFC 3174 (Secure Hash Algorithm). The value is returned as a string of\n40 hex digits, or NULL if the argument was NULL. One of the possible\nuses for this function is as a hash key. See the notes at the beginning\nof this section about storing hash values efficiently. You can also use\nSHA1() as a cryptographic function for storing passwords. SHA() is\nsynonymous with SHA1().\n\nThe return value is a nonbinary string in the connection character set.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/encryption-functions.html\n\n','mysql> SELECT SHA1(\'abc\');\n        -> \'a9993e364706816aba3e25717850c26c9cd0d89d\'\n','http://dev.mysql.com/doc/refman/5.6/en/encryption-functions.html'),(487,'BLOB',23,'BLOB[(M)]\n\nA BLOB column with a maximum length of 65,535 (216 - 1) bytes. Each\nBLOB value is stored using a 2-byte length prefix that indicates the\nnumber of bytes in the value.\n\nAn optional length M can be given for this type. If this is done, MySQL\ncreates the column as the smallest BLOB type large enough to hold\nvalues M bytes long.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/string-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/string-type-overview.html'),(488,'PASSWORD',12,'Syntax:\nPASSWORD(str)\n\nCalculates and returns a hashed password string from the cleartext\npassword str and returns a nonbinary string in the connection character\nset, or NULL if the argument is NULL. This function is the SQL\ninterface to the algorithm used by the server to encrypt MySQL\npasswords for storage in the mysql.user grant table.\n\nThe password hashing method used by PASSWORD() depends on the value of\nthe old_passwords system variable:\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/encryption-functions.html\n\n','mysql> SET old_passwords = 0;\nmysql> SELECT PASSWORD(\'mypass\');\n+-------------------------------------------+\n| PASSWORD(\'mypass\')                        |\n+-------------------------------------------+\n| *6C8989366EAF75BB670AD8EA7A7FC1176A95CEF4 |\n+-------------------------------------------+\n\nmysql> SET old_passwords = 1;\nmysql> SELECT PASSWORD(\'mypass\');\n+--------------------+\n| PASSWORD(\'mypass\') |\n+--------------------+\n| 6f8c114b58f2ce9e   |\n+--------------------+\n','http://dev.mysql.com/doc/refman/5.6/en/encryption-functions.html'),(489,'UTC_DATE',32,'Syntax:\nUTC_DATE, UTC_DATE()\n\nReturns the current UTC date as a value in \'YYYY-MM-DD\' or YYYYMMDD\nformat, depending on whether the function is used in a string or\nnumeric context.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html\n\n','mysql> SELECT UTC_DATE(), UTC_DATE() + 0;\n        -> \'2003-08-14\', 20030814\n','http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html'),(490,'DIMENSION',37,'Dimension(g)\n\nReturns the inherent dimension of the geometry value g. The result can\nbe -1, 0, 1, or 2. The meaning of these values is given in\nhttp://dev.mysql.com/doc/refman/5.6/en/gis-class-geometry.html.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/geometry-property-functions.html\n\n','mysql> SELECT Dimension(GeomFromText(\'LineString(1 1,2 2)\'));\n+------------------------------------------------+\n| Dimension(GeomFromText(\'LineString(1 1,2 2)\')) |\n+------------------------------------------------+\n|                                              1 |\n+------------------------------------------------+\n','http://dev.mysql.com/doc/refman/5.6/en/geometry-property-functions.html'),(491,'BIT',23,'BIT[(M)]\n\nA bit-field type. M indicates the number of bits per value, from 1 to\n64. The default is 1 if M is omitted.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/numeric-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/numeric-type-overview.html'),(492,'EQUALS',31,'Equals(g1,g2)\n\nReturns 1 or 0 to indicate whether g1 is spatially equal to g2.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/functions-for-testing-spatial-relations-between-geometric-objects.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/functions-for-testing-spatial-relations-between-geometric-objects.html'),(493,'XA',8,'Syntax:\nXA {START|BEGIN} xid [JOIN|RESUME]\n\nXA END xid [SUSPEND [FOR MIGRATE]]\n\nXA PREPARE xid\n\nXA COMMIT xid [ONE PHASE]\n\nXA ROLLBACK xid\n\nXA RECOVER\n\nFor XA START, the JOIN and RESUME clauses are not supported.\n\nFor XA END the SUSPEND [FOR MIGRATE] clause is not supported.\n\nEach XA statement begins with the XA keyword, and most of them require\nan xid value. An xid is an XA transaction identifier. It indicates\nwhich transaction the statement applies to. xid values are supplied by\nthe client, or generated by the MySQL server. An xid value has from one\nto three parts:\n\nxid: gtrid [, bqual [, formatID ]]\n\ngtrid is a global transaction identifier, bqual is a branch qualifier,\nand formatID is a number that identifies the format used by the gtrid\nand bqual values. As indicated by the syntax, bqual and formatID are\noptional. The default bqual value is \'\' if not given. The default\nformatID value is 1 if not given.\n\ngtrid and bqual must be string literals, each up to 64 bytes (not\ncharacters) long. gtrid and bqual can be specified in several ways. You\ncan use a quoted string (\'ab\'), hex string (0x6162, X\'ab\'), or bit\nvalue (b\'nnnn\').\n\nformatID is an unsigned integer.\n\nThe gtrid and bqual values are interpreted in bytes by the MySQL\nserver\'s underlying XA support routines. However, while an SQL\nstatement containing an XA statement is being parsed, the server works\nwith some specific character set. To be safe, write gtrid and bqual as\nhex strings.\n\nxid values typically are generated by the Transaction Manager. Values\ngenerated by one TM must be different from values generated by other\nTMs. A given TM must be able to recognize its own xid values in a list\nof values returned by the XA RECOVER statement.\n\nXA START xid starts an XA transaction with the given xid value. Each XA\ntransaction must have a unique xid value, so the value must not\ncurrently be used by another XA transaction. Uniqueness is assessed\nusing the gtrid and bqual values. All following XA statements for the\nXA transaction must be specified using the same xid value as that given\nin the XA START statement. If you use any of those statements but\nspecify an xid value that does not correspond to some existing XA\ntransaction, an error occurs.\n\nOne or more XA transactions can be part of the same global transaction.\nAll XA transactions within a given global transaction must use the same\ngtrid value in the xid value. For this reason, gtrid values must be\nglobally unique so that there is no ambiguity about which global\ntransaction a given XA transaction is part of. The bqual part of the\nxid value must be different for each XA transaction within a global\ntransaction. (The requirement that bqual values be different is a\nlimitation of the current MySQL XA implementation. It is not part of\nthe XA specification.)\n\nThe XA RECOVER statement returns information for those XA transactions\non the MySQL server that are in the PREPARED state. (See\nhttp://dev.mysql.com/doc/refman/5.6/en/xa-states.html.) The output\nincludes a row for each such XA transaction on the server, regardless\nof which client started it.\n\nXA RECOVER output rows look like this (for an example xid value\nconsisting of the parts \'abc\', \'def\', and 7):\n\nmysql> XA RECOVER;\n+----------+--------------+--------------+--------+\n| formatID | gtrid_length | bqual_length | data   |\n+----------+--------------+--------------+--------+\n|        7 |            3 |            3 | abcdef |\n+----------+--------------+--------------+--------+\n\nThe output columns have the following meanings:\n\no formatID is the formatID part of the transaction xid\n\no gtrid_length is the length in bytes of the gtrid part of the xid\n\no bqual_length is the length in bytes of the bqual part of the xid\n\no data is the concatenation of the gtrid and bqual parts of the xid\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/xa-statements.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/xa-statements.html'),(494,'OCTET_LENGTH',38,'Syntax:\nOCTET_LENGTH(str)\n\nOCTET_LENGTH() is a synonym for LENGTH().\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/string-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/string-functions.html'),(495,'UTC_TIMESTAMP',32,'Syntax:\nUTC_TIMESTAMP, UTC_TIMESTAMP([fsp])\n\nReturns the current UTC date and time as a value in \'YYYY-MM-DD\nHH:MM:SS\' or YYYYMMDDHHMMSS format, depending on whether the function\nis used in a string or numeric context.\n\nAs of MySQL 5.6.4, if the fsp argument is given to specify a fractional\nseconds precision from 0 to 6, the return value includes a fractional\nseconds part of that many digits. Before 5.6.4, any argument is\nignored.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html\n\n','mysql> SELECT UTC_TIMESTAMP(), UTC_TIMESTAMP() + 0;\n        -> \'2003-08-14 18:08:04\', 20030814180804.000000\n','http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html'),(496,'AES_ENCRYPT',12,'Syntax:\nAES_ENCRYPT(str,key_str)\n\nAES_ENCRYPT() and AES_DECRYPT() enable encryption and decryption of\ndata using the official AES (Advanced Encryption Standard) algorithm,\npreviously known as \"Rijndael.\" Encoding with a 128-bit key length is\nused, but you can extend it up to 256 bits by modifying the source. We\nchose 128 bits because it is much faster and it is secure enough for\nmost purposes.\n\nAES_ENCRYPT() encrypts a string and returns a binary string.\nAES_DECRYPT() decrypts the encrypted string and returns the original\nstring. The input arguments may be any length. If either argument is\nNULL, the result of this function is also NULL.\n\nBecause AES is a block-level algorithm, padding is used to encode\nuneven length strings and so the result string length may be calculated\nusing this formula:\n\n16 * (trunc(string_length / 16) + 1)\n\nIf AES_DECRYPT() detects invalid data or incorrect padding, it returns\nNULL. However, it is possible for AES_DECRYPT() to return a non-NULL\nvalue (possibly garbage) if the input data or the key is invalid.\n\nYou can use the AES functions to store data in an encrypted form by\nmodifying your queries:\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/encryption-functions.html\n\n','INSERT INTO t VALUES (1,AES_ENCRYPT(\'text\',\'password\'));\n','http://dev.mysql.com/doc/refman/5.6/en/encryption-functions.html'),(497,'+',4,'Syntax:\n+\n\nAddition:\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/arithmetic-functions.html\n\n','mysql> SELECT 3+5;\n        -> 8\n','http://dev.mysql.com/doc/refman/5.6/en/arithmetic-functions.html'),(498,'GTID_SUBTRACT',17,'Syntax:\nGTID_SUBTRACT(set,subset)\n\nGiven two sets of global transaction IDs subset and set, returns only\nthose GTIDs from set that are not in subset.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/gtid-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/gtid-functions.html'),(499,'INET_NTOA',14,'Syntax:\nINET_NTOA(expr)\n\nGiven a numeric IPv4 network address in network byte order, returns the\ndotted-quad string representation of the address as a nonbinary string\nin the connection character set. INET_NTOA() returns NULL if it does\nnot understand its argument.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/miscellaneous-functions.html\n\n','mysql> SELECT INET_NTOA(167773449);\n        -> \'10.0.5.9\'\n','http://dev.mysql.com/doc/refman/5.6/en/miscellaneous-functions.html'),(500,'DAYOFWEEK',32,'Syntax:\nDAYOFWEEK(date)\n\nReturns the weekday index for date (1 = Sunday, 2 = Monday, ..., 7 =\nSaturday). These index values correspond to the ODBC standard.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html\n\n','mysql> SELECT DAYOFWEEK(\'2007-02-03\');\n        -> 7\n','http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html'),(501,'CEILING',4,'Syntax:\nCEILING(X)\n\nReturns the smallest integer value not less than X.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/mathematical-functions.html\n\n','mysql> SELECT CEILING(1.23);\n        -> 2\nmysql> SELECT CEILING(-1.23);\n        -> -1\n','http://dev.mysql.com/doc/refman/5.6/en/mathematical-functions.html'),(502,'LINEFROMWKB',33,'LineFromWKB(wkb[,srid]), LineStringFromWKB(wkb[,srid])\n\nConstructs a LINESTRING value using its WKB representation and SRID.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/creating-spatial-values.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/creating-spatial-values.html'),(503,'SHOW PROCESSLIST',27,'Syntax:\nSHOW [FULL] PROCESSLIST\n\nSHOW PROCESSLIST shows you which threads are running. You can also get\nthis information from the INFORMATION_SCHEMA PROCESSLIST table or the\nmysqladmin processlist command. If you have the PROCESS privilege, you\ncan see all threads. Otherwise, you can see only your own threads (that\nis, threads associated with the MySQL account that you are using). If\nyou do not use the FULL keyword, only the first 100 characters of each\nstatement are shown in the Info field.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/show-processlist.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/show-processlist.html'),(504,'GEOMETRYTYPE',37,'GeometryType(g)\n\nReturns as a binary string the name of the geometry type of which the\ngeometry instance g is a member. The name corresponds to one of the\ninstantiable Geometry subclasses.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/geometry-property-functions.html\n\n','mysql> SELECT GeometryType(GeomFromText(\'POINT(1 1)\'));\n+------------------------------------------+\n| GeometryType(GeomFromText(\'POINT(1 1)\')) |\n+------------------------------------------+\n| POINT                                    |\n+------------------------------------------+\n','http://dev.mysql.com/doc/refman/5.6/en/geometry-property-functions.html'),(505,'CREATE VIEW',40,'Syntax:\nCREATE\n    [OR REPLACE]\n    [ALGORITHM = {UNDEFINED | MERGE | TEMPTABLE}]\n    [DEFINER = { user | CURRENT_USER }]\n    [SQL SECURITY { DEFINER | INVOKER }]\n    VIEW view_name [(column_list)]\n    AS select_statement\n    [WITH [CASCADED | LOCAL] CHECK OPTION]\n\nThe CREATE VIEW statement creates a new view, or replaces an existing\none if the OR REPLACE clause is given. If the view does not exist,\nCREATE OR REPLACE VIEW is the same as CREATE VIEW. If the view does\nexist, CREATE OR REPLACE VIEW is the same as ALTER VIEW.\n\nThe select_statement is a SELECT statement that provides the definition\nof the view. (When you select from the view, you select in effect using\nthe SELECT statement.) select_statement can select from base tables or\nother views.\n\nThe view definition is \"frozen\" at creation time, so changes to the\nunderlying tables afterward do not affect the view definition. For\nexample, if a view is defined as SELECT * on a table, new columns added\nto the table later do not become part of the view.\n\nThe ALGORITHM clause affects how MySQL processes the view. The DEFINER\nand SQL SECURITY clauses specify the security context to be used when\nchecking access privileges at view invocation time. The WITH CHECK\nOPTION clause can be given to constrain inserts or updates to rows in\ntables referenced by the view. These clauses are described later in\nthis section.\n\nThe CREATE VIEW statement requires the CREATE VIEW privilege for the\nview, and some privilege for each column selected by the SELECT\nstatement. For columns used elsewhere in the SELECT statement you must\nhave the SELECT privilege. If the OR REPLACE clause is present, you\nmust also have the DROP privilege for the view. CREATE VIEW might also\nrequire the SUPER privilege, depending on the DEFINER value, as\ndescribed later in this section.\n\nWhen a view is referenced, privilege checking occurs as described later\nin this section.\n\nA view belongs to a database. By default, a new view is created in the\ndefault database. To create the view explicitly in a given database,\nspecify the name as db_name.view_name when you create it:\n\nmysql> CREATE VIEW test.v AS SELECT * FROM t;\n\nWithin a database, base tables and views share the same namespace, so a\nbase table and a view cannot have the same name.\n\nColumns retrieved by the SELECT statement can be simple references to\ntable columns. They can also be expressions that use functions,\nconstant values, operators, and so forth.\n\nViews must have unique column names with no duplicates, just like base\ntables. By default, the names of the columns retrieved by the SELECT\nstatement are used for the view column names. To define explicit names\nfor the view columns, the optional column_list clause can be given as a\nlist of comma-separated identifiers. The number of names in column_list\nmust be the same as the number of columns retrieved by the SELECT\nstatement.\n\nUnqualified table or view names in the SELECT statement are interpreted\nwith respect to the default database. A view can refer to tables or\nviews in other databases by qualifying the table or view name with the\nproper database name.\n\nA view can be created from many kinds of SELECT statements. It can\nrefer to base tables or other views. It can use joins, UNION, and\nsubqueries. The SELECT need not even refer to any tables. The following\nexample defines a view that selects two columns from another table, as\nwell as an expression calculated from those columns:\n\nmysql> CREATE TABLE t (qty INT, price INT);\nmysql> INSERT INTO t VALUES(3, 50);\nmysql> CREATE VIEW v AS SELECT qty, price, qty*price AS value FROM t;\nmysql> SELECT * FROM v;\n+------+-------+-------+\n| qty  | price | value |\n+------+-------+-------+\n|    3 |    50 |   150 |\n+------+-------+-------+\n\nA view definition is subject to the following restrictions:\n\no The SELECT statement cannot contain a subquery in the FROM clause.\n\no The SELECT statement cannot refer to system or user variables.\n\no Within a stored program, the definition cannot refer to program\n  parameters or local variables.\n\no The SELECT statement cannot refer to prepared statement parameters.\n\no Any table or view referred to in the definition must exist. However,\n  after a view has been created, it is possible to drop a table or view\n  that the definition refers to. In this case, use of the view results\n  in an error. To check a view definition for problems of this kind,\n  use the CHECK TABLE statement.\n\no The definition cannot refer to a TEMPORARY table, and you cannot\n  create a TEMPORARY view.\n\no Any tables named in the view definition must exist at definition\n  time.\n\no You cannot associate a trigger with a view.\n\no Aliases for column names in the SELECT statement are checked against\n  the maximum column length of 64 characters (not the maximum alias\n  length of 256 characters).\n\nORDER BY is permitted in a view definition, but it is ignored if you\nselect from a view using a statement that has its own ORDER BY.\n\nFor other options or clauses in the definition, they are added to the\noptions or clauses of the statement that references the view, but the\neffect is undefined. For example, if a view definition includes a LIMIT\nclause, and you select from the view using a statement that has its own\nLIMIT clause, it is undefined which limit applies. This same principle\napplies to options such as ALL, DISTINCT, or SQL_SMALL_RESULT that\nfollow the SELECT keyword, and to clauses such as INTO, FOR UPDATE,\nLOCK IN SHARE MODE, and PROCEDURE.\n\nIf you create a view and then change the query processing environment\nby changing system variables, that may affect the results that you get\nfrom the view:\n\nmysql> CREATE VIEW v (mycol) AS SELECT \'abc\';\nQuery OK, 0 rows affected (0.01 sec)\n\nmysql> SET sql_mode = \'\';\nQuery OK, 0 rows affected (0.00 sec)\n\nmysql> SELECT \"mycol\" FROM v;\n+-------+\n| mycol |\n+-------+\n| mycol |\n+-------+\n1 row in set (0.01 sec)\n\nmysql> SET sql_mode = \'ANSI_QUOTES\';\nQuery OK, 0 rows affected (0.00 sec)\n\nmysql> SELECT \"mycol\" FROM v;\n+-------+\n| mycol |\n+-------+\n| abc   |\n+-------+\n1 row in set (0.00 sec)\n\nThe DEFINER and SQL SECURITY clauses determine which MySQL account to\nuse when checking access privileges for the view when a statement is\nexecuted that references the view. The valid SQL SECURITY\ncharacteristic values are DEFINER and INVOKER. These indicate that the\nrequired privileges must be held by the user who defined or invoked the\nview, respectively. The default SQL SECURITY value is DEFINER.\n\nIf a user value is given for the DEFINER clause, it should be a MySQL\naccount specified as \'user_name\'@\'host_name\' (the same format used in\nthe GRANT statement), CURRENT_USER, or CURRENT_USER(). The default\nDEFINER value is the user who executes the CREATE VIEW statement. This\nis the same as specifying DEFINER = CURRENT_USER explicitly.\n\nIf you specify the DEFINER clause, these rules determine the valid\nDEFINER user values:\n\no If you do not have the SUPER privilege, the only valid user value is\n  your own account, either specified literally or by using\n  CURRENT_USER. You cannot set the definer to some other account.\n\no If you have the SUPER privilege, you can specify any syntactically\n  valid account name. If the account does not actually exist, a warning\n  is generated.\n\no Although it is possible to create a view with a nonexistent DEFINER\n  account, an error occurs when the view is referenced if the SQL\n  SECURITY value is DEFINER but the definer account does not exist.\n\nFor more information about view security, see\nhttp://dev.mysql.com/doc/refman/5.6/en/stored-programs-security.html.\n\nWithin a view definition, CURRENT_USER returns the view\'s DEFINER value\nby default. For views defined with the SQL SECURITY INVOKER\ncharacteristic, CURRENT_USER returns the account for the view\'s\ninvoker. For information about user auditing within views, see\nhttp://dev.mysql.com/doc/refman/5.6/en/account-activity-auditing.html.\n\nWithin a stored routine that is defined with the SQL SECURITY DEFINER\ncharacteristic, CURRENT_USER returns the routine\'s DEFINER value. This\nalso affects a view defined within such a routine, if the view\ndefinition contains a DEFINER value of CURRENT_USER.\n\nView privileges are checked like this:\n\no At view definition time, the view creator must have the privileges\n  needed to use the top-level objects accessed by the view. For\n  example, if the view definition refers to table columns, the creator\n  must have some privilege for each column in the select list of the\n  definition, and the SELECT privilege for each column used elsewhere\n  in the definition. If the definition refers to a stored function,\n  only the privileges needed to invoke the function can be checked. The\n  privileges required at function invocation time can be checked only\n  as it executes: For different invocations, different execution paths\n  within the function might be taken.\n\no The user who references a view must have appropriate privileges to\n  access it (SELECT to select from it, INSERT to insert into it, and so\n  forth.)\n\no When a view has been referenced, privileges for objects accessed by\n  the view are checked against the privileges held by the view DEFINER\n  account or invoker, depending on whether the SQL SECURITY\n  characteristic is DEFINER or INVOKER, respectively.\n\no If reference to a view causes execution of a stored function,\n  privilege checking for statements executed within the function depend\n  on whether the function SQL SECURITY characteristic is DEFINER or\n  INVOKER. If the security characteristic is DEFINER, the function runs\n  with the privileges of the DEFINER account. If the characteristic is\n  INVOKER, the function runs with the privileges determined by the\n  view\'s SQL SECURITY characteristic.\n\nExample: A view might depend on a stored function, and that function\nmight invoke other stored routines. For example, the following view\ninvokes a stored function f():\n\nCREATE VIEW v AS SELECT * FROM t WHERE t.id = f(t.name);\n\nSuppose that f() contains a statement such as this:\n\nIF name IS NULL then\n  CALL p1();\nELSE\n  CALL p2();\nEND IF;\n\nThe privileges required for executing statements within f() need to be\nchecked when f() executes. This might mean that privileges are needed\nfor p1() or p2(), depending on the execution path within f(). Those\nprivileges must be checked at runtime, and the user who must possess\nthe privileges is determined by the SQL SECURITY values of the view v\nand the function f().\n\nThe DEFINER and SQL SECURITY clauses for views are extensions to\nstandard SQL. In standard SQL, views are handled using the rules for\nSQL SECURITY DEFINER. The standard says that the definer of the view,\nwhich is the same as the owner of the view\'s schema, gets applicable\nprivileges on the view (for example, SELECT) and may grant them. MySQL\nhas no concept of a schema \"owner\", so MySQL adds a clause to identify\nthe definer. The DEFINER clause is an extension where the intent is to\nhave what the standard has; that is, a permanent record of who defined\nthe view. This is why the default DEFINER value is the account of the\nview creator.\n\nThe optional ALGORITHM clause is a MySQL extension to standard SQL. It\naffects how MySQL processes the view. ALGORITHM takes three values:\nMERGE, TEMPTABLE, or UNDEFINED. The default algorithm is UNDEFINED if\nno ALGORITHM clause is present. For more information, see\nhttp://dev.mysql.com/doc/refman/5.6/en/view-algorithms.html.\n\nSome views are updatable. That is, you can use them in statements such\nas UPDATE, DELETE, or INSERT to update the contents of the underlying\ntable. For a view to be updatable, there must be a one-to-one\nrelationship between the rows in the view and the rows in the\nunderlying table. There are also certain other constructs that make a\nview nonupdatable.\n\nThe WITH CHECK OPTION clause can be given for an updatable view to\nprevent inserts or updates to rows except those for which the WHERE\nclause in the select_statement is true.\n\nIn a WITH CHECK OPTION clause for an updatable view, the LOCAL and\nCASCADED keywords determine the scope of check testing when the view is\ndefined in terms of another view. The LOCAL keyword restricts the CHECK\nOPTION only to the view being defined. CASCADED causes the checks for\nunderlying views to be evaluated as well. When neither keyword is\ngiven, the default is CASCADED.\n\nFor more information about updatable views and the WITH CHECK OPTION\nclause, see\nhttp://dev.mysql.com/doc/refman/5.6/en/view-updatability.html.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/create-view.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/create-view.html'),(506,'TRIM',38,'Syntax:\nTRIM([{BOTH | LEADING | TRAILING} [remstr] FROM] str), TRIM([remstr\nFROM] str)\n\nReturns the string str with all remstr prefixes or suffixes removed. If\nnone of the specifiers BOTH, LEADING, or TRAILING is given, BOTH is\nassumed. remstr is optional and, if not specified, spaces are removed.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/string-functions.html\n\n','mysql> SELECT TRIM(\'  bar   \');\n        -> \'bar\'\nmysql> SELECT TRIM(LEADING \'x\' FROM \'xxxbarxxx\');\n        -> \'barxxx\'\nmysql> SELECT TRIM(BOTH \'x\' FROM \'xxxbarxxx\');\n        -> \'bar\'\nmysql> SELECT TRIM(TRAILING \'xyz\' FROM \'barxxyz\');\n        -> \'barx\'\n','http://dev.mysql.com/doc/refman/5.6/en/string-functions.html'),(507,'INET6_NTOA',14,'Syntax:\nINET6_NTOA(expr)\n\nGiven an IPv6 or IPv4 network address represented in numeric form as a\nbinary string, returns the string representation of the address as a\nnonbinary string in the connection character set. If the argument is\nnot a valid address, INET6_NTOA() returns NULL.\n\nINET6_NTOA() has these properties:\n\no It does not use operating system functions to perform conversions,\n  thus the output string is platform independent.\n\no The return string has a maximum length of 39 (4 x 8 + 7). Given this\n  statement:\n\nCREATE TABLE t AS SELECT INET6_NTOA(expr) AS c1;\n\n  The resulting table would have this definition:\n\nCREATE TABLE t (c1 VARCHAR(39) CHARACTER SET utf8 DEFAULT NULL);\n\no The return string uses lowercase letters for IPv6 addresses.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/miscellaneous-functions.html\n\n','mysql> SELECT INET6_NTOA(INET6_ATON(\'fdfe::5a55:caff:fefa:9089\'));\n        -> \'fdfe::5a55:caff:fefa:9089\'\nmysql> SELECT INET6_NTOA(INET6_ATON(\'10.0.5.9\'));\n        -> \'10.0.5.9\'\n\nmysql> SELECT INET6_NTOA(UNHEX(\'FDFE0000000000005A55CAFFFEFA9089\'));\n        -> \'fdfe::5a55:caff:fefa:9089\'\nmysql> SELECT INET6_NTOA(UNHEX(\'0A000509\'));\n        -> \'10.0.5.9\'\n','http://dev.mysql.com/doc/refman/5.6/en/miscellaneous-functions.html'),(508,'SIGNAL',24,'Syntax:\nSIGNAL condition_value\n    [SET signal_information_item\n    [, signal_information_item] ...]\n\ncondition_value:\n    SQLSTATE [VALUE] sqlstate_value\n  | condition_name\n\nsignal_information_item:\n    condition_information_item_name = simple_value_specification\n\ncondition_information_item_name:\n    CLASS_ORIGIN\n  | SUBCLASS_ORIGIN\n  | MESSAGE_TEXT\n  | MYSQL_ERRNO\n  | CONSTRAINT_CATALOG\n  | CONSTRAINT_SCHEMA\n  | CONSTRAINT_NAME\n  | CATALOG_NAME\n  | SCHEMA_NAME\n  | TABLE_NAME\n  | COLUMN_NAME\n  | CURSOR_NAME\n\ncondition_name, simple_value_specification:\n    (see following discussion)\n\nSIGNAL is the way to \"return\" an error. SIGNAL provides error\ninformation to a handler, to an outer portion of the application, or to\nthe client. Also, it provides control over the error\'s characteristics\n(error number, SQLSTATE value, message). Without SIGNAL, it is\nnecessary to resort to workarounds such as deliberately referring to a\nnonexistent table to cause a routine to return an error.\n\nNo special privileges are required to execute the SIGNAL statement.\n\nTo retrieve information from the diagnostics area, use the GET\nDIAGNOSTICS statement (see [HELP GET DIAGNOSTICS]). For information\nabout the diagnostics area, see\nhttp://dev.mysql.com/doc/refman/5.6/en/diagnostics-area.html.\n\nThe condition_value in a SIGNAL statement indicates the error value to\nbe returned. It can be an SQLSTATE value (a 5-character string literal)\nor a condition_name that refers to a named condition previously defined\nwith DECLARE ... CONDITION (see [HELP DECLARE CONDITION]).\n\nAn SQLSTATE value can indicate errors, warnings, or \"not found.\" The\nfirst two characters of the value indicate its error class, as\ndiscussed in\nhttp://dev.mysql.com/doc/refman/5.6/en/signal.html#signal-condition-inf\normation-items. Some signal values cause statement termination; see\nhttp://dev.mysql.com/doc/refman/5.6/en/signal.html#signal-effects.\n\nThe SQLSTATE value for a SIGNAL statement should not start with \'00\'\nbecause such values indicate success and are not valid for signaling an\nerror. This is true whether the SQLSTATE value is specified directly in\nthe SIGNAL statement or in a named condition referred to in the\nstatement. If the value is invalid, a Bad SQLSTATE error occurs.\n\nTo signal a generic SQLSTATE value, use \'45000\', which means \"unhandled\nuser-defined exception.\"\n\nThe SIGNAL statement optionally includes a SET clause that contains\nmultiple signal items, in a comma-separated list of\ncondition_information_item_name = simple_value_specification\nassignments.\n\nEach condition_information_item_name may be specified only once in the\nSET clause. Otherwise, a Duplicate condition information item error\noccurs.\n\nValid simple_value_specification designators can be specified using\nstored procedure or function parameters, stored program local variables\ndeclared with DECLARE, user-defined variables, system variables, or\nliterals. A character literal may include a _charset introducer.\n\nFor information about permissible condition_information_item_name\nvalues, see\nhttp://dev.mysql.com/doc/refman/5.6/en/signal.html#signal-condition-inf\normation-items.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/signal.html\n\n','CREATE PROCEDURE p (pval INT)\nBEGIN\n  DECLARE specialty CONDITION FOR SQLSTATE \'45000\';\n  IF pval = 0 THEN\n    SIGNAL SQLSTATE \'01000\';\n  ELSEIF pval = 1 THEN\n    SIGNAL SQLSTATE \'45000\'\n      SET MESSAGE_TEXT = \'An error occurred\';\n  ELSEIF pval = 2 THEN\n    SIGNAL specialty\n      SET MESSAGE_TEXT = \'An error occurred\';\n  ELSE\n    SIGNAL SQLSTATE \'01000\'\n      SET MESSAGE_TEXT = \'A warning occurred\', MYSQL_ERRNO = 1000;\n    SIGNAL SQLSTATE \'45000\'\n      SET MESSAGE_TEXT = \'An error occurred\', MYSQL_ERRNO = 1001;\n  END IF;\nEND;\n','http://dev.mysql.com/doc/refman/5.6/en/signal.html'),(509,'SAVEPOINT',8,'Syntax:\nSAVEPOINT identifier\nROLLBACK [WORK] TO [SAVEPOINT] identifier\nRELEASE SAVEPOINT identifier\n\nInnoDB supports the SQL statements SAVEPOINT, ROLLBACK TO SAVEPOINT,\nRELEASE SAVEPOINT and the optional WORK keyword for ROLLBACK.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/savepoint.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/savepoint.html'),(510,'MPOINTFROMWKB',33,'MPointFromWKB(wkb[,srid]), MultiPointFromWKB(wkb[,srid])\n\nConstructs a MULTIPOINT value using its WKB representation and SRID.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/creating-spatial-values.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/creating-spatial-values.html'),(511,'ALTER TABLE',40,'Syntax:\nALTER [IGNORE] TABLE tbl_name\n    [alter_specification [, alter_specification] ...]\n    [partition_options]\n\nalter_specification:\n    table_options\n  | ADD [COLUMN] col_name column_definition\n        [FIRST | AFTER col_name ]\n  | ADD [COLUMN] (col_name column_definition,...)\n  | ADD {INDEX|KEY} [index_name]\n        [index_type] (index_col_name,...) [index_option] ...\n  | ADD [CONSTRAINT [symbol]] PRIMARY KEY\n        [index_type] (index_col_name,...) [index_option] ...\n  | ADD [CONSTRAINT [symbol]]\n        UNIQUE [INDEX|KEY] [index_name]\n        [index_type] (index_col_name,...) [index_option] ...\n  | ADD FULLTEXT [INDEX|KEY] [index_name]\n        (index_col_name,...) [index_option] ...\n  | ADD SPATIAL [INDEX|KEY] [index_name]\n        (index_col_name,...) [index_option] ...\n  | ADD [CONSTRAINT [symbol]]\n        FOREIGN KEY [index_name] (index_col_name,...)\n        reference_definition\n  | ALGORITHM [=] {DEFAULT|INPLACE|COPY}\n  | ALTER [COLUMN] col_name {SET DEFAULT literal | DROP DEFAULT}\n  | CHANGE [COLUMN] old_col_name new_col_name column_definition\n        [FIRST|AFTER col_name]\n  | LOCK [=] {DEFAULT|NONE|SHARED|EXCLUSIVE}\n  | MODIFY [COLUMN] col_name column_definition\n        [FIRST | AFTER col_name]\n  | DROP [COLUMN] col_name\n  | DROP PRIMARY KEY\n  | DROP {INDEX|KEY} index_name\n  | DROP FOREIGN KEY fk_symbol\n  | DISABLE KEYS\n  | ENABLE KEYS\n  | RENAME [TO|AS] new_tbl_name\n  | ORDER BY col_name [, col_name] ...\n  | CONVERT TO CHARACTER SET charset_name [COLLATE collation_name]\n  | [DEFAULT] CHARACTER SET [=] charset_name [COLLATE [=] collation_name]\n  | DISCARD TABLESPACE\n  | IMPORT TABLESPACE\n  | FORCE\n  | ADD PARTITION (partition_definition)\n  | DROP PARTITION partition_names\n  | TRUNCATE PARTITION {partition_names | ALL}\n  | COALESCE PARTITION number\n  | REORGANIZE PARTITION partition_names INTO (partition_definitions)\n  | EXCHANGE PARTITION partition_name WITH TABLE tbl_name\n  | ANALYZE PARTITION {partition_names | ALL}\n  | CHECK PARTITION {partition_names | ALL}\n  | OPTIMIZE PARTITION {partition_names | ALL}\n  | REBUILD PARTITION {partition_names | ALL}\n  | REPAIR PARTITION {partition_names | ALL}\n  | REMOVE PARTITIONING\n\nindex_col_name:\n    col_name [(length)] [ASC | DESC]\n\nindex_type:\n    USING {BTREE | HASH}\n\nindex_option:\n    KEY_BLOCK_SIZE [=] value\n  | index_type\n  | WITH PARSER parser_name\n  | COMMENT \'string\'\n\ntable_options:\n    table_option [[,] table_option] ...  (see CREATE TABLE options)\n\npartition_options:\n    (see CREATE TABLE options)\n\nALTER TABLE changes the structure of a table. For example, you can add\nor delete columns, create or destroy indexes, change the type of\nexisting columns, or rename columns or the table itself. You can also\nchange characteristics such as the storage engine used for the table or\nthe table comment.\n\nPartitioning-related clauses for ALTER TABLE can be used with\npartitioned tables for repartitioning, for adding, dropping, merging,\nand splitting partitions, and for performing partitioning maintenance.\nIt is possible for an ALTER TABLE statement to contain a PARTITION BY\nor REMOVE PARTITION clause in an addition to other alter\nspecifications, but the PARTITION BY or REMOVE PARTITION clause must be\nspecified last after any other specifications. The ADD PARTITION, DROP\nPARTITION, COALESCE PARTITION, REORGANIZE PARTITION, ANALYZE PARTITION,\nCHECK PARTITION, and REPAIR PARTITION options cannot be combined with\nother alter specifications in a single ALTER TABLE, since the options\njust listed act on individual partitions. For more information, see\nhttp://dev.mysql.com/doc/refman/5.6/en/alter-table-partition-operations\n.html.\n\nFollowing the table name, specify the alterations to be made. If none\nare given, ALTER TABLE does nothing.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/alter-table.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/alter-table.html'),(512,'LABELS',24,'Syntax:\n[begin_label:] BEGIN\n    [statement_list]\nEND [end_label]\n\n[begin_label:] LOOP\n    statement_list\nEND LOOP [end_label]\n\n[begin_label:] REPEAT\n    statement_list\nUNTIL search_condition\nEND REPEAT [end_label]\n\n[begin_label:] WHILE search_condition DO\n    statement_list\nEND WHILE [end_label]\n\nLabels are permitted for BEGIN ... END blocks and for the LOOP, REPEAT,\nand WHILE statements. Label use for those statements follows these\nrules:\n\no begin_label must be followed by a colon.\n\no begin_label can be given without end_label. If end_label is present,\n  it must be the same as begin_label.\n\no end_label cannot be given without begin_label.\n\no Labels at the same nesting level must be distinct.\n\no Labels can be up to 16 characters long.\n\nTo refer to a label within the labeled construct, use an ITERATE or\nLEAVE statement. The following example uses those statements to\ncontinue iterating or terminate the loop:\n\nCREATE PROCEDURE doiterate(p1 INT)\nBEGIN\n  label1: LOOP\n    SET p1 = p1 + 1;\n    IF p1 < 10 THEN ITERATE label1; END IF;\n    LEAVE label1;\n  END LOOP label1;\nEND;\n\nThe scope of a block label does not include the code for handlers\ndeclared within the block. For details, see [HELP DECLARE HANDLER].\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/statement-labels.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/statement-labels.html'),(513,'CHAR BYTE',23,'The CHAR BYTE data type is an alias for the BINARY data type. This is a\ncompatibility feature.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/string-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/string-type-overview.html'),(514,'>',19,'Syntax:\n>\n\nGreater than:\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/comparison-operators.html\n\n','mysql> SELECT 2 > 2;\n        -> 0\n','http://dev.mysql.com/doc/refman/5.6/en/comparison-operators.html'),(515,'ANALYZE TABLE',21,'Syntax:\nANALYZE [NO_WRITE_TO_BINLOG | LOCAL] TABLE\n    tbl_name [, tbl_name] ...\n\nANALYZE TABLE analyzes and stores the key distribution for a table.\nDuring the analysis, the table is locked with a read lock for InnoDB\nand MyISAM. This statement works with InnoDB, NDB, and MyISAM tables.\nFor MyISAM tables, this statement is equivalent to using myisamchk\n--analyze.\n\nFor more information on how the analysis works within InnoDB, see\nhttp://dev.mysql.com/doc/refman/5.6/en/innodb-performance.html#innodb-p\nersistent-stats and\nhttp://dev.mysql.com/doc/refman/5.6/en/innodb-restrictions.html. In\nparticular, when you enable the innodb_stats_persistent option, you\nmust run ANALYZE TABLE after loading substantial data into an InnoDB\ntable, or creating a new index for one.\n\nMySQL uses the stored key distribution to decide the order in which\ntables should be joined when you perform a join on something other than\na constant. In addition, key distributions can be used when deciding\nwhich indexes to use for a specific table within a query.\n\nThis statement requires SELECT and INSERT privileges for the table.\n\nANALYZE TABLE is supported for partitioned tables, and you can use\nALTER TABLE ... ANALYZE PARTITION to analyze one or more partitions;\nfor more information, see [HELP ALTER TABLE], and\nhttp://dev.mysql.com/doc/refman/5.6/en/partitioning-maintenance.html.\n\nIn MySQL 5.6.11 only, gtid_next must be set to AUTOMATIC before issuing\nthis statement. (Bug #16062608, Bug #16715809, Bug #69045)\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/analyze-table.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/analyze-table.html'),(516,'FIELD',38,'Syntax:\nFIELD(str,str1,str2,str3,...)\n\nReturns the index (position) of str in the str1, str2, str3, ... list.\nReturns 0 if str is not found.\n\nIf all arguments to FIELD() are strings, all arguments are compared as\nstrings. If all arguments are numbers, they are compared as numbers.\nOtherwise, the arguments are compared as double.\n\nIf str is NULL, the return value is 0 because NULL fails equality\ncomparison with any value. FIELD() is the complement of ELT().\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/string-functions.html\n\n','mysql> SELECT FIELD(\'ej\', \'Hej\', \'ej\', \'Heja\', \'hej\', \'foo\');\n        -> 2\nmysql> SELECT FIELD(\'fo\', \'Hej\', \'ej\', \'Heja\', \'hej\', \'foo\');\n        -> 0\n','http://dev.mysql.com/doc/refman/5.6/en/string-functions.html'),(517,'CONSTRAINT',40,'MySQL supports foreign keys, which let you cross-reference related data\nacross tables, and foreign key constraints, which help keep this\nspread-out data consistent. The essential syntax for a foreign key\nconstraint definition in a CREATE TABLE or ALTER TABLE statement looks\nlike this:\n\n[CONSTRAINT [symbol]] FOREIGN KEY\n    [index_name] (index_col_name, ...)\n    REFERENCES tbl_name (index_col_name,...)\n    [ON DELETE reference_option]\n    [ON UPDATE reference_option]\n\nreference_option:\n    RESTRICT | CASCADE | SET NULL | NO ACTION\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/create-table-foreign-keys.html\n\n','CREATE TABLE product (\n    category INT NOT NULL, id INT NOT NULL,\n    price DECIMAL,\n    PRIMARY KEY(category, id)\n)   ENGINE=INNODB;\n\nCREATE TABLE customer (\n    id INT NOT NULL,\n    PRIMARY KEY (id)\n)   ENGINE=INNODB;\n\nCREATE TABLE product_order (\n    no INT NOT NULL AUTO_INCREMENT,\n    product_category INT NOT NULL,\n    product_id INT NOT NULL,\n    customer_id INT NOT NULL,\n\n    PRIMARY KEY(no),\n    INDEX (product_category, product_id),\n    INDEX (customer_id),\n\n    FOREIGN KEY (product_category, product_id)\n      REFERENCES product(category, id)\n      ON UPDATE CASCADE ON DELETE RESTRICT,\n\n    FOREIGN KEY (customer_id)\n      REFERENCES customer(id)\n)   ENGINE=INNODB;\n','http://dev.mysql.com/doc/refman/5.6/en/create-table-foreign-keys.html'),(518,'ALTER TABLESPACE',40,'Syntax:\nALTER TABLESPACE tablespace_name\n    {ADD|DROP} DATAFILE \'file_name\'\n    [INITIAL_SIZE [=] size]\n    [WAIT]\n    ENGINE [=] engine_name\n\nThis statement can be used either to add a new data file, or to drop a\ndata file from a tablespace.\n\nThe ADD DATAFILE variant enables you to specify an initial size using\nan INITIAL_SIZE clause, where size is measured in bytes; the default\nvalue is 128M (128 megabytes). You may optionally follow this integer\nvalue with a one-letter abbreviation for an order of magnitude, similar\nto those used in my.cnf. Generally, this is one of the letters M (for\nmegabytes) or G (for gigabytes).\n\n*Note*: All MySQL Cluster Disk Data objects share the same namespace.\nThis means that each Disk Data object must be uniquely named (and not\nmerely each Disk Data object of a given type). For example, you cannot\nhave a tablespace and an data file with the same name, or an undo log\nfile and a tablespace with the same name.\n\nOn 32-bit systems, the maximum supported value for INITIAL_SIZE is 4G.\n(Bug #29186)\n\nINITIAL_SIZE is rounded, explicitly, as for CREATE TABLESPACE.\n\nOnce a data file has been created, its size cannot be changed; however,\nyou can add more data files to the tablespace using additional ALTER\nTABLESPACE ... ADD DATAFILE statements.\n\nUsing DROP DATAFILE with ALTER TABLESPACE drops the data file\n\'file_name\' from the tablespace. You cannot drop a data file from a\ntablespace which is in use by any table; in other words, the data file\nmust be empty (no extents used). See\nhttp://dev.mysql.com/doc/refman/5.6/en/mysql-cluster-disk-data-objects.\nhtml. In addition, any data file to be dropped must previously have\nbeen added to the tablespace with CREATE TABLESPACE or ALTER\nTABLESPACE.\n\nBoth ALTER TABLESPACE ... ADD DATAFILE and ALTER TABLESPACE ... DROP\nDATAFILE require an ENGINE clause which specifies the storage engine\nused by the tablespace. Currently, the only accepted values for\nengine_name are NDB and NDBCLUSTER.\n\nWAIT is parsed but otherwise ignored, and so has no effect in MySQL\n5.6. It is intended for future expansion.\n\nWhen ALTER TABLESPACE ... ADD DATAFILE is used with ENGINE = NDB, a\ndata file is created on each Cluster data node. You can verify that the\ndata files were created and obtain information about them by querying\nthe INFORMATION_SCHEMA.FILES table. For example, the following query\nshows all data files belonging to the tablespace named newts:\n\nmysql> SELECT LOGFILE_GROUP_NAME, FILE_NAME, EXTRA\n    -> FROM INFORMATION_SCHEMA.FILES\n    -> WHERE TABLESPACE_NAME = \'newts\' AND FILE_TYPE = \'DATAFILE\';\n+--------------------+--------------+----------------+\n| LOGFILE_GROUP_NAME | FILE_NAME    | EXTRA          |\n+--------------------+--------------+----------------+\n| lg_3               | newdata.dat  | CLUSTER_NODE=3 |\n| lg_3               | newdata.dat  | CLUSTER_NODE=4 |\n| lg_3               | newdata2.dat | CLUSTER_NODE=3 |\n| lg_3               | newdata2.dat | CLUSTER_NODE=4 |\n+--------------------+--------------+----------------+\n2 rows in set (0.03 sec)\n\nSee http://dev.mysql.com/doc/refman/5.6/en/files-table.html.\n\nALTER TABLESPACE is useful only with Disk Data storage for MySQL\nCluster. See\nhttp://dev.mysql.com/doc/refman/5.6/en/mysql-cluster-disk-data.html.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/alter-tablespace.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/alter-tablespace.html'),(519,'ENUM',23,'ENUM(\'value1\',\'value2\',...) [CHARACTER SET charset_name] [COLLATE\ncollation_name]\n\nAn enumeration. A string object that can have only one value, chosen\nfrom the list of values \'value1\', \'value2\', ..., NULL or the special \'\'\nerror value. ENUM values are represented internally as integers.\n\nAn ENUM column can have a maximum of 65,535 distinct elements. (The\npractical limit is less than 3000.) A table can have no more than 255\nunique element list definitions among its ENUM and SET columns\nconsidered as a group. For more information on these limits, see\nhttp://dev.mysql.com/doc/refman/5.6/en/limits-frm-file.html.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/string-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/string-type-overview.html'),(520,'STRCMP',38,'Syntax:\nSTRCMP(expr1,expr2)\n\nSTRCMP() returns 0 if the strings are the same, -1 if the first\nargument is smaller than the second according to the current sort\norder, and 1 otherwise.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/string-comparison-functions.html\n\n','mysql> SELECT STRCMP(\'text\', \'text2\');\n        -> -1\nmysql> SELECT STRCMP(\'text2\', \'text\');\n        -> 1\nmysql> SELECT STRCMP(\'text\', \'text\');\n        -> 0\n','http://dev.mysql.com/doc/refman/5.6/en/string-comparison-functions.html'),(521,'INSERT DELAYED',28,'Syntax:\nINSERT DELAYED ...\n\nThe DELAYED option for the INSERT statement is a MySQL extension to\nstandard SQL that can be used for certain kinds of tables (such as\nMyISAM). When a client uses INSERT DELAYED, it gets an okay from the\nserver at once, and the row is queued to be inserted when the table is\nnot in use by any other thread.\n\n*Note*: INSERT DELAYED is slower than a normal INSERT if the table is\nnot otherwise in use. There is also the additional overhead for the\nserver to handle a separate thread for each table for which there are\ndelayed rows. This means that you should use INSERT DELAYED only when\nyou are really sure that you need it. As of MySQL 5.6.6, INSERT DELAYED\nis deprecated, and will be removed in a future release. Use INSERT\n(without DELAYED) instead.\n\nThe queued rows are held only in memory until they are inserted into\nthe table. This means that if you terminate mysqld forcibly (for\nexample, with kill -9) or if mysqld dies unexpectedly, any queued rows\nthat have not been written to disk are lost.\n\nThere are some constraints on the use of DELAYED:\n\no INSERT DELAYED works only with MyISAM, MEMORY, ARCHIVE, and BLACKHOLE\n  tables. For engines that do not support DELAYED, an error occurs.\n\no An error occurs for INSERT DELAYED if used with a table that has been\n  locked with LOCK TABLES because the insert must be handled by a\n  separate thread, not by the session that holds the lock.\n\no For MyISAM tables, if there are no free blocks in the middle of the\n  data file, concurrent SELECT and INSERT statements are supported.\n  Under these circumstances, you very seldom need to use INSERT DELAYED\n  with MyISAM.\n\no INSERT DELAYED should be used only for INSERT statements that specify\n  value lists. The server ignores DELAYED for INSERT ... SELECT or\n  INSERT ... ON DUPLICATE KEY UPDATE statements.\n\no Because the INSERT DELAYED statement returns immediately, before the\n  rows are inserted, you cannot use LAST_INSERT_ID() to get the\n  AUTO_INCREMENT value that the statement might generate.\n\no DELAYED rows are not visible to SELECT statements until they actually\n  have been inserted.\n\no Prior to MySQL 5.6, INSERT DELAYED was treated as a normal INSERT if\n  the statement inserted multiple rows, binary logging was enabled, and\n  the global logging format was statement-based (that is, whenever\n  binlog_format was set to STATEMENT). Beginning with MySQL 5.6, INSERT\n  DELAYED is always handled as a simple INSERT (that is, without the\n  DELAYED option) whenever the value of binlog_format is STATEMENT or\n  MIXED. (In the latter case, the statement no longer triggers a switch\n  to row-based logging, and so is logged using the statement-based\n  format.)\n\n  This does not apply when using row-based binary logging mode\n  (binlog_format set to ROW), in which INSERT DELAYED statements are\n  always executed using the DELAYED option as specified, and logged as\n  row-update events.\n\no DELAYED is ignored on slave replication servers, so that INSERT\n  DELAYED is treated as a normal INSERT on slaves. This is because\n  DELAYED could cause the slave to have different data than the master.\n\no Pending INSERT DELAYED statements are lost if a table is write locked\n  and ALTER TABLE is used to modify the table structure.\n\no INSERT DELAYED is not supported for views.\n\no INSERT DELAYED is not supported for partitioned tables.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/insert-delayed.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/insert-delayed.html'),(522,'SHOW PROCEDURE CODE',27,'Syntax:\nSHOW PROCEDURE CODE proc_name\n\nThis statement is a MySQL extension that is available only for servers\nthat have been built with debugging support. It displays a\nrepresentation of the internal implementation of the named stored\nprocedure. A similar statement, SHOW FUNCTION CODE, displays\ninformation about stored functions (see [HELP SHOW FUNCTION CODE]).\n\nBoth statements require that you be the owner of the routine or have\nSELECT access to the mysql.proc table.\n\nIf the named routine is available, each statement produces a result\nset. Each row in the result set corresponds to one \"instruction\" in the\nroutine. The first column is Pos, which is an ordinal number beginning\nwith 0. The second column is Instruction, which contains an SQL\nstatement (usually changed from the original source), or a directive\nwhich has meaning only to the stored-routine handler.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/show-procedure-code.html\n\n','mysql> DELIMITER //\nmysql> CREATE PROCEDURE p1 ()\n    -> BEGIN\n    ->   DECLARE fanta INT DEFAULT 55;\n    ->   DROP TABLE t2;\n    ->   LOOP\n    ->     INSERT INTO t3 VALUES (fanta);\n    ->     END LOOP;\n    ->   END//\nQuery OK, 0 rows affected (0.00 sec)\n\nmysql> SHOW PROCEDURE CODE p1//\n+-----+----------------------------------------+\n| Pos | Instruction                            |\n+-----+----------------------------------------+\n|   0 | set fanta@0 55                         |\n|   1 | stmt 9 \"DROP TABLE t2\"                 |\n|   2 | stmt 5 \"INSERT INTO t3 VALUES (fanta)\" |\n|   3 | jump 2                                 |\n+-----+----------------------------------------+\n4 rows in set (0.00 sec)\n','http://dev.mysql.com/doc/refman/5.6/en/show-procedure-code.html'),(523,'MEDIUMTEXT',23,'MEDIUMTEXT [CHARACTER SET charset_name] [COLLATE collation_name]\n\nA TEXT column with a maximum length of 16,777,215 (224 - 1) characters.\nThe effective maximum length is less if the value contains multi-byte\ncharacters. Each MEDIUMTEXT value is stored using a 3-byte length\nprefix that indicates the number of bytes in the value.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/string-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/string-type-overview.html'),(524,'LOG',4,'Syntax:\nLOG(X), LOG(B,X)\n\nIf called with one parameter, this function returns the natural\nlogarithm of X. If X is less than or equal to 0, then NULL is returned.\n\nThe inverse of this function (when called with a single argument) is\nthe EXP() function.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/mathematical-functions.html\n\n','mysql> SELECT LOG(2);\n        -> 0.69314718055995\nmysql> SELECT LOG(-2);\n        -> NULL\n','http://dev.mysql.com/doc/refman/5.6/en/mathematical-functions.html'),(525,'SHOW COLLATION',27,'Syntax:\nSHOW COLLATION\n    [LIKE \'pattern\' | WHERE expr]\n\nThis statement lists collations supported by the server. By default,\nthe output from SHOW COLLATION includes all available collations. The\nLIKE clause, if present, indicates which collation names to match. The\nWHERE clause can be given to select rows using more general conditions,\nas discussed in\nhttp://dev.mysql.com/doc/refman/5.6/en/extended-show.html. For example:\n\nmysql> SHOW COLLATION LIKE \'latin1%\';\n+-------------------+---------+----+---------+----------+---------+\n| Collation         | Charset | Id | Default | Compiled | Sortlen |\n+-------------------+---------+----+---------+----------+---------+\n| latin1_german1_ci | latin1  |  5 |         |          |       0 |\n| latin1_swedish_ci | latin1  |  8 | Yes     | Yes      |       0 |\n| latin1_danish_ci  | latin1  | 15 |         |          |       0 |\n| latin1_german2_ci | latin1  | 31 |         | Yes      |       2 |\n| latin1_bin        | latin1  | 47 |         | Yes      |       0 |\n| latin1_general_ci | latin1  | 48 |         |          |       0 |\n| latin1_general_cs | latin1  | 49 |         |          |       0 |\n| latin1_spanish_ci | latin1  | 94 |         |          |       0 |\n+-------------------+---------+----+---------+----------+---------+\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/show-collation.html\n\n','','http://dev.mysql.com/doc/refman/5.6/en/show-collation.html'),(526,'!=',19,'Syntax:\n<>, !=\n\nNot equal:\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/comparison-operators.html\n\n','mysql> SELECT \'.01\' <> \'0.01\';\n        -> 1\nmysql> SELECT .01 <> \'0.01\';\n        -> 0\nmysql> SELECT \'zapp\' <> \'zappp\';\n        -> 1\n','http://dev.mysql.com/doc/refman/5.6/en/comparison-operators.html'),(527,'WHILE',24,'Syntax:\n[begin_label:] WHILE search_condition DO\n    statement_list\nEND WHILE [end_label]\n\nThe statement list within a WHILE statement is repeated as long as the\nsearch_condition expression is true. statement_list consists of one or\nmore SQL statements, each terminated by a semicolon (;) statement\ndelimiter.\n\nA WHILE statement can be labeled. For the rules regarding label use,\nsee [HELP labels].\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/while.html\n\n','CREATE PROCEDURE dowhile()\nBEGIN\n  DECLARE v1 INT DEFAULT 5;\n\n  WHILE v1 > 0 DO\n    ...\n    SET v1 = v1 - 1;\n  END WHILE;\nEND;\n','http://dev.mysql.com/doc/refman/5.6/en/while.html'),(528,'DAYNAME',32,'Syntax:\nDAYNAME(date)\n\nReturns the name of the weekday for date. The language used for the\nname is controlled by the value of the lc_time_names system variable\n(http://dev.mysql.com/doc/refman/5.6/en/locale-support.html).\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html\n\n','mysql> SELECT DAYNAME(\'2007-02-03\');\n        -> \'Saturday\'\n','http://dev.mysql.com/doc/refman/5.6/en/date-and-time-functions.html'),(529,'COLLATION',17,'Syntax:\nCOLLATION(str)\n\nReturns the collation of the string argument.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/information-functions.html\n\n','mysql> SELECT COLLATION(\'abc\');\n        -> \'latin1_swedish_ci\'\nmysql> SELECT COLLATION(_utf8\'abc\');\n        -> \'utf8_general_ci\'\n','http://dev.mysql.com/doc/refman/5.6/en/information-functions.html'),(530,'RADIANS',4,'Syntax:\nRADIANS(X)\n\nReturns the argument X, converted from degrees to radians. (Note that\nπ radians equals 180 degrees.)\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/mathematical-functions.html\n\n','mysql> SELECT RADIANS(90);\n        -> 1.5707963267949\n','http://dev.mysql.com/doc/refman/5.6/en/mathematical-functions.html'),(531,'COALESCE',19,'Syntax:\nCOALESCE(value,...)\n\nReturns the first non-NULL value in the list, or NULL if there are no\nnon-NULL values.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/comparison-operators.html\n\n','mysql> SELECT COALESCE(NULL,1);\n        -> 1\nmysql> SELECT COALESCE(NULL,NULL,NULL);\n        -> NULL\n','http://dev.mysql.com/doc/refman/5.6/en/comparison-operators.html'),(532,'VERSION',17,'Syntax:\nVERSION()\n\nReturns a string that indicates the MySQL server version. The string\nuses the utf8 character set. The value might have a suffix in addition\nto the version number. See the description of the version system\nvariable in\nhttp://dev.mysql.com/doc/refman/5.6/en/server-system-variables.html.\n\nURL: http://dev.mysql.com/doc/refman/5.6/en/information-functions.html\n\n','mysql> SELECT VERSION();\n        -> \'5.6.13-standard\'\n','http://dev.mysql.com/doc/refman/5.6/en/information-functions.html');
/*!40000 ALTER TABLE `help_topic` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `innodb_index_stats`
--

DROP TABLE IF EXISTS `innodb_index_stats`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `innodb_index_stats` (
  `database_name` varchar(64) COLLATE utf8_bin NOT NULL,
  `table_name` varchar(64) COLLATE utf8_bin NOT NULL,
  `index_name` varchar(64) COLLATE utf8_bin NOT NULL,
  `last_update` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `stat_name` varchar(64) COLLATE utf8_bin NOT NULL,
  `stat_value` bigint(20) unsigned NOT NULL,
  `sample_size` bigint(20) unsigned DEFAULT NULL,
  `stat_description` varchar(1024) COLLATE utf8_bin NOT NULL,
  PRIMARY KEY (`database_name`,`table_name`,`index_name`,`stat_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin STATS_PERSISTENT=0;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `innodb_index_stats`
--

LOCK TABLES `innodb_index_stats` WRITE;
/*!40000 ALTER TABLE `innodb_index_stats` DISABLE KEYS */;
INSERT INTO `innodb_index_stats` VALUES ('mysql','gtid_executed','PRIMARY','2017-03-02 18:45:29','n_diff_pfx01',0,1,'source_uuid'),('mysql','gtid_executed','PRIMARY','2017-03-02 18:45:29','n_diff_pfx02',0,1,'source_uuid,interval_start'),('mysql','gtid_executed','PRIMARY','2017-03-02 18:45:29','n_leaf_pages',1,NULL,'Number of leaf pages in the index'),('mysql','gtid_executed','PRIMARY','2017-03-02 18:45:29','size',1,NULL,'Number of pages in the index'),('sys','sys_config','PRIMARY','2017-03-02 18:46:35','n_diff_pfx01',6,1,'variable'),('sys','sys_config','PRIMARY','2017-03-02 18:46:35','n_leaf_pages',1,NULL,'Number of leaf pages in the index'),('sys','sys_config','PRIMARY','2017-03-02 18:46:35','size',1,NULL,'Number of pages in the index');
/*!40000 ALTER TABLE `innodb_index_stats` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `innodb_table_stats`
--

DROP TABLE IF EXISTS `innodb_table_stats`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `innodb_table_stats` (
  `database_name` varchar(64) COLLATE utf8_bin NOT NULL,
  `table_name` varchar(64) COLLATE utf8_bin NOT NULL,
  `last_update` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `n_rows` bigint(20) unsigned NOT NULL,
  `clustered_index_size` bigint(20) unsigned NOT NULL,
  `sum_of_other_index_sizes` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`database_name`,`table_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin STATS_PERSISTENT=0;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `innodb_table_stats`
--

LOCK TABLES `innodb_table_stats` WRITE;
/*!40000 ALTER TABLE `innodb_table_stats` DISABLE KEYS */;
INSERT INTO `innodb_table_stats` VALUES ('mysql','gtid_executed','2017-03-02 18:45:29',0,1,0),('sys','sys_config','2017-03-02 18:46:35',6,1,0);
/*!40000 ALTER TABLE `innodb_table_stats` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ndb_binlog_index`
--

DROP TABLE IF EXISTS `ndb_binlog_index`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ndb_binlog_index` (
  `Position` bigint(20) unsigned NOT NULL,
  `File` varchar(255) NOT NULL,
  `epoch` bigint(20) unsigned NOT NULL,
  `inserts` int(10) unsigned NOT NULL,
  `updates` int(10) unsigned NOT NULL,
  `deletes` int(10) unsigned NOT NULL,
  `schemaops` int(10) unsigned NOT NULL,
  `orig_server_id` int(10) unsigned NOT NULL,
  `orig_epoch` bigint(20) unsigned NOT NULL,
  `gci` int(10) unsigned NOT NULL,
  `next_position` bigint(20) unsigned NOT NULL,
  `next_file` varchar(255) NOT NULL,
  PRIMARY KEY (`epoch`,`orig_server_id`,`orig_epoch`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ndb_binlog_index`
--

LOCK TABLES `ndb_binlog_index` WRITE;
/*!40000 ALTER TABLE `ndb_binlog_index` DISABLE KEYS */;
/*!40000 ALTER TABLE `ndb_binlog_index` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `plugin`
--

DROP TABLE IF EXISTS `plugin`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `plugin` (
  `name` varchar(64) NOT NULL DEFAULT '',
  `dl` varchar(128) NOT NULL DEFAULT '',
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 STATS_PERSISTENT=0 COMMENT='MySQL plugins';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `plugin`
--

LOCK TABLES `plugin` WRITE;
/*!40000 ALTER TABLE `plugin` DISABLE KEYS */;
/*!40000 ALTER TABLE `plugin` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `proc`
--

DROP TABLE IF EXISTS `proc`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `proc` (
  `db` char(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `name` char(64) NOT NULL DEFAULT '',
  `type` enum('FUNCTION','PROCEDURE') NOT NULL,
  `specific_name` char(64) NOT NULL DEFAULT '',
  `language` enum('SQL') NOT NULL DEFAULT 'SQL',
  `sql_data_access` enum('CONTAINS_SQL','NO_SQL','READS_SQL_DATA','MODIFIES_SQL_DATA') NOT NULL DEFAULT 'CONTAINS_SQL',
  `is_deterministic` enum('YES','NO') NOT NULL DEFAULT 'NO',
  `security_type` enum('INVOKER','DEFINER') NOT NULL DEFAULT 'DEFINER',
  `param_list` blob NOT NULL,
  `returns` longblob NOT NULL,
  `body` longblob NOT NULL,
  `definer` char(93) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `sql_mode` set('REAL_AS_FLOAT','PIPES_AS_CONCAT','ANSI_QUOTES','IGNORE_SPACE','NOT_USED','ONLY_FULL_GROUP_BY','NO_UNSIGNED_SUBTRACTION','NO_DIR_IN_CREATE','POSTGRESQL','ORACLE','MSSQL','DB2','MAXDB','NO_KEY_OPTIONS','NO_TABLE_OPTIONS','NO_FIELD_OPTIONS','MYSQL323','MYSQL40','ANSI','NO_AUTO_VALUE_ON_ZERO','NO_BACKSLASH_ESCAPES','STRICT_TRANS_TABLES','STRICT_ALL_TABLES','NO_ZERO_IN_DATE','NO_ZERO_DATE','INVALID_DATES','ERROR_FOR_DIVISION_BY_ZERO','TRADITIONAL','NO_AUTO_CREATE_USER','HIGH_NOT_PRECEDENCE','NO_ENGINE_SUBSTITUTION','PAD_CHAR_TO_FULL_LENGTH') NOT NULL DEFAULT '',
  `comment` text CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `character_set_client` char(32) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `collation_connection` char(32) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `db_collation` char(32) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `body_utf8` longblob,
  PRIMARY KEY (`db`,`name`,`type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Stored Procedures';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `proc`
--

LOCK TABLES `proc` WRITE;
/*!40000 ALTER TABLE `proc` DISABLE KEYS */;
INSERT INTO `proc` VALUES ('sys','extract_schema_from_file_name','FUNCTION','extract_schema_from_file_name','SQL','NO_SQL','YES','INVOKER',_binary ' path VARCHAR(512) ',_binary 'varchar(64) CHARSET utf8',_binary 'BEGIN RETURN LEFT(SUBSTRING_INDEX(SUBSTRING_INDEX(REPLACE(path, \'\\\\\', \'/\'), \'/\', -2), \'/\', 1), 64); END','mysql.sys@localhost','2017-03-02 18:46:26','2017-03-02 18:46:26','','\n Description\n \n Takes a raw file path, and attempts to extract the schema name from it.\n \n Useful for when interacting with Performance Schema data \n concerning IO statistics, for example.\n \n Currently relies on the fact that a table data file will be within a \n specified database directory (will not work with partitions or tables\n that specify an individual DATA_DIRECTORY).\n \n Parameters\n \n path (VARCHAR(512)):\n The full file path to a data file to extract the schema name from.\n \n Returns\n \n VARCHAR(64)\n \n Example\n \n mysql> SELECT sys.extract_schema_from_file_name(\'/var/lib/mysql/employees/employee.ibd\');\n +----------------------------------------------------------------------------+\n | sys.extract_schema_from_file_name(\'/var/lib/mysql/employees/employee.ibd\') |\n +----------------------------------------------------------------------------+\n | employees                                                                  |\n +----------------------------------------------------------------------------+\n 1 row in set (0.00 sec)\n ','utf8','utf8_general_ci','utf8_general_ci',_binary 'BEGIN RETURN LEFT(SUBSTRING_INDEX(SUBSTRING_INDEX(REPLACE(path, \'\\\', \'/\'), \'/\', -2), \'/\', 1), 64); END'),('sys','extract_table_from_file_name','FUNCTION','extract_table_from_file_name','SQL','NO_SQL','YES','INVOKER',_binary ' path VARCHAR(512) ',_binary 'varchar(64) CHARSET utf8',_binary 'BEGIN RETURN LEFT(SUBSTRING_INDEX(REPLACE(SUBSTRING_INDEX(REPLACE(path, \'\\\\\', \'/\'), \'/\', -1), \'@0024\', \'$\'), \'.\', 1), 64); END','mysql.sys@localhost','2017-03-02 18:46:26','2017-03-02 18:46:26','','\n Description\n \n Takes a raw file path, and extracts the table name from it.\n \n Useful for when interacting with Performance Schema data \n concerning IO statistics, for example.\n \n Parameters\n \n path (VARCHAR(512)):\n The full file path to a data file to extract the table name from.\n \n Returns\n \n VARCHAR(64)\n \n Example\n \n mysql> SELECT sys.extract_table_from_file_name(\'/var/lib/mysql/employees/employee.ibd\');\n +---------------------------------------------------------------------------+\n | sys.extract_table_from_file_name(\'/var/lib/mysql/employees/employee.ibd\') |\n +---------------------------------------------------------------------------+\n | employee                                                                  |\n +---------------------------------------------------------------------------+\n 1 row in set (0.02 sec)\n ','utf8','utf8_general_ci','utf8_general_ci',_binary 'BEGIN RETURN LEFT(SUBSTRING_INDEX(REPLACE(SUBSTRING_INDEX(REPLACE(path, \'\\\', \'/\'), \'/\', -1), \'@0024\', \'$\'), \'.\', 1), 64); END'),('sys','format_bytes','FUNCTION','format_bytes','SQL','NO_SQL','YES','INVOKER',_binary ' bytes TEXT ',_binary 'text CHARSET utf8',_binary 'BEGIN IF bytes IS NULL THEN RETURN NULL; ELSEIF bytes >= 1125899906842624 THEN RETURN CONCAT(ROUND(bytes / 1125899906842624, 2), \' PiB\'); ELSEIF bytes >= 1099511627776 THEN RETURN CONCAT(ROUND(bytes / 1099511627776, 2), \' TiB\'); ELSEIF bytes >= 1073741824 THEN RETURN CONCAT(ROUND(bytes / 1073741824, 2), \' GiB\'); ELSEIF bytes >= 1048576 THEN RETURN CONCAT(ROUND(bytes / 1048576, 2), \' MiB\'); ELSEIF bytes >= 1024 THEN RETURN CONCAT(ROUND(bytes / 1024, 2), \' KiB\'); ELSE RETURN CONCAT(ROUND(bytes, 0), \' bytes\'); END IF; END','mysql.sys@localhost','2017-03-02 18:46:26','2017-03-02 18:46:26','','\n Description\n \n Takes a raw bytes value, and converts it to a human readable format.\n \n Parameters\n \n bytes (TEXT):\n A raw bytes value.\n \n Returns\n \n TEXT\n \n Example\n \n mysql> SELECT sys.format_bytes(2348723492723746) AS size;\n +----------+\n | size     |\n +----------+\n | 2.09 PiB |\n +----------+\n 1 row in set (0.00 sec)\n \n mysql> SELECT sys.format_bytes(2348723492723) AS size;\n +----------+\n | size     |\n +----------+\n | 2.14 TiB |\n +----------+\n 1 row in set (0.00 sec)\n \n mysql> SELECT sys.format_bytes(23487234) AS size;\n +-----------+\n | size      |\n +-----------+\n | 22.40 MiB |\n +-----------+\n 1 row in set (0.00 sec)\n ','utf8','utf8_general_ci','utf8_general_ci',_binary 'BEGIN IF bytes IS NULL THEN RETURN NULL; ELSEIF bytes >= 1125899906842624 THEN RETURN CONCAT(ROUND(bytes / 1125899906842624, 2), \' PiB\'); ELSEIF bytes >= 1099511627776 THEN RETURN CONCAT(ROUND(bytes / 1099511627776, 2), \' TiB\'); ELSEIF bytes >= 1073741824 THEN RETURN CONCAT(ROUND(bytes / 1073741824, 2), \' GiB\'); ELSEIF bytes >= 1048576 THEN RETURN CONCAT(ROUND(bytes / 1048576, 2), \' MiB\'); ELSEIF bytes >= 1024 THEN RETURN CONCAT(ROUND(bytes / 1024, 2), \' KiB\'); ELSE RETURN CONCAT(ROUND(bytes, 0), \' bytes\'); END IF; END'),('sys','format_path','FUNCTION','format_path','SQL','NO_SQL','YES','INVOKER',_binary ' in_path VARCHAR(512) ',_binary 'varchar(512) CHARSET utf8',_binary 'BEGIN DECLARE v_path VARCHAR(512); DECLARE v_undo_dir VARCHAR(1024);  DECLARE path_separator CHAR(1) DEFAULT \'/\';  IF @@global.version_compile_os LIKE \'win%\' THEN SET path_separator = \'\\\\\'; END IF;  IF in_path LIKE \'/private/%\' THEN SET v_path = REPLACE(in_path, \'/private\', \'\'); ELSE SET v_path = in_path; END IF;  SET v_undo_dir = IFNULL((SELECT VARIABLE_VALUE FROM performance_schema.global_variables WHERE VARIABLE_NAME = \'innodb_undo_directory\'), \'\');  IF v_path IS NULL THEN RETURN NULL; ELSEIF v_path LIKE CONCAT(@@global.datadir, IF(SUBSTRING(@@global.datadir, -1) = path_separator, \'%\', CONCAT(path_separator, \'%\'))) ESCAPE \'|\' THEN SET v_path = REPLACE(v_path, @@global.datadir, CONCAT(\'@@datadir\', IF(SUBSTRING(@@global.datadir, -1) = path_separator, path_separator, \'\'))); ELSEIF v_path LIKE CONCAT(@@global.tmpdir, IF(SUBSTRING(@@global.tmpdir, -1) = path_separator, \'%\', CONCAT(path_separator, \'%\'))) ESCAPE \'|\' THEN SET v_path = REPLACE(v_path, @@global.tmpdir, CONCAT(\'@@tmpdir\', IF(SUBSTRING(@@global.tmpdir, -1) = path_separator, path_separator, \'\'))); ELSEIF v_path LIKE CONCAT(@@global.slave_load_tmpdir, IF(SUBSTRING(@@global.slave_load_tmpdir, -1) = path_separator, \'%\', CONCAT(path_separator, \'%\'))) ESCAPE \'|\' THEN SET v_path = REPLACE(v_path, @@global.slave_load_tmpdir, CONCAT(\'@@slave_load_tmpdir\', IF(SUBSTRING(@@global.slave_load_tmpdir, -1) = path_separator, path_separator, \'\'))); ELSEIF v_path LIKE CONCAT(@@global.innodb_data_home_dir, IF(SUBSTRING(@@global.innodb_data_home_dir, -1) = path_separator, \'%\', CONCAT(path_separator, \'%\'))) ESCAPE \'|\' THEN SET v_path = REPLACE(v_path, @@global.innodb_data_home_dir, CONCAT(\'@@innodb_data_home_dir\', IF(SUBSTRING(@@global.innodb_data_home_dir, -1) = path_separator, path_separator, \'\'))); ELSEIF v_path LIKE CONCAT(@@global.innodb_log_group_home_dir, IF(SUBSTRING(@@global.innodb_log_group_home_dir, -1) = path_separator, \'%\', CONCAT(path_separator, \'%\'))) ESCAPE \'|\' THEN SET v_path = REPLACE(v_path, @@global.innodb_log_group_home_dir, CONCAT(\'@@innodb_log_group_home_dir\', IF(SUBSTRING(@@global.innodb_log_group_home_dir, -1) = path_separator, path_separator, \'\'))); ELSEIF v_path LIKE CONCAT(v_undo_dir, IF(SUBSTRING(v_undo_dir, -1) = path_separator, \'%\', CONCAT(path_separator, \'%\'))) ESCAPE \'|\' THEN SET v_path = REPLACE(v_path, v_undo_dir, CONCAT(\'@@innodb_undo_directory\', IF(SUBSTRING(v_undo_dir, -1) = path_separator, path_separator, \'\'))); ELSEIF v_path LIKE CONCAT(@@global.basedir, IF(SUBSTRING(@@global.basedir, -1) = path_separator, \'%\', CONCAT(path_separator, \'%\'))) ESCAPE \'|\' THEN SET v_path = REPLACE(v_path, @@global.basedir, CONCAT(\'@@basedir\', IF(SUBSTRING(@@global.basedir, -1) = path_separator, path_separator, \'\'))); END IF;  RETURN v_path; END','mysql.sys@localhost','2017-03-02 18:46:26','2017-03-02 18:46:26','','\n Description\n \n Takes a raw path value, and strips out the datadir or tmpdir\n replacing with @@datadir and @@tmpdir respectively. \n \n Also normalizes the paths across operating systems, so backslashes\n on Windows are converted to forward slashes\n \n Parameters\n \n path (VARCHAR(512)):\n The raw file path value to format.\n \n Returns\n \n VARCHAR(512) CHARSET UTF8\n \n Example\n \n mysql> select @@datadir;\n +-----------------------------------------------+\n | @@datadir                                     |\n +-----------------------------------------------+\n | /Users/mark/sandboxes/SmallTree/AMaster/data/ |\n +-----------------------------------------------+\n 1 row in set (0.06 sec)\n \n mysql> select format_path(\'/Users/mark/sandboxes/SmallTree/AMaster/data/mysql/proc.MYD\') AS path;\n +--------------------------+\n | path                     |\n +--------------------------+\n | @@datadir/mysql/proc.MYD |\n +--------------------------+\n 1 row in set (0.03 sec)\n ','utf8','utf8_general_ci','utf8_general_ci',_binary 'BEGIN DECLARE v_path VARCHAR(512); DECLARE v_undo_dir VARCHAR(1024);  DECLARE path_separator CHAR(1) DEFAULT \'/\';  IF @@global.version_compile_os LIKE \'win%\' THEN SET path_separator = \'\\\'; END IF;  IF in_path LIKE \'/private/%\' THEN SET v_path = REPLACE(in_path, \'/private\', \'\'); ELSE SET v_path = in_path; END IF;  SET v_undo_dir = IFNULL((SELECT VARIABLE_VALUE FROM performance_schema.global_variables WHERE VARIABLE_NAME = \'innodb_undo_directory\'), \'\');  IF v_path IS NULL THEN RETURN NULL; ELSEIF v_path LIKE CONCAT(@@global.datadir, IF(SUBSTRING(@@global.datadir, -1) = path_separator, \'%\', CONCAT(path_separator, \'%\'))) ESCAPE \'|\' THEN SET v_path = REPLACE(v_path, @@global.datadir, CONCAT(\'@@datadir\', IF(SUBSTRING(@@global.datadir, -1) = path_separator, path_separator, \'\'))); ELSEIF v_path LIKE CONCAT(@@global.tmpdir, IF(SUBSTRING(@@global.tmpdir, -1) = path_separator, \'%\', CONCAT(path_separator, \'%\'))) ESCAPE \'|\' THEN SET v_path = REPLACE(v_path, @@global.tmpdir, CONCAT(\'@@tmpdir\', IF(SUBSTRING(@@global.tmpdir, -1) = path_separator, path_separator, \'\'))); ELSEIF v_path LIKE CONCAT(@@global.slave_load_tmpdir, IF(SUBSTRING(@@global.slave_load_tmpdir, -1) = path_separator, \'%\', CONCAT(path_separator, \'%\'))) ESCAPE \'|\' THEN SET v_path = REPLACE(v_path, @@global.slave_load_tmpdir, CONCAT(\'@@slave_load_tmpdir\', IF(SUBSTRING(@@global.slave_load_tmpdir, -1) = path_separator, path_separator, \'\'))); ELSEIF v_path LIKE CONCAT(@@global.innodb_data_home_dir, IF(SUBSTRING(@@global.innodb_data_home_dir, -1) = path_separator, \'%\', CONCAT(path_separator, \'%\'))) ESCAPE \'|\' THEN SET v_path = REPLACE(v_path, @@global.innodb_data_home_dir, CONCAT(\'@@innodb_data_home_dir\', IF(SUBSTRING(@@global.innodb_data_home_dir, -1) = path_separator, path_separator, \'\'))); ELSEIF v_path LIKE CONCAT(@@global.innodb_log_group_home_dir, IF(SUBSTRING(@@global.innodb_log_group_home_dir, -1) = path_separator, \'%\', CONCAT(path_separator, \'%\'))) ESCAPE \'|\' THEN SET v_path = REPLACE(v_path, @@global.innodb_log_group_home_dir, CONCAT(\'@@innodb_log_group_home_dir\', IF(SUBSTRING(@@global.innodb_log_group_home_dir, -1) = path_separator, path_separator, \'\'))); ELSEIF v_path LIKE CONCAT(v_undo_dir, IF(SUBSTRING(v_undo_dir, -1) = path_separator, \'%\', CONCAT(path_separator, \'%\'))) ESCAPE \'|\' THEN SET v_path = REPLACE(v_path, v_undo_dir, CONCAT(\'@@innodb_undo_directory\', IF(SUBSTRING(v_undo_dir, -1) = path_separator, path_separator, \'\'))); ELSEIF v_path LIKE CONCAT(@@global.basedir, IF(SUBSTRING(@@global.basedir, -1) = path_separator, \'%\', CONCAT(path_separator, \'%\'))) ESCAPE \'|\' THEN SET v_path = REPLACE(v_path, @@global.basedir, CONCAT(\'@@basedir\', IF(SUBSTRING(@@global.basedir, -1) = path_separator, path_separator, \'\'))); END IF;  RETURN v_path; END'),('sys','format_statement','FUNCTION','format_statement','SQL','NO_SQL','YES','INVOKER',_binary ' statement LONGTEXT ',_binary 'longtext CHARSET utf8',_binary 'BEGIN IF @sys.statement_truncate_len IS NULL THEN SET @sys.statement_truncate_len = sys_get_config(\'statement_truncate_len\', 64); END IF;  IF CHAR_LENGTH(statement) > @sys.statement_truncate_len THEN RETURN REPLACE(CONCAT(LEFT(statement, (@sys.statement_truncate_len/2)-2), \' ... \', RIGHT(statement, (@sys.statement_truncate_len/2)-2)), \'\\n\', \' \'); ELSE  RETURN REPLACE(statement, \'\\n\', \' \'); END IF; END','mysql.sys@localhost','2017-03-02 18:46:26','2017-03-02 18:46:26','','\n Description\n \n Formats a normalized statement, truncating it if it is > 64 characters long by default.\n \n To configure the length to truncate the statement to by default, update the `statement_truncate_len`\n variable with `sys_config` table to a different value. Alternatively, to change it just for just \n your particular session, use `SET @sys.statement_truncate_len := <some new value>`.\n \n Useful for printing statement related data from Performance Schema from \n the command line.\n \n Parameters\n \n statement (LONGTEXT): \n The statement to format.\n \n Returns\n \n LONGTEXT\n \n Example\n \n mysql> SELECT sys.format_statement(digest_text)\n ->   FROM performance_schema.events_statements_summary_by_digest\n ->  ORDER by sum_timer_wait DESC limit 5;\n +-------------------------------------------------------------------+\n | sys.format_statement(digest_text)                                 |\n +-------------------------------------------------------------------+\n | CREATE SQL SECURITY INVOKER VI ... KE ? AND `variable_value` > ?  |\n | CREATE SQL SECURITY INVOKER VI ... ait` IS NOT NULL , `esc` . ... |\n | CREATE SQL SECURITY INVOKER VI ... ait` IS NOT NULL , `sys` . ... |\n | CREATE SQL SECURITY INVOKER VI ...  , `compressed_size` ) ) DESC  |\n | CREATE SQL SECURITY INVOKER VI ... LIKE ? ORDER BY `timer_start`  |\n +-------------------------------------------------------------------+\n 5 rows in set (0.00 sec)\n ','utf8','utf8_general_ci','utf8_general_ci',_binary 'BEGIN IF @sys.statement_truncate_len IS NULL THEN SET @sys.statement_truncate_len = sys_get_config(\'statement_truncate_len\', 64); END IF;  IF CHAR_LENGTH(statement) > @sys.statement_truncate_len THEN RETURN REPLACE(CONCAT(LEFT(statement, (@sys.statement_truncate_len/2)-2), \' ... \', RIGHT(statement, (@sys.statement_truncate_len/2)-2)), \'\n\', \' \'); ELSE  RETURN REPLACE(statement, \'\n\', \' \'); END IF; END'),('sys','format_time','FUNCTION','format_time','SQL','NO_SQL','YES','INVOKER',_binary ' picoseconds TEXT ',_binary 'text CHARSET utf8',_binary 'BEGIN IF picoseconds IS NULL THEN RETURN NULL; ELSEIF picoseconds >= 604800000000000000 THEN RETURN CONCAT(ROUND(picoseconds / 604800000000000000, 2), \' w\'); ELSEIF picoseconds >= 86400000000000000 THEN RETURN CONCAT(ROUND(picoseconds / 86400000000000000, 2), \' d\'); ELSEIF picoseconds >= 3600000000000000 THEN RETURN CONCAT(ROUND(picoseconds / 3600000000000000, 2), \' h\'); ELSEIF picoseconds >= 60000000000000 THEN RETURN CONCAT(ROUND(picoseconds / 60000000000000, 2), \' m\'); ELSEIF picoseconds >= 1000000000000 THEN RETURN CONCAT(ROUND(picoseconds / 1000000000000, 2), \' s\'); ELSEIF picoseconds >= 1000000000 THEN RETURN CONCAT(ROUND(picoseconds / 1000000000, 2), \' ms\'); ELSEIF picoseconds >= 1000000 THEN RETURN CONCAT(ROUND(picoseconds / 1000000, 2), \' us\'); ELSEIF picoseconds >= 1000 THEN RETURN CONCAT(ROUND(picoseconds / 1000, 2), \' ns\'); ELSE RETURN CONCAT(picoseconds, \' ps\'); END IF; END','mysql.sys@localhost','2017-03-02 18:46:26','2017-03-02 18:46:26','','\n Description\n \n Takes a raw picoseconds value, and converts it to a human readable form.\n \n Picoseconds are the precision that all latency values are printed in \n within Performance Schema, however are not user friendly when wanting\n to scan output from the command line.\n \n Parameters\n \n picoseconds (TEXT): \n The raw picoseconds value to convert.\n \n Returns\n \n TEXT\n \n Example\n \n mysql> select format_time(342342342342345);\n +------------------------------+\n | format_time(342342342342345) |\n +------------------------------+\n | 00:05:42                     |\n +------------------------------+\n 1 row in set (0.00 sec)\n \n mysql> select format_time(342342342);\n +------------------------+\n | format_time(342342342) |\n +------------------------+\n | 342.34 us              |\n +------------------------+\n 1 row in set (0.00 sec)\n \n mysql> select format_time(34234);\n +--------------------+\n | format_time(34234) |\n +--------------------+\n | 34.23 ns           |\n +--------------------+\n 1 row in set (0.00 sec)\n ','utf8','utf8_general_ci','utf8_general_ci',_binary 'BEGIN IF picoseconds IS NULL THEN RETURN NULL; ELSEIF picoseconds >= 604800000000000000 THEN RETURN CONCAT(ROUND(picoseconds / 604800000000000000, 2), \' w\'); ELSEIF picoseconds >= 86400000000000000 THEN RETURN CONCAT(ROUND(picoseconds / 86400000000000000, 2), \' d\'); ELSEIF picoseconds >= 3600000000000000 THEN RETURN CONCAT(ROUND(picoseconds / 3600000000000000, 2), \' h\'); ELSEIF picoseconds >= 60000000000000 THEN RETURN CONCAT(ROUND(picoseconds / 60000000000000, 2), \' m\'); ELSEIF picoseconds >= 1000000000000 THEN RETURN CONCAT(ROUND(picoseconds / 1000000000000, 2), \' s\'); ELSEIF picoseconds >= 1000000000 THEN RETURN CONCAT(ROUND(picoseconds / 1000000000, 2), \' ms\'); ELSEIF picoseconds >= 1000000 THEN RETURN CONCAT(ROUND(picoseconds / 1000000, 2), \' us\'); ELSEIF picoseconds >= 1000 THEN RETURN CONCAT(ROUND(picoseconds / 1000, 2), \' ns\'); ELSE RETURN CONCAT(picoseconds, \' ps\'); END IF; END'),('sys','list_add','FUNCTION','list_add','SQL','CONTAINS_SQL','YES','INVOKER',_binary ' in_list TEXT, in_add_value TEXT ',_binary 'text CHARSET utf8',_binary 'BEGIN  IF (in_add_value IS NULL) THEN SIGNAL SQLSTATE \'02200\' SET MESSAGE_TEXT = \'Function sys.list_add: in_add_value input variable should not be NULL\', MYSQL_ERRNO = 1138; END IF;  IF (in_list IS NULL OR LENGTH(in_list) = 0) THEN RETURN in_add_value; END IF;  RETURN (SELECT CONCAT(TRIM(BOTH \',\' FROM TRIM(in_list)), \',\', in_add_value));  END','mysql.sys@localhost','2017-03-02 18:46:26','2017-03-02 18:46:26','','\n Description\n \n Takes a list, and a value to add to the list, and returns the resulting list.\n \n Useful for altering certain session variables, like sql_mode or optimizer_switch for instance.\n \n Parameters\n \n in_list (TEXT):\n The comma separated list to add a value to\n \n in_add_value (TEXT):\n The value to add to the input list\n \n Returns\n \n TEXT\n \n Example\n \n mysql> select @@sql_mode;\n +-----------------------------------------------------------------------------------+\n | @@sql_mode                                                                        |\n +-----------------------------------------------------------------------------------+\n | ONLY_FULL_GROUP_BY,STRICT_TRANS_TABLES,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION |\n +-----------------------------------------------------------------------------------+\n 1 row in set (0.00 sec)\n \n mysql> set sql_mode = sys.list_add(@@sql_mode, \'ANSI_QUOTES\');\n Query OK, 0 rows affected (0.06 sec)\n \n mysql> select @@sql_mode;\n +-----------------------------------------------------------------------------------------------+\n | @@sql_mode                                                                                    |\n +-----------------------------------------------------------------------------------------------+\n | ANSI_QUOTES,ONLY_FULL_GROUP_BY,STRICT_TRANS_TABLES,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION |\n +-----------------------------------------------------------------------------------------------+\n 1 row in set (0.00 sec)\n \n ','utf8','utf8_general_ci','utf8_general_ci',_binary 'BEGIN  IF (in_add_value IS NULL) THEN SIGNAL SQLSTATE \'02200\' SET MESSAGE_TEXT = \'Function sys.list_add: in_add_value input variable should not be NULL\', MYSQL_ERRNO = 1138; END IF;  IF (in_list IS NULL OR LENGTH(in_list) = 0) THEN RETURN in_add_value; END IF;  RETURN (SELECT CONCAT(TRIM(BOTH \',\' FROM TRIM(in_list)), \',\', in_add_value));  END'),('sys','list_drop','FUNCTION','list_drop','SQL','CONTAINS_SQL','YES','INVOKER',_binary ' in_list TEXT, in_drop_value TEXT ',_binary 'text CHARSET utf8',_binary 'BEGIN  IF (in_drop_value IS NULL) THEN SIGNAL SQLSTATE \'02200\' SET MESSAGE_TEXT = \'Function sys.list_drop: in_drop_value input variable should not be NULL\', MYSQL_ERRNO = 1138; END IF;  IF (in_list IS NULL OR LENGTH(in_list) = 0) THEN RETURN in_list; END IF;  RETURN (SELECT TRIM(BOTH \',\' FROM REPLACE(REPLACE(CONCAT(\',\', in_list), CONCAT(\',\', in_drop_value), \'\'), CONCAT(\', \', in_drop_value), \'\')));  END','mysql.sys@localhost','2017-03-02 18:46:26','2017-03-02 18:46:26','','\n Description\n \n Takes a list, and a value to attempt to remove from the list, and returns the resulting list.\n \n Useful for altering certain session variables, like sql_mode or optimizer_switch for instance.\n \n Parameters\n \n in_list (TEXT):\n The comma separated list to drop a value from\n \n in_drop_value (TEXT):\n The value to drop from the input list\n \n Returns\n \n TEXT\n \n Example\n \n mysql> select @@sql_mode;\n +-----------------------------------------------------------------------------------------------+\n | @@sql_mode                                                                                    |\n +-----------------------------------------------------------------------------------------------+\n | ANSI_QUOTES,ONLY_FULL_GROUP_BY,STRICT_TRANS_TABLES,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION |\n +-----------------------------------------------------------------------------------------------+\n 1 row in set (0.00 sec)\n \n mysql> set sql_mode = sys.list_drop(@@sql_mode, \'ONLY_FULL_GROUP_BY\');\n Query OK, 0 rows affected (0.03 sec)\n \n mysql> select @@sql_mode;\n +----------------------------------------------------------------------------+\n | @@sql_mode                                                                 |\n +----------------------------------------------------------------------------+\n | ANSI_QUOTES,STRICT_TRANS_TABLES,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION |\n +----------------------------------------------------------------------------+\n 1 row in set (0.00 sec)\n \n ','utf8','utf8_general_ci','utf8_general_ci',_binary 'BEGIN  IF (in_drop_value IS NULL) THEN SIGNAL SQLSTATE \'02200\' SET MESSAGE_TEXT = \'Function sys.list_drop: in_drop_value input variable should not be NULL\', MYSQL_ERRNO = 1138; END IF;  IF (in_list IS NULL OR LENGTH(in_list) = 0) THEN RETURN in_list; END IF;  RETURN (SELECT TRIM(BOTH \',\' FROM REPLACE(REPLACE(CONCAT(\',\', in_list), CONCAT(\',\', in_drop_value), \'\'), CONCAT(\', \', in_drop_value), \'\')));  END'),('sys','ps_is_account_enabled','FUNCTION','ps_is_account_enabled','SQL','READS_SQL_DATA','YES','INVOKER',_binary ' in_host VARCHAR(60),  in_user VARCHAR(32) ',_binary 'enum(\'YES\',\'NO\') CHARSET utf8',_binary 'BEGIN RETURN IF(EXISTS(SELECT 1 FROM performance_schema.setup_actors WHERE (`HOST` = \'%\' OR in_host LIKE `HOST`) AND (`USER` = \'%\' OR `USER` = in_user) AND (`ENABLED` = \'YES\') ), \'YES\', \'NO\' ); END','mysql.sys@localhost','2017-03-02 18:46:26','2017-03-02 18:46:26','','\n Description\n \n Determines whether instrumentation of an account is enabled \n within Performance Schema.\n \n Parameters\n \n in_host VARCHAR(60): \n The hostname of the account to check.\n in_user VARCHAR(32):\n The username of the account to check.\n \n Returns\n \n ENUM(\'YES\', \'NO\', \'PARTIAL\')\n \n Example\n \n mysql> SELECT sys.ps_is_account_enabled(\'localhost\', \'root\');\n +------------------------------------------------+\n | sys.ps_is_account_enabled(\'localhost\', \'root\') |\n +------------------------------------------------+\n | YES                                            |\n +------------------------------------------------+\n 1 row in set (0.01 sec)\n ','utf8','utf8_general_ci','utf8_general_ci',_binary 'BEGIN RETURN IF(EXISTS(SELECT 1 FROM performance_schema.setup_actors WHERE (`HOST` = \'%\' OR in_host LIKE `HOST`) AND (`USER` = \'%\' OR `USER` = in_user) AND (`ENABLED` = \'YES\') ), \'YES\', \'NO\' ); END'),('sys','ps_is_consumer_enabled','FUNCTION','ps_is_consumer_enabled','SQL','READS_SQL_DATA','YES','INVOKER',_binary ' in_consumer varchar(64) ',_binary 'enum(\'YES\',\'NO\') CHARSET utf8',_binary 'BEGIN RETURN ( SELECT (CASE WHEN c.NAME = \'global_instrumentation\' THEN c.ENABLED WHEN c.NAME = \'thread_instrumentation\' THEN IF(cg.ENABLED = \'YES\' AND c.ENABLED = \'YES\', \'YES\', \'NO\') WHEN c.NAME LIKE \'%\\_digest\'           THEN IF(cg.ENABLED = \'YES\' AND c.ENABLED = \'YES\', \'YES\', \'NO\') WHEN c.NAME LIKE \'%\\_current\'          THEN IF(cg.ENABLED = \'YES\' AND ct.ENABLED = \'YES\' AND c.ENABLED = \'YES\', \'YES\', \'NO\') ELSE IF(cg.ENABLED = \'YES\' AND ct.ENABLED = \'YES\' AND c.ENABLED = \'YES\' AND ( SELECT cc.ENABLED FROM performance_schema.setup_consumers cc WHERE NAME = CONCAT(SUBSTRING_INDEX(c.NAME, \'_\', 2), \'_current\') ) = \'YES\', \'YES\', \'NO\') END) AS IsEnabled FROM performance_schema.setup_consumers c INNER JOIN performance_schema.setup_consumers cg INNER JOIN performance_schema.setup_consumers ct WHERE cg.NAME       = \'global_instrumentation\' AND ct.NAME   = \'thread_instrumentation\' AND c.NAME    = in_consumer ); END','mysql.sys@localhost','2017-03-02 18:46:26','2017-03-02 18:46:26','','\n Description\n \n Determines whether a consumer is enabled (taking the consumer hierarchy into consideration)\n within the Performance Schema.\n \n Parameters\n \n in_consumer VARCHAR(64): \n The name of the consumer to check.\n \n Returns\n \n ENUM(\'YES\', \'NO\')\n \n Example\n \n mysql> SELECT sys.ps_is_consumer_enabled(\'events_stages_history\');\n +-----------------------------------------------------+\n | sys.ps_is_consumer_enabled(\'events_stages_history\') |\n +-----------------------------------------------------+\n | NO                                                  |\n +-----------------------------------------------------+\n 1 row in set (0.00 sec)\n ','utf8','utf8_general_ci','utf8_general_ci',_binary 'BEGIN RETURN ( SELECT (CASE WHEN c.NAME = \'global_instrumentation\' THEN c.ENABLED WHEN c.NAME = \'thread_instrumentation\' THEN IF(cg.ENABLED = \'YES\' AND c.ENABLED = \'YES\', \'YES\', \'NO\') WHEN c.NAME LIKE \'%\\_digest\'           THEN IF(cg.ENABLED = \'YES\' AND c.ENABLED = \'YES\', \'YES\', \'NO\') WHEN c.NAME LIKE \'%\\_current\'          THEN IF(cg.ENABLED = \'YES\' AND ct.ENABLED = \'YES\' AND c.ENABLED = \'YES\', \'YES\', \'NO\') ELSE IF(cg.ENABLED = \'YES\' AND ct.ENABLED = \'YES\' AND c.ENABLED = \'YES\' AND ( SELECT cc.ENABLED FROM performance_schema.setup_consumers cc WHERE NAME = CONCAT(SUBSTRING_INDEX(c.NAME, \'_\', 2), \'_current\') ) = \'YES\', \'YES\', \'NO\') END) AS IsEnabled FROM performance_schema.setup_consumers c INNER JOIN performance_schema.setup_consumers cg INNER JOIN performance_schema.setup_consumers ct WHERE cg.NAME       = \'global_instrumentation\' AND ct.NAME   = \'thread_instrumentation\' AND c.NAME    = in_consumer ); END'),('sys','ps_is_instrument_default_enabled','FUNCTION','ps_is_instrument_default_enabled','SQL','READS_SQL_DATA','YES','INVOKER',_binary ' in_instrument VARCHAR(128) ',_binary 'enum(\'YES\',\'NO\') CHARSET utf8',_binary 'BEGIN DECLARE v_enabled ENUM(\'YES\', \'NO\');  SET v_enabled = IF(in_instrument LIKE \'wait/io/file/%\' OR in_instrument LIKE \'wait/io/table/%\' OR in_instrument LIKE \'statement/%\' OR in_instrument LIKE \'memory/performance_schema/%\' OR in_instrument IN (\'wait/lock/table/sql/handler\', \'idle\')  OR in_instrument LIKE \'stage/innodb/%\' OR in_instrument = \'stage/sql/copy to tmp table\'  , \'YES\', \'NO\' );  RETURN v_enabled; END','mysql.sys@localhost','2017-03-02 18:46:26','2017-03-02 18:46:26','','\n Description\n \n Returns whether an instrument is enabled by default in this version of MySQL.\n \n Parameters\n \n in_instrument VARCHAR(128): \n The instrument to check.\n \n Returns\n \n ENUM(\'YES\', \'NO\')\n \n Example\n \n mysql> SELECT sys.ps_is_instrument_default_enabled(\'statement/sql/select\');\n +--------------------------------------------------------------+\n | sys.ps_is_instrument_default_enabled(\'statement/sql/select\') |\n +--------------------------------------------------------------+\n | YES                                                          |\n +--------------------------------------------------------------+\n 1 row in set (0.00 sec)\n ','utf8','utf8_general_ci','utf8_general_ci',_binary 'BEGIN DECLARE v_enabled ENUM(\'YES\', \'NO\');  SET v_enabled = IF(in_instrument LIKE \'wait/io/file/%\' OR in_instrument LIKE \'wait/io/table/%\' OR in_instrument LIKE \'statement/%\' OR in_instrument LIKE \'memory/performance_schema/%\' OR in_instrument IN (\'wait/lock/table/sql/handler\', \'idle\')  OR in_instrument LIKE \'stage/innodb/%\' OR in_instrument = \'stage/sql/copy to tmp table\'  , \'YES\', \'NO\' );  RETURN v_enabled; END'),('sys','ps_is_instrument_default_timed','FUNCTION','ps_is_instrument_default_timed','SQL','READS_SQL_DATA','YES','INVOKER',_binary ' in_instrument VARCHAR(128) ',_binary 'enum(\'YES\',\'NO\') CHARSET utf8',_binary 'BEGIN DECLARE v_timed ENUM(\'YES\', \'NO\');  SET v_timed = IF(in_instrument LIKE \'wait/io/file/%\' OR in_instrument LIKE \'wait/io/table/%\' OR in_instrument LIKE \'statement/%\' OR in_instrument IN (\'wait/lock/table/sql/handler\', \'idle\')  OR in_instrument LIKE \'stage/innodb/%\' OR in_instrument = \'stage/sql/copy to tmp table\'  , \'YES\', \'NO\' );  RETURN v_timed; END','mysql.sys@localhost','2017-03-02 18:46:26','2017-03-02 18:46:26','','\n Description\n \n Returns whether an instrument is timed by default in this version of MySQL.\n \n Parameters\n \n in_instrument VARCHAR(128): \n The instrument to check.\n \n Returns\n \n ENUM(\'YES\', \'NO\')\n \n Example\n \n mysql> SELECT sys.ps_is_instrument_default_timed(\'statement/sql/select\');\n +------------------------------------------------------------+\n | sys.ps_is_instrument_default_timed(\'statement/sql/select\') |\n +------------------------------------------------------------+\n | YES                                                        |\n +------------------------------------------------------------+\n 1 row in set (0.00 sec)\n ','utf8','utf8_general_ci','utf8_general_ci',_binary 'BEGIN DECLARE v_timed ENUM(\'YES\', \'NO\');  SET v_timed = IF(in_instrument LIKE \'wait/io/file/%\' OR in_instrument LIKE \'wait/io/table/%\' OR in_instrument LIKE \'statement/%\' OR in_instrument IN (\'wait/lock/table/sql/handler\', \'idle\')  OR in_instrument LIKE \'stage/innodb/%\' OR in_instrument = \'stage/sql/copy to tmp table\'  , \'YES\', \'NO\' );  RETURN v_timed; END'),('sys','ps_is_thread_instrumented','FUNCTION','ps_is_thread_instrumented','SQL','READS_SQL_DATA','NO','INVOKER',_binary ' in_connection_id BIGINT UNSIGNED ',_binary 'enum(\'YES\',\'NO\',\'UNKNOWN\') CHARSET utf8',_binary 'BEGIN DECLARE v_enabled ENUM(\'YES\', \'NO\', \'UNKNOWN\');  IF (in_connection_id IS NULL) THEN RETURN NULL; END IF;  SELECT INSTRUMENTED INTO v_enabled FROM performance_schema.threads  WHERE PROCESSLIST_ID = in_connection_id;  IF (v_enabled IS NULL) THEN RETURN \'UNKNOWN\'; ELSE RETURN v_enabled; END IF; END','mysql.sys@localhost','2017-03-02 18:46:26','2017-03-02 18:46:26','','\n Description\n \n Checks whether the provided connection id is instrumented within Performance Schema.\n \n Parameters\n \n in_connection_id (BIGINT UNSIGNED):\n The id of the connection to check.\n \n Returns\n \n ENUM(\'YES\', \'NO\', \'UNKNOWN\')\n \n Example\n \n mysql> SELECT sys.ps_is_thread_instrumented(CONNECTION_ID());\n +------------------------------------------------+\n | sys.ps_is_thread_instrumented(CONNECTION_ID()) |\n +------------------------------------------------+\n | YES                                            |\n +------------------------------------------------+\n ','utf8','utf8_general_ci','utf8_general_ci',_binary 'BEGIN DECLARE v_enabled ENUM(\'YES\', \'NO\', \'UNKNOWN\');  IF (in_connection_id IS NULL) THEN RETURN NULL; END IF;  SELECT INSTRUMENTED INTO v_enabled FROM performance_schema.threads  WHERE PROCESSLIST_ID = in_connection_id;  IF (v_enabled IS NULL) THEN RETURN \'UNKNOWN\'; ELSE RETURN v_enabled; END IF; END'),('sys','ps_thread_id','FUNCTION','ps_thread_id','SQL','READS_SQL_DATA','NO','INVOKER',_binary ' in_connection_id BIGINT UNSIGNED ',_binary 'bigint(20) unsigned',_binary 'BEGIN RETURN (SELECT THREAD_ID FROM `performance_schema`.`threads` WHERE PROCESSLIST_ID = IFNULL(in_connection_id, CONNECTION_ID()) ); END','mysql.sys@localhost','2017-03-02 18:46:26','2017-03-02 18:46:26','','\n Description\n \n Return the Performance Schema THREAD_ID for the specified connection ID.\n \n Parameters\n \n in_connection_id (BIGINT UNSIGNED):\n The id of the connection to return the thread id for. If NULL, the current\n connection thread id is returned.\n \n Example\n \n mysql> SELECT sys.ps_thread_id(79);\n +----------------------+\n | sys.ps_thread_id(79) |\n +----------------------+\n |                   98 |\n +----------------------+\n 1 row in set (0.00 sec)\n \n mysql> SELECT sys.ps_thread_id(CONNECTION_ID());\n +-----------------------------------+\n | sys.ps_thread_id(CONNECTION_ID()) |\n +-----------------------------------+\n |                                98 |\n +-----------------------------------+\n 1 row in set (0.00 sec)\n ','utf8','utf8_general_ci','utf8_general_ci',_binary 'BEGIN RETURN (SELECT THREAD_ID FROM `performance_schema`.`threads` WHERE PROCESSLIST_ID = IFNULL(in_connection_id, CONNECTION_ID()) ); END'),('sys','ps_thread_account','FUNCTION','ps_thread_account','SQL','READS_SQL_DATA','NO','INVOKER',_binary ' in_thread_id BIGINT UNSIGNED ',_binary 'text CHARSET utf8',_binary 'BEGIN RETURN (SELECT IF( type = \'FOREGROUND\', CONCAT(processlist_user, \'@\', processlist_host), type ) AS account FROM `performance_schema`.`threads` WHERE thread_id = in_thread_id); END','mysql.sys@localhost','2017-03-02 18:46:26','2017-03-02 18:46:26','','\n Description\n \n Return the user@host account for the given Performance Schema thread id.\n \n Parameters\n \n in_thread_id (BIGINT UNSIGNED):\n The id of the thread to return the account for.\n \n Example\n \n mysql> select thread_id, processlist_user, processlist_host from performance_schema.threads where type = \'foreground\';\n +-----------+------------------+------------------+\n | thread_id | processlist_user | processlist_host |\n +-----------+------------------+------------------+\n |        23 | NULL             | NULL             |\n |        30 | root             | localhost        |\n |        31 | msandbox         | localhost        |\n |        32 | msandbox         | localhost        |\n +-----------+------------------+------------------+\n 4 rows in set (0.00 sec)\n \n mysql> select sys.ps_thread_account(31);\n +---------------------------+\n | sys.ps_thread_account(31) |\n +---------------------------+\n | msandbox@localhost        |\n +---------------------------+\n 1 row in set (0.00 sec)\n ','utf8','utf8_general_ci','utf8_general_ci',_binary 'BEGIN RETURN (SELECT IF( type = \'FOREGROUND\', CONCAT(processlist_user, \'@\', processlist_host), type ) AS account FROM `performance_schema`.`threads` WHERE thread_id = in_thread_id); END'),('sys','ps_thread_stack','FUNCTION','ps_thread_stack','SQL','READS_SQL_DATA','NO','INVOKER',_binary ' thd_id BIGINT UNSIGNED, debug BOOLEAN ',_binary 'longtext CHARSET latin1',_binary 'BEGIN  DECLARE json_objects LONGTEXT;   UPDATE performance_schema.threads SET instrumented = \'NO\' WHERE processlist_id = CONNECTION_ID();   SET SESSION group_concat_max_len=@@global.max_allowed_packet;  SELECT GROUP_CONCAT(CONCAT( \'{\' , CONCAT_WS( \', \' , CONCAT(\'\"nesting_event_id\": \"\', IF(nesting_event_id IS NULL, \'0\', nesting_event_id), \'\"\') , CONCAT(\'\"event_id\": \"\', event_id, \'\"\') , CONCAT( \'\"timer_wait\": \', ROUND(timer_wait/1000000, 2))   , CONCAT( \'\"event_info\": \"\' , CASE WHEN event_name NOT LIKE \'wait/io%\' THEN REPLACE(SUBSTRING_INDEX(event_name, \'/\', -2), \'\\\\\', \'\\\\\\\\\') WHEN event_name NOT LIKE \'wait/io/file%\' OR event_name NOT LIKE \'wait/io/socket%\' THEN REPLACE(SUBSTRING_INDEX(event_name, \'/\', -4), \'\\\\\', \'\\\\\\\\\') ELSE event_name END , \'\"\' ) , CONCAT( \'\"wait_info\": \"\', IFNULL(wait_info, \'\'), \'\"\') , CONCAT( \'\"source\": \"\', IF(true AND event_name LIKE \'wait%\', IFNULL(wait_info, \'\'), \'\'), \'\"\') , CASE  WHEN event_name LIKE \'wait/io/file%\'      THEN \'\"event_type\": \"io/file\"\' WHEN event_name LIKE \'wait/io/table%\'     THEN \'\"event_type\": \"io/table\"\' WHEN event_name LIKE \'wait/io/socket%\'    THEN \'\"event_type\": \"io/socket\"\' WHEN event_name LIKE \'wait/synch/mutex%\'  THEN \'\"event_type\": \"synch/mutex\"\' WHEN event_name LIKE \'wait/synch/cond%\'   THEN \'\"event_type\": \"synch/cond\"\' WHEN event_name LIKE \'wait/synch/rwlock%\' THEN \'\"event_type\": \"synch/rwlock\"\' WHEN event_name LIKE \'wait/lock%\'         THEN \'\"event_type\": \"lock\"\' WHEN event_name LIKE \'statement/%\'        THEN \'\"event_type\": \"stmt\"\' WHEN event_name LIKE \'stage/%\'            THEN \'\"event_type\": \"stage\"\' WHEN event_name LIKE \'%idle%\'             THEN \'\"event_type\": \"idle\"\' ELSE \'\'  END                    ) , \'}\' ) ORDER BY event_id ASC SEPARATOR \',\') event INTO json_objects FROM (  (SELECT thread_id, event_id, event_name, timer_wait, timer_start, nesting_event_id,  CONCAT(sql_text, \'\\\\n\', \'errors: \', errors, \'\\\\n\', \'warnings: \', warnings, \'\\\\n\', \'lock time: \', ROUND(lock_time/1000000, 2),\'us\\\\n\', \'rows affected: \', rows_affected, \'\\\\n\', \'rows sent: \', rows_sent, \'\\\\n\', \'rows examined: \', rows_examined, \'\\\\n\', \'tmp tables: \', created_tmp_tables, \'\\\\n\', \'tmp disk tables: \', created_tmp_disk_tables, \'\\\\n\', \'select scan: \', select_scan, \'\\\\n\', \'select full join: \', select_full_join, \'\\\\n\', \'select full range join: \', select_full_range_join, \'\\\\n\', \'select range: \', select_range, \'\\\\n\', \'select range check: \', select_range_check, \'\\\\n\',  \'sort merge passes: \', sort_merge_passes, \'\\\\n\', \'sort rows: \', sort_rows, \'\\\\n\', \'sort range: \', sort_range, \'\\\\n\', \'sort scan: \', sort_scan, \'\\\\n\', \'no index used: \', IF(no_index_used, \'TRUE\', \'FALSE\'), \'\\\\n\', \'no good index used: \', IF(no_good_index_used, \'TRUE\', \'FALSE\'), \'\\\\n\' ) AS wait_info FROM performance_schema.events_statements_history_long WHERE thread_id = thd_id) UNION  (SELECT thread_id, event_id, event_name, timer_wait, timer_start, nesting_event_id, null AS wait_info FROM performance_schema.events_stages_history_long WHERE thread_id = thd_id)  UNION  (SELECT thread_id, event_id,  CONCAT(event_name ,  IF(event_name NOT LIKE \'wait/synch/mutex%\', IFNULL(CONCAT(\' - \', operation), \'\'), \'\'),  IF(number_of_bytes IS NOT NULL, CONCAT(\' \', number_of_bytes, \' bytes\'), \'\'), IF(event_name LIKE \'wait/io/file%\', \'\\\\n\', \'\'), IF(object_schema IS NOT NULL, CONCAT(\'\\\\nObject: \', object_schema, \'.\'), \'\'),  IF(object_name IS NOT NULL,  IF (event_name LIKE \'wait/io/socket%\', CONCAT(IF (object_name LIKE \':0%\', @@socket, object_name)), object_name), \'\'),  IF(index_name IS NOT NULL, CONCAT(\' Index: \', index_name), \'\'), \'\\\\n\' ) AS event_name, timer_wait, timer_start, nesting_event_id, source AS wait_info FROM performance_schema.events_waits_history_long WHERE thread_id = thd_id)) events  ORDER BY event_id;  RETURN CONCAT(\'{\',  CONCAT_WS(\',\',  \'\"rankdir\": \"LR\"\', \'\"nodesep\": \"0.10\"\', CONCAT(\'\"stack_created\": \"\', NOW(), \'\"\'), CONCAT(\'\"mysql_version\": \"\', VERSION(), \'\"\'), CONCAT(\'\"mysql_user\": \"\', CURRENT_USER(), \'\"\'), CONCAT(\'\"events\": [\', IFNULL(json_objects,\'\'), \']\') ), \'}\');  END','mysql.sys@localhost','2017-03-02 18:46:26','2017-03-02 18:46:26','','\n Description\n \n Outputs a JSON formatted stack of all statements, stages and events\n within Performance Schema for the specified thread.\n \n Parameters\n \n thd_id (BIGINT UNSIGNED):\n The id of the thread to trace. This should match the thread_id\n column from the performance_schema.threads table.\n in_verbose (BOOLEAN):\n Include file:lineno information in the events.\n \n Example\n \n (line separation added for output)\n \n mysql> SELECT sys.ps_thread_stack(37, FALSE) AS thread_stack\\G\n *************************** 1. row ***************************\n thread_stack: {\"rankdir\": \"LR\",\"nodesep\": \"0.10\",\"stack_created\": \"2014-02-19 13:39:03\",\n \"mysql_version\": \"5.7.3-m13\",\"mysql_user\": \"root@localhost\",\"events\": \n [{\"nesting_event_id\": \"0\", \"event_id\": \"10\", \"timer_wait\": 256.35, \"event_info\": \n \"sql/select\", \"wait_info\": \"select @@version_comment limit 1\\nerrors: 0\\nwarnings: 0\\nlock time:\n ...\n ','utf8','utf8_general_ci','utf8_general_ci',_binary 'BEGIN  DECLARE json_objects LONGTEXT;   UPDATE performance_schema.threads SET instrumented = \'NO\' WHERE processlist_id = CONNECTION_ID();   SET SESSION group_concat_max_len=@@global.max_allowed_packet;  SELECT GROUP_CONCAT(CONCAT( \'{\' , CONCAT_WS( \', \' , CONCAT(\'\"nesting_event_id\": \"\', IF(nesting_event_id IS NULL, \'0\', nesting_event_id), \'\"\') , CONCAT(\'\"event_id\": \"\', event_id, \'\"\') , CONCAT( \'\"timer_wait\": \', ROUND(timer_wait/1000000, 2))   , CONCAT( \'\"event_info\": \"\' , CASE WHEN event_name NOT LIKE \'wait/io%\' THEN REPLACE(SUBSTRING_INDEX(event_name, \'/\', -2), \'\\\', \'\\\\\') WHEN event_name NOT LIKE \'wait/io/file%\' OR event_name NOT LIKE \'wait/io/socket%\' THEN REPLACE(SUBSTRING_INDEX(event_name, \'/\', -4), \'\\\', \'\\\\\') ELSE event_name END , \'\"\' ) , CONCAT( \'\"wait_info\": \"\', IFNULL(wait_info, \'\'), \'\"\') , CONCAT( \'\"source\": \"\', IF(true AND event_name LIKE \'wait%\', IFNULL(wait_info, \'\'), \'\'), \'\"\') , CASE  WHEN event_name LIKE \'wait/io/file%\'      THEN \'\"event_type\": \"io/file\"\' WHEN event_name LIKE \'wait/io/table%\'     THEN \'\"event_type\": \"io/table\"\' WHEN event_name LIKE \'wait/io/socket%\'    THEN \'\"event_type\": \"io/socket\"\' WHEN event_name LIKE \'wait/synch/mutex%\'  THEN \'\"event_type\": \"synch/mutex\"\' WHEN event_name LIKE \'wait/synch/cond%\'   THEN \'\"event_type\": \"synch/cond\"\' WHEN event_name LIKE \'wait/synch/rwlock%\' THEN \'\"event_type\": \"synch/rwlock\"\' WHEN event_name LIKE \'wait/lock%\'         THEN \'\"event_type\": \"lock\"\' WHEN event_name LIKE \'statement/%\'        THEN \'\"event_type\": \"stmt\"\' WHEN event_name LIKE \'stage/%\'            THEN \'\"event_type\": \"stage\"\' WHEN event_name LIKE \'%idle%\'             THEN \'\"event_type\": \"idle\"\' ELSE \'\'  END                    ) , \'}\' ) ORDER BY event_id ASC SEPARATOR \',\') event INTO json_objects FROM (  (SELECT thread_id, event_id, event_name, timer_wait, timer_start, nesting_event_id,  CONCAT(sql_text, \'\\n\', \'errors: \', errors, \'\\n\', \'warnings: \', warnings, \'\\n\', \'lock time: \', ROUND(lock_time/1000000, 2),\'us\\n\', \'rows affected: \', rows_affected, \'\\n\', \'rows sent: \', rows_sent, \'\\n\', \'rows examined: \', rows_examined, \'\\n\', \'tmp tables: \', created_tmp_tables, \'\\n\', \'tmp disk tables: \', created_tmp_disk_tables, \'\\n\', \'select scan: \', select_scan, \'\\n\', \'select full join: \', select_full_join, \'\\n\', \'select full range join: \', select_full_range_join, \'\\n\', \'select range: \', select_range, \'\\n\', \'select range check: \', select_range_check, \'\\n\',  \'sort merge passes: \', sort_merge_passes, \'\\n\', \'sort rows: \', sort_rows, \'\\n\', \'sort range: \', sort_range, \'\\n\', \'sort scan: \', sort_scan, \'\\n\', \'no index used: \', IF(no_index_used, \'TRUE\', \'FALSE\'), \'\\n\', \'no good index used: \', IF(no_good_index_used, \'TRUE\', \'FALSE\'), \'\\n\' ) AS wait_info FROM performance_schema.events_statements_history_long WHERE thread_id = thd_id) UNION  (SELECT thread_id, event_id, event_name, timer_wait, timer_start, nesting_event_id, null AS wait_info FROM performance_schema.events_stages_history_long WHERE thread_id = thd_id)  UNION  (SELECT thread_id, event_id,  CONCAT(event_name ,  IF(event_name NOT LIKE \'wait/synch/mutex%\', IFNULL(CONCAT(\' - \', operation), \'\'), \'\'),  IF(number_of_bytes IS NOT NULL, CONCAT(\' \', number_of_bytes, \' bytes\'), \'\'), IF(event_name LIKE \'wait/io/file%\', \'\\n\', \'\'), IF(object_schema IS NOT NULL, CONCAT(\'\\nObject: \', object_schema, \'.\'), \'\'),  IF(object_name IS NOT NULL,  IF (event_name LIKE \'wait/io/socket%\', CONCAT(IF (object_name LIKE \':0%\', @@socket, object_name)), object_name), \'\'),  IF(index_name IS NOT NULL, CONCAT(\' Index: \', index_name), \'\'), \'\\n\' ) AS event_name, timer_wait, timer_start, nesting_event_id, source AS wait_info FROM performance_schema.events_waits_history_long WHERE thread_id = thd_id)) events  ORDER BY event_id;  RETURN CONCAT(\'{\',  CONCAT_WS(\',\',  \'\"rankdir\": \"LR\"\', \'\"nodesep\": \"0.10\"\', CONCAT(\'\"stack_created\": \"\', NOW(), \'\"\'), CONCAT(\'\"mysql_version\": \"\', VERSION(), \'\"\'), CONCAT(\'\"mysql_user\": \"\', CURRENT_USER(), \'\"\'), CONCAT(\'\"events\": [\', IFNULL(json_objects,\'\'), \']\') ), \'}\');  END'),('sys','ps_thread_trx_info','FUNCTION','ps_thread_trx_info','SQL','READS_SQL_DATA','NO','INVOKER',_binary ' in_thread_id BIGINT UNSIGNED ',_binary 'longtext CHARSET utf8',_binary 'BEGIN DECLARE v_output LONGTEXT DEFAULT \'{}\'; DECLARE v_msg_text TEXT DEFAULT \'\'; DECLARE v_signal_msg TEXT DEFAULT \'\'; DECLARE v_mysql_errno INT; DECLARE v_max_output_len BIGINT; DECLARE EXIT HANDLER FOR SQLWARNING, SQLEXCEPTION BEGIN GET DIAGNOSTICS CONDITION 1 v_msg_text = MESSAGE_TEXT, v_mysql_errno = MYSQL_ERRNO;  IF v_mysql_errno = 1260 THEN SET v_signal_msg = CONCAT(\'{ \"error\": \"Trx info truncated: \', v_msg_text, \'\" }\'); ELSE SET v_signal_msg = CONCAT(\'{ \"error\": \"\', v_msg_text, \'\" }\'); END IF;  RETURN v_signal_msg; END;  IF (@sys.ps_thread_trx_info.max_length IS NULL) THEN SET @sys.ps_thread_trx_info.max_length = sys.sys_get_config(\'ps_thread_trx_info.max_length\', 65535); END IF;  IF (@sys.ps_thread_trx_info.max_length != @@session.group_concat_max_len) THEN SET @old_group_concat_max_len = @@session.group_concat_max_len; SET v_max_output_len = (@sys.ps_thread_trx_info.max_length - 5); SET SESSION group_concat_max_len = v_max_output_len; END IF;  SET v_output = ( SELECT CONCAT(\'[\', IFNULL(GROUP_CONCAT(trx_info ORDER BY event_id), \'\'), \'\\n]\') AS trx_info FROM (SELECT trxi.thread_id,  trxi.event_id, GROUP_CONCAT( IFNULL( CONCAT(\'\\n  {\\n\', \'    \"time\": \"\', IFNULL(sys.format_time(trxi.timer_wait), \'\'), \'\",\\n\', \'    \"state\": \"\', IFNULL(trxi.state, \'\'), \'\",\\n\', \'    \"mode\": \"\', IFNULL(trxi.access_mode, \'\'), \'\",\\n\', \'    \"autocommitted\": \"\', IFNULL(trxi.autocommit, \'\'), \'\",\\n\', \'    \"gtid\": \"\', IFNULL(trxi.gtid, \'\'), \'\",\\n\', \'    \"isolation\": \"\', IFNULL(trxi.isolation_level, \'\'), \'\",\\n\', \'    \"statements_executed\": [\', IFNULL(s.stmts, \'\'), IF(s.stmts IS NULL, \' ]\\n\', \'\\n    ]\\n\'), \'  }\' ),  \'\')  ORDER BY event_id) AS trx_info  FROM ( (SELECT thread_id, event_id, timer_wait, state,access_mode, autocommit, gtid, isolation_level FROM performance_schema.events_transactions_current WHERE thread_id = in_thread_id AND end_event_id IS NULL) UNION (SELECT thread_id, event_id, timer_wait, state,access_mode, autocommit, gtid, isolation_level FROM performance_schema.events_transactions_history WHERE thread_id = in_thread_id) ) AS trxi LEFT JOIN (SELECT thread_id, nesting_event_id, GROUP_CONCAT( IFNULL( CONCAT(\'\\n      {\\n\', \'        \"sql_text\": \"\', IFNULL(sys.format_statement(REPLACE(sql_text, \'\\\\\', \'\\\\\\\\\')), \'\'), \'\",\\n\', \'        \"time\": \"\', IFNULL(sys.format_time(timer_wait), \'\'), \'\",\\n\', \'        \"schema\": \"\', IFNULL(current_schema, \'\'), \'\",\\n\', \'        \"rows_examined\": \', IFNULL(rows_examined, \'\'), \',\\n\', \'        \"rows_affected\": \', IFNULL(rows_affected, \'\'), \',\\n\', \'        \"rows_sent\": \', IFNULL(rows_sent, \'\'), \',\\n\', \'        \"tmp_tables\": \', IFNULL(created_tmp_tables, \'\'), \',\\n\', \'        \"tmp_disk_tables\": \', IFNULL(created_tmp_disk_tables, \'\'), \',\\n\', \'        \"sort_rows\": \', IFNULL(sort_rows, \'\'), \',\\n\', \'        \"sort_merge_passes\": \', IFNULL(sort_merge_passes, \'\'), \'\\n\', \'      }\'), \'\') ORDER BY event_id) AS stmts FROM performance_schema.events_statements_history WHERE sql_text IS NOT NULL AND thread_id = in_thread_id GROUP BY thread_id, nesting_event_id ) AS s  ON trxi.thread_id = s.thread_id  AND trxi.event_id = s.nesting_event_id WHERE trxi.thread_id = in_thread_id GROUP BY trxi.thread_id, trxi.event_id ) trxs GROUP BY thread_id );  IF (@old_group_concat_max_len IS NOT NULL) THEN SET SESSION group_concat_max_len = @old_group_concat_max_len; END IF;  RETURN v_output; END','mysql.sys@localhost','2017-03-02 18:46:26','2017-03-02 18:46:26','','\n Description\n \n Returns a JSON object with info on the given threads current transaction, \n and the statements it has already executed, derived from the\n performance_schema.events_transactions_current and\n performance_schema.events_statements_history tables (so the consumers \n for these also have to be enabled within Performance Schema to get full\n data in the object).\n \n When the output exceeds the default truncation length (65535), a JSON error\n object is returned, such as:\n \n { \"error\": \"Trx info truncated: Row 6 was cut by GROUP_CONCAT()\" }\n \n Similar error objects are returned for other warnings/and exceptions raised\n when calling the function.\n \n The max length of the output of this function can be controlled with the\n ps_thread_trx_info.max_length variable set via sys_config, or the\n @sys.ps_thread_trx_info.max_length user variable, as appropriate.\n \n Parameters\n \n in_thread_id (BIGINT UNSIGNED):\n The id of the thread to return the transaction info for.\n \n Example\n \n SELECT sys.ps_thread_trx_info(48)\\G\n *************************** 1. row ***************************\n sys.ps_thread_trx_info(48): [\n {\n \"time\": \"790.70 us\",\n \"state\": \"COMMITTED\",\n \"mode\": \"READ WRITE\",\n \"autocommitted\": \"NO\",\n \"gtid\": \"AUTOMATIC\",\n \"isolation\": \"REPEATABLE READ\",\n \"statements_executed\": [\n {\n \"sql_text\": \"INSERT INTO info VALUES (1, \'foo\')\",\n \"time\": \"471.02 us\",\n \"schema\": \"trx\",\n \"rows_examined\": 0,\n \"rows_affected\": 1,\n \"rows_sent\": 0,\n \"tmp_tables\": 0,\n \"tmp_disk_tables\": 0,\n \"sort_rows\": 0,\n \"sort_merge_passes\": 0\n },\n {\n \"sql_text\": \"COMMIT\",\n \"time\": \"254.42 us\",\n \"schema\": \"trx\",\n \"rows_examined\": 0,\n \"rows_affected\": 0,\n \"rows_sent\": 0,\n \"tmp_tables\": 0,\n \"tmp_disk_tables\": 0,\n \"sort_rows\": 0,\n \"sort_merge_passes\": 0\n }\n ]\n },\n {\n \"time\": \"426.20 us\",\n \"state\": \"COMMITTED\",\n \"mode\": \"READ WRITE\",\n \"autocommitted\": \"NO\",\n \"gtid\": \"AUTOMATIC\",\n \"isolation\": \"REPEATABLE READ\",\n \"statements_executed\": [\n {\n \"sql_text\": \"INSERT INTO info VALUES (2, \'bar\')\",\n \"time\": \"107.33 us\",\n \"schema\": \"trx\",\n \"rows_examined\": 0,\n \"rows_affected\": 1,\n \"rows_sent\": 0,\n \"tmp_tables\": 0,\n \"tmp_disk_tables\": 0,\n \"sort_rows\": 0,\n \"sort_merge_passes\": 0\n },\n {\n \"sql_text\": \"COMMIT\",\n \"time\": \"213.23 us\",\n \"schema\": \"trx\",\n \"rows_examined\": 0,\n \"rows_affected\": 0,\n \"rows_sent\": 0,\n \"tmp_tables\": 0,\n \"tmp_disk_tables\": 0,\n \"sort_rows\": 0,\n \"sort_merge_passes\": 0\n }\n ]\n }\n ]\n 1 row in set (0.03 sec)\n ','utf8','utf8_general_ci','utf8_general_ci',_binary 'BEGIN DECLARE v_output LONGTEXT DEFAULT \'{}\'; DECLARE v_msg_text TEXT DEFAULT \'\'; DECLARE v_signal_msg TEXT DEFAULT \'\'; DECLARE v_mysql_errno INT; DECLARE v_max_output_len BIGINT; DECLARE EXIT HANDLER FOR SQLWARNING, SQLEXCEPTION BEGIN GET DIAGNOSTICS CONDITION 1 v_msg_text = MESSAGE_TEXT, v_mysql_errno = MYSQL_ERRNO;  IF v_mysql_errno = 1260 THEN SET v_signal_msg = CONCAT(\'{ \"error\": \"Trx info truncated: \', v_msg_text, \'\" }\'); ELSE SET v_signal_msg = CONCAT(\'{ \"error\": \"\', v_msg_text, \'\" }\'); END IF;  RETURN v_signal_msg; END;  IF (@sys.ps_thread_trx_info.max_length IS NULL) THEN SET @sys.ps_thread_trx_info.max_length = sys.sys_get_config(\'ps_thread_trx_info.max_length\', 65535); END IF;  IF (@sys.ps_thread_trx_info.max_length != @@session.group_concat_max_len) THEN SET @old_group_concat_max_len = @@session.group_concat_max_len; SET v_max_output_len = (@sys.ps_thread_trx_info.max_length - 5); SET SESSION group_concat_max_len = v_max_output_len; END IF;  SET v_output = ( SELECT CONCAT(\'[\', IFNULL(GROUP_CONCAT(trx_info ORDER BY event_id), \'\'), \'\n]\') AS trx_info FROM (SELECT trxi.thread_id,  trxi.event_id, GROUP_CONCAT( IFNULL( CONCAT(\'\n  {\n\', \'    \"time\": \"\', IFNULL(sys.format_time(trxi.timer_wait), \'\'), \'\",\n\', \'    \"state\": \"\', IFNULL(trxi.state, \'\'), \'\",\n\', \'    \"mode\": \"\', IFNULL(trxi.access_mode, \'\'), \'\",\n\', \'    \"autocommitted\": \"\', IFNULL(trxi.autocommit, \'\'), \'\",\n\', \'    \"gtid\": \"\', IFNULL(trxi.gtid, \'\'), \'\",\n\', \'    \"isolation\": \"\', IFNULL(trxi.isolation_level, \'\'), \'\",\n\', \'    \"statements_executed\": [\', IFNULL(s.stmts, \'\'), IF(s.stmts IS NULL, \' ]\n\', \'\n    ]\n\'), \'  }\' ),  \'\')  ORDER BY event_id) AS trx_info  FROM ( (SELECT thread_id, event_id, timer_wait, state,access_mode, autocommit, gtid, isolation_level FROM performance_schema.events_transactions_current WHERE thread_id = in_thread_id AND end_event_id IS NULL) UNION (SELECT thread_id, event_id, timer_wait, state,access_mode, autocommit, gtid, isolation_level FROM performance_schema.events_transactions_history WHERE thread_id = in_thread_id) ) AS trxi LEFT JOIN (SELECT thread_id, nesting_event_id, GROUP_CONCAT( IFNULL( CONCAT(\'\n      {\n\', \'        \"sql_text\": \"\', IFNULL(sys.format_statement(REPLACE(sql_text, \'\\\', \'\\\\\')), \'\'), \'\",\n\', \'        \"time\": \"\', IFNULL(sys.format_time(timer_wait), \'\'), \'\",\n\', \'        \"schema\": \"\', IFNULL(current_schema, \'\'), \'\",\n\', \'        \"rows_examined\": \', IFNULL(rows_examined, \'\'), \',\n\', \'        \"rows_affected\": \', IFNULL(rows_affected, \'\'), \',\n\', \'        \"rows_sent\": \', IFNULL(rows_sent, \'\'), \',\n\', \'        \"tmp_tables\": \', IFNULL(created_tmp_tables, \'\'), \',\n\', \'        \"tmp_disk_tables\": \', IFNULL(created_tmp_disk_tables, \'\'), \',\n\', \'        \"sort_rows\": \', IFNULL(sort_rows, \'\'), \',\n\', \'        \"sort_merge_passes\": \', IFNULL(sort_merge_passes, \'\'), \'\n\', \'      }\'), \'\') ORDER BY event_id) AS stmts FROM performance_schema.events_statements_history WHERE sql_text IS NOT NULL AND thread_id = in_thread_id GROUP BY thread_id, nesting_event_id ) AS s  ON trxi.thread_id = s.thread_id  AND trxi.event_id = s.nesting_event_id WHERE trxi.thread_id = in_thread_id GROUP BY trxi.thread_id, trxi.event_id ) trxs GROUP BY thread_id );  IF (@old_group_concat_max_len IS NOT NULL) THEN SET SESSION group_concat_max_len = @old_group_concat_max_len; END IF;  RETURN v_output; END'),('sys','quote_identifier','FUNCTION','quote_identifier','SQL','NO_SQL','YES','INVOKER',_binary 'in_identifier TEXT',_binary 'text CHARSET utf8',_binary 'BEGIN RETURN CONCAT(\'`\', REPLACE(in_identifier, \'`\', \'``\'), \'`\'); END','mysql.sys@localhost','2017-03-02 18:46:26','2017-03-02 18:46:26','','\n Description\n \n Takes an unquoted identifier (schema name, table name, etc.) and\n returns the identifier quoted with backticks.\n \n Parameters\n \n in_identifier (TEXT):\n The identifier to quote.\n \n Returns\n \n TEXT\n \n Example\n \n mysql> SELECT sys.quote_identifier(\'my_identifier\') AS Identifier;\n +-----------------+\n | Identifier      |\n +-----------------+\n | `my_identifier` |\n +-----------------+\n 1 row in set (0.00 sec)\n \n mysql> SELECT sys.quote_identifier(\'my`idenfier\') AS Identifier;\n +----------------+\n | Identifier     |\n +----------------+\n | `my``idenfier` |\n +----------------+\n 1 row in set (0.00 sec)\n ','utf8','utf8_general_ci','utf8_general_ci',_binary 'BEGIN RETURN CONCAT(\'`\', REPLACE(in_identifier, \'`\', \'``\'), \'`\'); END'),('sys','sys_get_config','FUNCTION','sys_get_config','SQL','READS_SQL_DATA','YES','INVOKER',_binary ' in_variable_name VARCHAR(128), in_default_value VARCHAR(128) ',_binary 'varchar(128) CHARSET utf8',_binary 'BEGIN DECLARE v_value VARCHAR(128) DEFAULT NULL;  SET v_value = (SELECT value FROM sys.sys_config WHERE variable = in_variable_name);  IF (v_value IS NULL) THEN SET v_value = in_default_value; END IF;  RETURN v_value; END','mysql.sys@localhost','2017-03-02 18:46:26','2017-03-02 18:46:26','','\n Description\n \n Returns the value for the requested variable using the following logic:\n \n 1. If the option exists in sys.sys_config return the value from there.\n 2. Else fall back on the provided default value.\n \n Notes for using sys_get_config():\n \n * If the default value argument to sys_get_config() is NULL and case 2. is reached, NULL is returned.\n It is then expected that the caller is able to handle NULL for the given configuration option.\n * The convention is to name the user variables @sys.<name of variable>. It is <name of variable> that\n is stored in the sys_config table and is what is expected as the argument to sys_get_config().\n * If you want to check whether the configuration option has already been set and if not assign with\n the return value of sys_get_config() you can use IFNULL(...) (see example below). However this should\n not be done inside a loop (e.g. for each row in a result set) as for repeated calls where assignment\n is only needed in the first iteration using IFNULL(...) is expected to be significantly slower than\n using an IF (...) THEN ... END IF; block (see example below).\n \n Parameters\n \n in_variable_name (VARCHAR(128)):\n The name of the config option to return the value for.\n \n in_default_value (VARCHAR(128)):\n The default value to return if the variable does not exist in sys.sys_config.\n \n Returns\n \n VARCHAR(128)\n \n Example\n \n mysql> SELECT sys.sys_get_config(\'statement_truncate_len\', 128) AS Value;\n +-------+\n | Value |\n +-------+\n | 64    |\n +-------+\n 1 row in set (0.00 sec)\n \n mysql> SET @sys.statement_truncate_len = IFNULL(@sys.statement_truncate_len, sys.sys_get_config(\'statement_truncate_len\', 64));\n Query OK, 0 rows affected (0.00 sec)\n \n IF (@sys.statement_truncate_len IS NULL) THEN\n SET @sys.statement_truncate_len = sys.sys_get_config(\'statement_truncate_len\', 64);\n END IF;\n ','utf8','utf8_general_ci','utf8_general_ci',_binary 'BEGIN DECLARE v_value VARCHAR(128) DEFAULT NULL;  SET v_value = (SELECT value FROM sys.sys_config WHERE variable = in_variable_name);  IF (v_value IS NULL) THEN SET v_value = in_default_value; END IF;  RETURN v_value; END'),('sys','version_major','FUNCTION','version_major','SQL','NO_SQL','NO','INVOKER','',_binary 'tinyint(3) unsigned',_binary 'BEGIN RETURN SUBSTRING_INDEX(SUBSTRING_INDEX(VERSION(), \'-\', 1), \'.\', 1); END','mysql.sys@localhost','2017-03-02 18:46:26','2017-03-02 18:46:26','','\n Description\n \n Returns the major version of MySQL Server.\n \n Returns\n \n TINYINT UNSIGNED\n \n Example\n \n mysql> SELECT VERSION(), sys.version_major();\n +--------------------------------------+---------------------+\n | VERSION()                            | sys.version_major() |\n +--------------------------------------+---------------------+\n | 5.7.9-enterprise-commercial-advanced | 5                   |\n +--------------------------------------+---------------------+\n 1 row in set (0.00 sec)\n ','utf8','utf8_general_ci','utf8_general_ci',_binary 'BEGIN RETURN SUBSTRING_INDEX(SUBSTRING_INDEX(VERSION(), \'-\', 1), \'.\', 1); END'),('sys','version_minor','FUNCTION','version_minor','SQL','NO_SQL','NO','INVOKER','',_binary 'tinyint(3) unsigned',_binary 'BEGIN RETURN SUBSTRING_INDEX(SUBSTRING_INDEX(SUBSTRING_INDEX(VERSION(), \'-\', 1), \'.\', 2), \'.\', -1); END','mysql.sys@localhost','2017-03-02 18:46:26','2017-03-02 18:46:26','','\n Description\n \n Returns the minor (release series) version of MySQL Server.\n \n Returns\n \n TINYINT UNSIGNED\n \n Example\n \n mysql> SELECT VERSION(), sys.server_minor();\n +--------------------------------------+---------------------+\n | VERSION()                            | sys.version_minor() |\n +--------------------------------------+---------------------+\n | 5.7.9-enterprise-commercial-advanced | 7                   |\n +--------------------------------------+---------------------+\n 1 row in set (0.00 sec)\n ','utf8','utf8_general_ci','utf8_general_ci',_binary 'BEGIN RETURN SUBSTRING_INDEX(SUBSTRING_INDEX(SUBSTRING_INDEX(VERSION(), \'-\', 1), \'.\', 2), \'.\', -1); END'),('sys','version_patch','FUNCTION','version_patch','SQL','NO_SQL','NO','INVOKER','',_binary 'tinyint(3) unsigned',_binary 'BEGIN RETURN SUBSTRING_INDEX(SUBSTRING_INDEX(VERSION(), \'-\', 1), \'.\', -1); END','mysql.sys@localhost','2017-03-02 18:46:26','2017-03-02 18:46:26','','\n Description\n \n Returns the patch release version of MySQL Server.\n \n Returns\n \n TINYINT UNSIGNED\n \n Example\n \n mysql> SELECT VERSION(), sys.version_patch();\n +--------------------------------------+---------------------+\n | VERSION()                            | sys.version_patch() |\n +--------------------------------------+---------------------+\n | 5.7.9-enterprise-commercial-advanced | 9                   |\n +--------------------------------------+---------------------+\n 1 row in set (0.00 sec)\n ','utf8','utf8_general_ci','utf8_general_ci',_binary 'BEGIN RETURN SUBSTRING_INDEX(SUBSTRING_INDEX(VERSION(), \'-\', 1), \'.\', -1); END'),('sys','create_synonym_db','PROCEDURE','create_synonym_db','SQL','MODIFIES_SQL_DATA','NO','INVOKER',_binary ' IN in_db_name VARCHAR(64),  IN in_synonym VARCHAR(64) ','',_binary 'BEGIN DECLARE v_done bool DEFAULT FALSE; DECLARE v_db_name_check VARCHAR(64); DECLARE v_db_err_msg TEXT; DECLARE v_table VARCHAR(64); DECLARE v_views_created INT DEFAULT 0;  DECLARE db_doesnt_exist CONDITION FOR SQLSTATE \'42000\'; DECLARE db_name_exists CONDITION FOR SQLSTATE \'HY000\';  DECLARE c_table_names CURSOR FOR  SELECT TABLE_NAME  FROM INFORMATION_SCHEMA.TABLES  WHERE TABLE_SCHEMA = in_db_name;  DECLARE CONTINUE HANDLER FOR NOT FOUND SET v_done = TRUE;  SELECT SCHEMA_NAME INTO v_db_name_check FROM INFORMATION_SCHEMA.SCHEMATA WHERE SCHEMA_NAME = in_db_name;  IF v_db_name_check IS NULL THEN SET v_db_err_msg = CONCAT(\'Unknown database \', in_db_name); SIGNAL SQLSTATE \'HY000\' SET MESSAGE_TEXT = v_db_err_msg; END IF;  SELECT SCHEMA_NAME INTO v_db_name_check FROM INFORMATION_SCHEMA.SCHEMATA WHERE SCHEMA_NAME = in_synonym;  IF v_db_name_check = in_synonym THEN SET v_db_err_msg = CONCAT(\'Can\\\'t create database \', in_synonym, \'; database exists\'); SIGNAL SQLSTATE \'HY000\' SET MESSAGE_TEXT = v_db_err_msg; END IF;  SET @create_db_stmt := CONCAT(\'CREATE DATABASE \', sys.quote_identifier(in_synonym)); PREPARE create_db_stmt FROM @create_db_stmt; EXECUTE create_db_stmt; DEALLOCATE PREPARE create_db_stmt;  SET v_done = FALSE; OPEN c_table_names; c_table_names: LOOP FETCH c_table_names INTO v_table; IF v_done THEN LEAVE c_table_names; END IF;  SET @create_view_stmt = CONCAT( \'CREATE SQL SECURITY INVOKER VIEW \', sys.quote_identifier(in_synonym), \'.\', sys.quote_identifier(v_table), \' AS SELECT * FROM \', sys.quote_identifier(in_db_name), \'.\', sys.quote_identifier(v_table) ); PREPARE create_view_stmt FROM @create_view_stmt; EXECUTE create_view_stmt; DEALLOCATE PREPARE create_view_stmt;  SET v_views_created = v_views_created + 1; END LOOP; CLOSE c_table_names;  SELECT CONCAT( \'Created \', v_views_created, \' view\', IF(v_views_created != 1, \'s\', \'\'), \' in the \', sys.quote_identifier(in_synonym), \' database\' ) AS summary;  END','mysql.sys@localhost','2017-03-02 18:46:53','2017-03-02 18:46:53','','\n Description\n \n Takes a source database name and synonym name, and then creates the \n synonym database with views that point to all of the tables within\n the source database.\n \n Useful for creating a \"ps\" synonym for \"performance_schema\",\n or \"is\" instead of \"information_schema\", for example.\n \n Parameters\n \n in_db_name (VARCHAR(64)):\n The database name that you would like to create a synonym for.\n in_synonym (VARCHAR(64)):\n The database synonym name.\n \n Example\n \n mysql> SHOW DATABASES;\n +--------------------+\n | Database           |\n +--------------------+\n | information_schema |\n | mysql              |\n | performance_schema |\n | sys                |\n | test               |\n +--------------------+\n 5 rows in set (0.00 sec)\n \n mysql> CALL sys.create_synonym_db(\'performance_schema\', \'ps\');\n +---------------------------------------+\n | summary                               |\n +---------------------------------------+\n | Created 74 views in the `ps` database |\n +---------------------------------------+\n 1 row in set (8.57 sec)\n \n Query OK, 0 rows affected (8.57 sec)\n \n mysql> SHOW DATABASES;\n +--------------------+\n | Database           |\n +--------------------+\n | information_schema |\n | mysql              |\n | performance_schema |\n | ps                 |\n | sys                |\n | test               |\n +--------------------+\n 6 rows in set (0.00 sec)\n \n mysql> SHOW FULL TABLES FROM ps;\n +------------------------------------------------------+------------+\n | Tables_in_ps                                         | Table_type |\n +------------------------------------------------------+------------+\n | accounts                                             | VIEW       |\n | cond_instances                                       | VIEW       |\n | events_stages_current                                | VIEW       |\n | events_stages_history                                | VIEW       |\n ...\n ','utf8','utf8_general_ci','utf8_general_ci',_binary 'BEGIN DECLARE v_done bool DEFAULT FALSE; DECLARE v_db_name_check VARCHAR(64); DECLARE v_db_err_msg TEXT; DECLARE v_table VARCHAR(64); DECLARE v_views_created INT DEFAULT 0;  DECLARE db_doesnt_exist CONDITION FOR SQLSTATE \'42000\'; DECLARE db_name_exists CONDITION FOR SQLSTATE \'HY000\';  DECLARE c_table_names CURSOR FOR  SELECT TABLE_NAME  FROM INFORMATION_SCHEMA.TABLES  WHERE TABLE_SCHEMA = in_db_name;  DECLARE CONTINUE HANDLER FOR NOT FOUND SET v_done = TRUE;  SELECT SCHEMA_NAME INTO v_db_name_check FROM INFORMATION_SCHEMA.SCHEMATA WHERE SCHEMA_NAME = in_db_name;  IF v_db_name_check IS NULL THEN SET v_db_err_msg = CONCAT(\'Unknown database \', in_db_name); SIGNAL SQLSTATE \'HY000\' SET MESSAGE_TEXT = v_db_err_msg; END IF;  SELECT SCHEMA_NAME INTO v_db_name_check FROM INFORMATION_SCHEMA.SCHEMATA WHERE SCHEMA_NAME = in_synonym;  IF v_db_name_check = in_synonym THEN SET v_db_err_msg = CONCAT(\'Can\'t create database \', in_synonym, \'; database exists\'); SIGNAL SQLSTATE \'HY000\' SET MESSAGE_TEXT = v_db_err_msg; END IF;  SET @create_db_stmt := CONCAT(\'CREATE DATABASE \', sys.quote_identifier(in_synonym)); PREPARE create_db_stmt FROM @create_db_stmt; EXECUTE create_db_stmt; DEALLOCATE PREPARE create_db_stmt;  SET v_done = FALSE; OPEN c_table_names; c_table_names: LOOP FETCH c_table_names INTO v_table; IF v_done THEN LEAVE c_table_names; END IF;  SET @create_view_stmt = CONCAT( \'CREATE SQL SECURITY INVOKER VIEW \', sys.quote_identifier(in_synonym), \'.\', sys.quote_identifier(v_table), \' AS SELECT * FROM \', sys.quote_identifier(in_db_name), \'.\', sys.quote_identifier(v_table) ); PREPARE create_view_stmt FROM @create_view_stmt; EXECUTE create_view_stmt; DEALLOCATE PREPARE create_view_stmt;  SET v_views_created = v_views_created + 1; END LOOP; CLOSE c_table_names;  SELECT CONCAT( \'Created \', v_views_created, \' view\', IF(v_views_created != 1, \'s\', \'\'), \' in the \', sys.quote_identifier(in_synonym), \' database\' ) AS summary;  END'),('sys','execute_prepared_stmt','PROCEDURE','execute_prepared_stmt','SQL','READS_SQL_DATA','NO','INVOKER',_binary ' IN in_query longtext CHARACTER SET UTF8 ','',_binary 'BEGIN IF (@sys.debug IS NULL) THEN SET @sys.debug = sys.sys_get_config(\'debug\', \'OFF\'); END IF;  IF (in_query IS NULL OR LENGTH(in_query) < 4) THEN SIGNAL SQLSTATE \'45000\' SET MESSAGE_TEXT = \"The @sys.execute_prepared_stmt.sql must contain a query\"; END IF;  SET @sys.execute_prepared_stmt.sql = in_query;  IF (@sys.debug = \'ON\') THEN SELECT @sys.execute_prepared_stmt.sql AS \'Debug\'; END IF; PREPARE sys_execute_prepared_stmt FROM @sys.execute_prepared_stmt.sql; EXECUTE sys_execute_prepared_stmt; DEALLOCATE PREPARE sys_execute_prepared_stmt;  SET @sys.execute_prepared_stmt.sql = NULL; END','mysql.sys@localhost','2017-03-02 18:46:53','2017-03-02 18:46:53','','\n Description\n \n Takes the query in the argument and executes it using a prepared statement. The prepared statement is deallocated,\n so the procedure is mainly useful for executing one off dynamically created queries.\n \n The sys_execute_prepared_stmt prepared statement name is used for the query and is required not to exist.\n \n \n Parameters\n \n in_query (longtext CHARACTER SET UTF8):\n The query to execute.\n \n \n Configuration Options\n \n sys.debug\n Whether to provide debugging output.\n Default is \'OFF\'. Set to \'ON\' to include.\n \n \n Example\n \n mysql> CALL sys.execute_prepared_stmt(\'SELECT * FROM sys.sys_config\');\n +------------------------+-------+---------------------+--------+\n | variable               | value | set_time            | set_by |\n +------------------------+-------+---------------------+--------+\n | statement_truncate_len | 64    | 2015-06-30 13:06:00 | NULL   |\n +------------------------+-------+---------------------+--------+\n 1 row in set (0.00 sec)\n \n Query OK, 0 rows affected (0.00 sec)\n ','utf8','utf8_general_ci','utf8_general_ci',_binary 'BEGIN IF (@sys.debug IS NULL) THEN SET @sys.debug = sys.sys_get_config(\'debug\', \'OFF\'); END IF;  IF (in_query IS NULL OR LENGTH(in_query) < 4) THEN SIGNAL SQLSTATE \'45000\' SET MESSAGE_TEXT = \"The @sys.execute_prepared_stmt.sql must contain a query\"; END IF;  SET @sys.execute_prepared_stmt.sql = in_query;  IF (@sys.debug = \'ON\') THEN SELECT @sys.execute_prepared_stmt.sql AS \'Debug\'; END IF; PREPARE sys_execute_prepared_stmt FROM @sys.execute_prepared_stmt.sql; EXECUTE sys_execute_prepared_stmt; DEALLOCATE PREPARE sys_execute_prepared_stmt;  SET @sys.execute_prepared_stmt.sql = NULL; END'),('sys','diagnostics','PROCEDURE','diagnostics','SQL','READS_SQL_DATA','NO','INVOKER',_binary ' IN in_max_runtime int unsigned, IN in_interval int unsigned, IN in_auto_config enum (\'current\', \'medium\', \'full\') ','',_binary 'BEGIN DECLARE v_start, v_runtime, v_iter_start, v_sleep DECIMAL(20,2) DEFAULT 0.0; DECLARE v_has_innodb, v_has_ndb, v_has_ps, v_has_replication, v_has_ps_replication VARCHAR(8) CHARSET utf8 DEFAULT \'NO\'; DECLARE v_this_thread_enabled, v_has_ps_vars, v_has_metrics ENUM(\'YES\', \'NO\'); DECLARE v_table_name, v_banner VARCHAR(64) CHARSET utf8; DECLARE v_sql_status_summary_select, v_sql_status_summary_delta, v_sql_status_summary_from, v_no_delta_names TEXT; DECLARE v_output_time, v_output_time_prev DECIMAL(20,3) UNSIGNED; DECLARE v_output_count, v_count, v_old_group_concat_max_len INT UNSIGNED DEFAULT 0; DECLARE v_status_summary_width TINYINT UNSIGNED DEFAULT 50; DECLARE v_done BOOLEAN DEFAULT FALSE; DECLARE c_ndbinfo CURSOR FOR SELECT TABLE_NAME FROM information_schema.TABLES WHERE TABLE_SCHEMA = \'ndbinfo\' AND TABLE_NAME NOT IN ( \'blocks\', \'config_params\', \'dict_obj_types\', \'disk_write_speed_base\', \'memory_per_fragment\', \'memoryusage\', \'operations_per_fragment\', \'threadblocks\' ); DECLARE c_sysviews_w_delta CURSOR FOR SELECT table_name FROM tmp_sys_views_delta ORDER BY table_name;  DECLARE CONTINUE HANDLER FOR NOT FOUND SET v_done = TRUE;  SELECT INSTRUMENTED INTO v_this_thread_enabled FROM performance_schema.threads WHERE PROCESSLIST_ID = CONNECTION_ID(); IF (v_this_thread_enabled = \'YES\') THEN CALL sys.ps_setup_disable_thread(CONNECTION_ID()); END IF;  IF (in_max_runtime < in_interval) THEN SIGNAL SQLSTATE \'45000\' SET MESSAGE_TEXT = \'in_max_runtime must be greater than or equal to in_interval\'; END IF; IF (in_max_runtime = 0) THEN SIGNAL SQLSTATE \'45000\' SET MESSAGE_TEXT = \'in_max_runtime must be greater than 0\'; END IF; IF (in_interval = 0) THEN SIGNAL SQLSTATE \'45000\' SET MESSAGE_TEXT = \'in_interval must be greater than 0\'; END IF;  IF (@sys.diagnostics.allow_i_s_tables IS NULL) THEN SET @sys.diagnostics.allow_i_s_tables = sys.sys_get_config(\'diagnostics.allow_i_s_tables\', \'OFF\'); END IF; IF (@sys.diagnostics.include_raw IS NULL) THEN SET @sys.diagnostics.include_raw      = sys.sys_get_config(\'diagnostics.include_raw\'     , \'OFF\'); END IF; IF (@sys.debug IS NULL) THEN SET @sys.debug                        = sys.sys_get_config(\'debug\'                       , \'OFF\'); END IF; IF (@sys.statement_truncate_len IS NULL) THEN SET @sys.statement_truncate_len       = sys.sys_get_config(\'statement_truncate_len\'      , \'64\' ); END IF;  SET @log_bin := @@sql_log_bin; IF (@log_bin = 1) THEN SET sql_log_bin = 0; END IF;  SET v_no_delta_names = CONCAT(\'s%{COUNT}.Variable_name NOT IN (\', \'\'\'innodb_buffer_pool_pages_total\'\', \', \'\'\'innodb_page_size\'\', \', \'\'\'last_query_cost\'\', \', \'\'\'last_query_partial_plans\'\', \', \'\'\'qcache_total_blocks\'\', \', \'\'\'slave_last_heartbeat\'\', \', \'\'\'ssl_ctx_verify_depth\'\', \', \'\'\'ssl_ctx_verify_mode\'\', \', \'\'\'ssl_session_cache_size\'\', \', \'\'\'ssl_verify_depth\'\', \', \'\'\'ssl_verify_mode\'\', \', \'\'\'ssl_version\'\', \', \'\'\'buffer_flush_lsn_avg_rate\'\', \', \'\'\'buffer_flush_pct_for_dirty\'\', \', \'\'\'buffer_flush_pct_for_lsn\'\', \', \'\'\'buffer_pool_pages_total\'\', \', \'\'\'lock_row_lock_time_avg\'\', \', \'\'\'lock_row_lock_time_max\'\', \', \'\'\'innodb_page_size\'\'\', \')\');  IF (in_auto_config <> \'current\') THEN IF (@sys.debug = \'ON\') THEN SELECT CONCAT(\'Updating Performance Schema configuration to \', in_auto_config) AS \'Debug\'; END IF; CALL sys.ps_setup_save(0);  IF (in_auto_config = \'medium\') THEN UPDATE performance_schema.setup_consumers SET ENABLED = \'YES\' WHERE NAME NOT LIKE \'%\\_history%\';  UPDATE performance_schema.setup_instruments SET ENABLED = \'YES\', TIMED   = \'YES\' WHERE NAME NOT LIKE \'wait/synch/%\'; ELSEIF (in_auto_config = \'full\') THEN UPDATE performance_schema.setup_consumers SET ENABLED = \'YES\';  UPDATE performance_schema.setup_instruments SET ENABLED = \'YES\', TIMED   = \'YES\'; END IF;  UPDATE performance_schema.threads SET INSTRUMENTED = \'YES\' WHERE PROCESSLIST_ID <> CONNECTION_ID(); END IF;  SET v_start        = UNIX_TIMESTAMP(NOW(2)), in_interval    = IFNULL(in_interval, 30), in_max_runtime = IFNULL(in_max_runtime, 60);  SET v_banner = REPEAT( \'-\', LEAST( GREATEST( 36, CHAR_LENGTH(VERSION()), CHAR_LENGTH(@@global.version_comment), CHAR_LENGTH(@@global.version_compile_os), CHAR_LENGTH(@@global.version_compile_machine), CHAR_LENGTH(@@global.socket), CHAR_LENGTH(@@global.datadir) ), 64 ) ); SELECT \'Hostname\' AS \'Name\', @@global.hostname AS \'Value\' UNION ALL SELECT \'Port\' AS \'Name\', @@global.port AS \'Value\' UNION ALL SELECT \'Socket\' AS \'Name\', @@global.socket AS \'Value\' UNION ALL SELECT \'Datadir\' AS \'Name\', @@global.datadir AS \'Value\' UNION ALL SELECT \'Server UUID\' AS \'Name\', @@global.server_uuid AS \'Value\' UNION ALL SELECT REPEAT(\'-\', 23) AS \'Name\', v_banner AS \'Value\' UNION ALL SELECT \'MySQL Version\' AS \'Name\', VERSION() AS \'Value\' UNION ALL SELECT \'Sys Schema Version\' AS \'Name\', (SELECT sys_version FROM sys.version) AS \'Value\' UNION ALL SELECT \'Version Comment\' AS \'Name\', @@global.version_comment AS \'Value\' UNION ALL SELECT \'Version Compile OS\' AS \'Name\', @@global.version_compile_os AS \'Value\' UNION ALL SELECT \'Version Compile Machine\' AS \'Name\', @@global.version_compile_machine AS \'Value\' UNION ALL SELECT REPEAT(\'-\', 23) AS \'Name\', v_banner AS \'Value\' UNION ALL SELECT \'UTC Time\' AS \'Name\', UTC_TIMESTAMP() AS \'Value\' UNION ALL SELECT \'Local Time\' AS \'Name\', NOW() AS \'Value\' UNION ALL SELECT \'Time Zone\' AS \'Name\', @@global.time_zone AS \'Value\' UNION ALL SELECT \'System Time Zone\' AS \'Name\', @@global.system_time_zone AS \'Value\' UNION ALL SELECT \'Time Zone Offset\' AS \'Name\', TIMEDIFF(NOW(), UTC_TIMESTAMP()) AS \'Value\';  SET v_has_innodb         = IFNULL((SELECT SUPPORT FROM information_schema.ENGINES WHERE ENGINE = \'InnoDB\'), \'NO\'), v_has_ndb            = IFNULL((SELECT SUPPORT FROM information_schema.ENGINES WHERE ENGINE = \'NDBCluster\'), \'NO\'), v_has_ps             = IFNULL((SELECT SUPPORT FROM information_schema.ENGINES WHERE ENGINE = \'PERFORMANCE_SCHEMA\'), \'NO\'), v_has_ps_replication = IF(v_has_ps = \'YES\' AND EXISTS(SELECT 1 FROM information_schema.TABLES WHERE TABLE_SCHEMA = \'performance_schema\' AND TABLE_NAME = \'replication_applier_status\'), \'YES\', \'NO\' ), v_has_replication    =  IF(v_has_ps_replication = \'YES\', IF((SELECT COUNT(*) FROM performance_schema.replication_connection_status) > 0, \'YES\', \'NO\'), IF(@@master_info_repository = \'TABLE\', IF((SELECT COUNT(*) FROM mysql.slave_master_info) > 0, \'YES\', \'NO\'), IF(@@relay_log_info_repository = \'TABLE\', IF((SELECT COUNT(*) FROM mysql.slave_relay_log_info) > 0, \'YES\', \'NO\'), \'MAYBE\')) ) , v_has_metrics        = IF(v_has_ps = \'YES\' OR (sys.version_major() = 5 AND sys.version_minor() = 6), \'YES\', \'NO\'), v_has_ps_vars        = \'NO\';   SET v_has_ps_vars = IF(@@global.show_compatibility_56, \'NO\', \'YES\');  SET v_has_ps_vars = \'YES\';  IF (@sys.debug = \'ON\') THEN SELECT v_has_innodb AS \'Has_InnoDB\', v_has_ndb AS \'Has_NDBCluster\', v_has_ps AS \'Has_Performance_Schema\', v_has_ps_vars AS \'Has_P_S_SHOW_Variables\', v_has_metrics AS \'Has_metrics\', v_has_ps_replication \'AS Has_P_S_Replication\', v_has_replication AS \'Has_Replication\'; END IF;  IF (v_has_innodb IN (\'DEFAULT\', \'YES\')) THEN SET @sys.diagnostics.sql = \'SHOW ENGINE InnoDB STATUS\'; PREPARE stmt_innodb_status FROM @sys.diagnostics.sql; END IF;  IF (v_has_ps = \'YES\') THEN SET @sys.diagnostics.sql = \'SHOW ENGINE PERFORMANCE_SCHEMA STATUS\'; PREPARE stmt_ps_status FROM @sys.diagnostics.sql; END IF;  IF (v_has_ndb IN (\'DEFAULT\', \'YES\')) THEN SET @sys.diagnostics.sql = \'SHOW ENGINE NDBCLUSTER STATUS\'; PREPARE stmt_ndbcluster_status FROM @sys.diagnostics.sql; END IF;  SET @sys.diagnostics.sql_gen_query_template = \'SELECT CONCAT( \'\'SELECT \'\', GROUP_CONCAT( CASE WHEN (SUBSTRING(TABLE_NAME, 3), COLUMN_NAME) IN ( (\'\'io_global_by_file_by_bytes\'\', \'\'total\'\'), (\'\'io_global_by_wait_by_bytes\'\', \'\'total_requested\'\') ) THEN CONCAT(\'\'sys.format_bytes(\'\', COLUMN_NAME, \'\') AS \'\', COLUMN_NAME) WHEN SUBSTRING(COLUMN_NAME, -8) = \'\'_latency\'\' THEN CONCAT(\'\'sys.format_time(\'\', COLUMN_NAME, \'\') AS \'\', COLUMN_NAME) WHEN SUBSTRING(COLUMN_NAME, -7) = \'\'_memory\'\' OR SUBSTRING(COLUMN_NAME, -17) = \'\'_memory_allocated\'\' OR ((SUBSTRING(COLUMN_NAME, -5) = \'\'_read\'\' OR SUBSTRING(COLUMN_NAME, -8) = \'\'_written\'\' OR SUBSTRING(COLUMN_NAME, -6) = \'\'_write\'\') AND SUBSTRING(COLUMN_NAME, 1, 6) <> \'\'COUNT_\'\') THEN CONCAT(\'\'sys.format_bytes(\'\', COLUMN_NAME, \'\') AS \'\', COLUMN_NAME) ELSE COLUMN_NAME END ORDER BY ORDINAL_POSITION SEPARATOR \'\',\\n       \'\' ), \'\'\\n  FROM tmp_\'\', SUBSTRING(TABLE_NAME FROM 3), \'\'_%{OUTPUT}\'\' ) AS Query INTO @sys.diagnostics.sql_select FROM information_schema.COLUMNS WHERE TABLE_SCHEMA = \'\'sys\'\' AND TABLE_NAME = ? GROUP BY TABLE_NAME\';  SET @sys.diagnostics.sql_gen_query_delta = \'SELECT CONCAT( \'\'SELECT \'\', GROUP_CONCAT( CASE WHEN FIND_IN_SET(COLUMN_NAME, diag.pk) THEN COLUMN_NAME WHEN diag.TABLE_NAME = \'\'io_global_by_file_by_bytes\'\' AND COLUMN_NAME = \'\'write_pct\'\' THEN CONCAT(\'\'IFNULL(ROUND(100-(((e.total_read-IFNULL(s.total_read, 0))\'\', \'\'/NULLIF(((e.total_read-IFNULL(s.total_read, 0))+(e.total_written-IFNULL(s.total_written, 0))), 0))*100), 2), 0.00) AS \'\', COLUMN_NAME) WHEN (diag.TABLE_NAME, COLUMN_NAME) IN ( (\'\'io_global_by_file_by_bytes\'\', \'\'total\'\'), (\'\'io_global_by_wait_by_bytes\'\', \'\'total_requested\'\') ) THEN CONCAT(\'\'sys.format_bytes(e.\'\', COLUMN_NAME, \'\'-IFNULL(s.\'\', COLUMN_NAME, \'\', 0)) AS \'\', COLUMN_NAME) WHEN SUBSTRING(COLUMN_NAME, 1, 4) IN (\'\'max_\'\', \'\'min_\'\') AND SUBSTRING(COLUMN_NAME, -8) = \'\'_latency\'\' THEN CONCAT(\'\'sys.format_time(e.\'\', COLUMN_NAME, \'\') AS \'\', COLUMN_NAME) WHEN COLUMN_NAME = \'\'avg_latency\'\' THEN CONCAT(\'\'sys.format_time((e.total_latency - IFNULL(s.total_latency, 0))\'\', \'\'/NULLIF(e.total - IFNULL(s.total, 0), 0)) AS \'\', COLUMN_NAME) WHEN SUBSTRING(COLUMN_NAME, -12) = \'\'_avg_latency\'\' THEN CONCAT(\'\'sys.format_time((e.\'\', SUBSTRING(COLUMN_NAME FROM 1 FOR CHAR_LENGTH(COLUMN_NAME)-12), \'\'_latency - IFNULL(s.\'\', SUBSTRING(COLUMN_NAME FROM 1 FOR CHAR_LENGTH(COLUMN_NAME)-12), \'\'_latency, 0))\'\', \'\'/NULLIF(e.\'\', SUBSTRING(COLUMN_NAME FROM 1 FOR CHAR_LENGTH(COLUMN_NAME)-12), \'\'s - IFNULL(s.\'\', SUBSTRING(COLUMN_NAME FROM 1 FOR CHAR_LENGTH(COLUMN_NAME)-12), \'\'s, 0), 0)) AS \'\', COLUMN_NAME) WHEN SUBSTRING(COLUMN_NAME, -8) = \'\'_latency\'\' THEN CONCAT(\'\'sys.format_time(e.\'\', COLUMN_NAME, \'\' - IFNULL(s.\'\', COLUMN_NAME, \'\', 0)) AS \'\', COLUMN_NAME) WHEN COLUMN_NAME IN (\'\'avg_read\'\', \'\'avg_write\'\', \'\'avg_written\'\') THEN CONCAT(\'\'sys.format_bytes(IFNULL((e.total_\'\', IF(COLUMN_NAME = \'\'avg_read\'\', \'\'read\'\', \'\'written\'\'), \'\'-IFNULL(s.total_\'\', IF(COLUMN_NAME = \'\'avg_read\'\', \'\'read\'\', \'\'written\'\'), \'\', 0))\'\', \'\'/NULLIF(e.count_\'\', IF(COLUMN_NAME = \'\'avg_read\'\', \'\'read\'\', \'\'write\'\'), \'\'-IFNULL(s.count_\'\', IF(COLUMN_NAME = \'\'avg_read\'\', \'\'read\'\', \'\'write\'\'), \'\', 0), 0), 0)) AS \'\', COLUMN_NAME) WHEN SUBSTRING(COLUMN_NAME, -7) = \'\'_memory\'\' OR SUBSTRING(COLUMN_NAME, -17) = \'\'_memory_allocated\'\' OR ((SUBSTRING(COLUMN_NAME, -5) = \'\'_read\'\' OR SUBSTRING(COLUMN_NAME, -8) = \'\'_written\'\' OR SUBSTRING(COLUMN_NAME, -6) = \'\'_write\'\') AND SUBSTRING(COLUMN_NAME, 1, 6) <> \'\'COUNT_\'\') THEN CONCAT(\'\'sys.format_bytes(e.\'\', COLUMN_NAME, \'\' - IFNULL(s.\'\', COLUMN_NAME, \'\', 0)) AS \'\', COLUMN_NAME) ELSE CONCAT(\'\'(e.\'\', COLUMN_NAME, \'\' - IFNULL(s.\'\', COLUMN_NAME, \'\', 0)) AS \'\', COLUMN_NAME) END ORDER BY ORDINAL_POSITION SEPARATOR \'\',\\n       \'\' ), \'\'\\n  FROM tmp_\'\', diag.TABLE_NAME, \'\'_end e LEFT OUTER JOIN tmp_\'\', diag.TABLE_NAME, \'\'_start s USING (\'\', diag.pk, \'\')\'\' ) AS Query INTO @sys.diagnostics.sql_select FROM tmp_sys_views_delta diag INNER JOIN information_schema.COLUMNS c ON c.TABLE_NAME = CONCAT(\'\'x$\'\', diag.TABLE_NAME) WHERE c.TABLE_SCHEMA = \'\'sys\'\' AND diag.TABLE_NAME = ? GROUP BY diag.TABLE_NAME\';  IF (v_has_ps = \'YES\') THEN DROP TEMPORARY TABLE IF EXISTS tmp_sys_views_delta; CREATE TEMPORARY TABLE tmp_sys_views_delta ( TABLE_NAME varchar(64) NOT NULL, order_by text COMMENT \'ORDER BY clause for the initial and overall views\', order_by_delta text COMMENT \'ORDER BY clause for the delta views\', where_delta text COMMENT \'WHERE clause to use for delta views to only include rows with a \"count\" > 0\', limit_rows int unsigned COMMENT \'The maximum number of rows to include for the view\', pk varchar(128) COMMENT \'Used with the FIND_IN_SET() function so use comma separated list without whitespace\', PRIMARY KEY (TABLE_NAME) );  IF (@sys.debug = \'ON\') THEN SELECT \'Populating tmp_sys_views_delta\' AS \'Debug\'; END IF; INSERT INTO tmp_sys_views_delta VALUES (\'host_summary\'                       , \'%{TABLE}.statement_latency DESC\', \'(e.statement_latency-IFNULL(s.statement_latency, 0)) DESC\', \'(e.statements - IFNULL(s.statements, 0)) > 0\', NULL, \'host\'), (\'host_summary_by_file_io\'            , \'%{TABLE}.io_latency DESC\', \'(e.io_latency-IFNULL(s.io_latency, 0)) DESC\', \'(e.ios - IFNULL(s.ios, 0)) > 0\', NULL, \'host\'), (\'host_summary_by_file_io_type\'       , \'%{TABLE}.host, %{TABLE}.total_latency DESC\', \'e.host, (e.total_latency-IFNULL(s.total_latency, 0)) DESC\', \'(e.total - IFNULL(s.total, 0)) > 0\', NULL, \'host,event_name\'), (\'host_summary_by_stages\'             , \'%{TABLE}.host, %{TABLE}.total_latency DESC\', \'e.host, (e.total_latency-IFNULL(s.total_latency, 0)) DESC\', \'(e.total - IFNULL(s.total, 0)) > 0\', NULL, \'host,event_name\'), (\'host_summary_by_statement_latency\'  , \'%{TABLE}.total_latency DESC\', \'(e.total_latency-IFNULL(s.total_latency, 0)) DESC\', \'(e.total - IFNULL(s.total, 0)) > 0\', NULL, \'host\'), (\'host_summary_by_statement_type\'     , \'%{TABLE}.host, %{TABLE}.total_latency DESC\', \'e.host, (e.total_latency-IFNULL(s.total_latency, 0)) DESC\', \'(e.total - IFNULL(s.total, 0)) > 0\', NULL, \'host,statement\'), (\'io_by_thread_by_latency\'            , \'%{TABLE}.total_latency DESC\', \'(e.total_latency-IFNULL(s.total_latency, 0)) DESC\', \'(e.total - IFNULL(s.total, 0)) > 0\', NULL, \'user,thread_id,processlist_id\'), (\'io_global_by_file_by_bytes\'         , \'%{TABLE}.total DESC\', \'(e.total-IFNULL(s.total, 0)) DESC\', \'(e.total - IFNULL(s.total, 0)) > 0\', 100, \'file\'), (\'io_global_by_file_by_latency\'       , \'%{TABLE}.total_latency DESC\', \'(e.total_latency-IFNULL(s.total_latency, 0)) DESC\', \'(e.total - IFNULL(s.total, 0)) > 0\', 100, \'file\'), (\'io_global_by_wait_by_bytes\'         , \'%{TABLE}.total_requested DESC\', \'(e.total_requested-IFNULL(s.total_requested, 0)) DESC\', \'(e.total - IFNULL(s.total, 0)) > 0\', NULL, \'event_name\'), (\'io_global_by_wait_by_latency\'       , \'%{TABLE}.total_latency DESC\', \'(e.total_latency-IFNULL(s.total_latency, 0)) DESC\', \'(e.total - IFNULL(s.total, 0)) > 0\', NULL, \'event_name\'), (\'schema_index_statistics\'            , \'(%{TABLE}.select_latency+%{TABLE}.insert_latency+%{TABLE}.update_latency+%{TABLE}.delete_latency) DESC\', \'((e.select_latency+e.insert_latency+e.update_latency+e.delete_latency)-IFNULL(s.select_latency+s.insert_latency+s.update_latency+s.delete_latency, 0)) DESC\', \'((e.rows_selected+e.insert_latency+e.rows_updated+e.rows_deleted)-IFNULL(s.rows_selected+s.rows_inserted+s.rows_updated+s.rows_deleted, 0)) > 0\', 100, \'table_schema,table_name,index_name\'), (\'schema_table_statistics\'            , \'%{TABLE}.total_latency DESC\', \'(e.total_latency-IFNULL(s.total_latency, 0)) DESC\', \'(e.total_latency-IFNULL(s.total_latency, 0)) > 0\', 100, \'table_schema,table_name\'), (\'schema_tables_with_full_table_scans\', \'%{TABLE}.rows_full_scanned DESC\', \'(e.rows_full_scanned-IFNULL(s.rows_full_scanned, 0)) DESC\', \'(e.rows_full_scanned-IFNULL(s.rows_full_scanned, 0)) > 0\', 100, \'object_schema,object_name\'), (\'user_summary\'                       , \'%{TABLE}.statement_latency DESC\', \'(e.statement_latency-IFNULL(s.statement_latency, 0)) DESC\', \'(e.statements - IFNULL(s.statements, 0)) > 0\', NULL, \'user\'), (\'user_summary_by_file_io\'            , \'%{TABLE}.io_latency DESC\', \'(e.io_latency-IFNULL(s.io_latency, 0)) DESC\', \'(e.ios - IFNULL(s.ios, 0)) > 0\', NULL, \'user\'), (\'user_summary_by_file_io_type\'       , \'%{TABLE}.user, %{TABLE}.latency DESC\', \'e.user, (e.latency-IFNULL(s.latency, 0)) DESC\', \'(e.total - IFNULL(s.total, 0)) > 0\', NULL, \'user,event_name\'), (\'user_summary_by_stages\'             , \'%{TABLE}.user, %{TABLE}.total_latency DESC\', \'e.user, (e.total_latency-IFNULL(s.total_latency, 0)) DESC\', \'(e.total - IFNULL(s.total, 0)) > 0\', NULL, \'user,event_name\'), (\'user_summary_by_statement_latency\'  , \'%{TABLE}.total_latency DESC\', \'(e.total_latency-IFNULL(s.total_latency, 0)) DESC\', \'(e.total - IFNULL(s.total, 0)) > 0\', NULL, \'user\'), (\'user_summary_by_statement_type\'     , \'%{TABLE}.user, %{TABLE}.total_latency DESC\', \'e.user, (e.total_latency-IFNULL(s.total_latency, 0)) DESC\', \'(e.total - IFNULL(s.total, 0)) > 0\', NULL, \'user,statement\'), (\'wait_classes_global_by_avg_latency\' , \'IFNULL(%{TABLE}.total_latency / NULLIF(%{TABLE}.total, 0), 0) DESC\', \'IFNULL((e.total_latency-IFNULL(s.total_latency, 0)) / NULLIF((e.total - IFNULL(s.total, 0)), 0), 0) DESC\', \'(e.total - IFNULL(s.total, 0)) > 0\', NULL, \'event_class\'), (\'wait_classes_global_by_latency\'     , \'%{TABLE}.total_latency DESC\', \'(e.total_latency-IFNULL(s.total_latency, 0)) DESC\', \'(e.total - IFNULL(s.total, 0)) > 0\', NULL, \'event_class\'), (\'waits_by_host_by_latency\'           , \'%{TABLE}.host, %{TABLE}.total_latency DESC\', \'e.host, (e.total_latency-IFNULL(s.total_latency, 0)) DESC\', \'(e.total - IFNULL(s.total, 0)) > 0\', NULL, \'host,event\'), (\'waits_by_user_by_latency\'           , \'%{TABLE}.user, %{TABLE}.total_latency DESC\', \'e.user, (e.total_latency-IFNULL(s.total_latency, 0)) DESC\', \'(e.total - IFNULL(s.total, 0)) > 0\', NULL, \'user,event\'), (\'waits_global_by_latency\'            , \'%{TABLE}.total_latency DESC\', \'(e.total_latency-IFNULL(s.total_latency, 0)) DESC\', \'(e.total - IFNULL(s.total, 0)) > 0\', NULL, \'events\') ; END IF;   SELECT \'  =======================  Configuration  =======================  \' AS \'\'; SELECT \'GLOBAL VARIABLES\' AS \'The following output is:\'; IF (v_has_ps_vars = \'YES\') THEN SELECT LOWER(VARIABLE_NAME) AS Variable_name, VARIABLE_VALUE AS Variable_value FROM performance_schema.global_variables ORDER BY VARIABLE_NAME; ELSE SELECT LOWER(VARIABLE_NAME) AS Variable_name, VARIABLE_VALUE AS Variable_value FROM information_schema.GLOBAL_VARIABLES ORDER BY VARIABLE_NAME; END IF;  IF (v_has_ps = \'YES\') THEN SELECT \'Performance Schema Setup - Actors\' AS \'The following output is:\'; SELECT * FROM performance_schema.setup_actors;  SELECT \'Performance Schema Setup - Consumers\' AS \'The following output is:\'; SELECT NAME AS Consumer, ENABLED, sys.ps_is_consumer_enabled(NAME) AS COLLECTS FROM performance_schema.setup_consumers;  SELECT \'Performance Schema Setup - Instruments\' AS \'The following output is:\'; SELECT SUBSTRING_INDEX(NAME, \'/\', 2) AS \'InstrumentClass\', ROUND(100*SUM(IF(ENABLED = \'YES\', 1, 0))/COUNT(*), 2) AS \'EnabledPct\', ROUND(100*SUM(IF(TIMED = \'YES\', 1, 0))/COUNT(*), 2) AS \'TimedPct\' FROM performance_schema.setup_instruments GROUP BY SUBSTRING_INDEX(NAME, \'/\', 2) ORDER BY SUBSTRING_INDEX(NAME, \'/\', 2);  SELECT \'Performance Schema Setup - Objects\' AS \'The following output is:\'; SELECT * FROM performance_schema.setup_objects;  SELECT \'Performance Schema Setup - Threads\' AS \'The following output is:\'; SELECT `TYPE` AS ThreadType, COUNT(*) AS \'Total\', ROUND(100*SUM(IF(INSTRUMENTED = \'YES\', 1, 0))/COUNT(*), 2) AS \'InstrumentedPct\' FROM performance_schema.threads GROUP BY TYPE; END IF;   IF (v_has_replication = \'NO\') THEN SELECT \'No Replication Configured\' AS \'Replication Status\'; ELSE SELECT CONCAT(\'Replication Configured: \', v_has_replication, \' - Performance Schema Replication Tables: \', v_has_ps_replication) AS \'Replication Status\';  IF (v_has_ps_replication = \'YES\') THEN SELECT \'Replication - Connection Configuration\' AS \'The following output is:\'; SELECT * FROM performance_schema.replication_connection_configuration ORDER BY CHANNEL_NAME ; END IF;  IF (v_has_ps_replication = \'YES\') THEN SELECT \'Replication - Applier Configuration\' AS \'The following output is:\'; SELECT * FROM performance_schema.replication_applier_configuration ORDER BY CHANNEL_NAME; END IF;  IF (@@master_info_repository = \'TABLE\') THEN SELECT \'Replication - Master Info Repository Configuration\' AS \'The following output is:\'; SELECT  Channel_name, Host, User_name, Port, Connect_retry, Enabled_ssl, Ssl_ca, Ssl_capath, Ssl_cert, Ssl_cipher, Ssl_key, Ssl_verify_server_cert, Heartbeat, Bind, Ignored_server_ids, Uuid, Retry_count, Ssl_crl, Ssl_crlpath, Tls_version, Enabled_auto_position FROM mysql.slave_master_info ORDER BY Channel_name ; END IF;  IF (@@relay_log_info_repository = \'TABLE\') THEN SELECT \'Replication - Relay Log Repository Configuration\' AS \'The following output is:\'; SELECT  Channel_name, Sql_delay, Number_of_workers, Id FROM mysql.slave_relay_log_info ORDER BY Channel_name ; END IF; END IF;   IF (v_has_ndb IN (\'DEFAULT\', \'YES\')) THEN SELECT \'Cluster Thread Blocks\' AS \'The following output is:\'; SELECT * FROM ndbinfo.threadblocks; END IF;  IF (v_has_ps = \'YES\') THEN IF (@sys.diagnostics.include_raw = \'ON\') THEN SELECT \'  ========================  Initial Status  ========================  \' AS \'\'; END IF;  DROP TEMPORARY TABLE IF EXISTS tmp_digests_start; CALL sys.statement_performance_analyzer(\'create_tmp\', \'tmp_digests_start\', NULL); CALL sys.statement_performance_analyzer(\'snapshot\', NULL, NULL); CALL sys.statement_performance_analyzer(\'save\', \'tmp_digests_start\', NULL);  IF (@sys.diagnostics.include_raw = \'ON\') THEN SET @sys.diagnostics.sql = REPLACE(@sys.diagnostics.sql_gen_query_template, \'%{OUTPUT}\', \'start\'); IF (@sys.debug = \'ON\') THEN SELECT \'The following query will be used to generate the query for each sys view\' AS \'Debug\'; SELECT @sys.diagnostics.sql AS \'Debug\'; END IF; PREPARE stmt_gen_query FROM @sys.diagnostics.sql; END IF; SET v_done = FALSE; OPEN c_sysviews_w_delta; c_sysviews_w_delta_loop: LOOP FETCH c_sysviews_w_delta INTO v_table_name; IF v_done THEN LEAVE c_sysviews_w_delta_loop; END IF;  IF (@sys.debug = \'ON\') THEN SELECT CONCAT(\'The following queries are for storing the initial content of \', v_table_name) AS \'Debug\'; END IF;  CALL sys.execute_prepared_stmt(CONCAT(\'DROP TEMPORARY TABLE IF EXISTS `tmp_\', v_table_name, \'_start`\')); CALL sys.execute_prepared_stmt(CONCAT(\'CREATE TEMPORARY TABLE `tmp_\', v_table_name, \'_start` SELECT * FROM `sys`.`x$\', v_table_name, \'`\'));  IF (@sys.diagnostics.include_raw = \'ON\') THEN SET @sys.diagnostics.table_name = CONCAT(\'x$\', v_table_name); EXECUTE stmt_gen_query USING @sys.diagnostics.table_name; SELECT CONCAT(@sys.diagnostics.sql_select, IF(order_by IS NOT NULL, CONCAT(\'\\n ORDER BY \', REPLACE(order_by, \'%{TABLE}\', CONCAT(\'tmp_\', v_table_name, \'_start\'))), \'\'), IF(limit_rows IS NOT NULL, CONCAT(\'\\n LIMIT \', limit_rows), \'\') ) INTO @sys.diagnostics.sql_select FROM tmp_sys_views_delta WHERE TABLE_NAME = v_table_name; SELECT CONCAT(\'Initial \', v_table_name) AS \'The following output is:\'; CALL sys.execute_prepared_stmt(@sys.diagnostics.sql_select); END IF; END LOOP; CLOSE c_sysviews_w_delta;  IF (@sys.diagnostics.include_raw = \'ON\') THEN DEALLOCATE PREPARE stmt_gen_query; END IF; END IF;  SET v_sql_status_summary_select = \'SELECT Variable_name\', v_sql_status_summary_delta  = \'\', v_sql_status_summary_from   = \'\';  REPEAT  SET v_output_count = v_output_count + 1; IF (v_output_count > 1) THEN SET v_sleep = in_interval-(UNIX_TIMESTAMP(NOW(2))-v_iter_start); SELECT NOW() AS \'Time\', CONCAT(\'Going to sleep for \', v_sleep, \' seconds. Please do not interrupt\') AS \'The following output is:\'; DO SLEEP(in_interval); END IF; SET v_iter_start = UNIX_TIMESTAMP(NOW(2));  SELECT NOW(), CONCAT(\'Iteration Number \', IFNULL(v_output_count, \'NULL\')) AS \'The following output is:\';  IF (@@log_bin = 1) THEN SELECT \'SHOW MASTER STATUS\' AS \'The following output is:\'; SHOW MASTER STATUS; END IF;  IF (v_has_replication <> \'NO\') THEN SELECT \'SHOW SLAVE STATUS\' AS \'The following output is:\'; SHOW SLAVE STATUS;  IF (v_has_ps_replication = \'YES\') THEN SELECT \'Replication Connection Status\' AS \'The following output is:\'; SELECT * FROM performance_schema.replication_connection_status;  SELECT \'Replication Applier Status\' AS \'The following output is:\'; SELECT * FROM performance_schema.replication_applier_status ORDER BY CHANNEL_NAME;  SELECT \'Replication Applier Status - Coordinator\' AS \'The following output is:\'; SELECT * FROM performance_schema.replication_applier_status_by_coordinator ORDER BY CHANNEL_NAME;  SELECT \'Replication Applier Status - Worker\' AS \'The following output is:\'; SELECT * FROM performance_schema.replication_applier_status_by_worker ORDER BY CHANNEL_NAME, WORKER_ID; END IF;  IF (@@master_info_repository = \'TABLE\') THEN SELECT \'Replication - Master Log Status\' AS \'The following output is:\'; SELECT Master_log_name, Master_log_pos FROM mysql.slave_master_info; END IF;  IF (@@relay_log_info_repository = \'TABLE\') THEN SELECT \'Replication - Relay Log Status\' AS \'The following output is:\'; SELECT sys.format_path(Relay_log_name) AS Relay_log_name, Relay_log_pos, Master_log_name, Master_log_pos FROM mysql.slave_relay_log_info;  SELECT \'Replication - Worker Status\' AS \'The following output is:\'; SELECT Id, sys.format_path(Relay_log_name) AS Relay_log_name, Relay_log_pos, Master_log_name, Master_log_pos, sys.format_path(Checkpoint_relay_log_name) AS Checkpoint_relay_log_name, Checkpoint_relay_log_pos, Checkpoint_master_log_name, Checkpoint_master_log_pos, Checkpoint_seqno, Checkpoint_group_size, HEX(Checkpoint_group_bitmap) AS Checkpoint_group_bitmap , Channel_name FROM mysql.slave_worker_info ORDER BY  Channel_name, Id; END IF; END IF;  SET v_table_name = CONCAT(\'tmp_metrics_\', v_output_count); CALL sys.execute_prepared_stmt(CONCAT(\'DROP TEMPORARY TABLE IF EXISTS \', v_table_name));  CALL sys.execute_prepared_stmt(CONCAT(\'CREATE TEMPORARY TABLE \', v_table_name, \' ( Variable_name VARCHAR(193) NOT NULL, Variable_value VARCHAR(1024), Type VARCHAR(225) NOT NULL, Enabled ENUM(\'\'YES\'\', \'\'NO\'\', \'\'PARTIAL\'\') NOT NULL, PRIMARY KEY (Type, Variable_name) ) ENGINE = InnoDB DEFAULT CHARSET=utf8\'));  IF (v_has_metrics) THEN SET @sys.diagnostics.sql = CONCAT( \'INSERT INTO \', v_table_name, \' SELECT Variable_name, REPLACE(Variable_value, \'\'\\n\'\', \'\'\\\\\\\\n\'\') AS Variable_value, Type, Enabled FROM sys.metrics\' ); ELSE SET @sys.diagnostics.sql = CONCAT( \'INSERT INTO \', v_table_name, \'(SELECT LOWER(VARIABLE_NAME) AS Variable_name, REPLACE(VARIABLE_VALUE, \'\'\\n\'\', \'\'\\\\\\\\n\'\') AS Variable_value, \'\'Global Status\'\' AS Type, \'\'YES\'\' AS Enabled FROM performance_schema.global_status ) UNION ALL ( SELECT NAME AS Variable_name, COUNT AS Variable_value, CONCAT(\'\'InnoDB Metrics - \'\', SUBSYSTEM) AS Type, IF(STATUS = \'\'enabled\'\', \'\'YES\'\', \'\'NO\'\') AS Enabled FROM information_schema.INNODB_METRICS WHERE NAME NOT IN ( \'\'lock_row_lock_time\'\', \'\'lock_row_lock_time_avg\'\', \'\'lock_row_lock_time_max\'\', \'\'lock_row_lock_waits\'\', \'\'buffer_pool_reads\'\', \'\'buffer_pool_read_requests\'\', \'\'buffer_pool_write_requests\'\', \'\'buffer_pool_wait_free\'\', \'\'buffer_pool_read_ahead\'\', \'\'buffer_pool_read_ahead_evicted\'\', \'\'buffer_pool_pages_total\'\', \'\'buffer_pool_pages_misc\'\', \'\'buffer_pool_pages_data\'\', \'\'buffer_pool_bytes_data\'\', \'\'buffer_pool_pages_dirty\'\', \'\'buffer_pool_bytes_dirty\'\', \'\'buffer_pool_pages_free\'\', \'\'buffer_pages_created\'\', \'\'buffer_pages_written\'\', \'\'buffer_pages_read\'\', \'\'buffer_data_reads\'\', \'\'buffer_data_written\'\', \'\'file_num_open_files\'\', \'\'os_log_bytes_written\'\', \'\'os_log_fsyncs\'\', \'\'os_log_pending_fsyncs\'\', \'\'os_log_pending_writes\'\', \'\'log_waits\'\', \'\'log_write_requests\'\', \'\'log_writes\'\', \'\'innodb_dblwr_writes\'\', \'\'innodb_dblwr_pages_written\'\', \'\'innodb_page_size\'\') ) UNION ALL ( SELECT \'\'NOW()\'\' AS Variable_name, NOW(3) AS Variable_value, \'\'System Time\'\' AS Type, \'\'YES\'\' AS Enabled ) UNION ALL ( SELECT \'\'UNIX_TIMESTAMP()\'\' AS Variable_name, ROUND(UNIX_TIMESTAMP(NOW(3)), 3) AS Variable_value, \'\'System Time\'\' AS Type, \'\'YES\'\' AS Enabled ) ORDER BY Type, Variable_name;\' ); END IF; CALL sys.execute_prepared_stmt(@sys.diagnostics.sql);  CALL sys.execute_prepared_stmt( CONCAT(\'(SELECT Variable_value INTO @sys.diagnostics.output_time FROM \', v_table_name, \' WHERE Type = \'\'System Time\'\' AND Variable_name = \'\'UNIX_TIMESTAMP()\'\')\') ); SET v_output_time = @sys.diagnostics.output_time;  SET v_sql_status_summary_select = CONCAT(v_sql_status_summary_select, \', CONCAT( LEFT(s\', v_output_count, \'.Variable_value, \', v_status_summary_width, \'), IF(\', REPLACE(v_no_delta_names, \'%{COUNT}\', v_output_count), \' AND s\', v_output_count, \'.Variable_value REGEXP \'\'^[0-9]+(\\\\\\\\.[0-9]+)?$\'\', CONCAT(\'\' (\'\', ROUND(s\', v_output_count, \'.Variable_value/\', v_output_time, \', 2), \'\'/sec)\'\'), \'\'\'\') ) AS \'\'Output \', v_output_count, \'\'\'\'), v_sql_status_summary_from   = CONCAT(v_sql_status_summary_from, \' \', IF(v_output_count = 1, \'  FROM \', \'       INNER JOIN \'), v_table_name, \' s\', v_output_count, IF (v_output_count = 1, \'\', \' USING (Type, Variable_name)\')); IF (v_output_count > 1) THEN SET v_sql_status_summary_delta  = CONCAT(v_sql_status_summary_delta, \', IF(\', REPLACE(v_no_delta_names, \'%{COUNT}\', v_output_count), \' AND s\', (v_output_count-1), \'.Variable_value REGEXP \'\'^[0-9]+(\\\\\\\\.[0-9]+)?$\'\' AND s\', v_output_count, \'.Variable_value REGEXP \'\'^[0-9]+(\\\\\\\\.[0-9]+)?$\'\', CONCAT(IF(s\', (v_output_count-1), \'.Variable_value REGEXP \'\'^[0-9]+\\\\\\\\.[0-9]+$\'\' OR s\', v_output_count, \'.Variable_value REGEXP \'\'^[0-9]+\\\\\\\\.[0-9]+$\'\', ROUND((s\', v_output_count, \'.Variable_value-s\', (v_output_count-1), \'.Variable_value), 2), (s\', v_output_count, \'.Variable_value-s\', (v_output_count-1), \'.Variable_value) ), \'\' (\'\', ROUND((s\', v_output_count, \'.Variable_value-s\', (v_output_count-1), \'.Variable_value)/(\', v_output_time, \'-\', v_output_time_prev, \'), 2), \'\'/sec)\'\' ), \'\'\'\' ) AS \'\'Delta (\', (v_output_count-1), \' -> \', v_output_count, \')\'\'\'); END IF;  SET v_output_time_prev = v_output_time;  IF (@sys.diagnostics.include_raw = \'ON\') THEN IF (v_has_metrics) THEN SELECT \'SELECT * FROM sys.metrics\' AS \'The following output is:\'; ELSE SELECT \'sys.metrics equivalent\' AS \'The following output is:\'; END IF; CALL sys.execute_prepared_stmt(CONCAT(\'SELECT Type, Variable_name, Enabled, Variable_value FROM \', v_table_name, \' ORDER BY Type, Variable_name\')); END IF;  IF (v_has_innodb IN (\'DEFAULT\', \'YES\')) THEN SELECT \'SHOW ENGINE INNODB STATUS\' AS \'The following output is:\'; EXECUTE stmt_innodb_status; SELECT \'InnoDB - Transactions\' AS \'The following output is:\'; SELECT * FROM information_schema.INNODB_TRX; END IF;  IF (v_has_ndb IN (\'DEFAULT\', \'YES\')) THEN SELECT \'SHOW ENGINE NDBCLUSTER STATUS\' AS \'The following output is:\'; EXECUTE stmt_ndbcluster_status;  SELECT \'ndbinfo.memoryusage\' AS \'The following output is:\'; SELECT node_id, memory_type, sys.format_bytes(used) AS used, used_pages, sys.format_bytes(total) AS total, total_pages, ROUND(100*(used/total), 2) AS \'Used %\' FROM ndbinfo.memoryusage;  SET v_done = FALSE; OPEN c_ndbinfo; c_ndbinfo_loop: LOOP FETCH c_ndbinfo INTO v_table_name; IF v_done THEN LEAVE c_ndbinfo_loop; END IF;  SELECT CONCAT(\'SELECT * FROM ndbinfo.\', v_table_name) AS \'The following output is:\'; CALL sys.execute_prepared_stmt(CONCAT(\'SELECT * FROM `ndbinfo`.`\', v_table_name, \'`\')); END LOOP; CLOSE c_ndbinfo;  SELECT * FROM information_schema.FILES; END IF;  SELECT \'SELECT * FROM sys.processlist\' AS \'The following output is:\'; SELECT processlist.* FROM sys.processlist;  IF (v_has_ps = \'YES\') THEN IF (sys.ps_is_consumer_enabled(\'events_waits_history_long\') = \'YES\') THEN SELECT \'SELECT * FROM sys.latest_file_io\' AS \'The following output is:\'; SELECT * FROM sys.latest_file_io; END IF;  IF (EXISTS(SELECT 1 FROM performance_schema.setup_instruments WHERE NAME LIKE \'memory/%\' AND ENABLED = \'YES\')) THEN SELECT \'SELECT * FROM sys.memory_by_host_by_current_bytes\' AS \'The following output is:\'; SELECT * FROM sys.memory_by_host_by_current_bytes;  SELECT \'SELECT * FROM sys.memory_by_thread_by_current_bytes\' AS \'The following output is:\'; SELECT * FROM sys.memory_by_thread_by_current_bytes;  SELECT \'SELECT * FROM sys.memory_by_user_by_current_bytes\' AS \'The following output is:\'; SELECT * FROM sys.memory_by_user_by_current_bytes;  SELECT \'SELECT * FROM sys.memory_global_by_current_bytes\' AS \'The following output is:\'; SELECT * FROM sys.memory_global_by_current_bytes; END IF; END IF;  SET v_runtime = (UNIX_TIMESTAMP(NOW(2)) - v_start); UNTIL (v_runtime + in_interval >= in_max_runtime) END REPEAT;  IF (v_has_ps = \'YES\') THEN SELECT \'SHOW ENGINE PERFORMANCE_SCHEMA STATUS\' AS \'The following output is:\'; EXECUTE stmt_ps_status; END IF;  IF (v_has_innodb IN (\'DEFAULT\', \'YES\')) THEN DEALLOCATE PREPARE stmt_innodb_status; END IF; IF (v_has_ps = \'YES\') THEN DEALLOCATE PREPARE stmt_ps_status; END IF; IF (v_has_ndb IN (\'DEFAULT\', \'YES\')) THEN DEALLOCATE PREPARE stmt_ndbcluster_status; END IF;   SELECT \'  ============================  Schema Information  ============================  \' AS \'\';  SELECT COUNT(*) AS \'Total Number of Tables\' FROM information_schema.TABLES;  IF (@sys.diagnostics.allow_i_s_tables = \'ON\') THEN SELECT \'Storage Engine Usage\' AS \'The following output is:\'; SELECT ENGINE, COUNT(*) AS NUM_TABLES, sys.format_bytes(SUM(DATA_LENGTH)) AS DATA_LENGTH, sys.format_bytes(SUM(INDEX_LENGTH)) AS INDEX_LENGTH, sys.format_bytes(SUM(DATA_LENGTH+INDEX_LENGTH)) AS TOTAL FROM information_schema.TABLES GROUP BY ENGINE;  SELECT \'Schema Object Overview\' AS \'The following output is:\'; SELECT * FROM sys.schema_object_overview;  SELECT \'Tables without a PRIMARY KEY\' AS \'The following output is:\'; SELECT TABLES.TABLE_SCHEMA, ENGINE, COUNT(*) AS NumTables FROM information_schema.TABLES LEFT OUTER JOIN information_schema.STATISTICS ON STATISTICS.TABLE_SCHEMA = TABLES.TABLE_SCHEMA AND STATISTICS.TABLE_NAME = TABLES.TABLE_NAME AND STATISTICS.INDEX_NAME = \'PRIMARY\' WHERE STATISTICS.TABLE_NAME IS NULL AND TABLES.TABLE_SCHEMA NOT IN (\'mysql\', \'information_schema\', \'performance_schema\', \'sys\') AND TABLES.TABLE_TYPE = \'BASE TABLE\' GROUP BY TABLES.TABLE_SCHEMA, ENGINE; END IF;  IF (v_has_ps = \'YES\') THEN SELECT \'Unused Indexes\' AS \'The following output is:\'; SELECT object_schema, COUNT(*) AS NumUnusedIndexes FROM performance_schema.table_io_waits_summary_by_index_usage  WHERE index_name IS NOT NULL AND count_star = 0 AND object_schema NOT IN (\'mysql\', \'sys\') AND index_name != \'PRIMARY\' GROUP BY object_schema; END IF;  IF (v_has_ps = \'YES\') THEN SELECT \'  =========================  Overall Status  =========================  \' AS \'\';  SELECT \'CALL sys.ps_statement_avg_latency_histogram()\' AS \'The following output is:\'; CALL sys.ps_statement_avg_latency_histogram();  CALL sys.statement_performance_analyzer(\'snapshot\', NULL, NULL); CALL sys.statement_performance_analyzer(\'overall\', NULL, \'with_runtimes_in_95th_percentile\');  SET @sys.diagnostics.sql = REPLACE(@sys.diagnostics.sql_gen_query_template, \'%{OUTPUT}\', \'end\'); IF (@sys.debug = \'ON\') THEN SELECT \'The following query will be used to generate the query for each sys view\' AS \'Debug\'; SELECT @sys.diagnostics.sql AS \'Debug\'; END IF; PREPARE stmt_gen_query FROM @sys.diagnostics.sql;  SET v_done = FALSE; OPEN c_sysviews_w_delta; c_sysviews_w_delta_loop: LOOP FETCH c_sysviews_w_delta INTO v_table_name; IF v_done THEN LEAVE c_sysviews_w_delta_loop; END IF;  IF (@sys.debug = \'ON\') THEN SELECT CONCAT(\'The following queries are for storing the final content of \', v_table_name) AS \'Debug\'; END IF;  CALL sys.execute_prepared_stmt(CONCAT(\'DROP TEMPORARY TABLE IF EXISTS `tmp_\', v_table_name, \'_end`\')); CALL sys.execute_prepared_stmt(CONCAT(\'CREATE TEMPORARY TABLE `tmp_\', v_table_name, \'_end` SELECT * FROM `sys`.`x$\', v_table_name, \'`\'));  IF (@sys.diagnostics.include_raw = \'ON\') THEN SET @sys.diagnostics.table_name = CONCAT(\'x$\', v_table_name); EXECUTE stmt_gen_query USING @sys.diagnostics.table_name; SELECT CONCAT(@sys.diagnostics.sql_select, IF(order_by IS NOT NULL, CONCAT(\'\\n ORDER BY \', REPLACE(order_by, \'%{TABLE}\', CONCAT(\'tmp_\', v_table_name, \'_end\'))), \'\'), IF(limit_rows IS NOT NULL, CONCAT(\'\\n LIMIT \', limit_rows), \'\') ) INTO @sys.diagnostics.sql_select FROM tmp_sys_views_delta WHERE TABLE_NAME = v_table_name; SELECT CONCAT(\'Overall \', v_table_name) AS \'The following output is:\'; CALL sys.execute_prepared_stmt(@sys.diagnostics.sql_select); END IF; END LOOP; CLOSE c_sysviews_w_delta;  DEALLOCATE PREPARE stmt_gen_query;   SELECT \'  ======================  Delta Status  ======================  \' AS \'\';  CALL sys.statement_performance_analyzer(\'delta\', \'tmp_digests_start\', \'with_runtimes_in_95th_percentile\'); CALL sys.statement_performance_analyzer(\'cleanup\', NULL, NULL);  DROP TEMPORARY TABLE tmp_digests_start;  IF (@sys.debug = \'ON\') THEN SELECT \'The following query will be used to generate the query for each sys view delta\' AS \'Debug\'; SELECT @sys.diagnostics.sql_gen_query_delta AS \'Debug\'; END IF; PREPARE stmt_gen_query_delta FROM @sys.diagnostics.sql_gen_query_delta;  SET v_old_group_concat_max_len = @@session.group_concat_max_len; SET @@session.group_concat_max_len = 2048; SET v_done = FALSE; OPEN c_sysviews_w_delta; c_sysviews_w_delta_loop: LOOP FETCH c_sysviews_w_delta INTO v_table_name; IF v_done THEN LEAVE c_sysviews_w_delta_loop; END IF;  SET @sys.diagnostics.table_name = v_table_name; EXECUTE stmt_gen_query_delta USING @sys.diagnostics.table_name; SELECT CONCAT(@sys.diagnostics.sql_select, IF(where_delta IS NOT NULL, CONCAT(\'\\n WHERE \', where_delta), \'\'), IF(order_by_delta IS NOT NULL, CONCAT(\'\\n ORDER BY \', order_by_delta), \'\'), IF(limit_rows IS NOT NULL, CONCAT(\'\\n LIMIT \', limit_rows), \'\') ) INTO @sys.diagnostics.sql_select FROM tmp_sys_views_delta WHERE TABLE_NAME = v_table_name;  SELECT CONCAT(\'Delta \', v_table_name) AS \'The following output is:\'; CALL sys.execute_prepared_stmt(@sys.diagnostics.sql_select);  CALL sys.execute_prepared_stmt(CONCAT(\'DROP TEMPORARY TABLE `tmp_\', v_table_name, \'_end`\')); CALL sys.execute_prepared_stmt(CONCAT(\'DROP TEMPORARY TABLE `tmp_\', v_table_name, \'_start`\')); END LOOP; CLOSE c_sysviews_w_delta; SET @@session.group_concat_max_len = v_old_group_concat_max_len;  DEALLOCATE PREPARE stmt_gen_query_delta; DROP TEMPORARY TABLE tmp_sys_views_delta; END IF;  IF (v_has_metrics) THEN SELECT \'SELECT * FROM sys.metrics\' AS \'The following output is:\'; ELSE SELECT \'sys.metrics equivalent\' AS \'The following output is:\'; END IF; CALL sys.execute_prepared_stmt( CONCAT(v_sql_status_summary_select, v_sql_status_summary_delta, \', Type, s1.Enabled\', v_sql_status_summary_from, \' ORDER BY Type, Variable_name\' ) );  SET v_count = 0; WHILE (v_count < v_output_count) DO SET v_count = v_count + 1; SET v_table_name = CONCAT(\'tmp_metrics_\', v_count); CALL sys.execute_prepared_stmt(CONCAT(\'DROP TEMPORARY TABLE IF EXISTS \', v_table_name)); END WHILE;  IF (in_auto_config <> \'current\') THEN CALL sys.ps_setup_reload_saved(); SET sql_log_bin = @log_bin; END IF;  SET @sys.diagnostics.output_time            = NULL, @sys.diagnostics.sql                    = NULL, @sys.diagnostics.sql_gen_query_delta    = NULL, @sys.diagnostics.sql_gen_query_template = NULL, @sys.diagnostics.sql_select             = NULL, @sys.diagnostics.table_name             = NULL;  IF (v_this_thread_enabled = \'YES\') THEN CALL sys.ps_setup_enable_thread(CONNECTION_ID()); END IF;  IF (@log_bin = 1) THEN SET sql_log_bin = @log_bin; END IF; END','mysql.sys@localhost','2017-03-02 18:46:53','2017-03-02 18:46:53','','\n Description\n \n Create a report of the current status of the server for diagnostics purposes. Data collected includes (some items depends on versions and settings):\n \n * The GLOBAL VARIABLES\n * Several sys schema views including metrics or equivalent (depending on version and settings)\n * Queries in the 95th percentile\n * Several ndbinfo views for MySQL Cluster\n * Replication (both master and slave) information.\n \n Some of the sys schema views are calculated as initial (optional), overall, delta:\n \n * The initial view is the content of the view at the start of this procedure.\n This output will be the same as the the start values used for the delta view.\n The initial view is included if @sys.diagnostics.include_raw = \'ON\'.\n * The overall view is the content of the view at the end of this procedure.\n This output is the same as the end values used for the delta view.\n The overall view is always included.\n * The delta view is the difference from the beginning to the end. Note that for min and max values\n they are simply the min or max value from the end view respectively, so does not necessarily reflect\n the minimum/maximum value in the monitored period.\n Note: except for the metrics views the delta is only calculation between the first and last outputs.\n \n Requires the SUPER privilege for \"SET sql_log_bin = 0;\".\n \n Versions supported:\n * MySQL 5.6: 5.6.10 and later\n * MySQL 5.7: 5.7.9 and later\n \n Parameters\n \n in_max_runtime (INT UNSIGNED):\n The maximum time to keep collecting data.\n Use NULL to get the default which is 60 seconds, otherwise enter a value greater than 0.\n in_interval (INT UNSIGNED):\n How long to sleep between data collections.\n Use NULL to get the default which is 30 seconds, otherwise enter a value greater than 0.\n in_auto_config (ENUM(\'current\', \'medium\', \'full\'))\n Automatically enable Performance Schema instruments and consumers.\n NOTE: The more that are enabled, the more impact on the performance.\n Supported values are:\n * current - use the current settings.\n * medium - enable some settings.\n * full - enables all settings. This will have a big impact on the\n performance - be careful using this option.\n If another setting the \'current\' is chosen, the current settings\n are restored at the end of the procedure.\n \n \n Configuration Options\n \n sys.diagnostics.allow_i_s_tables\n Specifies whether it is allowed to do table scan queries on information_schema.TABLES. This can be expensive if there\n are many tables. Set to \'ON\' to allow, \'OFF\' to not allow.\n Default is \'OFF\'.\n \n sys.diagnostics.include_raw\n Set to \'ON\' to include the raw data (e.g. the original output of \"SELECT * FROM sys.metrics\").\n Use this to get the initial values of the various views.\n Default is \'OFF\'.\n \n sys.statement_truncate_len\n How much of queries in the process list output to include.\n Default is 64.\n \n sys.debug\n Whether to provide debugging output.\n Default is \'OFF\'. Set to \'ON\' to include.\n \n \n Example\n \n To create a report and append it to the file diag.out:\n \n mysql> TEE diag.out;\n mysql> CALL sys.diagnostics(120, 30, \'current\');\n ...\n mysql> NOTEE;\n ','utf8','utf8_general_ci','utf8_general_ci',_binary 'BEGIN DECLARE v_start, v_runtime, v_iter_start, v_sleep DECIMAL(20,2) DEFAULT 0.0; DECLARE v_has_innodb, v_has_ndb, v_has_ps, v_has_replication, v_has_ps_replication VARCHAR(8) CHARSET utf8 DEFAULT \'NO\'; DECLARE v_this_thread_enabled, v_has_ps_vars, v_has_metrics ENUM(\'YES\', \'NO\'); DECLARE v_table_name, v_banner VARCHAR(64) CHARSET utf8; DECLARE v_sql_status_summary_select, v_sql_status_summary_delta, v_sql_status_summary_from, v_no_delta_names TEXT; DECLARE v_output_time, v_output_time_prev DECIMAL(20,3) UNSIGNED; DECLARE v_output_count, v_count, v_old_group_concat_max_len INT UNSIGNED DEFAULT 0; DECLARE v_status_summary_width TINYINT UNSIGNED DEFAULT 50; DECLARE v_done BOOLEAN DEFAULT FALSE; DECLARE c_ndbinfo CURSOR FOR SELECT TABLE_NAME FROM information_schema.TABLES WHERE TABLE_SCHEMA = \'ndbinfo\' AND TABLE_NAME NOT IN ( \'blocks\', \'config_params\', \'dict_obj_types\', \'disk_write_speed_base\', \'memory_per_fragment\', \'memoryusage\', \'operations_per_fragment\', \'threadblocks\' ); DECLARE c_sysviews_w_delta CURSOR FOR SELECT table_name FROM tmp_sys_views_delta ORDER BY table_name;  DECLARE CONTINUE HANDLER FOR NOT FOUND SET v_done = TRUE;  SELECT INSTRUMENTED INTO v_this_thread_enabled FROM performance_schema.threads WHERE PROCESSLIST_ID = CONNECTION_ID(); IF (v_this_thread_enabled = \'YES\') THEN CALL sys.ps_setup_disable_thread(CONNECTION_ID()); END IF;  IF (in_max_runtime < in_interval) THEN SIGNAL SQLSTATE \'45000\' SET MESSAGE_TEXT = \'in_max_runtime must be greater than or equal to in_interval\'; END IF; IF (in_max_runtime = 0) THEN SIGNAL SQLSTATE \'45000\' SET MESSAGE_TEXT = \'in_max_runtime must be greater than 0\'; END IF; IF (in_interval = 0) THEN SIGNAL SQLSTATE \'45000\' SET MESSAGE_TEXT = \'in_interval must be greater than 0\'; END IF;  IF (@sys.diagnostics.allow_i_s_tables IS NULL) THEN SET @sys.diagnostics.allow_i_s_tables = sys.sys_get_config(\'diagnostics.allow_i_s_tables\', \'OFF\'); END IF; IF (@sys.diagnostics.include_raw IS NULL) THEN SET @sys.diagnostics.include_raw      = sys.sys_get_config(\'diagnostics.include_raw\'     , \'OFF\'); END IF; IF (@sys.debug IS NULL) THEN SET @sys.debug                        = sys.sys_get_config(\'debug\'                       , \'OFF\'); END IF; IF (@sys.statement_truncate_len IS NULL) THEN SET @sys.statement_truncate_len       = sys.sys_get_config(\'statement_truncate_len\'      , \'64\' ); END IF;  SET @log_bin := @@sql_log_bin; IF (@log_bin = 1) THEN SET sql_log_bin = 0; END IF;  SET v_no_delta_names = CONCAT(\'s%{COUNT}.Variable_name NOT IN (\', \'\'innodb_buffer_pool_pages_total\', \', \'\'innodb_page_size\', \', \'\'last_query_cost\', \', \'\'last_query_partial_plans\', \', \'\'qcache_total_blocks\', \', \'\'slave_last_heartbeat\', \', \'\'ssl_ctx_verify_depth\', \', \'\'ssl_ctx_verify_mode\', \', \'\'ssl_session_cache_size\', \', \'\'ssl_verify_depth\', \', \'\'ssl_verify_mode\', \', \'\'ssl_version\', \', \'\'buffer_flush_lsn_avg_rate\', \', \'\'buffer_flush_pct_for_dirty\', \', \'\'buffer_flush_pct_for_lsn\', \', \'\'buffer_pool_pages_total\', \', \'\'lock_row_lock_time_avg\', \', \'\'lock_row_lock_time_max\', \', \'\'innodb_page_size\'\', \')\');  IF (in_auto_config <> \'current\') THEN IF (@sys.debug = \'ON\') THEN SELECT CONCAT(\'Updating Performance Schema configuration to \', in_auto_config) AS \'Debug\'; END IF; CALL sys.ps_setup_save(0);  IF (in_auto_config = \'medium\') THEN UPDATE performance_schema.setup_consumers SET ENABLED = \'YES\' WHERE NAME NOT LIKE \'%\\_history%\';  UPDATE performance_schema.setup_instruments SET ENABLED = \'YES\', TIMED   = \'YES\' WHERE NAME NOT LIKE \'wait/synch/%\'; ELSEIF (in_auto_config = \'full\') THEN UPDATE performance_schema.setup_consumers SET ENABLED = \'YES\';  UPDATE performance_schema.setup_instruments SET ENABLED = \'YES\', TIMED   = \'YES\'; END IF;  UPDATE performance_schema.threads SET INSTRUMENTED = \'YES\' WHERE PROCESSLIST_ID <> CONNECTION_ID(); END IF;  SET v_start        = UNIX_TIMESTAMP(NOW(2)), in_interval    = IFNULL(in_interval, 30), in_max_runtime = IFNULL(in_max_runtime, 60);  SET v_banner = REPEAT( \'-\', LEAST( GREATEST( 36, CHAR_LENGTH(VERSION()), CHAR_LENGTH(@@global.version_comment), CHAR_LENGTH(@@global.version_compile_os), CHAR_LENGTH(@@global.version_compile_machine), CHAR_LENGTH(@@global.socket), CHAR_LENGTH(@@global.datadir) ), 64 ) ); SELECT \'Hostname\' AS \'Name\', @@global.hostname AS \'Value\' UNION ALL SELECT \'Port\' AS \'Name\', @@global.port AS \'Value\' UNION ALL SELECT \'Socket\' AS \'Name\', @@global.socket AS \'Value\' UNION ALL SELECT \'Datadir\' AS \'Name\', @@global.datadir AS \'Value\' UNION ALL SELECT \'Server UUID\' AS \'Name\', @@global.server_uuid AS \'Value\' UNION ALL SELECT REPEAT(\'-\', 23) AS \'Name\', v_banner AS \'Value\' UNION ALL SELECT \'MySQL Version\' AS \'Name\', VERSION() AS \'Value\' UNION ALL SELECT \'Sys Schema Version\' AS \'Name\', (SELECT sys_version FROM sys.version) AS \'Value\' UNION ALL SELECT \'Version Comment\' AS \'Name\', @@global.version_comment AS \'Value\' UNION ALL SELECT \'Version Compile OS\' AS \'Name\', @@global.version_compile_os AS \'Value\' UNION ALL SELECT \'Version Compile Machine\' AS \'Name\', @@global.version_compile_machine AS \'Value\' UNION ALL SELECT REPEAT(\'-\', 23) AS \'Name\', v_banner AS \'Value\' UNION ALL SELECT \'UTC Time\' AS \'Name\', UTC_TIMESTAMP() AS \'Value\' UNION ALL SELECT \'Local Time\' AS \'Name\', NOW() AS \'Value\' UNION ALL SELECT \'Time Zone\' AS \'Name\', @@global.time_zone AS \'Value\' UNION ALL SELECT \'System Time Zone\' AS \'Name\', @@global.system_time_zone AS \'Value\' UNION ALL SELECT \'Time Zone Offset\' AS \'Name\', TIMEDIFF(NOW(), UTC_TIMESTAMP()) AS \'Value\';  SET v_has_innodb         = IFNULL((SELECT SUPPORT FROM information_schema.ENGINES WHERE ENGINE = \'InnoDB\'), \'NO\'), v_has_ndb            = IFNULL((SELECT SUPPORT FROM information_schema.ENGINES WHERE ENGINE = \'NDBCluster\'), \'NO\'), v_has_ps             = IFNULL((SELECT SUPPORT FROM information_schema.ENGINES WHERE ENGINE = \'PERFORMANCE_SCHEMA\'), \'NO\'), v_has_ps_replication = IF(v_has_ps = \'YES\' AND EXISTS(SELECT 1 FROM information_schema.TABLES WHERE TABLE_SCHEMA = \'performance_schema\' AND TABLE_NAME = \'replication_applier_status\'), \'YES\', \'NO\' ), v_has_replication    =  IF(v_has_ps_replication = \'YES\', IF((SELECT COUNT(*) FROM performance_schema.replication_connection_status) > 0, \'YES\', \'NO\'), IF(@@master_info_repository = \'TABLE\', IF((SELECT COUNT(*) FROM mysql.slave_master_info) > 0, \'YES\', \'NO\'), IF(@@relay_log_info_repository = \'TABLE\', IF((SELECT COUNT(*) FROM mysql.slave_relay_log_info) > 0, \'YES\', \'NO\'), \'MAYBE\')) ) , v_has_metrics        = IF(v_has_ps = \'YES\' OR (sys.version_major() = 5 AND sys.version_minor() = 6), \'YES\', \'NO\'), v_has_ps_vars        = \'NO\';   SET v_has_ps_vars = IF(@@global.show_compatibility_56, \'NO\', \'YES\');  SET v_has_ps_vars = \'YES\';  IF (@sys.debug = \'ON\') THEN SELECT v_has_innodb AS \'Has_InnoDB\', v_has_ndb AS \'Has_NDBCluster\', v_has_ps AS \'Has_Performance_Schema\', v_has_ps_vars AS \'Has_P_S_SHOW_Variables\', v_has_metrics AS \'Has_metrics\', v_has_ps_replication \'AS Has_P_S_Replication\', v_has_replication AS \'Has_Replication\'; END IF;  IF (v_has_innodb IN (\'DEFAULT\', \'YES\')) THEN SET @sys.diagnostics.sql = \'SHOW ENGINE InnoDB STATUS\'; PREPARE stmt_innodb_status FROM @sys.diagnostics.sql; END IF;  IF (v_has_ps = \'YES\') THEN SET @sys.diagnostics.sql = \'SHOW ENGINE PERFORMANCE_SCHEMA STATUS\'; PREPARE stmt_ps_status FROM @sys.diagnostics.sql; END IF;  IF (v_has_ndb IN (\'DEFAULT\', \'YES\')) THEN SET @sys.diagnostics.sql = \'SHOW ENGINE NDBCLUSTER STATUS\'; PREPARE stmt_ndbcluster_status FROM @sys.diagnostics.sql; END IF;  SET @sys.diagnostics.sql_gen_query_template = \'SELECT CONCAT( \'SELECT \', GROUP_CONCAT( CASE WHEN (SUBSTRING(TABLE_NAME, 3), COLUMN_NAME) IN ( (\'io_global_by_file_by_bytes\', \'total\'), (\'io_global_by_wait_by_bytes\', \'total_requested\') ) THEN CONCAT(\'sys.format_bytes(\', COLUMN_NAME, \') AS \', COLUMN_NAME) WHEN SUBSTRING(COLUMN_NAME, -8) = \'_latency\' THEN CONCAT(\'sys.format_time(\', COLUMN_NAME, \') AS \', COLUMN_NAME) WHEN SUBSTRING(COLUMN_NAME, -7) = \'_memory\' OR SUBSTRING(COLUMN_NAME, -17) = \'_memory_allocated\' OR ((SUBSTRING(COLUMN_NAME, -5) = \'_read\' OR SUBSTRING(COLUMN_NAME, -8) = \'_written\' OR SUBSTRING(COLUMN_NAME, -6) = \'_write\') AND SUBSTRING(COLUMN_NAME, 1, 6) <> \'COUNT_\') THEN CONCAT(\'sys.format_bytes(\', COLUMN_NAME, \') AS \', COLUMN_NAME) ELSE COLUMN_NAME END ORDER BY ORDINAL_POSITION SEPARATOR \',\n       \' ), \'\n  FROM tmp_\', SUBSTRING(TABLE_NAME FROM 3), \'_%{OUTPUT}\' ) AS Query INTO @sys.diagnostics.sql_select FROM information_schema.COLUMNS WHERE TABLE_SCHEMA = \'sys\' AND TABLE_NAME = ? GROUP BY TABLE_NAME\';  SET @sys.diagnostics.sql_gen_query_delta = \'SELECT CONCAT( \'SELECT \', GROUP_CONCAT( CASE WHEN FIND_IN_SET(COLUMN_NAME, diag.pk) THEN COLUMN_NAME WHEN diag.TABLE_NAME = \'io_global_by_file_by_bytes\' AND COLUMN_NAME = \'write_pct\' THEN CONCAT(\'IFNULL(ROUND(100-(((e.total_read-IFNULL(s.total_read, 0))\', \'/NULLIF(((e.total_read-IFNULL(s.total_read, 0))+(e.total_written-IFNULL(s.total_written, 0))), 0))*100), 2), 0.00) AS \', COLUMN_NAME) WHEN (diag.TABLE_NAME, COLUMN_NAME) IN ( (\'io_global_by_file_by_bytes\', \'total\'), (\'io_global_by_wait_by_bytes\', \'total_requested\') ) THEN CONCAT(\'sys.format_bytes(e.\', COLUMN_NAME, \'-IFNULL(s.\', COLUMN_NAME, \', 0)) AS \', COLUMN_NAME) WHEN SUBSTRING(COLUMN_NAME, 1, 4) IN (\'max_\', \'min_\') AND SUBSTRING(COLUMN_NAME, -8) = \'_latency\' THEN CONCAT(\'sys.format_time(e.\', COLUMN_NAME, \') AS \', COLUMN_NAME) WHEN COLUMN_NAME = \'avg_latency\' THEN CONCAT(\'sys.format_time((e.total_latency - IFNULL(s.total_latency, 0))\', \'/NULLIF(e.total - IFNULL(s.total, 0), 0)) AS \', COLUMN_NAME) WHEN SUBSTRING(COLUMN_NAME, -12) = \'_avg_latency\' THEN CONCAT(\'sys.format_time((e.\', SUBSTRING(COLUMN_NAME FROM 1 FOR CHAR_LENGTH(COLUMN_NAME)-12), \'_latency - IFNULL(s.\', SUBSTRING(COLUMN_NAME FROM 1 FOR CHAR_LENGTH(COLUMN_NAME)-12), \'_latency, 0))\', \'/NULLIF(e.\', SUBSTRING(COLUMN_NAME FROM 1 FOR CHAR_LENGTH(COLUMN_NAME)-12), \'s - IFNULL(s.\', SUBSTRING(COLUMN_NAME FROM 1 FOR CHAR_LENGTH(COLUMN_NAME)-12), \'s, 0), 0)) AS \', COLUMN_NAME) WHEN SUBSTRING(COLUMN_NAME, -8) = \'_latency\' THEN CONCAT(\'sys.format_time(e.\', COLUMN_NAME, \' - IFNULL(s.\', COLUMN_NAME, \', 0)) AS \', COLUMN_NAME) WHEN COLUMN_NAME IN (\'avg_read\', \'avg_write\', \'avg_written\') THEN CONCAT(\'sys.format_bytes(IFNULL((e.total_\', IF(COLUMN_NAME = \'avg_read\', \'read\', \'written\'), \'-IFNULL(s.total_\', IF(COLUMN_NAME = \'avg_read\', \'read\', \'written\'), \', 0))\', \'/NULLIF(e.count_\', IF(COLUMN_NAME = \'avg_read\', \'read\', \'write\'), \'-IFNULL(s.count_\', IF(COLUMN_NAME = \'avg_read\', \'read\', \'write\'), \', 0), 0), 0)) AS \', COLUMN_NAME) WHEN SUBSTRING(COLUMN_NAME, -7) = \'_memory\' OR SUBSTRING(COLUMN_NAME, -17) = \'_memory_allocated\' OR ((SUBSTRING(COLUMN_NAME, -5) = \'_read\' OR SUBSTRING(COLUMN_NAME, -8) = \'_written\' OR SUBSTRING(COLUMN_NAME, -6) = \'_write\') AND SUBSTRING(COLUMN_NAME, 1, 6) <> \'COUNT_\') THEN CONCAT(\'sys.format_bytes(e.\', COLUMN_NAME, \' - IFNULL(s.\', COLUMN_NAME, \', 0)) AS \', COLUMN_NAME) ELSE CONCAT(\'(e.\', COLUMN_NAME, \' - IFNULL(s.\', COLUMN_NAME, \', 0)) AS \', COLUMN_NAME) END ORDER BY ORDINAL_POSITION SEPARATOR \',\n       \' ), \'\n  FROM tmp_\', diag.TABLE_NAME, \'_end e LEFT OUTER JOIN tmp_\', diag.TABLE_NAME, \'_start s USING (\', diag.pk, \')\' ) AS Query INTO @sys.diagnostics.sql_select FROM tmp_sys_views_delta diag INNER JOIN information_schema.COLUMNS c ON c.TABLE_NAME = CONCAT(\'x$\', diag.TABLE_NAME) WHERE c.TABLE_SCHEMA = \'sys\' AND diag.TABLE_NAME = ? GROUP BY diag.TABLE_NAME\';  IF (v_has_ps = \'YES\') THEN DROP TEMPORARY TABLE IF EXISTS tmp_sys_views_delta; CREATE TEMPORARY TABLE tmp_sys_views_delta ( TABLE_NAME varchar(64) NOT NULL, order_by text COMMENT \'ORDER BY clause for the initial and overall views\', order_by_delta text COMMENT \'ORDER BY clause for the delta views\', where_delta text COMMENT \'WHERE clause to use for delta views to only include rows with a \"count\" > 0\', limit_rows int unsigned COMMENT \'The maximum number of rows to include for the view\', pk varchar(128) COMMENT \'Used with the FIND_IN_SET() function so use comma separated list without whitespace\', PRIMARY KEY (TABLE_NAME) );  IF (@sys.debug = \'ON\') THEN SELECT \'Populating tmp_sys_views_delta\' AS \'Debug\'; END IF; INSERT INTO tmp_sys_views_delta VALUES (\'host_summary\'                       , \'%{TABLE}.statement_latency DESC\', \'(e.statement_latency-IFNULL(s.statement_latency, 0)) DESC\', \'(e.statements - IFNULL(s.statements, 0)) > 0\', NULL, \'host\'), (\'host_summary_by_file_io\'            , \'%{TABLE}.io_latency DESC\', \'(e.io_latency-IFNULL(s.io_latency, 0)) DESC\', \'(e.ios - IFNULL(s.ios, 0)) > 0\', NULL, \'host\'), (\'host_summary_by_file_io_type\'       , \'%{TABLE}.host, %{TABLE}.total_latency DESC\', \'e.host, (e.total_latency-IFNULL(s.total_latency, 0)) DESC\', \'(e.total - IFNULL(s.total, 0)) > 0\', NULL, \'host,event_name\'), (\'host_summary_by_stages\'             , \'%{TABLE}.host, %{TABLE}.total_latency DESC\', \'e.host, (e.total_latency-IFNULL(s.total_latency, 0)) DESC\', \'(e.total - IFNULL(s.total, 0)) > 0\', NULL, \'host,event_name\'), (\'host_summary_by_statement_latency\'  , \'%{TABLE}.total_latency DESC\', \'(e.total_latency-IFNULL(s.total_latency, 0)) DESC\', \'(e.total - IFNULL(s.total, 0)) > 0\', NULL, \'host\'), (\'host_summary_by_statement_type\'     , \'%{TABLE}.host, %{TABLE}.total_latency DESC\', \'e.host, (e.total_latency-IFNULL(s.total_latency, 0)) DESC\', \'(e.total - IFNULL(s.total, 0)) > 0\', NULL, \'host,statement\'), (\'io_by_thread_by_latency\'            , \'%{TABLE}.total_latency DESC\', \'(e.total_latency-IFNULL(s.total_latency, 0)) DESC\', \'(e.total - IFNULL(s.total, 0)) > 0\', NULL, \'user,thread_id,processlist_id\'), (\'io_global_by_file_by_bytes\'         , \'%{TABLE}.total DESC\', \'(e.total-IFNULL(s.total, 0)) DESC\', \'(e.total - IFNULL(s.total, 0)) > 0\', 100, \'file\'), (\'io_global_by_file_by_latency\'       , \'%{TABLE}.total_latency DESC\', \'(e.total_latency-IFNULL(s.total_latency, 0)) DESC\', \'(e.total - IFNULL(s.total, 0)) > 0\', 100, \'file\'), (\'io_global_by_wait_by_bytes\'         , \'%{TABLE}.total_requested DESC\', \'(e.total_requested-IFNULL(s.total_requested, 0)) DESC\', \'(e.total - IFNULL(s.total, 0)) > 0\', NULL, \'event_name\'), (\'io_global_by_wait_by_latency\'       , \'%{TABLE}.total_latency DESC\', \'(e.total_latency-IFNULL(s.total_latency, 0)) DESC\', \'(e.total - IFNULL(s.total, 0)) > 0\', NULL, \'event_name\'), (\'schema_index_statistics\'            , \'(%{TABLE}.select_latency+%{TABLE}.insert_latency+%{TABLE}.update_latency+%{TABLE}.delete_latency) DESC\', \'((e.select_latency+e.insert_latency+e.update_latency+e.delete_latency)-IFNULL(s.select_latency+s.insert_latency+s.update_latency+s.delete_latency, 0)) DESC\', \'((e.rows_selected+e.insert_latency+e.rows_updated+e.rows_deleted)-IFNULL(s.rows_selected+s.rows_inserted+s.rows_updated+s.rows_deleted, 0)) > 0\', 100, \'table_schema,table_name,index_name\'), (\'schema_table_statistics\'            , \'%{TABLE}.total_latency DESC\', \'(e.total_latency-IFNULL(s.total_latency, 0)) DESC\', \'(e.total_latency-IFNULL(s.total_latency, 0)) > 0\', 100, \'table_schema,table_name\'), (\'schema_tables_with_full_table_scans\', \'%{TABLE}.rows_full_scanned DESC\', \'(e.rows_full_scanned-IFNULL(s.rows_full_scanned, 0)) DESC\', \'(e.rows_full_scanned-IFNULL(s.rows_full_scanned, 0)) > 0\', 100, \'object_schema,object_name\'), (\'user_summary\'                       , \'%{TABLE}.statement_latency DESC\', \'(e.statement_latency-IFNULL(s.statement_latency, 0)) DESC\', \'(e.statements - IFNULL(s.statements, 0)) > 0\', NULL, \'user\'), (\'user_summary_by_file_io\'            , \'%{TABLE}.io_latency DESC\', \'(e.io_latency-IFNULL(s.io_latency, 0)) DESC\', \'(e.ios - IFNULL(s.ios, 0)) > 0\', NULL, \'user\'), (\'user_summary_by_file_io_type\'       , \'%{TABLE}.user, %{TABLE}.latency DESC\', \'e.user, (e.latency-IFNULL(s.latency, 0)) DESC\', \'(e.total - IFNULL(s.total, 0)) > 0\', NULL, \'user,event_name\'), (\'user_summary_by_stages\'             , \'%{TABLE}.user, %{TABLE}.total_latency DESC\', \'e.user, (e.total_latency-IFNULL(s.total_latency, 0)) DESC\', \'(e.total - IFNULL(s.total, 0)) > 0\', NULL, \'user,event_name\'), (\'user_summary_by_statement_latency\'  , \'%{TABLE}.total_latency DESC\', \'(e.total_latency-IFNULL(s.total_latency, 0)) DESC\', \'(e.total - IFNULL(s.total, 0)) > 0\', NULL, \'user\'), (\'user_summary_by_statement_type\'     , \'%{TABLE}.user, %{TABLE}.total_latency DESC\', \'e.user, (e.total_latency-IFNULL(s.total_latency, 0)) DESC\', \'(e.total - IFNULL(s.total, 0)) > 0\', NULL, \'user,statement\'), (\'wait_classes_global_by_avg_latency\' , \'IFNULL(%{TABLE}.total_latency / NULLIF(%{TABLE}.total, 0), 0) DESC\', \'IFNULL((e.total_latency-IFNULL(s.total_latency, 0)) / NULLIF((e.total - IFNULL(s.total, 0)), 0), 0) DESC\', \'(e.total - IFNULL(s.total, 0)) > 0\', NULL, \'event_class\'), (\'wait_classes_global_by_latency\'     , \'%{TABLE}.total_latency DESC\', \'(e.total_latency-IFNULL(s.total_latency, 0)) DESC\', \'(e.total - IFNULL(s.total, 0)) > 0\', NULL, \'event_class\'), (\'waits_by_host_by_latency\'           , \'%{TABLE}.host, %{TABLE}.total_latency DESC\', \'e.host, (e.total_latency-IFNULL(s.total_latency, 0)) DESC\', \'(e.total - IFNULL(s.total, 0)) > 0\', NULL, \'host,event\'), (\'waits_by_user_by_latency\'           , \'%{TABLE}.user, %{TABLE}.total_latency DESC\', \'e.user, (e.total_latency-IFNULL(s.total_latency, 0)) DESC\', \'(e.total - IFNULL(s.total, 0)) > 0\', NULL, \'user,event\'), (\'waits_global_by_latency\'            , \'%{TABLE}.total_latency DESC\', \'(e.total_latency-IFNULL(s.total_latency, 0)) DESC\', \'(e.total - IFNULL(s.total, 0)) > 0\', NULL, \'events\') ; END IF;   SELECT \'  =======================  Configuration  =======================  \' AS \'\'; SELECT \'GLOBAL VARIABLES\' AS \'The following output is:\'; IF (v_has_ps_vars = \'YES\') THEN SELECT LOWER(VARIABLE_NAME) AS Variable_name, VARIABLE_VALUE AS Variable_value FROM performance_schema.global_variables ORDER BY VARIABLE_NAME; ELSE SELECT LOWER(VARIABLE_NAME) AS Variable_name, VARIABLE_VALUE AS Variable_value FROM information_schema.GLOBAL_VARIABLES ORDER BY VARIABLE_NAME; END IF;  IF (v_has_ps = \'YES\') THEN SELECT \'Performance Schema Setup - Actors\' AS \'The following output is:\'; SELECT * FROM performance_schema.setup_actors;  SELECT \'Performance Schema Setup - Consumers\' AS \'The following output is:\'; SELECT NAME AS Consumer, ENABLED, sys.ps_is_consumer_enabled(NAME) AS COLLECTS FROM performance_schema.setup_consumers;  SELECT \'Performance Schema Setup - Instruments\' AS \'The following output is:\'; SELECT SUBSTRING_INDEX(NAME, \'/\', 2) AS \'InstrumentClass\', ROUND(100*SUM(IF(ENABLED = \'YES\', 1, 0))/COUNT(*), 2) AS \'EnabledPct\', ROUND(100*SUM(IF(TIMED = \'YES\', 1, 0))/COUNT(*), 2) AS \'TimedPct\' FROM performance_schema.setup_instruments GROUP BY SUBSTRING_INDEX(NAME, \'/\', 2) ORDER BY SUBSTRING_INDEX(NAME, \'/\', 2);  SELECT \'Performance Schema Setup - Objects\' AS \'The following output is:\'; SELECT * FROM performance_schema.setup_objects;  SELECT \'Performance Schema Setup - Threads\' AS \'The following output is:\'; SELECT `TYPE` AS ThreadType, COUNT(*) AS \'Total\', ROUND(100*SUM(IF(INSTRUMENTED = \'YES\', 1, 0))/COUNT(*), 2) AS \'InstrumentedPct\' FROM performance_schema.threads GROUP BY TYPE; END IF;   IF (v_has_replication = \'NO\') THEN SELECT \'No Replication Configured\' AS \'Replication Status\'; ELSE SELECT CONCAT(\'Replication Configured: \', v_has_replication, \' - Performance Schema Replication Tables: \', v_has_ps_replication) AS \'Replication Status\';  IF (v_has_ps_replication = \'YES\') THEN SELECT \'Replication - Connection Configuration\' AS \'The following output is:\'; SELECT * FROM performance_schema.replication_connection_configuration ORDER BY CHANNEL_NAME ; END IF;  IF (v_has_ps_replication = \'YES\') THEN SELECT \'Replication - Applier Configuration\' AS \'The following output is:\'; SELECT * FROM performance_schema.replication_applier_configuration ORDER BY CHANNEL_NAME; END IF;  IF (@@master_info_repository = \'TABLE\') THEN SELECT \'Replication - Master Info Repository Configuration\' AS \'The following output is:\'; SELECT  Channel_name, Host, User_name, Port, Connect_retry, Enabled_ssl, Ssl_ca, Ssl_capath, Ssl_cert, Ssl_cipher, Ssl_key, Ssl_verify_server_cert, Heartbeat, Bind, Ignored_server_ids, Uuid, Retry_count, Ssl_crl, Ssl_crlpath, Tls_version, Enabled_auto_position FROM mysql.slave_master_info ORDER BY Channel_name ; END IF;  IF (@@relay_log_info_repository = \'TABLE\') THEN SELECT \'Replication - Relay Log Repository Configuration\' AS \'The following output is:\'; SELECT  Channel_name, Sql_delay, Number_of_workers, Id FROM mysql.slave_relay_log_info ORDER BY Channel_name ; END IF; END IF;   IF (v_has_ndb IN (\'DEFAULT\', \'YES\')) THEN SELECT \'Cluster Thread Blocks\' AS \'The following output is:\'; SELECT * FROM ndbinfo.threadblocks; END IF;  IF (v_has_ps = \'YES\') THEN IF (@sys.diagnostics.include_raw = \'ON\') THEN SELECT \'  ========================  Initial Status  ========================  \' AS \'\'; END IF;  DROP TEMPORARY TABLE IF EXISTS tmp_digests_start; CALL sys.statement_performance_analyzer(\'create_tmp\', \'tmp_digests_start\', NULL); CALL sys.statement_performance_analyzer(\'snapshot\', NULL, NULL); CALL sys.statement_performance_analyzer(\'save\', \'tmp_digests_start\', NULL);  IF (@sys.diagnostics.include_raw = \'ON\') THEN SET @sys.diagnostics.sql = REPLACE(@sys.diagnostics.sql_gen_query_template, \'%{OUTPUT}\', \'start\'); IF (@sys.debug = \'ON\') THEN SELECT \'The following query will be used to generate the query for each sys view\' AS \'Debug\'; SELECT @sys.diagnostics.sql AS \'Debug\'; END IF; PREPARE stmt_gen_query FROM @sys.diagnostics.sql; END IF; SET v_done = FALSE; OPEN c_sysviews_w_delta; c_sysviews_w_delta_loop: LOOP FETCH c_sysviews_w_delta INTO v_table_name; IF v_done THEN LEAVE c_sysviews_w_delta_loop; END IF;  IF (@sys.debug = \'ON\') THEN SELECT CONCAT(\'The following queries are for storing the initial content of \', v_table_name) AS \'Debug\'; END IF;  CALL sys.execute_prepared_stmt(CONCAT(\'DROP TEMPORARY TABLE IF EXISTS `tmp_\', v_table_name, \'_start`\')); CALL sys.execute_prepared_stmt(CONCAT(\'CREATE TEMPORARY TABLE `tmp_\', v_table_name, \'_start` SELECT * FROM `sys`.`x$\', v_table_name, \'`\'));  IF (@sys.diagnostics.include_raw = \'ON\') THEN SET @sys.diagnostics.table_name = CONCAT(\'x$\', v_table_name); EXECUTE stmt_gen_query USING @sys.diagnostics.table_name; SELECT CONCAT(@sys.diagnostics.sql_select, IF(order_by IS NOT NULL, CONCAT(\'\n ORDER BY \', REPLACE(order_by, \'%{TABLE}\', CONCAT(\'tmp_\', v_table_name, \'_start\'))), \'\'), IF(limit_rows IS NOT NULL, CONCAT(\'\n LIMIT \', limit_rows), \'\') ) INTO @sys.diagnostics.sql_select FROM tmp_sys_views_delta WHERE TABLE_NAME = v_table_name; SELECT CONCAT(\'Initial \', v_table_name) AS \'The following output is:\'; CALL sys.execute_prepared_stmt(@sys.diagnostics.sql_select); END IF; END LOOP; CLOSE c_sysviews_w_delta;  IF (@sys.diagnostics.include_raw = \'ON\') THEN DEALLOCATE PREPARE stmt_gen_query; END IF; END IF;  SET v_sql_status_summary_select = \'SELECT Variable_name\', v_sql_status_summary_delta  = \'\', v_sql_status_summary_from   = \'\';  REPEAT  SET v_output_count = v_output_count + 1; IF (v_output_count > 1) THEN SET v_sleep = in_interval-(UNIX_TIMESTAMP(NOW(2))-v_iter_start); SELECT NOW() AS \'Time\', CONCAT(\'Going to sleep for \', v_sleep, \' seconds. Please do not interrupt\') AS \'The following output is:\'; DO SLEEP(in_interval); END IF; SET v_iter_start = UNIX_TIMESTAMP(NOW(2));  SELECT NOW(), CONCAT(\'Iteration Number \', IFNULL(v_output_count, \'NULL\')) AS \'The following output is:\';  IF (@@log_bin = 1) THEN SELECT \'SHOW MASTER STATUS\' AS \'The following output is:\'; SHOW MASTER STATUS; END IF;  IF (v_has_replication <> \'NO\') THEN SELECT \'SHOW SLAVE STATUS\' AS \'The following output is:\'; SHOW SLAVE STATUS;  IF (v_has_ps_replication = \'YES\') THEN SELECT \'Replication Connection Status\' AS \'The following output is:\'; SELECT * FROM performance_schema.replication_connection_status;  SELECT \'Replication Applier Status\' AS \'The following output is:\'; SELECT * FROM performance_schema.replication_applier_status ORDER BY CHANNEL_NAME;  SELECT \'Replication Applier Status - Coordinator\' AS \'The following output is:\'; SELECT * FROM performance_schema.replication_applier_status_by_coordinator ORDER BY CHANNEL_NAME;  SELECT \'Replication Applier Status - Worker\' AS \'The following output is:\'; SELECT * FROM performance_schema.replication_applier_status_by_worker ORDER BY CHANNEL_NAME, WORKER_ID; END IF;  IF (@@master_info_repository = \'TABLE\') THEN SELECT \'Replication - Master Log Status\' AS \'The following output is:\'; SELECT Master_log_name, Master_log_pos FROM mysql.slave_master_info; END IF;  IF (@@relay_log_info_repository = \'TABLE\') THEN SELECT \'Replication - Relay Log Status\' AS \'The following output is:\'; SELECT sys.format_path(Relay_log_name) AS Relay_log_name, Relay_log_pos, Master_log_name, Master_log_pos FROM mysql.slave_relay_log_info;  SELECT \'Replication - Worker Status\' AS \'The following output is:\'; SELECT Id, sys.format_path(Relay_log_name) AS Relay_log_name, Relay_log_pos, Master_log_name, Master_log_pos, sys.format_path(Checkpoint_relay_log_name) AS Checkpoint_relay_log_name, Checkpoint_relay_log_pos, Checkpoint_master_log_name, Checkpoint_master_log_pos, Checkpoint_seqno, Checkpoint_group_size, HEX(Checkpoint_group_bitmap) AS Checkpoint_group_bitmap , Channel_name FROM mysql.slave_worker_info ORDER BY  Channel_name, Id; END IF; END IF;  SET v_table_name = CONCAT(\'tmp_metrics_\', v_output_count); CALL sys.execute_prepared_stmt(CONCAT(\'DROP TEMPORARY TABLE IF EXISTS \', v_table_name));  CALL sys.execute_prepared_stmt(CONCAT(\'CREATE TEMPORARY TABLE \', v_table_name, \' ( Variable_name VARCHAR(193) NOT NULL, Variable_value VARCHAR(1024), Type VARCHAR(225) NOT NULL, Enabled ENUM(\'YES\', \'NO\', \'PARTIAL\') NOT NULL, PRIMARY KEY (Type, Variable_name) ) ENGINE = InnoDB DEFAULT CHARSET=utf8\'));  IF (v_has_metrics) THEN SET @sys.diagnostics.sql = CONCAT( \'INSERT INTO \', v_table_name, \' SELECT Variable_name, REPLACE(Variable_value, \'\n\', \'\\\\n\') AS Variable_value, Type, Enabled FROM sys.metrics\' ); ELSE SET @sys.diagnostics.sql = CONCAT( \'INSERT INTO \', v_table_name, \'(SELECT LOWER(VARIABLE_NAME) AS Variable_name, REPLACE(VARIABLE_VALUE, \'\n\', \'\\\\n\') AS Variable_value, \'Global Status\' AS Type, \'YES\' AS Enabled FROM performance_schema.global_status ) UNION ALL ( SELECT NAME AS Variable_name, COUNT AS Variable_value, CONCAT(\'InnoDB Metrics - \', SUBSYSTEM) AS Type, IF(STATUS = \'enabled\', \'YES\', \'NO\') AS Enabled FROM information_schema.INNODB_METRICS WHERE NAME NOT IN ( \'lock_row_lock_time\', \'lock_row_lock_time_avg\', \'lock_row_lock_time_max\', \'lock_row_lock_waits\', \'buffer_pool_reads\', \'buffer_pool_read_requests\', \'buffer_pool_write_requests\', \'buffer_pool_wait_free\', \'buffer_pool_read_ahead\', \'buffer_pool_read_ahead_evicted\', \'buffer_pool_pages_total\', \'buffer_pool_pages_misc\', \'buffer_pool_pages_data\', \'buffer_pool_bytes_data\', \'buffer_pool_pages_dirty\', \'buffer_pool_bytes_dirty\', \'buffer_pool_pages_free\', \'buffer_pages_created\', \'buffer_pages_written\', \'buffer_pages_read\', \'buffer_data_reads\', \'buffer_data_written\', \'file_num_open_files\', \'os_log_bytes_written\', \'os_log_fsyncs\', \'os_log_pending_fsyncs\', \'os_log_pending_writes\', \'log_waits\', \'log_write_requests\', \'log_writes\', \'innodb_dblwr_writes\', \'innodb_dblwr_pages_written\', \'innodb_page_size\') ) UNION ALL ( SELECT \'NOW()\' AS Variable_name, NOW(3) AS Variable_value, \'System Time\' AS Type, \'YES\' AS Enabled ) UNION ALL ( SELECT \'UNIX_TIMESTAMP()\' AS Variable_name, ROUND(UNIX_TIMESTAMP(NOW(3)), 3) AS Variable_value, \'System Time\' AS Type, \'YES\' AS Enabled ) ORDER BY Type, Variable_name;\' ); END IF; CALL sys.execute_prepared_stmt(@sys.diagnostics.sql);  CALL sys.execute_prepared_stmt( CONCAT(\'(SELECT Variable_value INTO @sys.diagnostics.output_time FROM \', v_table_name, \' WHERE Type = \'System Time\' AND Variable_name = \'UNIX_TIMESTAMP()\')\') ); SET v_output_time = @sys.diagnostics.output_time;  SET v_sql_status_summary_select = CONCAT(v_sql_status_summary_select, \', CONCAT( LEFT(s\', v_output_count, \'.Variable_value, \', v_status_summary_width, \'), IF(\', REPLACE(v_no_delta_names, \'%{COUNT}\', v_output_count), \' AND s\', v_output_count, \'.Variable_value REGEXP \'^[0-9]+(\\\\.[0-9]+)?$\', CONCAT(\' (\', ROUND(s\', v_output_count, \'.Variable_value/\', v_output_time, \', 2), \'/sec)\'), \'\') ) AS \'Output \', v_output_count, \'\'\'), v_sql_status_summary_from   = CONCAT(v_sql_status_summary_from, \' \', IF(v_output_count = 1, \'  FROM \', \'       INNER JOIN \'), v_table_name, \' s\', v_output_count, IF (v_output_count = 1, \'\', \' USING (Type, Variable_name)\')); IF (v_output_count > 1) THEN SET v_sql_status_summary_delta  = CONCAT(v_sql_status_summary_delta, \', IF(\', REPLACE(v_no_delta_names, \'%{COUNT}\', v_output_count), \' AND s\', (v_output_count-1), \'.Variable_value REGEXP \'^[0-9]+(\\\\.[0-9]+)?$\' AND s\', v_output_count, \'.Variable_value REGEXP \'^[0-9]+(\\\\.[0-9]+)?$\', CONCAT(IF(s\', (v_output_count-1), \'.Variable_value REGEXP \'^[0-9]+\\\\.[0-9]+$\' OR s\', v_output_count, \'.Variable_value REGEXP \'^[0-9]+\\\\.[0-9]+$\', ROUND((s\', v_output_count, \'.Variable_value-s\', (v_output_count-1), \'.Variable_value), 2), (s\', v_output_count, \'.Variable_value-s\', (v_output_count-1), \'.Variable_value) ), \' (\', ROUND((s\', v_output_count, \'.Variable_value-s\', (v_output_count-1), \'.Variable_value)/(\', v_output_time, \'-\', v_output_time_prev, \'), 2), \'/sec)\' ), \'\' ) AS \'Delta (\', (v_output_count-1), \' -> \', v_output_count, \')\'\'); END IF;  SET v_output_time_prev = v_output_time;  IF (@sys.diagnostics.include_raw = \'ON\') THEN IF (v_has_metrics) THEN SELECT \'SELECT * FROM sys.metrics\' AS \'The following output is:\'; ELSE SELECT \'sys.metrics equivalent\' AS \'The following output is:\'; END IF; CALL sys.execute_prepared_stmt(CONCAT(\'SELECT Type, Variable_name, Enabled, Variable_value FROM \', v_table_name, \' ORDER BY Type, Variable_name\')); END IF;  IF (v_has_innodb IN (\'DEFAULT\', \'YES\')) THEN SELECT \'SHOW ENGINE INNODB STATUS\' AS \'The following output is:\'; EXECUTE stmt_innodb_status; SELECT \'InnoDB - Transactions\' AS \'The following output is:\'; SELECT * FROM information_schema.INNODB_TRX; END IF;  IF (v_has_ndb IN (\'DEFAULT\', \'YES\')) THEN SELECT \'SHOW ENGINE NDBCLUSTER STATUS\' AS \'The following output is:\'; EXECUTE stmt_ndbcluster_status;  SELECT \'ndbinfo.memoryusage\' AS \'The following output is:\'; SELECT node_id, memory_type, sys.format_bytes(used) AS used, used_pages, sys.format_bytes(total) AS total, total_pages, ROUND(100*(used/total), 2) AS \'Used %\' FROM ndbinfo.memoryusage;  SET v_done = FALSE; OPEN c_ndbinfo; c_ndbinfo_loop: LOOP FETCH c_ndbinfo INTO v_table_name; IF v_done THEN LEAVE c_ndbinfo_loop; END IF;  SELECT CONCAT(\'SELECT * FROM ndbinfo.\', v_table_name) AS \'The following output is:\'; CALL sys.execute_prepared_stmt(CONCAT(\'SELECT * FROM `ndbinfo`.`\', v_table_name, \'`\')); END LOOP; CLOSE c_ndbinfo;  SELECT * FROM information_schema.FILES; END IF;  SELECT \'SELECT * FROM sys.processlist\' AS \'The following output is:\'; SELECT processlist.* FROM sys.processlist;  IF (v_has_ps = \'YES\') THEN IF (sys.ps_is_consumer_enabled(\'events_waits_history_long\') = \'YES\') THEN SELECT \'SELECT * FROM sys.latest_file_io\' AS \'The following output is:\'; SELECT * FROM sys.latest_file_io; END IF;  IF (EXISTS(SELECT 1 FROM performance_schema.setup_instruments WHERE NAME LIKE \'memory/%\' AND ENABLED = \'YES\')) THEN SELECT \'SELECT * FROM sys.memory_by_host_by_current_bytes\' AS \'The following output is:\'; SELECT * FROM sys.memory_by_host_by_current_bytes;  SELECT \'SELECT * FROM sys.memory_by_thread_by_current_bytes\' AS \'The following output is:\'; SELECT * FROM sys.memory_by_thread_by_current_bytes;  SELECT \'SELECT * FROM sys.memory_by_user_by_current_bytes\' AS \'The following output is:\'; SELECT * FROM sys.memory_by_user_by_current_bytes;  SELECT \'SELECT * FROM sys.memory_global_by_current_bytes\' AS \'The following output is:\'; SELECT * FROM sys.memory_global_by_current_bytes; END IF; END IF;  SET v_runtime = (UNIX_TIMESTAMP(NOW(2)) - v_start); UNTIL (v_runtime + in_interval >= in_max_runtime) END REPEAT;  IF (v_has_ps = \'YES\') THEN SELECT \'SHOW ENGINE PERFORMANCE_SCHEMA STATUS\' AS \'The following output is:\'; EXECUTE stmt_ps_status; END IF;  IF (v_has_innodb IN (\'DEFAULT\', \'YES\')) THEN DEALLOCATE PREPARE stmt_innodb_status; END IF; IF (v_has_ps = \'YES\') THEN DEALLOCATE PREPARE stmt_ps_status; END IF; IF (v_has_ndb IN (\'DEFAULT\', \'YES\')) THEN DEALLOCATE PREPARE stmt_ndbcluster_status; END IF;   SELECT \'  ============================  Schema Information  ============================  \' AS \'\';  SELECT COUNT(*) AS \'Total Number of Tables\' FROM information_schema.TABLES;  IF (@sys.diagnostics.allow_i_s_tables = \'ON\') THEN SELECT \'Storage Engine Usage\' AS \'The following output is:\'; SELECT ENGINE, COUNT(*) AS NUM_TABLES, sys.format_bytes(SUM(DATA_LENGTH)) AS DATA_LENGTH, sys.format_bytes(SUM(INDEX_LENGTH)) AS INDEX_LENGTH, sys.format_bytes(SUM(DATA_LENGTH+INDEX_LENGTH)) AS TOTAL FROM information_schema.TABLES GROUP BY ENGINE;  SELECT \'Schema Object Overview\' AS \'The following output is:\'; SELECT * FROM sys.schema_object_overview;  SELECT \'Tables without a PRIMARY KEY\' AS \'The following output is:\'; SELECT TABLES.TABLE_SCHEMA, ENGINE, COUNT(*) AS NumTables FROM information_schema.TABLES LEFT OUTER JOIN information_schema.STATISTICS ON STATISTICS.TABLE_SCHEMA = TABLES.TABLE_SCHEMA AND STATISTICS.TABLE_NAME = TABLES.TABLE_NAME AND STATISTICS.INDEX_NAME = \'PRIMARY\' WHERE STATISTICS.TABLE_NAME IS NULL AND TABLES.TABLE_SCHEMA NOT IN (\'mysql\', \'information_schema\', \'performance_schema\', \'sys\') AND TABLES.TABLE_TYPE = \'BASE TABLE\' GROUP BY TABLES.TABLE_SCHEMA, ENGINE; END IF;  IF (v_has_ps = \'YES\') THEN SELECT \'Unused Indexes\' AS \'The following output is:\'; SELECT object_schema, COUNT(*) AS NumUnusedIndexes FROM performance_schema.table_io_waits_summary_by_index_usage  WHERE index_name IS NOT NULL AND count_star = 0 AND object_schema NOT IN (\'mysql\', \'sys\') AND index_name != \'PRIMARY\' GROUP BY object_schema; END IF;  IF (v_has_ps = \'YES\') THEN SELECT \'  =========================  Overall Status  =========================  \' AS \'\';  SELECT \'CALL sys.ps_statement_avg_latency_histogram()\' AS \'The following output is:\'; CALL sys.ps_statement_avg_latency_histogram();  CALL sys.statement_performance_analyzer(\'snapshot\', NULL, NULL); CALL sys.statement_performance_analyzer(\'overall\', NULL, \'with_runtimes_in_95th_percentile\');  SET @sys.diagnostics.sql = REPLACE(@sys.diagnostics.sql_gen_query_template, \'%{OUTPUT}\', \'end\'); IF (@sys.debug = \'ON\') THEN SELECT \'The following query will be used to generate the query for each sys view\' AS \'Debug\'; SELECT @sys.diagnostics.sql AS \'Debug\'; END IF; PREPARE stmt_gen_query FROM @sys.diagnostics.sql;  SET v_done = FALSE; OPEN c_sysviews_w_delta; c_sysviews_w_delta_loop: LOOP FETCH c_sysviews_w_delta INTO v_table_name; IF v_done THEN LEAVE c_sysviews_w_delta_loop; END IF;  IF (@sys.debug = \'ON\') THEN SELECT CONCAT(\'The following queries are for storing the final content of \', v_table_name) AS \'Debug\'; END IF;  CALL sys.execute_prepared_stmt(CONCAT(\'DROP TEMPORARY TABLE IF EXISTS `tmp_\', v_table_name, \'_end`\')); CALL sys.execute_prepared_stmt(CONCAT(\'CREATE TEMPORARY TABLE `tmp_\', v_table_name, \'_end` SELECT * FROM `sys`.`x$\', v_table_name, \'`\'));  IF (@sys.diagnostics.include_raw = \'ON\') THEN SET @sys.diagnostics.table_name = CONCAT(\'x$\', v_table_name); EXECUTE stmt_gen_query USING @sys.diagnostics.table_name; SELECT CONCAT(@sys.diagnostics.sql_select, IF(order_by IS NOT NULL, CONCAT(\'\n ORDER BY \', REPLACE(order_by, \'%{TABLE}\', CONCAT(\'tmp_\', v_table_name, \'_end\'))), \'\'), IF(limit_rows IS NOT NULL, CONCAT(\'\n LIMIT \', limit_rows), \'\') ) INTO @sys.diagnostics.sql_select FROM tmp_sys_views_delta WHERE TABLE_NAME = v_table_name; SELECT CONCAT(\'Overall \', v_table_name) AS \'The following output is:\'; CALL sys.execute_prepared_stmt(@sys.diagnostics.sql_select); END IF; END LOOP; CLOSE c_sysviews_w_delta;  DEALLOCATE PREPARE stmt_gen_query;   SELECT \'  ======================  Delta Status  ======================  \' AS \'\';  CALL sys.statement_performance_analyzer(\'delta\', \'tmp_digests_start\', \'with_runtimes_in_95th_percentile\'); CALL sys.statement_performance_analyzer(\'cleanup\', NULL, NULL);  DROP TEMPORARY TABLE tmp_digests_start;  IF (@sys.debug = \'ON\') THEN SELECT \'The following query will be used to generate the query for each sys view delta\' AS \'Debug\'; SELECT @sys.diagnostics.sql_gen_query_delta AS \'Debug\'; END IF; PREPARE stmt_gen_query_delta FROM @sys.diagnostics.sql_gen_query_delta;  SET v_old_group_concat_max_len = @@session.group_concat_max_len; SET @@session.group_concat_max_len = 2048; SET v_done = FALSE; OPEN c_sysviews_w_delta; c_sysviews_w_delta_loop: LOOP FETCH c_sysviews_w_delta INTO v_table_name; IF v_done THEN LEAVE c_sysviews_w_delta_loop; END IF;  SET @sys.diagnostics.table_name = v_table_name; EXECUTE stmt_gen_query_delta USING @sys.diagnostics.table_name; SELECT CONCAT(@sys.diagnostics.sql_select, IF(where_delta IS NOT NULL, CONCAT(\'\n WHERE \', where_delta), \'\'), IF(order_by_delta IS NOT NULL, CONCAT(\'\n ORDER BY \', order_by_delta), \'\'), IF(limit_rows IS NOT NULL, CONCAT(\'\n LIMIT \', limit_rows), \'\') ) INTO @sys.diagnostics.sql_select FROM tmp_sys_views_delta WHERE TABLE_NAME = v_table_name;  SELECT CONCAT(\'Delta \', v_table_name) AS \'The following output is:\'; CALL sys.execute_prepared_stmt(@sys.diagnostics.sql_select);  CALL sys.execute_prepared_stmt(CONCAT(\'DROP TEMPORARY TABLE `tmp_\', v_table_name, \'_end`\')); CALL sys.execute_prepared_stmt(CONCAT(\'DROP TEMPORARY TABLE `tmp_\', v_table_name, \'_start`\')); END LOOP; CLOSE c_sysviews_w_delta; SET @@session.group_concat_max_len = v_old_group_concat_max_len;  DEALLOCATE PREPARE stmt_gen_query_delta; DROP TEMPORARY TABLE tmp_sys_views_delta; END IF;  IF (v_has_metrics) THEN SELECT \'SELECT * FROM sys.metrics\' AS \'The following output is:\'; ELSE SELECT \'sys.metrics equivalent\' AS \'The following output is:\'; END IF; CALL sys.execute_prepared_stmt( CONCAT(v_sql_status_summary_select, v_sql_status_summary_delta, \', Type, s1.Enabled\', v_sql_status_summary_from, \' ORDER BY Type, Variable_name\' ) );  SET v_count = 0; WHILE (v_count < v_output_count) DO SET v_count = v_count + 1; SET v_table_name = CONCAT(\'tmp_metrics_\', v_count); CALL sys.execute_prepared_stmt(CONCAT(\'DROP TEMPORARY TABLE IF EXISTS \', v_table_name)); END WHILE;  IF (in_auto_config <> \'current\') THEN CALL sys.ps_setup_reload_saved(); SET sql_log_bin = @log_bin; END IF;  SET @sys.diagnostics.output_time            = NULL, @sys.diagnostics.sql                    = NULL, @sys.diagnostics.sql_gen_query_delta    = NULL, @sys.diagnostics.sql_gen_query_template = NULL, @sys.diagnostics.sql_select             = NULL, @sys.diagnostics.table_name             = NULL;  IF (v_this_thread_enabled = \'YES\') THEN CALL sys.ps_setup_enable_thread(CONNECTION_ID()); END IF;  IF (@log_bin = 1) THEN SET sql_log_bin = @log_bin; END IF; END'),('sys','ps_statement_avg_latency_histogram','PROCEDURE','ps_statement_avg_latency_histogram','SQL','READS_SQL_DATA','NO','INVOKER','','',_binary 'BEGIN SELECT CONCAT(\'\\n\', \'\\n  . = 1 unit\', \'\\n  * = 2 units\', \'\\n  # = 3 units\\n\', @label := CONCAT(@label_inner := CONCAT(\'\\n(0 - \', ROUND((@bucket_size := (SELECT ROUND((MAX(avg_us) - MIN(avg_us)) / (@buckets := 16)) AS size FROM sys.x$ps_digest_avg_latency_distribution)) / (@unit_div := 1000)), (@unit := \'ms\'), \')\'), REPEAT(\' \', (@max_label_size := ((1 + LENGTH(ROUND((@bucket_size * 15) / @unit_div)) + 3 + LENGTH(ROUND(@bucket_size * 16) / @unit_div)) + 1)) - LENGTH(@label_inner)), @count_in_bucket := IFNULL((SELECT SUM(cnt) FROM sys.x$ps_digest_avg_latency_distribution AS b1  WHERE b1.avg_us <= @bucket_size), 0)), REPEAT(\' \', (@max_label_len := (@max_label_size + LENGTH((@total_queries := (SELECT SUM(cnt) FROM sys.x$ps_digest_avg_latency_distribution)))) + 1) - LENGTH(@label)), \'| \', IFNULL(REPEAT(IF(@count_in_bucket < (@one_unit := 40), \'.\', IF(@count_in_bucket < (@two_unit := 80), \'*\', \'#\')),  	             IF(@count_in_bucket < @one_unit, @count_in_bucket, 	             	IF(@count_in_bucket < @two_unit, @count_in_bucket / 2, @count_in_bucket / 3))), \'\'),  @label := CONCAT(@label_inner := CONCAT(\'\\n(\', ROUND(@bucket_size / @unit_div), \' - \', ROUND((@bucket_size * 2) / @unit_div), @unit, \')\'), REPEAT(\' \', @max_label_size - LENGTH(@label_inner)), @count_in_bucket := IFNULL((SELECT SUM(cnt) FROM sys.x$ps_digest_avg_latency_distribution AS b1  WHERE b1.avg_us > @bucket_size AND b1.avg_us <= @bucket_size * 2), 0)), REPEAT(\' \', @max_label_len - LENGTH(@label)), \'| \', IFNULL(REPEAT(IF(@count_in_bucket < @one_unit, \'.\', IF(@count_in_bucket < @two_unit, \'*\', \'#\')),  	             IF(@count_in_bucket < @one_unit, @count_in_bucket, 	             	IF(@count_in_bucket < @two_unit, @count_in_bucket / 2, @count_in_bucket / 3))), \'\'), @label := CONCAT(@label_inner := CONCAT(\'\\n(\', ROUND((@bucket_size * 2) / @unit_div), \' - \', ROUND((@bucket_size * 3) / @unit_div), @unit, \')\'), REPEAT(\' \', @max_label_size - LENGTH(@label_inner)), @count_in_bucket := IFNULL((SELECT SUM(cnt) FROM sys.x$ps_digest_avg_latency_distribution AS b1  WHERE b1.avg_us > @bucket_size * 2 AND b1.avg_us <= @bucket_size * 3), 0)), REPEAT(\' \', @max_label_len - LENGTH(@label)), \'| \', IFNULL(REPEAT(IF(@count_in_bucket < @one_unit, \'.\', IF(@count_in_bucket < @two_unit, \'*\', \'#\')),  	             IF(@count_in_bucket < @one_unit, @count_in_bucket, 	             	IF(@count_in_bucket < @two_unit, @count_in_bucket / 2, @count_in_bucket / 3))), \'\'), @label := CONCAT(@label_inner := CONCAT(\'\\n(\', ROUND((@bucket_size * 3) / @unit_div), \' - \', ROUND((@bucket_size * 4) / @unit_div), @unit, \')\'), REPEAT(\' \', @max_label_size - LENGTH(@label_inner)), @count_in_bucket := IFNULL((SELECT SUM(cnt) FROM sys.x$ps_digest_avg_latency_distribution AS b1  WHERE b1.avg_us > @bucket_size * 3 AND b1.avg_us <= @bucket_size * 4), 0)), REPEAT(\' \', @max_label_len - LENGTH(@label)), \'| \', IFNULL(REPEAT(IF(@count_in_bucket < @one_unit, \'.\', IF(@count_in_bucket < @two_unit, \'*\', \'#\')),  	             IF(@count_in_bucket < @one_unit, @count_in_bucket, 	             	IF(@count_in_bucket < @two_unit, @count_in_bucket / 2, @count_in_bucket / 3))), \'\'), @label := CONCAT(@label_inner := CONCAT(\'\\n(\', ROUND((@bucket_size * 4) / @unit_div), \' - \', ROUND((@bucket_size * 5) / @unit_div), @unit, \')\'), REPEAT(\' \', @max_label_size - LENGTH(@label_inner)), @count_in_bucket := IFNULL((SELECT SUM(cnt) FROM sys.x$ps_digest_avg_latency_distribution AS b1  WHERE b1.avg_us > @bucket_size * 4 AND b1.avg_us <= @bucket_size * 5), 0)), REPEAT(\' \', @max_label_len - LENGTH(@label)), \'| \', IFNULL(REPEAT(IF(@count_in_bucket < @one_unit, \'.\', IF(@count_in_bucket < @two_unit, \'*\', \'#\')),  	             IF(@count_in_bucket < @one_unit, @count_in_bucket, 	             	IF(@count_in_bucket < @two_unit, @count_in_bucket / 2, @count_in_bucket / 3))), \'\'), @label := CONCAT(@label_inner := CONCAT(\'\\n(\', ROUND((@bucket_size * 5) / @unit_div), \' - \', ROUND((@bucket_size * 6) / @unit_div), @unit, \')\'), REPEAT(\' \', @max_label_size - LENGTH(@label_inner)), @count_in_bucket := IFNULL((SELECT SUM(cnt) FROM sys.x$ps_digest_avg_latency_distribution AS b1  WHERE b1.avg_us > @bucket_size * 5 AND b1.avg_us <= @bucket_size * 6), 0)), REPEAT(\' \', @max_label_len - LENGTH(@label)), \'| \', IFNULL(REPEAT(IF(@count_in_bucket < @one_unit, \'.\', IF(@count_in_bucket < @two_unit, \'*\', \'#\')),  	             IF(@count_in_bucket < @one_unit, @count_in_bucket, 	             	IF(@count_in_bucket < @two_unit, @count_in_bucket / 2, @count_in_bucket / 3))), \'\'), @label := CONCAT(@label_inner := CONCAT(\'\\n(\', ROUND((@bucket_size * 6) / @unit_div), \' - \', ROUND((@bucket_size * 7) / @unit_div), @unit, \')\'), REPEAT(\' \', @max_label_size - LENGTH(@label_inner)), @count_in_bucket := IFNULL((SELECT SUM(cnt) FROM sys.x$ps_digest_avg_latency_distribution AS b1  WHERE b1.avg_us > @bucket_size * 6 AND b1.avg_us <= @bucket_size * 7), 0)), REPEAT(\' \', @max_label_len - LENGTH(@label)), \'| \', IFNULL(REPEAT(IF(@count_in_bucket < @one_unit, \'.\', IF(@count_in_bucket < @two_unit, \'*\', \'#\')),  	             IF(@count_in_bucket < @one_unit, @count_in_bucket, 	             	IF(@count_in_bucket < @two_unit, @count_in_bucket / 2, @count_in_bucket / 3))), \'\'), @label := CONCAT(@label_inner := CONCAT(\'\\n(\', ROUND((@bucket_size * 7) / @unit_div), \' - \', ROUND((@bucket_size * 8) / @unit_div), @unit, \')\'), REPEAT(\' \', @max_label_size - LENGTH(@label_inner)), @count_in_bucket := IFNULL((SELECT SUM(cnt) FROM sys.x$ps_digest_avg_latency_distribution AS b1  WHERE b1.avg_us > @bucket_size * 7 AND b1.avg_us <= @bucket_size * 8), 0)), REPEAT(\' \', @max_label_len - LENGTH(@label)), \'| \', IFNULL(REPEAT(IF(@count_in_bucket < @one_unit, \'.\', IF(@count_in_bucket < @two_unit, \'*\', \'#\')),  	             IF(@count_in_bucket < @one_unit, @count_in_bucket, 	             	IF(@count_in_bucket < @two_unit, @count_in_bucket / 2, @count_in_bucket / 3))), \'\'), @label := CONCAT(@label_inner := CONCAT(\'\\n(\', ROUND((@bucket_size * 8) / @unit_div), \' - \', ROUND((@bucket_size * 9) / @unit_div), @unit, \')\'), REPEAT(\' \', @max_label_size - LENGTH(@label_inner)), @count_in_bucket := IFNULL((SELECT SUM(cnt) FROM sys.x$ps_digest_avg_latency_distribution AS b1  WHERE b1.avg_us > @bucket_size * 8 AND b1.avg_us <= @bucket_size * 9), 0)), REPEAT(\' \', @max_label_len - LENGTH(@label)), \'| \', IFNULL(REPEAT(IF(@count_in_bucket < @one_unit, \'.\', IF(@count_in_bucket < @two_unit, \'*\', \'#\')),  	             IF(@count_in_bucket < @one_unit, @count_in_bucket, 	             	IF(@count_in_bucket < @two_unit, @count_in_bucket / 2, @count_in_bucket / 3))), \'\'), @label := CONCAT(@label_inner := CONCAT(\'\\n(\', ROUND((@bucket_size * 9) / @unit_div), \' - \', ROUND((@bucket_size * 10) / @unit_div), @unit, \')\'), REPEAT(\' \', @max_label_size - LENGTH(@label_inner)), @count_in_bucket := IFNULL((SELECT SUM(cnt) FROM sys.x$ps_digest_avg_latency_distribution AS b1  WHERE b1.avg_us > @bucket_size * 9 AND b1.avg_us <= @bucket_size * 10), 0)), REPEAT(\' \', @max_label_len - LENGTH(@label)), \'| \', IFNULL(REPEAT(IF(@count_in_bucket < @one_unit, \'.\', IF(@count_in_bucket < @two_unit, \'*\', \'#\')),  	             IF(@count_in_bucket < @one_unit, @count_in_bucket, 	             	IF(@count_in_bucket < @two_unit, @count_in_bucket / 2, @count_in_bucket / 3))), \'\'), @label := CONCAT(@label_inner := CONCAT(\'\\n(\', ROUND((@bucket_size * 10) / @unit_div), \' - \', ROUND((@bucket_size * 11) / @unit_div), @unit, \')\'), REPEAT(\' \', @max_label_size - LENGTH(@label_inner)), @count_in_bucket := IFNULL((SELECT SUM(cnt) FROM sys.x$ps_digest_avg_latency_distribution AS b1  WHERE b1.avg_us > @bucket_size * 10 AND b1.avg_us <= @bucket_size * 11), 0)), REPEAT(\' \', @max_label_len - LENGTH(@label)), \'| \', IFNULL(REPEAT(IF(@count_in_bucket < @one_unit, \'.\', IF(@count_in_bucket < @two_unit, \'*\', \'#\')),  	             IF(@count_in_bucket < @one_unit, @count_in_bucket, 	             	IF(@count_in_bucket < @two_unit, @count_in_bucket / 2, @count_in_bucket / 3))), \'\'), @label := CONCAT(@label_inner := CONCAT(\'\\n(\', ROUND((@bucket_size * 11) / @unit_div), \' - \', ROUND((@bucket_size * 12) / @unit_div), @unit, \')\'), REPEAT(\' \', @max_label_size - LENGTH(@label_inner)), @count_in_bucket := IFNULL((SELECT SUM(cnt) FROM sys.x$ps_digest_avg_latency_distribution AS b1  WHERE b1.avg_us > @bucket_size * 11 AND b1.avg_us <= @bucket_size * 12), 0)), REPEAT(\' \', @max_label_len - LENGTH(@label)), \'| \', IFNULL(REPEAT(IF(@count_in_bucket < @one_unit, \'.\', IF(@count_in_bucket < @two_unit, \'*\', \'#\')),  	             IF(@count_in_bucket < @one_unit, @count_in_bucket, 	             	IF(@count_in_bucket < @two_unit, @count_in_bucket / 2, @count_in_bucket / 3))), \'\'), @label := CONCAT(@label_inner := CONCAT(\'\\n(\', ROUND((@bucket_size * 12) / @unit_div), \' - \', ROUND((@bucket_size * 13) / @unit_div), @unit, \')\'), REPEAT(\' \', @max_label_size - LENGTH(@label_inner)), @count_in_bucket := IFNULL((SELECT SUM(cnt) FROM sys.x$ps_digest_avg_latency_distribution AS b1  WHERE b1.avg_us > @bucket_size * 12 AND b1.avg_us <= @bucket_size * 13), 0)), REPEAT(\' \', @max_label_len - LENGTH(@label)), \'| \', IFNULL(REPEAT(IF(@count_in_bucket < @one_unit, \'.\', IF(@count_in_bucket < @two_unit, \'*\', \'#\')),  	             IF(@count_in_bucket < @one_unit, @count_in_bucket, 	             	IF(@count_in_bucket < @two_unit, @count_in_bucket / 2, @count_in_bucket / 3))), \'\'), @label := CONCAT(@label_inner := CONCAT(\'\\n(\', ROUND((@bucket_size * 13) / @unit_div), \' - \', ROUND((@bucket_size * 14) / @unit_div), @unit, \')\'), REPEAT(\' \', @max_label_size - LENGTH(@label_inner)), @count_in_bucket := IFNULL((SELECT SUM(cnt) FROM sys.x$ps_digest_avg_latency_distribution AS b1  WHERE b1.avg_us > @bucket_size * 13 AND b1.avg_us <= @bucket_size * 14), 0)), REPEAT(\' \', @max_label_len - LENGTH(@label)), \'| \', IFNULL(REPEAT(IF(@count_in_bucket < @one_unit, \'.\', IF(@count_in_bucket < @two_unit, \'*\', \'#\')),  	             IF(@count_in_bucket < @one_unit, @count_in_bucket, 	             	IF(@count_in_bucket < @two_unit, @count_in_bucket / 2, @count_in_bucket / 3))), \'\'), @label := CONCAT(@label_inner := CONCAT(\'\\n(\', ROUND((@bucket_size * 14) / @unit_div), \' - \', ROUND((@bucket_size * 15) / @unit_div), @unit, \')\'), REPEAT(\' \', @max_label_size - LENGTH(@label_inner)), @count_in_bucket := IFNULL((SELECT SUM(cnt) FROM sys.x$ps_digest_avg_latency_distribution AS b1  WHERE b1.avg_us > @bucket_size * 14 AND b1.avg_us <= @bucket_size * 15), 0)), REPEAT(\' \', @max_label_len - LENGTH(@label)), \'| \', IFNULL(REPEAT(IF(@count_in_bucket < @one_unit, \'.\', IF(@count_in_bucket < @two_unit, \'*\', \'#\')),  	             IF(@count_in_bucket < @one_unit, @count_in_bucket, 	             	IF(@count_in_bucket < @two_unit, @count_in_bucket / 2, @count_in_bucket / 3))), \'\'), @label := CONCAT(@label_inner := CONCAT(\'\\n(\', ROUND((@bucket_size * 15) / @unit_div), \' - \', ROUND((@bucket_size * 16) / @unit_div), @unit, \')\'), REPEAT(\' \', @max_label_size - LENGTH(@label_inner)), @count_in_bucket := IFNULL((SELECT SUM(cnt) FROM sys.x$ps_digest_avg_latency_distribution AS b1  WHERE b1.avg_us > @bucket_size * 15 AND b1.avg_us <= @bucket_size * 16), 0)), REPEAT(\' \', @max_label_len - LENGTH(@label)), \'| \', IFNULL(REPEAT(IF(@count_in_bucket < @one_unit, \'.\', IF(@count_in_bucket < @two_unit, \'*\', \'#\')),  	             IF(@count_in_bucket < @one_unit, @count_in_bucket, 	             	IF(@count_in_bucket < @two_unit, @count_in_bucket / 2, @count_in_bucket / 3))), \'\'),  \'\\n\\n  Total Statements: \', @total_queries, \'; Buckets: \', @buckets , \'; Bucket Size: \', ROUND(@bucket_size / @unit_div) , \' \', @unit, \';\\n\'  ) AS `Performance Schema Statement Digest Average Latency Histogram`;  END','mysql.sys@localhost','2017-03-02 18:46:53','2017-03-02 18:46:53','','\n Description\n \n Outputs a textual histogram graph of the average latency values\n across all normalized queries tracked within the Performance Schema\n events_statements_summary_by_digest table.\n \n Can be used to show a very high level picture of what kind of \n latency distribution statements running within this instance have.\n \n Parameters\n \n None.\n \n Example\n \n mysql> CALL sys.ps_statement_avg_latency_histogram()\\G\n *************************** 1. row ***************************\n Performance Schema Statement Digest Average Latency Histogram:\n \n . = 1 unit\n * = 2 units\n # = 3 units\n \n (0 - 38ms)     240 | ################################################################################\n (38 - 77ms)    38  | ......................................\n (77 - 115ms)   3   | ...\n (115 - 154ms)  62  | *******************************\n (154 - 192ms)  3   | ...\n (192 - 231ms)  0   |\n (231 - 269ms)  0   |\n (269 - 307ms)  0   |\n (307 - 346ms)  0   |\n (346 - 384ms)  1   | .\n (384 - 423ms)  1   | .\n (423 - 461ms)  0   |\n (461 - 499ms)  0   |\n (499 - 538ms)  0   |\n (538 - 576ms)  0   |\n (576 - 615ms)  1   | .\n \n Total Statements: 350; Buckets: 16; Bucket Size: 38 ms;\n ','utf8','utf8_general_ci','utf8_general_ci',_binary 'BEGIN SELECT CONCAT(\'\n\', \'\n  . = 1 unit\', \'\n  * = 2 units\', \'\n  # = 3 units\n\', @label := CONCAT(@label_inner := CONCAT(\'\n(0 - \', ROUND((@bucket_size := (SELECT ROUND((MAX(avg_us) - MIN(avg_us)) / (@buckets := 16)) AS size FROM sys.x$ps_digest_avg_latency_distribution)) / (@unit_div := 1000)), (@unit := \'ms\'), \')\'), REPEAT(\' \', (@max_label_size := ((1 + LENGTH(ROUND((@bucket_size * 15) / @unit_div)) + 3 + LENGTH(ROUND(@bucket_size * 16) / @unit_div)) + 1)) - LENGTH(@label_inner)), @count_in_bucket := IFNULL((SELECT SUM(cnt) FROM sys.x$ps_digest_avg_latency_distribution AS b1  WHERE b1.avg_us <= @bucket_size), 0)), REPEAT(\' \', (@max_label_len := (@max_label_size + LENGTH((@total_queries := (SELECT SUM(cnt) FROM sys.x$ps_digest_avg_latency_distribution)))) + 1) - LENGTH(@label)), \'| \', IFNULL(REPEAT(IF(@count_in_bucket < (@one_unit := 40), \'.\', IF(@count_in_bucket < (@two_unit := 80), \'*\', \'#\')),  	             IF(@count_in_bucket < @one_unit, @count_in_bucket, 	             	IF(@count_in_bucket < @two_unit, @count_in_bucket / 2, @count_in_bucket / 3))), \'\'),  @label := CONCAT(@label_inner := CONCAT(\'\n(\', ROUND(@bucket_size / @unit_div), \' - \', ROUND((@bucket_size * 2) / @unit_div), @unit, \')\'), REPEAT(\' \', @max_label_size - LENGTH(@label_inner)), @count_in_bucket := IFNULL((SELECT SUM(cnt) FROM sys.x$ps_digest_avg_latency_distribution AS b1  WHERE b1.avg_us > @bucket_size AND b1.avg_us <= @bucket_size * 2), 0)), REPEAT(\' \', @max_label_len - LENGTH(@label)), \'| \', IFNULL(REPEAT(IF(@count_in_bucket < @one_unit, \'.\', IF(@count_in_bucket < @two_unit, \'*\', \'#\')),  	             IF(@count_in_bucket < @one_unit, @count_in_bucket, 	             	IF(@count_in_bucket < @two_unit, @count_in_bucket / 2, @count_in_bucket / 3))), \'\'), @label := CONCAT(@label_inner := CONCAT(\'\n(\', ROUND((@bucket_size * 2) / @unit_div), \' - \', ROUND((@bucket_size * 3) / @unit_div), @unit, \')\'), REPEAT(\' \', @max_label_size - LENGTH(@label_inner)), @count_in_bucket := IFNULL((SELECT SUM(cnt) FROM sys.x$ps_digest_avg_latency_distribution AS b1  WHERE b1.avg_us > @bucket_size * 2 AND b1.avg_us <= @bucket_size * 3), 0)), REPEAT(\' \', @max_label_len - LENGTH(@label)), \'| \', IFNULL(REPEAT(IF(@count_in_bucket < @one_unit, \'.\', IF(@count_in_bucket < @two_unit, \'*\', \'#\')),  	             IF(@count_in_bucket < @one_unit, @count_in_bucket, 	             	IF(@count_in_bucket < @two_unit, @count_in_bucket / 2, @count_in_bucket / 3))), \'\'), @label := CONCAT(@label_inner := CONCAT(\'\n(\', ROUND((@bucket_size * 3) / @unit_div), \' - \', ROUND((@bucket_size * 4) / @unit_div), @unit, \')\'), REPEAT(\' \', @max_label_size - LENGTH(@label_inner)), @count_in_bucket := IFNULL((SELECT SUM(cnt) FROM sys.x$ps_digest_avg_latency_distribution AS b1  WHERE b1.avg_us > @bucket_size * 3 AND b1.avg_us <= @bucket_size * 4), 0)), REPEAT(\' \', @max_label_len - LENGTH(@label)), \'| \', IFNULL(REPEAT(IF(@count_in_bucket < @one_unit, \'.\', IF(@count_in_bucket < @two_unit, \'*\', \'#\')),  	             IF(@count_in_bucket < @one_unit, @count_in_bucket, 	             	IF(@count_in_bucket < @two_unit, @count_in_bucket / 2, @count_in_bucket / 3))), \'\'), @label := CONCAT(@label_inner := CONCAT(\'\n(\', ROUND((@bucket_size * 4) / @unit_div), \' - \', ROUND((@bucket_size * 5) / @unit_div), @unit, \')\'), REPEAT(\' \', @max_label_size - LENGTH(@label_inner)), @count_in_bucket := IFNULL((SELECT SUM(cnt) FROM sys.x$ps_digest_avg_latency_distribution AS b1  WHERE b1.avg_us > @bucket_size * 4 AND b1.avg_us <= @bucket_size * 5), 0)), REPEAT(\' \', @max_label_len - LENGTH(@label)), \'| \', IFNULL(REPEAT(IF(@count_in_bucket < @one_unit, \'.\', IF(@count_in_bucket < @two_unit, \'*\', \'#\')),  	             IF(@count_in_bucket < @one_unit, @count_in_bucket, 	             	IF(@count_in_bucket < @two_unit, @count_in_bucket / 2, @count_in_bucket / 3))), \'\'), @label := CONCAT(@label_inner := CONCAT(\'\n(\', ROUND((@bucket_size * 5) / @unit_div), \' - \', ROUND((@bucket_size * 6) / @unit_div), @unit, \')\'), REPEAT(\' \', @max_label_size - LENGTH(@label_inner)), @count_in_bucket := IFNULL((SELECT SUM(cnt) FROM sys.x$ps_digest_avg_latency_distribution AS b1  WHERE b1.avg_us > @bucket_size * 5 AND b1.avg_us <= @bucket_size * 6), 0)), REPEAT(\' \', @max_label_len - LENGTH(@label)), \'| \', IFNULL(REPEAT(IF(@count_in_bucket < @one_unit, \'.\', IF(@count_in_bucket < @two_unit, \'*\', \'#\')),  	             IF(@count_in_bucket < @one_unit, @count_in_bucket, 	             	IF(@count_in_bucket < @two_unit, @count_in_bucket / 2, @count_in_bucket / 3))), \'\'), @label := CONCAT(@label_inner := CONCAT(\'\n(\', ROUND((@bucket_size * 6) / @unit_div), \' - \', ROUND((@bucket_size * 7) / @unit_div), @unit, \')\'), REPEAT(\' \', @max_label_size - LENGTH(@label_inner)), @count_in_bucket := IFNULL((SELECT SUM(cnt) FROM sys.x$ps_digest_avg_latency_distribution AS b1  WHERE b1.avg_us > @bucket_size * 6 AND b1.avg_us <= @bucket_size * 7), 0)), REPEAT(\' \', @max_label_len - LENGTH(@label)), \'| \', IFNULL(REPEAT(IF(@count_in_bucket < @one_unit, \'.\', IF(@count_in_bucket < @two_unit, \'*\', \'#\')),  	             IF(@count_in_bucket < @one_unit, @count_in_bucket, 	             	IF(@count_in_bucket < @two_unit, @count_in_bucket / 2, @count_in_bucket / 3))), \'\'), @label := CONCAT(@label_inner := CONCAT(\'\n(\', ROUND((@bucket_size * 7) / @unit_div), \' - \', ROUND((@bucket_size * 8) / @unit_div), @unit, \')\'), REPEAT(\' \', @max_label_size - LENGTH(@label_inner)), @count_in_bucket := IFNULL((SELECT SUM(cnt) FROM sys.x$ps_digest_avg_latency_distribution AS b1  WHERE b1.avg_us > @bucket_size * 7 AND b1.avg_us <= @bucket_size * 8), 0)), REPEAT(\' \', @max_label_len - LENGTH(@label)), \'| \', IFNULL(REPEAT(IF(@count_in_bucket < @one_unit, \'.\', IF(@count_in_bucket < @two_unit, \'*\', \'#\')),  	             IF(@count_in_bucket < @one_unit, @count_in_bucket, 	             	IF(@count_in_bucket < @two_unit, @count_in_bucket / 2, @count_in_bucket / 3))), \'\'), @label := CONCAT(@label_inner := CONCAT(\'\n(\', ROUND((@bucket_size * 8) / @unit_div), \' - \', ROUND((@bucket_size * 9) / @unit_div), @unit, \')\'), REPEAT(\' \', @max_label_size - LENGTH(@label_inner)), @count_in_bucket := IFNULL((SELECT SUM(cnt) FROM sys.x$ps_digest_avg_latency_distribution AS b1  WHERE b1.avg_us > @bucket_size * 8 AND b1.avg_us <= @bucket_size * 9), 0)), REPEAT(\' \', @max_label_len - LENGTH(@label)), \'| \', IFNULL(REPEAT(IF(@count_in_bucket < @one_unit, \'.\', IF(@count_in_bucket < @two_unit, \'*\', \'#\')),  	             IF(@count_in_bucket < @one_unit, @count_in_bucket, 	             	IF(@count_in_bucket < @two_unit, @count_in_bucket / 2, @count_in_bucket / 3))), \'\'), @label := CONCAT(@label_inner := CONCAT(\'\n(\', ROUND((@bucket_size * 9) / @unit_div), \' - \', ROUND((@bucket_size * 10) / @unit_div), @unit, \')\'), REPEAT(\' \', @max_label_size - LENGTH(@label_inner)), @count_in_bucket := IFNULL((SELECT SUM(cnt) FROM sys.x$ps_digest_avg_latency_distribution AS b1  WHERE b1.avg_us > @bucket_size * 9 AND b1.avg_us <= @bucket_size * 10), 0)), REPEAT(\' \', @max_label_len - LENGTH(@label)), \'| \', IFNULL(REPEAT(IF(@count_in_bucket < @one_unit, \'.\', IF(@count_in_bucket < @two_unit, \'*\', \'#\')),  	             IF(@count_in_bucket < @one_unit, @count_in_bucket, 	             	IF(@count_in_bucket < @two_unit, @count_in_bucket / 2, @count_in_bucket / 3))), \'\'), @label := CONCAT(@label_inner := CONCAT(\'\n(\', ROUND((@bucket_size * 10) / @unit_div), \' - \', ROUND((@bucket_size * 11) / @unit_div), @unit, \')\'), REPEAT(\' \', @max_label_size - LENGTH(@label_inner)), @count_in_bucket := IFNULL((SELECT SUM(cnt) FROM sys.x$ps_digest_avg_latency_distribution AS b1  WHERE b1.avg_us > @bucket_size * 10 AND b1.avg_us <= @bucket_size * 11), 0)), REPEAT(\' \', @max_label_len - LENGTH(@label)), \'| \', IFNULL(REPEAT(IF(@count_in_bucket < @one_unit, \'.\', IF(@count_in_bucket < @two_unit, \'*\', \'#\')),  	             IF(@count_in_bucket < @one_unit, @count_in_bucket, 	             	IF(@count_in_bucket < @two_unit, @count_in_bucket / 2, @count_in_bucket / 3))), \'\'), @label := CONCAT(@label_inner := CONCAT(\'\n(\', ROUND((@bucket_size * 11) / @unit_div), \' - \', ROUND((@bucket_size * 12) / @unit_div), @unit, \')\'), REPEAT(\' \', @max_label_size - LENGTH(@label_inner)), @count_in_bucket := IFNULL((SELECT SUM(cnt) FROM sys.x$ps_digest_avg_latency_distribution AS b1  WHERE b1.avg_us > @bucket_size * 11 AND b1.avg_us <= @bucket_size * 12), 0)), REPEAT(\' \', @max_label_len - LENGTH(@label)), \'| \', IFNULL(REPEAT(IF(@count_in_bucket < @one_unit, \'.\', IF(@count_in_bucket < @two_unit, \'*\', \'#\')),  	             IF(@count_in_bucket < @one_unit, @count_in_bucket, 	             	IF(@count_in_bucket < @two_unit, @count_in_bucket / 2, @count_in_bucket / 3))), \'\'), @label := CONCAT(@label_inner := CONCAT(\'\n(\', ROUND((@bucket_size * 12) / @unit_div), \' - \', ROUND((@bucket_size * 13) / @unit_div), @unit, \')\'), REPEAT(\' \', @max_label_size - LENGTH(@label_inner)), @count_in_bucket := IFNULL((SELECT SUM(cnt) FROM sys.x$ps_digest_avg_latency_distribution AS b1  WHERE b1.avg_us > @bucket_size * 12 AND b1.avg_us <= @bucket_size * 13), 0)), REPEAT(\' \', @max_label_len - LENGTH(@label)), \'| \', IFNULL(REPEAT(IF(@count_in_bucket < @one_unit, \'.\', IF(@count_in_bucket < @two_unit, \'*\', \'#\')),  	             IF(@count_in_bucket < @one_unit, @count_in_bucket, 	             	IF(@count_in_bucket < @two_unit, @count_in_bucket / 2, @count_in_bucket / 3))), \'\'), @label := CONCAT(@label_inner := CONCAT(\'\n(\', ROUND((@bucket_size * 13) / @unit_div), \' - \', ROUND((@bucket_size * 14) / @unit_div), @unit, \')\'), REPEAT(\' \', @max_label_size - LENGTH(@label_inner)), @count_in_bucket := IFNULL((SELECT SUM(cnt) FROM sys.x$ps_digest_avg_latency_distribution AS b1  WHERE b1.avg_us > @bucket_size * 13 AND b1.avg_us <= @bucket_size * 14), 0)), REPEAT(\' \', @max_label_len - LENGTH(@label)), \'| \', IFNULL(REPEAT(IF(@count_in_bucket < @one_unit, \'.\', IF(@count_in_bucket < @two_unit, \'*\', \'#\')),  	             IF(@count_in_bucket < @one_unit, @count_in_bucket, 	             	IF(@count_in_bucket < @two_unit, @count_in_bucket / 2, @count_in_bucket / 3))), \'\'), @label := CONCAT(@label_inner := CONCAT(\'\n(\', ROUND((@bucket_size * 14) / @unit_div), \' - \', ROUND((@bucket_size * 15) / @unit_div), @unit, \')\'), REPEAT(\' \', @max_label_size - LENGTH(@label_inner)), @count_in_bucket := IFNULL((SELECT SUM(cnt) FROM sys.x$ps_digest_avg_latency_distribution AS b1  WHERE b1.avg_us > @bucket_size * 14 AND b1.avg_us <= @bucket_size * 15), 0)), REPEAT(\' \', @max_label_len - LENGTH(@label)), \'| \', IFNULL(REPEAT(IF(@count_in_bucket < @one_unit, \'.\', IF(@count_in_bucket < @two_unit, \'*\', \'#\')),  	             IF(@count_in_bucket < @one_unit, @count_in_bucket, 	             	IF(@count_in_bucket < @two_unit, @count_in_bucket / 2, @count_in_bucket / 3))), \'\'), @label := CONCAT(@label_inner := CONCAT(\'\n(\', ROUND((@bucket_size * 15) / @unit_div), \' - \', ROUND((@bucket_size * 16) / @unit_div), @unit, \')\'), REPEAT(\' \', @max_label_size - LENGTH(@label_inner)), @count_in_bucket := IFNULL((SELECT SUM(cnt) FROM sys.x$ps_digest_avg_latency_distribution AS b1  WHERE b1.avg_us > @bucket_size * 15 AND b1.avg_us <= @bucket_size * 16), 0)), REPEAT(\' \', @max_label_len - LENGTH(@label)), \'| \', IFNULL(REPEAT(IF(@count_in_bucket < @one_unit, \'.\', IF(@count_in_bucket < @two_unit, \'*\', \'#\')),  	             IF(@count_in_bucket < @one_unit, @count_in_bucket, 	             	IF(@count_in_bucket < @two_unit, @count_in_bucket / 2, @count_in_bucket / 3))), \'\'),  \'\n\n  Total Statements: \', @total_queries, \'; Buckets: \', @buckets , \'; Bucket Size: \', ROUND(@bucket_size / @unit_div) , \' \', @unit, \';\n\'  ) AS `Performance Schema Statement Digest Average Latency Histogram`;  END'),('sys','ps_trace_statement_digest','PROCEDURE','ps_trace_statement_digest','SQL','MODIFIES_SQL_DATA','NO','INVOKER',_binary ' IN in_digest VARCHAR(32), IN in_runtime INT,  IN in_interval DECIMAL(2,2), IN in_start_fresh BOOLEAN, IN in_auto_enable BOOLEAN ','',_binary 'BEGIN  DECLARE v_start_fresh BOOLEAN DEFAULT false; DECLARE v_auto_enable BOOLEAN DEFAULT false; DECLARE v_explain     BOOLEAN DEFAULT true; DECLARE v_this_thread_enabed ENUM(\'YES\', \'NO\'); DECLARE v_runtime INT DEFAULT 0; DECLARE v_start INT DEFAULT 0; DECLARE v_found_stmts INT;  SET @log_bin := @@sql_log_bin; SET sql_log_bin = 0;  SELECT INSTRUMENTED INTO v_this_thread_enabed FROM performance_schema.threads WHERE PROCESSLIST_ID = CONNECTION_ID(); CALL sys.ps_setup_disable_thread(CONNECTION_ID());  DROP TEMPORARY TABLE IF EXISTS stmt_trace; CREATE TEMPORARY TABLE stmt_trace ( thread_id BIGINT UNSIGNED, timer_start BIGINT UNSIGNED, event_id BIGINT UNSIGNED, sql_text longtext, timer_wait BIGINT UNSIGNED, lock_time BIGINT UNSIGNED, errors BIGINT UNSIGNED, mysql_errno INT, rows_sent BIGINT UNSIGNED, rows_affected BIGINT UNSIGNED, rows_examined BIGINT UNSIGNED, created_tmp_tables BIGINT UNSIGNED, created_tmp_disk_tables BIGINT UNSIGNED, no_index_used BIGINT UNSIGNED, PRIMARY KEY (thread_id, timer_start) );  DROP TEMPORARY TABLE IF EXISTS stmt_stages; CREATE TEMPORARY TABLE stmt_stages ( event_id BIGINT UNSIGNED, stmt_id BIGINT UNSIGNED, event_name VARCHAR(128), timer_wait BIGINT UNSIGNED, PRIMARY KEY (event_id) );  SET v_start_fresh = in_start_fresh; IF v_start_fresh THEN TRUNCATE TABLE performance_schema.events_statements_history_long; TRUNCATE TABLE performance_schema.events_stages_history_long; END IF;  SET v_auto_enable = in_auto_enable; IF v_auto_enable THEN CALL sys.ps_setup_save(0);  UPDATE performance_schema.threads SET INSTRUMENTED = IF(PROCESSLIST_ID IS NOT NULL, \'YES\', \'NO\');  UPDATE performance_schema.setup_consumers SET ENABLED = \'YES\' WHERE NAME NOT LIKE \'%\\_history\' AND NAME NOT LIKE \'events_wait%\' AND NAME NOT LIKE \'events_transactions%\' AND NAME <> \'statements_digest\';  UPDATE performance_schema.setup_instruments SET ENABLED = \'YES\', TIMED   = \'YES\' WHERE NAME LIKE \'statement/%\' OR NAME LIKE \'stage/%\'; END IF;  WHILE v_runtime < in_runtime DO SELECT UNIX_TIMESTAMP() INTO v_start;  INSERT IGNORE INTO stmt_trace SELECT thread_id, timer_start, event_id, sql_text, timer_wait, lock_time, errors, mysql_errno,  rows_sent, rows_affected, rows_examined, created_tmp_tables, created_tmp_disk_tables, no_index_used FROM performance_schema.events_statements_history_long WHERE digest = in_digest;  INSERT IGNORE INTO stmt_stages SELECT stages.event_id, stmt_trace.event_id, stages.event_name, stages.timer_wait FROM performance_schema.events_stages_history_long AS stages JOIN stmt_trace ON stages.nesting_event_id = stmt_trace.event_id;  SELECT SLEEP(in_interval) INTO @sleep; SET v_runtime = v_runtime + (UNIX_TIMESTAMP() - v_start); END WHILE;  SELECT \"SUMMARY STATISTICS\";  SELECT COUNT(*) executions, sys.format_time(SUM(timer_wait)) AS exec_time, sys.format_time(SUM(lock_time)) AS lock_time, SUM(rows_sent) AS rows_sent, SUM(rows_affected) AS rows_affected, SUM(rows_examined) AS rows_examined, SUM(created_tmp_tables) AS tmp_tables, SUM(no_index_used) AS full_scans FROM stmt_trace;  SELECT event_name, COUNT(*) as count, sys.format_time(SUM(timer_wait)) as latency FROM stmt_stages GROUP BY event_name ORDER BY SUM(timer_wait) DESC;  SELECT \"LONGEST RUNNING STATEMENT\";  SELECT thread_id, sys.format_time(timer_wait) AS exec_time, sys.format_time(lock_time) AS lock_time, rows_sent, rows_affected, rows_examined, created_tmp_tables AS tmp_tables, no_index_used AS full_scan FROM stmt_trace ORDER BY timer_wait DESC LIMIT 1;  SELECT sql_text FROM stmt_trace ORDER BY timer_wait DESC LIMIT 1;  SELECT sql_text, event_id INTO @sql, @sql_id FROM stmt_trace ORDER BY timer_wait DESC LIMIT 1;  IF (@sql_id IS NOT NULL) THEN SELECT event_name, sys.format_time(timer_wait) as latency FROM stmt_stages WHERE stmt_id = @sql_id ORDER BY event_id; END IF;  DROP TEMPORARY TABLE stmt_trace; DROP TEMPORARY TABLE stmt_stages;  IF (@sql IS NOT NULL) THEN SET @stmt := CONCAT(\"EXPLAIN FORMAT=JSON \", @sql); BEGIN DECLARE CONTINUE HANDLER FOR 1064, 1146 SET v_explain = false;  PREPARE explain_stmt FROM @stmt; END;  IF (v_explain) THEN EXECUTE explain_stmt; DEALLOCATE PREPARE explain_stmt; END IF; END IF;  IF v_auto_enable THEN CALL sys.ps_setup_reload_saved(); END IF; IF (v_this_thread_enabed = \'YES\') THEN CALL sys.ps_setup_enable_thread(CONNECTION_ID()); END IF;  SET sql_log_bin = @log_bin; END','mysql.sys@localhost','2017-03-02 18:46:53','2017-03-02 18:46:53','','\n Description\n \n Traces all instrumentation within Performance Schema for a specific\n Statement Digest. \n \n When finding a statement of interest within the \n performance_schema.events_statements_summary_by_digest table, feed\n the DIGEST MD5 value in to this procedure, set how long to poll for, \n and at what interval to poll, and it will generate a report of all \n statistics tracked within Performance Schema for that digest for the\n interval.\n \n It will also attempt to generate an EXPLAIN for the longest running \n example of the digest during the interval. Note this may fail, as:\n \n * Performance Schema truncates long SQL_TEXT values (and hence the \n EXPLAIN will fail due to parse errors)\n * the default schema is sys (so tables that are not fully qualified\n in the query may not be found)\n * some queries such as SHOW are not supported in EXPLAIN.\n \n When the EXPLAIN fails, the error will be ignored and no EXPLAIN\n output generated.\n \n Requires the SUPER privilege for \"SET sql_log_bin = 0;\".\n \n Parameters\n \n in_digest (VARCHAR(32)):\n The statement digest identifier you would like to analyze\n in_runtime (INT):\n The number of seconds to run analysis for\n in_interval (DECIMAL(2,2)):\n The interval (in seconds, may be fractional) at which to try\n and take snapshots\n in_start_fresh (BOOLEAN):\n Whether to TRUNCATE the events_statements_history_long and\n events_stages_history_long tables before starting\n in_auto_enable (BOOLEAN):\n Whether to automatically turn on required consumers\n \n Example\n \n mysql> call ps_trace_statement_digest(\'891ec6860f98ba46d89dd20b0c03652c\', 10, 0.1, true, true);\n +--------------------+\n | SUMMARY STATISTICS |\n +--------------------+\n | SUMMARY STATISTICS |\n +--------------------+\n 1 row in set (9.11 sec)\n \n +------------+-----------+-----------+-----------+---------------+------------+------------+\n | executions | exec_time | lock_time | rows_sent | rows_examined | tmp_tables | full_scans |\n +------------+-----------+-----------+-----------+---------------+------------+------------+\n |         21 | 4.11 ms   | 2.00 ms   |         0 |            21 |          0 |          0 |\n +------------+-----------+-----------+-----------+---------------+------------+------------+\n 1 row in set (9.11 sec)\n \n +------------------------------------------+-------+-----------+\n | event_name                               | count | latency   |\n +------------------------------------------+-------+-----------+\n | stage/sql/checking query cache for query |    16 | 724.37 us |\n | stage/sql/statistics                     |    16 | 546.92 us |\n | stage/sql/freeing items                  |    18 | 520.11 us |\n | stage/sql/init                           |    51 | 466.80 us |\n ...\n | stage/sql/cleaning up                    |    18 | 11.92 us  |\n | stage/sql/executing                      |    16 | 6.95 us   |\n +------------------------------------------+-------+-----------+\n 17 rows in set (9.12 sec)\n \n +---------------------------+\n | LONGEST RUNNING STATEMENT |\n +---------------------------+\n | LONGEST RUNNING STATEMENT |\n +---------------------------+\n 1 row in set (9.16 sec)\n \n +-----------+-----------+-----------+-----------+---------------+------------+-----------+\n | thread_id | exec_time | lock_time | rows_sent | rows_examined | tmp_tables | full_scan |\n +-----------+-----------+-----------+-----------+---------------+------------+-----------+\n |    166646 | 618.43 us | 1.00 ms   |         0 |             1 |          0 |         0 |\n +-----------+-----------+-----------+-----------+---------------+------------+-----------+\n 1 row in set (9.16 sec)\n \n // Truncated for clarity...\n +-----------------------------------------------------------------+\n | sql_text                                                        |\n +-----------------------------------------------------------------+\n | select hibeventhe0_.id as id1382_, hibeventhe0_.createdTime ... |\n +-----------------------------------------------------------------+\n 1 row in set (9.17 sec)\n \n +------------------------------------------+-----------+\n | event_name                               | latency   |\n +------------------------------------------+-----------+\n | stage/sql/init                           | 8.61 us   |\n | stage/sql/Waiting for query cache lock   | 453.23 us |\n | stage/sql/init                           | 331.07 ns |\n | stage/sql/checking query cache for query | 43.04 us  |\n ...\n | stage/sql/freeing items                  | 30.46 us  |\n | stage/sql/cleaning up                    | 662.13 ns |\n +------------------------------------------+-----------+\n 18 rows in set (9.23 sec)\n \n +----+-------------+--------------+-------+---------------+-----------+---------+-------------+------+-------+\n | id | select_type | table        | type  | possible_keys | key       | key_len | ref         | rows | Extra |\n +----+-------------+--------------+-------+---------------+-----------+---------+-------------+------+-------+\n |  1 | SIMPLE      | hibeventhe0_ | const | fixedTime     | fixedTime | 775     | const,const |    1 | NULL  |\n +----+-------------+--------------+-------+---------------+-----------+---------+-------------+------+-------+\n 1 row in set (9.27 sec)\n \n Query OK, 0 rows affected (9.28 sec)\n ','utf8','utf8_general_ci','utf8_general_ci',_binary 'BEGIN  DECLARE v_start_fresh BOOLEAN DEFAULT false; DECLARE v_auto_enable BOOLEAN DEFAULT false; DECLARE v_explain     BOOLEAN DEFAULT true; DECLARE v_this_thread_enabed ENUM(\'YES\', \'NO\'); DECLARE v_runtime INT DEFAULT 0; DECLARE v_start INT DEFAULT 0; DECLARE v_found_stmts INT;  SET @log_bin := @@sql_log_bin; SET sql_log_bin = 0;  SELECT INSTRUMENTED INTO v_this_thread_enabed FROM performance_schema.threads WHERE PROCESSLIST_ID = CONNECTION_ID(); CALL sys.ps_setup_disable_thread(CONNECTION_ID());  DROP TEMPORARY TABLE IF EXISTS stmt_trace; CREATE TEMPORARY TABLE stmt_trace ( thread_id BIGINT UNSIGNED, timer_start BIGINT UNSIGNED, event_id BIGINT UNSIGNED, sql_text longtext, timer_wait BIGINT UNSIGNED, lock_time BIGINT UNSIGNED, errors BIGINT UNSIGNED, mysql_errno INT, rows_sent BIGINT UNSIGNED, rows_affected BIGINT UNSIGNED, rows_examined BIGINT UNSIGNED, created_tmp_tables BIGINT UNSIGNED, created_tmp_disk_tables BIGINT UNSIGNED, no_index_used BIGINT UNSIGNED, PRIMARY KEY (thread_id, timer_start) );  DROP TEMPORARY TABLE IF EXISTS stmt_stages; CREATE TEMPORARY TABLE stmt_stages ( event_id BIGINT UNSIGNED, stmt_id BIGINT UNSIGNED, event_name VARCHAR(128), timer_wait BIGINT UNSIGNED, PRIMARY KEY (event_id) );  SET v_start_fresh = in_start_fresh; IF v_start_fresh THEN TRUNCATE TABLE performance_schema.events_statements_history_long; TRUNCATE TABLE performance_schema.events_stages_history_long; END IF;  SET v_auto_enable = in_auto_enable; IF v_auto_enable THEN CALL sys.ps_setup_save(0);  UPDATE performance_schema.threads SET INSTRUMENTED = IF(PROCESSLIST_ID IS NOT NULL, \'YES\', \'NO\');  UPDATE performance_schema.setup_consumers SET ENABLED = \'YES\' WHERE NAME NOT LIKE \'%\\_history\' AND NAME NOT LIKE \'events_wait%\' AND NAME NOT LIKE \'events_transactions%\' AND NAME <> \'statements_digest\';  UPDATE performance_schema.setup_instruments SET ENABLED = \'YES\', TIMED   = \'YES\' WHERE NAME LIKE \'statement/%\' OR NAME LIKE \'stage/%\'; END IF;  WHILE v_runtime < in_runtime DO SELECT UNIX_TIMESTAMP() INTO v_start;  INSERT IGNORE INTO stmt_trace SELECT thread_id, timer_start, event_id, sql_text, timer_wait, lock_time, errors, mysql_errno,  rows_sent, rows_affected, rows_examined, created_tmp_tables, created_tmp_disk_tables, no_index_used FROM performance_schema.events_statements_history_long WHERE digest = in_digest;  INSERT IGNORE INTO stmt_stages SELECT stages.event_id, stmt_trace.event_id, stages.event_name, stages.timer_wait FROM performance_schema.events_stages_history_long AS stages JOIN stmt_trace ON stages.nesting_event_id = stmt_trace.event_id;  SELECT SLEEP(in_interval) INTO @sleep; SET v_runtime = v_runtime + (UNIX_TIMESTAMP() - v_start); END WHILE;  SELECT \"SUMMARY STATISTICS\";  SELECT COUNT(*) executions, sys.format_time(SUM(timer_wait)) AS exec_time, sys.format_time(SUM(lock_time)) AS lock_time, SUM(rows_sent) AS rows_sent, SUM(rows_affected) AS rows_affected, SUM(rows_examined) AS rows_examined, SUM(created_tmp_tables) AS tmp_tables, SUM(no_index_used) AS full_scans FROM stmt_trace;  SELECT event_name, COUNT(*) as count, sys.format_time(SUM(timer_wait)) as latency FROM stmt_stages GROUP BY event_name ORDER BY SUM(timer_wait) DESC;  SELECT \"LONGEST RUNNING STATEMENT\";  SELECT thread_id, sys.format_time(timer_wait) AS exec_time, sys.format_time(lock_time) AS lock_time, rows_sent, rows_affected, rows_examined, created_tmp_tables AS tmp_tables, no_index_used AS full_scan FROM stmt_trace ORDER BY timer_wait DESC LIMIT 1;  SELECT sql_text FROM stmt_trace ORDER BY timer_wait DESC LIMIT 1;  SELECT sql_text, event_id INTO @sql, @sql_id FROM stmt_trace ORDER BY timer_wait DESC LIMIT 1;  IF (@sql_id IS NOT NULL) THEN SELECT event_name, sys.format_time(timer_wait) as latency FROM stmt_stages WHERE stmt_id = @sql_id ORDER BY event_id; END IF;  DROP TEMPORARY TABLE stmt_trace; DROP TEMPORARY TABLE stmt_stages;  IF (@sql IS NOT NULL) THEN SET @stmt := CONCAT(\"EXPLAIN FORMAT=JSON \", @sql); BEGIN DECLARE CONTINUE HANDLER FOR 1064, 1146 SET v_explain = false;  PREPARE explain_stmt FROM @stmt; END;  IF (v_explain) THEN EXECUTE explain_stmt; DEALLOCATE PREPARE explain_stmt; END IF; END IF;  IF v_auto_enable THEN CALL sys.ps_setup_reload_saved(); END IF; IF (v_this_thread_enabed = \'YES\') THEN CALL sys.ps_setup_enable_thread(CONNECTION_ID()); END IF;  SET sql_log_bin = @log_bin; END'),('sys','ps_trace_thread','PROCEDURE','ps_trace_thread','SQL','MODIFIES_SQL_DATA','NO','INVOKER',_binary ' IN in_thread_id BIGINT UNSIGNED, IN in_outfile VARCHAR(255), IN in_max_runtime DECIMAL(20,2), IN in_interval DECIMAL(20,2), IN in_start_fresh BOOLEAN, IN in_auto_setup BOOLEAN, IN in_debug BOOLEAN ','',_binary 'BEGIN DECLARE v_done bool DEFAULT FALSE; DECLARE v_start, v_runtime DECIMAL(20,2) DEFAULT 0.0; DECLARE v_min_event_id bigint unsigned DEFAULT 0; DECLARE v_this_thread_enabed ENUM(\'YES\', \'NO\'); DECLARE v_event longtext; DECLARE c_stack CURSOR FOR SELECT CONCAT(IF(nesting_event_id IS NOT NULL, CONCAT(nesting_event_id, \' -> \'), \'\'),  event_id, \'; \', event_id, \' [label=\"\', \'(\', sys.format_time(timer_wait), \') \', IF (event_name NOT LIKE \'wait/io%\',  SUBSTRING_INDEX(event_name, \'/\', -2),  IF (event_name NOT LIKE \'wait/io/file%\' OR event_name NOT LIKE \'wait/io/socket%\', SUBSTRING_INDEX(event_name, \'/\', -4), event_name) ), IF (event_name LIKE \'transaction\', IFNULL(CONCAT(\'\\\\n\', wait_info), \'\'), \'\'), IF (event_name LIKE \'statement/%\', IFNULL(CONCAT(\'\\\\n\', wait_info), \'\'), \'\'), IF (in_debug AND event_name LIKE \'wait%\', wait_info, \'\'), \'\", \',  CASE WHEN event_name LIKE \'wait/io/file%\' THEN  \'shape=box, style=filled, color=red\' WHEN event_name LIKE \'wait/io/table%\' THEN  \'shape=box, style=filled, color=green\' WHEN event_name LIKE \'wait/io/socket%\' THEN \'shape=box, style=filled, color=yellow\' WHEN event_name LIKE \'wait/synch/mutex%\' THEN \'style=filled, color=lightskyblue\' WHEN event_name LIKE \'wait/synch/cond%\' THEN \'style=filled, color=darkseagreen3\' WHEN event_name LIKE \'wait/synch/rwlock%\' THEN \'style=filled, color=orchid\' WHEN event_name LIKE \'wait/synch/sxlock%\' THEN \'style=filled, color=palevioletred\'  WHEN event_name LIKE \'wait/lock%\' THEN \'shape=box, style=filled, color=tan\' WHEN event_name LIKE \'statement/%\' THEN CONCAT(\'shape=box, style=bold\', CASE WHEN event_name LIKE \'statement/com/%\' THEN \' style=filled, color=darkseagreen\' ELSE IF((timer_wait/1000000000000) > @@long_query_time,  \' style=filled, color=red\',  \' style=filled, color=lightblue\') END ) WHEN event_name LIKE \'transaction\' THEN \'shape=box, style=filled, color=lightblue3\' WHEN event_name LIKE \'stage/%\' THEN \'style=filled, color=slategray3\' WHEN event_name LIKE \'%idle%\' THEN \'shape=box, style=filled, color=firebrick3\' ELSE \'\' END, \'];\\n\' ) event, event_id FROM ( (SELECT thread_id, event_id, event_name, timer_wait, timer_start, nesting_event_id, CONCAT(\'trx_id: \',  IFNULL(trx_id, \'\'), \'\\\\n\', \'gtid: \', IFNULL(gtid, \'\'), \'\\\\n\', \'state: \', state, \'\\\\n\', \'mode: \', access_mode, \'\\\\n\', \'isolation: \', isolation_level, \'\\\\n\', \'autocommit: \', autocommit, \'\\\\n\', \'savepoints: \', number_of_savepoints, \'\\\\n\' ) AS wait_info FROM performance_schema.events_transactions_history_long WHERE thread_id = in_thread_id AND event_id > v_min_event_id) UNION (SELECT thread_id, event_id, event_name, timer_wait, timer_start, nesting_event_id,  CONCAT(\'statement: \', sql_text, \'\\\\n\', \'errors: \', errors, \'\\\\n\', \'warnings: \', warnings, \'\\\\n\', \'lock time: \', sys.format_time(lock_time),\'\\\\n\', \'rows affected: \', rows_affected, \'\\\\n\', \'rows sent: \', rows_sent, \'\\\\n\', \'rows examined: \', rows_examined, \'\\\\n\', \'tmp tables: \', created_tmp_tables, \'\\\\n\', \'tmp disk tables: \', created_tmp_disk_tables, \'\\\\n\' \'select scan: \', select_scan, \'\\\\n\', \'select full join: \', select_full_join, \'\\\\n\', \'select full range join: \', select_full_range_join, \'\\\\n\', \'select range: \', select_range, \'\\\\n\', \'select range check: \', select_range_check, \'\\\\n\',  \'sort merge passes: \', sort_merge_passes, \'\\\\n\', \'sort rows: \', sort_rows, \'\\\\n\', \'sort range: \', sort_range, \'\\\\n\', \'sort scan: \', sort_scan, \'\\\\n\', \'no index used: \', IF(no_index_used, \'TRUE\', \'FALSE\'), \'\\\\n\', \'no good index used: \', IF(no_good_index_used, \'TRUE\', \'FALSE\'), \'\\\\n\' ) AS wait_info FROM performance_schema.events_statements_history_long WHERE thread_id = in_thread_id AND event_id > v_min_event_id) UNION (SELECT thread_id, event_id, event_name, timer_wait, timer_start, nesting_event_id, null AS wait_info FROM performance_schema.events_stages_history_long  WHERE thread_id = in_thread_id AND event_id > v_min_event_id) UNION  (SELECT thread_id, event_id,  CONCAT(event_name,  IF(event_name NOT LIKE \'wait/synch/mutex%\', IFNULL(CONCAT(\' - \', operation), \'\'), \'\'),  IF(number_of_bytes IS NOT NULL, CONCAT(\' \', number_of_bytes, \' bytes\'), \'\'), IF(event_name LIKE \'wait/io/file%\', \'\\\\n\', \'\'), IF(object_schema IS NOT NULL, CONCAT(\'\\\\nObject: \', object_schema, \'.\'), \'\'),  IF(object_name IS NOT NULL,  IF (event_name LIKE \'wait/io/socket%\', CONCAT(\'\\\\n\', IF (object_name LIKE \':0%\', @@socket, object_name)), object_name), \'\' ), IF(index_name IS NOT NULL, CONCAT(\' Index: \', index_name), \'\'), \'\\\\n\' ) AS event_name, timer_wait, timer_start, nesting_event_id, source AS wait_info FROM performance_schema.events_waits_history_long WHERE thread_id = in_thread_id AND event_id > v_min_event_id) ) events  ORDER BY event_id; DECLARE CONTINUE HANDLER FOR NOT FOUND SET v_done = TRUE;  SET @log_bin := @@sql_log_bin; SET sql_log_bin = 0;  SELECT INSTRUMENTED INTO v_this_thread_enabed FROM performance_schema.threads WHERE PROCESSLIST_ID = CONNECTION_ID(); CALL sys.ps_setup_disable_thread(CONNECTION_ID());  IF (in_auto_setup) THEN CALL sys.ps_setup_save(0);  DELETE FROM performance_schema.setup_actors;  UPDATE performance_schema.threads SET INSTRUMENTED = IF(THREAD_ID = in_thread_id, \'YES\', \'NO\');  UPDATE performance_schema.setup_consumers SET ENABLED = \'YES\' WHERE NAME NOT LIKE \'%\\_history\';  UPDATE performance_schema.setup_instruments SET ENABLED = \'YES\', TIMED   = \'YES\'; END IF;  IF (in_start_fresh) THEN TRUNCATE performance_schema.events_transactions_history_long; TRUNCATE performance_schema.events_statements_history_long; TRUNCATE performance_schema.events_stages_history_long; TRUNCATE performance_schema.events_waits_history_long; END IF;  DROP TEMPORARY TABLE IF EXISTS tmp_events; CREATE TEMPORARY TABLE tmp_events ( event_id bigint unsigned NOT NULL, event longblob, PRIMARY KEY (event_id) );  INSERT INTO tmp_events VALUES (0, CONCAT(\'digraph events { rankdir=LR; nodesep=0.10;\\n\', \'// Stack created .....: \', NOW(), \'\\n\', \'// MySQL version .....: \', VERSION(), \'\\n\', \'// MySQL hostname ....: \', @@hostname, \'\\n\', \'// MySQL port ........: \', @@port, \'\\n\', \'// MySQL socket ......: \', @@socket, \'\\n\', \'// MySQL user ........: \', CURRENT_USER(), \'\\n\'));  SELECT CONCAT(\'Data collection starting for THREAD_ID = \', in_thread_id) AS \'Info\';  SET v_min_event_id = 0, v_start        = UNIX_TIMESTAMP(), in_interval    = IFNULL(in_interval, 1.00), in_max_runtime = IFNULL(in_max_runtime, 60.00);  WHILE (v_runtime < in_max_runtime AND (SELECT INSTRUMENTED FROM performance_schema.threads WHERE THREAD_ID = in_thread_id) = \'YES\') DO SET v_done = FALSE; OPEN c_stack; c_stack_loop: LOOP FETCH c_stack INTO v_event, v_min_event_id; IF v_done THEN LEAVE c_stack_loop; END IF;  IF (LENGTH(v_event) > 0) THEN INSERT INTO tmp_events VALUES (v_min_event_id, v_event); END IF; END LOOP; CLOSE c_stack;  SELECT SLEEP(in_interval) INTO @sleep; SET v_runtime = (UNIX_TIMESTAMP() - v_start); END WHILE;  INSERT INTO tmp_events VALUES (v_min_event_id+1, \'}\');  SET @query = CONCAT(\'SELECT event FROM tmp_events ORDER BY event_id INTO OUTFILE \'\'\', in_outfile, \'\'\' FIELDS ESCAPED BY \'\'\'\' LINES TERMINATED BY \'\'\'\'\'); PREPARE stmt_output FROM @query; EXECUTE stmt_output; DEALLOCATE PREPARE stmt_output;  SELECT CONCAT(\'Stack trace written to \', in_outfile) AS \'Info\'; SELECT CONCAT(\'dot -Tpdf -o /tmp/stack_\', in_thread_id, \'.pdf \', in_outfile) AS \'Convert to PDF\'; SELECT CONCAT(\'dot -Tpng -o /tmp/stack_\', in_thread_id, \'.png \', in_outfile) AS \'Convert to PNG\'; DROP TEMPORARY TABLE tmp_events;  IF (in_auto_setup) THEN CALL sys.ps_setup_reload_saved(); END IF; IF (v_this_thread_enabed = \'YES\') THEN CALL sys.ps_setup_enable_thread(CONNECTION_ID()); END IF;  SET sql_log_bin = @log_bin; END','mysql.sys@localhost','2017-03-02 18:46:53','2017-03-02 18:46:53','','\n Description\n \n Dumps all data within Performance Schema for an instrumented thread,\n to create a DOT formatted graph file. \n \n Each resultset returned from the procedure should be used for a complete graph\n \n Requires the SUPER privilege for \"SET sql_log_bin = 0;\".\n \n Parameters\n \n in_thread_id (BIGINT UNSIGNED):\n The thread that you would like a stack trace for\n in_outfile  (VARCHAR(255)):\n The filename the dot file will be written to\n in_max_runtime (DECIMAL(20,2)):\n The maximum time to keep collecting data.\n Use NULL to get the default which is 60 seconds.\n in_interval (DECIMAL(20,2)): \n How long to sleep between data collections. \n Use NULL to get the default which is 1 second.\n in_start_fresh (BOOLEAN):\n Whether to reset all Performance Schema data before tracing.\n in_auto_setup (BOOLEAN):\n Whether to disable all other threads and enable all consumers/instruments. \n This will also reset the settings at the end of the run.\n in_debug (BOOLEAN):\n Whether you would like to include file:lineno in the graph\n \n Example\n \n mysql> CALL sys.ps_trace_thread(25, CONCAT(\'/tmp/stack-\', REPLACE(NOW(), \' \', \'-\'), \'.dot\'), NULL, NULL, TRUE, TRUE, TRUE);\n +-------------------+\n | summary           |\n +-------------------+\n | Disabled 1 thread |\n +-------------------+\n 1 row in set (0.00 sec)\n \n +---------------------------------------------+\n | Info                                        |\n +---------------------------------------------+\n | Data collection starting for THREAD_ID = 25 |\n +---------------------------------------------+\n 1 row in set (0.03 sec)\n \n +-----------------------------------------------------------+\n | Info                                                      |\n +-----------------------------------------------------------+\n | Stack trace written to /tmp/stack-2014-02-16-21:18:41.dot |\n +-----------------------------------------------------------+\n 1 row in set (60.07 sec)\n \n +-------------------------------------------------------------------+\n | Convert to PDF                                                    |\n +-------------------------------------------------------------------+\n | dot -Tpdf -o /tmp/stack_25.pdf /tmp/stack-2014-02-16-21:18:41.dot |\n +-------------------------------------------------------------------+\n 1 row in set (60.07 sec)\n \n +-------------------------------------------------------------------+\n | Convert to PNG                                                    |\n +-------------------------------------------------------------------+\n | dot -Tpng -o /tmp/stack_25.png /tmp/stack-2014-02-16-21:18:41.dot |\n +-------------------------------------------------------------------+\n 1 row in set (60.07 sec)\n \n +------------------+\n | summary          |\n +------------------+\n | Enabled 1 thread |\n +------------------+\n 1 row in set (60.32 sec)\n ','utf8','utf8_general_ci','utf8_general_ci',_binary 'BEGIN DECLARE v_done bool DEFAULT FALSE; DECLARE v_start, v_runtime DECIMAL(20,2) DEFAULT 0.0; DECLARE v_min_event_id bigint unsigned DEFAULT 0; DECLARE v_this_thread_enabed ENUM(\'YES\', \'NO\'); DECLARE v_event longtext; DECLARE c_stack CURSOR FOR SELECT CONCAT(IF(nesting_event_id IS NOT NULL, CONCAT(nesting_event_id, \' -> \'), \'\'),  event_id, \'; \', event_id, \' [label=\"\', \'(\', sys.format_time(timer_wait), \') \', IF (event_name NOT LIKE \'wait/io%\',  SUBSTRING_INDEX(event_name, \'/\', -2),  IF (event_name NOT LIKE \'wait/io/file%\' OR event_name NOT LIKE \'wait/io/socket%\', SUBSTRING_INDEX(event_name, \'/\', -4), event_name) ), IF (event_name LIKE \'transaction\', IFNULL(CONCAT(\'\\n\', wait_info), \'\'), \'\'), IF (event_name LIKE \'statement/%\', IFNULL(CONCAT(\'\\n\', wait_info), \'\'), \'\'), IF (in_debug AND event_name LIKE \'wait%\', wait_info, \'\'), \'\", \',  CASE WHEN event_name LIKE \'wait/io/file%\' THEN  \'shape=box, style=filled, color=red\' WHEN event_name LIKE \'wait/io/table%\' THEN  \'shape=box, style=filled, color=green\' WHEN event_name LIKE \'wait/io/socket%\' THEN \'shape=box, style=filled, color=yellow\' WHEN event_name LIKE \'wait/synch/mutex%\' THEN \'style=filled, color=lightskyblue\' WHEN event_name LIKE \'wait/synch/cond%\' THEN \'style=filled, color=darkseagreen3\' WHEN event_name LIKE \'wait/synch/rwlock%\' THEN \'style=filled, color=orchid\' WHEN event_name LIKE \'wait/synch/sxlock%\' THEN \'style=filled, color=palevioletred\'  WHEN event_name LIKE \'wait/lock%\' THEN \'shape=box, style=filled, color=tan\' WHEN event_name LIKE \'statement/%\' THEN CONCAT(\'shape=box, style=bold\', CASE WHEN event_name LIKE \'statement/com/%\' THEN \' style=filled, color=darkseagreen\' ELSE IF((timer_wait/1000000000000) > @@long_query_time,  \' style=filled, color=red\',  \' style=filled, color=lightblue\') END ) WHEN event_name LIKE \'transaction\' THEN \'shape=box, style=filled, color=lightblue3\' WHEN event_name LIKE \'stage/%\' THEN \'style=filled, color=slategray3\' WHEN event_name LIKE \'%idle%\' THEN \'shape=box, style=filled, color=firebrick3\' ELSE \'\' END, \'];\n\' ) event, event_id FROM ( (SELECT thread_id, event_id, event_name, timer_wait, timer_start, nesting_event_id, CONCAT(\'trx_id: \',  IFNULL(trx_id, \'\'), \'\\n\', \'gtid: \', IFNULL(gtid, \'\'), \'\\n\', \'state: \', state, \'\\n\', \'mode: \', access_mode, \'\\n\', \'isolation: \', isolation_level, \'\\n\', \'autocommit: \', autocommit, \'\\n\', \'savepoints: \', number_of_savepoints, \'\\n\' ) AS wait_info FROM performance_schema.events_transactions_history_long WHERE thread_id = in_thread_id AND event_id > v_min_event_id) UNION (SELECT thread_id, event_id, event_name, timer_wait, timer_start, nesting_event_id,  CONCAT(\'statement: \', sql_text, \'\\n\', \'errors: \', errors, \'\\n\', \'warnings: \', warnings, \'\\n\', \'lock time: \', sys.format_time(lock_time),\'\\n\', \'rows affected: \', rows_affected, \'\\n\', \'rows sent: \', rows_sent, \'\\n\', \'rows examined: \', rows_examined, \'\\n\', \'tmp tables: \', created_tmp_tables, \'\\n\', \'tmp disk tables: \', created_tmp_disk_tables, \'\\n\' \'select scan: \', select_scan, \'\\n\', \'select full join: \', select_full_join, \'\\n\', \'select full range join: \', select_full_range_join, \'\\n\', \'select range: \', select_range, \'\\n\', \'select range check: \', select_range_check, \'\\n\',  \'sort merge passes: \', sort_merge_passes, \'\\n\', \'sort rows: \', sort_rows, \'\\n\', \'sort range: \', sort_range, \'\\n\', \'sort scan: \', sort_scan, \'\\n\', \'no index used: \', IF(no_index_used, \'TRUE\', \'FALSE\'), \'\\n\', \'no good index used: \', IF(no_good_index_used, \'TRUE\', \'FALSE\'), \'\\n\' ) AS wait_info FROM performance_schema.events_statements_history_long WHERE thread_id = in_thread_id AND event_id > v_min_event_id) UNION (SELECT thread_id, event_id, event_name, timer_wait, timer_start, nesting_event_id, null AS wait_info FROM performance_schema.events_stages_history_long  WHERE thread_id = in_thread_id AND event_id > v_min_event_id) UNION  (SELECT thread_id, event_id,  CONCAT(event_name,  IF(event_name NOT LIKE \'wait/synch/mutex%\', IFNULL(CONCAT(\' - \', operation), \'\'), \'\'),  IF(number_of_bytes IS NOT NULL, CONCAT(\' \', number_of_bytes, \' bytes\'), \'\'), IF(event_name LIKE \'wait/io/file%\', \'\\n\', \'\'), IF(object_schema IS NOT NULL, CONCAT(\'\\nObject: \', object_schema, \'.\'), \'\'),  IF(object_name IS NOT NULL,  IF (event_name LIKE \'wait/io/socket%\', CONCAT(\'\\n\', IF (object_name LIKE \':0%\', @@socket, object_name)), object_name), \'\' ), IF(index_name IS NOT NULL, CONCAT(\' Index: \', index_name), \'\'), \'\\n\' ) AS event_name, timer_wait, timer_start, nesting_event_id, source AS wait_info FROM performance_schema.events_waits_history_long WHERE thread_id = in_thread_id AND event_id > v_min_event_id) ) events  ORDER BY event_id; DECLARE CONTINUE HANDLER FOR NOT FOUND SET v_done = TRUE;  SET @log_bin := @@sql_log_bin; SET sql_log_bin = 0;  SELECT INSTRUMENTED INTO v_this_thread_enabed FROM performance_schema.threads WHERE PROCESSLIST_ID = CONNECTION_ID(); CALL sys.ps_setup_disable_thread(CONNECTION_ID());  IF (in_auto_setup) THEN CALL sys.ps_setup_save(0);  DELETE FROM performance_schema.setup_actors;  UPDATE performance_schema.threads SET INSTRUMENTED = IF(THREAD_ID = in_thread_id, \'YES\', \'NO\');  UPDATE performance_schema.setup_consumers SET ENABLED = \'YES\' WHERE NAME NOT LIKE \'%\\_history\';  UPDATE performance_schema.setup_instruments SET ENABLED = \'YES\', TIMED   = \'YES\'; END IF;  IF (in_start_fresh) THEN TRUNCATE performance_schema.events_transactions_history_long; TRUNCATE performance_schema.events_statements_history_long; TRUNCATE performance_schema.events_stages_history_long; TRUNCATE performance_schema.events_waits_history_long; END IF;  DROP TEMPORARY TABLE IF EXISTS tmp_events; CREATE TEMPORARY TABLE tmp_events ( event_id bigint unsigned NOT NULL, event longblob, PRIMARY KEY (event_id) );  INSERT INTO tmp_events VALUES (0, CONCAT(\'digraph events { rankdir=LR; nodesep=0.10;\n\', \'// Stack created .....: \', NOW(), \'\n\', \'// MySQL version .....: \', VERSION(), \'\n\', \'// MySQL hostname ....: \', @@hostname, \'\n\', \'// MySQL port ........: \', @@port, \'\n\', \'// MySQL socket ......: \', @@socket, \'\n\', \'// MySQL user ........: \', CURRENT_USER(), \'\n\'));  SELECT CONCAT(\'Data collection starting for THREAD_ID = \', in_thread_id) AS \'Info\';  SET v_min_event_id = 0, v_start        = UNIX_TIMESTAMP(), in_interval    = IFNULL(in_interval, 1.00), in_max_runtime = IFNULL(in_max_runtime, 60.00);  WHILE (v_runtime < in_max_runtime AND (SELECT INSTRUMENTED FROM performance_schema.threads WHERE THREAD_ID = in_thread_id) = \'YES\') DO SET v_done = FALSE; OPEN c_stack; c_stack_loop: LOOP FETCH c_stack INTO v_event, v_min_event_id; IF v_done THEN LEAVE c_stack_loop; END IF;  IF (LENGTH(v_event) > 0) THEN INSERT INTO tmp_events VALUES (v_min_event_id, v_event); END IF; END LOOP; CLOSE c_stack;  SELECT SLEEP(in_interval) INTO @sleep; SET v_runtime = (UNIX_TIMESTAMP() - v_start); END WHILE;  INSERT INTO tmp_events VALUES (v_min_event_id+1, \'}\');  SET @query = CONCAT(\'SELECT event FROM tmp_events ORDER BY event_id INTO OUTFILE \'\', in_outfile, \'\' FIELDS ESCAPED BY \'\' LINES TERMINATED BY \'\'\'); PREPARE stmt_output FROM @query; EXECUTE stmt_output; DEALLOCATE PREPARE stmt_output;  SELECT CONCAT(\'Stack trace written to \', in_outfile) AS \'Info\'; SELECT CONCAT(\'dot -Tpdf -o /tmp/stack_\', in_thread_id, \'.pdf \', in_outfile) AS \'Convert to PDF\'; SELECT CONCAT(\'dot -Tpng -o /tmp/stack_\', in_thread_id, \'.png \', in_outfile) AS \'Convert to PNG\'; DROP TEMPORARY TABLE tmp_events;  IF (in_auto_setup) THEN CALL sys.ps_setup_reload_saved(); END IF; IF (v_this_thread_enabed = \'YES\') THEN CALL sys.ps_setup_enable_thread(CONNECTION_ID()); END IF;  SET sql_log_bin = @log_bin; END'),('sys','ps_setup_disable_background_threads','PROCEDURE','ps_setup_disable_background_threads','SQL','MODIFIES_SQL_DATA','NO','INVOKER','','',_binary 'BEGIN UPDATE performance_schema.threads SET instrumented = \'NO\' WHERE type = \'BACKGROUND\';  SELECT CONCAT(\'Disabled \', @rows := ROW_COUNT(), \' background thread\', IF(@rows != 1, \'s\', \'\')) AS summary; END','mysql.sys@localhost','2017-03-02 18:46:53','2017-03-02 18:46:53','','\n Description\n \n Disable all background thread instrumentation within Performance Schema.\n \n Parameters\n \n None.\n \n Example\n \n mysql> CALL sys.ps_setup_disable_background_threads();\n +--------------------------------+\n | summary                        |\n +--------------------------------+\n | Disabled 18 background threads |\n +--------------------------------+\n 1 row in set (0.00 sec)\n ','utf8','utf8_general_ci','utf8_general_ci',_binary 'BEGIN UPDATE performance_schema.threads SET instrumented = \'NO\' WHERE type = \'BACKGROUND\';  SELECT CONCAT(\'Disabled \', @rows := ROW_COUNT(), \' background thread\', IF(@rows != 1, \'s\', \'\')) AS summary; END'),('sys','ps_setup_disable_consumer','PROCEDURE','ps_setup_disable_consumer','SQL','MODIFIES_SQL_DATA','NO','INVOKER',_binary ' IN consumer VARCHAR(128) ','',_binary 'BEGIN UPDATE performance_schema.setup_consumers SET enabled = \'NO\' WHERE name LIKE CONCAT(\'%\', consumer, \'%\');  SELECT CONCAT(\'Disabled \', @rows := ROW_COUNT(), \' consumer\', IF(@rows != 1, \'s\', \'\')) AS summary; END','mysql.sys@localhost','2017-03-02 18:46:53','2017-03-02 18:46:53','','\n Description\n \n Disables consumers within Performance Schema \n matching the input pattern.\n \n Parameters\n \n consumer (VARCHAR(128)):\n A LIKE pattern match (using \"%consumer%\") of consumers to disable\n \n Example\n \n To disable all consumers:\n \n mysql> CALL sys.ps_setup_disable_consumer(\'\');\n +--------------------------+\n | summary                  |\n +--------------------------+\n | Disabled 15 consumers    |\n +--------------------------+\n 1 row in set (0.02 sec)\n \n To disable just the event_stage consumers:\n \n mysql> CALL sys.ps_setup_disable_comsumers(\'stage\');\n +------------------------+\n | summary                |\n +------------------------+\n | Disabled 3 consumers   |\n +------------------------+\n 1 row in set (0.00 sec)\n ','utf8','utf8_general_ci','utf8_general_ci',_binary 'BEGIN UPDATE performance_schema.setup_consumers SET enabled = \'NO\' WHERE name LIKE CONCAT(\'%\', consumer, \'%\');  SELECT CONCAT(\'Disabled \', @rows := ROW_COUNT(), \' consumer\', IF(@rows != 1, \'s\', \'\')) AS summary; END'),('sys','ps_setup_disable_instrument','PROCEDURE','ps_setup_disable_instrument','SQL','MODIFIES_SQL_DATA','NO','INVOKER',_binary ' IN in_pattern VARCHAR(128) ','',_binary 'BEGIN UPDATE performance_schema.setup_instruments SET enabled = \'NO\', timed = \'NO\' WHERE name LIKE CONCAT(\'%\', in_pattern, \'%\');  SELECT CONCAT(\'Disabled \', @rows := ROW_COUNT(), \' instrument\', IF(@rows != 1, \'s\', \'\')) AS summary; END','mysql.sys@localhost','2017-03-02 18:46:53','2017-03-02 18:46:53','','\n Description\n \n Disables instruments within Performance Schema \n matching the input pattern.\n \n Parameters\n \n in_pattern (VARCHAR(128)):\n A LIKE pattern match (using \"%in_pattern%\") of events to disable\n \n Example\n \n To disable all mutex instruments:\n \n mysql> CALL sys.ps_setup_disable_instrument(\'wait/synch/mutex\');\n +--------------------------+\n | summary                  |\n +--------------------------+\n | Disabled 155 instruments |\n +--------------------------+\n 1 row in set (0.02 sec)\n \n To disable just a specific TCP/IP based network IO instrument:\n \n mysql> CALL sys.ps_setup_disable_instrument(\'wait/io/socket/sql/server_tcpip_socket\');\n +------------------------+\n | summary                |\n +------------------------+\n | Disabled 1 instruments |\n +------------------------+\n 1 row in set (0.00 sec)\n \n To disable all instruments:\n \n mysql> CALL sys.ps_setup_disable_instrument(\'\');\n +--------------------------+\n | summary                  |\n +--------------------------+\n | Disabled 547 instruments |\n +--------------------------+\n 1 row in set (0.01 sec)\n ','utf8','utf8_general_ci','utf8_general_ci',_binary 'BEGIN UPDATE performance_schema.setup_instruments SET enabled = \'NO\', timed = \'NO\' WHERE name LIKE CONCAT(\'%\', in_pattern, \'%\');  SELECT CONCAT(\'Disabled \', @rows := ROW_COUNT(), \' instrument\', IF(@rows != 1, \'s\', \'\')) AS summary; END'),('sys','ps_setup_disable_thread','PROCEDURE','ps_setup_disable_thread','SQL','MODIFIES_SQL_DATA','NO','INVOKER',_binary ' IN in_connection_id BIGINT ','',_binary 'BEGIN UPDATE performance_schema.threads SET instrumented = \'NO\' WHERE processlist_id = in_connection_id;  SELECT CONCAT(\'Disabled \', @rows := ROW_COUNT(), \' thread\', IF(@rows != 1, \'s\', \'\')) AS summary; END','mysql.sys@localhost','2017-03-02 18:46:53','2017-03-02 18:46:53','','\n Description\n \n Disable the given connection/thread in Performance Schema.\n \n Parameters\n \n in_connection_id (BIGINT):\n The connection ID (PROCESSLIST_ID from performance_schema.threads\n or the ID shown within SHOW PROCESSLIST)\n \n Example\n \n mysql> CALL sys.ps_setup_disable_thread(3);\n +-------------------+\n | summary           |\n +-------------------+\n | Disabled 1 thread |\n +-------------------+\n 1 row in set (0.01 sec)\n \n To disable the current connection:\n \n mysql> CALL sys.ps_setup_disable_thread(CONNECTION_ID());\n +-------------------+\n | summary           |\n +-------------------+\n | Disabled 1 thread |\n +-------------------+\n 1 row in set (0.00 sec)\n ','utf8','utf8_general_ci','utf8_general_ci',_binary 'BEGIN UPDATE performance_schema.threads SET instrumented = \'NO\' WHERE processlist_id = in_connection_id;  SELECT CONCAT(\'Disabled \', @rows := ROW_COUNT(), \' thread\', IF(@rows != 1, \'s\', \'\')) AS summary; END'),('sys','ps_setup_enable_background_threads','PROCEDURE','ps_setup_enable_background_threads','SQL','MODIFIES_SQL_DATA','NO','INVOKER','','',_binary 'BEGIN UPDATE performance_schema.threads SET instrumented = \'YES\' WHERE type = \'BACKGROUND\';  SELECT CONCAT(\'Enabled \', @rows := ROW_COUNT(), \' background thread\', IF(@rows != 1, \'s\', \'\')) AS summary; END','mysql.sys@localhost','2017-03-02 18:46:53','2017-03-02 18:46:53','','\n Description\n \n Enable all background thread instrumentation within Performance Schema.\n \n Parameters\n \n None.\n \n Example\n \n mysql> CALL sys.ps_setup_enable_background_threads();\n +-------------------------------+\n | summary                       |\n +-------------------------------+\n | Enabled 18 background threads |\n +-------------------------------+\n 1 row in set (0.00 sec)\n ','utf8','utf8_general_ci','utf8_general_ci',_binary 'BEGIN UPDATE performance_schema.threads SET instrumented = \'YES\' WHERE type = \'BACKGROUND\';  SELECT CONCAT(\'Enabled \', @rows := ROW_COUNT(), \' background thread\', IF(@rows != 1, \'s\', \'\')) AS summary; END'),('sys','ps_setup_enable_consumer','PROCEDURE','ps_setup_enable_consumer','SQL','MODIFIES_SQL_DATA','NO','INVOKER',_binary ' IN consumer VARCHAR(128) ','',_binary 'BEGIN UPDATE performance_schema.setup_consumers SET enabled = \'YES\' WHERE name LIKE CONCAT(\'%\', consumer, \'%\');  SELECT CONCAT(\'Enabled \', @rows := ROW_COUNT(), \' consumer\', IF(@rows != 1, \'s\', \'\')) AS summary; END','mysql.sys@localhost','2017-03-02 18:46:53','2017-03-02 18:46:53','','\n Description\n \n Enables consumers within Performance Schema \n matching the input pattern.\n \n Parameters\n \n consumer (VARCHAR(128)):\n A LIKE pattern match (using \"%consumer%\") of consumers to enable\n \n Example\n \n To enable all consumers:\n \n mysql> CALL sys.ps_setup_enable_consumer(\'\');\n +-------------------------+\n | summary                 |\n +-------------------------+\n | Enabled 10 consumers    |\n +-------------------------+\n 1 row in set (0.02 sec)\n \n Query OK, 0 rows affected (0.02 sec)\n \n To enable just \"waits\" consumers:\n \n mysql> CALL sys.ps_setup_enable_consumer(\'waits\');\n +-----------------------+\n | summary               |\n +-----------------------+\n | Enabled 3 consumers   |\n +-----------------------+\n 1 row in set (0.00 sec)\n \n Query OK, 0 rows affected (0.00 sec)\n ','utf8','utf8_general_ci','utf8_general_ci',_binary 'BEGIN UPDATE performance_schema.setup_consumers SET enabled = \'YES\' WHERE name LIKE CONCAT(\'%\', consumer, \'%\');  SELECT CONCAT(\'Enabled \', @rows := ROW_COUNT(), \' consumer\', IF(@rows != 1, \'s\', \'\')) AS summary; END'),('sys','ps_setup_enable_instrument','PROCEDURE','ps_setup_enable_instrument','SQL','MODIFIES_SQL_DATA','NO','INVOKER',_binary ' IN in_pattern VARCHAR(128) ','',_binary 'BEGIN UPDATE performance_schema.setup_instruments SET enabled = \'YES\', timed = \'YES\' WHERE name LIKE CONCAT(\'%\', in_pattern, \'%\');  SELECT CONCAT(\'Enabled \', @rows := ROW_COUNT(), \' instrument\', IF(@rows != 1, \'s\', \'\')) AS summary; END','mysql.sys@localhost','2017-03-02 18:46:53','2017-03-02 18:46:53','','\n Description\n \n Enables instruments within Performance Schema \n matching the input pattern.\n \n Parameters\n \n in_pattern (VARCHAR(128)):\n A LIKE pattern match (using \"%in_pattern%\") of events to enable\n \n Example\n \n To enable all mutex instruments:\n \n mysql> CALL sys.ps_setup_enable_instrument(\'wait/synch/mutex\');\n +-------------------------+\n | summary                 |\n +-------------------------+\n | Enabled 155 instruments |\n +-------------------------+\n 1 row in set (0.02 sec)\n \n Query OK, 0 rows affected (0.02 sec)\n \n To enable just a specific TCP/IP based network IO instrument:\n \n mysql> CALL sys.ps_setup_enable_instrument(\'wait/io/socket/sql/server_tcpip_socket\');\n +-----------------------+\n | summary               |\n +-----------------------+\n | Enabled 1 instruments |\n +-----------------------+\n 1 row in set (0.00 sec)\n \n Query OK, 0 rows affected (0.00 sec)\n \n To enable all instruments:\n \n mysql> CALL sys.ps_setup_enable_instrument(\'\');\n +-------------------------+\n | summary                 |\n +-------------------------+\n | Enabled 547 instruments |\n +-------------------------+\n 1 row in set (0.01 sec)\n \n Query OK, 0 rows affected (0.01 sec)\n ','utf8','utf8_general_ci','utf8_general_ci',_binary 'BEGIN UPDATE performance_schema.setup_instruments SET enabled = \'YES\', timed = \'YES\' WHERE name LIKE CONCAT(\'%\', in_pattern, \'%\');  SELECT CONCAT(\'Enabled \', @rows := ROW_COUNT(), \' instrument\', IF(@rows != 1, \'s\', \'\')) AS summary; END'),('sys','ps_setup_enable_thread','PROCEDURE','ps_setup_enable_thread','SQL','MODIFIES_SQL_DATA','NO','INVOKER',_binary ' IN in_connection_id BIGINT ','',_binary 'BEGIN UPDATE performance_schema.threads SET instrumented = \'YES\' WHERE processlist_id = in_connection_id;  SELECT CONCAT(\'Enabled \', @rows := ROW_COUNT(), \' thread\', IF(@rows != 1, \'s\', \'\')) AS summary; END','mysql.sys@localhost','2017-03-02 18:46:53','2017-03-02 18:46:53','','\n Description\n \n Enable the given connection/thread in Performance Schema.\n \n Parameters\n \n in_connection_id (BIGINT):\n The connection ID (PROCESSLIST_ID from performance_schema.threads\n or the ID shown within SHOW PROCESSLIST)\n \n Example\n \n mysql> CALL sys.ps_setup_enable_thread(3);\n +------------------+\n | summary          |\n +------------------+\n | Enabled 1 thread |\n +------------------+\n 1 row in set (0.01 sec)\n \n To enable the current connection:\n \n mysql> CALL sys.ps_setup_enable_thread(CONNECTION_ID());\n +------------------+\n | summary          |\n +------------------+\n | Enabled 1 thread |\n +------------------+\n 1 row in set (0.00 sec)\n ','utf8','utf8_general_ci','utf8_general_ci',_binary 'BEGIN UPDATE performance_schema.threads SET instrumented = \'YES\' WHERE processlist_id = in_connection_id;  SELECT CONCAT(\'Enabled \', @rows := ROW_COUNT(), \' thread\', IF(@rows != 1, \'s\', \'\')) AS summary; END'),('sys','ps_setup_reload_saved','PROCEDURE','ps_setup_reload_saved','SQL','MODIFIES_SQL_DATA','NO','INVOKER','','',_binary 'BEGIN DECLARE v_done bool DEFAULT FALSE; DECLARE v_lock_result INT; DECLARE v_lock_used_by BIGINT; DECLARE v_signal_message TEXT; DECLARE EXIT HANDLER FOR SQLEXCEPTION BEGIN SIGNAL SQLSTATE VALUE \'90001\' SET MESSAGE_TEXT = \'An error occurred, was sys.ps_setup_save() run before this procedure?\'; END;  SET @log_bin := @@sql_log_bin; SET sql_log_bin = 0;  SELECT IS_USED_LOCK(\'sys.ps_setup_save\') INTO v_lock_used_by;  IF (v_lock_used_by != CONNECTION_ID()) THEN SET v_signal_message = CONCAT(\'The sys.ps_setup_save lock is currently owned by \', v_lock_used_by); SIGNAL SQLSTATE VALUE \'90002\' SET MESSAGE_TEXT = v_signal_message; END IF;  DELETE FROM performance_schema.setup_actors; INSERT INTO performance_schema.setup_actors SELECT * FROM tmp_setup_actors;  BEGIN DECLARE v_name varchar(64); DECLARE v_enabled enum(\'YES\', \'NO\'); DECLARE c_consumers CURSOR FOR SELECT NAME, ENABLED FROM tmp_setup_consumers; DECLARE CONTINUE HANDLER FOR NOT FOUND SET v_done = TRUE;  SET v_done = FALSE; OPEN c_consumers; c_consumers_loop: LOOP FETCH c_consumers INTO v_name, v_enabled; IF v_done THEN LEAVE c_consumers_loop; END IF;  UPDATE performance_schema.setup_consumers SET ENABLED = v_enabled WHERE NAME = v_name; END LOOP; CLOSE c_consumers; END;  UPDATE performance_schema.setup_instruments INNER JOIN tmp_setup_instruments USING (NAME) SET performance_schema.setup_instruments.ENABLED = tmp_setup_instruments.ENABLED, performance_schema.setup_instruments.TIMED   = tmp_setup_instruments.TIMED; BEGIN DECLARE v_thread_id bigint unsigned; DECLARE v_instrumented enum(\'YES\', \'NO\'); DECLARE c_threads CURSOR FOR SELECT THREAD_ID, INSTRUMENTED FROM tmp_threads; DECLARE CONTINUE HANDLER FOR NOT FOUND SET v_done = TRUE;  SET v_done = FALSE; OPEN c_threads; c_threads_loop: LOOP FETCH c_threads INTO v_thread_id, v_instrumented; IF v_done THEN LEAVE c_threads_loop; END IF;  UPDATE performance_schema.threads SET INSTRUMENTED = v_instrumented WHERE THREAD_ID = v_thread_id; END LOOP; CLOSE c_threads; END;  UPDATE performance_schema.threads SET INSTRUMENTED = IF(PROCESSLIST_USER IS NOT NULL, sys.ps_is_account_enabled(PROCESSLIST_HOST, PROCESSLIST_USER), \'YES\') WHERE THREAD_ID NOT IN (SELECT THREAD_ID FROM tmp_threads);  DROP TEMPORARY TABLE tmp_setup_actors; DROP TEMPORARY TABLE tmp_setup_consumers; DROP TEMPORARY TABLE tmp_setup_instruments; DROP TEMPORARY TABLE tmp_threads;  SELECT RELEASE_LOCK(\'sys.ps_setup_save\') INTO v_lock_result;  SET sql_log_bin = @log_bin;  END','mysql.sys@localhost','2017-03-02 18:46:53','2017-03-02 18:46:53','','\n Description\n \n Reloads a saved Performance Schema configuration,\n so that you can alter the setup for debugging purposes, \n but restore it to a previous state.\n \n Use the companion procedure - ps_setup_save(), to \n save a configuration.\n \n Requires the SUPER privilege for \"SET sql_log_bin = 0;\".\n \n Parameters\n \n None.\n \n Example\n \n mysql> CALL sys.ps_setup_save();\n Query OK, 0 rows affected (0.08 sec)\n \n mysql> UPDATE performance_schema.setup_instruments SET enabled = \'YES\', timed = \'YES\';\n Query OK, 547 rows affected (0.40 sec)\n Rows matched: 784  Changed: 547  Warnings: 0\n \n /* Run some tests that need more detailed instrumentation here */\n \n mysql> CALL sys.ps_setup_reload_saved();\n Query OK, 0 rows affected (0.32 sec)\n ','utf8','utf8_general_ci','utf8_general_ci',_binary 'BEGIN DECLARE v_done bool DEFAULT FALSE; DECLARE v_lock_result INT; DECLARE v_lock_used_by BIGINT; DECLARE v_signal_message TEXT; DECLARE EXIT HANDLER FOR SQLEXCEPTION BEGIN SIGNAL SQLSTATE VALUE \'90001\' SET MESSAGE_TEXT = \'An error occurred, was sys.ps_setup_save() run before this procedure?\'; END;  SET @log_bin := @@sql_log_bin; SET sql_log_bin = 0;  SELECT IS_USED_LOCK(\'sys.ps_setup_save\') INTO v_lock_used_by;  IF (v_lock_used_by != CONNECTION_ID()) THEN SET v_signal_message = CONCAT(\'The sys.ps_setup_save lock is currently owned by \', v_lock_used_by); SIGNAL SQLSTATE VALUE \'90002\' SET MESSAGE_TEXT = v_signal_message; END IF;  DELETE FROM performance_schema.setup_actors; INSERT INTO performance_schema.setup_actors SELECT * FROM tmp_setup_actors;  BEGIN DECLARE v_name varchar(64); DECLARE v_enabled enum(\'YES\', \'NO\'); DECLARE c_consumers CURSOR FOR SELECT NAME, ENABLED FROM tmp_setup_consumers; DECLARE CONTINUE HANDLER FOR NOT FOUND SET v_done = TRUE;  SET v_done = FALSE; OPEN c_consumers; c_consumers_loop: LOOP FETCH c_consumers INTO v_name, v_enabled; IF v_done THEN LEAVE c_consumers_loop; END IF;  UPDATE performance_schema.setup_consumers SET ENABLED = v_enabled WHERE NAME = v_name; END LOOP; CLOSE c_consumers; END;  UPDATE performance_schema.setup_instruments INNER JOIN tmp_setup_instruments USING (NAME) SET performance_schema.setup_instruments.ENABLED = tmp_setup_instruments.ENABLED, performance_schema.setup_instruments.TIMED   = tmp_setup_instruments.TIMED; BEGIN DECLARE v_thread_id bigint unsigned; DECLARE v_instrumented enum(\'YES\', \'NO\'); DECLARE c_threads CURSOR FOR SELECT THREAD_ID, INSTRUMENTED FROM tmp_threads; DECLARE CONTINUE HANDLER FOR NOT FOUND SET v_done = TRUE;  SET v_done = FALSE; OPEN c_threads; c_threads_loop: LOOP FETCH c_threads INTO v_thread_id, v_instrumented; IF v_done THEN LEAVE c_threads_loop; END IF;  UPDATE performance_schema.threads SET INSTRUMENTED = v_instrumented WHERE THREAD_ID = v_thread_id; END LOOP; CLOSE c_threads; END;  UPDATE performance_schema.threads SET INSTRUMENTED = IF(PROCESSLIST_USER IS NOT NULL, sys.ps_is_account_enabled(PROCESSLIST_HOST, PROCESSLIST_USER), \'YES\') WHERE THREAD_ID NOT IN (SELECT THREAD_ID FROM tmp_threads);  DROP TEMPORARY TABLE tmp_setup_actors; DROP TEMPORARY TABLE tmp_setup_consumers; DROP TEMPORARY TABLE tmp_setup_instruments; DROP TEMPORARY TABLE tmp_threads;  SELECT RELEASE_LOCK(\'sys.ps_setup_save\') INTO v_lock_result;  SET sql_log_bin = @log_bin;  END'),('sys','ps_setup_reset_to_default','PROCEDURE','ps_setup_reset_to_default','SQL','MODIFIES_SQL_DATA','NO','INVOKER',_binary ' IN in_verbose BOOLEAN ','',_binary 'BEGIN SET @query = \'DELETE FROM performance_schema.setup_actors WHERE NOT (HOST = \'\'%\'\' AND USER = \'\'%\'\' AND ROLE = \'\'%\'\')\';  IF (in_verbose) THEN SELECT CONCAT(\'Resetting: setup_actors\\n\', REPLACE(@query, \'  \', \'\')) AS status; END IF;  PREPARE reset_stmt FROM @query; EXECUTE reset_stmt; DEALLOCATE PREPARE reset_stmt;  SET @query = \'INSERT IGNORE INTO performance_schema.setup_actors VALUES (\'\'%\'\', \'\'%\'\', \'\'%\'\', \'\'YES\'\', \'\'YES\'\')\';  IF (in_verbose) THEN SELECT CONCAT(\'Resetting: setup_actors\\n\', REPLACE(@query, \'  \', \'\')) AS status; END IF;  PREPARE reset_stmt FROM @query; EXECUTE reset_stmt; DEALLOCATE PREPARE reset_stmt;  SET @query = \'UPDATE performance_schema.setup_instruments SET ENABLED = sys.ps_is_instrument_default_enabled(NAME), TIMED   = sys.ps_is_instrument_default_timed(NAME)\';  IF (in_verbose) THEN SELECT CONCAT(\'Resetting: setup_instruments\\n\', REPLACE(@query, \'  \', \'\')) AS status; END IF;  PREPARE reset_stmt FROM @query; EXECUTE reset_stmt; DEALLOCATE PREPARE reset_stmt;  SET @query = \'UPDATE performance_schema.setup_consumers SET ENABLED = IF(NAME IN (\'\'events_statements_current\'\', \'\'events_transactions_current\'\', \'\'global_instrumentation\'\', \'\'thread_instrumentation\'\', \'\'statements_digest\'\'), \'\'YES\'\', \'\'NO\'\')\';  IF (in_verbose) THEN SELECT CONCAT(\'Resetting: setup_consumers\\n\', REPLACE(@query, \'  \', \'\')) AS status; END IF;  PREPARE reset_stmt FROM @query; EXECUTE reset_stmt; DEALLOCATE PREPARE reset_stmt;  SET @query = \'DELETE FROM performance_schema.setup_objects WHERE NOT (OBJECT_TYPE IN (\'\'EVENT\'\', \'\'FUNCTION\'\', \'\'PROCEDURE\'\', \'\'TABLE\'\', \'\'TRIGGER\'\') AND OBJECT_NAME = \'\'%\'\'  AND (OBJECT_SCHEMA = \'\'mysql\'\'              AND ENABLED = \'\'NO\'\'  AND TIMED = \'\'NO\'\' ) OR (OBJECT_SCHEMA = \'\'performance_schema\'\' AND ENABLED = \'\'NO\'\'  AND TIMED = \'\'NO\'\' ) OR (OBJECT_SCHEMA = \'\'information_schema\'\' AND ENABLED = \'\'NO\'\'  AND TIMED = \'\'NO\'\' ) OR (OBJECT_SCHEMA = \'\'%\'\'                  AND ENABLED = \'\'YES\'\' AND TIMED = \'\'YES\'\'))\';  IF (in_verbose) THEN SELECT CONCAT(\'Resetting: setup_objects\\n\', REPLACE(@query, \'  \', \'\')) AS status; END IF;  PREPARE reset_stmt FROM @query; EXECUTE reset_stmt; DEALLOCATE PREPARE reset_stmt;  SET @query = \'INSERT IGNORE INTO performance_schema.setup_objects VALUES (\'\'EVENT\'\'    , \'\'mysql\'\'             , \'\'%\'\', \'\'NO\'\' , \'\'NO\'\' ), (\'\'EVENT\'\'    , \'\'performance_schema\'\', \'\'%\'\', \'\'NO\'\' , \'\'NO\'\' ), (\'\'EVENT\'\'    , \'\'information_schema\'\', \'\'%\'\', \'\'NO\'\' , \'\'NO\'\' ), (\'\'EVENT\'\'    , \'\'%\'\'                 , \'\'%\'\', \'\'YES\'\', \'\'YES\'\'), (\'\'FUNCTION\'\' , \'\'mysql\'\'             , \'\'%\'\', \'\'NO\'\' , \'\'NO\'\' ), (\'\'FUNCTION\'\' , \'\'performance_schema\'\', \'\'%\'\', \'\'NO\'\' , \'\'NO\'\' ), (\'\'FUNCTION\'\' , \'\'information_schema\'\', \'\'%\'\', \'\'NO\'\' , \'\'NO\'\' ), (\'\'FUNCTION\'\' , \'\'%\'\'                 , \'\'%\'\', \'\'YES\'\', \'\'YES\'\'), (\'\'PROCEDURE\'\', \'\'mysql\'\'             , \'\'%\'\', \'\'NO\'\' , \'\'NO\'\' ), (\'\'PROCEDURE\'\', \'\'performance_schema\'\', \'\'%\'\', \'\'NO\'\' , \'\'NO\'\' ), (\'\'PROCEDURE\'\', \'\'information_schema\'\', \'\'%\'\', \'\'NO\'\' , \'\'NO\'\' ), (\'\'PROCEDURE\'\', \'\'%\'\'                 , \'\'%\'\', \'\'YES\'\', \'\'YES\'\'), (\'\'TABLE\'\'    , \'\'mysql\'\'             , \'\'%\'\', \'\'NO\'\' , \'\'NO\'\' ), (\'\'TABLE\'\'    , \'\'performance_schema\'\', \'\'%\'\', \'\'NO\'\' , \'\'NO\'\' ), (\'\'TABLE\'\'    , \'\'information_schema\'\', \'\'%\'\', \'\'NO\'\' , \'\'NO\'\' ), (\'\'TABLE\'\'    , \'\'%\'\'                 , \'\'%\'\', \'\'YES\'\', \'\'YES\'\'), (\'\'TRIGGER\'\'  , \'\'mysql\'\'             , \'\'%\'\', \'\'NO\'\' , \'\'NO\'\' ), (\'\'TRIGGER\'\'  , \'\'performance_schema\'\', \'\'%\'\', \'\'NO\'\' , \'\'NO\'\' ), (\'\'TRIGGER\'\'  , \'\'information_schema\'\', \'\'%\'\', \'\'NO\'\' , \'\'NO\'\' ), (\'\'TRIGGER\'\'  , \'\'%\'\'                 , \'\'%\'\', \'\'YES\'\', \'\'YES\'\')\';  IF (in_verbose) THEN SELECT CONCAT(\'Resetting: setup_objects\\n\', REPLACE(@query, \'  \', \'\')) AS status; END IF;  PREPARE reset_stmt FROM @query; EXECUTE reset_stmt; DEALLOCATE PREPARE reset_stmt;  SET @query = \'UPDATE performance_schema.threads SET INSTRUMENTED = \'\'YES\'\'\';  IF (in_verbose) THEN SELECT CONCAT(\'Resetting: threads\\n\', REPLACE(@query, \'  \', \'\')) AS status; END IF;  PREPARE reset_stmt FROM @query; EXECUTE reset_stmt; DEALLOCATE PREPARE reset_stmt; END','mysql.sys@localhost','2017-03-02 18:46:53','2017-03-02 18:46:53','','\n Description\n \n Resets the Performance Schema setup to the default settings.\n \n Parameters\n \n in_verbose (BOOLEAN):\n Whether to print each setup stage (including the SQL) whilst running.\n \n Example\n \n mysql> CALL sys.ps_setup_reset_to_default(true)\\G\n *************************** 1. row ***************************\n status: Resetting: setup_actors\n DELETE\n FROM performance_schema.setup_actors\n WHERE NOT (HOST = \'%\' AND USER = \'%\' AND ROLE = \'%\')\n 1 row in set (0.00 sec)\n \n *************************** 1. row ***************************\n status: Resetting: setup_actors\n INSERT IGNORE INTO performance_schema.setup_actors\n VALUES (\'%\', \'%\', \'%\')\n 1 row in set (0.00 sec)\n ...\n \n mysql> CALL sys.ps_setup_reset_to_default(false)\\G\n Query OK, 0 rows affected (0.00 sec)\n ','utf8','utf8_general_ci','utf8_general_ci',_binary 'BEGIN SET @query = \'DELETE FROM performance_schema.setup_actors WHERE NOT (HOST = \'%\' AND USER = \'%\' AND ROLE = \'%\')\';  IF (in_verbose) THEN SELECT CONCAT(\'Resetting: setup_actors\n\', REPLACE(@query, \'  \', \'\')) AS status; END IF;  PREPARE reset_stmt FROM @query; EXECUTE reset_stmt; DEALLOCATE PREPARE reset_stmt;  SET @query = \'INSERT IGNORE INTO performance_schema.setup_actors VALUES (\'%\', \'%\', \'%\', \'YES\', \'YES\')\';  IF (in_verbose) THEN SELECT CONCAT(\'Resetting: setup_actors\n\', REPLACE(@query, \'  \', \'\')) AS status; END IF;  PREPARE reset_stmt FROM @query; EXECUTE reset_stmt; DEALLOCATE PREPARE reset_stmt;  SET @query = \'UPDATE performance_schema.setup_instruments SET ENABLED = sys.ps_is_instrument_default_enabled(NAME), TIMED   = sys.ps_is_instrument_default_timed(NAME)\';  IF (in_verbose) THEN SELECT CONCAT(\'Resetting: setup_instruments\n\', REPLACE(@query, \'  \', \'\')) AS status; END IF;  PREPARE reset_stmt FROM @query; EXECUTE reset_stmt; DEALLOCATE PREPARE reset_stmt;  SET @query = \'UPDATE performance_schema.setup_consumers SET ENABLED = IF(NAME IN (\'events_statements_current\', \'events_transactions_current\', \'global_instrumentation\', \'thread_instrumentation\', \'statements_digest\'), \'YES\', \'NO\')\';  IF (in_verbose) THEN SELECT CONCAT(\'Resetting: setup_consumers\n\', REPLACE(@query, \'  \', \'\')) AS status; END IF;  PREPARE reset_stmt FROM @query; EXECUTE reset_stmt; DEALLOCATE PREPARE reset_stmt;  SET @query = \'DELETE FROM performance_schema.setup_objects WHERE NOT (OBJECT_TYPE IN (\'EVENT\', \'FUNCTION\', \'PROCEDURE\', \'TABLE\', \'TRIGGER\') AND OBJECT_NAME = \'%\'  AND (OBJECT_SCHEMA = \'mysql\'              AND ENABLED = \'NO\'  AND TIMED = \'NO\' ) OR (OBJECT_SCHEMA = \'performance_schema\' AND ENABLED = \'NO\'  AND TIMED = \'NO\' ) OR (OBJECT_SCHEMA = \'information_schema\' AND ENABLED = \'NO\'  AND TIMED = \'NO\' ) OR (OBJECT_SCHEMA = \'%\'                  AND ENABLED = \'YES\' AND TIMED = \'YES\'))\';  IF (in_verbose) THEN SELECT CONCAT(\'Resetting: setup_objects\n\', REPLACE(@query, \'  \', \'\')) AS status; END IF;  PREPARE reset_stmt FROM @query; EXECUTE reset_stmt; DEALLOCATE PREPARE reset_stmt;  SET @query = \'INSERT IGNORE INTO performance_schema.setup_objects VALUES (\'EVENT\'    , \'mysql\'             , \'%\', \'NO\' , \'NO\' ), (\'EVENT\'    , \'performance_schema\', \'%\', \'NO\' , \'NO\' ), (\'EVENT\'    , \'information_schema\', \'%\', \'NO\' , \'NO\' ), (\'EVENT\'    , \'%\'                 , \'%\', \'YES\', \'YES\'), (\'FUNCTION\' , \'mysql\'             , \'%\', \'NO\' , \'NO\' ), (\'FUNCTION\' , \'performance_schema\', \'%\', \'NO\' , \'NO\' ), (\'FUNCTION\' , \'information_schema\', \'%\', \'NO\' , \'NO\' ), (\'FUNCTION\' , \'%\'                 , \'%\', \'YES\', \'YES\'), (\'PROCEDURE\', \'mysql\'             , \'%\', \'NO\' , \'NO\' ), (\'PROCEDURE\', \'performance_schema\', \'%\', \'NO\' , \'NO\' ), (\'PROCEDURE\', \'information_schema\', \'%\', \'NO\' , \'NO\' ), (\'PROCEDURE\', \'%\'                 , \'%\', \'YES\', \'YES\'), (\'TABLE\'    , \'mysql\'             , \'%\', \'NO\' , \'NO\' ), (\'TABLE\'    , \'performance_schema\', \'%\', \'NO\' , \'NO\' ), (\'TABLE\'    , \'information_schema\', \'%\', \'NO\' , \'NO\' ), (\'TABLE\'    , \'%\'                 , \'%\', \'YES\', \'YES\'), (\'TRIGGER\'  , \'mysql\'             , \'%\', \'NO\' , \'NO\' ), (\'TRIGGER\'  , \'performance_schema\', \'%\', \'NO\' , \'NO\' ), (\'TRIGGER\'  , \'information_schema\', \'%\', \'NO\' , \'NO\' ), (\'TRIGGER\'  , \'%\'                 , \'%\', \'YES\', \'YES\')\';  IF (in_verbose) THEN SELECT CONCAT(\'Resetting: setup_objects\n\', REPLACE(@query, \'  \', \'\')) AS status; END IF;  PREPARE reset_stmt FROM @query; EXECUTE reset_stmt; DEALLOCATE PREPARE reset_stmt;  SET @query = \'UPDATE performance_schema.threads SET INSTRUMENTED = \'YES\'\';  IF (in_verbose) THEN SELECT CONCAT(\'Resetting: threads\n\', REPLACE(@query, \'  \', \'\')) AS status; END IF;  PREPARE reset_stmt FROM @query; EXECUTE reset_stmt; DEALLOCATE PREPARE reset_stmt; END'),('sys','ps_setup_save','PROCEDURE','ps_setup_save','SQL','MODIFIES_SQL_DATA','NO','INVOKER',_binary ' IN in_timeout INT ','',_binary 'BEGIN DECLARE v_lock_result INT;  SET @log_bin := @@sql_log_bin; SET sql_log_bin = 0;  SELECT GET_LOCK(\'sys.ps_setup_save\', in_timeout) INTO v_lock_result;  IF v_lock_result THEN DROP TEMPORARY TABLE IF EXISTS tmp_setup_actors; DROP TEMPORARY TABLE IF EXISTS tmp_setup_consumers; DROP TEMPORARY TABLE IF EXISTS tmp_setup_instruments; DROP TEMPORARY TABLE IF EXISTS tmp_threads;  CREATE TEMPORARY TABLE tmp_setup_actors LIKE performance_schema.setup_actors; CREATE TEMPORARY TABLE tmp_setup_consumers LIKE performance_schema.setup_consumers; CREATE TEMPORARY TABLE tmp_setup_instruments LIKE performance_schema.setup_instruments; CREATE TEMPORARY TABLE tmp_threads (THREAD_ID bigint unsigned NOT NULL PRIMARY KEY, INSTRUMENTED enum(\'YES\',\'NO\') NOT NULL);  INSERT INTO tmp_setup_actors SELECT * FROM performance_schema.setup_actors; INSERT INTO tmp_setup_consumers SELECT * FROM performance_schema.setup_consumers; INSERT INTO tmp_setup_instruments SELECT * FROM performance_schema.setup_instruments; INSERT INTO tmp_threads SELECT THREAD_ID, INSTRUMENTED FROM performance_schema.threads; ELSE SIGNAL SQLSTATE VALUE \'90000\' SET MESSAGE_TEXT = \'Could not lock the sys.ps_setup_save user lock, another thread has a saved configuration\'; END IF;  SET sql_log_bin = @log_bin; END','mysql.sys@localhost','2017-03-02 18:46:53','2017-03-02 18:46:53','','\n Description\n \n Saves the current configuration of Performance Schema, \n so that you can alter the setup for debugging purposes, \n but restore it to a previous state.\n \n Use the companion procedure - ps_setup_reload_saved(), to \n restore the saved config.\n \n The named lock \"sys.ps_setup_save\" is taken before the\n current configuration is saved. If the attempt to get the named\n lock times out, an error occurs.\n \n The lock is released after the settings have been restored by\n calling ps_setup_reload_saved().\n \n Requires the SUPER privilege for \"SET sql_log_bin = 0;\".\n \n Parameters\n \n in_timeout INT\n The timeout in seconds used when trying to obtain the lock.\n A negative timeout means infinite timeout.\n \n Example\n \n mysql> CALL sys.ps_setup_save(-1);\n Query OK, 0 rows affected (0.08 sec)\n \n mysql> UPDATE performance_schema.setup_instruments \n ->    SET enabled = \'YES\', timed = \'YES\';\n Query OK, 547 rows affected (0.40 sec)\n Rows matched: 784  Changed: 547  Warnings: 0\n \n /* Run some tests that need more detailed instrumentation here */\n \n mysql> CALL sys.ps_setup_reload_saved();\n Query OK, 0 rows affected (0.32 sec)\n ','utf8','utf8_general_ci','utf8_general_ci',_binary 'BEGIN DECLARE v_lock_result INT;  SET @log_bin := @@sql_log_bin; SET sql_log_bin = 0;  SELECT GET_LOCK(\'sys.ps_setup_save\', in_timeout) INTO v_lock_result;  IF v_lock_result THEN DROP TEMPORARY TABLE IF EXISTS tmp_setup_actors; DROP TEMPORARY TABLE IF EXISTS tmp_setup_consumers; DROP TEMPORARY TABLE IF EXISTS tmp_setup_instruments; DROP TEMPORARY TABLE IF EXISTS tmp_threads;  CREATE TEMPORARY TABLE tmp_setup_actors LIKE performance_schema.setup_actors; CREATE TEMPORARY TABLE tmp_setup_consumers LIKE performance_schema.setup_consumers; CREATE TEMPORARY TABLE tmp_setup_instruments LIKE performance_schema.setup_instruments; CREATE TEMPORARY TABLE tmp_threads (THREAD_ID bigint unsigned NOT NULL PRIMARY KEY, INSTRUMENTED enum(\'YES\',\'NO\') NOT NULL);  INSERT INTO tmp_setup_actors SELECT * FROM performance_schema.setup_actors; INSERT INTO tmp_setup_consumers SELECT * FROM performance_schema.setup_consumers; INSERT INTO tmp_setup_instruments SELECT * FROM performance_schema.setup_instruments; INSERT INTO tmp_threads SELECT THREAD_ID, INSTRUMENTED FROM performance_schema.threads; ELSE SIGNAL SQLSTATE VALUE \'90000\' SET MESSAGE_TEXT = \'Could not lock the sys.ps_setup_save user lock, another thread has a saved configuration\'; END IF;  SET sql_log_bin = @log_bin; END'),('sys','ps_setup_show_disabled','PROCEDURE','ps_setup_show_disabled','SQL','READS_SQL_DATA','NO','INVOKER',_binary ' IN in_show_instruments BOOLEAN, IN in_show_threads BOOLEAN ','',_binary 'BEGIN SELECT @@performance_schema AS performance_schema_enabled;   SELECT CONCAT(\'\\\'\', user, \'\\\'@\\\'\', host, \'\\\'\') AS disabled_users FROM performance_schema.setup_actors WHERE enabled = \'NO\' ORDER BY disabled_users;   SELECT object_type, CONCAT(object_schema, \'.\', object_name) AS objects, enabled, timed FROM performance_schema.setup_objects WHERE enabled = \'NO\' ORDER BY object_type, objects;  SELECT name AS disabled_consumers FROM performance_schema.setup_consumers WHERE enabled = \'NO\' ORDER BY disabled_consumers;  IF (in_show_threads) THEN SELECT IF(name = \'thread/sql/one_connection\',  CONCAT(processlist_user, \'@\', processlist_host),  REPLACE(name, \'thread/\', \'\')) AS disabled_threads, TYPE AS thread_type FROM performance_schema.threads WHERE INSTRUMENTED = \'NO\' ORDER BY disabled_threads; END IF;  IF (in_show_instruments) THEN SELECT name AS disabled_instruments, timed FROM performance_schema.setup_instruments WHERE enabled = \'NO\' ORDER BY disabled_instruments; END IF; END','mysql.sys@localhost','2017-03-02 18:46:53','2017-03-02 18:46:53','','\n Description\n \n Shows all currently disable Performance Schema configuration.\n \n Disabled users is only available for MySQL 5.7.6 and later.\n In earlier versions it was only possible to enable users.\n \n Parameters\n \n in_show_instruments (BOOLEAN):\n Whether to print disabled instruments (can print many items)\n \n in_show_threads (BOOLEAN):\n Whether to print disabled threads\n \n Example\n \n mysql> CALL sys.ps_setup_show_disabled(TRUE, TRUE);\n +----------------------------+\n | performance_schema_enabled |\n +----------------------------+\n |                          1 |\n +----------------------------+\n 1 row in set (0.00 sec)\n \n +--------------------+\n | disabled_users     |\n +--------------------+\n | \'mark\'@\'localhost\' |\n +--------------------+\n 1 row in set (0.00 sec)\n \n +-------------+----------------------+---------+-------+\n | object_type | objects              | enabled | timed |\n +-------------+----------------------+---------+-------+\n | EVENT       | mysql.%              | NO      | NO    |\n | EVENT       | performance_schema.% | NO      | NO    |\n | EVENT       | information_schema.% | NO      | NO    |\n | FUNCTION    | mysql.%              | NO      | NO    |\n | FUNCTION    | performance_schema.% | NO      | NO    |\n | FUNCTION    | information_schema.% | NO      | NO    |\n | PROCEDURE   | mysql.%              | NO      | NO    |\n | PROCEDURE   | performance_schema.% | NO      | NO    |\n | PROCEDURE   | information_schema.% | NO      | NO    |\n | TABLE       | mysql.%              | NO      | NO    |\n | TABLE       | performance_schema.% | NO      | NO    |\n | TABLE       | information_schema.% | NO      | NO    |\n | TRIGGER     | mysql.%              | NO      | NO    |\n | TRIGGER     | performance_schema.% | NO      | NO    |\n | TRIGGER     | information_schema.% | NO      | NO    |\n +-------------+----------------------+---------+-------+\n 15 rows in set (0.00 sec)\n \n +----------------------------------+\n | disabled_consumers               |\n +----------------------------------+\n | events_stages_current            |\n | events_stages_history            |\n | events_stages_history_long       |\n | events_statements_history        |\n | events_statements_history_long   |\n | events_transactions_history      |\n | events_transactions_history_long |\n | events_waits_current             |\n | events_waits_history             |\n | events_waits_history_long        |\n +----------------------------------+\n 10 rows in set (0.00 sec)\n \n Empty set (0.00 sec)\n \n +---------------------------------------------------------------------------------------+-------+\n | disabled_instruments                                                                  | timed |\n +---------------------------------------------------------------------------------------+-------+\n | wait/synch/mutex/sql/TC_LOG_MMAP::LOCK_tc                                             | NO    |\n | wait/synch/mutex/sql/LOCK_des_key_file                                                | NO    |\n | wait/synch/mutex/sql/MYSQL_BIN_LOG::LOCK_commit                                       | NO    |\n ...\n | memory/sql/servers_cache                                                              | NO    |\n | memory/sql/udf_mem                                                                    | NO    |\n | wait/lock/metadata/sql/mdl                                                            | NO    |\n +---------------------------------------------------------------------------------------+-------+\n 547 rows in set (0.00 sec)\n \n Query OK, 0 rows affected (0.01 sec)\n ','utf8','utf8_general_ci','utf8_general_ci',_binary 'BEGIN SELECT @@performance_schema AS performance_schema_enabled;   SELECT CONCAT(\'\'\', user, \'\'@\'\', host, \'\'\') AS disabled_users FROM performance_schema.setup_actors WHERE enabled = \'NO\' ORDER BY disabled_users;   SELECT object_type, CONCAT(object_schema, \'.\', object_name) AS objects, enabled, timed FROM performance_schema.setup_objects WHERE enabled = \'NO\' ORDER BY object_type, objects;  SELECT name AS disabled_consumers FROM performance_schema.setup_consumers WHERE enabled = \'NO\' ORDER BY disabled_consumers;  IF (in_show_threads) THEN SELECT IF(name = \'thread/sql/one_connection\',  CONCAT(processlist_user, \'@\', processlist_host),  REPLACE(name, \'thread/\', \'\')) AS disabled_threads, TYPE AS thread_type FROM performance_schema.threads WHERE INSTRUMENTED = \'NO\' ORDER BY disabled_threads; END IF;  IF (in_show_instruments) THEN SELECT name AS disabled_instruments, timed FROM performance_schema.setup_instruments WHERE enabled = \'NO\' ORDER BY disabled_instruments; END IF; END'),('sys','ps_setup_show_disabled_consumers','PROCEDURE','ps_setup_show_disabled_consumers','SQL','READS_SQL_DATA','YES','INVOKER','','',_binary 'BEGIN SELECT name AS disabled_consumers FROM performance_schema.setup_consumers WHERE enabled = \'NO\' ORDER BY disabled_consumers; END','mysql.sys@localhost','2017-03-02 18:46:53','2017-03-02 18:46:53','','\n Description\n \n Shows all currently disabled consumers.\n \n Parameters\n \n None\n \n Example\n \n mysql> CALL sys.ps_setup_show_disabled_consumers();\n \n +---------------------------+\n | disabled_consumers        |\n +---------------------------+\n | events_statements_current |\n | global_instrumentation    |\n | thread_instrumentation    |\n | statements_digest         |\n +---------------------------+\n 4 rows in set (0.05 sec)\n ','utf8','utf8_general_ci','utf8_general_ci',_binary 'BEGIN SELECT name AS disabled_consumers FROM performance_schema.setup_consumers WHERE enabled = \'NO\' ORDER BY disabled_consumers; END'),('sys','ps_setup_show_disabled_instruments','PROCEDURE','ps_setup_show_disabled_instruments','SQL','READS_SQL_DATA','YES','INVOKER','','',_binary 'BEGIN SELECT name AS disabled_instruments, timed FROM performance_schema.setup_instruments WHERE enabled = \'NO\' ORDER BY disabled_instruments; END','mysql.sys@localhost','2017-03-02 18:46:53','2017-03-02 18:46:53','','\n Description\n \n Shows all currently disabled instruments.\n \n Parameters\n \n None\n \n Example\n \n mysql> CALL sys.ps_setup_show_disabled_instruments();\n ','utf8','utf8_general_ci','utf8_general_ci',_binary 'BEGIN SELECT name AS disabled_instruments, timed FROM performance_schema.setup_instruments WHERE enabled = \'NO\' ORDER BY disabled_instruments; END'),('sys','ps_setup_show_enabled','PROCEDURE','ps_setup_show_enabled','SQL','READS_SQL_DATA','YES','INVOKER',_binary ' IN in_show_instruments BOOLEAN, IN in_show_threads BOOLEAN ','',_binary 'BEGIN SELECT @@performance_schema AS performance_schema_enabled;  SELECT CONCAT(\'\\\'\', user, \'\\\'@\\\'\', host, \'\\\'\') AS enabled_users FROM performance_schema.setup_actors  WHERE enabled = \'YES\'  ORDER BY enabled_users;  SELECT object_type, CONCAT(object_schema, \'.\', object_name) AS objects, enabled, timed FROM performance_schema.setup_objects WHERE enabled = \'YES\' ORDER BY object_type, objects;  SELECT name AS enabled_consumers FROM performance_schema.setup_consumers WHERE enabled = \'YES\' ORDER BY enabled_consumers;  IF (in_show_threads) THEN SELECT IF(name = \'thread/sql/one_connection\',  CONCAT(processlist_user, \'@\', processlist_host),  REPLACE(name, \'thread/\', \'\')) AS enabled_threads, TYPE AS thread_type FROM performance_schema.threads WHERE INSTRUMENTED = \'YES\' ORDER BY enabled_threads; END IF;  IF (in_show_instruments) THEN SELECT name AS enabled_instruments, timed FROM performance_schema.setup_instruments WHERE enabled = \'YES\' ORDER BY enabled_instruments; END IF; END','mysql.sys@localhost','2017-03-02 18:46:53','2017-03-02 18:46:53','','\n Description\n \n Shows all currently enabled Performance Schema configuration.\n \n Parameters\n \n in_show_instruments (BOOLEAN):\n Whether to print enabled instruments (can print many items)\n \n in_show_threads (BOOLEAN):\n Whether to print enabled threads\n \n Example\n \n mysql> CALL sys.ps_setup_show_enabled(TRUE, TRUE);\n +----------------------------+\n | performance_schema_enabled |\n +----------------------------+\n |                          1 |\n +----------------------------+\n 1 row in set (0.00 sec)\n \n +---------------+\n | enabled_users |\n +---------------+\n | \'%\'@\'%\'       |\n +---------------+\n 1 row in set (0.01 sec)\n \n +-------------+---------+---------+-------+\n | object_type | objects | enabled | timed |\n +-------------+---------+---------+-------+\n | EVENT       | %.%     | YES     | YES   |\n | FUNCTION    | %.%     | YES     | YES   |\n | PROCEDURE   | %.%     | YES     | YES   |\n | TABLE       | %.%     | YES     | YES   |\n | TRIGGER     | %.%     | YES     | YES   |\n +-------------+---------+---------+-------+\n 5 rows in set (0.01 sec)\n \n +---------------------------+\n | enabled_consumers         |\n +---------------------------+\n | events_statements_current |\n | global_instrumentation    |\n | thread_instrumentation    |\n | statements_digest         |\n +---------------------------+\n 4 rows in set (0.05 sec)\n \n +---------------------------------+-------------+\n | enabled_threads                 | thread_type |\n +---------------------------------+-------------+\n | sql/main                        | BACKGROUND  |\n | sql/thread_timer_notifier       | BACKGROUND  |\n | innodb/io_ibuf_thread           | BACKGROUND  |\n | innodb/io_log_thread            | BACKGROUND  |\n | innodb/io_read_thread           | BACKGROUND  |\n | innodb/io_read_thread           | BACKGROUND  |\n | innodb/io_write_thread          | BACKGROUND  |\n | innodb/io_write_thread          | BACKGROUND  |\n | innodb/page_cleaner_thread      | BACKGROUND  |\n | innodb/srv_lock_timeout_thread  | BACKGROUND  |\n | innodb/srv_error_monitor_thread | BACKGROUND  |\n | innodb/srv_monitor_thread       | BACKGROUND  |\n | innodb/srv_master_thread        | BACKGROUND  |\n | innodb/srv_purge_thread         | BACKGROUND  |\n | innodb/srv_worker_thread        | BACKGROUND  |\n | innodb/srv_worker_thread        | BACKGROUND  |\n | innodb/srv_worker_thread        | BACKGROUND  |\n | innodb/buf_dump_thread          | BACKGROUND  |\n | innodb/dict_stats_thread        | BACKGROUND  |\n | sql/signal_handler              | BACKGROUND  |\n | sql/compress_gtid_table         | FOREGROUND  |\n | root@localhost                  | FOREGROUND  |\n +---------------------------------+-------------+\n 22 rows in set (0.01 sec)\n \n +-------------------------------------+-------+\n | enabled_instruments                 | timed |\n +-------------------------------------+-------+\n | wait/io/file/sql/map                | YES   |\n | wait/io/file/sql/binlog             | YES   |\n ...\n | statement/com/Error                 | YES   |\n | statement/com/                      | YES   |\n | idle                                | YES   |\n +-------------------------------------+-------+\n 210 rows in set (0.08 sec)\n \n Query OK, 0 rows affected (0.89 sec)\n ','utf8','utf8_general_ci','utf8_general_ci',_binary 'BEGIN SELECT @@performance_schema AS performance_schema_enabled;  SELECT CONCAT(\'\'\', user, \'\'@\'\', host, \'\'\') AS enabled_users FROM performance_schema.setup_actors  WHERE enabled = \'YES\'  ORDER BY enabled_users;  SELECT object_type, CONCAT(object_schema, \'.\', object_name) AS objects, enabled, timed FROM performance_schema.setup_objects WHERE enabled = \'YES\' ORDER BY object_type, objects;  SELECT name AS enabled_consumers FROM performance_schema.setup_consumers WHERE enabled = \'YES\' ORDER BY enabled_consumers;  IF (in_show_threads) THEN SELECT IF(name = \'thread/sql/one_connection\',  CONCAT(processlist_user, \'@\', processlist_host),  REPLACE(name, \'thread/\', \'\')) AS enabled_threads, TYPE AS thread_type FROM performance_schema.threads WHERE INSTRUMENTED = \'YES\' ORDER BY enabled_threads; END IF;  IF (in_show_instruments) THEN SELECT name AS enabled_instruments, timed FROM performance_schema.setup_instruments WHERE enabled = \'YES\' ORDER BY enabled_instruments; END IF; END'),('sys','ps_setup_show_enabled_consumers','PROCEDURE','ps_setup_show_enabled_consumers','SQL','READS_SQL_DATA','YES','INVOKER','','',_binary 'BEGIN SELECT name AS enabled_consumers FROM performance_schema.setup_consumers WHERE enabled = \'YES\' ORDER BY enabled_consumers; END','mysql.sys@localhost','2017-03-02 18:46:53','2017-03-02 18:46:53','','\n Description\n \n Shows all currently enabled consumers.\n \n Parameters\n \n None\n \n Example\n \n mysql> CALL sys.ps_setup_show_enabled_consumers();\n \n +---------------------------+\n | enabled_consumers         |\n +---------------------------+\n | events_statements_current |\n | global_instrumentation    |\n | thread_instrumentation    |\n | statements_digest         |\n +---------------------------+\n 4 rows in set (0.05 sec)\n ','utf8','utf8_general_ci','utf8_general_ci',_binary 'BEGIN SELECT name AS enabled_consumers FROM performance_schema.setup_consumers WHERE enabled = \'YES\' ORDER BY enabled_consumers; END'),('sys','ps_setup_show_enabled_instruments','PROCEDURE','ps_setup_show_enabled_instruments','SQL','READS_SQL_DATA','YES','INVOKER','','',_binary 'BEGIN SELECT name AS enabled_instruments, timed FROM performance_schema.setup_instruments WHERE enabled = \'YES\' ORDER BY enabled_instruments; END','mysql.sys@localhost','2017-03-02 18:46:53','2017-03-02 18:46:53','','\n Description\n \n Shows all currently enabled instruments.\n \n Parameters\n \n None\n \n Example\n \n mysql> CALL sys.ps_setup_show_enabled_instruments();\n ','utf8','utf8_general_ci','utf8_general_ci',_binary 'BEGIN SELECT name AS enabled_instruments, timed FROM performance_schema.setup_instruments WHERE enabled = \'YES\' ORDER BY enabled_instruments; END'),('sys','ps_truncate_all_tables','PROCEDURE','ps_truncate_all_tables','SQL','MODIFIES_SQL_DATA','YES','INVOKER',_binary ' IN in_verbose BOOLEAN ','',_binary 'BEGIN DECLARE v_done INT DEFAULT FALSE; DECLARE v_total_tables INT DEFAULT 0; DECLARE v_ps_table VARCHAR(64); DECLARE ps_tables CURSOR FOR SELECT table_name  FROM INFORMATION_SCHEMA.TABLES  WHERE table_schema = \'performance_schema\'  AND (table_name LIKE \'%summary%\'  OR table_name LIKE \'%history%\'); DECLARE CONTINUE HANDLER FOR NOT FOUND SET v_done = TRUE;  OPEN ps_tables;  ps_tables_loop: LOOP FETCH ps_tables INTO v_ps_table; IF v_done THEN LEAVE ps_tables_loop; END IF;  SET @truncate_stmt := CONCAT(\'TRUNCATE TABLE performance_schema.\', v_ps_table); IF in_verbose THEN SELECT CONCAT(\'Running: \', @truncate_stmt) AS status; END IF;  PREPARE truncate_stmt FROM @truncate_stmt; EXECUTE truncate_stmt; DEALLOCATE PREPARE truncate_stmt;  SET v_total_tables = v_total_tables + 1; END LOOP;  CLOSE ps_tables;  SELECT CONCAT(\'Truncated \', v_total_tables, \' tables\') AS summary;  END','mysql.sys@localhost','2017-03-02 18:46:53','2017-03-02 18:46:53','','\n Description\n \n Truncates all summary tables within Performance Schema, \n resetting all aggregated instrumentation as a snapshot.\n \n Parameters\n \n in_verbose (BOOLEAN):\n Whether to print each TRUNCATE statement before running\n \n Example\n \n mysql> CALL sys.ps_truncate_all_tables(false);\n +---------------------+\n | summary             |\n +---------------------+\n | Truncated 44 tables |\n +---------------------+\n 1 row in set (0.10 sec)\n \n Query OK, 0 rows affected (0.10 sec)\n ','utf8','utf8_general_ci','utf8_general_ci',_binary 'BEGIN DECLARE v_done INT DEFAULT FALSE; DECLARE v_total_tables INT DEFAULT 0; DECLARE v_ps_table VARCHAR(64); DECLARE ps_tables CURSOR FOR SELECT table_name  FROM INFORMATION_SCHEMA.TABLES  WHERE table_schema = \'performance_schema\'  AND (table_name LIKE \'%summary%\'  OR table_name LIKE \'%history%\'); DECLARE CONTINUE HANDLER FOR NOT FOUND SET v_done = TRUE;  OPEN ps_tables;  ps_tables_loop: LOOP FETCH ps_tables INTO v_ps_table; IF v_done THEN LEAVE ps_tables_loop; END IF;  SET @truncate_stmt := CONCAT(\'TRUNCATE TABLE performance_schema.\', v_ps_table); IF in_verbose THEN SELECT CONCAT(\'Running: \', @truncate_stmt) AS status; END IF;  PREPARE truncate_stmt FROM @truncate_stmt; EXECUTE truncate_stmt; DEALLOCATE PREPARE truncate_stmt;  SET v_total_tables = v_total_tables + 1; END LOOP;  CLOSE ps_tables;  SELECT CONCAT(\'Truncated \', v_total_tables, \' tables\') AS summary;  END'),('sys','statement_performance_analyzer','PROCEDURE','statement_performance_analyzer','SQL','CONTAINS_SQL','NO','INVOKER',_binary ' IN in_action ENUM(\'snapshot\', \'overall\', \'delta\', \'create_table\', \'create_tmp\', \'save\', \'cleanup\'), IN in_table VARCHAR(129), IN in_views SET (\'with_runtimes_in_95th_percentile\', \'analysis\', \'with_errors_or_warnings\', \'with_full_table_scans\', \'with_sorting\', \'with_temp_tables\', \'custom\') ','',_binary 'BEGIN DECLARE v_table_exists, v_tmp_digests_table_exists, v_custom_view_exists ENUM(\'\', \'BASE TABLE\', \'VIEW\', \'TEMPORARY\') DEFAULT \'\'; DECLARE v_this_thread_enabled ENUM(\'YES\', \'NO\'); DECLARE v_force_new_snapshot BOOLEAN DEFAULT FALSE; DECLARE v_digests_table VARCHAR(133); DECLARE v_quoted_table, v_quoted_custom_view VARCHAR(133) DEFAULT \'\'; DECLARE v_table_db, v_table_name, v_custom_db, v_custom_name VARCHAR(64); DECLARE v_digest_table_template, v_checksum_ref, v_checksum_table text; DECLARE v_sql longtext; DECLARE v_error_msg VARCHAR(128);   SELECT INSTRUMENTED INTO v_this_thread_enabled FROM performance_schema.threads WHERE PROCESSLIST_ID = CONNECTION_ID(); IF (v_this_thread_enabled = \'YES\') THEN CALL sys.ps_setup_disable_thread(CONNECTION_ID()); END IF;  SET @log_bin := @@sql_log_bin; IF (@log_bin = 1) THEN SET sql_log_bin = 0; END IF;   IF (@sys.statement_performance_analyzer.limit IS NULL) THEN SET @sys.statement_performance_analyzer.limit = sys.sys_get_config(\'statement_performance_analyzer.limit\', \'100\'); END IF; IF (@sys.debug IS NULL) THEN SET @sys.debug                                = sys.sys_get_config(\'debug\'                               , \'OFF\'); END IF;   IF (in_table = \'NOW()\') THEN SET v_force_new_snapshot = TRUE, in_table             = NULL; ELSEIF (in_table IS NOT NULL) THEN IF (NOT INSTR(in_table, \'.\')) THEN SET v_table_db   = DATABASE(), v_table_name = in_table; ELSE SET v_table_db   = SUBSTRING_INDEX(in_table, \'.\', 1); SET v_table_name = SUBSTRING(in_table, CHAR_LENGTH(v_table_db)+2); END IF;  SET v_quoted_table = CONCAT(\'`\', v_table_db, \'`.`\', v_table_name, \'`\');  IF (@sys.debug = \'ON\') THEN SELECT CONCAT(\'in_table is: db = \'\'\', v_table_db, \'\'\', table = \'\'\', v_table_name, \'\'\'\') AS \'Debug\'; END IF;  IF (v_table_db = DATABASE() AND (v_table_name = \'tmp_digests\' OR v_table_name = \'tmp_digests_delta\')) THEN SET v_error_msg = CONCAT(\'Invalid value for in_table: \', v_quoted_table, \' is reserved table name.\'); SIGNAL SQLSTATE \'45000\' SET MESSAGE_TEXT = v_error_msg; END IF;  CALL sys.table_exists(v_table_db, v_table_name, v_table_exists); IF (@sys.debug = \'ON\') THEN SELECT CONCAT(\'v_table_exists = \', v_table_exists) AS \'Debug\'; END IF;  IF (v_table_exists = \'BASE TABLE\') THEN SET v_checksum_ref = ( SELECT GROUP_CONCAT(CONCAT(COLUMN_NAME, COLUMN_TYPE) ORDER BY ORDINAL_POSITION) AS Checksum FROM information_schema.COLUMNS WHERE TABLE_SCHEMA = \'performance_schema\' AND TABLE_NAME = \'events_statements_summary_by_digest\' ), v_checksum_table = ( SELECT GROUP_CONCAT(CONCAT(COLUMN_NAME, COLUMN_TYPE) ORDER BY ORDINAL_POSITION) AS Checksum FROM information_schema.COLUMNS WHERE TABLE_SCHEMA = v_table_db AND TABLE_NAME = v_table_name );  IF (v_checksum_ref <> v_checksum_table) THEN SET v_error_msg = CONCAT(\'The table \', IF(CHAR_LENGTH(v_quoted_table) > 93, CONCAT(\'...\', SUBSTRING(v_quoted_table, -90)), v_quoted_table), \' has the wrong definition.\'); SIGNAL SQLSTATE \'45000\' SET MESSAGE_TEXT = v_error_msg; END IF; END IF; END IF;   IF (in_views IS NULL OR in_views = \'\') THEN SET in_views = \'with_runtimes_in_95th_percentile,analysis,with_errors_or_warnings,with_full_table_scans,with_sorting,with_temp_tables\'; END IF;   CALL sys.table_exists(DATABASE(), \'tmp_digests\', v_tmp_digests_table_exists); IF (@sys.debug = \'ON\') THEN SELECT CONCAT(\'v_tmp_digests_table_exists = \', v_tmp_digests_table_exists) AS \'Debug\'; END IF;  CASE WHEN in_action IN (\'snapshot\', \'overall\') THEN IF (in_table IS NOT NULL) THEN IF (NOT v_table_exists IN (\'TEMPORARY\', \'BASE TABLE\')) THEN SET v_error_msg = CONCAT(\'The \', in_action, \' action requires in_table to be NULL, NOW() or specify an existing table.\', \' The table \', IF(CHAR_LENGTH(v_quoted_table) > 16, CONCAT(\'...\', SUBSTRING(v_quoted_table, -13)), v_quoted_table), \' does not exist.\'); SIGNAL SQLSTATE \'45000\' SET MESSAGE_TEXT = v_error_msg; END IF; END IF;  WHEN in_action IN (\'delta\', \'save\') THEN IF (v_table_exists NOT IN (\'TEMPORARY\', \'BASE TABLE\')) THEN SET v_error_msg = CONCAT(\'The \', in_action, \' action requires in_table to be an existing table.\', IF(in_table IS NOT NULL, CONCAT(\' The table \', IF(CHAR_LENGTH(v_quoted_table) > 39, CONCAT(\'...\', SUBSTRING(v_quoted_table, -36)), v_quoted_table), \' does not exist.\'), \'\')); SIGNAL SQLSTATE \'45000\' SET MESSAGE_TEXT = v_error_msg; END IF;  IF (in_action = \'delta\' AND v_tmp_digests_table_exists <> \'TEMPORARY\') THEN SIGNAL SQLSTATE \'45000\' SET MESSAGE_TEXT = \'An existing snapshot generated with the statement_performance_analyzer() must exist.\'; END IF; WHEN in_action = \'create_tmp\' THEN IF (v_table_exists = \'TEMPORARY\') THEN SET v_error_msg = CONCAT(\'Cannot create the table \', IF(CHAR_LENGTH(v_quoted_table) > 72, CONCAT(\'...\', SUBSTRING(v_quoted_table, -69)), v_quoted_table), \' as it already exists.\'); SIGNAL SQLSTATE \'45000\' SET MESSAGE_TEXT = v_error_msg; END IF;  WHEN in_action = \'create_table\' THEN IF (v_table_exists <> \'\') THEN SET v_error_msg = CONCAT(\'Cannot create the table \', IF(CHAR_LENGTH(v_quoted_table) > 52, CONCAT(\'...\', SUBSTRING(v_quoted_table, -49)), v_quoted_table), \' as it already exists\', IF(v_table_exists = \'TEMPORARY\', \' as a temporary table.\', \'.\')); SIGNAL SQLSTATE \'45000\' SET MESSAGE_TEXT = v_error_msg; END IF;  WHEN in_action = \'cleanup\' THEN DO (SELECT 1); ELSE SIGNAL SQLSTATE \'45000\' SET MESSAGE_TEXT = \'Unknown action. Supported actions are: cleanup, create_table, create_tmp, delta, overall, save, snapshot\'; END CASE;  SET v_digest_table_template = \'CREATE %{TEMPORARY}TABLE %{TABLE_NAME} ( `SCHEMA_NAME` varchar(64) DEFAULT NULL, `DIGEST` varchar(32) DEFAULT NULL, `DIGEST_TEXT` longtext, `COUNT_STAR` bigint(20) unsigned NOT NULL, `SUM_TIMER_WAIT` bigint(20) unsigned NOT NULL, `MIN_TIMER_WAIT` bigint(20) unsigned NOT NULL, `AVG_TIMER_WAIT` bigint(20) unsigned NOT NULL, `MAX_TIMER_WAIT` bigint(20) unsigned NOT NULL, `SUM_LOCK_TIME` bigint(20) unsigned NOT NULL, `SUM_ERRORS` bigint(20) unsigned NOT NULL, `SUM_WARNINGS` bigint(20) unsigned NOT NULL, `SUM_ROWS_AFFECTED` bigint(20) unsigned NOT NULL, `SUM_ROWS_SENT` bigint(20) unsigned NOT NULL, `SUM_ROWS_EXAMINED` bigint(20) unsigned NOT NULL, `SUM_CREATED_TMP_DISK_TABLES` bigint(20) unsigned NOT NULL, `SUM_CREATED_TMP_TABLES` bigint(20) unsigned NOT NULL, `SUM_SELECT_FULL_JOIN` bigint(20) unsigned NOT NULL, `SUM_SELECT_FULL_RANGE_JOIN` bigint(20) unsigned NOT NULL, `SUM_SELECT_RANGE` bigint(20) unsigned NOT NULL, `SUM_SELECT_RANGE_CHECK` bigint(20) unsigned NOT NULL, `SUM_SELECT_SCAN` bigint(20) unsigned NOT NULL, `SUM_SORT_MERGE_PASSES` bigint(20) unsigned NOT NULL, `SUM_SORT_RANGE` bigint(20) unsigned NOT NULL, `SUM_SORT_ROWS` bigint(20) unsigned NOT NULL, `SUM_SORT_SCAN` bigint(20) unsigned NOT NULL, `SUM_NO_INDEX_USED` bigint(20) unsigned NOT NULL, `SUM_NO_GOOD_INDEX_USED` bigint(20) unsigned NOT NULL, `FIRST_SEEN` timestamp NULL DEFAULT NULL, `LAST_SEEN` timestamp NULL DEFAULT NULL, INDEX (SCHEMA_NAME, DIGEST) ) DEFAULT CHARSET=utf8\';  IF (v_force_new_snapshot OR in_action = \'snapshot\' OR (in_action = \'overall\' AND in_table IS NULL) OR (in_action = \'save\' AND v_tmp_digests_table_exists <> \'TEMPORARY\') ) THEN IF (v_tmp_digests_table_exists = \'TEMPORARY\') THEN IF (@sys.debug = \'ON\') THEN SELECT \'DROP TEMPORARY TABLE IF EXISTS tmp_digests\' AS \'Debug\'; END IF; DROP TEMPORARY TABLE IF EXISTS tmp_digests; END IF; CALL sys.execute_prepared_stmt(REPLACE(REPLACE(v_digest_table_template, \'%{TEMPORARY}\', \'TEMPORARY \'), \'%{TABLE_NAME}\', \'tmp_digests\'));  SET v_sql = CONCAT(\'INSERT INTO tmp_digests SELECT * FROM \', IF(in_table IS NULL OR in_action = \'save\', \'performance_schema.events_statements_summary_by_digest\', v_quoted_table)); CALL sys.execute_prepared_stmt(v_sql); END IF;  IF (in_action IN (\'create_table\', \'create_tmp\')) THEN IF (in_action = \'create_table\') THEN CALL sys.execute_prepared_stmt(REPLACE(REPLACE(v_digest_table_template, \'%{TEMPORARY}\', \'\'), \'%{TABLE_NAME}\', v_quoted_table)); ELSE CALL sys.execute_prepared_stmt(REPLACE(REPLACE(v_digest_table_template, \'%{TEMPORARY}\', \'TEMPORARY \'), \'%{TABLE_NAME}\', v_quoted_table)); END IF; ELSEIF (in_action = \'save\') THEN CALL sys.execute_prepared_stmt(CONCAT(\'DELETE FROM \', v_quoted_table)); CALL sys.execute_prepared_stmt(CONCAT(\'INSERT INTO \', v_quoted_table, \' SELECT * FROM tmp_digests\')); ELSEIF (in_action = \'cleanup\') THEN DROP TEMPORARY TABLE IF EXISTS sys.tmp_digests; DROP TEMPORARY TABLE IF EXISTS sys.tmp_digests_delta; ELSEIF (in_action IN (\'overall\', \'delta\')) THEN IF (in_action = \'overall\') THEN IF (in_table IS NULL) THEN SET v_digests_table = \'tmp_digests\'; ELSE SET v_digests_table = v_quoted_table; END IF; ELSE SET v_digests_table = \'tmp_digests_delta\'; DROP TEMPORARY TABLE IF EXISTS tmp_digests_delta; CREATE TEMPORARY TABLE tmp_digests_delta LIKE tmp_digests; SET v_sql = CONCAT(\'INSERT INTO tmp_digests_delta SELECT `d_end`.`SCHEMA_NAME`, `d_end`.`DIGEST`, `d_end`.`DIGEST_TEXT`, `d_end`.`COUNT_STAR`-IFNULL(`d_start`.`COUNT_STAR`, 0) AS \'\'COUNT_STAR\'\', `d_end`.`SUM_TIMER_WAIT`-IFNULL(`d_start`.`SUM_TIMER_WAIT`, 0) AS \'\'SUM_TIMER_WAIT\'\', `d_end`.`MIN_TIMER_WAIT` AS \'\'MIN_TIMER_WAIT\'\', IFNULL((`d_end`.`SUM_TIMER_WAIT`-IFNULL(`d_start`.`SUM_TIMER_WAIT`, 0))/NULLIF(`d_end`.`COUNT_STAR`-IFNULL(`d_start`.`COUNT_STAR`, 0), 0), 0) AS \'\'AVG_TIMER_WAIT\'\', `d_end`.`MAX_TIMER_WAIT` AS \'\'MAX_TIMER_WAIT\'\', `d_end`.`SUM_LOCK_TIME`-IFNULL(`d_start`.`SUM_LOCK_TIME`, 0) AS \'\'SUM_LOCK_TIME\'\', `d_end`.`SUM_ERRORS`-IFNULL(`d_start`.`SUM_ERRORS`, 0) AS \'\'SUM_ERRORS\'\', `d_end`.`SUM_WARNINGS`-IFNULL(`d_start`.`SUM_WARNINGS`, 0) AS \'\'SUM_WARNINGS\'\', `d_end`.`SUM_ROWS_AFFECTED`-IFNULL(`d_start`.`SUM_ROWS_AFFECTED`, 0) AS \'\'SUM_ROWS_AFFECTED\'\', `d_end`.`SUM_ROWS_SENT`-IFNULL(`d_start`.`SUM_ROWS_SENT`, 0) AS \'\'SUM_ROWS_SENT\'\', `d_end`.`SUM_ROWS_EXAMINED`-IFNULL(`d_start`.`SUM_ROWS_EXAMINED`, 0) AS \'\'SUM_ROWS_EXAMINED\'\', `d_end`.`SUM_CREATED_TMP_DISK_TABLES`-IFNULL(`d_start`.`SUM_CREATED_TMP_DISK_TABLES`, 0) AS \'\'SUM_CREATED_TMP_DISK_TABLES\'\', `d_end`.`SUM_CREATED_TMP_TABLES`-IFNULL(`d_start`.`SUM_CREATED_TMP_TABLES`, 0) AS \'\'SUM_CREATED_TMP_TABLES\'\', `d_end`.`SUM_SELECT_FULL_JOIN`-IFNULL(`d_start`.`SUM_SELECT_FULL_JOIN`, 0) AS \'\'SUM_SELECT_FULL_JOIN\'\', `d_end`.`SUM_SELECT_FULL_RANGE_JOIN`-IFNULL(`d_start`.`SUM_SELECT_FULL_RANGE_JOIN`, 0) AS \'\'SUM_SELECT_FULL_RANGE_JOIN\'\', `d_end`.`SUM_SELECT_RANGE`-IFNULL(`d_start`.`SUM_SELECT_RANGE`, 0) AS \'\'SUM_SELECT_RANGE\'\', `d_end`.`SUM_SELECT_RANGE_CHECK`-IFNULL(`d_start`.`SUM_SELECT_RANGE_CHECK`, 0) AS \'\'SUM_SELECT_RANGE_CHECK\'\', `d_end`.`SUM_SELECT_SCAN`-IFNULL(`d_start`.`SUM_SELECT_SCAN`, 0) AS \'\'SUM_SELECT_SCAN\'\', `d_end`.`SUM_SORT_MERGE_PASSES`-IFNULL(`d_start`.`SUM_SORT_MERGE_PASSES`, 0) AS \'\'SUM_SORT_MERGE_PASSES\'\', `d_end`.`SUM_SORT_RANGE`-IFNULL(`d_start`.`SUM_SORT_RANGE`, 0) AS \'\'SUM_SORT_RANGE\'\', `d_end`.`SUM_SORT_ROWS`-IFNULL(`d_start`.`SUM_SORT_ROWS`, 0) AS \'\'SUM_SORT_ROWS\'\', `d_end`.`SUM_SORT_SCAN`-IFNULL(`d_start`.`SUM_SORT_SCAN`, 0) AS \'\'SUM_SORT_SCAN\'\', `d_end`.`SUM_NO_INDEX_USED`-IFNULL(`d_start`.`SUM_NO_INDEX_USED`, 0) AS \'\'SUM_NO_INDEX_USED\'\', `d_end`.`SUM_NO_GOOD_INDEX_USED`-IFNULL(`d_start`.`SUM_NO_GOOD_INDEX_USED`, 0) AS \'\'SUM_NO_GOOD_INDEX_USED\'\', `d_end`.`FIRST_SEEN`, `d_end`.`LAST_SEEN` FROM tmp_digests d_end LEFT OUTER JOIN \', v_quoted_table, \' d_start ON `d_start`.`DIGEST` = `d_end`.`DIGEST` AND (`d_start`.`SCHEMA_NAME` = `d_end`.`SCHEMA_NAME` OR (`d_start`.`SCHEMA_NAME` IS NULL AND `d_end`.`SCHEMA_NAME` IS NULL) ) WHERE `d_end`.`COUNT_STAR`-IFNULL(`d_start`.`COUNT_STAR`, 0) > 0\'); CALL sys.execute_prepared_stmt(v_sql); END IF;  IF (FIND_IN_SET(\'with_runtimes_in_95th_percentile\', in_views)) THEN SELECT \'Queries with Runtime in 95th Percentile\' AS \'Next Output\';  DROP TEMPORARY TABLE IF EXISTS tmp_digest_avg_latency_distribution1; DROP TEMPORARY TABLE IF EXISTS tmp_digest_avg_latency_distribution2; DROP TEMPORARY TABLE IF EXISTS tmp_digest_95th_percentile_by_avg_us;  CREATE TEMPORARY TABLE tmp_digest_avg_latency_distribution1 ( cnt bigint unsigned NOT NULL, avg_us decimal(21,0) NOT NULL, PRIMARY KEY (avg_us) ) ENGINE=InnoDB;  SET v_sql = CONCAT(\'INSERT INTO tmp_digest_avg_latency_distribution1 SELECT COUNT(*) cnt,  ROUND(avg_timer_wait/1000000) AS avg_us FROM \', v_digests_table, \' GROUP BY avg_us\'); CALL sys.execute_prepared_stmt(v_sql);  CREATE TEMPORARY TABLE tmp_digest_avg_latency_distribution2 LIKE tmp_digest_avg_latency_distribution1; INSERT INTO tmp_digest_avg_latency_distribution2 SELECT * FROM tmp_digest_avg_latency_distribution1;  CREATE TEMPORARY TABLE tmp_digest_95th_percentile_by_avg_us ( avg_us decimal(21,0) NOT NULL, percentile decimal(46,4) NOT NULL, PRIMARY KEY (avg_us) ) ENGINE=InnoDB;  SET v_sql = CONCAT(\'INSERT INTO tmp_digest_95th_percentile_by_avg_us SELECT s2.avg_us avg_us, IFNULL(SUM(s1.cnt)/NULLIF((SELECT COUNT(*) FROM \', v_digests_table, \'), 0), 0) percentile FROM tmp_digest_avg_latency_distribution1 AS s1 JOIN tmp_digest_avg_latency_distribution2 AS s2 ON s1.avg_us <= s2.avg_us GROUP BY s2.avg_us HAVING percentile > 0.95 ORDER BY percentile LIMIT 1\'); CALL sys.execute_prepared_stmt(v_sql);  SET v_sql = REPLACE( REPLACE( (SELECT VIEW_DEFINITION FROM information_schema.VIEWS WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = \'statements_with_runtimes_in_95th_percentile\' ), \'`performance_schema`.`events_statements_summary_by_digest`\', v_digests_table ), \'sys.x$ps_digest_95th_percentile_by_avg_us\', \'`sys`.`x$ps_digest_95th_percentile_by_avg_us`\' ); CALL sys.execute_prepared_stmt(v_sql);  DROP TEMPORARY TABLE tmp_digest_avg_latency_distribution1; DROP TEMPORARY TABLE tmp_digest_avg_latency_distribution2; DROP TEMPORARY TABLE tmp_digest_95th_percentile_by_avg_us; END IF;  IF (FIND_IN_SET(\'analysis\', in_views)) THEN SELECT CONCAT(\'Top \', @sys.statement_performance_analyzer.limit, \' Queries Ordered by Total Latency\') AS \'Next Output\'; SET v_sql = REPLACE( (SELECT VIEW_DEFINITION FROM information_schema.VIEWS WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = \'statement_analysis\' ), \'`performance_schema`.`events_statements_summary_by_digest`\', v_digests_table ); IF (@sys.statement_performance_analyzer.limit > 0) THEN SET v_sql = CONCAT(v_sql, \' LIMIT \', @sys.statement_performance_analyzer.limit); END IF; CALL sys.execute_prepared_stmt(v_sql); END IF;  IF (FIND_IN_SET(\'with_errors_or_warnings\', in_views)) THEN SELECT CONCAT(\'Top \', @sys.statement_performance_analyzer.limit, \' Queries with Errors\') AS \'Next Output\'; SET v_sql = REPLACE( (SELECT VIEW_DEFINITION FROM information_schema.VIEWS WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = \'statements_with_errors_or_warnings\' ), \'`performance_schema`.`events_statements_summary_by_digest`\', v_digests_table ); IF (@sys.statement_performance_analyzer.limit > 0) THEN SET v_sql = CONCAT(v_sql, \' LIMIT \', @sys.statement_performance_analyzer.limit); END IF; CALL sys.execute_prepared_stmt(v_sql); END IF;  IF (FIND_IN_SET(\'with_full_table_scans\', in_views)) THEN SELECT CONCAT(\'Top \', @sys.statement_performance_analyzer.limit, \' Queries with Full Table Scan\') AS \'Next Output\'; SET v_sql = REPLACE( (SELECT VIEW_DEFINITION FROM information_schema.VIEWS WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = \'statements_with_full_table_scans\' ), \'`performance_schema`.`events_statements_summary_by_digest`\', v_digests_table ); IF (@sys.statement_performance_analyzer.limit > 0) THEN SET v_sql = CONCAT(v_sql, \' LIMIT \', @sys.statement_performance_analyzer.limit); END IF; CALL sys.execute_prepared_stmt(v_sql); END IF;  IF (FIND_IN_SET(\'with_sorting\', in_views)) THEN SELECT CONCAT(\'Top \', @sys.statement_performance_analyzer.limit, \' Queries with Sorting\') AS \'Next Output\'; SET v_sql = REPLACE( (SELECT VIEW_DEFINITION FROM information_schema.VIEWS WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = \'statements_with_sorting\' ), \'`performance_schema`.`events_statements_summary_by_digest`\', v_digests_table ); IF (@sys.statement_performance_analyzer.limit > 0) THEN SET v_sql = CONCAT(v_sql, \' LIMIT \', @sys.statement_performance_analyzer.limit); END IF; CALL sys.execute_prepared_stmt(v_sql); END IF;  IF (FIND_IN_SET(\'with_temp_tables\', in_views)) THEN SELECT CONCAT(\'Top \', @sys.statement_performance_analyzer.limit, \' Queries with Internal Temporary Tables\') AS \'Next Output\'; SET v_sql = REPLACE( (SELECT VIEW_DEFINITION FROM information_schema.VIEWS WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = \'statements_with_temp_tables\' ), \'`performance_schema`.`events_statements_summary_by_digest`\', v_digests_table ); IF (@sys.statement_performance_analyzer.limit > 0) THEN SET v_sql = CONCAT(v_sql, \' LIMIT \', @sys.statement_performance_analyzer.limit); END IF; CALL sys.execute_prepared_stmt(v_sql); END IF;  IF (FIND_IN_SET(\'custom\', in_views)) THEN SELECT CONCAT(\'Top \', @sys.statement_performance_analyzer.limit, \' Queries Using Custom View\') AS \'Next Output\';  IF (@sys.statement_performance_analyzer.view IS NULL) THEN SET @sys.statement_performance_analyzer.view = sys.sys_get_config(\'statement_performance_analyzer.view\', NULL); END IF; IF (@sys.statement_performance_analyzer.view IS NULL) THEN SIGNAL SQLSTATE \'45000\' SET MESSAGE_TEXT = \'The @sys.statement_performance_analyzer.view user variable must be set with the view or query to use.\'; END IF;  IF (NOT INSTR(@sys.statement_performance_analyzer.view, \' \')) THEN IF (NOT INSTR(@sys.statement_performance_analyzer.view, \'.\')) THEN SET v_custom_db   = DATABASE(), v_custom_name = @sys.statement_performance_analyzer.view; ELSE SET v_custom_db   = SUBSTRING_INDEX(@sys.statement_performance_analyzer.view, \'.\', 1); SET v_custom_name = SUBSTRING(@sys.statement_performance_analyzer.view, CHAR_LENGTH(v_custom_db)+2); END IF;  CALL sys.table_exists(v_custom_db, v_custom_name, v_custom_view_exists); IF (v_custom_view_exists <> \'VIEW\') THEN SIGNAL SQLSTATE \'45000\' SET MESSAGE_TEXT = \'The @sys.statement_performance_analyzer.view user variable is set but specified neither an existing view nor a query.\'; END IF;  SET v_sql = REPLACE( (SELECT VIEW_DEFINITION FROM information_schema.VIEWS WHERE TABLE_SCHEMA = v_custom_db AND TABLE_NAME = v_custom_name ), \'`performance_schema`.`events_statements_summary_by_digest`\', v_digests_table ); ELSE SET v_sql = REPLACE(@sys.statement_performance_analyzer.view, \'`performance_schema`.`events_statements_summary_by_digest`\', v_digests_table); END IF;  IF (@sys.statement_performance_analyzer.limit > 0) THEN SET v_sql = CONCAT(v_sql, \' LIMIT \', @sys.statement_performance_analyzer.limit); END IF;  CALL sys.execute_prepared_stmt(v_sql); END IF; END IF;  IF (v_this_thread_enabled = \'YES\') THEN CALL sys.ps_setup_enable_thread(CONNECTION_ID()); END IF;  IF (@log_bin = 1) THEN SET sql_log_bin = @log_bin; END IF; END','mysql.sys@localhost','2017-03-02 18:46:53','2017-03-02 18:46:53','','\n Description\n \n Create a report of the statements running on the server.\n \n The views are calculated based on the overall and/or delta activity.\n \n Requires the SUPER privilege for \"SET sql_log_bin = 0;\".\n \n Parameters\n \n in_action (ENUM(\'snapshot\', \'overall\', \'delta\', \'create_tmp\', \'create_table\', \'save\', \'cleanup\')):\n The action to take. Supported actions are:\n * snapshot      Store a snapshot. The default is to make a snapshot of the current content of\n performance_schema.events_statements_summary_by_digest, but by setting in_table\n this can be overwritten to copy the content of the specified table.\n The snapshot is stored in the sys.tmp_digests temporary table.\n * overall       Generate analyzis based on the content specified by in_table. For the overall analyzis,\n in_table can be NOW() to use a fresh snapshot. This will overwrite an existing snapshot.\n Use NULL for in_table to use the existing snapshot. If in_table IS NULL and no snapshot\n exists, a new will be created.\n See also in_views and @sys.statement_performance_analyzer.limit.\n * delta         Generate a delta analysis. The delta will be calculated between the reference table in\n in_table and the snapshot. An existing snapshot must exist.\n The action uses the sys.tmp_digests_delta temporary table.\n See also in_views and @sys.statement_performance_analyzer.limit.\n * create_table  Create a regular table suitable for storing the snapshot for later use, e.g. for\n calculating deltas.\n * create_tmp    Create a temporary table suitable for storing the snapshot for later use, e.g. for\n calculating deltas.\n * save          Save the snapshot in the table specified by in_table. The table must exists and have\n the correct structure.\n If no snapshot exists, a new is created.\n * cleanup       Remove the temporary tables used for the snapshot and delta.\n \n in_table (VARCHAR(129)):\n The table argument used for some actions. Use the format \'db1.t1\' or \'t1\' without using any backticks (`)\n for quoting. Periods (.) are not supported in the database and table names.\n \n The meaning of the table for each action supporting the argument is:\n \n * snapshot      The snapshot is created based on the specified table. Set to NULL or NOW() to use\n the current content of performance_schema.events_statements_summary_by_digest.\n * overall       The table with the content to create the overall analyzis for. The following values\n can be used:\n - A table name - use the content of that table.\n - NOW()        - create a fresh snapshot and overwrite the existing snapshot.\n - NULL         - use the last stored snapshot.\n * delta         The table name is mandatory and specified the reference view to compare the currently\n stored snapshot against. If no snapshot exists, a new will be created.\n * create_table  The name of the regular table to create.\n * create_tmp    The name of the temporary table to create.\n * save          The name of the table to save the currently stored snapshot into.\n \n in_views (SET (\'with_runtimes_in_95th_percentile\', \'analysis\', \'with_errors_or_warnings\',\n \'with_full_table_scans\', \'with_sorting\', \'with_temp_tables\', \'custom\'))\n Which views to include:  * with_runtimes_in_95th_percentile  Based on the sys.statements_with_runtimes_in_95th_percentile view * analysis                          Based on the sys.statement_analysis view * with_errors_or_warnings           Based on the sys.statements_with_errors_or_warnings view * with_full_table_scans             Based on the sys.statements_with_full_table_scans view * with_sorting                      Based on the sys.statements_with_sorting view * with_temp_tables                  Based on the sys.statements_with_temp_tables view * custom                            Use a custom view. This view must be specified in @sys.statement_performance_analyzer.view to an existing view or a query  Default is to include all except \'custom\'.   Configuration Options  sys.statement_performance_analyzer.limit The maximum number of rows to include for the views that does not have a built-in limit (e.g. the 95th percentile view). If not set the limit is 100.  sys.statement_performance_analyzer.view Used together with the \'custom\' view. If the value contains a space, it is considered a query, otherwise it must be an existing view querying the performance_schema.events_statements_summary_by_digest table. There cannot be any limit clause including in the query or view definition if @sys.statement_performance_analyzer.limit > 0. If specifying a view, use the same format as for in_table.  sys.debug Whether to provide debugging output. Default is \'OFF\'. Set to \'ON\' to include.   Example  To create a report with the queries in the 95th percentile since last truncate of performance_schema.events_statements_summary_by_digest and the delta for a 1 minute period:  1. Create a temporary table to store the initial snapshot. 2. Create the initial snapshot. 3. Save the initial snapshot in the temporary table. 4. Wait one minute. 5. Create a new snapshot. 6. Perform analyzis based on the new snapshot. 7. Perform analyzis based on the delta between the initial and new snapshots.  mysql> CALL sys.statement_performance_analyzer(\'create_tmp\', \'mydb.tmp_digests_ini\', NULL); Query OK, 0 rows affected (0.08 sec)  mysql> CALL sys.statement_performance_analyzer(\'snapshot\', NULL, NULL); Query OK, 0 rows affected (0.02 sec)  mysql> CALL sys.statement_performance_analyzer(\'save\', \'mydb.tmp_digests_ini\', NULL); Query OK, 0 rows affected (0.00 sec)  mysql> DO SLEEP(60); Query OK, 0 rows affected (1 min 0.00 sec)  mysql> CALL sys.statement_performance_analyzer(\'snapshot\', NULL, NULL); Query OK, 0 rows affected (0.02 sec)  mysql> CALL sys.statement_performance_analyzer(\'overall\', NULL, \'with_runtimes_in_95th_percentile\'); +-----------------------------------------+ | Next Output                             | +-----------------------------------------+ | Queries with Runtime in 95th Percentile | +-----------------------------------------+ 1 row in set (0.05 sec)  ...  mysql> CALL sys.statement_performance_analyzer(\'delta\', \'mydb.tmp_digests_ini\', \'with_runtimes_in_95th_percentile\'); +-----------------------------------------+ | Next Output                             | +-----------------------------------------+ | Queries with Runtime in 95th Percentile | +-----------------------------------------+ 1 row in set (0.03 sec)  ...   To create an overall report of the 95th percentile queries and the top 10 queries with full table scans:  mysql> CALL sys.statement_performance_analyzer(\'snapshot\', NULL, NULL); Query OK, 0 rows affected (0.01 sec)                                     mysql> SET @sys.statement_performance_analyzer.limit = 10; Query OK, 0 rows affected (0.00 sec)            mysql> CALL sys.statement_performance_analyzer(\'overall\', NULL, \'with_runtimes_in_95th_percentile,with_full_table_scans\'); +-----------------------------------------+ | Next Output                             | +-----------------------------------------+ | Queries with Runtime in 95th Percentile | +-----------------------------------------+ 1 row in set (0.01 sec)  ...  +-------------------------------------+ | Next Output                         | +-------------------------------------+ | Top 10 Queries with Full Table Scan | +-------------------------------------+ 1 row in set (0.09 sec)  ...   Use a custom view showing the top 10 query sorted by total execution time refreshing the view every minute using the watch command in Linux.  mysql> CREATE OR REPLACE VIEW mydb.my_statements AS -> SELECT sys.format_statement(DIGEST_TEXT) AS query, ->        SCHEMA_NAME AS db, ->        COUNT_STAR AS exec_count, ->        sys.format_time(SUM_TIMER_WAIT) AS total_latency, ->        sys.format_time(AVG_TIMER_WAIT) AS avg_latency, ->        ROUND(IFNULL(SUM_ROWS_SENT / NULLIF(COUNT_STAR, 0), 0)) AS rows_sent_avg, ->        ROUND(IFNULL(SUM_ROWS_EXAMINED / NULLIF(COUNT_STAR, 0), 0)) AS rows_examined_avg, ->        ROUND(IFNULL(SUM_ROWS_AFFECTED / NULLIF(COUNT_STAR, 0), 0)) AS rows_affected_avg, ->        DIGEST AS digest ->   FROM performance_schema.events_statements_summary_by_digest -> ORDER BY SUM_TIMER_WAIT DESC; Query OK, 0 rows affected (0.01 sec)  mysql> CALL sys.statement_performance_analyzer(\'create_table\', \'mydb.digests_prev\', NULL); Query OK, 0 rows affected (0.10 sec)  shell$ watch -n 60 \"mysql sys --table -e \" > SET @sys.statement_performance_analyzer.view = \'mydb.my_statements\'; > SET @sys.statement_performance_analyzer.limit = 10; > CALL statement_performance_analyzer(\'snapshot\', NULL, NULL); > CALL statement_performance_analyzer(\'delta\', \'mydb.digests_prev\', \'custom\'); > CALL statement_performance_analyzer(\'save\', \'mydb.digests_prev\', NULL); > \"\"  Every 60.0s: mysql sys --table -e \"                                                                                                   ...  Mon Dec 22 10:58:51 2014  +----------------------------------+ | Next Output                      | +----------------------------------+ | Top 10 Queries Using Custom View | +----------------------------------+ +-------------------+-------+------------+---------------+-------------+---------------+-------------------+-------------------+----------------------------------+ | query             | db    | exec_count | total_latency | avg_latency | rows_sent_avg | rows_examined_avg | rows_affected_avg | digest                           | +-------------------+-------+------------+---------------+-------------+---------------+-------------------+-------------------+----------------------------------+ ... ','utf8','utf8_general_ci','utf8_general_ci',_binary 'BEGIN DECLARE v_table_exists, v_tmp_digests_table_exists, v_custom_view_exists ENUM(\'\', \'BASE TABLE\', \'VIEW\', \'TEMPORARY\') DEFAULT \'\'; DECLARE v_this_thread_enabled ENUM(\'YES\', \'NO\'); DECLARE v_force_new_snapshot BOOLEAN DEFAULT FALSE; DECLARE v_digests_table VARCHAR(133); DECLARE v_quoted_table, v_quoted_custom_view VARCHAR(133) DEFAULT \'\'; DECLARE v_table_db, v_table_name, v_custom_db, v_custom_name VARCHAR(64); DECLARE v_digest_table_template, v_checksum_ref, v_checksum_table text; DECLARE v_sql longtext; DECLARE v_error_msg VARCHAR(128);   SELECT INSTRUMENTED INTO v_this_thread_enabled FROM performance_schema.threads WHERE PROCESSLIST_ID = CONNECTION_ID(); IF (v_this_thread_enabled = \'YES\') THEN CALL sys.ps_setup_disable_thread(CONNECTION_ID()); END IF;  SET @log_bin := @@sql_log_bin; IF (@log_bin = 1) THEN SET sql_log_bin = 0; END IF;   IF (@sys.statement_performance_analyzer.limit IS NULL) THEN SET @sys.statement_performance_analyzer.limit = sys.sys_get_config(\'statement_performance_analyzer.limit\', \'100\'); END IF; IF (@sys.debug IS NULL) THEN SET @sys.debug                                = sys.sys_get_config(\'debug\'                               , \'OFF\'); END IF;   IF (in_table = \'NOW()\') THEN SET v_force_new_snapshot = TRUE, in_table             = NULL; ELSEIF (in_table IS NOT NULL) THEN IF (NOT INSTR(in_table, \'.\')) THEN SET v_table_db   = DATABASE(), v_table_name = in_table; ELSE SET v_table_db   = SUBSTRING_INDEX(in_table, \'.\', 1); SET v_table_name = SUBSTRING(in_table, CHAR_LENGTH(v_table_db)+2); END IF;  SET v_quoted_table = CONCAT(\'`\', v_table_db, \'`.`\', v_table_name, \'`\');  IF (@sys.debug = \'ON\') THEN SELECT CONCAT(\'in_table is: db = \'\', v_table_db, \'\', table = \'\', v_table_name, \'\'\') AS \'Debug\'; END IF;  IF (v_table_db = DATABASE() AND (v_table_name = \'tmp_digests\' OR v_table_name = \'tmp_digests_delta\')) THEN SET v_error_msg = CONCAT(\'Invalid value for in_table: \', v_quoted_table, \' is reserved table name.\'); SIGNAL SQLSTATE \'45000\' SET MESSAGE_TEXT = v_error_msg; END IF;  CALL sys.table_exists(v_table_db, v_table_name, v_table_exists); IF (@sys.debug = \'ON\') THEN SELECT CONCAT(\'v_table_exists = \', v_table_exists) AS \'Debug\'; END IF;  IF (v_table_exists = \'BASE TABLE\') THEN SET v_checksum_ref = ( SELECT GROUP_CONCAT(CONCAT(COLUMN_NAME, COLUMN_TYPE) ORDER BY ORDINAL_POSITION) AS Checksum FROM information_schema.COLUMNS WHERE TABLE_SCHEMA = \'performance_schema\' AND TABLE_NAME = \'events_statements_summary_by_digest\' ), v_checksum_table = ( SELECT GROUP_CONCAT(CONCAT(COLUMN_NAME, COLUMN_TYPE) ORDER BY ORDINAL_POSITION) AS Checksum FROM information_schema.COLUMNS WHERE TABLE_SCHEMA = v_table_db AND TABLE_NAME = v_table_name );  IF (v_checksum_ref <> v_checksum_table) THEN SET v_error_msg = CONCAT(\'The table \', IF(CHAR_LENGTH(v_quoted_table) > 93, CONCAT(\'...\', SUBSTRING(v_quoted_table, -90)), v_quoted_table), \' has the wrong definition.\'); SIGNAL SQLSTATE \'45000\' SET MESSAGE_TEXT = v_error_msg; END IF; END IF; END IF;   IF (in_views IS NULL OR in_views = \'\') THEN SET in_views = \'with_runtimes_in_95th_percentile,analysis,with_errors_or_warnings,with_full_table_scans,with_sorting,with_temp_tables\'; END IF;   CALL sys.table_exists(DATABASE(), \'tmp_digests\', v_tmp_digests_table_exists); IF (@sys.debug = \'ON\') THEN SELECT CONCAT(\'v_tmp_digests_table_exists = \', v_tmp_digests_table_exists) AS \'Debug\'; END IF;  CASE WHEN in_action IN (\'snapshot\', \'overall\') THEN IF (in_table IS NOT NULL) THEN IF (NOT v_table_exists IN (\'TEMPORARY\', \'BASE TABLE\')) THEN SET v_error_msg = CONCAT(\'The \', in_action, \' action requires in_table to be NULL, NOW() or specify an existing table.\', \' The table \', IF(CHAR_LENGTH(v_quoted_table) > 16, CONCAT(\'...\', SUBSTRING(v_quoted_table, -13)), v_quoted_table), \' does not exist.\'); SIGNAL SQLSTATE \'45000\' SET MESSAGE_TEXT = v_error_msg; END IF; END IF;  WHEN in_action IN (\'delta\', \'save\') THEN IF (v_table_exists NOT IN (\'TEMPORARY\', \'BASE TABLE\')) THEN SET v_error_msg = CONCAT(\'The \', in_action, \' action requires in_table to be an existing table.\', IF(in_table IS NOT NULL, CONCAT(\' The table \', IF(CHAR_LENGTH(v_quoted_table) > 39, CONCAT(\'...\', SUBSTRING(v_quoted_table, -36)), v_quoted_table), \' does not exist.\'), \'\')); SIGNAL SQLSTATE \'45000\' SET MESSAGE_TEXT = v_error_msg; END IF;  IF (in_action = \'delta\' AND v_tmp_digests_table_exists <> \'TEMPORARY\') THEN SIGNAL SQLSTATE \'45000\' SET MESSAGE_TEXT = \'An existing snapshot generated with the statement_performance_analyzer() must exist.\'; END IF; WHEN in_action = \'create_tmp\' THEN IF (v_table_exists = \'TEMPORARY\') THEN SET v_error_msg = CONCAT(\'Cannot create the table \', IF(CHAR_LENGTH(v_quoted_table) > 72, CONCAT(\'...\', SUBSTRING(v_quoted_table, -69)), v_quoted_table), \' as it already exists.\'); SIGNAL SQLSTATE \'45000\' SET MESSAGE_TEXT = v_error_msg; END IF;  WHEN in_action = \'create_table\' THEN IF (v_table_exists <> \'\') THEN SET v_error_msg = CONCAT(\'Cannot create the table \', IF(CHAR_LENGTH(v_quoted_table) > 52, CONCAT(\'...\', SUBSTRING(v_quoted_table, -49)), v_quoted_table), \' as it already exists\', IF(v_table_exists = \'TEMPORARY\', \' as a temporary table.\', \'.\')); SIGNAL SQLSTATE \'45000\' SET MESSAGE_TEXT = v_error_msg; END IF;  WHEN in_action = \'cleanup\' THEN DO (SELECT 1); ELSE SIGNAL SQLSTATE \'45000\' SET MESSAGE_TEXT = \'Unknown action. Supported actions are: cleanup, create_table, create_tmp, delta, overall, save, snapshot\'; END CASE;  SET v_digest_table_template = \'CREATE %{TEMPORARY}TABLE %{TABLE_NAME} ( `SCHEMA_NAME` varchar(64) DEFAULT NULL, `DIGEST` varchar(32) DEFAULT NULL, `DIGEST_TEXT` longtext, `COUNT_STAR` bigint(20) unsigned NOT NULL, `SUM_TIMER_WAIT` bigint(20) unsigned NOT NULL, `MIN_TIMER_WAIT` bigint(20) unsigned NOT NULL, `AVG_TIMER_WAIT` bigint(20) unsigned NOT NULL, `MAX_TIMER_WAIT` bigint(20) unsigned NOT NULL, `SUM_LOCK_TIME` bigint(20) unsigned NOT NULL, `SUM_ERRORS` bigint(20) unsigned NOT NULL, `SUM_WARNINGS` bigint(20) unsigned NOT NULL, `SUM_ROWS_AFFECTED` bigint(20) unsigned NOT NULL, `SUM_ROWS_SENT` bigint(20) unsigned NOT NULL, `SUM_ROWS_EXAMINED` bigint(20) unsigned NOT NULL, `SUM_CREATED_TMP_DISK_TABLES` bigint(20) unsigned NOT NULL, `SUM_CREATED_TMP_TABLES` bigint(20) unsigned NOT NULL, `SUM_SELECT_FULL_JOIN` bigint(20) unsigned NOT NULL, `SUM_SELECT_FULL_RANGE_JOIN` bigint(20) unsigned NOT NULL, `SUM_SELECT_RANGE` bigint(20) unsigned NOT NULL, `SUM_SELECT_RANGE_CHECK` bigint(20) unsigned NOT NULL, `SUM_SELECT_SCAN` bigint(20) unsigned NOT NULL, `SUM_SORT_MERGE_PASSES` bigint(20) unsigned NOT NULL, `SUM_SORT_RANGE` bigint(20) unsigned NOT NULL, `SUM_SORT_ROWS` bigint(20) unsigned NOT NULL, `SUM_SORT_SCAN` bigint(20) unsigned NOT NULL, `SUM_NO_INDEX_USED` bigint(20) unsigned NOT NULL, `SUM_NO_GOOD_INDEX_USED` bigint(20) unsigned NOT NULL, `FIRST_SEEN` timestamp NULL DEFAULT NULL, `LAST_SEEN` timestamp NULL DEFAULT NULL, INDEX (SCHEMA_NAME, DIGEST) ) DEFAULT CHARSET=utf8\';  IF (v_force_new_snapshot OR in_action = \'snapshot\' OR (in_action = \'overall\' AND in_table IS NULL) OR (in_action = \'save\' AND v_tmp_digests_table_exists <> \'TEMPORARY\') ) THEN IF (v_tmp_digests_table_exists = \'TEMPORARY\') THEN IF (@sys.debug = \'ON\') THEN SELECT \'DROP TEMPORARY TABLE IF EXISTS tmp_digests\' AS \'Debug\'; END IF; DROP TEMPORARY TABLE IF EXISTS tmp_digests; END IF; CALL sys.execute_prepared_stmt(REPLACE(REPLACE(v_digest_table_template, \'%{TEMPORARY}\', \'TEMPORARY \'), \'%{TABLE_NAME}\', \'tmp_digests\'));  SET v_sql = CONCAT(\'INSERT INTO tmp_digests SELECT * FROM \', IF(in_table IS NULL OR in_action = \'save\', \'performance_schema.events_statements_summary_by_digest\', v_quoted_table)); CALL sys.execute_prepared_stmt(v_sql); END IF;  IF (in_action IN (\'create_table\', \'create_tmp\')) THEN IF (in_action = \'create_table\') THEN CALL sys.execute_prepared_stmt(REPLACE(REPLACE(v_digest_table_template, \'%{TEMPORARY}\', \'\'), \'%{TABLE_NAME}\', v_quoted_table)); ELSE CALL sys.execute_prepared_stmt(REPLACE(REPLACE(v_digest_table_template, \'%{TEMPORARY}\', \'TEMPORARY \'), \'%{TABLE_NAME}\', v_quoted_table)); END IF; ELSEIF (in_action = \'save\') THEN CALL sys.execute_prepared_stmt(CONCAT(\'DELETE FROM \', v_quoted_table)); CALL sys.execute_prepared_stmt(CONCAT(\'INSERT INTO \', v_quoted_table, \' SELECT * FROM tmp_digests\')); ELSEIF (in_action = \'cleanup\') THEN DROP TEMPORARY TABLE IF EXISTS sys.tmp_digests; DROP TEMPORARY TABLE IF EXISTS sys.tmp_digests_delta; ELSEIF (in_action IN (\'overall\', \'delta\')) THEN IF (in_action = \'overall\') THEN IF (in_table IS NULL) THEN SET v_digests_table = \'tmp_digests\'; ELSE SET v_digests_table = v_quoted_table; END IF; ELSE SET v_digests_table = \'tmp_digests_delta\'; DROP TEMPORARY TABLE IF EXISTS tmp_digests_delta; CREATE TEMPORARY TABLE tmp_digests_delta LIKE tmp_digests; SET v_sql = CONCAT(\'INSERT INTO tmp_digests_delta SELECT `d_end`.`SCHEMA_NAME`, `d_end`.`DIGEST`, `d_end`.`DIGEST_TEXT`, `d_end`.`COUNT_STAR`-IFNULL(`d_start`.`COUNT_STAR`, 0) AS \'COUNT_STAR\', `d_end`.`SUM_TIMER_WAIT`-IFNULL(`d_start`.`SUM_TIMER_WAIT`, 0) AS \'SUM_TIMER_WAIT\', `d_end`.`MIN_TIMER_WAIT` AS \'MIN_TIMER_WAIT\', IFNULL((`d_end`.`SUM_TIMER_WAIT`-IFNULL(`d_start`.`SUM_TIMER_WAIT`, 0))/NULLIF(`d_end`.`COUNT_STAR`-IFNULL(`d_start`.`COUNT_STAR`, 0), 0), 0) AS \'AVG_TIMER_WAIT\', `d_end`.`MAX_TIMER_WAIT` AS \'MAX_TIMER_WAIT\', `d_end`.`SUM_LOCK_TIME`-IFNULL(`d_start`.`SUM_LOCK_TIME`, 0) AS \'SUM_LOCK_TIME\', `d_end`.`SUM_ERRORS`-IFNULL(`d_start`.`SUM_ERRORS`, 0) AS \'SUM_ERRORS\', `d_end`.`SUM_WARNINGS`-IFNULL(`d_start`.`SUM_WARNINGS`, 0) AS \'SUM_WARNINGS\', `d_end`.`SUM_ROWS_AFFECTED`-IFNULL(`d_start`.`SUM_ROWS_AFFECTED`, 0) AS \'SUM_ROWS_AFFECTED\', `d_end`.`SUM_ROWS_SENT`-IFNULL(`d_start`.`SUM_ROWS_SENT`, 0) AS \'SUM_ROWS_SENT\', `d_end`.`SUM_ROWS_EXAMINED`-IFNULL(`d_start`.`SUM_ROWS_EXAMINED`, 0) AS \'SUM_ROWS_EXAMINED\', `d_end`.`SUM_CREATED_TMP_DISK_TABLES`-IFNULL(`d_start`.`SUM_CREATED_TMP_DISK_TABLES`, 0) AS \'SUM_CREATED_TMP_DISK_TABLES\', `d_end`.`SUM_CREATED_TMP_TABLES`-IFNULL(`d_start`.`SUM_CREATED_TMP_TABLES`, 0) AS \'SUM_CREATED_TMP_TABLES\', `d_end`.`SUM_SELECT_FULL_JOIN`-IFNULL(`d_start`.`SUM_SELECT_FULL_JOIN`, 0) AS \'SUM_SELECT_FULL_JOIN\', `d_end`.`SUM_SELECT_FULL_RANGE_JOIN`-IFNULL(`d_start`.`SUM_SELECT_FULL_RANGE_JOIN`, 0) AS \'SUM_SELECT_FULL_RANGE_JOIN\', `d_end`.`SUM_SELECT_RANGE`-IFNULL(`d_start`.`SUM_SELECT_RANGE`, 0) AS \'SUM_SELECT_RANGE\', `d_end`.`SUM_SELECT_RANGE_CHECK`-IFNULL(`d_start`.`SUM_SELECT_RANGE_CHECK`, 0) AS \'SUM_SELECT_RANGE_CHECK\', `d_end`.`SUM_SELECT_SCAN`-IFNULL(`d_start`.`SUM_SELECT_SCAN`, 0) AS \'SUM_SELECT_SCAN\', `d_end`.`SUM_SORT_MERGE_PASSES`-IFNULL(`d_start`.`SUM_SORT_MERGE_PASSES`, 0) AS \'SUM_SORT_MERGE_PASSES\', `d_end`.`SUM_SORT_RANGE`-IFNULL(`d_start`.`SUM_SORT_RANGE`, 0) AS \'SUM_SORT_RANGE\', `d_end`.`SUM_SORT_ROWS`-IFNULL(`d_start`.`SUM_SORT_ROWS`, 0) AS \'SUM_SORT_ROWS\', `d_end`.`SUM_SORT_SCAN`-IFNULL(`d_start`.`SUM_SORT_SCAN`, 0) AS \'SUM_SORT_SCAN\', `d_end`.`SUM_NO_INDEX_USED`-IFNULL(`d_start`.`SUM_NO_INDEX_USED`, 0) AS \'SUM_NO_INDEX_USED\', `d_end`.`SUM_NO_GOOD_INDEX_USED`-IFNULL(`d_start`.`SUM_NO_GOOD_INDEX_USED`, 0) AS \'SUM_NO_GOOD_INDEX_USED\', `d_end`.`FIRST_SEEN`, `d_end`.`LAST_SEEN` FROM tmp_digests d_end LEFT OUTER JOIN \', v_quoted_table, \' d_start ON `d_start`.`DIGEST` = `d_end`.`DIGEST` AND (`d_start`.`SCHEMA_NAME` = `d_end`.`SCHEMA_NAME` OR (`d_start`.`SCHEMA_NAME` IS NULL AND `d_end`.`SCHEMA_NAME` IS NULL) ) WHERE `d_end`.`COUNT_STAR`-IFNULL(`d_start`.`COUNT_STAR`, 0) > 0\'); CALL sys.execute_prepared_stmt(v_sql); END IF;  IF (FIND_IN_SET(\'with_runtimes_in_95th_percentile\', in_views)) THEN SELECT \'Queries with Runtime in 95th Percentile\' AS \'Next Output\';  DROP TEMPORARY TABLE IF EXISTS tmp_digest_avg_latency_distribution1; DROP TEMPORARY TABLE IF EXISTS tmp_digest_avg_latency_distribution2; DROP TEMPORARY TABLE IF EXISTS tmp_digest_95th_percentile_by_avg_us;  CREATE TEMPORARY TABLE tmp_digest_avg_latency_distribution1 ( cnt bigint unsigned NOT NULL, avg_us decimal(21,0) NOT NULL, PRIMARY KEY (avg_us) ) ENGINE=InnoDB;  SET v_sql = CONCAT(\'INSERT INTO tmp_digest_avg_latency_distribution1 SELECT COUNT(*) cnt,  ROUND(avg_timer_wait/1000000) AS avg_us FROM \', v_digests_table, \' GROUP BY avg_us\'); CALL sys.execute_prepared_stmt(v_sql);  CREATE TEMPORARY TABLE tmp_digest_avg_latency_distribution2 LIKE tmp_digest_avg_latency_distribution1; INSERT INTO tmp_digest_avg_latency_distribution2 SELECT * FROM tmp_digest_avg_latency_distribution1;  CREATE TEMPORARY TABLE tmp_digest_95th_percentile_by_avg_us ( avg_us decimal(21,0) NOT NULL, percentile decimal(46,4) NOT NULL, PRIMARY KEY (avg_us) ) ENGINE=InnoDB;  SET v_sql = CONCAT(\'INSERT INTO tmp_digest_95th_percentile_by_avg_us SELECT s2.avg_us avg_us, IFNULL(SUM(s1.cnt)/NULLIF((SELECT COUNT(*) FROM \', v_digests_table, \'), 0), 0) percentile FROM tmp_digest_avg_latency_distribution1 AS s1 JOIN tmp_digest_avg_latency_distribution2 AS s2 ON s1.avg_us <= s2.avg_us GROUP BY s2.avg_us HAVING percentile > 0.95 ORDER BY percentile LIMIT 1\'); CALL sys.execute_prepared_stmt(v_sql);  SET v_sql = REPLACE( REPLACE( (SELECT VIEW_DEFINITION FROM information_schema.VIEWS WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = \'statements_with_runtimes_in_95th_percentile\' ), \'`performance_schema`.`events_statements_summary_by_digest`\', v_digests_table ), \'sys.x$ps_digest_95th_percentile_by_avg_us\', \'`sys`.`x$ps_digest_95th_percentile_by_avg_us`\' ); CALL sys.execute_prepared_stmt(v_sql);  DROP TEMPORARY TABLE tmp_digest_avg_latency_distribution1; DROP TEMPORARY TABLE tmp_digest_avg_latency_distribution2; DROP TEMPORARY TABLE tmp_digest_95th_percentile_by_avg_us; END IF;  IF (FIND_IN_SET(\'analysis\', in_views)) THEN SELECT CONCAT(\'Top \', @sys.statement_performance_analyzer.limit, \' Queries Ordered by Total Latency\') AS \'Next Output\'; SET v_sql = REPLACE( (SELECT VIEW_DEFINITION FROM information_schema.VIEWS WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = \'statement_analysis\' ), \'`performance_schema`.`events_statements_summary_by_digest`\', v_digests_table ); IF (@sys.statement_performance_analyzer.limit > 0) THEN SET v_sql = CONCAT(v_sql, \' LIMIT \', @sys.statement_performance_analyzer.limit); END IF; CALL sys.execute_prepared_stmt(v_sql); END IF;  IF (FIND_IN_SET(\'with_errors_or_warnings\', in_views)) THEN SELECT CONCAT(\'Top \', @sys.statement_performance_analyzer.limit, \' Queries with Errors\') AS \'Next Output\'; SET v_sql = REPLACE( (SELECT VIEW_DEFINITION FROM information_schema.VIEWS WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = \'statements_with_errors_or_warnings\' ), \'`performance_schema`.`events_statements_summary_by_digest`\', v_digests_table ); IF (@sys.statement_performance_analyzer.limit > 0) THEN SET v_sql = CONCAT(v_sql, \' LIMIT \', @sys.statement_performance_analyzer.limit); END IF; CALL sys.execute_prepared_stmt(v_sql); END IF;  IF (FIND_IN_SET(\'with_full_table_scans\', in_views)) THEN SELECT CONCAT(\'Top \', @sys.statement_performance_analyzer.limit, \' Queries with Full Table Scan\') AS \'Next Output\'; SET v_sql = REPLACE( (SELECT VIEW_DEFINITION FROM information_schema.VIEWS WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = \'statements_with_full_table_scans\' ), \'`performance_schema`.`events_statements_summary_by_digest`\', v_digests_table ); IF (@sys.statement_performance_analyzer.limit > 0) THEN SET v_sql = CONCAT(v_sql, \' LIMIT \', @sys.statement_performance_analyzer.limit); END IF; CALL sys.execute_prepared_stmt(v_sql); END IF;  IF (FIND_IN_SET(\'with_sorting\', in_views)) THEN SELECT CONCAT(\'Top \', @sys.statement_performance_analyzer.limit, \' Queries with Sorting\') AS \'Next Output\'; SET v_sql = REPLACE( (SELECT VIEW_DEFINITION FROM information_schema.VIEWS WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = \'statements_with_sorting\' ), \'`performance_schema`.`events_statements_summary_by_digest`\', v_digests_table ); IF (@sys.statement_performance_analyzer.limit > 0) THEN SET v_sql = CONCAT(v_sql, \' LIMIT \', @sys.statement_performance_analyzer.limit); END IF; CALL sys.execute_prepared_stmt(v_sql); END IF;  IF (FIND_IN_SET(\'with_temp_tables\', in_views)) THEN SELECT CONCAT(\'Top \', @sys.statement_performance_analyzer.limit, \' Queries with Internal Temporary Tables\') AS \'Next Output\'; SET v_sql = REPLACE( (SELECT VIEW_DEFINITION FROM information_schema.VIEWS WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = \'statements_with_temp_tables\' ), \'`performance_schema`.`events_statements_summary_by_digest`\', v_digests_table ); IF (@sys.statement_performance_analyzer.limit > 0) THEN SET v_sql = CONCAT(v_sql, \' LIMIT \', @sys.statement_performance_analyzer.limit); END IF; CALL sys.execute_prepared_stmt(v_sql); END IF;  IF (FIND_IN_SET(\'custom\', in_views)) THEN SELECT CONCAT(\'Top \', @sys.statement_performance_analyzer.limit, \' Queries Using Custom View\') AS \'Next Output\';  IF (@sys.statement_performance_analyzer.view IS NULL) THEN SET @sys.statement_performance_analyzer.view = sys.sys_get_config(\'statement_performance_analyzer.view\', NULL); END IF; IF (@sys.statement_performance_analyzer.view IS NULL) THEN SIGNAL SQLSTATE \'45000\' SET MESSAGE_TEXT = \'The @sys.statement_performance_analyzer.view user variable must be set with the view or query to use.\'; END IF;  IF (NOT INSTR(@sys.statement_performance_analyzer.view, \' \')) THEN IF (NOT INSTR(@sys.statement_performance_analyzer.view, \'.\')) THEN SET v_custom_db   = DATABASE(), v_custom_name = @sys.statement_performance_analyzer.view; ELSE SET v_custom_db   = SUBSTRING_INDEX(@sys.statement_performance_analyzer.view, \'.\', 1); SET v_custom_name = SUBSTRING(@sys.statement_performance_analyzer.view, CHAR_LENGTH(v_custom_db)+2); END IF;  CALL sys.table_exists(v_custom_db, v_custom_name, v_custom_view_exists); IF (v_custom_view_exists <> \'VIEW\') THEN SIGNAL SQLSTATE \'45000\' SET MESSAGE_TEXT = \'The @sys.statement_performance_analyzer.view user variable is set but specified neither an existing view nor a query.\'; END IF;  SET v_sql = REPLACE( (SELECT VIEW_DEFINITION FROM information_schema.VIEWS WHERE TABLE_SCHEMA = v_custom_db AND TABLE_NAME = v_custom_name ), \'`performance_schema`.`events_statements_summary_by_digest`\', v_digests_table ); ELSE SET v_sql = REPLACE(@sys.statement_performance_analyzer.view, \'`performance_schema`.`events_statements_summary_by_digest`\', v_digests_table); END IF;  IF (@sys.statement_performance_analyzer.limit > 0) THEN SET v_sql = CONCAT(v_sql, \' LIMIT \', @sys.statement_performance_analyzer.limit); END IF;  CALL sys.execute_prepared_stmt(v_sql); END IF; END IF;  IF (v_this_thread_enabled = \'YES\') THEN CALL sys.ps_setup_enable_thread(CONNECTION_ID()); END IF;  IF (@log_bin = 1) THEN SET sql_log_bin = @log_bin; END IF; END'),('sys','table_exists','PROCEDURE','table_exists','SQL','CONTAINS_SQL','NO','INVOKER',_binary ' IN in_db VARCHAR(64), IN in_table VARCHAR(64), OUT out_exists ENUM(\'\', \'BASE TABLE\', \'VIEW\', \'TEMPORARY\') ','',_binary 'BEGIN DECLARE v_error BOOLEAN DEFAULT FALSE; DECLARE CONTINUE HANDLER FOR 1050 SET v_error = TRUE; DECLARE CONTINUE HANDLER FOR 1146 SET v_error = TRUE;  SET out_exists = \'\';  IF (EXISTS(SELECT 1 FROM information_schema.TABLES WHERE TABLE_SCHEMA = in_db AND TABLE_NAME = in_table)) THEN SET @sys.tmp.table_exists.SQL = CONCAT(\'CREATE TEMPORARY TABLE `\', in_db, \'`.`\', in_table, \'` (id INT PRIMARY KEY)\'); PREPARE stmt_create_table FROM @sys.tmp.table_exists.SQL; EXECUTE stmt_create_table; DEALLOCATE PREPARE stmt_create_table; IF (v_error) THEN SET out_exists = \'TEMPORARY\'; ELSE SET @sys.tmp.table_exists.SQL = CONCAT(\'DROP TEMPORARY TABLE `\', in_db, \'`.`\', in_table, \'`\'); PREPARE stmt_drop_table FROM @sys.tmp.table_exists.SQL; EXECUTE stmt_drop_table; DEALLOCATE PREPARE stmt_drop_table; SET out_exists = (SELECT TABLE_TYPE FROM information_schema.TABLES WHERE TABLE_SCHEMA = in_db AND TABLE_NAME = in_table); END IF; ELSE SET @sys.tmp.table_exists.SQL = CONCAT(\'SELECT COUNT(*) FROM `\', in_db, \'`.`\', in_table, \'`\'); PREPARE stmt_select FROM @sys.tmp.table_exists.SQL; IF (NOT v_error) THEN DEALLOCATE PREPARE stmt_select; SET out_exists = \'TEMPORARY\'; END IF; END IF; END','mysql.sys@localhost','2017-03-02 18:46:53','2017-03-02 18:46:53','','\n Description\n \n Tests whether the table specified in in_db and in_table exists either as a regular\n table, or as a temporary table. The returned value corresponds to the table that\n will be used, so if there\'s both a temporary and a permanent table with the given\n name, then \'TEMPORARY\' will be returned.\n \n Parameters\n \n in_db (VARCHAR(64)):\n The database name to check for the existance of the table in.\n \n in_table (VARCHAR(64)):\n The name of the table to check the existance of.\n \n out_exists ENUM(\'\', \'BASE TABLE\', \'VIEW\', \'TEMPORARY\'):\n The return value: whether the table exists. The value is one of:\n * \'\'           - the table does not exist neither as a base table, view, nor temporary table.\n * \'BASE TABLE\' - the table name exists as a permanent base table table.\n * \'VIEW\'       - the table name exists as a view.\n * \'TEMPORARY\'  - the table name exists as a temporary table.\n \n Example\n \n mysql> CREATE DATABASE db1;\n Query OK, 1 row affected (0.07 sec)\n \n mysql> use db1;\n Database changed\n mysql> CREATE TABLE t1 (id INT PRIMARY KEY);\n Query OK, 0 rows affected (0.08 sec)\n \n mysql> CREATE TABLE t2 (id INT PRIMARY KEY);\n Query OK, 0 rows affected (0.08 sec)\n \n mysql> CREATE view v_t1 AS SELECT * FROM t1;\n Query OK, 0 rows affected (0.00 sec)\n \n mysql> CREATE TEMPORARY TABLE t1 (id INT PRIMARY KEY);\n Query OK, 0 rows affected (0.00 sec)\n \n mysql> CALL sys.table_exists(\'db1\', \'t1\', @exists); SELECT @exists;\n Query OK, 0 rows affected (0.00 sec)\n \n +------------+\n | @exists    |\n +------------+\n | TEMPORARY  |\n +------------+\n 1 row in set (0.00 sec)\n \n mysql> CALL sys.table_exists(\'db1\', \'t2\', @exists); SELECT @exists;\n Query OK, 0 rows affected (0.00 sec)\n \n +------------+\n | @exists    |\n +------------+\n | BASE TABLE |\n +------------+\n 1 row in set (0.01 sec)\n \n mysql> CALL sys.table_exists(\'db1\', \'v_t1\', @exists); SELECT @exists;\n Query OK, 0 rows affected (0.00 sec)\n \n +---------+\n | @exists |\n +---------+\n | VIEW    |\n +---------+\n 1 row in set (0.00 sec)\n \n mysql> CALL sys.table_exists(\'db1\', \'t3\', @exists); SELECT @exists;\n Query OK, 0 rows affected (0.01 sec)\n \n +---------+\n | @exists |\n +---------+\n |         |\n +---------+\n 1 row in set (0.00 sec)\n ','utf8','utf8_general_ci','utf8_general_ci',_binary 'BEGIN DECLARE v_error BOOLEAN DEFAULT FALSE; DECLARE CONTINUE HANDLER FOR 1050 SET v_error = TRUE; DECLARE CONTINUE HANDLER FOR 1146 SET v_error = TRUE;  SET out_exists = \'\';  IF (EXISTS(SELECT 1 FROM information_schema.TABLES WHERE TABLE_SCHEMA = in_db AND TABLE_NAME = in_table)) THEN SET @sys.tmp.table_exists.SQL = CONCAT(\'CREATE TEMPORARY TABLE `\', in_db, \'`.`\', in_table, \'` (id INT PRIMARY KEY)\'); PREPARE stmt_create_table FROM @sys.tmp.table_exists.SQL; EXECUTE stmt_create_table; DEALLOCATE PREPARE stmt_create_table; IF (v_error) THEN SET out_exists = \'TEMPORARY\'; ELSE SET @sys.tmp.table_exists.SQL = CONCAT(\'DROP TEMPORARY TABLE `\', in_db, \'`.`\', in_table, \'`\'); PREPARE stmt_drop_table FROM @sys.tmp.table_exists.SQL; EXECUTE stmt_drop_table; DEALLOCATE PREPARE stmt_drop_table; SET out_exists = (SELECT TABLE_TYPE FROM information_schema.TABLES WHERE TABLE_SCHEMA = in_db AND TABLE_NAME = in_table); END IF; ELSE SET @sys.tmp.table_exists.SQL = CONCAT(\'SELECT COUNT(*) FROM `\', in_db, \'`.`\', in_table, \'`\'); PREPARE stmt_select FROM @sys.tmp.table_exists.SQL; IF (NOT v_error) THEN DEALLOCATE PREPARE stmt_select; SET out_exists = \'TEMPORARY\'; END IF; END IF; END');
/*!40000 ALTER TABLE `proc` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `procs_priv`
--

DROP TABLE IF EXISTS `procs_priv`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `procs_priv` (
  `Host` char(60) COLLATE utf8_bin NOT NULL DEFAULT '',
  `Db` char(64) COLLATE utf8_bin NOT NULL DEFAULT '',
  `User` char(32) COLLATE utf8_bin NOT NULL DEFAULT '',
  `Routine_name` char(64) CHARACTER SET utf8 NOT NULL DEFAULT '',
  `Routine_type` enum('FUNCTION','PROCEDURE') COLLATE utf8_bin NOT NULL,
  `Grantor` char(93) COLLATE utf8_bin NOT NULL DEFAULT '',
  `Proc_priv` set('Execute','Alter Routine','Grant') CHARACTER SET utf8 NOT NULL DEFAULT '',
  `Timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`Host`,`Db`,`User`,`Routine_name`,`Routine_type`),
  KEY `Grantor` (`Grantor`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='Procedure privileges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `procs_priv`
--

LOCK TABLES `procs_priv` WRITE;
/*!40000 ALTER TABLE `procs_priv` DISABLE KEYS */;
/*!40000 ALTER TABLE `procs_priv` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `proxies_priv`
--

DROP TABLE IF EXISTS `proxies_priv`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `proxies_priv` (
  `Host` char(60) COLLATE utf8_bin NOT NULL DEFAULT '',
  `User` char(32) COLLATE utf8_bin NOT NULL DEFAULT '',
  `Proxied_host` char(60) COLLATE utf8_bin NOT NULL DEFAULT '',
  `Proxied_user` char(32) COLLATE utf8_bin NOT NULL DEFAULT '',
  `With_grant` tinyint(1) NOT NULL DEFAULT '0',
  `Grantor` char(93) COLLATE utf8_bin NOT NULL DEFAULT '',
  `Timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`Host`,`User`,`Proxied_host`,`Proxied_user`),
  KEY `Grantor` (`Grantor`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='User proxy privileges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `proxies_priv`
--

LOCK TABLES `proxies_priv` WRITE;
/*!40000 ALTER TABLE `proxies_priv` DISABLE KEYS */;
INSERT INTO `proxies_priv` VALUES ('localhost','root','','',1,'','2016-08-01 18:28:06'),('ppctest-mysql01k','root','','',1,'','2016-08-01 18:28:06');
/*!40000 ALTER TABLE `proxies_priv` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `server_cost`
--

DROP TABLE IF EXISTS `server_cost`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `server_cost` (
  `cost_name` varchar(64) NOT NULL,
  `cost_value` float DEFAULT NULL,
  `last_update` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `comment` varchar(1024) DEFAULT NULL,
  PRIMARY KEY (`cost_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 STATS_PERSISTENT=0;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `server_cost`
--

LOCK TABLES `server_cost` WRITE;
/*!40000 ALTER TABLE `server_cost` DISABLE KEYS */;
INSERT INTO `server_cost` VALUES ('disk_temptable_create_cost',NULL,'2017-03-02 18:45:30',NULL),('disk_temptable_row_cost',NULL,'2017-03-02 18:45:30',NULL),('key_compare_cost',NULL,'2017-03-02 18:45:30',NULL),('memory_temptable_create_cost',NULL,'2017-03-02 18:45:30',NULL),('memory_temptable_row_cost',NULL,'2017-03-02 18:45:30',NULL),('row_evaluate_cost',NULL,'2017-03-02 18:45:30',NULL);
/*!40000 ALTER TABLE `server_cost` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `servers`
--

DROP TABLE IF EXISTS `servers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `servers` (
  `Server_name` char(64) NOT NULL DEFAULT '',
  `Host` char(64) NOT NULL DEFAULT '',
  `Db` char(64) NOT NULL DEFAULT '',
  `Username` char(64) NOT NULL DEFAULT '',
  `Password` char(64) NOT NULL DEFAULT '',
  `Port` int(4) NOT NULL DEFAULT '0',
  `Socket` char(64) NOT NULL DEFAULT '',
  `Wrapper` char(64) NOT NULL DEFAULT '',
  `Owner` char(64) NOT NULL DEFAULT '',
  PRIMARY KEY (`Server_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 STATS_PERSISTENT=0 COMMENT='MySQL Foreign Servers table';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `servers`
--

LOCK TABLES `servers` WRITE;
/*!40000 ALTER TABLE `servers` DISABLE KEYS */;
/*!40000 ALTER TABLE `servers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `slave_master_info`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `slave_master_info` (
  `Number_of_lines` int(10) unsigned NOT NULL COMMENT 'Number of lines in the file.',
  `Master_log_name` text CHARACTER SET utf8 COLLATE utf8_bin NOT NULL COMMENT 'The name of the master binary log currently being read from the master.',
  `Master_log_pos` bigint(20) unsigned NOT NULL COMMENT 'The master log position of the last read event.',
  `Host` char(64) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '' COMMENT 'The host name of the master.',
  `User_name` text CHARACTER SET utf8 COLLATE utf8_bin COMMENT 'The user name used to connect to the master.',
  `User_password` text CHARACTER SET utf8 COLLATE utf8_bin COMMENT 'The password used to connect to the master.',
  `Port` int(10) unsigned NOT NULL COMMENT 'The network port used to connect to the master.',
  `Connect_retry` int(10) unsigned NOT NULL COMMENT 'The period (in seconds) that the slave will wait before trying to reconnect to the master.',
  `Enabled_ssl` tinyint(1) NOT NULL COMMENT 'Indicates whether the server supports SSL connections.',
  `Ssl_ca` text CHARACTER SET utf8 COLLATE utf8_bin COMMENT 'The file used for the Certificate Authority (CA) certificate.',
  `Ssl_capath` text CHARACTER SET utf8 COLLATE utf8_bin COMMENT 'The path to the Certificate Authority (CA) certificates.',
  `Ssl_cert` text CHARACTER SET utf8 COLLATE utf8_bin COMMENT 'The name of the SSL certificate file.',
  `Ssl_cipher` text CHARACTER SET utf8 COLLATE utf8_bin COMMENT 'The name of the cipher in use for the SSL connection.',
  `Ssl_key` text CHARACTER SET utf8 COLLATE utf8_bin COMMENT 'The name of the SSL key file.',
  `Ssl_verify_server_cert` tinyint(1) NOT NULL COMMENT 'Whether to verify the server certificate.',
  `Heartbeat` float NOT NULL,
  `Bind` text CHARACTER SET utf8 COLLATE utf8_bin COMMENT 'Displays which interface is employed when connecting to the MySQL server',
  `Ignored_server_ids` text CHARACTER SET utf8 COLLATE utf8_bin COMMENT 'The number of server IDs to be ignored, followed by the actual server IDs',
  `Uuid` text CHARACTER SET utf8 COLLATE utf8_bin COMMENT 'The master server uuid.',
  `Retry_count` bigint(20) unsigned NOT NULL COMMENT 'Number of reconnect attempts, to the master, before giving up.',
  `Ssl_crl` text CHARACTER SET utf8 COLLATE utf8_bin COMMENT 'The file used for the Certificate Revocation List (CRL)',
  `Ssl_crlpath` text CHARACTER SET utf8 COLLATE utf8_bin COMMENT 'The path used for Certificate Revocation List (CRL) files',
  `Enabled_auto_position` tinyint(1) NOT NULL COMMENT 'Indicates whether GTIDs will be used to retrieve events from the master.',
  `Channel_name` char(64) NOT NULL DEFAULT '' COMMENT 'The channel on which the slave is connected to a source. Used in Multisource Replication',
  `Tls_version` text CHARACTER SET utf8 COLLATE utf8_bin COMMENT 'Tls version',
  PRIMARY KEY (`Channel_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 STATS_PERSISTENT=0 COMMENT='Master Information';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `slave_relay_log_info`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `slave_relay_log_info` (
  `Number_of_lines` int(10) unsigned NOT NULL COMMENT 'Number of lines in the file or rows in the table. Used to version table definitions.',
  `Relay_log_name` text CHARACTER SET utf8 COLLATE utf8_bin NOT NULL COMMENT 'The name of the current relay log file.',
  `Relay_log_pos` bigint(20) unsigned NOT NULL COMMENT 'The relay log position of the last executed event.',
  `Master_log_name` text CHARACTER SET utf8 COLLATE utf8_bin NOT NULL COMMENT 'The name of the master binary log file from which the events in the relay log file were read.',
  `Master_log_pos` bigint(20) unsigned NOT NULL COMMENT 'The master log position of the last executed event.',
  `Sql_delay` int(11) NOT NULL COMMENT 'The number of seconds that the slave must lag behind the master.',
  `Number_of_workers` int(10) unsigned NOT NULL,
  `Id` int(10) unsigned NOT NULL COMMENT 'Internal Id that uniquely identifies this record.',
  `Channel_name` char(64) NOT NULL DEFAULT '' COMMENT 'The channel on which the slave is connected to a source. Used in Multisource Replication',
  PRIMARY KEY (`Channel_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 STATS_PERSISTENT=0 COMMENT='Relay Log Information';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `slave_worker_info`
--

DROP TABLE IF EXISTS `slave_worker_info`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `slave_worker_info` (
  `Id` int(10) unsigned NOT NULL,
  `Relay_log_name` text CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `Relay_log_pos` bigint(20) unsigned NOT NULL,
  `Master_log_name` text CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `Master_log_pos` bigint(20) unsigned NOT NULL,
  `Checkpoint_relay_log_name` text CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `Checkpoint_relay_log_pos` bigint(20) unsigned NOT NULL,
  `Checkpoint_master_log_name` text CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `Checkpoint_master_log_pos` bigint(20) unsigned NOT NULL,
  `Checkpoint_seqno` int(10) unsigned NOT NULL,
  `Checkpoint_group_size` int(10) unsigned NOT NULL,
  `Checkpoint_group_bitmap` blob NOT NULL,
  `Channel_name` char(64) NOT NULL DEFAULT '' COMMENT 'The channel on which the slave is connected to a source. Used in Multisource Replication',
  PRIMARY KEY (`Channel_name`,`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 STATS_PERSISTENT=0 COMMENT='Worker Information';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `slave_worker_info`
--

LOCK TABLES `slave_worker_info` WRITE;
/*!40000 ALTER TABLE `slave_worker_info` DISABLE KEYS */;
/*!40000 ALTER TABLE `slave_worker_info` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tables_priv`
--

DROP TABLE IF EXISTS `tables_priv`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tables_priv` (
  `Host` char(60) COLLATE utf8_bin NOT NULL DEFAULT '',
  `Db` char(64) COLLATE utf8_bin NOT NULL DEFAULT '',
  `User` char(32) COLLATE utf8_bin NOT NULL DEFAULT '',
  `Table_name` char(64) COLLATE utf8_bin NOT NULL DEFAULT '',
  `Grantor` char(93) COLLATE utf8_bin NOT NULL DEFAULT '',
  `Timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `Table_priv` set('Select','Insert','Update','Delete','Create','Drop','Grant','References','Index','Alter','Create View','Show view','Trigger') CHARACTER SET utf8 NOT NULL DEFAULT '',
  `Column_priv` set('Select','Insert','Update','References') CHARACTER SET utf8 NOT NULL DEFAULT '',
  PRIMARY KEY (`Host`,`Db`,`User`,`Table_name`),
  KEY `Grantor` (`Grantor`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='Table privileges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tables_priv`
--

LOCK TABLES `tables_priv` WRITE;
/*!40000 ALTER TABLE `tables_priv` DISABLE KEYS */;
INSERT INTO `tables_priv` VALUES ('localhost','sys','mysql.sys','sys_config','root@localhost','2017-03-02 18:46:25','Select','');
/*!40000 ALTER TABLE `tables_priv` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `time_zone`
--

DROP TABLE IF EXISTS `time_zone`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `time_zone` (
  `Time_zone_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `Use_leap_seconds` enum('Y','N') NOT NULL DEFAULT 'N',
  PRIMARY KEY (`Time_zone_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 STATS_PERSISTENT=0 COMMENT='Time zones';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `time_zone`
--

LOCK TABLES `time_zone` WRITE;
/*!40000 ALTER TABLE `time_zone` DISABLE KEYS */;
/*!40000 ALTER TABLE `time_zone` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `time_zone_leap_second`
--

DROP TABLE IF EXISTS `time_zone_leap_second`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `time_zone_leap_second` (
  `Transition_time` bigint(20) NOT NULL,
  `Correction` int(11) NOT NULL,
  PRIMARY KEY (`Transition_time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 STATS_PERSISTENT=0 COMMENT='Leap seconds information for time zones';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `time_zone_leap_second`
--

LOCK TABLES `time_zone_leap_second` WRITE;
/*!40000 ALTER TABLE `time_zone_leap_second` DISABLE KEYS */;
/*!40000 ALTER TABLE `time_zone_leap_second` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `time_zone_name`
--

DROP TABLE IF EXISTS `time_zone_name`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `time_zone_name` (
  `Name` char(64) NOT NULL,
  `Time_zone_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`Name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 STATS_PERSISTENT=0 COMMENT='Time zone names';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `time_zone_name`
--

LOCK TABLES `time_zone_name` WRITE;
/*!40000 ALTER TABLE `time_zone_name` DISABLE KEYS */;
/*!40000 ALTER TABLE `time_zone_name` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `time_zone_transition`
--

DROP TABLE IF EXISTS `time_zone_transition`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `time_zone_transition` (
  `Time_zone_id` int(10) unsigned NOT NULL,
  `Transition_time` bigint(20) NOT NULL,
  `Transition_type_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`Time_zone_id`,`Transition_time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 STATS_PERSISTENT=0 COMMENT='Time zone transitions';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `time_zone_transition`
--

LOCK TABLES `time_zone_transition` WRITE;
/*!40000 ALTER TABLE `time_zone_transition` DISABLE KEYS */;
/*!40000 ALTER TABLE `time_zone_transition` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `time_zone_transition_type`
--

DROP TABLE IF EXISTS `time_zone_transition_type`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `time_zone_transition_type` (
  `Time_zone_id` int(10) unsigned NOT NULL,
  `Transition_type_id` int(10) unsigned NOT NULL,
  `Offset` int(11) NOT NULL DEFAULT '0',
  `Is_DST` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `Abbreviation` char(8) NOT NULL DEFAULT '',
  PRIMARY KEY (`Time_zone_id`,`Transition_type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 STATS_PERSISTENT=0 COMMENT='Time zone transition types';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `time_zone_transition_type`
--

LOCK TABLES `time_zone_transition_type` WRITE;
/*!40000 ALTER TABLE `time_zone_transition_type` DISABLE KEYS */;
/*!40000 ALTER TABLE `time_zone_transition_type` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user`
--

DROP TABLE IF EXISTS `user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user` (
  `Host` char(60) COLLATE utf8_bin NOT NULL DEFAULT '',
  `User` char(32) COLLATE utf8_bin NOT NULL DEFAULT '',
  `Select_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `Insert_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `Update_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `Delete_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `Create_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `Drop_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `Reload_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `Shutdown_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `Process_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `File_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `Grant_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `References_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `Index_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `Alter_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `Show_db_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `Super_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `Create_tmp_table_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `Lock_tables_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `Execute_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `Repl_slave_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `Repl_client_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `Create_view_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `Show_view_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `Create_routine_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `Alter_routine_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `Create_user_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `Event_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `Trigger_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `Create_tablespace_priv` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `ssl_type` enum('','ANY','X509','SPECIFIED') CHARACTER SET utf8 NOT NULL DEFAULT '',
  `ssl_cipher` blob NOT NULL,
  `x509_issuer` blob NOT NULL,
  `x509_subject` blob NOT NULL,
  `max_questions` int(11) unsigned NOT NULL DEFAULT '0',
  `max_updates` int(11) unsigned NOT NULL DEFAULT '0',
  `max_connections` int(11) unsigned NOT NULL DEFAULT '0',
  `max_user_connections` int(11) unsigned NOT NULL DEFAULT '0',
  `plugin` char(64) COLLATE utf8_bin NOT NULL DEFAULT 'mysql_native_password',
  `authentication_string` text COLLATE utf8_bin,
  `password_expired` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  `password_last_changed` timestamp NULL DEFAULT NULL,
  `password_lifetime` smallint(5) unsigned DEFAULT NULL,
  `account_locked` enum('N','Y') CHARACTER SET utf8 NOT NULL DEFAULT 'N',
  PRIMARY KEY (`Host`,`User`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='Users and global privileges';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user`
--

LOCK TABLES `user` WRITE;
/*!40000 ALTER TABLE `user` DISABLE KEYS */;
INSERT INTO `user` VALUES ('localhost','root','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','','','','',0,0,0,0,'mysql_native_password','','N','2017-03-02 18:46:10',NULL,'N'),('ppctest-mysql01k','root','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','','','','',0,0,0,0,'mysql_native_password','','N','2017-03-02 18:46:10',NULL,'N'),('127.0.0.1','root','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','','','','',0,0,0,0,'mysql_native_password','','N','2017-03-02 18:46:10',NULL,'N'),('::1','root','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','','','','',0,0,0,0,'mysql_native_password','','N','2017-03-02 18:46:10',NULL,'N'),('localhost','','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','','','','',0,0,0,0,'mysql_native_password',NULL,'N','2017-03-02 18:46:10',NULL,'N'),('ppctest-mysql01k','','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','','','','',0,0,0,0,'mysql_native_password',NULL,'N','2017-03-02 18:46:10',NULL,'N'),('5.255.228.69','autotester','Y','Y','Y','Y','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','','','','',0,0,0,0,'mysql_native_password','*F9A8E96790775D196D12F53BCC88B8048FF62ED5','N','2018-04-05 16:45:59',NULL,'N'),('2a02:6b8:0:1a78:d024:8501:432a:d6c8','autotester','Y','Y','Y','Y','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','','','','',0,0,0,0,'mysql_native_password','*F9A8E96790775D196D12F53BCC88B8048FF62ED5','N','2018-04-05 16:45:59',NULL,'N'),('87.250.243.49','autotester','Y','Y','Y','Y','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','','','','',0,0,0,0,'mysql_native_password','*F9A8E96790775D196D12F53BCC88B8048FF62ED5','N','2018-04-05 16:45:59',NULL,'N'),('2a02:6b8:0:144d:e330:c2df:61ee:2743','autotester','Y','Y','Y','Y','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','','','','',0,0,0,0,'mysql_native_password','*F9A8E96790775D196D12F53BCC88B8048FF62ED5','N','2018-04-05 16:45:59',NULL,'N'),('87.250.243.61','autotester','Y','Y','Y','Y','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','','','','',0,0,0,0,'mysql_native_password','*F9A8E96790775D196D12F53BCC88B8048FF62ED5','N','2018-04-05 16:45:59',NULL,'N'),('2a02:6b8:0:144d:bf4a:579d:b651:fcdf','autotester','Y','Y','Y','Y','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','','','','',0,0,0,0,'mysql_native_password','*F9A8E96790775D196D12F53BCC88B8048FF62ED5','N','2018-04-05 16:45:59',NULL,'N'),('5.255.228.73','autotester','Y','Y','Y','Y','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','','','','',0,0,0,0,'mysql_native_password','*F9A8E96790775D196D12F53BCC88B8048FF62ED5','N','2018-04-05 16:45:59',NULL,'N'),('2a02:6b8:0:1a78:d47f:cb94:832d:9a1','autotester','Y','Y','Y','Y','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','','','','',0,0,0,0,'mysql_native_password','*F9A8E96790775D196D12F53BCC88B8048FF62ED5','N','2018-04-05 16:45:59',NULL,'N'),('5.255.228.76','autotester','Y','Y','Y','Y','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','','','','',0,0,0,0,'mysql_native_password','*F9A8E96790775D196D12F53BCC88B8048FF62ED5','N','2018-04-05 16:46:00',NULL,'N'),('2a02:6b8:0:1a78:b395:6c6c:3c36:762','autotester','Y','Y','Y','Y','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','','','','',0,0,0,0,'mysql_native_password','*F9A8E96790775D196D12F53BCC88B8048FF62ED5','N','2018-04-05 16:46:00',NULL,'N'),('87.250.243.51','autotester','Y','Y','Y','Y','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','','','','',0,0,0,0,'mysql_native_password','*F9A8E96790775D196D12F53BCC88B8048FF62ED5','N','2018-04-05 16:46:00',NULL,'N'),('2a02:6b8:0:144d:e330:c2df:61ee:2744','autotester','Y','Y','Y','Y','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','','','','',0,0,0,0,'mysql_native_password','*F9A8E96790775D196D12F53BCC88B8048FF62ED5','N','2018-04-05 16:46:00',NULL,'N'),('141.8.173.72','autotester','Y','Y','Y','Y','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','','','','',0,0,0,0,'mysql_native_password','*F9A8E96790775D196D12F53BCC88B8048FF62ED5','N','2018-04-05 16:46:00',NULL,'N'),('2a02:6b8:0:1604:5a03:bb94:86b2:4392','autotester','Y','Y','Y','Y','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','','','','',0,0,0,0,'mysql_native_password','*F9A8E96790775D196D12F53BCC88B8048FF62ED5','N','2018-04-05 16:46:00',NULL,'N'),('37.140.140.195','autotester','Y','Y','Y','Y','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','','','','',0,0,0,0,'mysql_native_password','*F9A8E96790775D196D12F53BCC88B8048FF62ED5','N','2018-04-05 16:46:00',NULL,'N'),('2a02:6b8:0:2504:97cb:a52f:2832:415e','autotester','Y','Y','Y','Y','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','','','','',0,0,0,0,'mysql_native_password','*F9A8E96790775D196D12F53BCC88B8048FF62ED5','N','2018-04-05 16:46:00',NULL,'N'),('178.154.224.135','autotester','Y','Y','Y','Y','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','','','','',0,0,0,0,'mysql_native_password','*F9A8E96790775D196D12F53BCC88B8048FF62ED5','N','2018-04-05 16:46:00',NULL,'N'),('2a02:6b8:0:1448:e96c:b176:340b:ff26','autotester','Y','Y','Y','Y','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','','','','',0,0,0,0,'mysql_native_password','*F9A8E96790775D196D12F53BCC88B8048FF62ED5','N','2018-04-05 16:46:00',NULL,'N'),('5.45.244.35','autotester','Y','Y','Y','Y','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','','','','',0,0,0,0,'mysql_native_password','*F9A8E96790775D196D12F53BCC88B8048FF62ED5','N','2018-04-05 16:46:00',NULL,'N'),('2a02:6b8:0:2537:f1de:ae5a:230a:9af5','autotester','Y','Y','Y','Y','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','','','','',0,0,0,0,'mysql_native_password','*F9A8E96790775D196D12F53BCC88B8048FF62ED5','N','2018-04-05 16:46:00',NULL,'N'),('2a02:6b8:0:2537:e137:d5aa:c3a5:583d','autotester','Y','Y','Y','Y','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','','','','',0,0,0,0,'mysql_native_password','*F9A8E96790775D196D12F53BCC88B8048FF62ED5','N','2018-04-05 16:46:00',NULL,'N'),('77.88.4.162','autotester','Y','Y','Y','Y','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','','','','',0,0,0,0,'mysql_native_password','*F9A8E96790775D196D12F53BCC88B8048FF62ED5','N','2018-04-05 16:46:00',NULL,'N'),('2a02:6b8:0:2307:58ca:9bde:b5a2:9ca0','autotester','Y','Y','Y','Y','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','','','','',0,0,0,0,'mysql_native_password','*F9A8E96790775D196D12F53BCC88B8048FF62ED5','N','2018-04-05 16:46:00',NULL,'N'),('37.140.140.196','autotester','Y','Y','Y','Y','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','','','','',0,0,0,0,'mysql_native_password','*F9A8E96790775D196D12F53BCC88B8048FF62ED5','N','2018-04-05 16:46:00',NULL,'N'),('2a02:6b8:0:2504:3eb:917:b677:102d','autotester','Y','Y','Y','Y','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','','','','',0,0,0,0,'mysql_native_password','*F9A8E96790775D196D12F53BCC88B8048FF62ED5','N','2018-04-05 16:46:00',NULL,'N'),('5.255.228.84','autotester','Y','Y','Y','Y','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','','','','',0,0,0,0,'mysql_native_password','*F9A8E96790775D196D12F53BCC88B8048FF62ED5','N','2018-04-05 16:46:00',NULL,'N'),('2a02:6b8:0:1a78:236e:a31c:8ffe:5e3e','autotester','Y','Y','Y','Y','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','','','','',0,0,0,0,'mysql_native_password','*F9A8E96790775D196D12F53BCC88B8048FF62ED5','N','2018-04-05 16:46:00',NULL,'N'),('37.140.140.169','adiuser','Y','Y','Y','Y','Y','Y','N','N','N','N','N','Y','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','N','N','Y','N','','','','',0,0,0,0,'mysql_native_password','*61B8CBFAC6E1397C405D8AB745E3262EF58BE8EE','N','2018-04-05 16:46:00',NULL,'N'),('2a02:6b8:0:2504:b84d:5b54:9114:daf6','adiuser','Y','Y','Y','Y','Y','Y','N','N','N','N','N','Y','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','N','N','Y','N','','','','',0,0,0,0,'mysql_native_password','*61B8CBFAC6E1397C405D8AB745E3262EF58BE8EE','N','2018-04-05 16:46:00',NULL,'N'),('5.255.228.74','adiuser','Y','Y','Y','Y','Y','Y','N','N','N','N','N','Y','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','N','N','Y','N','','','','',0,0,0,0,'mysql_native_password','*61B8CBFAC6E1397C405D8AB745E3262EF58BE8EE','N','2018-04-05 16:46:00',NULL,'N'),('2a02:6b8:0:1a78:d476:7c80:ceab:669b','adiuser','Y','Y','Y','Y','Y','Y','N','N','N','N','N','Y','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','N','N','Y','N','','','','',0,0,0,0,'mysql_native_password','*61B8CBFAC6E1397C405D8AB745E3262EF58BE8EE','N','2018-04-05 16:46:00',NULL,'N'),('37.140.140.176','adiuser','Y','Y','Y','Y','Y','Y','N','N','N','N','N','Y','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','N','N','Y','N','','','','',0,0,0,0,'mysql_native_password','*61B8CBFAC6E1397C405D8AB745E3262EF58BE8EE','N','2018-04-05 16:46:00',NULL,'N'),('2a02:6b8:0:2504:bfb8:b5e1:943c:93ec','adiuser','Y','Y','Y','Y','Y','Y','N','N','N','N','N','Y','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','N','N','Y','N','','','','',0,0,0,0,'mysql_native_password','*61B8CBFAC6E1397C405D8AB745E3262EF58BE8EE','N','2018-04-05 16:46:00',NULL,'N'),('5.45.244.34','adiuser','Y','Y','Y','Y','Y','Y','N','N','N','N','N','Y','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','N','N','Y','N','','','','',0,0,0,0,'mysql_native_password','*61B8CBFAC6E1397C405D8AB745E3262EF58BE8EE','N','2018-04-05 16:46:01',NULL,'N'),('2a02:6b8:0:2537:e3e2:da0:5e53:4218','adiuser','Y','Y','Y','Y','Y','Y','N','N','N','N','N','Y','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','N','N','Y','N','','','','',0,0,0,0,'mysql_native_password','*61B8CBFAC6E1397C405D8AB745E3262EF58BE8EE','N','2018-04-05 16:46:01',NULL,'N'),('178.154.224.212','adiuser','Y','Y','Y','Y','Y','Y','N','N','N','N','N','Y','Y','Y','Y','Y','Y','Y','N','N','Y','Y','Y','Y','Y','N','N','Y','N','','','','',0,0,0,0,'mysql_native_password','*61B8CBFAC6E1397C405D8AB745E3262EF58BE8EE','N','2017-03-02 18:46:10',NULL,'N'),('2a02:6b8:0:1448:a5a0:3d20:3be1:5937','adiuser','Y','Y','Y','Y','Y','Y','N','N','N','N','N','Y','Y','Y','Y','Y','Y','Y','N','N','Y','Y','Y','Y','Y','N','N','Y','N','','','','',0,0,0,0,'mysql_native_password','*61B8CBFAC6E1397C405D8AB745E3262EF58BE8EE','N','2017-03-02 18:46:10',NULL,'N'),('5.255.228.69','adiuser','Y','Y','Y','Y','Y','Y','N','N','N','N','N','Y','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','N','N','Y','N','','','','',0,0,0,0,'mysql_native_password','*61B8CBFAC6E1397C405D8AB745E3262EF58BE8EE','N','2018-04-05 16:46:01',NULL,'N'),('2a02:6b8:0:1a78:d024:8501:432a:d6c8','adiuser','Y','Y','Y','Y','Y','Y','N','N','N','N','N','Y','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','N','N','Y','N','','','','',0,0,0,0,'mysql_native_password','*61B8CBFAC6E1397C405D8AB745E3262EF58BE8EE','N','2018-04-05 16:46:01',NULL,'N'),('87.250.243.49','adiuser','Y','Y','Y','Y','Y','Y','N','N','N','N','N','Y','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','N','N','Y','N','','','','',0,0,0,0,'mysql_native_password','*61B8CBFAC6E1397C405D8AB745E3262EF58BE8EE','N','2018-04-05 16:46:01',NULL,'N'),('2a02:6b8:0:144d:e330:c2df:61ee:2743','adiuser','Y','Y','Y','Y','Y','Y','N','N','N','N','N','Y','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','N','N','Y','N','','','','',0,0,0,0,'mysql_native_password','*61B8CBFAC6E1397C405D8AB745E3262EF58BE8EE','N','2018-04-05 16:46:01',NULL,'N'),('87.250.243.61','adiuser','Y','Y','Y','Y','Y','Y','N','N','N','N','N','Y','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','N','N','Y','N','','','','',0,0,0,0,'mysql_native_password','*61B8CBFAC6E1397C405D8AB745E3262EF58BE8EE','N','2018-04-05 16:46:01',NULL,'N'),('2a02:6b8:0:144d:bf4a:579d:b651:fcdf','adiuser','Y','Y','Y','Y','Y','Y','N','N','N','N','N','Y','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','N','N','Y','N','','','','',0,0,0,0,'mysql_native_password','*61B8CBFAC6E1397C405D8AB745E3262EF58BE8EE','N','2018-04-05 16:46:01',NULL,'N'),('5.255.228.73','adiuser','Y','Y','Y','Y','Y','Y','N','N','N','N','N','Y','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','N','N','Y','N','','','','',0,0,0,0,'mysql_native_password','*61B8CBFAC6E1397C405D8AB745E3262EF58BE8EE','N','2018-04-05 16:46:01',NULL,'N'),('2a02:6b8:0:1a78:d47f:cb94:832d:9a1','adiuser','Y','Y','Y','Y','Y','Y','N','N','N','N','N','Y','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','N','N','Y','N','','','','',0,0,0,0,'mysql_native_password','*61B8CBFAC6E1397C405D8AB745E3262EF58BE8EE','N','2018-04-05 16:46:01',NULL,'N'),('5.255.228.76','adiuser','Y','Y','Y','Y','Y','Y','N','N','N','N','N','Y','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','N','N','Y','N','','','','',0,0,0,0,'mysql_native_password','*61B8CBFAC6E1397C405D8AB745E3262EF58BE8EE','N','2018-04-05 16:46:01',NULL,'N'),('2a02:6b8:0:1a78:b395:6c6c:3c36:762','adiuser','Y','Y','Y','Y','Y','Y','N','N','N','N','N','Y','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','N','N','Y','N','','','','',0,0,0,0,'mysql_native_password','*61B8CBFAC6E1397C405D8AB745E3262EF58BE8EE','N','2018-04-05 16:46:02',NULL,'N'),('87.250.243.51','adiuser','Y','Y','Y','Y','Y','Y','N','N','N','N','N','Y','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','N','N','Y','N','','','','',0,0,0,0,'mysql_native_password','*61B8CBFAC6E1397C405D8AB745E3262EF58BE8EE','N','2018-04-05 16:46:02',NULL,'N'),('2a02:6b8:0:144d:e330:c2df:61ee:2744','adiuser','Y','Y','Y','Y','Y','Y','N','N','N','N','N','Y','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','N','N','Y','N','','','','',0,0,0,0,'mysql_native_password','*61B8CBFAC6E1397C405D8AB745E3262EF58BE8EE','N','2018-04-05 16:46:02',NULL,'N'),('141.8.173.72','adiuser','Y','Y','Y','Y','Y','Y','N','N','N','N','N','Y','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','N','N','Y','N','','','','',0,0,0,0,'mysql_native_password','*61B8CBFAC6E1397C405D8AB745E3262EF58BE8EE','N','2018-04-05 16:46:02',NULL,'N'),('2a02:6b8:0:1604:5a03:bb94:86b2:4392','adiuser','Y','Y','Y','Y','Y','Y','N','N','N','N','N','Y','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','N','N','Y','N','','','','',0,0,0,0,'mysql_native_password','*61B8CBFAC6E1397C405D8AB745E3262EF58BE8EE','N','2018-04-05 16:46:02',NULL,'N'),('37.140.140.195','adiuser','Y','Y','Y','Y','Y','Y','N','N','N','N','N','Y','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','N','N','Y','N','','','','',0,0,0,0,'mysql_native_password','*61B8CBFAC6E1397C405D8AB745E3262EF58BE8EE','N','2018-04-05 16:46:02',NULL,'N'),('2a02:6b8:0:2504:97cb:a52f:2832:415e','adiuser','Y','Y','Y','Y','Y','Y','N','N','N','N','N','Y','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','N','N','Y','N','','','','',0,0,0,0,'mysql_native_password','*61B8CBFAC6E1397C405D8AB745E3262EF58BE8EE','N','2018-04-05 16:46:02',NULL,'N'),('178.154.224.135','adiuser','Y','Y','Y','Y','Y','Y','N','N','N','N','N','Y','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','N','N','Y','N','','','','',0,0,0,0,'mysql_native_password','*61B8CBFAC6E1397C405D8AB745E3262EF58BE8EE','N','2018-04-05 16:46:02',NULL,'N'),('2a02:6b8:0:1448:e96c:b176:340b:ff26','adiuser','Y','Y','Y','Y','Y','Y','N','N','N','N','N','Y','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','N','N','Y','N','','','','',0,0,0,0,'mysql_native_password','*61B8CBFAC6E1397C405D8AB745E3262EF58BE8EE','N','2018-04-05 16:46:02',NULL,'N'),('5.45.244.35','adiuser','Y','Y','Y','Y','Y','Y','N','N','N','N','N','Y','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','N','N','Y','N','','','','',0,0,0,0,'mysql_native_password','*61B8CBFAC6E1397C405D8AB745E3262EF58BE8EE','N','2018-04-05 16:46:02',NULL,'N'),('2a02:6b8:0:2537:f1de:ae5a:230a:9af5','adiuser','Y','Y','Y','Y','Y','Y','N','N','N','N','N','Y','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','N','N','Y','N','','','','',0,0,0,0,'mysql_native_password','*61B8CBFAC6E1397C405D8AB745E3262EF58BE8EE','N','2018-04-05 16:46:02',NULL,'N'),('2a02:6b8:0:2537:e137:d5aa:c3a5:583d','adiuser','Y','Y','Y','Y','Y','Y','N','N','N','N','N','Y','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','N','N','Y','N','','','','',0,0,0,0,'mysql_native_password','*61B8CBFAC6E1397C405D8AB745E3262EF58BE8EE','N','2018-04-05 16:46:02',NULL,'N'),('37.140.140.169','direct-sql','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','','','','',0,0,0,0,'mysql_native_password','*685AF2845F8E6355AA269D85978B8E7A53E8C1C3','N','2018-04-05 16:46:02',NULL,'N'),('2a02:6b8:0:2504:b84d:5b54:9114:daf6','direct-sql','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','','','','',0,0,0,0,'mysql_native_password','*685AF2845F8E6355AA269D85978B8E7A53E8C1C3','N','2018-04-05 16:46:02',NULL,'N'),('5.255.228.74','direct-sql','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','','','','',0,0,0,0,'mysql_native_password','*685AF2845F8E6355AA269D85978B8E7A53E8C1C3','N','2018-04-05 16:46:02',NULL,'N'),('2a02:6b8:0:1a78:d476:7c80:ceab:669b','direct-sql','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','','','','',0,0,0,0,'mysql_native_password','*685AF2845F8E6355AA269D85978B8E7A53E8C1C3','N','2018-04-05 16:46:03',NULL,'N'),('37.140.140.176','direct-sql','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','','','','',0,0,0,0,'mysql_native_password','*685AF2845F8E6355AA269D85978B8E7A53E8C1C3','N','2018-04-05 16:46:03',NULL,'N'),('2a02:6b8:0:2504:bfb8:b5e1:943c:93ec','direct-sql','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','','','','',0,0,0,0,'mysql_native_password','*685AF2845F8E6355AA269D85978B8E7A53E8C1C3','N','2018-04-05 16:46:03',NULL,'N'),('5.45.244.34','direct-sql','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','','','','',0,0,0,0,'mysql_native_password','*685AF2845F8E6355AA269D85978B8E7A53E8C1C3','N','2018-04-05 16:46:03',NULL,'N'),('2a02:6b8:0:2537:e3e2:da0:5e53:4218','direct-sql','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','','','','',0,0,0,0,'mysql_native_password','*685AF2845F8E6355AA269D85978B8E7A53E8C1C3','N','2018-04-05 16:46:03',NULL,'N'),('178.154.224.212','direct-sql','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','','','','',0,0,0,0,'mysql_native_password','*685AF2845F8E6355AA269D85978B8E7A53E8C1C3','N','2017-03-02 18:46:10',NULL,'N'),('2a02:6b8:0:1448:a5a0:3d20:3be1:5937','direct-sql','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','','','','',0,0,0,0,'mysql_native_password','*685AF2845F8E6355AA269D85978B8E7A53E8C1C3','N','2017-03-02 18:46:10',NULL,'N'),('5.255.228.69','direct-sql','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','','','','',0,0,0,0,'mysql_native_password','*685AF2845F8E6355AA269D85978B8E7A53E8C1C3','N','2018-04-05 16:46:04',NULL,'N'),('2a02:6b8:0:1a78:d024:8501:432a:d6c8','direct-sql','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','','','','',0,0,0,0,'mysql_native_password','*685AF2845F8E6355AA269D85978B8E7A53E8C1C3','N','2018-04-05 16:46:04',NULL,'N'),('87.250.243.49','direct-sql','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','','','','',0,0,0,0,'mysql_native_password','*685AF2845F8E6355AA269D85978B8E7A53E8C1C3','N','2018-04-05 16:46:04',NULL,'N'),('2a02:6b8:0:144d:e330:c2df:61ee:2743','direct-sql','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','','','','',0,0,0,0,'mysql_native_password','*685AF2845F8E6355AA269D85978B8E7A53E8C1C3','N','2018-04-05 16:46:04',NULL,'N'),('87.250.243.61','direct-sql','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','','','','',0,0,0,0,'mysql_native_password','*685AF2845F8E6355AA269D85978B8E7A53E8C1C3','N','2018-04-05 16:46:04',NULL,'N'),('2a02:6b8:0:144d:bf4a:579d:b651:fcdf','direct-sql','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','','','','',0,0,0,0,'mysql_native_password','*685AF2845F8E6355AA269D85978B8E7A53E8C1C3','N','2018-04-05 16:46:04',NULL,'N'),('5.255.228.73','direct-sql','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','','','','',0,0,0,0,'mysql_native_password','*685AF2845F8E6355AA269D85978B8E7A53E8C1C3','N','2018-04-05 16:46:04',NULL,'N'),('2a02:6b8:0:1a78:d47f:cb94:832d:9a1','direct-sql','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','','','','',0,0,0,0,'mysql_native_password','*685AF2845F8E6355AA269D85978B8E7A53E8C1C3','N','2018-04-05 16:46:04',NULL,'N'),('5.255.228.76','direct-sql','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','','','','',0,0,0,0,'mysql_native_password','*685AF2845F8E6355AA269D85978B8E7A53E8C1C3','N','2018-04-05 16:46:04',NULL,'N'),('2a02:6b8:0:1a78:b395:6c6c:3c36:762','direct-sql','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','','','','',0,0,0,0,'mysql_native_password','*685AF2845F8E6355AA269D85978B8E7A53E8C1C3','N','2018-04-05 16:46:04',NULL,'N'),('87.250.243.51','direct-sql','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','','','','',0,0,0,0,'mysql_native_password','*685AF2845F8E6355AA269D85978B8E7A53E8C1C3','N','2018-04-05 16:46:04',NULL,'N'),('2a02:6b8:0:144d:e330:c2df:61ee:2744','direct-sql','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','','','','',0,0,0,0,'mysql_native_password','*685AF2845F8E6355AA269D85978B8E7A53E8C1C3','N','2018-04-05 16:46:04',NULL,'N'),('141.8.173.72','direct-sql','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','','','','',0,0,0,0,'mysql_native_password','*685AF2845F8E6355AA269D85978B8E7A53E8C1C3','N','2018-04-05 16:46:04',NULL,'N'),('2a02:6b8:0:1604:5a03:bb94:86b2:4392','direct-sql','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','','','','',0,0,0,0,'mysql_native_password','*685AF2845F8E6355AA269D85978B8E7A53E8C1C3','N','2018-04-05 16:46:04',NULL,'N'),('37.140.140.195','direct-sql','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','','','','',0,0,0,0,'mysql_native_password','*685AF2845F8E6355AA269D85978B8E7A53E8C1C3','N','2018-04-05 16:46:04',NULL,'N'),('2a02:6b8:0:2504:97cb:a52f:2832:415e','direct-sql','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','','','','',0,0,0,0,'mysql_native_password','*685AF2845F8E6355AA269D85978B8E7A53E8C1C3','N','2018-04-05 16:46:04',NULL,'N'),('178.154.224.135','direct-sql','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','','','','',0,0,0,0,'mysql_native_password','*685AF2845F8E6355AA269D85978B8E7A53E8C1C3','N','2018-04-05 16:46:04',NULL,'N'),('2a02:6b8:0:1448:e96c:b176:340b:ff26','direct-sql','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','','','','',0,0,0,0,'mysql_native_password','*685AF2845F8E6355AA269D85978B8E7A53E8C1C3','N','2018-04-05 16:46:04',NULL,'N'),('5.45.244.35','direct-sql','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','','','','',0,0,0,0,'mysql_native_password','*685AF2845F8E6355AA269D85978B8E7A53E8C1C3','N','2018-04-05 16:46:04',NULL,'N'),('2a02:6b8:0:2537:f1de:ae5a:230a:9af5','direct-sql','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','','','','',0,0,0,0,'mysql_native_password','*685AF2845F8E6355AA269D85978B8E7A53E8C1C3','N','2018-04-05 16:46:04',NULL,'N'),('2a02:6b8:0:2537:e137:d5aa:c3a5:583d','direct-sql','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','','','','',0,0,0,0,'mysql_native_password','*685AF2845F8E6355AA269D85978B8E7A53E8C1C3','N','2018-04-05 16:46:05',NULL,'N'),('77.88.34.51','adiuser','Y','Y','Y','Y','Y','Y','N','N','N','N','N','Y','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','N','N','Y','N','','','','',0,0,0,0,'mysql_native_password','*BEB047C6F77288C14C1A84817187B82F5003531E','N','2018-04-05 16:46:05',NULL,'N'),('%','reader','Y','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','','','','',0,0,0,0,'mysql_native_password','*CA4665A09024322FED25CF45B2E921AA7E6CFF7D','N','2019-04-02 19:17:50',NULL,'N'),('%','adiuser','Y','Y','Y','Y','Y','Y','N','N','N','N','N','Y','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','N','N','Y','N','','','','',0,0,0,0,'mysql_native_password','*61B8CBFAC6E1397C405D8AB745E3262EF58BE8EE','N','2019-04-02 19:17:50',NULL,'N'),('2a02:6b8:b010:3034::19','adiuser','Y','Y','Y','Y','Y','Y','N','N','N','N','N','Y','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','N','N','Y','N','','','','',0,0,0,0,'mysql_native_password','*61B8CBFAC6E1397C405D8AB745E3262EF58BE8EE','N','2018-04-05 16:46:01',NULL,'N'),('2a02:6b8:b010:3034::19','direct-sql','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','','','','',0,0,0,0,'mysql_native_password','*685AF2845F8E6355AA269D85978B8E7A53E8C1C3','N','2018-04-05 16:46:03',NULL,'N'),('37.140.140.171','sales','Y','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','','','','',0,0,0,0,'mysql_native_password','*BEB047C6F77288C14C1A84817187B82F5003531E','N','2018-04-05 16:46:05',NULL,'N'),('178.154.224.183','sales','Y','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','','','','',0,0,0,0,'mysql_native_password','*BEB047C6F77288C14C1A84817187B82F5003531E','N','2018-04-05 16:46:05',NULL,'N'),('localhost','mysql.sys','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','','','','',0,0,0,0,'mysql_native_password','*THISISNOTAVALIDPASSWORDTHATCANBEUSEDHERE','N','2017-03-02 18:46:25',NULL,'Y'),('2a02:6b8:c08:51a8:0:1358:2:8960','adiuser','Y','Y','Y','Y','Y','Y','N','N','N','N','N','Y','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','N','N','Y','N','','','','',0,0,0,0,'mysql_native_password','*61B8CBFAC6E1397C405D8AB745E3262EF58BE8EE','N','2018-04-05 16:46:01',NULL,'N'),('2a02:6b8:c0c:416:0:1358:19:6928','adiuser','Y','Y','Y','Y','Y','Y','N','N','N','N','N','Y','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','N','N','Y','N','','','','',0,0,0,0,'mysql_native_password','*61B8CBFAC6E1397C405D8AB745E3262EF58BE8EE','N','2018-04-05 16:46:01',NULL,'N'),('2a02:6b8:b010:1f::1b2','adiuser','Y','Y','Y','Y','Y','Y','N','N','N','N','N','Y','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','N','N','Y','N','','','','',0,0,0,0,'mysql_native_password','*61B8CBFAC6E1397C405D8AB745E3262EF58BE8EE','N','2018-04-05 16:46:01',NULL,'N'),('2a02:6b8:b010:1f::1b3','adiuser','Y','Y','Y','Y','Y','Y','N','N','N','N','N','Y','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','N','N','Y','N','','','','',0,0,0,0,'mysql_native_password','*61B8CBFAC6E1397C405D8AB745E3262EF58BE8EE','N','2018-04-05 16:46:01',NULL,'N'),('2a02:6b8:c08:51a8:0:1358:2:8960','direct-sql','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','','','','',0,0,0,0,'mysql_native_password','*685AF2845F8E6355AA269D85978B8E7A53E8C1C3','N','2018-04-05 16:46:03',NULL,'N'),('2a02:6b8:c0c:416:0:1358:19:6928','direct-sql','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','','','','',0,0,0,0,'mysql_native_password','*685AF2845F8E6355AA269D85978B8E7A53E8C1C3','N','2018-04-05 16:46:03',NULL,'N'),('2a02:6b8:b010:1f::1b2','direct-sql','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','','','','',0,0,0,0,'mysql_native_password','*685AF2845F8E6355AA269D85978B8E7A53E8C1C3','N','2018-04-05 16:46:03',NULL,'N'),('2a02:6b8:b010:1f::1b3','direct-sql','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','','','','',0,0,0,0,'mysql_native_password','*685AF2845F8E6355AA269D85978B8E7A53E8C1C3','N','2018-04-05 16:46:03',NULL,'N'),('2a02:6b8:c0b:2698:0:1358:13:6528','adiuser','Y','Y','Y','Y','Y','Y','N','N','N','N','N','Y','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','N','N','Y','N','','','','',0,0,0,0,'mysql_native_password','*61B8CBFAC6E1397C405D8AB745E3262EF58BE8EE','N','2018-04-05 16:46:01',NULL,'N'),('2a02:6b8:c08:2504:0:1358:13:6032','adiuser','Y','Y','Y','Y','Y','Y','N','N','N','N','N','Y','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','N','N','Y','N','','','','',0,0,0,0,'mysql_native_password','*61B8CBFAC6E1397C405D8AB745E3262EF58BE8EE','N','2018-04-05 16:46:01',NULL,'N'),('2a02:6b8:c09:a16:0:1358:8:4048','adiuser','Y','Y','Y','Y','Y','Y','N','N','N','N','N','Y','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','N','N','Y','N','','','','',0,0,0,0,'mysql_native_password','*61B8CBFAC6E1397C405D8AB745E3262EF58BE8EE','N','2018-04-05 16:46:01',NULL,'N'),('2a02:6b8:c08:4d99:0:1358:8:2992','adiuser','Y','Y','Y','Y','Y','Y','N','N','N','N','N','Y','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','N','N','Y','N','','','','',0,0,0,0,'mysql_native_password','*61B8CBFAC6E1397C405D8AB745E3262EF58BE8EE','N','2018-04-05 16:46:01',NULL,'N'),('2a02:6b8:c0b:2698:0:1358:13:6528','direct-sql','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','','','','',0,0,0,0,'mysql_native_password','*685AF2845F8E6355AA269D85978B8E7A53E8C1C3','N','2018-04-05 16:46:04',NULL,'N'),('2a02:6b8:c08:2504:0:1358:13:6032','direct-sql','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','','','','',0,0,0,0,'mysql_native_password','*685AF2845F8E6355AA269D85978B8E7A53E8C1C3','N','2018-04-05 16:46:04',NULL,'N'),('2a02:6b8:c09:a16:0:1358:8:4048','direct-sql','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','','','','',0,0,0,0,'mysql_native_password','*685AF2845F8E6355AA269D85978B8E7A53E8C1C3','N','2018-04-05 16:46:04',NULL,'N'),('2a02:6b8:c08:4d99:0:1358:8:2992','direct-sql','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','','','','',0,0,0,0,'mysql_native_password','*685AF2845F8E6355AA269D85978B8E7A53E8C1C3','N','2018-04-05 16:46:04',NULL,'N'),('%','direct-test','Y','Y','Y','Y','Y','Y','N','N','N','N','N','Y','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','N','N','Y','N','','','','',0,0,0,0,'mysql_native_password','*347676E810584DCD2C05604904D4AD4F3D8892A7','N','2019-04-02 19:17:50',NULL,'N'),('2a02:6b8:b011:8000:b179:7d07:2801:8945','autotester','Y','Y','Y','Y','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','','','','',0,0,0,0,'mysql_native_password','*F9A8E96790775D196D12F53BCC88B8048FF62ED5','N','2018-04-05 16:46:00',NULL,'N'),('2a02:6b8:b011:8000:b179:7d07:2801:8945','adiuser','Y','Y','Y','Y','Y','Y','N','N','N','N','N','Y','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','N','N','Y','N','','','','',0,0,0,0,'mysql_native_password','*61B8CBFAC6E1397C405D8AB745E3262EF58BE8EE','N','2018-04-05 16:46:02',NULL,'N'),('2a02:6b8:b011:8000:b179:7d07:2801:8945','direct-sql','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','','','','',0,0,0,0,'mysql_native_password','*685AF2845F8E6355AA269D85978B8E7A53E8C1C3','N','2018-04-05 16:46:04',NULL,'N'),('%','autotester','Y','Y','Y','Y','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','','','','',0,0,0,0,'mysql_native_password','*F9A8E96790775D196D12F53BCC88B8048FF62ED5','N','2019-04-02 19:17:50',NULL,'N'),('%','direct-sql','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','N','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','','','','',0,0,0,0,'mysql_native_password','*685AF2845F8E6355AA269D85978B8E7A53E8C1C3','N','2019-04-02 19:17:50',NULL,'N');
/*!40000 ALTER TABLE `user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `general_log`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `general_log` (
  `event_time` timestamp(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6) ON UPDATE CURRENT_TIMESTAMP(6),
  `user_host` mediumtext NOT NULL,
  `thread_id` bigint(21) unsigned NOT NULL,
  `server_id` int(10) unsigned NOT NULL,
  `command_type` varchar(64) NOT NULL,
  `argument` mediumblob NOT NULL
) ENGINE=CSV DEFAULT CHARSET=utf8 COMMENT='General log';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `slow_log`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE IF NOT EXISTS `slow_log` (
  `start_time` timestamp(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6) ON UPDATE CURRENT_TIMESTAMP(6),
  `user_host` mediumtext NOT NULL,
  `query_time` time(6) NOT NULL,
  `lock_time` time(6) NOT NULL,
  `rows_sent` int(11) NOT NULL,
  `rows_examined` int(11) NOT NULL,
  `db` varchar(512) NOT NULL,
  `last_insert_id` int(11) NOT NULL,
  `insert_id` int(11) NOT NULL,
  `server_id` int(10) unsigned NOT NULL,
  `sql_text` mediumblob NOT NULL,
  `thread_id` bigint(21) unsigned NOT NULL
) ENGINE=CSV DEFAULT CHARSET=utf8 COMMENT='Slow log';
/*!40101 SET character_set_client = @saved_cs_client */;
/*!50112 SET @disable_bulk_load = IF (@is_rocksdb_supported, 'SET SESSION rocksdb_bulk_load = @old_rocksdb_bulk_load', 'SET @dummy_rocksdb_bulk_load = 0') */;
/*!50112 PREPARE s FROM @disable_bulk_load */;
/*!50112 EXECUTE s */;
/*!50112 DEALLOCATE PREPARE s */;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2019-10-01 15:22:03
