#!/usr/bin/python
# -*- coding: utf-8 -*-

import datetime
import re
import subprocess
import sys
import json
import yaml
import argparse

DATES_COUNT = 7
NUMBER_BACKUPS = 3

USAGE = '''
%(prog)s -- утилита для получения информации об имеющихся бэкапах (за какие даты имеются).
Cмотрит, за какие даты есть бэкапы в MDS и для последних {keep_dates_count} дат выводит 
результат в виде таблицы.

    %(prog)s

Для корректной работы нужен доступ до MDS-S3/direct(dpkg: yandex-du-mysql-backup-mds).
'''.format(keep_dates_count=DATES_COUNT)

def aggregate_complects(hosts, dates, number_backups):
    ''' Получает словарь хостов {hosts}, множетво всех дат {sets}, количество бекапов для объединения {number_backups}.
        Например:
            hosts = { 'ppcdata1': set(['20180101', '20180102', '20180103']),
                       ...
                      'ppcdata2': set(['20180101', '20180102', '20180104']) }
            dates =  set(['20180101', '20180102', '20180103', '20180104'])
            number_backups = 3
        На выхоже отдает два словаря: {complects} набор-имена баз, datasets набор-даты бекапов.
            complects = { 0: set(['ppcdata1', 'ppcdata2', ]),
                          ...
                          6: set(['ppcdata2']) }
            datasets = { 0: [ '20180101', '20180102', '20180103' ],
                          ...
                         6: [ '20171222', '20171223', '20171224' ] }
    '''
    complects = dict()
    datasets = dict()
    date_instance = dict()
    full_dates = [ int(i) for i in dates ]
    full_dates.reverse()

    for instance in hosts:
        hdates = list(hosts[instance])
        [date_instance.setdefault(date, set()) for date in dates]
        [date_instance[date].add(instance) for date in dates if hdates.count(date)]

    for i, date in enumerate(full_dates):
        number = i
        complects.setdefault(number, set())
        possible_dates = [ str(int(date)-j) for j in range(number_backups) ]
        if opts.debug: print number, ":\t", possible_dates
        datasets[number] = possible_dates
        for k in possible_dates:
            complects[number].update(date_instance.get(k, set()))
        if opts.debug: print complects
        if opts.debug: print date_instance
    return complects, datasets

def print_different_complects(hosts, complects, datasets):
    ''' Получает словарь хостов {hosts}, набор комплектов {complects}, набор датасетов {datasets}.
        При opts.verbose=True печает список недостающих бекапов в каждом из комплектов.
        При opts.debug=True выводит резулитат в формате monrun.
    '''
    empty_complects = dict()
    instances = set(hosts.keys())
    full_complects = set()
    for d in complects:
        delta = instances - complects[d]
        if delta:
            empty_complects[d] = list(delta)
        else:
            full_complects.add(d)
    if opts.monrun:
        if len(empty_complects) == len(complects):
            print "2; not found full complect backups. Use {0} -v".format(sys.argv[0])
        else:
            print "0; found full complect backups"
    else:
        if empty_complects:
            print "we are dont have full complects {0}/{1}:".format(len(empty_complects), len(complects))
            for e in empty_complects:
                print "complect {0} for dates {1} not full. Missing: {2}".format(e, datasets[e], empty_complects[e])
            print "we are have full complects:"
            for e in full_complects:
                print "complect {0} for dates {1} are full.".format(e, datasets[e])
        else:
            print "[print_different_complects] found full complect backups. :)"
    return

def print_different_table(dbs, dates):
    print ' '*db_field_width + ' '.join(dates)
    for db in dbs:
        sys.stdout.write(db.ljust(db_field_width))
        for d in dates:
            if d in h[db]:
               sys.stdout.write('    x    ')
            else:
               sys.stdout.write('         ')
        sys.stdout.write('\n')
    return


if __name__ == '__main__':
    parser = argparse.ArgumentParser(usage=USAGE)
    parser.add_argument('-v', action='store_true', dest='verbose', help='вывести резулитат по отсутствующим датасетам')
    parser.add_argument('-d', action='store_true', dest='debug', help='debug режим')
    parser.add_argument('-m', action='store_true', dest='monrun', help='вывести результат в формате monrun')

    opts = parser.parse_args()

    if opts.debug: print opts
    dates = set()

    h = {}
    p = subprocess.Popen(['/usr/bin/mysql-backup-mds', 'list', '-j'], stdout=subprocess.PIPE)
    jdata = json.loads(p.stdout.read())
    for db in jdata:
        dates = set([ i.get("date") for i in jdata.get(db) ])
        h[db] = dates

    # интересуемся только данными за последнюю недели или раньше, если за последнюю неделю не нашлось
    dates = sorted(set().union(*h.values()))[-DATES_COUNT:]
    db_field_width = max([len(db) for db in h])+1

    complects, datasets = aggregate_complects(h, dates, NUMBER_BACKUPS)
    if opts.monrun or opts.verbose:
        print_different_complects(h, complects, datasets)
    else:
        print_different_table(h.keys(), dates)
